# Computer Vision

- 3D CNN-based classification using sMRI and MD-DTI images for Alzheimer disease studies. [`arxiv`](https://arxiv.org/abs/1801.05968)
- A Closed-form Solution to Photorealistic Image Stylization. [`arxiv`](https://arxiv.org/abs/1802.06474) [`code`](https://github.com/NVIDIA/FastPhotoStyle) :star:
- A Convolutional Autoencoder Approach to Learn Volumetric Shape Representations for Brain Structures. [`arxiv`](https://arxiv.org/abs/1810.07746)
- Adversarial Learning for Semi-Supervised Semantic Segmentation. [`arxiv`](https://arxiv.org/abs/1802.07934) [`pytorch`](https://github.com/hfslyc/AdvSemiSeg)
- Adversarial Training of Variational Auto-encoders for High Fidelity Image Generation. [`arxiv`](https://arxiv.org/abs/1804.10323)
- Attention-Aware Compositional Network for Person Re-identification. [`arxiv`](https://arxiv.org/abs/1805.03344)
- Attention U-Net: Learning Where to Look for the Pancreas. [`arxiv`](https://arxiv.org/abs/1804.03999) [`code`](https://github.com/ozan-oktay/Attention-Gated-Networks)
- AutoAugment: Learning Augmentation Policies from Data. [`arxiv`](https://arxiv.org/abs/1805.09501)
- Avatar-Net: Multi-scale Zero-shot Style Transfer by Feature Decoration. [`arxiv`](https://arxiv.org/abs/1805.03857)
- Choose Your Neuron: Incorporating Domain Knowledge through Neuron-Importance. [`arxiv`](https://arxiv.org/abs/1808.02861)
- Compressed Sensing with Deep Image Prior and Learned Regularization. [`arxiv`](https://arxiv.org/abs/1806.06438)
- Compressed Video Action Recognition. [`arxiv`](https://arxiv.org/abs/1712.00636) [`code`](https://github.com/chaoyuaw/pytorch-coviar) :star:
- Deep Autoencoding Models for Unsupervised Anomaly Segmentation in Brain MR Images. [`arxiv`](https://arxiv.org/abs/1804.04488)
- Deep Clustering for Unsupervised Learning of Visual Features. [`arxiv`](https://arxiv.org/abs/1807.05520)
- Deep Convolutional Neural Networks for Breast Cancer Histology Image Analysis. [`arxiv`](https://arxiv.org/abs/1802.00752) [`code`](https://github.com/alexander-rakhlin/ICIAR2018)
- DeepGlobe 2018: A Challenge to Parse the Earth through Satellite Images. [`arxiv`](https://arxiv.org/abs/1805.06561)
- Deep Lip Reading: a comparison of models and an online application. [`arxiv`](https://arxiv.org/abs/1806.06053)
- Deep Pose Consensus Networks. [`arxiv`](https://arxiv.org/abs/1803.08190) 
- Depth CNNs for RGB-D scene recognition: learning from scratch better than transferring from RGB-CNNs. [`arxiv`](https://arxiv.org/abs/1801.06797) [`code`](https://github.com/songxinhang/D-CNN)
- Detecting Visual Relationships Using Box Attention. [`arxiv`](https://arxiv.org/abs/1807.02136)
- Detection and Segmentation of Manufacturing Defects with Convolutional Neural Networks and Transfer Learning. [`arxiv`](https://arxiv.org/abs/1808.02518)
- DynSLAM: Tracking, Mapping and Inpainting in Dynamic Scenes. [`arxiv`](https://arxiv.org/abs/1806.05620)
- Encoding, Fast and Slow: Low-Latency Video Processing Using Thousands of Tiny Threads. [`arxiv`](https://www.usenix.org/system/files/conference/nsdi17/nsdi17-fouladi.pdf)
- End-to-End Saliency Mapping via Probability Distribution Prediction. [`arxiv`](https://arxiv.org/abs/1804.01793)
- Fast Semantic Segmentation on Video Using Motion Vector-Based Feature Interpolation. [`arxiv`](https://arxiv.org/abs/1803.07742)
- From Selective Deep Convolutional Features to Compact Binary Representations for Image Retrieval. [`arxiv`](https://arxiv.org/abs/1802.02899) [`code`](https://github.com/hnanhtuan/selectiveConvFeature)
- Geometrical Stem Detection from Image Data for Precision Agriculture. [`arxiv`](https://arxiv.org/abs/1812.05415) [`code`](https://github.com/PRBonn/geometrical_stem_detection)
- Harmonious Attention Network for Person Re-Identification. [`arxiv`](https://arxiv.org/abs/1802.08122)
- IGCV2: Interleaved Structured Sparse Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1804.06202)
- Image Inpainting for Irregular Holes Using Partial Convolutions. [`arxiv`](https://arxiv.org/abs/1804.07723)
- Image-to-image translation for cross-domain disentanglement. [`arxiv`](https://arxiv.org/abs/1805.09730)
- Image Transformer. [`arxiv`](https://arxiv.org/abs/1802.05751) :star:
- Infrared and Visible Image Fusion using a Deep Learning Framework. [`arxiv`](https://arxiv.org/abs/1804.06992) [`code`](https://github.com/exceptionLi/imagefusion_deeplearning)
- Instance-level Human Parsing via Part Grouping Network. [`arxiv`](https://arxiv.org/abs/1808.00157) 
- LF-Net: Learning Local Features from Images. [`arxiv`](https://arxiv.org/abs/1805.09662)
- Low-Shot Learning from Imaginary Data. [`arxiv`](https://arxiv.org/abs/1801.05401)
- Mask TextSpotter: An End-to-End Trainable Neural Network for Spotting Text with Arbitrary Shapes. [`arxiv`](https://arxiv.org/abs/1807.02242)
- MegaDepth: Learning Single-View Depth Prediction from Internet Photos. [`arxiv`](https://arxiv.org/abs/1804.00607) [`code`](https://github.com/lixx2938/MegaDepth)
- ModaNet: A Large-Scale Street Fashion Dataset with Polygon Annotations. [`arxiv`](https://arxiv.org/abs/1807.01394)
- Multimodal Unsupervised Image-to-Image Translation. [`arxiv`](https://arxiv.org/abs/1804.04732) [`code`](https://github.com/nvlabs/MUNIT) :star:
- Multitask Learning on Graph Neural Networks - Learning Multiple Graph Centrality Measures with a Unified Network. [`arxiv`](https://arxiv.org/abs/1809.07695)
- Multi-view Consistency as Supervisory Signal for Learning Shape and Pose Prediction. [`arxiv`](https://arxiv.org/abs/1801.03910) [`code`](https://github.com//shubhtuls/mvcSnP)
- PCN: Point Completion Network. [`arxiv`](https://arxiv.org/abs/1808.00671) [`code`](https://github.com/TonythePlaneswalker/pcn)
- Pixel-wise Attentional Gating for Parsimonious Pixel Labeling. [`arxiv`](https://arxiv.org/abs/1805.01556) [`code`](https://github.com/aimerykong/Pixel-Attentional-Gating)
- PlaneNet: Piece-wise Planar Reconstruction from a Single RGB Image. [`pdf`](https://eng.ucmerced.edu/people/jyang44/papers/cvpr2018_PlaneNet_camera_ready.pdf) [`code`](https://github.com/art-programmer/PlaneNet)
- PointNetVLAD: Deep Point Cloud Based Retrieval for Large-Scale Place Recognition. [`arxiv`](https://arxiv.org/abs/1804.03492) [`code`](https://github.com/mikacuy/pointnetvlad)
- Quantizing deep convolutional networks for efficient inference: A whitepaper. [`arxiv`](https://arxiv.org/abs/1806.08342)
- Recurrent Squeeze-and-Excitation Context Aggregation Net for Single Image Deraining. [`arxiv`](https://arxiv.org/abs/1807.05698) [`pytorch`](https://github.com/XiaLiPKU/RESCAN)
- ShuffleNet V2: Practical Guidelines for Efficient CNN Architecture Design. [`arxiv`](https://arxiv.org/abs/1807.11164) [`code`](https://github.com/Randl/ShuffleNetV2-pytorch)
- Simple Baselines for Human Pose Estimation and Tracking. [`arxiv`](https://arxiv.org/abs/1804.06208)
- Spatial Temporal Graph Convolutional Networks for Skeleton-Based Action Recognition. [`arxiv`](https://arxiv.org/abs/1801.07455) [`code`](https://github.com/yysijie/st-gcn)
- Stacked U-Nets: A No-Frills Approach to Natural Image Segmentation. [`arxiv`](https://arxiv.org/abs/1804.10343) [`code`](https://github.com/shahsohil/sunets)
- Text to Image Synthesis Using Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1805.00676)
- Total Capture: A 3D Deformation Model for Tracking Faces, Hands, and Bodies. [`pdf`](http://openaccess.thecvf.com/content_cvpr_2018/papers/Joo_Total_Capture_A_CVPR_2018_paper.pdf)
- Towards Image Understanding from Deep Compression without Decoding. [`arxiv`](https://arxiv.org/abs/1803.06131)
- Towards Semantic SLAM: Points, Planes and Objects. [`arxiv`](https://arxiv.org/abs/1804.09111)
- Trajectory Factory: Tracklet Cleaving and Re-connection by Deep Siamese Bi-GRU for Multiple Object Tracking. [`arxiv`](https://arxiv.org/abs/1804.04555)
- Unsupervised Discovery of Object Landmarks as Structural Representations. [`arxiv`](https://arxiv.org/abs/1804.04412)
- Unsupervised Training for 3D Morphable Model Regression. [`arxiv`](https://arxiv.org/abs/1806.06098)
- Video Person Re-identification by Temporal Residual Learning. [`arxiv`](https://arxiv.org/abs/1802.07918)

## Face Recognition

- Additive Margin Softmax for Face Verification. [`arxiv`](https://arxiv.org/abs/1801.05599) [`code`](https://github.com/happynear/AMSoftmax) :star:
- Anchor Cascade for Efficient Face Detection. [`arxiv`](https://arxiv.org/abs/1805.03363)
- Detecting and counting tiny faces. [`arxiv`](https://arxiv.org/abs/1801.06504) [`code`](https://github.com/alexattia/ExtendedTinyFaces)
- Face Recognition: From Traditional to Deep Learning Methods. [`arxiv`](https://arxiv.org/abs/1811.00116)
- RED-Net: A Recurrent Encoder-Decoder Network for Video-based Face Alignment. [`arxiv`](https://arxiv.org/abs/1801.06066) 
- SSR-Net: A Compact Soft Stagewise Regression Network for Age Estimation. [`pdf`](https://github.com/shamangary/SSR-Net/blob/master/ijcai18_ssrnet_pdfa_2b.pdf) [`code`](https://github.com/shamangary/SSR-Net)
- Survey of Face Detection on Low-quality Images. [`arxiv`](https://arxiv.org/abs/1804.07362)

## Image Classifier

- Bag of Tricks for Image Classification with Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1812.01187)
- Combined convolutional and recurrent neural networks for hierarchical classification of images. [`arxiv`](https://arxiv.org/abs/1809.09574)
- Global Weighted Average Pooling Bridges Pixel-level Localization and Image-level Classification. [`arxiv`](https://arxiv.org/abs/1809.08264)
- Regularized Evolution for Image Classifier Architecture Search. [`arxiv`](https://arxiv.org/abs/1802.01548)
- Rethinking Feature Distribution for Loss Functions in Image Classification. [`arxiv`](https://arxiv.org/abs/1803.02988) [`code`](https://github.com/WeitaoVan/L-GM-loss)

## Image Generate

- Enhancing Underwater Imagery using Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1801.04011) [`code`](https://github.com//cameronfabbri/Underwater-Color-Correction)
- ST-GAN: Spatial Transformer Generative Adversarial Networks for Image Compositing. [`arxiv`](https://arxiv.org/abs/1803.01837) [`code`](https://github.com/chenhsuanlin/spatial-transformer-GAN)


## Object Detection

- A Generalized Active Learning Approach for Unsupervised Anomaly Detection. [`arxiv`](https://arxiv.org/abs/1805.09411)
- CornerNet: Detecting Objects as Paired Keypoints. [`arxiv`](https://arxiv.org/abs/1808.01244) [`code`](https://github.com/umich-vl/CornerNet)
- Cross-Domain Weakly-Supervised Object Detection through Progressive Domain Adaptation. [`arxiv`](https://arxiv.org/abs/1803.11365) [`code`](https://github.com/naoto0804/cross-domain-detection)
- CubeSLAM: Monocular 3D Object Detection and SLAM without Prior Models. [`arxiv`](https://arxiv.org/abs/1806.00557)
- Deep Learning Approach for Very Similar Objects Recognition Application on Chihuahua and Muffin Problem. [`arxiv`](https://arxiv.org/abs/1801.09573)
- Deep Learning for Generic Object Detection: A Survey.  [`arxiv`](https://arxiv.org/abs/1809.02165)
- Dense Object Nets: Learning Dense Visual Object Descriptors By and For Robotic Manipulation. [`arxiv`](https://arxiv.org/abs/1806.08756) [`code`](https://github.com/RobotLocomotion/pytorch-dense-correspondence)
- Detect-and-Track: Efficient Pose Estimation in Videos. [`arxiv`](https://arxiv.org/abs/1712.09184) [`code`](https://github.com/facebookresearch/DetectAndTrack) :star:
- DetNet: A Backbone network for Object Detection. [`arxiv`](https://arxiv.org/abs/1804.06215)
- Domain Adaptive Faster R-CNN for Object Detection in the Wild. [`arxiv`](https://arxiv.org/abs/1803.03243) [`code`](https://github.com/yuhuayc/da-faster-rcnn)
- Faster RER-CNN: application to the detection of vehicles in aerial images. [`arxiv`](https://arxiv.org/abs/1809.07628)
- Faster Training of Mask R-CNN by Focusing on Instance Boundaries. [`arxiv`](https://arxiv.org/abs/1809.07069)
- GANomaly: Semi-Supervised Anomaly Detection via Adversarial Training. [`arxiv`](https://arxiv.org/abs/1805.06725) [`code`](https://github.com/samet-akcay/ganomaly)
- Multi-Resolution 3D Convolutional Neural Networks for Object Recognition. [`arxiv`](https://arxiv.org/abs/1805.12254)
- Object Detection for Comics using Manga109 Annotations. [`arxiv`](http://xxx.itp.ac.cn/abs/1803.08670)
- Object Detection from Scratch with Deep Supervision. [`arxiv`](https://arxiv.org/abs/1809.09294)
- Object Detection in Satellite Imagery using 2-Step Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1808.02996)
- Optimizing Video Object Detection via a Scale-Time Lattice. [`url`](http://mmlab.ie.cuhk.edu.hk/projects/ST-Lattice/) [`code`](https://github.com/hellock/scale-time-lattice)
- Pseudo Mask Augmented Object Detection. [`arxiv`](https://arxiv.org/abs/1803.05858)
- Probabilistic Model of Object Detection Based on Convolutional Neural Network.  [`arxiv`](https://arxiv.org/abs/1808.08272)
- Recent Advances in Object Detection in the Age of Deep Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1809.03193)
- Relation Networks for Object Detection. [`arxiv`](https://arxiv.org/abs/1711.11575) [`code`](https://github.com/msracver/Relation-Networks-for-Object-Detection)
- Road Damage Detection Using Deep Neural Networks with Images Captured Through a Smartphone. [`arxiv`](https://arxiv.org/abs/1801.09454) [`code`](https://github.com/sekilab/RoadDamageDetector/)
- Single-Shot Bidirectional Pyramid Networks for High-Quality Object Detection. [`arxiv`](https://arxiv.org/abs/1803.08208)
- SNIPER: Efficient Multi-Scale Training. [`arxiv`](https://arxiv.org/abs/1805.09300) [`code`](https://github.com/mahyarnajibi/SNIPER)
- Subpixel-Precise Tracking of Rigid Objects in Real-time. [`arxiv`](https://arxiv.org/abs/1807.01952)
- YOLO3D: End-to-end real-time 3D Oriented Object Bounding Box Detection from LiDAR Point Cloud. [`arxiv`](https://arxiv.org/abs/1808.02350)
- You Only Look Twice: Rapid Multi-Scale Object Detection In Satellite Imagery. [`arxiv`](https://arxiv.org/abs/1805.09512) [`code`](https://github.com/CosmiQ/yolt)
- Zero-Shot Object Detection by Hybrid Region Embedding. [`arxiv`](https://arxiv.org/abs/1805.06157) 
- Zero-Shot Object Detection: Learning to Simultaneously Recognize and Localize Novel Concepts. [`arxiv`](https://arxiv.org/abs/1803.06049)

## Object Segmentation

- An application of cascaded 3D fully convolutional networks for medical image segmentation. [`arxiv`](https://arxiv.org/abs/1803.05431) [`code`](https://github.com/holgerroth/3Dunet_abdomen_cascade)
- An Iterative Boundary Random Walks Algorithm for Interactive Image Segmentation. [`arxiv`](https://arxiv.org/abs/1808.03002)
- A Probabilistic U-Net for Segmentation of Ambiguous Images. [`arxiv`](https://arxiv.org/abs/1806.05034)
- A two-stage 3D Unet framework for multi-class segmentation on full resolution image. [`arxiv`](https://arxiv.org/abs/1804.04341)
- ClusterNet: Instance Segmentation in RGB-D Images. [`arxiv`](https://arxiv.org/abs/1807.08894)
- Dark Model Adaptation: Semantic Image Segmentation from Daytime to Nighttime. [`arxiv`](https://arxiv.org/abs/1810.02575)
- Deep Learning for Semantic Segmentation on Minimal Hardware. [`arxiv`](https://arxiv.org/abs/1807.05597)
- Domain Adaptation for Semantic Segmentation via Class-Balanced Self-Training. [`arxiv`](https://arxiv.org/abs/1810.07911) [`code`](https://github.com/yzou2/cbst)
- Fast and Accurate Online Video Object Segmentation via Tracking Parts. [`arxiv`](https://arxiv.org/abs/1806.02323) [`code`](https://github.com/JingchunCheng/FAVOS)
- Learning to Segment Every Thing. [`pdf`](http://openaccess.thecvf.com/content_cvpr_2018/papers/Hu_Learning_to_Segment_CVPR_2018_paper.pdf) [`code`](https://github.com/skrish13/PyTorch-mask-x-rcnn) :star:
- Learning to Segment Medical Images with Scribble-Supervision Alone. [`arxiv`](https://arxiv.org/abs/1807.04668)
- MaskFusion: Real-Time Recognition, Tracking and Reconstruction of Multiple Moving Objects. [`arxiv`](https://arxiv.org/abs/1804.09194)
- NeuroNet: Fast and Robust Reproduction of Multiple Brain Image Segmentation Pipelines. [`arxiv`](https://arxiv.org/abs/1806.04224)
- Panoptic Segmentation with a Joint Semantic and Instance Segmentation Network. [`arxiv`](https://arxiv.org/abs/1809.02110)
- Pathology Segmentation using Distributional Differences to Images of Healthy Origin. [`arxiv`](https://arxiv.org/abs/1805.10344)
- PersonLab: Person Pose Estimation and Instance Segmentation with a Bottom-Up, Part-Based, Geometric Embedding Model. [`arxiv`](https://arxiv.org/abs/1803.08225)
- Pixel Level Data Augmentation for Semantic Image Segmentation using Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1811.00174)
- PointSIFT: A SIFT-like Network Module for 3D Point Cloud Semantic Segmentation. [`arxiv`](https://arxiv.org/abs/1807.00652) [`code`](https://github.com/MVIG-SJTU/pointSIFT)
- Pyramid Attention Network for Semantic Segmentation. [`arxiv`](https://arxiv.org/abs/1805.10180)
- Semantic Binary Segmentation using Convolutional Networks without Decoders. [`arxiv`](https://arxiv.org/abs/1805.00138)
- Y-Net: Joint Segmentation and Classification for Diagnosis of Breast Biopsy Images. [`arxiv`](https://arxiv.org/abs/1806.01313)

### OCR

- Fooling OCR Systems with Adversarial Text Images. [`arxiv`](https://arxiv.org/abs/1802.05385)
- Open Set Chinese Character Recognition using Multi-typed Attributes. [`arxiv`](https://arxiv.org/abs/1808.08993)
