## Nature language process

### deep learning

- A Comparative Study of Word Embeddings for Reading Comprehension. [`arxiv`](https://arxiv.org/abs/1703.00993)
- Advances in Pre-Training Distributed Word Representations. [`arxiv`](https://arxiv.org/abs/1712.09405)
- An Automated Text Categorization Framework based on Hyperparameter Optimization. [`arxiv`](https://arxiv.org/abs/1704.01975) [`code`](https://github.com/INGEOTEC/microTC)
- An Embedded Deep Learning based Word Prediction. [`arxiv`](https://arxiv.org/abs/1707.01662) [`code`](https://github.com/meinwerk/WordPrediction)
- An End-to-End Architecture for Keyword Spotting and Voice Activity Detection. [`arxiv`](https://arxiv.org/abs/1611.09405) [`code`](https://github.com/mindorii/kws)
- A Neural Framework for Generalized Topic Models. [`arxiv`](https://arxiv.org/abs/1705.09296) [`code`](https://github.com/dallascard/neural_topic_models)
- An online sequence-to-sequence model for noisy speech recognition. [`arxiv`](https://arxiv.org/abs/1706.06428) :star:
- A Read-Write Memory Network for Movie Story Understanding. [`arxiv`](https://arxiv.org/abs/1709.09345) [`code`](https://github.com/seilna/RWMN)
- Are You Talking to Me? Reasoned Visual Dialog Generation through Adversarial Learning. [`arxiv`](https://arxiv.org/abs/1711.07613)
- A Review on Deep Learning Techniques Applied to Semantic Segmentation. [`arxiv`](https://arxiv.org/abs/1704.06857)
- A Structured Self-attentive Sentence Embedding. [`arxiv`](https://arxiv.org/abs/1703.03130) [`code`](https://github.com/kaushalshetty/Structured-Self-Attention)
- A Tidy Data Model for Natural Language Processing using cleanNLP. [`arXiv`](https://arxiv.org/abs/1703.09570)
- Attention-based Mixture Density Recurrent Networks for History-based Recommendation. [`arxiv`](https://arxiv.org/abs/1709.07545)
- Attention-based Natural Language Person Retrieval. [`arxiv`](https://arxiv.org/abs/1705.08923)
- Autoencoding Variational Inference For Topic Models. [`arxiv`](https://arxiv.org/abs/1703.01488) [`tensorflow`](https://github.com/akashgit/autoencoding_vi_for_topic_models) :star:
- Automated Crowdturfing Attacks and Defenses in Online Review Systems. [`arxiv`](https://arxiv.org/abs/1708.08151)
- Automatic Rule Extraction from Long Short Term Memory Networks. [`arxiv`](https://arxiv.org/abs/1702.02540)
- A Wavenet for Speech Denoising. [`arxiv`](https://arxiv.org/abs/1706.07162) [`code`](https://github.com/drethage/speech-denoising-wavenet)
- Big Picture Machine Learning: Classifying Text with Neural Networks and TensorFlow. [`url`](https://medium.freecodecamp.com/big-picture-machine-learning-classifying-text-with-neural-networks-and-tensorflow-d94036ac2274) [`tensorflow`](https://github.com/dmesquita/understanding_tensorflow_nn)
- Billion-scale similarity search with GPUs. [`arXiv`](https://arxiv.org/abs/1702.08734) [`code`](https://github.com/facebookresearch/faiss) :star:
- Collaborative Recurrent Neural Networks for Dynamic Recommender Systems. [`pdf`](https://infoscience.epfl.ch/record/222477/files/ko101.pdf) [`tensorflow`](https://github.com/lca4/collaborative-rnn)
- Context Aware Document Embedding. [`arXiv`](https://arxiv.org/abs/1707.01521)
- DANCin SEQ2SEQ: Fooling Text Classifiers with Adversarial Text Example Generation. [`arXiv`](https://arxiv.org/abs/1712.05419) [`code`](https://github.com//CatherineWong/dancin_seq2seq) :star:
- Deep Collaborative Autoencoder for Recommender Systems: A Unified Framework for Explicit and Implicit Feedback. [`arxiv`](https://arxiv.org/abs/1712.09043)
- Deep Multitask Learning for Semantic Dependency Parsing. [`arXiv`](https://arxiv.org/abs/1704.06855)
- Deep Recurrent Neural Network for Protein Function Prediction from Sequence. [`arxiv`](https://arxiv.org/abs/1701.08318)
- Deep Voice: Real-time Neural Text-to-Speech. [`arxiv`](https://arxiv.org/abs/1702.07825) :star:
- Depthwise Separable Convolutions for Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1706.03059)
- Detecting Oriented Text in Natural Images by Linking Segments. [`arxiv`](https://arxiv.org/abs/1703.06520) [`tensorflow`](https://github.com/dengdan/seglink) :star:
- Dialog Context Language Modeling with Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1701.04056)
- dna2vec: Consistent vector representations of variable-length k-mers. [`arxiv`](https://arxiv.org/abs/1701.06279) [`code`](https://pnpnpn.github.io/dna2vec/)
- DropoutNet: Addressing Cold Start in Recommender Systems. [`pdf`](http://www.cs.toronto.edu/~mvolkovs/nips2017_deepcf.pdf) [`tensorflow`](https://github.com//layer6ai-labs/DropoutNet)
- Efficient Natural Language Response Suggestion for Smart Reply. [`arxiv`](https://arxiv.org/abs/1705.00652)
- Efficient Vector Representation For Documents Through Corruption. [`pdf`](https://openreview.net/pdf?id=B1Igu2ogg)] [`code`](https://github.com/mchen24/iclr2017) :star:
- End-to-End MAP Training of a Hybrid HMM-DNN Model. [`arXiv`](https://arxiv.org/abs/1703.10356)
- End-to-end semantic face segmentation with conditional random fields as convolutional, recurrent and adversarial networks. [`arxiv`](https://arxiv.org/abs/1703.03305)
- End-to-End Task-Completion Neural Dialogue Systems. [`arxiv`](https://arxiv.org/abs/1703.01008) [`code`](https://github.com/MiuLab/TC-Bot)] :star:
- Explaining Recurrent Neural Network Predictions in Sentiment Analysis. [`arxiv`](https://arxiv.org/abs/1706.07206) [`code`](https://github.com/ArrasL/LRP_for_LSTM)
- Fast and Accurate Entity Recognition with Iterated Dilated Convolutions. [`arxiv`](https://arxiv.org/abs/1702.02098) [`tensorflow`](https://github.com/iesl/dilated-cnn-ner)
- Focusing Attention: Towards Accurate Text Recognition in Natural Images. [`arxiv`](https://arxiv.org/abs/1709.02054)
- Learned in Translation: Contextualized Word Vectors. [`arxiv`](https://arxiv.org/abs/1708.00107) [`code`](https://github.com/salesforce/cove)
- Letter-Based Speech Recognition with Gated ConvNets. [`arxiv`](https://arxiv.org/abs/1712.09444) [`code`](https://github.com//facebookresearch/wav2letter) :star:
- Generating Sentences by Editing Prototypes. [`arxiv`](https://arxiv.org/abs/1709.08878)
- Get To The Point: Summarization with Pointer-Generator Networks. [`arxiv`](https://arxiv.org/abs/1704.04368) [`code`](https://github.com/becxer/pointer-generator)
- [Globally Normalized Reader.](http://research.baidu.com/gnr/) [`pdf`](https://www.aclweb.org/anthology/D17-1112) [`tensorflow`](https://github.com/baidu-research/GloballyNormalizedReader) :star:
- Global Relation Embedding for Relation Extraction. [`arxiv`](https://arxiv.org/abs/1704.05958) [`code`](https://github.com/ppuliu/GloRE)
- Graph Convolutional Networks for Named Entity Recognition. [`arxiv`](https://arxiv.org/abs/1709.10053) [`code`](https://github.com/ContextScout/gcn_ner)
- Graph Embedding Techniques, Applications, and Performance: A Survey. [`arxiv`](https://arxiv.org/abs/1705.02801) [`code`](https://github.com/palash1992/GEM)
- Joint Semantic Synthesis and Morphological Analysis of the Derived Word. [`arxiv`](https://arxiv.org/abs/1701.00946)
- Jointly Learning Sentence Embeddings and Syntax with Unsupervised Tree-LSTMs. [`arxiv`](https://arxiv.org/abs/1705.09189) :star:
- Jointly Trained Sequential Labeling and Classification by Sparse Attention Neural Networks. [`arxiv`](https://arxiv.org/abs/1709.10191)
- HDLTex: Hierarchical Deep Learning for Text Classification. [`arxiv`](https://arxiv.org/abs/1709.08267) [`code`](https://github.com/kk7nc/HDLTex)
- High-Throughput and Language-Agnostic Entity Disambiguation and Linking on User Generated Data. [`arxiv`](https://arxiv.org/abs/1703.04498)
- Improving End-to-End Speech Recognition with Policy Learning. [`arxiv`](https://arxiv.org/abs/1712.07101)
- Improving speech recognition by revising gated recurrent units. [`arxiv`](https://arxiv.org/abs/1710.00641) :star:
- Label Refinement Network for Coarse-to-Fine Semantic Segmentation. [`arxiv`](https://arxiv.org/abs/1703.00551)
- LangPro: Natural Language Theorem Prover. [`arxiv`](https://arxiv.org/abs/1708.09417) [`code`](https://github.com/kovvalsky/LangPro)
- Language Generation with Recurrent Generative Adversarial Networks without Pre-training. [`arxiv`](https://arxiv.org/abs/1706.01399) [`code`](https://github.com/amirbar/rnn.wgan)
- LanideNN: Multilingual Language Identification on Character Window. [`arxiv`](https://arxiv.org/abs/1701.03338) [`code`](https://github.com/tomkocmi/LanideNN)
- Latent Intention Dialogue Models. [`arxiv`](https://arxiv.org/abs/1705.10229)
- Learning a Natural Language Interface with Neural Programmer. [`arxiv`](https://arxiv.org/abs/1611.08945) [`tensorflow`](https://github.com/tensorflow/models/tree/master/neural_programmer) :star:
- Learning Arbitrary Potentials in CRFs with Gradient Descent. [`arxiv`](https://arxiv.org/abs/1701.06805)
- Learning Convolutional Text Representations for Visual Question Answering. [`arxiv`](https://arxiv.org/abs/1705.06824) [`code`](https://github.com/divelab/vqa-text) :star:
- Learning Discourse-level Diversity for Neural Dialog Models using Conditional Variational Autoencoders. [`arxiv`](https://arxiv.org/abs/1703.10960) [`tensorflow`](https://github.com/snakeztc/NeuralDialog-CVAE)
- Learning Important Features Through Propagating Activation Differences. [`arxiv`](https://arxiv.org/abs/1704.02685) [`code`](https://github.com/kundajelab/deeplift) :star:
- Learning Structured Text Representations. [`arxiv`](https://arxiv.org/abs/1705.09207) [`code`](https://github.com//nlpyang/structured)
- Learning to Extract Semantic Structure from Documents Using Multimodal Fully Convolutional Neural Network. [`arxiv`](https://arxiv.org/abs/1706.02337)
- Learning to Generate Reviews and Discovering Sentiment. [`arxiv`](https://arxiv.org/abs/1704.01444) [`code`](https://github.com/openai/generating-reviews-discovering-sentiment)
- Learning to Reason: End-to-End Module Networks for Visual Question Answering. [`arxiv`](https://arxiv.org/abs/1704.05526) [`tensorflow`](https://github.com/ronghanghu/n2nmn)
- Learning to Skim Text. [`arxiv`](https://arxiv.org/abs/1704.06877)
- Learning with Confident Examples: Rank Pruning for Robust Classification with Noisy Labels. [`arxiv`](https://arxiv.org/abs/1705.01936) [`code`](https://github.com/cgnorthcutt/rankpruning)
- Machine Comprehension by Text-to-Text Neural Question Generation. [`arxiv`](https://arxiv.org/abs/1705.02012)
- Multi-Label Classification of Patient Notes a Case Study on ICD Code Assignment. [`arxiv`](https://arxiv.org/abs/1709.09587) [`code`](https://github.com/talbaumel/MIMIC)
- Multi-level Representations for Fine-Grained Typing of Knowledge Base Entities. [`arxiv`](https://arxiv.org/abs/1701.02025)
- Named Entity Recognition with stack residual LSTM and trainable bias decoding. [`arxiv`](https://arxiv.org/abs/1706.07598) :star:
- Natural Language Processing with Small Feed-Forward Networks. [`arxiv`](https://arxiv.org/abs/1708.00214)
- Neural Probabilistic Model for Non-projective MST Parsing. [`arxiv`](https://arxiv.org/abs/1701.00874)
- Ngram2vec: Learning Improved Word Representations from Ngram Co-occurrence Statistics. [`pdf`](http://www.aclweb.org/anthology/D17-1023) [`code`](https://github.com/zhezhaoa/ngram2vec)
- N-gram Language Modeling using Recurrent Neural Network Estimation. [`arxiv`](https://arxiv.org/abs/1703.10724) :star:
- [Non-Autoregressive Neural Machine Translation.](https://mp.weixin.qq.com/s/ckxFVBZtKYd-EBOkglnFPA) [`pdf`](https://einstein.ai/static/images/pages/research/non-autoregressive-neural-mt.pdf) [`code`](https://github.com/salesforce/nonauto-nmt)
- One Representation per Word - Does it make Sense for Composition?.  [`arxiv`](https://arxiv.org/abs/1702.06696)
- Optimal Hyperparameters for Deep LSTM-Networks for Sequence Labeling Tasks. [`arxiv`](https://arxiv.org/abs/1707.06799) [`tensorflow`](https://github.com/UKPLab/emnlp2017-bilstm-cnn-crf) :star:
- Outlier Detection for Text Data : An Extended Version. [`arxiv`](https://128.84.21.199/abs/1701.01325v1)
- Person Search with Natural Language Description. [`arxiv`](https://arxiv.org/abs/1702.05729)
- Poincaré Embeddings for Learning Hierarchical Representations. [`arxiv`](https://arxiv.org/abs/1705.08039) [`code`](https://github.com/TatsuyaShirakawa/poincare-embedding)
- Question Answering from Unstructured Text by Retrieval and Comprehension. [`arxiv`](https://arxiv.org/abs/1703.08885)
- Rationalization: A Neural Machine Translation Approach to Generating Natural Language Explanations. [`arxiv`](https://arxiv.org/abs/1702.07826) :star:
- Recurrent and Contextual Models for Visual Question Answering. [`arxiv`](https://arxiv.org/abs/1703.08120)
- Recurrent neural networks with specialized word embeddings for health-domain named-entity recognition. [`arxiv`](https://arxiv.org/abs/1706.09569) [`code`](https://github.com/ijauregiCMCRC/healthNER)
- Recurrent Recommender Networks. [`pdf`](http://alexbeutel.com/papers/rrn_wsdm2017.pdf)
- Recurrent Relational Networks for Complex Relational Reasoning. [`arxiv`](https://arxiv.org/abs/1711.08028)
- R-NET: Machine Reading Comprehension With Self-Matching Networks. [`pdf`](https://www.microsoft.com/en-us/research/wp-content/uploads/2017/05/r-net.pdf) [`code`](https://github.com/HKUST-KnowComp/R-Net)
- SearchQA: A New Q&A Dataset Augmented with Context from a Search Engine. [`arxiv`](https://arxiv.org/abs/1704.05179)  [`pytorch`](https://github.com/nyu-dl/SearchQA) :star:
- Sentiment Analysis by Joint Learning of Word Embeddings and Classifier. [`arxiv`](https://arxiv.org/abs/1708.03995)
- [Semantic Instance Segmentation via Deep Metric Learning.](http://weibo.com/ttarticle/p/show?id=2309351000224096147458277147&u=1402400261&m=4096554547383656&cu=3291965747&ru=1402400261&rm=4091597186263507) [`arxiv`](https://arxiv.org/abs/1703.10277) :star: 
- Semantic keyword spotting by learning from images and speech. [`arxiv`](https://arxiv.org/abs/1710.01949) [`code`](https://github.com/kamperh/semantic_flickraudio)
- State-of-the-art Speech Recognition With Sequence-to-Sequence Models. [`arxiv`](https://arxiv.org/abs/1712.01769)
- struc2vec: Learning Node Representations from Structural Identity. [`arxiv`](https://arxiv.org/abs/1704.03165) [`code`](https://github.com/leoribeiro/struc2vec)
- Symbolic, Distributed and Distributional Representations for Natural Language Processing in the Era of Deep Learning: a Survey. [`arxiv`](https://arxiv.org/abs/1702.00764)
- <b>[Tacotron]</b> A Fully End-to-End Text-To-Speech Synthesis Model. [`arxiv`](https://arxiv.org/abs/1703.10135) [`code`](https://github.com/google/tacotron) [`tensorflow`](https://github.com/Kyubyong/tacotron) :star:
- Text Summarization using Abstract Meaning Representation. [`arxiv`](https://arxiv.org/abs/1706.01678)
- TGIF-QA: Toward Spatio-Temporal Reasoning in Visual Question Answering. [`arxiv`](https://arxiv.org/abs/1704.04497) :star:
- The NarrativeQA Reading Comprehension Challenge. [`arxiv`](https://arxiv.org/abs/1712.07040) :star:
- Topic Compositional Neural Language Model. [`arxiv`](https://arxiv.org/abs/1712.09783)
- Topics and Label Propagation: Best of Both Worlds for Weakly Supervised Text Classification. [`arxiv`](https://arxiv.org/abs/1712.02767)
- Twitter100k: A Real-world Dataset for Weakly Supervised Cross-Media Retrieval. [`arxiv`](https://arxiv.org/abs/1703.06618) [`code`](https://github.com/huyt16/Twitter100k/)
- Understanding Convolution for Semantic Segmentation. [`arxiv`](https://arxiv.org/abs/1702.08502) [`code`](https://github.com/TuSimple/TuSimple-DUC/) :star:
- Unsupervised Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1710.11041) [`pytorch`](https://github.com/artetxem/undreamt)
- Vector Embedding of Wikipedia Concepts and Entities. [`arxiv`](https://arxiv.org/abs/1702.03470) [`code`](https://github.com/ehsansherkat/ConVec)]
- VINet: Visual-Inertial Odometry as a Sequence-to-Sequence Learning Problem. [`arxiv`](https://arxiv.org/abs/1701.08376)
- What's in a Question: Using Visual Questions as a Form of Supervision. [`arxiv`](https://arxiv.org/abs/1704.03895) [`code`](https://github.com/sidgan/whats_in_a_question)
  

### Attention and memory 

- Attentive Memory Networks: Efficient Machine Reading for Conversational Search. [`arxiv`](https://arxiv.org/abs/1712.07229)
- Bottom-Up and Top-Down Attention for Image Captioning and Visual Question Answering. [`pdf`](http://www.panderson.me/images/1707.07998-up-down.pdf) [`code`](https://github.com//peteanderson80/bottom-up-attention)
- Gated-Attention Architectures for Task-Oriented Language Grounding. [`arxiv`](https://arxiv.org/abs/1706.07230) [`pytorch`](https://github.com/devendrachaplot/DeepRL-Grounding)
- End-to-End Attention based Text-Dependent Speaker Verification. [`arxiv`](https://arxiv.org/abs/1701.00562)
- Frustratingly Short Attention Spans in Neural Language Modeling. [`arxiv`](https://arxiv.org/abs/1702.04521)
- Recurrent Neural Network-Based Sentence Encoder with Gated Attention for Natural Language Inference. [`arxiv`](https://arxiv.org/abs/1708.01353) [`code`](https://github.com/lukecq1231/enc_nli)
- Single Shot Text Detector with Regional Attention. [`arxiv`](https://arxiv.org/abs/1709.00138) [`code`](https://github.com//BestSonny/SSTD)
- Structural Attention Neural Networks for improved sentiment analysis. [`arxiv`](https://arxiv.org/abs/1701.01811)

### Generative learning

- Adversarial Generation of Natural Language. [`arXiv`](https://arxiv.org/abs/1705.10929)
- [Adversarial Learning for Neural Dialogue Generation.](https://zhuanlan.zhihu.com/p/25027693) [`arXiv`](https://arxiv.org/abs/1701.06547) [`tensorflow`](https://github.com/BigPlay/Adversarial-Learning-for-Neural-Dialogue-Generation-in-Tensorflow)
- Adversarial Multi-Criteria Learning for Chinese Word Segmentation. [`arxiv`](https://arxiv.org/abs/1704.07556) [`tensorflow`](https://github.com/FudanNLP/adversarial-multi-criteria-learning-for-CWS) :star:
- Adversarial Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1704.06933)
- Data-driven Natural Language Generation: Paving the Road to Success. [`arxiv`](https://arxiv.org/abs/1706.09433)
- Get To The Point: Summarization with Pointer-Generator Networks. [`arxiv`](https://arxiv.org/abs/1704.04368)
- Improved Variational Autoencoders for Text Modeling using Dilated Convolutions. [`arxiv`](https://arxiv.org/abs/1702.08139)
- IRGAN: A Minimax Game for Unifying Generative and Discriminative Information Retrieval Models. [`arxiv`](https://arxiv.org/abs/1705.10513) [`code`](https://github.com/geek-ai/irgan)
- KATE: K-Competitive Autoencoder for Text. [`arxiv`](https://arxiv.org/abs/1705.02033) [`code`](https://github.com/hugochan/K-Competitive-Autoencoder-for-Text)
- Long Text Generation via Adversarial Training with Leaked Information. [`arxiv`](https://arxiv.org/abs/1709.08624) [`tensorflow`](https://github.com/CR-Gjx/LeakGAN)
- Objective-Reinforced Generative Adversarial Networks (ORGAN) for Sequence Generation Models. [`arxiv`](https://arxiv.org/abs/1705.10843) [`tensorflow`](https://github.com/gablg1/ORGAN)
- Training Deep AutoEncoders for Collaborative Filtering. [`arxiv`](https://arxiv.org/abs/1708.01715) [`code`](https://github.com/okuchaiev/DeepRecoEncoders)
    
### Transfer learning

- Better Text Understanding Through Image-To-Text Transfer. [`arxiv`](https://arxiv.org/abs/1705.08386) :star:
- Domain Adaptation in Question Answering. [`arxiv`](https://arxiv.org/abs/1702.02171)
- Neural Machine Translation and Sequence-to-sequence Models: A Tutorial. [`arxiv`](https://arxiv.org/abs/1703.01619)
- Semantic Autoencoder for Zero-Shot Learning. [`arxiv`](https://arxiv.org/abs/1704.08345) [`code`](https://github.com/Elyorcv/SAE)
- Transfer Learning for Low-Resource Chinese Word Segmentation with a Novel Neural Network. [`arxiv`](https://arxiv.org/abs/1702.04488) [`code`](https://github.com/jincy520/Low-Resource-CWS-)
- Transfer Learning for Named-Entity Recognition with Neural Networks. [`arxiv`](https://arxiv.org/abs/1705.06273) [`code`](https://github.com/Franck-Dernoncourt/NeuroNER)
