## Computer vision

- 3D Object Reconstruction from a Single Depth View with Adversarial Learning. [`arxiv`](https://arxiv.org/abs/1708.07969) [`code`](https://github.com/Yang7879/3D-RecGAN)
- Abnormal Event Detection in Videos using Spatiotemporal Autoencoder. [`arxiv`](https://arxiv.org/abs/1701.01546) [`tensorflow`](https://github.com/yshean/abnormal-spatiotemporal-ae)
- Accurate Single Stage Detector Using Recurrent Rolling Convolution. [`arxiv`](https://arxiv.org/abs/1704.05776) [`code`](https://github.com/xiaohaoChen/rrc_detection)
- Active Convolution: Learning the Shape of Convolution for Image Classification. [`arxiv`](https://arxiv.org/abs/1703.09076) [`caffe`](https://github.com/jyh2986/Active-Convolution)
- A generative vision model that trains with high data efficiency and breaks text-based CAPTCHAs. [`url`](http://science.sciencemag.org/content/early/2017/10/25/science.aag2612.full) :star:
- <b>[AENet]</b> Learning Deep Audio Features for Video Analysis. [`arxiv`](https://arxiv.org/abs/1701.00599) [`code`](https://github.com/znaoya/aenet) :star:
- A Neural Representation of Sketch Drawings. [`arxiv`](https://arxiv.org/abs/1704.03477) [`pytorch`](https://github.com/alexis-jacq/Pytorch-Sketch-RNN) :star:
- A network of deep neural networks for distant speech recognition. [`arXiv`](https://arxiv.org/abs/1703.08002) :star:
- A New Convolutional Network-in-Network Structure and Its Applications in Skin Detection, Semantic Segmentation, and Artifact Reduction. [`arxiv`](https://arxiv.org/abs/1701.06190)
- Annotating Object Instances with a Polygon-RNN. [`arXiv`](https://arxiv.org/abs/1704.05548)
- Building Detection from Satellite Images on a Global Scale. [`arxiv`](https://arxiv.org/abs/1707.08952)
- Cascade R-CNN: Delving into High Quality Object Detection. [`arxiv`](https://arxiv.org/abs/1712.00726) [`code`](https://github.com/zhaoweicai/cascade-rcnn)
- Class-Weighted Convolutional Features for Visual Instance Search. [`arxiv`](https://arxiv.org/abs/1707.02581) [`code`](https://github.com/imatge-upc/retrieval-2017-cam)
- Convolutional 2D Knowledge Graph Embeddings. [`arxiv`](https://arxiv.org/abs/1707.01476) [`code`](https://github.com/TimDettmers/ConvE)
- CortexNet: a Generic Network Family for Robust Visual Temporal Representations. [`arXiv`](https://arxiv.org/abs/1706.02735) [`code`](https://github.com/atcold/pytorch-CortexNet)
- CSVideoNet: A Real-time End-to-end Learning Framework for High-frame-rate Video Compressive Sensing. [`arXiv`](https://arxiv.org/abs/1612.05203) [`caffe`](https://github.com/PSCLab-ASU/CSVideoNet)
- Cost-Effective Active Learning for Deep Image Classification. [`arxiv`](https://arxiv.org/abs/1701.03551)
- Convolutional Oriented Boundaries: From Image Segmentation to High-Level Tasks. [`arxiv`](https://arxiv.org/abs/1701.04658) [`caffe`](https://github.com/kmaninis/COB)
- DCT-like Transform for Image Compression Requires 14 Additions Only. [`arxiv`](https://arxiv.org/abs/1702.00817)
- Deep Alignment Network: A convolutional neural network for robust face alignment. [`arxiv`](https://arxiv.org/abs/1706.01789) [`code`](https://github.com/MarekKowalski/DeepAlignmentNetwork)
- Deep Bayesian Active Learning with Image Data. [`arxiv`](https://arxiv.org/abs/1703.02910) [`keras`](https://github.com/Riashat/Deep-Bayesian-Active-Learning)
- Deep Convolutional Neural Networks for Pairwise Causality. [`arxiv`](https://arxiv.org/abs/1701.00597)
- DeepFix: Fixing Common C Language Errors by Deep Learning. [`pdf`](https://www.aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14603/13921) [`code`](https://bitbucket.org/iiscseal/deepfix)
- DeepFM: A Factorization-Machine based Neural Network for CTR Prediction. [`arxiv`](https://arxiv.org/abs/1703.04247) [`tensorflow`](https://github.com/Leavingseason/OpenLearning4DeepRecsys)
- Deep Image Prior. [`pdf`](https://sites.skoltech.ru/app/data/uploads/sites/25/2017/11/deep_image_prior.pdf) [`code`](https://github.com//DmitryUlyanov/deep-image-prior) :star:
- Deep Learning Based Large-Scale Automatic Satellite Crosswalk Classification. [`arxiv`](https://arxiv.org/abs/1706.09302) [`code`](https://github.com/rodrigoberriel/satellite-crosswalk-classification)
- Deep Learning Features at Scale for Visual Place Recognition. [`arxiv`](https://arxiv.org/abs/1701.05105)
- Deep learning for predicting refractive error from retinal fundus images. [`arxiv`](https://arxiv.org/abs/1712.07798)
- Deep Learning for Tumor Classification in Imaging Mass Spectrometry. [`arxiv`](https://arxiv.org/abs/1705.01015)
- Deep Hybrid Similarity Learning for Person Re-identification. [`arxiv`](https://arxiv.org/abs/1702.04858)
- Deep Photo Style Transfer. [`arxiv`](https://arxiv.org/abs/1703.07511) [`code`](https://github.com/luanfujun/deep-photo-styletransfer) :star:
- DenseReg: Fully Convolutional Dense Shape Regression In-the-Wild. [`arxiv`](https://arxiv.org/abs/1612.01202) [`code`](https://github.com/ralpguler/DenseReg)
- Detecting Curve Text in the Wild: New Dataset and New Solution. [`arxiv`](https://arxiv.org/abs/1712.02170) [`code`](https://github.com/Yuliang-Liu/Curve-Text-Detector)
- Detecting Oriented Text in Natural Images by Linking Segments. [`arxiv`](https://arxiv.org/abs/1703.06520) [`tensorflow`](https://github.com/dengdan/seglink) :star:
- Disentangled Person Image Generation. [`arxiv`](https://arxiv.org/abs/1712.02621)
- Disentangling Motion, Foreground and Background Features in Videos. [`arxiv`](https://arxiv.org/abs/1707.04092) [`code`](https://github.com/imatge-upc/unsupervised-2017-cvprw)
- Disguised Face Identification (DFI) with Facial KeyPoints using Spatial Fusion Convolutional Network. [`arxiv`](https://arxiv.org/abs/1708.09317)
- DR2-Net: Deep Residual Reconstruction Network for Image Compressive Sensing. [`arxiv`](https://arxiv.org/abs/1702.05743)
- Dual-Path Convolutional Image-Text Embedding. [`arxiv`](https://arxiv.org/abs/1711.05535) [`code`](https://github.com//layumi/Image-Text-Embedding)
- End-to-end Recovery of Human Shape and Pose. [`arxiv`](https://arxiv.org/abs/1712.06584) [`code`](https://github.com/akanazawa/hmr)
- End-to-end Training for Whole Image Breast Cancer Diagnosis using An All Convolutional Design. [`arxiv`](https://arxiv.org/abs/1708.09427) [`code`](https://github.com/lishen/end2end-all-conv)
- End-to-end weakly-supervised semantic alignment. [`arxiv`](https://arxiv.org/abs/1712.06861) [`pytorch`](https://github.com/ignacio-rocco/weakalign)
- Estimated Depth Map Helps Image Classification. [`arxiv`](https://arxiv.org/abs/1709.07077) [`code`](https://github.com/yihui-he/Estimated-Depth-Map-Helps-Image-Classification)
- Exercise Motion Classification from Large-Scale Wearable Sensor Data Using Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1610.07031)
- Extreme 3D Face Reconstruction: Looking Past Occlusions. [`arxiv`](https://arxiv.org/abs/1712.05083) [`code`](https://github.com//anhttran/extreme_3d_faces)
- Explaining How a Deep Neural Network Trained with End-to-End Learning Steers a Car. [`arxiv`](https://arxiv.org/abs/1704.07911) :star:
- FaceBoxes: A CPU Real-time Face Detector with High Accuracy. [`arxiv`](https://arxiv.org/abs/1708.05234) [`code`](https://github.com/zeusees/FaceBoxes)
- Face Detection using Deep Learning: An Improved Faster RCNN Approach. [`arxiv`](https://arxiv.org/abs/1701.08289)
- Fader Networks: Manipulating Images by Sliding Attributes. [`arxiv`](https://arxiv.org/abs/1706.00409) [`pytorch`](https://github.com//facebookresearch/FaderNetworks) :star:
- Fast Image Processing with Fully-Convolutional Networks. [`arxiv`](https://arxiv.org/abs/1709.00643) [`code`](https://github.com/CQFIO/FastImageProcessing)
- FCN-rLSTM: Deep Spatio-Temporal Neural Networks for Vehicle Counting in City Cameras. [`arxiv`](https://arxiv.org/abs/1707.09476)
- Focal Loss for Dense Object Detection. [`arxiv`](https://arxiv.org/abs/1708.02002) [`mxnet`](https://github.com/unsky/RetinaNet) [`tensorflow`](https://github.com/ailias/Focal-Loss-implement-on-Tensorflow)
- Im2Pano3D: Extrapolating 360 Structure and Semantics Beyond the Field of View. [`arxiv`](https://arxiv.org/abs/1712.04569)
- Image-Grounded Conversations: Multimodal Context for Natural Question and Response Generation. [`arxiv`](https://arxiv.org/abs/1701.08251)
- Improving Smiling Detection with Race and Gender Diversity. [`arxiv`](https://arxiv.org/abs/1712.00193)
- Improved Texture Networks: Maximizing Quality and Diversity in Feed-forward Stylization and Texture Synthesis. [`arxiv`](https://arxiv.org/abs/1701.02096) [`code`](https://github.com/DmitryUlyanov/texture_nets)
- Joint auto-encoders: a flexible multi-task learning framework. [`arxiv`](https://arxiv.org/abs/1705.10494)
- Knowledge Concentration: Learning 100K Object Classifiers in a Single CNN. [`arxiv`](https://arxiv.org/abs/1711.07607)
- Large-Scale Evolution of Image Classifiers. [`arxiv`](https://arxiv.org/abs/1703.01041) [`pytorch`](https://github.com/neuralix/google_evolution)
- Learning a Mixture of Deep Networks for Single Image Super-Resolution. [`arxiv`](https://arxiv.org/abs/1701.00823) [`code`](http://t.cn/RM4pjZ4)]
- Learning a time-dependent master saliency map from eye-tracking data in videos. [`arxiv`](https://arxiv.org/abs/1702.00714) [`code`](http://antoinecoutrot.magix.net/public/saliency-with-lasso.html)
- Learning Deep Representations for Scene Labeling with Semantic Context Guided Supervision. [`arxiv`](https://arxiv.org/abs/1706.02493)
- Learning Deep ResNet Blocks Sequentially using Boosting Theory. [`arxiv`](https://arxiv.org/abs/1706.04964)
- Learning Feature Pyramids for Human Pose Estimation. [`arxiv`](https://arxiv.org/abs/1708.01101) [`code`](https://github.com/bearpaw/PyraNet)
- Learning to Estimate 3D Hand Pose from Single RGB Images. [`arxiv`](https://arxiv.org/abs/1705.01389) [`tensorflow`](https://github.com/lmb-freiburg/hand3d)
- Learning to Estimate Pose by Watching Videos. [`arxiv`](https://arxiv.org/abs/1704.04081) 
- Learning to Generate Posters of Scientific Papers by Probabilistic Graphical Models. [`arxiv`](https://arxiv.org/abs/1702.06228)
- [Learning to Learn from Noisy Web Videos.](https://mp.weixin.qq.com/s?__biz=MzI5NTIxNTg0OA==&mid=2247486059&idx=2&sn=8fee2ea4b1441e20be4630ff9cfc576e) [`arxiv`](https://arxiv.org/abs/1706.02884) :star:
- Learning to Segment Every Thing. [`arxiv`](https://arxiv.org/abs/1711.10370)
- Lifting from the Deep: Convolutional 3D Pose Estimation from a Single Image. [`arxiv`](https://arxiv.org/abs/1701.00295)
- Light-Head R-CNN: In Defense of Two-Stage Object Detector. [`arxiv`](https://arxiv.org/abs/1711.07264) [`code`](https://github.com/zengarden/light_head_rcnn)
- Linear Disentangled Representation Learning for Facial Actions. [`arxiv`](https://arxiv.org/abs/1701.03102) [`code`](https://github.com/eglxiang/FacialAU.)
- Loss Max-Pooling for Semantic Image Segmentation. [`arxiv`](https://arxiv.org/abs/1704.02966) [`pytorch`](https://github.com/BelBES/mpl.pytorch)
- Mask R-CNN. [`arxiv`](https://arxiv.org/abs/1703.06870) [`caffe`](https://github.com/jasjeetIM/Mask-RCNN) [`mxnet`](https://github.com/TuSimple/mx-maskrcnn) :star:
- MentorNet: Regularizing Very Deep Neural Networks on Corrupted Labels. [`arxiv`](https://arxiv.org/abs/1712.05055) :star:
- Mix-and-Match Tuning for Self-Supervised Semantic Segmentation. [`arxiv`](http://mmlab.ie.cuhk.edu.hk/projects/M&M/) [`code`](https://github.com//liuziwei7/mix-and-match)
- MobileNets: Efficient Convolutional Neural Networks for Mobile Vision Applications. [`arxiv`](https://arxiv.org/abs/1704.04861) [`pytorch`](https://github.com/marvis/pytorch-mobilenet) [`keras`](https://github.com/titu1994/MobileNetworks) [`tensorflow`](https://github.com/MG2033/MobileNet/)
- Modeling Relational Data with Graph Convolutional Networks. [`arxiv`](https://arxiv.org/abs/1703.06103) :star:
- <b>[MobileNets]</b> Efficient Convolutional Neural Networks for Mobile Vision Applications. [`arxiv`](https://arxiv.org/abs/1704.04861) [`keras`](https://github.com/rcmalli/keras-mobilenet) :star:
- MonoCap: Monocular Human Motion Capture using a CNN Coupled with a Geometric Prior. [`arxiv`](https://arxiv.org/abs/1701.02354)
- Multi-Scale Dense Networks for Resource Efficient Image Classification. [`arxiv`](https://arxiv.org/abs/1703.09844) [`code`](https://github.com//gaohuang/MSDNet)
- Negative Results in Computer Vision: A Perspective. [`arxiv`](https://arxiv.org/abs/1705.04402)
- Neural Motifs: Scene Graph Parsing with Global Context. [`arxiv`](https://arxiv.org/abs/1711.06640v2) [`code`](https://github.com/rowanz/neural-motifs)
- Object Detection Using Deep CNNs Trained on Synthetic Images. [`arxiv`](https://arxiv.org/abs/1706.06782) [`code`](https://github.com/paramrajpura/Syn2Real)
- Octree Generating Networks: Efficient Convolutional Architectures for High-resolution 3D Outputs. [`arxiv`](https://arxiv.org/abs/1703.09438) [`code`](https://github.com/lmb-freiburg/ogn)
- Optimizing Deep CNN-Based Queries over Video Streams at Scale. [`arxiv`](https://arxiv.org/abs/1703.02529) [`tensorflow`](https://github.com/stanford-futuredata/tensorflow-noscope)
- Pedestrian Alignment Network for Large-scale Person Re-identification. [`arxiv`](https://arxiv.org/abs/1707.00408) [`code`](https://github.com/layumi/Pedestrian_Alignment)
- Perceptually Optimized Image Rendering. [`arxiv`](https://arxiv.org/abs/1701.06641)
- PersonRank: Detecting Important People in Images. [`arxiv`](https://arxiv.org/abs/1711.01984)
- Photographic Image Synthesis with Cascaded Refinement Networks. [`arxiv`](https://arxiv.org/abs/1707.09405) [`tensorflow`](https://github.com/CQFIO/PhotographicImageSynthesis) :star:
- [Pixel Recursive Super Resolution.](https://mp.weixin.qq.com/s?__biz=MzI0NDU4MDg5MA==&mid=2247484778&idx=1&sn=e9fe3cc1a8b084a79e65144720c1b11d) [`arxiv`](https://arxiv.org/abs/1702.00783) :star:
- Putting a Face to the Voice: Fusing Audio and Visual Signals Across a Video to Determine Speakers. [`arxiv`](https://arxiv.org/abs/1706.00079)
- Receptive Field Block Net for Accurate and Fast Object Detection. [`arxiv`](https://arxiv.org/abs/1711.07767) [`code`](https://github.com//ruinmessi/RFBNet)
- Recurrent Scale Approximation for Object Detection in CNN. [`arxiv`](https://arxiv.org/abs/1707.09531) [`code`](https://github.com/sciencefans/RSA-for-object-detection)
- Rethinking Atrous Convolution for Semantic Image Segmentation. [`arxiv`](https://arxiv.org/abs/1706.05587)
- S^3FD: Single Shot Scale-invariant Face Detector. [`arxiv`](https://arxiv.org/abs/1708.05237) [`pytorch`](https://github.com/clcarwin/SFD_pytorch)
- SfM-Net: Learning of Structure and Motion from Video. [`arxiv`](https://arxiv.org/abs/1704.07804) :star:
- Show, Adapt and Tell: Adversarial Training of Cross-domain Image Captioner. [`arxiv`](https://arxiv.org/abs/1705.00930) [`code`](https://github.com/tsenghungchen/show-adapt-and-tell)
- Single-Shot Refinement Neural Network for Object Detection. [`arxiv`](https://arxiv.org/abs/1711.06897) [`caffe`](https://github.com//sfzhang15/RefineDet)
- SLAM with Objects using a Nonparametric Pose Graph. [`arxiv`](https://arxiv.org/abs/1704.05959) [`code`](https://github.com/BeipengMu/objectSLAM)
- Smart, Sparse Contours to Represent and Edit Images. [`arxiv`](https://arxiv.org/abs/1712.08232)
- STN-OCR: A single Neural Network for Text Detection and Text Recognition. [`arxiv`](https://arxiv.org/abs/1707.08831) [`code`](https://github.com/Bartzi/stn-ocr)
- Soft + Hardwired Attention: An LSTM Framework for Human Trajectory Prediction and Abnormal Event Detection.  [`arxiv`](https://arxiv.org/abs/1702.05552)
- Sparse-to-Dense: Depth Prediction from Sparse Depth Samples and a Single Image. [`arxiv`](https://arxiv.org/abs/1709.07492) [`code`](https://github.com/fangchangma/sparse-to-dense)
- SphereFace: Deep Hypersphere Embedding for Face Recognition. [`arxiv`](https://arxiv.org/abs/1704.08063) [`code`](https://github.com/wy1iu/sphereface)
- Spinal cord gray matter segmentation using deep dilated convolutions. [`arxiv`](https://arxiv.org/abs/1710.01269) [`code`](https://github.com/neuropoly/spinalcordtoolbox ​​​​)
- SSPP-DAN: Deep Domain Adaptation Network for Face Recognition with Single Sample Per Person.[`arxiv`](https://arxiv.org/abs/1702.04069)
- [StreetStyle: Exploring world-wide clothing styles from millions of photos.](http://streetstyle.cs.cornell.edu/) [`arxiv`](https://arxiv.org/abs/1706.01869)
- SuperPoint: Self-Supervised Interest Point Detection and Description. [`arxiv`](https://arxiv.org/abs/1712.07629) :star:
- Supervised Multilayer Sparse Coding Networks for Image Classification. [`arxiv`](https://arxiv.org/abs/1701.08349)
- SurfaceNet: An End-to-end 3D Neural Network for Multiview Stereopsis. [`arxiv`](https://arxiv.org/abs/1708.01749) [`code`](https://github.com/mjiUST/SurfaceNet)
- SwGridNet: A Deep Convolutional Neural Network based on Grid Topology for Image Classification. [`arxiv`](https://arxiv.org/abs/1709.07646) [`code`](https://github.com/takedarts/swgridnet)
- <b>[Tacotron]</b> Towards End-to-End Speech Synthesis. [`arxiv`](https://arxiv.org/abs/1703.10135) [`code`](https://github.com/google/tacotron) :star:
- Tangent: Automatic Differentiation Using Source Code Transformation in Python. [`arxiv`](https://arxiv.org/abs/1711.02712) [`code`](https://github.com//google/tangent)
- [Time-Contrastive Networks: Self-Supervised Learning from Video.](https://sermanet.github.io/imitate/) [`arxiv`](https://arxiv.org/abs/1704.06888) :star:
- Towards a Principled Integration of Multi-Camera Re-Identification and Tracking through Optimal Bayes Filters.  [`arxiv`](https://arxiv.org/abs/1705.04608)
- Toward Geometric Deep SLAM. [`arxiv`](https://arxiv.org/abs/1707.07410) :star:
- Towards perspective-free object counting with deep learning. [`pdf`](http://agamenon.tsc.uah.es/Investigacion/gram/publications/eccv2016-onoro.pdf) [`code`](https://github.com/gramuah/ccnn)
- Training object class detectors with click supervision. [`arxiv`](https://arxiv.org/abs/1704.06189)
- TransFlow: Unsupervised Motion Flow by Joint Geometric and Pixel-level Estimation. [`arxiv`](https://arxiv.org/abs/1706.00322) [`code`](https://github.com/stefanoalletto/TransFlow)
- Using Deep Learning and Google Street View to Estimate the Demographic Makeup of the US. [`arxiv`](https://arxiv.org/abs/1702.06683) :star:
- Unsupervised Image-to-Image Translation Networks. [`arxiv`](https://arxiv.org/abs/1703.00848) [`tensorflow`](https://github.com/leehomyc/Img2Img-Translation-Networks)
- Unsupervised Learning by Predicting Noise. [`arxiv`](https://arxiv.org/abs/1704.05310) :star:
- Unsupervised Learning of Long-Term Motion Dynamics for Videos. [`arxiv`](https://arxiv.org/abs/1701.01821)
- [Variational Approaches for Auto-Encoding Generative Adversarial Networks.](https://mp.weixin.qq.com/s?__biz=MzI5NTIxNTg0OA==&mid=2247486161&idx=2&sn=e11c6bb9839a1fde85e96d26ac2d0b75) [`arxiv`](https://arxiv.org/abs/1706.04987) :star:
- Video-based Person Re-identification with Accumulative Motion Context. [`arxiv`](https://arxiv.org/abs/1701.00193)
- Video Frame Interpolation via Adaptive Separable Convolution. [`pdf`](http://web.cecs.pdx.edu/~fliu/papers/iccv2017-interp.pdf) [`pytorch`](https://github.com/sniklaus/pytorch-sepconv)
- Video Frame Synthesis using Deep Voxel Flow. [`arxiv`](https://arxiv.org/abs/1702.02463) [`code`](https://github.com/liuziwei7/voxel-flow)
- ViP-CNN: A Visual Phrase Reasoning Convolutional Neural Network for Visual Relationship Detection. [`arxiv`](https://arxiv.org/abs/1702.07191)
- Visualizing LSTM decisions. [`arxiv`](https://arxiv.org/abs/1705.08153)
- Visual Attribute Transfer through Deep Image Analogy. [`arxiv`](https://arxiv.org/abs/1705.01088) [`pytorch`](https://github.com/Ben-Louis/Deep-Image-Analogy-PyTorch)
- Visual Discovery at Pinterest. [`arxiv`](https://arxiv.org/abs/1702.04680)
- [Visualizing Residual Networks.](https://mp.weixin.qq.com/s?__biz=MzA3MzI4MjgzMw==&mid=2650722569&idx=4&sn=28edc09238076e924c94ac1094ddfa53) [`arxiv`](https://arxiv.org/abs/1701.02362) :star:
- VoxelNet: End-to-End Learning for Point Cloud Based 3D Object Detection. [`arxiv`](https://arxiv.org/abs/1711.06396)
- [Wide-Residual-Inception Networks for Real-time Object Detection.](https://mp.weixin.qq.com/s?__biz=MzA3MzI4MjgzMw==&mid=2650723042&idx=5&sn=575a4de5c895487616f20228e9d15f43) [`arxiv`](https://arxiv.org/abs/1702.01243) :star:
- YouTube-BoundingBoxes: A Large High-Precision Human-Annotated Data Set for Object Detection in Video.  [`arxiv`](https://arxiv.org/abs/1702.00824) [`code`](https://github.com/mbuckler/youtube-bb)
- Zoom Out-and-In Network with Recursive Training for Object Proposal. [`arxiv`](https://arxiv.org/abs/1702.05711)
  