## deep reinforcement learning

- [return to home](../../README.md)

### papers

- Asynchronous Methods for Deep Reinforcement Learning. [[arxiv](http://arxiv.org/abs/1602.01783)] :star: 
- Actor-Mimic: Deep Multitask and Transfer Reinforcement Learning, E. Parisotto, et al., *ICLR*. [[arxiv](http://arxiv.org/abs/1511.06342)]
- A New Softmax Operator for Reinforcement Learning.[[url](https://128.84.21.199/abs/1612.05628?context=cs)]
- Benchmarking Deep Reinforcement Learning for Continuous Control, Y. Duan et al., *ICML*. [[arxiv](https://arxiv.org/abs/1604.06778)]
- Better Computer Go Player with Neural Network and Long-term Prediction, Y. Tian et al., *ICLR*. [[arxiv](http://arxiv.org/abs/1511.06410)]
- Deep Reinforcement Learning in Parameterized Action Space, M. Hausknecht et al., *ICLR*. [[arxiv](http://arxiv.org/abs/1511.04143)]
- Curiosity-driven Exploration in Deep Reinforcement Learning via Bayesian Neural Networks, R. Houthooft et al., *arXiv*. [[url](http://arxiv.org/abs/1605.09674)]
- Control of Memory, Active Perception, and Action in Minecraft, J. Oh et al., *ICML*. [[arxiv](http://arxiv.org/abs/1605.09128)]
- Continuous Deep Q-Learning with Model-based Acceleration, S. Gu et al., *ICML*. [[arxiv](http://arxiv.org/abs/1603.00748)]
- Continuous control with deep reinforcement learning. [[arxiv](http://arxiv.org/abs/1509.02971)] :star: 
- Deep Successor Reinforcement Learning. [[arxiv](http://arxiv.org/abs/1606.02396)]
- Dynamic Frame skip Deep Q Network, A. S. Lakshminarayanan et al., *IJCAI Deep RL Workshop*. [[arxiv](http://arxiv.org/abs/1605.05365)]
- Deep Exploration via Bootstrapped DQN. [[arxiv](http://arxiv.org/abs/1602.04621)] :star: 
- Deep Reinforcement Learning for Dialogue Generation. [[arxiv](https://arxiv.org/abs/1606.01541)] [`tensorflow`](https://github.com/BigPlay/Deep-Reinforcement-Learning-for-Dialogue-Generation-in-tensorflow)
- Deep Reinforcement Learning in Parameterized Action Space. [[arxiv](http://arxiv.org/abs/1511.04143)] :star: 
- Deep Reinforcement Learning with Successor Features for Navigation across Similar Environments.[[url](https://scirate.com/arxiv/1612.05533)]
- Designing Neural Network Architectures using Reinforcement Learning. [`arxiv`](https://arxiv.org/abs/1611.02167) [`code`](https://bowenbaker.github.io/metaqnn/)
- Dialogue manager domain adaptation using Gaussian process reinforcement learning. [[arxiv](https://arxiv.org/abs/1609.02846)]
- End-to-End Reinforcement Learning of Dialogue Agents for Information Access. [[arxiv](https://arxiv.org/abs/1609.00777)]
- Generating Text with Deep Reinforcement Learning. [[arxiv](https://arxiv.org/abs/1510.09202)]
- Guided Cost Learning: Deep Inverse Optimal Control via Policy Optimization, C. Finn et al., *arXiv*. [[arxiv](http://arxiv.org/abs/1603.00448)]
- Hierarchical Reinforcement Learning using Spatio-Temporal Abstractions and Deep Neural Networks, R. Krishnamurthy et al., *arXiv*. [[arxiv](https://arxiv.org/abs/1605.05359)]
- Hierarchical Deep Reinforcement Learning: Integrating Temporal Abstraction and Intrinsic Motivation, T. D. Kulkarni et al., *arXiv*. [[arxiv](https://arxiv.org/abs/1604.06057)]
- Hierarchical Object Detection with Deep Reinforcement Learning. [[arxiv](https://arxiv.org/abs/1611.03718)]
- High-Dimensional Continuous Control Using Generalized Advantage Estimation, J. Schulman et al., *ICLR*. [[arxiv](http://arxiv.org/abs/1506.02438)]
- Increasing the Action Gap: New Operators for Reinforcement Learning, M. G. Bellemare et al., *AAAI*. [[arxiv](http://arxiv.org/abs/1512.04860)]
- Interactive Spoken Content Retrieval by Deep Reinforcement Learning. [[arxiv](https://arxiv.org/abs/1609.05234)]
- Learning Hand-Eye Coordination for Robotic Grasping with Deep Learning and Large-Scale Data Collection, S. Levine et al., *arXiv*. [[url](http://arxiv.org/abs/1603.02199)]
- Learning to Communicate to Solve Riddles with Deep Distributed Recurrent Q-Networks, J. N. Foerster et al., *arXiv*. [[url](http://arxiv.org/abs/1602.02672)]
- Learning to compose words into sentences with reinforcement learning. [[url](https://www.google.com.hk/url?sa=t&rct=j&q=&esrc=s&source=web&cd=3&cad=rja&uact=8&ved=0ahUKEwim56OJ1I_RAhUJi1QKHcDRAEYQFgg2MAI&url=https%3A%2F%2Fwww.reddit.com%2Fr%2FMachineLearning%2Fcomments%2F5b373g%2Fr_learning_to_compose_words_into_sentences_with%2F&usg=AFQjCNFBoour5fTqAiKQF1NXNon2e-j9pA)]
- Loss is its own Reward: Self-Supervision for Reinforcement Learning.[[arxiv](https://arxiv.org/abs/1612.07307)]
- Model-Free Episodic Control. [[arxiv](http://arxiv.org/abs/1606.04460)]
- Mastering the game of Go with deep neural networks and tree search. [[nature](http://www.nature.com/nature/journal/v529/n7587/full/nature16961.html)] :star: 
- MazeBase: A Sandbox for Learning from Games .[[arxiv](http://arxiv.org/abs/1511.07401)]
- [Neural Architecture Search with Reinforcement Learning.](https://mp.weixin.qq.com/s?__biz=MzI0ODcxODk5OA==&mid=2247483966&idx=1&sn=e3fde0461e10e220aca322ca9395958c) [[pdf](https://openreview.net/pdf?id=r1Ue8Hcxg)]
- Neural Combinatorial Optimization with Reinforcement Learning. [[arxiv](https://arxiv.org/abs/1611.09940)]
- Non-Deterministic Policy Improvement Stabilizes Approximated Reinforcement Learning. [[url](https://ewrl.files.wordpress.com/2016/11/ewrl13-2016-submission_2.pdf)]
- Online Sequence-to-Sequence Active Learning for Open-Domain Dialogue Generation. *arXiv*. [[arxiv](https://arxiv.org/abs/1612.03929)]
- Policy Distillation, A. A. Rusu et at., *ICLR*. [[arxiv](http://arxiv.org/abs/1511.06295)]
- Prioritized Experience Replay. [[arxiv](http://arxiv.org/abs/1511.05952)] :star:
- Reinforcement Learning Using Quantum Boltzmann Machines. [[arxiv](https://arxiv.org/abs/1612.05695)]
- Safe and Efficient Off-Policy Reinforcement Learning, R. Munos et al.[[arxiv](https://arxiv.org/abs/1606.02647)]
- [Safe, Multi-Agent, Reinforcement Learning for Autonomous Driving.](https://zhuanlan.zhihu.com/p/25673276) [[arxiv](https://arxiv.org/abs/1610.03295)]
- Sample-efficient Deep Reinforcement Learning for Dialog Control. [[url](https://scirate.com/arxiv/1612.06000)]
- Self-Correcting Models for Model-Based Reinforcement Learning.[[url](https://scirate.com/arxiv/1612.06018)]
- Unifying Count-Based Exploration and Intrinsic Motivation. [[arxiv](https://arxiv.org/abs/1606.01868)]
- Value Iteration Networks. [[arxiv](http://arxiv.org/abs/1602.02867)]
