## natural language process

- [return to home](../../README.md)

### NLP

- Abstractive Text Summarization using Sequence-to-sequence RNNs and Beyond. [`pdf`](https://aclweb.org/anthology/K/K16/K16-1028.pdf)
- AC-BLSTM: Asymmetric Convolutional Bidirectional LSTM Networks for Text Classification. [`arxiv`](https://arxiv.org/abs/1611.01884)
- Achieving Human Parity in Conversational Speech Recognition. [`arxiv`](https://arxiv.org/abs/1610.05256)
- A General Framework for Content-enhanced Network Representation Learning. [`arxiv`](https://arxiv.org/abs/1610.02906)
- A Hybrid Geometric Approach for Measuring Similarity Level Among Documents and Document Clustering. [`pdf`](http://ieeexplore.ieee.org/document/7474366/?reload=true) [`code`](https://github.com/taki0112/Vector_Similarity)
- A Joint Many-Task Model- Growing a Neural Network for Multiple NLP Tasks. [`arxiv`](https://arxiv.org/abs/1611.01587)
- A Semisupervised Approach for Language Identification based on Ladder Networks. [`pdf`](http://www.eng.biu.ac.il/goldbej/files/2012/05/Odyssey_2016_paper.pdf)
- A Simple, Fast Diverse Decoding Algorithm for Neural Generation. [`arxiv`](https://arxiv.org/abs/1611.08562)
- Aspect Level Sentiment Classification with Deep Memory Network. [`arxiv`](https://arxiv.org/abs/1605.08900) [`tensorflow`](https://github.com/endymecy/transwarp-nlp) :star:
- A Strong Baseline for Learning Cross-Lingual Word Embeddings from Sentence Alignments. [`arxiv`](https://arxiv.org/abs/1608.05426)
- Cached Long Short-Term Memory Neural Networks for Document-Level Sentiment Classification. [`arxiv`](https://arxiv.org/abs/1610.04989)
- Character-level and Multi-channel Convolutional Neural Networks for Large-scale Authorship Attribution. [`arxiv`](https://arxiv.org/abs/1609.06686)
- COCO-Text-Dataset and Benchmark for Text Detection and Recognition in Natural Images. [`pdf`](http://sunw.csail.mit.edu/papers/01_Veit_SUNw.pdf)
- Collaborative Recurrent Autoencoder: Recommend while Learning to Fill in the Blanks. [`arxiv`](https://arxiv.org/abs/1611.00454)
- Collaborative Recurrent Neural Networks for Dynamic Recommender Systems. [`pdf`](https://infoscience.epfl.ch/record/222477/files/ko101.pdf) [`tensorflow`](https://github.com/lca4/collaborative-rnn)
- Context-aware Natural Language Generation with Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1611.09900)
- <b>[CLSTM]</b> Contextual LSTM models for Large scale NLP tasks. [`pdf`](http://www.csl.sri.com/users/shalini/clstm_dlkdd16.pdf) :star: 
- Deep Biaffine Attention for Neural Dependency Parsing. [`pdf`](https://openreview.net/pdf?id=Hk95PK9le) [`code`](https://github.com/tdozat/Parser) :star:
- Deep Semi-Supervised Learning with Linguistically Motivated Sequence Labeling Task Hierarchies. [`arxiv`](https://arxiv.org/abs/1612.09113)
- Deep Neural Networks for YouTube Recommendations. [`pdf`](https://static.googleusercontent.com/media/research.google.com/zh-CN//pubs/archive/45530.pdf)
- Detecting Text in Natural Image with Connectionist Text Proposal Network. [`arxiv`](https://arxiv.org/abs/1609.03605) [`code`](https://github.com/qingswu/CTPN)
- Diverse Beam Search: Decoding Diverse Solutions from Neural Sequence Models. [`arxiv`](https://arxiv.org/abs/1610.02424)
- Efficient Character-level Document Classification by Combining Convolution and Recurrent Layers. [`arxiv`](https://arxiv.org/abs/1602.00367)
- End-to-End Answer Chunk Extraction and Ranking for Reading Comprehension. [`arxiv`](https://arxiv.org/abs/1610.09996)
- End-to-End Multi-View Networks for Text Classification. [`arxiv`](https://arxiv.org/abs/1704.05907)
- End-to-end Sequence Labeling via Bi-directional LSTM-CNNs-CRF. [`arxiv`](https://arxiv.org/abs/1603.01354) :star:
- Enhancing and Combining Sequential and Tree LSTM for Natural Language Inference. [`arxiv`](https://arxiv.org/abs/1609.06038)
- Fully Convolutional Instance-aware Semantic Segmentation. [`arxiv`](https://arxiv.org/abs/1611.07709) [`code`](https://github.com/msracver/FCIS)
- Generative Deep Neural Networks for Dialogue: A Short Review. [`arxiv`](https://arxiv.org/abs/1611.06216)
- Generating Factoid Questions With Recurrent Neural Networks- The 30M Factoid Question-Answer Corpus. [`pdf`](https://aclweb.org/anthology/P/P16/P16-1056.pdf) :star: 
- Globally Normalized Transition-Based Neural Networks. [`arxiv`](https://arxiv.org/abs/1603.06042) [`tensorflow`](https://github.com/tensorflow/models/tree/master/syntaxnet) :star:
- GraphNet: Recommendation system based on language and network structure. [`pdf`](https://web.stanford.edu/class/cs224n/reports/2758630.pdf)
- How NOT To Evaluate Your Dialogue System. [`arxiv`](https://arxiv.org/abs/1603.08023) :star: 
- Inducing Multilingual Text Analysis Tools Using Bidirectional Recurrent Neural Networks. [`pdf`](https://hal.archives-ouvertes.fr/hal-01374205/document)
- Key-Value Memory Networks for Directly Reading Documents. [`pdf`](https://arxiv.org/pdf/1606.03126.pdf)
- Learning Distributed Representations of Sentences from Unlabelled Data. [`arxiv`](https://arxiv.org/abs/1602.03483) :star: 
- Learning End-to-End Goal-Oriented Dialog. [`arxiv`](https://arxiv.org/abs/1605.07683) [`tensorflow`](https://github.com/vyraun/chatbot-MemN2N-tensorflow) :star:
- Learning Recurrent Span Representations for Extractive Question Answering. [`arxiv`](https://arxiv.org/abs/1611.01436)
- Learning to Compose Neural Networks for Question Answering. [`arxiv`](https://arxiv.org/abs/1601.01705) :star: 
- Learning to Translate in Real-time with Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1610.00388)
- Linguistically Regularized LSTMs for Sentiment Classification. [`arxiv`](https://arxiv.org/abs/1611.03949)
- Long Short-Term Memory-Networks for Machine Reading. [`url`](https://aclweb.org/anthology/D16-1053) :star: 
- <b>[lda2vec]</b> Mixing Dirichlet Topic Models and Word Embeddings to Make lda2vec. [`arxiv`](https://arxiv.org/abs/1605.02019) [`code`](https://github.com/cemoody/lda2vec) [`tensorflow`](https://github.com/meereeum/lda2vec-tf) :star:
- Modeling Coverage for Neural Machine Translation. [`pdf`](http://www.hangli-hl.com/uploads/3/4/4/6/34465961/tu_et_al_2016.pdf) :star: 
- Multilingual Part-of-Speech Tagging with Bidirectional Long Short-Term Memory Models and Auxiliary Loss. [`pdf`](https://www.aclweb.org/anthology/P/P16/P16-2067.pdf) [`code`](https://github.com/bplank/bilstm-aux) :star: 
- MultiNet: Real-time Joint Semantic Reasoning for Autonomous Driving. [`arxiv`](https://arxiv.org/abs/1612.07695) :star: 
- Neural Architectures for Fine-grained Entity Type Classification. [`arxiv`](https://arxiv.org/abs/1606.01341)
- Neural Architectures for Named Entity Recognition. [`arxiv`](https://arxiv.org/abs/1603.01360) :star: 
- Neural Emoji Recommendation in Dialogue Systems.[`arxiv`](https://arxiv.org/abs/1612.04609)
- Neural Paraphrase Generation with Stacked Residual LSTM Networks. [`arxiv`](https://arxiv.org/abs/1610.03098)
- Neural Semantic Encoders. [`arxiv`](https://arxiv.org/abs/1607.04315)
- Neural Variational Inference for Text Processing. [`arxiv`](https://arxiv.org/pdf/1511.06038) :star: 
- Online Segment to Segment Neural Transduction. [`arxiv`](https://arxiv.org/abs/1609.08194)
- On Random Weights for Texture Generation in One Layer Neural Networks.[`arxiv`](https://arxiv.org/abs/1612.06070?utm_source=feedburner&utm_medium=feed&utm_campaign=Feed%253A+arxiv%252FQSXk+%2528ExcitingAds%2521+cs+updates+on+arXiv.org%2529)
- Parallelizing Word2Vec in Shared and Distributed Memory.[`arxiv`](https://arxiv.org/abs/1604.04661) [`code`](https://github.com/IntelLabs/pWord2Vec)
- Phased LSTM: Accelerating Recurrent Network Training for Long or Event-based Sequences. [`arxiv`](https://arxiv.org/abs/1610.09513) [`code`](https://github.com/dannyneil/public_plstm)
- Recurrent Neural Network Grammars. [`arxiv`](https://arxiv.org/abs/1602.07776) :star: 
- Reading Wikipedia to Answer Open-Domain Questions. [`arxiv`](https://arxiv.org/abs/1704.00051) [`pytorch`](https://github.com/facebookresearch/DrQA)
- ReasoNet: Learning to Stop Reading in Machine Comprehension. [`arxiv`](https://arxiv.org/abs/1609.05284)
- Sentence Level Recurrent Topic Model- Letting Topics Speak for Themselves. [`arxiv`](https://arxiv.org/abs/1604.02038)
- Sentence-Level Grammatical Error Identification as Sequence-to-Sequence Correction. [`pdf`](https://aclweb.org/anthology/W/W16/W16-0528.pdf)
- Sentence Ordering using Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1611.02654)
- Sequence to Backward and Forward Sequences: A Content-Introducing Approach to Generative Short-Text Conversation. [`arxiv`](https://arxiv.org/abs/1607.00970)
- Sequential Match Network: A New Architecture for Multi-turn Response Selection in Retrieval-based Chatbots. [`arxiv`](https://arxiv.org/abs/1612.01627)
- Structured Sequence Modeling with Graph Convolutional Recurrent Networks. [`arxiv`](https://arxiv.org/abs/1612.07659)
- [TopicRNN: A Recurrent Neural Network with Long-Range Semantic Dependency.](http://weibo.com/ttarticle/p/show?id=2309404086416278721142) [`arxiv`](https://arxiv.org/abs/1611.01702)
- Tracking the World State with Recurrent Entity Networks . [`arxiv`](https://arxiv.org/abs/1612.03969) :star: 
- Tying Word Vectors and Word Classifiers: A Loss Framework for Language Modeling. [`arxiv`](https://arxiv.org/abs/1611.01462) [`code`](https://github.com/icoxfog417/tying-wv-and-wc)
- Tweet2Vec: Learning Tweet Embeddings Using Character-level CNN-LSTM Encoder-Decoder.[`arxiv`](https://arxiv.org/abs/1607.07514) [`code`](https://github.com/soroushv/Tweet2Vec)
- Unsupervised Learning of Sentence Representations using Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1611.07897)
- Unsupervised neural and Bayesian models for zero-resource speech processing. [`arxiv`](https://arxiv.org/abs/1701.00851)
- Unsupervised Pretraining for Sequence to Sequence Learning. [`arxiv`](https://arxiv.org/abs/1611.02683)
- UTCNN: a Deep Learning Model of Stance Classificationon on Social Media Text. [`arxiv`](https://arxiv.org/abs/1611.03599)
- Very Deep Convolutional Networks for Natural Language Processing. [`arxiv`](https://arxiv.org/pdf/1606.01781.pdf) :star: 
- Visual Dialog. [`arxiv`](https://arxiv.org/abs/1611.08669) [`code`](https://github.com/Cloud-CV/visual-chatbot) :star:
- Wav2Letter: an End-to-End ConvNet-based Speech Recognition System. [`arxiv`](https://arxiv.org/abs/1609.03193)
- [Wide & Deep Learning for Recommender Systems.](http://blog.csdn.net/dinosoft/article/details/52581368) [`arxiv`](https://arxiv.org/abs/1606.07792) [`tensorflow`](https://www.tensorflow.org/tutorials/wide_and_deep/) :star:

### Generative learning

- Adversarial Training Methods for Semi-Supervised Text Classification. [`arxiv`](https://arxiv.org/abs/1605.07725)
- Aspect Level Sentiment Classification with Deep Memory Network. [`arxiv`](https://arxiv.org/pdf/1605.08900.pdf)
- Generative Adversarial Text to Image Synthesis. [`arxiv`](https://arxiv.org/abs/1605.05396) :star: 
- Modeling documents with Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1612.09122)
- <b>[StackGAN]</b> StackGAN: Text to Photo-realistic Image Synthesis with Stacked Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1612.03242) [`code`](https://github.com/hanzhanggit/StackGAN) :star:

### Attention and memory

- ABCNN: Attention-Based Convolutional Neural Network for Modeling Sentence Pairs. [`arxiv`](https://arxiv.org/abs/1512.05193) [`tensorflow`](https://github.com/galsang/ABCNN)
- A Context-aware Attention Network for Interactive Question Answering. [`url`](https://openreview.net/pdf?id=SkyQWDcex)
- A Decomposable Attention Model for Natural Language Inference. [`arxiv`](https://arxiv.org/abs/1606.01933) [`code`](https://github.com/harvardnlp/decomp-attn)
- A self-attentive sentence embedding. [`pdf`](https://openreview.net/pdf?id=BJC_jUqxe)
- Aspect Level Sentiment Classification with Deep Memory Network. [`arxiv`](https://arxiv.org/abs/1605.08900) [`code`](http://nlp.stanford.edu/sentiment/code.html) :star:
- AttSum: Joint Learning of Focusing and Summarization with Neural Attention. [`arxiv`](https://arxiv.org/abs/1604.00125)
- Attention-over-Attention Neural Networks for Reading Comprehension. [`arxiv`](https://arxiv.org/abs/1607.04423) [`code`](https://github.com/OlavHN/attention-over-attention)
- Collective Entity Resolution with Multi-Focal Attention. [`pdf`](https://www.aclweb.org/anthology/P/P16/P16-1059.pdf)
- [Gated-Attention Readers for Text Comprehension.](https://theneuralperspective.com/2017/01/19/gated-attention-readers-for-text-comprehension/)  [`pdf`](https://openreview.net/pdf?id=HkcdHtqlx)
- Hierarchical Attention Networks for Document Classification. [`pdf`](https://www.cs.cmu.edu/~diyiy/docs/naacl16.pdf) [`tensorflow`](https://github.com/ematvey/deep-text-classifier) :star: 
- Hierarchical Memory Networks for Answer Selection on Unknown Words. [`arxiv`](https://arxiv.org/abs/1609.08843)
- Implicit Distortion and Fertility Models for Attention-based Encoder-Decoder NMT Model. [`arxiv`](https://arxiv.org/abs/1601.03317)
- Improving Attention Modeling with Implicit Distortion and Fertility for Machine Translation. [`pdf`](https://www.aclweb.org/anthology/C/C16/C16-1290.pdf)
- Iterative Alternating Neural Attention for Machine Reading. [`arxiv`](https://arxiv.org/pdf/1606.02245.pdf)
- Joint CTC-Attention based End-to-End Speech Recognition using Multi-task Learning. [`arxiv`](https://arxiv.org/abs/1609.06773)
- Key-Value Memory Networks for Directly Reading Documents. [`arxiv`](https://arxiv.org/abs/1606.03126)
- Knowledge as a Teacher: Knowledge-Guided Structural Attention Networks. [`arxiv`](https://arxiv.org/abs/1609.03286)
- Language to Logical Form with Neural Attention. [`pdf`](http://homepages.inf.ed.ac.uk/s1478528/acl16-lang2logic-slides.pdf) :star: 
- Learning Natural Language Inference using Bidirectional LSTM model and Inner-Attention. [`arxiv`](https://arxiv.org/abs/1605.09090)
- Lexicon Integrated CNN Models with Attention for Sentiment Analysis. [`arxiv`](https://arxiv.org/abs/1610.06272)
- Memory-enhanced Decoder for Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1606.02003)
- Neural Language Correction with Character-Based Attention. [`arxiv`](https://arxiv.org/abs/1603.09727)
- Visualizing and Understanding Curriculum Learning for Long Short-Term Memory Networks. [`arxiv`](https://arxiv.org/abs/1611.06204)

### Neural Machine Translation

- Achieving Open Vocabulary Neural Machine Translation with Hybrid Word-Character Models. [`arxiv`](https://arxiv.org/abs/1604.00788) :star: 
- A Character-level Decoder without Explicit Segmentation for Neural Machine Translation. [`pdf`](https://www.aclweb.org/anthology/P/P16/P16-1160.pdf) :star: 
- A Convolutional Encoder Model for Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1611.02344) [`pytorch`](https://github.com//pravarmahajan/cnn-encoder-nmt)
- Character-based Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1511.04586) :star: 
- Context-Dependent Word Representation for Neural Machine Translation. [`arxiv`](https://arxiv.org/pdf/1607.00578.pdf)
- Convolutional Encoders for Neural Machine Translation. [`pdf`](https://cs224d.stanford.edu/reports/LambAndrew.pdf)
- Deep Recurrent Models with Fast-Forward Connections for Neural Machine Translatin. [`arxiv`](https://arxiv.org/pdf/1606.04199.pdf)
- Dual Learning for Machine Translation. [`pdf`](https://papers.nips.cc/paper/6469-dual-learning-for-machine-translation.pdf)
- Fast Domain Adaptation for Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1612.06897)
- Fully Character-Level Neural Machine Translation without Explicit Segmentation. [`pdf`](https://arxiv.org/pdf/1610.03017.pdf) :star: 
- Google's Multilingual Neural Machine Translation System- Enabling Zero-Shot Translation. [`arxiv`](https://arxiv.org/abs/1611.04558)
- Google's Neural Machine Translation System- Bridging the Gap between Human and Machine Translation. [`arxiv`](https://arxiv.org/abs/1609.08144) :star: 
- How Grammatical is Character-level Neural Machine Translation? Assessing MT Quality with Contrastive Translation Pairs. [`arxiv`](https://arxiv.org/abs/1612.04629)
- Interactive Attention for Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1610.05011)
- Multimodal Attention for Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1609.03976)
- Multi-Way, Multilingual Neural Machine Translation with a Shared Attention Mechanism. [`arxiv`](https://arxiv.org/pdf/1601.01073.pdf) :star: 
- Modeling Coverage for Neural Machine Translation. [`pdf`](http://www.hangli-hl.com/uploads/3/4/4/6/34465961/tu_et_al_2016.pdf) :star: 
- Neural Machine Translation in Linear Time. [`arxiv`](https://arxiv.org/abs/1610.10099)
- Neural Network Translation Models for Grammatical Error Correction. [`arxiv`](https://arxiv.org/pdf/1606.00189.pdf)
- Neural Machine Translation with Latent Semantic of Image and Text. [`arxiv`](https://arxiv.org/abs/1611.08459)
- Neural Machine Translation with Pivot Languages. [`arxiv`](https://arxiv.org/abs/1611.04928)
- Neural Machine Translation with Recurrent Attention Modeling. [`arxiv`](https://arxiv.org/abs/1607.05108)
- Neural Machine Translation with Supervised Attention. [`pdf`](https://www.aclweb.org/anthology/C/C16/C16-1291.pdf)
- Recurrent Neural Machine Translation.[`arxiv`](https://arxiv.org/abs/1607.08725)
- Semi-Supervised Learning for Neural Machine Translation. [`pdf`](http://iiis.tsinghua.edu.cn/~weixu/files/acl2016_chengyong.pdf)
- Temporal Attention Model for Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1608.02927)
- Zero-Resource Translation with Multi-Lingual Neural Machine Translation. [`arxiv`](https://arxiv.org/pdf/1606.04164.pdf)

### Neural Language Model

- Character-Aware Neural Language Models. [`pdf`](http://www.aaai.org/ocs/index.php/AAAI/AAAI16/paper/download/12489/12017) :star: 
- Character-Level Language Modeling with Hierarchical Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1609.03777)
- Coherent Dialogue with Attention-based Language Models. [`arxiv`](https://arxiv.org/abs/1611.06997)
- Joint Online Spoken Language Understanding and Language Modeling with Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1609.01462)
- Improving neural language models with a continuous cache. [`pdf`](https://openreview.net/pdf?id=B184E5qee)
- Language Modeling with Gated Convolutional Networks. [`arxiv`](https://arxiv.org/abs/1612.08083) [`tensorflow`](https://github.com/anantzoid/Language-Modeling-GatedCNN) :star: 
- Scalable Bayesian Learning of Recurrent Neural Networks for Language Modeling. [`arxiv`](https://arxiv.org/abs/1611.08034)
- Recurrent Memory Networks for Language Modeling. [`arxiv`](https://arxiv.org/pdf/1601.01272.pdf)
