## Deep Learning

- [return to home](../../README.md)

### Deep learning

- Adaptive Computation Time for Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1603.08983) :star: 
- A Deep Learning Approach To Multiple Kernel Fusion. [`arxiv`](https://arxiv.org/abs/1612.09007)
- Aggregated Residual Transformations for Deep Neural Networks.  [`arxiv`](https://arxiv.org/abs/1611.05431) [`tensorflow`](https://github.com/wenxinxu/ResNeXt-in-tensorflow) 
- A guide to convolution arithmetic for deep learning. [`arxiv`](https://arxiv.org/pdf/1603.07285.pdf)
- A New Method to Visualize Deep Neural Networks. [`pdf`](https://icmlviz.github.io/assets/papers/23.pdf)
- A Persona-Based Neural Conversation Model. [`pdf`](https://www.aclweb.org/anthology/P/P16/P16-1094.pdf)
- Architectural Complexity Measures of Recurrent Neural Networks. [`arxiv`](https://arxiv.org/pdf/1602.08210.pdf)
- Associative Long Short-Term Memory. [`arxiv`](https://arxiv.org/pdf/1602.03032.pdf) :star: 
- Automatic chemical design using a data-driven continuous representation of molecules. [`arxiv`](https://arxiv.org/abs/1610.02415) [`pytorch`](https://github.com/cxhernandez/molencoder)
- A Way out of the Odyssey- Analyzing and Combining Recent Insights for LSTMs. [`arxiv`](https://arxiv.org/abs/1611.05104) :star: 
- Batch Policy Gradient Methods for Improving Neural Conversation Models.  [`url`](https://openreview.net/pdf?id=rJfMusFll)
- Benefits of depth in neural networks. [`url`](http://proceedings.mlr.press/v49/telgarsky16.pdf)
- BinaryNet-Training Deep Neural Networks with Weights and Activations Constrained to +1 or -1. [`arxiv`](https://arxiv.org/abs/1602.02830)
- Bitwise Neural Networks.  [`pdf`](http://paris.cs.illinois.edu/pubs/minje-icmlw2015.pdf)
- Bridging the Gaps Between Residual Learning, Recurrent Neural Networks and Visual Cortex.  [`arxiv`](https://arxiv.org/abs/1604.03640)
- Building Machines That Learn and Think Like People. [`pdf`](http://www.mit.edu/~tomeru/papers/machines_that_think.pdf) :star: 
- Building Large Machine Reading-Comprehension Datasets using Paragraph Vectors. [`arxiv`](https://arxiv.org/abs/1612.04342)
- CNN Image Retrieval Learns from BoW: Unsupervised Fine-Tuning with Hard Examples. [`arxiv`](https://arxiv.org/abs/1604.02426) [`code`](https://github.com/filipradenovic/cnnimageretrieval)
- Composing graphical models with neural networks for structured representations and fast inference .[`arxiv`](https://arxiv.org/abs/1603.06277) [`code`](https://github.com/mattjj/svae)
- Conditional Generative Moment-Matching Networks. [`arxiv`](https://arxiv.org/abs/1606.04218)
- Context Encoders: Feature Learning by Inpainting. [`arxiv`](https://arxiv.org/abs/1604.07379) [`pytorch`](https://github.com/BoyuanJiang/context_encoder_pytorch)
- Conversational Contextual Cues-The Case of Personalization and History for Response Ranking. [`arxiv`](https://arxiv.org/abs/1606.00372)
- Controlling Output Length in Neural Encoder-Decoders. [`arxiv`](https://arxiv.org/abs/1609.09552) [`code`](https://github.com/kiyukuta/lencon)
- Convolutional Neural Networks on Graphs with Fast Localized Spectral Filtering. [`arxiv`](https://arxiv.org/abs/1606.09375) [`code`](https://github.com/mdeff/cnn_graph)
- Data Programming- Creating Large Training Sets, Quickly. [`arxiv`](https://arxiv.org/abs/1605.07723)
- DCM Bandits: Learning to Rank with Multiple Clicks. [`pdf`](https://pdfs.semanticscholar.org/b4c3/a056426aeca24d43785fac6c4d61af7eb5fe.pdf)
- Decoupled Neural Interfaces using Synthetic Gradients. [`pdf`](https://pdfs.semanticscholar.org/b4c3/a056426aeca24d43785fac6c4d61af7eb5fe.pdfhttps://arxiv.org/abs/1608.05343)
- DeepChess: End-to-End Deep Neural Network for Automatic Learning in Chess. [`pdf`](http://www.cs.tau.ac.il/~wolf/papers/deepchess.pdf) [`tensorflow`](https://github.com/mr-press/DeepChess)
- <b>DeepMind Lab.</b> [`url`](https://arxiv.org/abs/1612.03801) :star: 
- Deep API Learning.  [`pdf`](http://home.cse.ust.hk/~xguaa/papers/deepapi.pdf)
- <b>[DeepCoder]</b> [DeepCoder: Learning to Write Programs](https://mp.weixin.qq.com/s?__biz=MzA3MzI4MjgzMw==&mid=2650723632&idx=5&sn=2654d4e512ff3c23e1bd17b2e9e562d5) :star:
- <b>[DeepFashion]</b> Powering Robust Clothes Recognition and Retrieval with Rich Annotations. [`pdf`](http://www.cv-foundation.org/openaccess/content_cvpr_2016/papers/Liu_DeepFashion_Powering_Robust_CVPR_2016_paper.pdf) [`code`](https://github.com/liuziwei7/fashion-detection)
- Deep Learning without Poor Local Minima. [`arxiv`](https://arxiv.org/abs/1605.07110) :star: 
- Deep Learning with Differential Privacy. [`arxiv`](https://arxiv.org/abs/1607.00133) [`tensorflow`](https://github.com/tensorflow/models/tree/master/differential_privacy/privacy_accountant) :star:
- Deep Portfolio Theory. [`arxiv`](https://arxiv.org/pdf/1605.07230.pdf)
- Deeply-Fused Nets. [`arxiv`](https://arxiv.org/abs/1605.07716) :star: 
- DeepSense: A Unified Deep Learning Framework for Time-Series Mobile Sensing Data Processing. [`arxiv`](https://arxiv.org/abs/1611.01942) [`code`](https://github.com/yscacaca/DeepSense)
- Densely Connected Convolutional Networks. [`arxiv`](https://arxiv.org/abs/1608.06993) [`pytorch`](http://www.weibo.com/1402400261/FfDPdBLum?type=comment)
- Detect, Replace, Refine: Deep Structured Prediction For Pixel Wise Labeling. [`arxiv`](https://arxiv.org/abs/1612.04770) [`code`](https://github.com/gidariss/DRR_struct_pred)
- <b>[DenseNet]</b> [Densely Connected Convolutional Networks.](https://medium.com/@illarionkhlestov/notes-on-the-implementation-densenet-in-tensorflow-beeda9dd1504#.a88ur45ce) [`arxiv`](https://arxiv.org/abs/1608.06993) [`pytorch`](https://github.com/andreasveit/densenet-pytorch) :star:
- Density estimation using Real NVP.[`arxiv`](https://arxiv.org/abs/1605.08803)[`tensorflow`](https://github.com/tensorflow/models/tree/master/real_nvp)
- Domain Separation Networks. [[url](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwij0dG5oI7RAhVriVQKHV3gAfwQFggsMAE&url=https%3A%2F%2Fpapers.nips.cc%2Fpaper%2F6254-domain-separation-networks.pdf&usg=AFQjCNFRd_0epq_0QAs21drboBmgCRdg1A)]
- <b>[DrMAD]</b> [Distilling Reverse-Mode Automatic Differentiation for Optimizing Hyperparameters of Deep Neural Networks.](http://mp.weixin.qq.com/s?__biz=MzI1NTE4NTUwOQ==&mid=2650326224&idx=1&sn=d40d8e0078f71b76c140ebe5185a8f80&chksm=f235a3dac5422acc9c8a0fa9a485cd666b792e52a188b4be3ec25cc800423be8ffecb069ae23&mpshare=1)) [`arxiv`](https://arxiv.org/abs/1601.00917) [`code`](https://github.com/bigaidream-projects/drmad) :star:
- Dynamic Neural Turing Machine with Soft and Hard Addressing Schemes. [`arxiv`](https://arxiv.org/abs/1607.00036)
- Early Visual Concept Learning with Unsupervised Deep Learning. [`arxiv`](https://arxiv.org/abs/1606.05579) [`code`](https://github.com/miyosuda/disentangled_vae)
- Efficient softmax approximation for GPUs. [`arxiv`](https://arxiv.org/abs/1609.04309) [`code`](https://github.com/rosinality/adaptive-softmax-pytorch)
- Efficient Training of Very Deep Neural Networks for Supervised Hashing. [`arxiv`](https://arxiv.org/abs/1511.04524)
- Episodic Exploration for Deep Deterministic Policies- An Application to StarCraft Micromanagement Tasks. [`arxiv`](https://arxiv.org/abs/1609.02993)
- Event-driven Random Back-Propagation: Enabling Neuromorphic Deep Learning Machines. [`arxiv`](https://arxiv.org/abs/1612.05596?utm_source=feedburner&utm_medium=feed&utm_campaign=Feed%253A+arxiv%252FQSXk+%2528ExcitingAds%2521+cs+updates+on+arXiv.org%2529)
- Fathom: Reference Workloads for Modern Deep Learning Methods.[`arxiv`](https://arxiv.org/abs/1608.06581)
- Feedback arcs and node hierarchy in directed networks. [`arxiv`](https://arxiv.org/abs/1612.05347)
- FINN: A framework for fast, scalable binarized neural network inference. [`arxiv`](https://arxiv.org/abs/1612.07119) [`code`](https://github.com/Xilinx/BNN-PYNQ)
- FlowNet 2.0: Evolution of Optical Flow Estimation with Deep Networks. [`arxiv`](https://arxiv.org/abs/1612.01925) [`code`](https://github.com/lmb-freiburg/flownet2)
- FractalNet-Ultra-Deep Neural Networks without Residuals. [`arxiv`](https://arxiv.org/pdf/1605.07648.pdf)
- <b>[URNN]</b> Full-Capacity Unitary Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1611.00035) [`code`](https://github.com/stwisdom/urnn) :star: 
- Fused-Layer CNN Accelerators. [`pdf`](http://compas.cs.stonybrook.edu/~mferdman/downloads.php/MICRO16_Fused_Layer_CNN_Accelerators.pdf)
- Generating long and diverse responses with neural conversation models.[`arxiv`](https://arxiv.org/pdf/1701.03185.pdf)
- GRAPH CONVOLUTIONAL NETWORKS. [`url`](http://tkipf.github.io/graph-convolutional-networks/) [`code`](https://github.com//shagunsodhani/pregel) :star:
- Hierarchical Multiscale Recurrent Neural Networks. [`arxiv`](https://arxiv.org/pdf/1609.01704.pdf) :star: 
- Higher Order Recurrent Neural Networks. [`arxiv`](https://arxiv.org/pdf/1605.00064.pdf)
- Highway and Residual Networks learn Unrolled Iterative Estimation. [`pdf`](https://openreview.net/pdf?id=Skn9Shcxe)
- Hyperband: A Novel Bandit-Based Approach to Hyperparameter Optimization. [`arxiv`](https://arxiv.org/abs/1603.06560) [`pytorch`](https://github.com/kevinzakka/hyperband) :star:
- How to Train Your Deep Neural Network with Dictionary Learning. [`arxiv`](https://arxiv.org/pdf/1612.07454.pdf)
- Improving the Robustness of Deep Neural Networks via Stability Training. [`arxiv`](https://arxiv.org/abs/1604.04326)
- Large-Margin Softmax Loss for Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1612.02295)
- Latent Predictor Networks for Code Generation. [`arxiv`](https://arxiv.org/pdf/1603.06744.pdf)
- <b>[Normalization]</b> Layer Normalization. [`arxiv`](https://arxiv.org/pdf/1607.06450.pdf) [`code`](https://github.com/ryankiros/layer-norm) :star: 
- Learning Discriminative Features via Label Consistent Neural Network. [`arxiv`](https://arxiv.org/abs/1602.01168)
- Learning End-to-End Goal-Oriented Dialog. [`arxiv`](https://arxiv.org/pdf/1605.07683.pdf)
- Learning Features by Watching Objects Move. [`arxiv`](https://arxiv.org/abs/1612.06370) [`code`](https://github.com/pathak22/unsupervised-video)
- Learning Python Code Suggestion with a Sparse Pointer Network. [`arxiv`](https://arxiv.org/abs/1611.08307) [`code`](https://github.com/uclmr/pycodesuggest) :star: 
- Learning to learn by gradient descent by gradient descent. [`pdf`](http://papers.nips.cc/paper/6461-learning-to-learn-by-gradient-descent-by-gradient-descent.pdf) :star: 
- Machine Comprehension Using Match-LSTM and Answer Pointer. [`arxiv`](https://arxiv.org/pdf/1608.07905.pdf)
- <b>[AlphaGo]</b> Mastering the game of Go with deep neural networks and tree search. [`pdf`](https://gogameguru.com/i/2016/03/deepmind-mastering-go.pdf)] :star: 
- Meta-Unsupervised-Learning: A supervised approach to unsupervised learning. [`arxiv`](https://arxiv.org/abs/1612.09030)
- Models, networks and algorithmic complexity. [`arxiv`](https://arxiv.org/abs/1612.05627)
- Multivariate Industrial Time Series with Cyber-Attack Simulation: Fault Detection Using an LSTM-based Predictive Data Model.[`url`](https://128.84.21.199/abs/1612.06676)
- Multiresolution Recurrent Neural Networks- An Application to Dialogue Response Generation. [`arxiv`](https://arxiv.org/pdf/1606.00776.pdf)
- Mutual information for fitting deep nonlinear models. [`pdf`](https://128.84.21.199/pdf/1612.05708)
- Natural-Parameter Networks: A Class of Probabilistic Neural Networks. [`arxiv`](https://arxiv.org/abs/1611.00448)
- Neural Paraphrase Generation with Stacked Residual LSTM Networks. [`arxiv`](https://arxiv.org/abs/1610.03098) [`code`](https://github.com//iamaaditya/neural-paraphrase-generation)
- Outrageously Large Neural Networks- The Sparsely-Gated Mixture-of-Experts Layer. [`pdf`](https://openreview.net/pdf?id=B1ckMDqlg)
- Overcoming catastrophic forgetting in neural networks. [`arxiv`](https://arxiv.org/abs/1612.00796)
- Phased LSTM: Accelerating Recurrent Network Training for Long or Event-based Sequences. [`arxiv`](https://arxiv.org/abs/1610.09513) [`tensorflow`](https://www.tensorflow.org/api_docs/python/tf/contrib/rnn/PhasedLSTMCell) :star:
- Pixel Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1601.06759)
- Polynomial networks and factorization machines new insights and efficient training algorithms. [`pdf`](http://mblondel.org/talks/mblondel-erato-2016-08.pdf)
- Policy Networks with Two-Stage Training for Dialogue Systems. [`arxiv`](https://arxiv.org/pdf/1606.03152.pdf)
- <b>[PSPNet]</b> [Pyramid Scene Parsing Network.](http://www.dongzhuoyao.com/pyramid-scene-parsing-network/) [`arxiv`](https://arxiv.org/abs/1612.01105) [`code`](http://weibo.com/1402400261/EuVYls29J?type=comment):star:
- Projected Semi-Stochastic Gradient Descent Method with Mini-Batch Scheme under Weak Strong Convexity Assumption. [`arxiv`](https://arxiv.org/abs/1612.05356)
- <b>[QRNN]</b> Quasi-Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1611.01576) [`tensorflow`](https://github.com/santi-pdp/quasi-rnn) [`keras`](https://github.com/DingKe/qrnn) [`pytorch`](https://github.com/salesforce/pytorch-qrnn) :star:
- RAISR: Rapid and Accurate Image Super Resolution. [`arxiv`](https://arxiv.org/abs/1606.01299) :star:
- Recurrent Batch Normalization. [`arxiv`](https://arxiv.org/pdf/1603.09025.pdf) :star: 
- Recurrent Dropout without Memory Loss. [`arxiv`](https://arxiv.org/abs/1603.05118) :star: 
- Recurrent Highway Networks. [`arxiv`](https://arxiv.org/abs/1607.03474)
- Residual Networks of Residual Networks- Multilevel Residual Networks. [`arxiv`](https://arxiv.org/abs/1608.02908)
- Revisiting Semi-Supervised Learning with Graph Embeddings. [`arxiv`](https://arxiv.org/abs/1603.08861) [`code`](https://github.com//kimiyoung/planetoid)
- Risk versus Uncertainty in Deep Learning: Bayes, Bootstrap and the Dangers of Dropout. [`pdf`](http://bayesiandeeplearning.org/papers/BDL_4.pdf)
- RNN-based Encoder-decoder Approach with Word Frequency Estimation. [`arxiv`](https://arxiv.org/abs/1701.00138)
- SampleRNN: An Unconditional End-To-End Neural Audio Generation Model. [`pdf`](https://openreview.net/pdf?id=HyJsPvcgg) [`code`](https://github.com/soroushmehr/sampleRNN_ICLR2017)
- Semantic3D.net: A new Large-scale Point Cloud Classification Benchmark.[`arxiv`](https://arxiv.org/abs/1704.03847) [`code`](https://github.com/nsavinov/semantic3dnet) 
- Semi-Supervised Classification with Graph Convolutional Networks. [`arxiv`](https://arxiv.org/abs/1609.02907)
- SoundNet: Learning Sound Representations from Unlabeled Video. [`pdf`](http://web.mit.edu/vondrick/soundnet.pdf) [`tensorflow`](https://github.com/eborboihuc/SoundNet-tensorflow) :star:
- Structured Receptive Fields in CNNs.  [`arxiv`](https://arxiv.org/abs/1605.02971v2) [`code`](https://github.com/jhjacobsen/RFNN)
- Tagger: Deep Unsupervised Perceptual Grouping.  [[url](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=3&cad=rja&uact=8&ved=0ahUKEwjp-razjufQAhWFLSYKHSF_CFcQFggsMAI&url=https%3A%2F%2Fpapers.nips.cc%2Fpaper%2F6067-tagger-deep-unsupervised-perceptual-grouping.pdf&usg=AFQjCNG2BMZI5bfamUYu5Kbba9EbDsc9mw)]
- Temporal Ensembling for Semi-Supervised Learning. [`arxiv`](https://arxiv.org/abs/1610.02242)  [`code`](https://github.com/smlaine2/tempens)
- TensorFlow- A system for large-scale machine learning. [`pdf`](http://download.tensorflow.org/paper/whitepaper2015.pdf) :star: 
- Tensors and algebra give interpretable groups for crosstalk mechanisms in breast cancer.[`arxiv`](https://arxiv.org/abs/1612.08116)
- The Inevitability of Probability- Probabilistic Inference in Generic Neural Networks Trained with Non-Probabilistic Feedback.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiAq9iqsNjQAhUEjpQKHUZjBq0QFggbMAA&url=https%3A%2F%2F128.84.21.199%2Fabs%2F1601.03060v1&usg=AFQjCNG5CeOHSBphHdIAmvp8U_iTvsBiEA)]
- The Predictron: End-To-End Learning and Planning. [`arxiv`](https://arxiv.org/abs/1612.08810) [`code`](https://github.com/zhongwen/predictron)
- Towards an integration of deep learning and neuroscience. [`arxiv`](https://arxiv.org/abs/1606.03813)
- Training Recurrent Neural Networks by Diffusion.  [`arxiv`](https://arxiv.org/abs/1601.04114)]
- Tutorial on Variational Autoencoders.[`arxiv`](https://arxiv.org/abs/1606.05908) :star: 
- Understanding Deep Convolutional Networks.  [`arxiv`](https://arxiv.org/abs/1601.04920) :star: 
- <b>[ICLR:Best Paper]</b> Understanding deep learning requires rethinking generalization. [`arxiv`](https://arxiv.org/abs/1611.03530) :star:
- Understanding deep learning requires rethinking generalization. [`arxiv`](https://arxiv.org/abs/1611.03530) [`code`](https://github.com/pluskid/fitting-random-labels) :star:
- Understanding Neural Networks through Representation Erasure. [`arxiv`](https://arxiv.org/abs/1612.08220)
- Unsupervised Perceptual Rewards for Imitation Learning.[`arxiv`](https://scirate.com/arxiv/1612.06699)]
- Using Fast Weights to Attend to the Recent Past. [`arxiv`](https://arxiv.org/abs/1610.06258) [`code`](https://github.com/jiamings/fast-weights)
- Value Iteration Networks. [`arxiv`](https://arxiv.org/abs/1602.02867) [`code`](https://github.com/karpathy/paper-notes/blob/master/vin.md)] :star: 
- Variable Computation in Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1611.06188)
- Visual Dynamics: Probabilistic Future Frame Synthesis via Cross Convolutional Networks. [`arxiv`](https://arxiv.org/abs/1607.02586) [`tensorflow`](https://github.com/tensorflow/models/tree/master/next_frame_prediction) :star:
- Weight Normalization-A Simple Reparameterization to Accelerate Training of Deep Neural Networks. [`arxiv`](https://arxiv.org/abs/1602.07868) [`code`](https://github.com/openai/weightnorm) :star: 
- Wide Residual Networks. [`arxiv`](https://arxiv.org/abs/1605.07146) [`pytorch`](https://github.com/xternalz/WideResNet-pytorch):star: 
- <b>[Xception]</b> Deep Learning with Depthwise Separable Convolutions. [`arxiv`](https://arxiv.org/abs/1610.02357v2) [`tensorflow`](https://github.com/fchollet/deep-learning-models/blob/master/xception.py) :star:
- Zoneout- Regularizing RNNs by Randomly Preserving Hidden Activations.  [`arxiv`](https://arxiv.org/abs/1606.01305) :star: 


### Attention and memory

- Attention Based Recurrent Neural Networks for Online Advertising. [`pdf`](http://www2016.net/proceedings/companion/p141.pdf)]
- Attention-Based Recurrent Neural Network Models for Joint Intent Detection and Slot Filling. [`arxiv`](https://arxiv.org/abs/1609.01454) [`tensorflow`](https://github.com/HadoopIt/rnn-nlu) :star:
- Can Active Memory Replace Attention? [`arxiv`](https://arxiv.org/abs/1610.08613)
- Deep Recurrent Models with Fast-Forward Connections for Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1606.04199) :star: 
- Emergent Logical Structure in Vector Representations of Neural Readers. [`arxiv`](https://arxiv.org/abs/1611.07954)
- Gated End-to-End Memory Networks. [`arxiv`](https://arxiv.org/abs/1610.04211)
- Generating Images from Captions with Attention. [`arxiv`](https://arxiv.org/abs/1511.02793)
- GRAM: Graph-based Attention Model for Healthcare Representation Learning. [`arxiv`](https://arxiv.org/abs/1611.07012) [`code`](https://github.com/mp2893/gram)
- Hybrid computing using a neural network with dynamic external memory. [`url`](https://news.ycombinator.com/item?id=12694779) :star: 
- Hierarchical Memory Networks. [`arxiv`](https://arxiv.org/abs/1605.07427)
- Knowing When to Look: Adaptive Attention via A Visual Sentinel for Image Captioning. [`arxiv`](https://arxiv.org/abs/1612.01887)
- <b>[LightRNN]</b> LightRNN: Memory and Computation-Efficient Recurrent Neural Networks.[`arxiv`](https://arxiv.org/abs/1610.09893) [`tensorflow`](https://github.com/YisenWang/LightRNN-NIPS2016-Tensorflow_code):star: 
- Paying More Attention to Attention: Improving the Performance of Convolutional Neural Networks via Attention Transfer. [`arxiv`](https://arxiv.org/abs/1612.03928) [`code`](https://github.com/szagoruyko/attention-transfer)
- Prioritizing Attention in Fast Data: Principles and Promise. [`pdf`](http://www.bailis.org/papers/fastdata-cidr2017.pdf)
- Recursive Recurrent Nets with Attention Modeling for OCR in the Wild. [`pdf`](http://www.cv-foundation.org/openaccess/content_cvpr_2016/papers/Lee_Recursive_Recurrent_Nets_CVPR_2016_paper.pdf) :star: 
- Reducing Redundant Computations with Flexible Attention. [`arxiv`](https://arxiv.org/abs/1612.06043)
- Scan, Attend and Read- End-to-End Handwritten Paragraph Recognition with MDLSTM Attention. [`arxiv`](https://arxiv.org/pdf/1604.03286.pdf)
- Structural Attention Neural Networks for improved sentiment analysis. [`arxiv`](https://arxiv.org/abs/1701.01811)
- Survey on the attention based RNN model and its applications in computer vision. [`arxiv`](https://arxiv.org/abs/1601.06823)

### Generative learning

- Adversarial Examples Detection in Deep Networks with Convolutional Filter Statistics. [`arxiv`](https://arxiv.org/abs/1612.07767)
- Adversarial examples in the physical world.[`arxiv`](https://arxiv.org/abs/1607.02533)
- Adversarially Learned Inference.[`arxiv`](https://arxiv.org/abs/1606.00704) [`code`](https://github.com/IshmaelBelghazi/ALI) :star: 
- Adversarial Multiclass Classification: A Risk Minimization Perspective. [`pdf`](https://www.cs.uic.edu/~rfathony/pdf/fathony2016adversarial.pdf) [`code`](https://github.com/rizalzaf/adversarial-multiclass)
- Adversarial Perturbations Against Deep Neural Networks for Malware Classification. [`arxiv`](https://arxiv.org/abs/1606.04435)
- Adversarial Training For Sketch Retrieval.[`arxiv`](https://arxiv.org/abs/1607.02748)
- A Point Set Generation Network for 3D Object Reconstruction from a Single Image. [`arxiv`](https://arxiv.org/abs/1612.00603) [`code`](https://github.com/fanhqme/PointSetGeneration)
- Automatic Description Generation from Images- A Survey of Models, Datasets, and Evaluation Measures. [`pdf`](https://www.jair.org/media/4900/live-4900-9139-jair.pdf)
- Automatic Colorization with Deep Convolutional Generative Adversarial Networks. [`stanford`](http://cs231n.stanford.edu/reports2016/224_Report.pdf)
- Auxiliary Deep Generative Models. [`arxiv`](https://arxiv.org/abs/1602.05473) [`code`](https://github.com/larsmaaloee/auxiliary-deep-generative-models) :star: 
- <b>[b-GAN]</b> Unified Framework of Generative Adversarial Networks. [`pdf`](https://openreview.net/pdf?id=S1JG13oee)] :star: 
- Conditional Image Synthesis With Auxiliary Classifier GANs. [`arxiv`](https://arxiv.org/abs/1610.09585) [`code`](https://github.com/lukedeo/keras-acgan)
- Connecting Generative Adversarial Networks and Actor-Critic Methods. [`arxiv`](https://arxiv.org/abs/1610.01945)
- Coupled Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1606.07536) [`code`](https://github.com/mingyuliutw/CoGAN)
- DARN: a Deep Adversial Residual Network for Intrinsic Image Decomposition. [`url`](https://128.84.21.199/abs/1612.07899?context=cs)
- DeMIAN: Deep Modality Invariant Adversarial Network. [[url](http://www.mathpubs.com/detail/1612.07976v1/DeMIAN-Deep-Modality-Invariant-Adversarial-Network)]
- Deep Learning Adversarial Examples. [`url`](http://www.kdnuggets.com/2015/07/deep-learning-adversarial-examples-misconceptions.html)
- DeepFace: Face Generation using Deep Learning. [`stanford`](http://cs231n.stanford.edu/reports2016/006_Report.pdf)
- Enabling Dark Energy Science with Deep Generative Models of Galaxy Images. [`arxiv`](https://arxiv.org/abs/1609.05796)
- <b>[EnergyGAN]</b> Energy-based Generative Adversarial Network. [`arxiv`](https://arxiv.org/pdf/1609.03126) [`code`](https://github.com/buriburisuri/ebgan) :star: 
- <b>[f-GAN]</b> f-GAN: Training Generative Neural Samplers using Variational Divergence Minimization.[`arxiv`](https://arxiv.org/abs/1606.00709) :star: 
- Generative Image Modeling using Style and Structure Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1603.05631)
- Generating Images Part by Part with Composite Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1607.05387)
- <b>[GRAN]</b> Generating images with recurrent adversarial networks. [`pdf`](https://pdfs.semanticscholar.org/c98e/9b2922a76b3cb3c3e8cfcda93c09c31ec5e6.pdf) :star: 
- Generating Images with Perceptual Similarity Metrics based on Deep Networks. [`arxiv`](https://arxiv.org/abs/1602.02644) :star:
- Generative Adversarial Imitation Learning.  [`arxiv`](https://arxiv.org/abs/1606.03476) [`code`](https://github.com/openai/imitation)
- <b>[VGNA]</b> Generative Adversarial Networks as Variational Training of Energy Based Models. [`arxiv`](https://arxiv.org/abs/1611.01799) [`code`](https://github.com/Shuangfei/vgan)
- Generative Adversarial Nets from a Density Ratio Estimation Perspective. [`arxiv`](https://arxiv.org/abs/1610.02920)
- <b>[iGNA]</b> Generative Visual Manipulation on the Natural Image Manifold. [`berkeley`](http://people.eecs.berkeley.edu/~junyanz/projects/gvm/) [`code`](https://github.com/junyanz/iGAN) :star: 
- Generating Videos with Scene Dynamics. [`pdf`](http://web.mit.edu/vondrick/tinyvideo/paper.pdf) [`code`](https://github.com/cvondrick/videogan) [`tensorflow`](https://github.com/Yuliang-Zou/tf_videogan):star:
- How to Train a GAN. [`code`](https://github.com/soumith/ganhacks) :star:
- <b>[Pix2Pix]</b>Image-to-Image Translation with Conditional Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1611.07004) [`tensorflow`](https://github.com/yenchenlin/pix2pix-tensorflow) :star:
- <b>[Improved GAN]</b> Image-Text Multi-Modal Representation Learning by Adversarial Backpropagation. [`arxiv`](https://arxiv.org/abs/1612.08354) :star: 
- [Improved Techniques for Training GANs.](http://blog.csdn.net/layumi1993/article/details/52413235)[`arxiv`](https://arxiv.org/abs/1606.03498) [`code`](https://github.com/openai/improved-gan) [`tensorflow`](https://github.com/shaohua0116/SSGAN-Tensorflow) :star: 
- <b>[InfoGAN]</b> [Interpretable Representation Learning by Information Maximizing Generative Adversarial Nets.](http://blog.csdn.net/Layumi1993/article/details/52474554) [`arxiv`](https://arxiv.org/abs/1606.03657) [`code`](https://github.com/tdeboissiere/DeepLearningImplementations/tree/master/InfoGAN) [`tensorflow`](https://github.com/buriburisuri/supervised_infogan) :star: 
- Learning a Probabilistic Latent Space of Object Shapes via 3D Generative-Adversarial Modeling. [`arxiv`](https://arxiv.org/abs/1610.07584) [`tensorflow`](https://github.com/meetshah1995/tf-3dgan)
- <b>[SimGAN]</b> Learning from Simulated and Unsupervised Images through Adversarial Training. [`arxiv`](https://arxiv.org/abs/1612.07828) [`keras`](https://github.com/wayaai/SimGAN) :star: 
- Learning in Implicit Generative Models. [`arxiv`](https://arxiv.org/abs/1610.03483)
- Learning to Protect Communications with Adversarial Neural Cryptography.  [`arxiv`](https://arxiv.org/abs/1610.06918)
- Least Squares Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1611.04076) :star:
- Medical Image Synthesis with Context-Aware Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1612.05362)
- Mode Regularized Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1612.02136) :star: 
- Neural Fill: Content Aware Image Fill with Generative Adversarial Neural Networks. [`stanford`](http://cs231n.stanford.edu/reports2016/209_Report.pdf)
- NIPS 2016 Tutorial: Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1701.00160) :star: 
- <b>[SRGAN]</b> Photo-Realistic Single Image Super-Resolution Using a Generative Adversarial Network. [`arxiv`](https://arxiv.org/abs/1609.04802) :star: 
- <b>[DCGAN use]</b> Semantic Image Inpainting with Perceptual and Contextual Losses.[`arxiv`](https://arxiv.org/abs/1607.07539) :star: 
- Semi-Supervised Learning with Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1606.01583)
- <b>[SeqGAN]</b> Sequence Generative Adversarial Nets with Policy Gradient. [`arxiv`](https://arxiv.org/abs/1609.05473) [`code`](https://github.com/LantaoYu/SeqGAN) :star: 
- Simple black-box adversarial perturbations for deep networks. [`url`](https://openreview.net/pdf?id=SJCscQcge)
- Stick-Breaking Variational Autoencoders. [`arxiv`](https://arxiv.org/abs/1605.06197) [`code`](https://github.com/enalisnick/stick-breaking_dgms)
- Stochastic Video Prediction with Deep Conditional Generative Models. [`stanford`](http://cs231n.stanford.edu/reports2016/215_Report.pdf)
- Task Specific Adversarial Cost Function. [`arxiv`](https://arxiv.org/abs/1609.08661)
- Temporal Generative Adversarial Nets with Singular Value Clipping. [`arxiv`](https://arxiv.org/abs/1611.06624) [`code`](https://github.com/pfnet-research/tgan)
- Towards Principled Methods for Training Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1701.04862)]
- [Understanding deep learning requires rethinking generalization.](https://theneuralperspective.com/2017/01/24/understanding-deep-learning-requires-rethinking-generalization/)[`arxiv`](https://arxiv.org/abs/1611.03530) :star:
- Unsupervised domain adaptation in brain lesion segmentation with adversarial networks.[`arxiv`](https://arxiv.org/abs/1612.08894v1) [`code`](https://github.com/Kamnitsask/deepmedic)
- Unrolled Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1611.02163) [`code`](https://github.com/poolio/unrolled_gan)
- Variational Graph Auto-Encoders. [`arxiv`](https://arxiv.org/abs/1611.07308) [`tensorflow`](https://github.com/tkipf/gae) :star:
  
  
### Transfer learning

- A survey of transfer learning. [`url`](https://link.springer.com/article/10.1186/s40537-016-0043-6) :star: 
- Building Machines That Learn and Think Like People. [`arxiv`](https://arxiv.org/abs/1604.00289)
- Fast color transfer from multiple images. [`arxiv`](https://arxiv.org/abs/1612.08927)
- Perceptual Losses for Real-Time Style Transfer and Super-Resolution.[`arxiv`](https://arxiv.org/abs/1603.08155) [`code`](https://github.com/jcjohnson/fast-neural-style) :star: 
- Personalizing a Dialogue System with Transfer Learning. [`arxiv`](https://arxiv.org/abs/1610.02891)
- Pixel-Level Domain Transfer. [`arxiv`](https://arxiv.org/abs/1603.07442)
- [Progressive Neural Networks.](http://www.cnblogs.com/wangxiaocvpr/p/6002214.html)  [`arxiv`](https://arxiv.org/abs/1606.04671) :star: 
- Semantic Style Transfer and Turning Two-Bit Doodles into Fine Artworks.[`arxiv`](https://arxiv.org/abs/1603.01768)[`code`](https://github.com/alexjc/neural-doodle) :star: 
- <b>[Best Paper]</b>Semi-supervised Knowledge Transfer for Deep Learning from Private Training Data. [`arxiv`](https://arxiv.org/abs/1610.05755) [`tensorflow`](https://github.com/tensorflow/models/tree/master/differential_privacy/multiple_teachers) :star:
- FastMask: Segment Multi-scale Object Candidates in One Shot.[`arxiv`](https://arxiv.org/abs/1612.08843)
- Learning feed-forward one-shot learners. [`arxiv`](https://arxiv.org/abs/1606.05233)
- Low-shot Visual Recognition by Shrinking and Hallucinating Features. [`arxiv`](https://arxiv.org/abs/1606.02819) :star: 
- Matching Networks for One Shot Learning. [`arxiv`](https://arxiv.org/abs/1606.04080)
- One-Shot Generalization in Deep Generative Models. [`pdf`](https://arxiv.org/pdf/1603.05106.pdf) :star: 
- One-shot Learning with Memory-Augmented Neural Networks. [`arxiv`](https://arxiv.org/abs/1605.06065) [`tensorflow`](https://github.com/hmishra2250/NTM-One-Shot-TF):star: 
- One-Shot Video Object Segmentation. [`arxiv`](https://arxiv.org/abs/1611.05198) [`tensorflow`](https://github.com/scaelles/OSVOS-TensorFlow)
- Tinkering Under the Hood: Interactive Zero-Shot Learning with Net Surgery. [`arxiv`](https://arxiv.org/abs/1612.04901)
