## 2015

### Deep Learning

- <b>[ADAM]</b> A Method for Stochastic Optimization. [`arxiv`](https://arxiv.org/pdf/1412.6980.pdf) :star: 
- A Diversity-Promoting Objective Function for Neural Conversation Models.[`acl`](http://www.aclweb.org/anthology/N16-1014)]
- A Neural Conversational Model. [`arxiv`](https://arxiv.org/pdf/1506.05869.pdf)
- A Neural Network Approach to Context-Sensitive Generation of Conversational Responses. [`acl`](http://www-etud.iro.umontreal.ca/~sordonia/pdf/naacl15.pdf)
- A Roadmap towards Machine Intelligence. [`arxiv`](https://arxiv.org/pdf/1511.08130.pdf)
- A Survey- Time Travel in Deep Learning Space- An Introduction to Deep Learning Models and How Deep Learning Models Evolved from the Initial Ideas.[`arxiv`](https://arxiv.org/abs/1510.04781)
- An Empirical Exploration of Recurrent Network Architectures.[`pdf`](http://proceedings.mlr.press/v37/jozefowicz15.pdf) :star: 
- <b>[Inception V2]</b> [Batch Normalization- Accelerating Deep Network Training by Reducing Internal Covariate Shift.](http://blog.csdn.net/happynear/article/details/44238541)  [`arxiv`](https://arxiv.org/abs/1502.03167) :star: 
- Building End-To-End Dialogue Systems Using Generative Hierarchical Neural Network Models. [`arxiv`](https://arxiv.org/pdf/1507.04808.pdf)
- Correlational Neural Networks. [`arxiv`](https://arxiv.org/abs/1504.07225) [`code`](https://github.com/GauravBh1010tt/DeepLearn/tree/master/corrnet)
- Deconstructing the Ladder Network Architecture. [`arxiv`](https://arxiv.org/pdf/1511.06430.pdf)
- Deep Compression: Compressing Deep Neural Networks with Pruning, Trained Quantization and Huffman Coding. [`arxiv`](https://arxiv.org/abs/1510.00149)
- Deep Knowledge Tracing. [`pdf`](https://web.stanford.edu/~cpiech/bio/papers/deepKnowledgeTracing.pdf)
- Deep learning. [`nature`](http://www.nature.com/nature/journal/v521/n7553/abs/nature14539.html) :star: 
- Distilling the Knowledge in a Neural Network. [`pdf`](https://www.cs.toronto.edu/~hinton/absps/distillation.pdf) :star: 
- Dropout as a Bayesian Approximation- Representing Model Uncertainty in Deep Learning. [`arxiv`](https://arxiv.org/pdf/1506.02142)
- Effective LSTMs for Target-Dependent Sentiment Classification. [`arxiv`](https://arxiv.org/abs/1512.01100)
- <b>[ELUs]</b> Fast and Accurate Deep Network Learning by Exponential Linear Units. [`arxiv`](https://arxiv.org/abs/1511.07289) :star:
- Human-level concept learning through probabilistic program induction [`science`](http://science.sciencemag.org/content/350/6266/1332) :star: 
- Learning Simple Algorithms from Examples. [`pdf`](http://proceedings.mlr.press/v48/zaremba16.pdf)
- Learning to Transduce with Unbounded Memory. [`arxiv`](https://arxiv.org/pdf/1506.02516.pdf)
- Listen, Attend and Spell. [`arxiv`](https://arxiv.org/abs/1508.01211v2) [`pytorch`](https://github.com/XenderLiu/Listen-Attend-and-Spell-Pytorch) :star:
- LSTM A Search Space Odyssey. [`arxiv`](https://arxiv.org/pdf/1503.04069.pdf) :star: 
- LSTM-based Deep Learning Models for non-factoid answer selection. [`arxiv`](https://arxiv.org/pdf/1511.04108.pdf)
- Neural GPUs Learn Algorithms. [`arxiv`](https://arxiv.org/abs/1511.08228) [`tensorflow`](https://github.com/tensorflow/models/tree/master/neural_gpu) :star:
- Neural Programmer- Inducing Latent Programs with Gradient Descent. [`pdf`](https://people.cs.umass.edu/~arvind/np.pdf)
- Pointer Networks. [`arxiv`](https://arxiv.org/abs/1506.03134) [`tensorflow`](https://github.com/devsisters/pointer-network-tensorflow) :star: 
- Poker-CNN- A Pattern Learning Strategy for Making Draws and Bets in Poker Games.[`pdf`](http://colinraffel.com/publications/aaai2016poker.pdf)
- Policy distillation. [`arxiv`](https://arxiv.org/abs/1511.06295) :star: 
- Regularizing RNNs by Stabilizing Activations. [`arxiv`](https://arxiv.org/pdf/1511.08400.pdf)
- ReNet- A Recurrent Neural Network Based Alternative to Convolutional Networks. [`arxiv`](https://arxiv.org/pdf/1505.00393.pdf)
- Semi-Supervised Learning with Ladder Networks. [`arxiv`](https://arxiv.org/pdf/1507.02672.pdf) :star: 
- Session-based Recommendations with Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1511.06939)
- Skip-Thought Vectors. [`arxiv`](https://arxiv.org/pdf/1506.06726.pdf) :star: 
- Training Very Deep Networks. [`arxiv`](https://arxiv.org/abs/1507.06228) :star: 
- Tree-structured composition in neural networks without tree-structured architectures. [`pdf`](http://ceur-ws.org/Vol-1583/CoCoNIPS_2015_paper_5.pdf)

### Computer vision

- A Neural Algorithm of Artistic Style. [`arxiv`](https://arxiv.org/abs/1508.06576) [`code`](https://github.com/titu1994/Neural-Style-Transfer) :star: 
- Autoencoding beyond pixels using a learned similarity metric. [`arxiv`](https://arxiv.org/abs/1512.09300) [`tensorflow`](https://github.com/zhangqianhui/vae-gan-tensorflow)
- Embed to Control: A Locally Linear Latent Dynamics Model for Control from Raw Images. [`arxiv`](https://arxiv.org/abs/1506.07365) [`pytorch`](https://github.com/ethanluoyc/e2c-pytorch)
- <b>[ResNet]</b> [Deep Residual Learning for Image Recognition](http://blog.csdn.net/cv_family_z/article/details/50328175). [`arxiv`](https://arxiv.org/abs/1512.03385) [`tensorflow`](https://github.com/tensorflow/models/tree/master/resnet) :star: 
- <b>[ResNet]</b> Delving Deep into Rectifiers- Surpassing Human-Level Performance on ImageNet Classification. [`arxiv`](https://arxiv.org/pdf/1502.01852.pdf) :star: 
- <b>[FaceNet]</b> [A Unified Embedding for Face Recognition and Clustering.](http://blog.csdn.net/chenriwei2/article/details/45031677) [`arxiv`](https://arxiv.org/abs/1503.03832) [`tensorflow`](https://github.com/davidsandberg/facenet) :star: 
- <b>[Faster R-CNN]</b> Towards Real-Time Object Detection with Region Proposal Networks. [`arxiv`](https://arxiv.org/abs/1506.01497) [`code`](https://github.com/rbgirshick/py-faster-rcnn) :star: 
- <b>[Fast R-CNN]</b> [Fast R-CNN](http://lib.csdn.net/article/deeplearning/53862?knId=1734) [`arxiv`](https://arxiv.org/abs/1504.08083) [`code`](https://github.com/rbgirshick/fast-rcnn) :star: 
- Hierarchical Recurrent Neural Network for Skeleton Based Action Recognition. [`pdf`](http://www.cv-foundation.org/openaccess/content_cvpr_2015/papers/Du_Hierarchical_Recurrent_Neural_2015_CVPR_paper.pdf) :star: 
- Inceptionism: Going Deeper into Neural Networks. [`google`](https://research.googleblog.com/2015/06/inceptionism-going-deeper-into-neural.html) :star: 
- Inside-Outside Net- Detecting Objects in Context with Skip Pooling and Recurrent Neural Networks. [`url`](http://image-net.org/challenges/talks/ion-coco-talk-bell2015.pdf)
- Multi-view 3D Models from Single Images with a Convolutional Network.[`arxiv`](https://arxiv.org/abs/1511.06702v2) [`tensorflow`](https://github.com/mtatarchenko/mv3d)
- ReSeg- A Recurrent Neural Network for Object Segmentation.  [`arxiv`](https://arxiv.org/pdf/1511.07053.pdf) :star: 
- <b>[Inception V3]</b> Rethinking the Inception Architecture for Computer Vision.  [`arxiv`](https://arxiv.org/abs/1512.00567) [`tensorflow`](https://github.com/tensorflow/models/tree/master/inception) :star: 
- Unsupervised Learning of Video Representations using LSTMs. [`arxiv`](https://arxiv.org/abs/1502.04681) [`tensorflow`](https://github.com/iwyoo/LSTM-autoencoder) :star:
- <b>[FCNT]</b> Visual Tracking with fully Convolutional Networks. [`cuhk`](http://www.ee.cuhk.edu.hk/~xgwang/papers/wangOWLiccv15.pdf) [`code`](https://github.com/scott89/FCNT) :star: 
- You Only Look Once: Unified, Real-Time Object Detection. [`arxiv`](https://arxiv.org/abs/1506.02640)
  

### Generative learning

- Adversarial Autoencoders. [`arxiv`](https://arxiv.org/abs/1511.05644)
- A note on the evaluation of generative models. [`arxiv`](https://arxiv.org/abs/1511.01844) :star: 
- Autoencoding beyond pixels using a learned similarity metric. [`arxiv`](https://arxiv.org/abs/1512.09300) :star:
- Censoring Representations with an Adversary. [`arxiv`](https://arxiv.org/abs/1511.05897)
- Conditional generative adversarial nets for convolutional face generation. [`pdf`](http://www.foldl.me/uploads/2015/conditional-gans-face-generation/paper.pdf)
- <b>[LAPGAN]</b> [Deep Generative Image Models using a Laplacian Pyramid of Adversarial Networks](http://blog.csdn.net/solomon1558/article/details/52562851) [`arxiv`](https://arxiv.org/abs/1506.05751) [`code`](https://github.com/facebook/eyescream) :star: 
- Distributional Smoothing with Virtual Adversarial Training. [`arxiv`](https://arxiv.org/abs/1507.00677) :star: 
- Exploring the Space of Adversarial Images. [`arxiv`](https://arxiv.org/abs/1510.05328) [`code`](https://github.com/tabacof/adversarial) :star: 
- Generative Adversarial Networks in Estimation of Distribution Algorithms for Combinatorial Optimization. [`arxiv`](https://arxiv.org/abs/1509.09235) [`code`](https://github.com/wohnjayne/eda-suite)
- Generative Image Modeling Using Spatial LSTMs. [`arxiv`](https://arxiv.org/abs/1506.03478)
- Generative Moment Matching Networks. [`arxiv`](https://arxiv.org/abs/1502.02761) :star: 
- Improving Semi-Supervised Learning with Auxiliary Deep Generative Models. [`pdf`](http://approximateinference.org/2015/accepted/MaaloeEtAl2015.pdf)
- <b>[CVAE]</b> Learning Structured Output Representation using Deep Conditional Generative Models. [`nips`](https://papers.nips.cc/paper/5775-learning-structured-output-representation-using-deep-conditional-generative-models)  :star: 
- Max-margin Deep Generative Models. [`arxiv`](https://arxiv.org/abs/1504.06787) [`code`](https://github.com/zhenxuan00/mmdgm)
- Semi-Supervised Learning with Ladder Networks. [`arxiv`](https://arxiv.org/abs/1507.02672) :star: 
- <b>[CatGAN]</b> Unsupervised and Semi-supervised Learning with Categorical Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1511.06390) :star: 
- <b>[DCGAN]</b> [Unsupervised Representation Learning with Deep Convolutional Generative Adversarial Networks](http://blog.csdn.net/solomon1558/article/details/52573596). [`arxiv`](https://arxiv.org/abs/1511.06434) [`tensorflow`](https://github.com/carpedm20/DCGAN-tensorflow) :star: 

### Attention and memory

- <b>[ABCNN]</b> Attention-Based Convolutional Neural Network for Modeling Sentence Pairs. [`arxiv`](https://arxiv.org/abs/1512.05193) :star: 
- Action Recognition using Visual Attention. [`arxiv`](https://arxiv.org/abs/1511.04119) [`code`](https://github.com/kracwarlock/action-recognition-visual-attention)
- Ask Me Anything- Dynamic Memory Networks for Natural Language Processing. [`arxiv`](https://arxiv.org/pdf/1506.07285.pdf) :star: 
- Attention-Based Models for Speech Recognition. [`arxiv`](https://arxiv.org/abs/1506.07503)
- Attention with Intention for a Neural Network Conversation Model. [`arxiv`](https://arxiv.org/pdf/1510.08565.pdf)]
- <b>[VAE with attention]</b> A Recurrent Neural Network For Image Generation.[`arxiv`](https://arxiv.org/abs/1502.04623) [`code`](https://github.com/ericjang/draw) :star: 
- Show, Attend and Tell- Neural Image Caption Generation with Visual Attention. [`arxiv`](https://arxiv.org/pdf/1502.03044.pdf) :star: 
- Agreement-based Joint Training for Bidirectional Attention-based Neural Machine Translation. [`arxiv`](https://arxiv.org/abs/1512.04650) 
- Ask Me Anything: Dynamic Memory Networks for Natural Language Processing. [`arxiv`](https://arxiv.org/abs/1506.07285) :star: 
- A Neural Attention Model for Sentence Summarization. [`pdf`](https://www.aclweb.org/anthology/D/D15/D15-1044.pdf) :star: 
- <b>[Global And Local Attention]</b> [Effective Approaches to Attention-based Neural Machine Translation.](http://blog.csdn.net/u011414416/article/details/51057789)[`arxiv`](https://arxiv.org/abs/1508.04025) [`code`](https://github.com/lmthang/nmt.matlab) [`tensorflow`](https://github.com/giancds/tsf_nmt) :star: 
- End-to-End Attention-based Large Vocabulary Speech Recognition. [`arxiv.`](https://arxiv.org/pdf/1508.04395.pdf)
- End-To-End Memory Networks. [`arxiv`](https://arxiv.org/abs/1503.08895) :star: 
- Grammar as a Foreign Language. [`arxiv`](https://arxiv.org/abs/1412.7449) :star: 
- Large-scale Simple Question Answering with Memory Networks. [`arxiv`](https://arxiv.org/abs/1506.02075)
- Learning Deep Neural Network Policies with Continuous Memory States. [`arxiv`](http://arxiv.org/abs/1507.01273)
- <b>[LAS]</b> Listen, Attend and Spell. [`arxiv`](https://arxiv.org/abs/1508.01211) :star:
- Listen, Attend, and Walk: Neural Mapping of Navigational Instructions to Action Sequences. [`arxiv`](http://arxiv.org/abs/1506.04089) :star: 
- Memory-based control with recurrent neural networks. [`arxiv`](http://arxiv.org/abs/1512.04455)
- Not All Contexts Are Created Equal: Better Word Representations with Variable Attention. [`pdf`](https://www.cs.cmu.edu/~lingwang/papers/emnlp2015-2.pdf)
- Reinforcement Learning Neural Turing Machines. [`arxiv`](https://arxiv.org/abs/1505.00521) :star: 
- <b>[Soft And Hard Attention]</b> Show, Attend and Tell: Neural Image Caption Generation with Visual Attention. [`arxiv`](https://arxiv.org/abs/1502.03044) [`code`](https://github.com/kelvinxu/arctic-captions) [`tensorflow`](https://github.com/yunjey/show-attend-and-tell-tensorflow) :star:
- Teaching Machines to Read and Comprehend. [`arxiv`](https://arxiv.org/abs/1506.03340) :star: 
- Video Description Generation Incorporating Spatio-Temporal Features and a Soft-Attention Mechanism. [`arxiv`](https://128.84.21.199/abs/1502.08029v1)

### Transfer learning

- Heterogeneous defect prediction. [`pdf`](http://www.cs.ust.hk/~hunkim/papers/nam-HDP-fse2015.pdf)
- Learning Transferred Weights From Co-Occurrence Data for Heterogeneous Transfer Learning. [`pdf`](http://ieeexplore.ieee.org/document/7243354/)
- Net2Net-Accelerating Learning via Knowledge Transfer. [`arxiv`](https://arxiv.org/abs/1511.05641) :star: 
- Siamese Neural Networks for One-shot Image Recognition. [`pdf`](http://www.cs.cmu.edu/~rsalakhu/papers/oneshot1.pdf)
- [Spatial Transformer Networks.](http://blog.csdn.net/shaoxiaohu1/article/details/51809605) [`arxiv`](https://arxiv.org/abs/1506.02025) [`tensorflow`](https://github.com/tensorflow/models/tree/master/transformer) :star: 
- Transfer Learning from Deep Features for Remote Sensing and Poverty Mapping. [`arxiv`](https://arxiv.org/abs/1510.00098)
- Transfer learning using computational intelligence: A survey. [`pdf`](https://pdfs.semanticscholar.org/21bb/ec954226c5fdf53560cb072188a18051683c.pdf)
- Transfer learning used to analyze the dynamic evolution of the dust aerosol. [`url`](https://www.researchgate.net/publication/272403336_Transfer_learning_used_to_analyze_the_dynamic_evolution_of_the_dust_aerosol)
- Transferring Rich Feature Hierarchies for Robust Visual Tracking. [`arxiv`](https://arxiv.org/abs/1501.04587) :star: 


### Deep reinforcement learning

- ADAAPT: A Deep Architecture for Adaptive Policy Transfer from Multiple Sources. [`arxiv`](http://arxiv.org/abs/1510.02879)
- Action-Conditional Video Prediction using Deep Networks in Atari Games. [`arxiv`](http://arxiv.org/abs/1507.08750) :star: 
- Actor-Mimic: Deep Multitask and Transfer Reinforcement Learning. [`arxiv`](https://arxiv.org/abs/1511.06342) :star: 
- <b>[DDPG]</b> Continuous control with deep reinforcement learning. [`arxiv`](https://arxiv.org/abs/1509.02971) :star: 
- <b>[NAF]</b> Continuous Deep Q-Learning with Model-based Acceleration. [`arxiv`](https://arxiv.org/abs/1603.00748) :star: 
- Dueling Network Architectures for Deep Reinforcement Learning.  [`arxiv`](http://arxiv.org/abs/1511.06581) :star: 
- Deep Reinforcement Learning with an Action Space Defined by Natural Language.[`arxiv`](http://arxiv.org/abs/1511.04636)
- Deep Reinforcement Learning with Double Q-learning. [`arxiv`](http://arxiv.org/abs/1509.06461) :star: 
- Deep Recurrent Q-Learning for Partially Observable MDPs. [`arxiv`](http://arxiv.org/abs/1507.06527) :star: 
- DeepMPC: Learning Deep Latent Features for Model Predictive Control. [`pdf`](http://deepmpc.cs.cornell.edu/DeepMPC.pdf)
- Deterministic Policy Gradient Algorithms. [`pdf`](http://jmlr.org/proceedings/papers/v32/silver14.pdf) :star: 
- Dueling Network Architectures for Deep Reinforcement Learning. [`arxiv`](https://arxiv.org/abs/1511.06581)
- End-to-End Training of Deep Visuomotor Policies. [`arxiv`](http://arxiv.org/abs/1504.00702) :star: 
- Giraffe: Using Deep Reinforcement Learning to Play Chess. [`arxiv`](http://arxiv.org/abs/1509.01549)
- Generating Text with Deep Reinforcement Learning. [`arxiv`](http://arxiv.org/abs/1510.09202)
- How to Discount Deep Reinforcement Learning: Towards New Dynamic Strategies. [`arxiv`](http://arxiv.org/abs/1512.02011)
- Human-level control through deep reinforcement learning.  [`nature`](http://www.nature.com/nature/journal/v518/n7540/pdf/nature14236.pdf) :star: 
- Incentivizing Exploration In Reinforcement Learning With Deep Predictive Models. [`arxiv`](http://arxiv.org/abs/1507.00814) :star: 
- Learning Simple Algorithms from Examples.  [`arxiv`](http://arxiv.org/abs/1511.07275)
- Language Understanding for Text-based Games Using Deep Reinforcement Learning. [`pdf`](http://people.csail.mit.edu/karthikn/pdfs/mud-play15.pdf) :star: 
- Learning Continuous Control Policies by Stochastic Value Gradients.[`pdf`](http://papers.nips.cc/paper/5796-learning-continuous-control-policies-by-stochastic-value-gradients.pdf) :star: 
- Multiagent Cooperation and Competition with Deep Reinforcement Learning. [`arxiv`](http://arxiv.org/abs/1511.08779)
- Maximum Entropy Deep Inverse Reinforcement Learning. [`arxiv`](http://arxiv.org/abs/1507.04888)
- Massively Parallel Methods for Deep Reinforcement Learning.  [`pdf`](http://www0.cs.ucl.ac.uk/staff/d.silver/web/Publications_files/gorila.pdf)] :star: 
- On Learning to Think- Algorithmic Information Theory for Novel Combinations of Reinforcement Learning Controllers and Recurrent Neural World Models.  [`arxiv`](https://arxiv.org/pdf/1511.09249)
- Playing Atari with Deep Reinforcement Learning. [`arxiv`](https://arxiv.org/abs/1312.5602)
- Recurrent Reinforcement Learning: A Hybrid Approach. [`arxiv`](http://arxiv.org/abs/1509.03044)
- Strategic Dialogue Management via Deep Reinforcement Learning. [`arxiv`](http://arxiv.org/abs/1511.08099)
- Towards Vision-Based Deep Reinforcement Learning for Robotic Motion Control. [`arxiv`](http://arxiv.org/abs/1511.03791)
- Trust Region Policy Optimization. [`pdf`](http://jmlr.org/proceedings/papers/v37/schulman15.pdf) :star: 
- Universal Value Function Approximators. [`pdf`](http://schaul.site44.com/publications/uvfa.pdf)
- Variational Information Maximisation for Intrinsically Motivated Reinforcement Learning. [`arxiv`](http://arxiv.org/abs/1509.08731)

### Natural language process

- A Primer on Neural Network Models for Natural Language Processing. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjr-I3b-9LQAhVEVbwKHVo8A70QFggsMAE&url=http%3A%2F%2Fcs.biu.ac.il%2F~yogo%2Fnnlp.pdf&usg=AFQjCNEZEkggUYseGdLhpFy_iG5mBA3X9g)]
- A Unified Tagging Solution- Bidirectional LSTM Recurrent Neural Network with Word Embedding.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwj-t_LG_NLQAhVES7wKHWTtCmIQFgguMAE&url=https%3A%2F%2Farxiv.org%2Fpdf%2F1511.00215&usg=AFQjCNECqO7dKUb1L7bkvFFR_8-hgPy52w)]
- Alternative structures for character-level RNNs. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwiyx_iZ_dLQAhUBT7wKHUE0A38QFggqMAE&url=http%3A%2F%2Fwww.di.ens.fr%2F~bojanowski%2Fpapers%2Fbojanowski16alternative.pdf&usg=AFQjCNF0ds1vVOijyqtBX-g_s9x8OedIbg)]
- Ask Me Anything- Dynamic Memory Networks for Natural Language Processing. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwiH8Kjf_dLQAhXIxLwKHU7QAb8QFggpMAE&url=https%3A%2F%2Farxiv.org%2Fpdf%2F1506.07285&usg=AFQjCNFjdb3GPe1IrNPSh8zevJazf58JwQ)] :star: 
- BlackOut- Speeding up Recurrent Neural Network Language Models With Very Large Vocabularies. [`arxiv`](https://arxiv.org/abs/1511.06909)
- Character-Aware Neural Language Models. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjJ7JjA_9LQAhVDwLwKHbmaCskQFgguMAE&url=https%3A%2F%2Farxiv.org%2Fpdf%2F1508.06615&usg=AFQjCNG3RqYNgZfsn7zIez3SEzwB70cEKg)] :star: 
- Character-level Convolutional Networks for Text Classification.[[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwiE5qTl_9LQAhUEWLwKHcHaDQgQFggsMAE&url=https%3A%2F%2Fpapers.nips.cc%2Fpaper%2F5782-character-level-convolutional-networks-for-text-classification.pdf&usg=AFQjCNFInMceTBvIU8_8XmtKfoizKGpOVA)]
- Deep Speech 2- End-to-End Speech Recognition in English and Mandarin.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwi5uvCDgdPQAhVFwLwKHSJ6B0MQFggvMAE&url=http%3A%2F%2Fjmlr.org%2Fproceedings%2Fpapers%2Fv48%2Famodei16.pdf&usg=AFQjCNFE5u2Xu81DH2gQUoyHVtC4AzLhYg)] :star: 
- Deep Unordered Composition Rivals Syntactic Methods for Text Classification. [`pdf`](http://cs.umd.edu/~miyyer/pubs/2015_acl_dan.pdf) [`code`](https://github.com/miyyer/dan)
- Distributed Representations of Sentences and Documents. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjf2ZyrgtPQAhWJvrwKHTV4BqsQFgguMAE&url=http%3A%2F%2Fcs.stanford.edu%2F~quocle%2Fparagraph_vector.pdf&usg=AFQjCNESECVF_9eXAkAjfSqqHrqlxkVQgg)] :star: 
- Dynamic Capacity Networks.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwiN_Yj0gtPQAhVPQLwKHVz0BZwQFgguMAE&url=https%3A%2F%2Farxiv.org%2Fpdf%2F1511.07838&usg=AFQjCNFR0AEK2z-pT8ulDl98QWXP0M3fCw)]
- Exploring Models and Data for Image Question Answering. [`arxiv`](https://arxiv.org/abs/1505.02074) [`tensorflow`](https://github.com/paarthneekhara/neural-vqa-tensorflow)
- From Word Embeddings To Document Distances. [`pdf`](http://www.cs.cornell.edu/~kilian/papers/wmd_metric.pdf) [`code`](https://github.com/src-d/wmd-relax)
- Improved Semantic Representations From Tree-Structured Long Short-Term Memory Networks. [`arxiv`](https://arxiv.org/abs/1503.00007) [`pytorch`](https://github.com/dasguptar/treelstm.pytorch) :star:
- Improved Transition-Based Parsing by Modeling Characters instead of Words with LSTMs. [`acl`](https://www.aclweb.org/anthology/D/D15/D15-1041.pdf)
- Larger-Context Language Modeling. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjHlvWshNPQAhWLybwKHTiuB-0QFgguMAE&url=https%3A%2F%2Farxiv.org%2Fpdf%2F1511.03729&usg=AFQjCNG88NnFeKSPKis1dVnVNYa0Tu50Gw)]
- [Multi-Perspective Sentence Similarity Modeling with Convolutional Neural Networks.](http://www.jeyzhang.com/cnn-apply-on-modelling-sentence.html) [`pdf`](http://ttic.uchicago.edu/~kgimpel/papers/he+etal.emnlp15.pdf) [`code`](https://github.com/tonyabracadabra/Multi-Perspective-Sentence-Similarity-Modeling-with-CNN)
- Multi-task Sequence to Sequence Learning. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwiu7MbphdPQAhWDUrwKHeo3DO8QFggpMAE&url=http%3A%2F%2Fjan.stanford.edu%2Fpubs%2Fluong2016iclr_multi.pdf&usg=AFQjCNGYWAqWnjbi6p3ZXWe0hBcNMSWawA)]
- Natural Language Understanding with Distributed Representation.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjhm4yThtPQAhWJVrwKHY-fDusQFggiMAA&url=https%3A%2F%2Farxiv.org%2Fabs%2F1511.07916&usg=AFQjCNEXqHl1eNACFv-e99vq-omz4TcY_Q)]
- Neural Machine Translation of Rare Words with Subword Units. [`arxiv`](https://arxiv.org/abs/1508.07909)
- Neural Responding Machine for Short-Text Conversation. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwiT-aOMntPQAhXHwbwKHXcqAzYQFggpMAE&url=https%3A%2F%2Farxiv.org%2Fpdf%2F1503.02364&usg=AFQjCNETeT0aqPYSdo-fP-DYyl7WZg2BqQ)]
- Part-of-Speech Tagging with Bidirectional Long Short-Term Memory Recurrent Neural Network. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwigxZnPntPQAhUCybwKHRJrCc8QFggiMAA&url=https%3A%2F%2Farxiv.org%2Fabs%2F1510.06168&usg=AFQjCNEIDEbarhumVAtwYDPin-r5-10mSQ)]
- Conditional Random Fields as Recurrent Neural Networks. [`arxiv`](https://arxiv.org/pdf/1502.03240.pdf) :star:
- Reading Scene Text in Deep Convolutional Sequences. [[url](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjnwcaJpY7RAhVnwlQKHdQhBMkQFggrMAE&url=https%3A%2F%2Farxiv.org%2Fpdf%2F1506.04395&usg=AFQjCNFwWEe1FlLYwTvy5JrYCme9M_QREA)]
- Recurrent Convolutional Neural Networks for Text Classification. [`pdf`](http://www.aaai.org/ocs/index.php/AAAI/AAAI15/paper/download/9745/9552) [`code`](https://github.com/knok/rcnn-text-classification) :star:
- Semi-supervised Sequence Learning. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwj28pOnodPQAhUJT7wKHb_eDpIQFggiMAA&url=https%3A%2F%2Fpapers.nips.cc%2Fpaper%2F5949-semi-supervised-sequence-learning.pdf&usg=AFQjCNFi_8bOPu361mtaI13MWB_aHDlspg)]
- Semantically Conditioned LSTM-based Natural Language Generation for Spoken Dialogue Systems. [`arxiv`](https://arxiv.org/abs/1508.01745)
- sense2vec - A Fast and Accurate Method for Word Sense Disambiguation In Neural Word Embeddings. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=4&cad=rja&uact=8&ved=0ahUKEwiQ_aHDodPQAhUITLwKHYP2B2kQFgg5MAM&url=https%3A%2F%2Fpdfs.semanticscholar.org%2F36f9%2F886ad1cb9ee3f66c5af0282ae7a3359b86b2.pdf&usg=AFQjCNE7oWW1uaAuK2skjRUnPXhykGFeMw)]
- Sequence Level Training with Recurrent Neural Networks. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjEgIbnodPQAhUKyrwKHXJICVUQFgghMAA&url=https%3A%2F%2Farxiv.org%2Fabs%2F1511.06732&usg=AFQjCNGEymvqFAIJnyEUAh0Ok7dImTDJjg)]
- Strategies for Training Large Vocabulary Neural Language Models. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjE1KCTo9PQAhXHwrwKHeTfDZ8QFggsMAE&url=http%3A%2F%2Fwww.aclweb.org%2Fanthology%2FP%2FP16%2FP16-1186.pdf&usg=AFQjCNGUJ0zFy2G4j9x9enwYuu2iTN5cig)]
- Towards Universal Paraphrastic Sentence Embeddings. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjM-u3Jo9PQAhUDbrwKHXETBuAQFggtMAE&url=http%3A%2F%2Fttic.uchicago.edu%2F~wieting%2Fwieting2016ICLR.pdf&usg=AFQjCNFMW6NpxCP9FMXpati4GbmkkCgPWQ)]
- Visualizing and Understanding Neural Models in NLP. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=3&cad=rja&uact=8&ved=0ahUKEwjszoDFpNPQAhWIxbwKHYlEAV0QFgg2MAI&url=https%3A%2F%2Fweb.stanford.edu%2F~jurafsky%2Fpubs%2Fvisualizing16.pdf&usg=AFQjCNECNXN2Cf42XcZokv2o5sE6RNM41Q)]
