## 2014

### Deep Learning

- A survey of multiple classifier systems as hybrid systems. [`science`](http://www.sciencedirect.com/science/article/pii/S156625351300047X) :star:
- A survey on feature selection methods. [`science`](http://www.sciencedirect.com/science/article/pii/S0045790613003066) :star:
- <b>[DeepFaceVariant]</b> [Deep Learning Face Representation from Predicting 10,000 Classes.](http://www.ifight.me/197/) [[pdf](http://mmlab.ie.cuhk.edu.hk/pdf/YiSun_CVPR14.pdf)] [[code](https://github.com/joyhuang9473/deepid-implementation)] :star: 
- Dropout: A Simple Way to Prevent Neural Networks from Overfitting. [[pdf](https://www.cs.toronto.edu/~hinton/absps/JMLRdropout.pdf)]
- Generative Moment Matching Networks. [[arxiv](https://arxiv.org/abs/1502.02761)] [[code](https://github.com/yujiali/gmmn)]
- <b>[Inception V1]</b> [Going Deeper with Convolutions](http://blog.csdn.net/u014114990/article/details/50370446). [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjHpOvi5NDQAhUCxLwKHU4BBM8QFgguMAE&url=https%3A%2F%2Fwww.cs.unc.edu%2F~wliu%2Fpapers%2FGoogLeNet.pdf&usg=AFQjCNHSEJVb0PWLBIG-Y-zWh9gRv9ehBQ)] :star: 
- Learning Longer Memory in Recurrent Neural Networks. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwiOkqOu5dDQAhVFa7wKHc7pCdgQFggsMAE&url=https%3A%2F%2Farxiv.org%2Fpdf%2F1412.7753&usg=AFQjCNEz4_vREocEuriflTVFg0GrMmaqfw)]
- Learning to Execute. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiVoZuO5tDQAhWJwLwKHVouD40QFggdMAA&url=https%3A%2F%2Farxiv.org%2Fabs%2F1410.4615&usg=AFQjCNEXYyZHLwwTzovP3pHsWa_jxvWvEQ)]
- [Multi-scale Orderless Pooling of Deep Convolutional Activation Features.](http://blog.csdn.net/happyer88/article/details/51418059) [`arxiv`](https://arxiv.org/abs/1403.1840) :star:
- [Network In Network](http://blog.csdn.net/hjimce/article/details/50458190). [`arxiv`](https://arxiv.org/abs/1312.4400)] :star: 
- <b>[OverFeat]</b> [OverFeat: Integrated Recognition, Localization and Detection using Convolutional Networks.](http://blog.csdn.net/whiteinblue/article/details/43374195) [`arxiv`](https://arxiv.org/abs/1312.6229)] [`code`](https://github.com/sermanet/OverFeat) :star: 
- Recurrent Neural Network Regularization. [`arxiv`](https://arxiv.org/abs/1409.2329) [`tensorflow`](https://github.com/tensorflow/models/tree/master/tutorials/rnn/ptb) :star:
- Show and Tell: A Neural Image Caption Generator.[[url](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjL6s6Xn47RAhVlqVQKHaynDI4QFggnMAE&url=%68%74%74%70%73%3a%2f%2f%61%72%78%69%76%2e%6f%72%67%2f%70%64%66%2f%31%34%31%31%2e%34%35%35%35&usg=AFQjCNEawcm4ZOK9ZVIgCjylPb2HY1UOug)] :star: 
- <b>[SPPNet]</b> [Spatial Pyramid Pooling in Deep Convolutional Networks for Visual Recognition.](http://blog.csdn.net/whiteinblue/article/details/43415035) [`arxiv`](https://arxiv.org/abs/1406.4729) [`keras`](https://github.com/yhenon/keras-spp) :star: 
- Striving for Simplicity: The All Convolutional Net. [[arxiv](https://arxiv.org/abs/1412.6806)] :star: 
- Towards end-to-end speech recognition with recurrent neural networks.[[pdf](http://jmlr.org/proceedings/papers/v32/graves14.pdf)] :star: 
- <b>[VGGNet]</b> [Very Deep Convolutional Networks for Large-Scale Image Recognition](http://www.cnblogs.com/xuanyuyt/p/5743758.html). [`arxiv`](https://arxiv.org/abs/1409.1556) [`code`](https://gist.github.com/ksimonyan/211839e770f7b538e2d8) :star: 
- What Regularized Auto-Encoders Learn from the Data. [`arxiv`](https://arxiv.org/pdf/1211.4246.pdf)

### Generative learning

- <b>[GAN]</b> [Generative Adversarial Nets.](http://blog.csdn.net/solomon1558/article/details/52549409) [`arxiv`](https://arxiv.org/abs/1406.2661) [`code`](https://github.com/goodfeli/adversarial) :star: 
- <b>[CGNA]</b> [Conditional Generative Adversarial Nets.](http://blog.csdn.net/solomon1558/article/details/52555083) [`arxiv`](https://arxiv.org/abs/1411.1784) [`code`](https://github.com/zhangqianhui/Conditional-Gans) :star: 
- Deep Visual-Semantic Alignments for Generating Image Descriptions. [`arxiv`](https://arxiv.org/abs/1412.2306) :star: 
- Explaining and Harnessing Adversarial Examples. [`arxiv`](https://arxiv.org/abs/1412.6572)
- On distinguishability criteria for estimating generative models. [`arxiv`](https://arxiv.org/abs/1412.6515)
- <b>[VAE]</b> Semi-Supervised Learning with Deep Generative Models. [`arxiv`](https://arxiv.org/abs/1406.5298) [`code`](https://github.com/dpkingma/nips14-ssl) [`tensorflow`](https://github.com/hwalsuklee/tensorflow-mnist-CVAE) :star: 
    
### Attention and memory

- End-to-end Continuous Speech Recognition using Attention-based Recurrent NN: First Results. [[arxiv](https://arxiv.org/abs/1412.1602)]
- Memory Networks. [[arxiv](https://arxiv.org/abs/1410.3916)] :star: 
- [Multiple Object Recognition with Visual Attention.](http://www.cnblogs.com/wangxiaocvpr/p/5559961.html) [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjW5KK95tDQAhVEbbwKHU3yC40QFgguMAE&url=https%3A%2F%2Farxiv.org%2Fpdf%2F1412.7755&usg=AFQjCNEdl2iMZSeK_mYsIKs8HXm4yI6zKQ)]
- <b>[Attention In NLP First]</b> [Neural Machine Translation by Jointly Learning to Align and Translate.](http://blog.csdn.net/u011414416/article/details/51057789) [[arxiv](https://arxiv.org/abs/1409.0473)] [[code](https://github.com/spro/torch-seq2seq-attention)] :star: 
- <b>[First Memory Paper]</b> Neural Turing Machines. [[arxiv](https://arxiv.org/abs/1410.5401)] :star: 
- <b>[RAM]</b> [Recurrent Models of Visual Attention.](http://www.cnblogs.com/wangxiaocvpr/p/5537454.html)  [[arxiv](https://arxiv.org/abs/1406.6247)] [[tensorflow](https://github.com/jlindsey15/RAM)] :star: 
- <b>[Seq2Seq]</b> Sequence to Sequence Learning with Neural Networks.  [[arxiv](https://arxiv.org/abs/1409.3215)] [[code](https://github.com/farizrahman4u/seq2seq)] :star: 

### Deep Reinforcement Learning

- Deep Learning for Real-Time Atari Game Play Using Offline Monte-Carlo Tree Search Planning.[[url](http://papers.nips.cc/paper/5421-deep-learning-for-real-time-atari-game-play-using-offline-monte-carlo-tree-search-planning.pdf)]

### Transfer learning

- Adaptation regularization: a general framework for transfer learning. [[pdf](http://www3.ntu.edu.sg/home/sinnopan/publications/[TKDE14]Adaptation%20Regularization%20A%20General%20Framework%20for%20Transfer%20Learning.pdf)] :star: 
- Heterogeneous Domain Adaptation for Multiple Classes. [[pdf](http://jmlr.org/proceedings/papers/v33/zhou14.pdf)]
- How transferable are features in deep neural networks? [`arxiv`](https://arxiv.org/abs/1411.1792)
- Hybrid heterogeneous transfer learning through deep learning. [[pdf](http://www.ntu.edu.sg/home/sinnopan/publications/[AAAI14]Hybrid%20Heterogeneous%20Transfer%20Learning%20through%20Deep%20Learning.pdf)]
- Learning with Augmented Features for Supervised and Semi-supervised Heterogeneous Domain Adaptation. [[pdf](http://lxduan.info/papers/LiTPAMI2014.pdf)]
- Machine learning for targeted display advertising: transfer learning in action. [[url](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiZr8H5uY7RAhXJq1QKHUocC64QFggfMAA&url=http%3A%2F%2Fdstillery.com%2Fwp-content%2Fuploads%2F2014%2F05%2FMachine-learning_target-display.pdf&usg=AFQjCNGDcM3pAUJ9-ZL7i0ujCUIWHenABQ)]
- Source Free Transfer Learning for Text Classification. [[pdf](http://www.cse.ust.hk/~yinz/SourceFreeTransferLearningforTextClassification.pdf)]

### Natural language process

- [A Convolutional Neural Network for Modelling Sentences.](http://www.jeyzhang.com/cnn-apply-on-modelling-sentence.html) [`arxiv`](https://arxiv.org/abs/1404.2188) [`code`](https://github.com/FredericGodin/DynamicCNN) :star:
- Automatic Construction and Natural-Language Description of Nonparametric Regression Models. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwj3xcWb49DQAhWIw7wKHSXFCfEQFggrMAE&url=http%3A%2F%2Fwww.aaai.org%2Focs%2Findex.php%2FAAAI%2FAAAI14%2Fpaper%2FviewFile%2F8240%2F8564&usg=AFQjCNFyni0wwo38CsLRVtSPMm6BlL7QpA)]
- [Convolutional Neural Networks for Sentence Classification.](https://arxiv.org/abs/1408.5882) [`arxiv`](https://arxiv.org/abs/1408.5882) [`tensorflow`](https://github.com/abhaikollara/CNN-Sentence-Classification) :star:
- Distributed Representations of Sentences and Documents Generating Distribution. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiulvPb49DQAhUGbrwKHeFRAlsQFggiMAA&url=http%3A%2F%2Fcs.stanford.edu%2F~quocle%2Fparagraph_vector.pdf&usg=AFQjCNESECVF_9eXAkAjfSqqHrqlxkVQgg)] :star: 
- Effective Use of Word Order for Text Categorization with Convolutional Neural Networks. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwiIl7qS5NDQAhVD2LwKHct_CVYQFggpMAE&url=https%3A%2F%2Farxiv.org%2Fpdf%2F1412.1058&usg=AFQjCNHDPOYHMKWIhirkznqnLq_mw4CqMQ)]
- Grammar as a Foreign Language. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwitq9CI5dDQAhXCu7wKHTUIBiAQFggpMAE&url=https%3A%2F%2Fpapers.nips.cc%2Fpaper%2F5635-grammar-as-a-foreign-language.pdf&usg=AFQjCNELENZf9OsnZ6q0LexQYcbjCHBv0w)]
- <b>[GRU]</b> [Learning Phrase Representations using RNN Encoder-Decoder for Statistical Machine Translation](http://www.zmonster.me/notes/phrase_representation_using_rnn_encoder_decoder.html). [`arxiv`](https://arxiv.org/abs/1406.1078) :star: 
- On the Properties of Neural Machine Translation- Encoder-Decoder Approaches. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjqtZDc59DQAhUGyrwKHbhDBLUQFggsMAE&url=https%3A%2F%2Farxiv.org%2Fpdf%2F1409.1259&usg=AFQjCNG6_CJ8ZYMv5sx4K59mRIPpHlL-Yg)]
- On Using Very Large Target Vocabulary for Neural Machine Translation.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwiSle7659DQAhULTbwKHfaiBsoQFggsMAE&url=http%3A%2F%2Fwww.aclweb.org%2Fanthology%2FP15-1001&usg=AFQjCNFUabHMFw5X9gjg26vjoDljEd4s_g)]
- Reading Text in the Wild with Convolutional Neural Networks.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwiBlcrmn9PQAhXGW7wKHa6VAEwQFggsMAE&url=https%3A%2F%2Fwww.robots.ox.ac.uk%2F~vgg%2Fpublications%2F2016%2FJaderberg16%2Fjaderberg16.pdf&usg=AFQjCNG2V55rN1HOyhtSMLcHAyiuAYFl3A)]
- <b>[Seq2Seq]</b> Sequence to Sequence Learning with Neural Networks. [`arxiv`](https://arxiv.org/abs/1409.3215) [`code`](https://github.com/farizrahman4u/seq2seq) :star: 
