# Applications

- pytorch
    - [2D and 3D Face alignment library build using pytorch](https://github.com/1adrianb/face-alignment)
    - [Adversarial Autoencoders](https://github.com/fducau/AAE_pytorch)
    - [A implementation of WaveNet with fast generation](https://github.com/vincentherrmann/pytorch-wavenet)
    - [A fast and differentiable QP solver for PyTorch.](https://github.com/locuslab/qpth)
    - [A few tutorials on getting started with PyTorch and TorchText for sentiment analysis.](https://github.com/bentrevett/pytorch-sentiment-analysis)
    - [A method to generate speech across multiple speakers](https://github.com/facebookresearch/loop)
    - [A model for style-specific music generation](https://github.com/calclavia/DeepJ) :star:
    - [A natural language processing toolkit using state-of-the-art deep learning models.](https://github.com/allenai/allennlp) :star:
    - [An implementation of Skip-Thought Vectors in PyTorch](https://github.com/sanyam5/skip-thoughts)
    - [Anuvada: Interpretable Models for NLP using PyTorch](https://github.com/Sandeep42/anuvada)
    - [An open-source NLP research library, built on PyTorch](https://github.com/allenai/allennlp)
    - [A PyTorch Implementation for Triplet Networks](https://github.com/andreasveit/triplet-network-pytorch)
    - [A pytorch implementation of Detectron.](https://github.com/roytseng-tw/Detectron.pytorch)
    - [A PyTorch implementation of MobileNetV2](https://github.com/tonylins/pytorch-mobilenet-v2)
    - [A PyTorch implementation of Paragraph Vectors (doc2vec)](https://github.com/inejc/paragraph-vectors)
    - [A PyTorch Implementation of Single Shot MultiBox Detector.](https://github.com/amdegroot/ssd.pytorch)
    - [A PyTorch implementation of the architecture of Mask RCNN](https://github.com/wannabeOG/Mask-RCNN)
    - [A simplified implemention of Faster R-CNN with competitive performance](https://github.com/chenyuntc/simple-faster-rcnn-pytorch)
    - [A simple PyTorch Implementation of Generative Adversarial Networks, focusing on anime face drawing](https://github.com/jayleicn/animeGAN)
    - [A short tutorial on performing fine tuning or transfer learning in PyTorch.](https://github.com/Spandan-Madan/Pytorch_fine_tuning_Tutorial)
    - [A universal and efficient framework for training well-performing light net](https://github.com/zhougr1993/Rocket-Launching)
    - [A utility library around PyTorch](https://github.com/nasimrahaman/inferno)
    - [Comprehensive Data Augmentation and Sampling for Pytorch](https://github.com/ncullen93/torchsample)
    - [CNNs for Sentence Classification in PyTorch](https://github.com/Shawn1993/cnn-text-classification-pytorch)
    - [Convolutional recurrent network in pytorch](https://github.com/meijieru/crnn.pytorch)
    - [Datasets, Transforms and Models specific to Computer Vision](https://github.com/endymecy/vision) :star:
    - [Deep AutoEncoders for Collaborative Filtering](https://github.com/NVIDIA/DeepRecommender)
    - [Deep recommender models using PyTorch.](https://github.com/maciejkula/spotlight) :star:
    - [Deep Reinforcement Learning with pytorch & visdom](https://github.com/jingweiz/pytorch-rl)
    - [Deep Q-Learning Network in pytorch](https://github.com/transedward/pytorch-dqn)
    - [Draw like Bob Ross using the power of Neural Networks](https://github.com/kendricktan/drawlikebobross)
    - [Facebook AI Research Sequence-to-Sequence Toolkit written in Python.](https://github.com/facebookresearch/fairseq-py)
    - [Fast Neural Style for Image Style Transform by Pytorch](https://github.com/bengxy/FastNeuralStyle)
    - [Faster RCNN with PyTorch](https://github.com/longcw/faster_rcnn_pytorch)
    - [Fine-tune pretrained Convolutional Neural Networks with PyTorch](https://github.com/creafz/pytorch-cnn-finetune)
    - [Highway networks implemented in PyTorch.](https://github.com/c0nn3r/pytorch_highway_networks)
    - [Image Classification Project Killer in PyTorch](https://github.com/felixgwu/img_classification_pk_pytorch)
    - [Image-to-image translation in PyTorch](https://github.com/junyanz/pytorch-CycleGAN-and-pix2pix) :star:
    - [Implementation of various methods for dimensionality reduction and spectral clustering implemented with Pytorch](https://github.com/dimkastan/PyTorch-Spectral-clustering)
    - [Implementations of different VAE-based semi-supervised and generative models in PyTorch](https://github.com/wohlert/semi-supervised-pytorch)
    - [InferSent is a sentence embeddings method that provides semantic sentence representations.](https://github.com/facebookresearch/InferSent)
    - [LeafSnap replicated using deep neural networks to test accuracy compared to traditional computer vision methods.](https://github.com/sujithv28/Deep-Leafsnap)
    - [Lightweight implementation of neural style in Pytorch with SqueezeNet](https://github.com/lizeng614/SqueezeNet-Neural-Style-Pytorch)
    - [Minimal PyTorch implementation of YOLOv3](https://github.com/eriklindernoren/PyTorch-YOLOv3)
    - [Minimal Seq2Seq model with Attention for Neural Machine Translation in PyTorch](https://github.com/keon/seq2seq)
    - [OpenNMT: Open-Source Neural Machine Translation in PyTorch](https://github.com/OpenNMT/OpenNMT-py) :star:
    - [Open source person re-identification library in python](https://github.com/Cysu/open-reid) :star:
    - [Probabilistic Programming and Statistical Inference in PyTorch](https://github.com/stepelu/ptstat)
    - [PyTorch ASR Implementation](https://github.com/awni/speech)
    - [PyTorch Extension Library of Optimised Graph Cluster Algorithms](https://github.com/rusty1s/pytorch_cluster)
    - [PyTorch Implementation of Autoencoding Variational Inference for Topic Models](https://github.com/hyqneuron/pytorch-avitm)
    - [PyTorch implementation of convolutional networks-based text-to-speech synthesis models](https://github.com/r9y9/deepvoice3_pytorch)
    - [PyTorch Implementation of CycleGAN and SGAN for Domain Transfer](https://github.com/yunjey/mnist-svhn-transfer)
    - [PyTorch implementations of Generative Adversarial Networks.](https://github.com/eriklindernoren/PyTorch-GAN) :star:
    - [PyTorch implementation of Fully Convolutional Networks](https://github.com/wkentaro/pytorch-fcn)
    - [Pytorch implementation of the U-Net for image semantic segmentation, with dense CRF post-processing](https://github.com/milesial/Pytorch-UNet)
    - [Pytorch Implementation of Perceptual Losses for Real-Time Style Transfer and Super-Resolution](https://github.com/ceshine/fast-neural-style)
    - [Pytorch Implementation of PixelCNN++](https://github.com/pclucas14/pixel-cnn-pp)
    - [Pytorch implement of Person re-identification baseline.](https://github.com/layumi/Person_reID_baseline_pytorch)
    - [pytorch implementation of grammar variational autoencoder](https://github.com/episodeyang/grammar_variational_autoencoder)
    - [PyTorch implementation of Global Vectors for Word Representation](https://github.com/2014mchidamb/TorchGlove)
    - [PyTorch implementation of the Value Iteration Networks](https://github.com/onlytailei/PyTorch-value-iteration-networks)
    - [PyTorch Marvelous ChatBot](https://github.com/jinfagang/pytorch_chatbot) :star:
    - [PyTorch module to use OpenFace's nn4.small2.v1.t7 model](https://github.com/thnkim/OpenFacePytorch)
    - [Pytorch Negative Sampling Loss](https://github.com/analvikingur/pytorch_NEG_loss)
    - [PyTorch Neural Turing Machine (NTM)](https://github.com/loudinthecloud/pytorch-ntm)
    - [Pytorch Poetry Generation](https://github.com/jhave/pytorch-poetry-generation)
    - [Pytorch structural similarity (SSIM) loss](https://github.com/Po-Hsun-Su/pytorch-ssim)
    - [PyTorch version of Google AI's BERT model with script to load Google's pre-trained models](https://github.com/huggingface/pytorch-pretrained-BERT)
    - [Pytorch yolo3](https://github.com/marvis/pytorch-yolo3)
    - [Quickly comparing your image classification models with the state-of-the-art models](https://github.com/felixgwu/img_classification_pk_pytorch)
    - [Semantic Image Segmentation in Pytorch](https://github.com/warmspringwinds/dense-ai)
    - [Semantic Segmentation Architectures Implemented in PyTorch](https://github.com/meetshah1995/pytorch-semseg)
    - [Sequence-to-Sequence learning using PyTorch](https://github.com/eladhoffer/seq2seq.pytorch)
    - [Sequence to Sequence Models with PyTorch](https://github.com/MaximumEntropy/Seq2Seq-PyTorch)
    - [SSD: Single Shot MultiBox Object Detector, in PyTorch](https://github.com/amdegroot/ssd.pytorch)
    - [t-SNE experiments in pytorch](https://github.com/cemoody/topicsne)
    - [Visualization of CNN in PyTorch](https://github.com/leelabcnbc/cnnvis-pytorch)
    - [Visual Question Answering in Pytorch](https://github.com/Cadene/vqa.pytorch)
    - [Weight normalization](https://github.com/ruotianluo/weightnorm-pytorch)
    - [YOLOv2 in PyTorch](https://github.com/longcw/yolo2-pytorch)
    - [使用PyTorch实现Char RNN生成古诗和周杰伦的歌词](https://github.com/SherlockLiao/Char-RNN-PyTorch)
- theano
    - [CNN-yelp-challenge-2016-sentiment-classification](https://github.com/haoopeng/CNN-yelp-challenge-2016-sentiment-classification)
    - [Deep learning tutorial for PyData](https://github.com/Britefury/deep-learning-tutorial-pydata)
    - [Deep Neural Network for Sentiment Analysis on Twitter](https://github.com/xiaohan2012/twitter-sent-dnn)
    - [Implementations of many popular deep learning models in Theano+Lasagne](https://github.com/kuleshov/deep-learning-models)
- tensorflow
    - [A chatbot implemented in TensorFlow based on the seq2seq model, with certain rules integrated.](https://github.com/bshao001/ChatLearner) :star:
    - [A framework for developing and evaluating reinforcement learning algorithms](https://github.com/shaneshixiang/rllabplusplus)
    - [A general-purpose encoder-decoder framework for Tensorflow that can be used for Machine Translation, Text Summarization, Conversational Modeling, Image Captioning, and more.](https://github.com/google/seq2seq)
    - [A generic image detection program that uses tensorflow and a pre-trained Inception.](https://github.com/ArunMichaelDsouza/tensorflow-image-detection)
    - [All kinds of text classificaiton models and more with deep learning](https://github.com/brightmart/text_classification) :star:
    - [Applying transfer learning to a custom dataset by retraining Inception's final layer](https://github.com/HusainZafar/TransferLearningTutorial)
    - [An easy implement of VGG19 with tensorflow, which has a detailed explanation.](https://github.com/hjptriplebee/VGG19_with_tensorflow)
    - [An experimentation system for Reinforcement Learning using OpenAI Gym, Tensorflow, and Keras.](https://github.com/kengz/openai_lab) :star:
    - [An implementation of Pix2Pix in Tensorflow for use with frames from films](https://github.com/awjuliani/Pix2Pix-Film)
    - [An implementation of skip-thought vectors in Tensorflow](https://github.com/persiyanov/skip-thought-tf)
    - [An open-source convolutional neural networks platform for research in medical image analysis and image-guided therapy](https://github.com/NifTK/NiftyNet)
    - [A Practical Guide for Debugging TensorFlow Codes](https://github.com/wookayin/tensorflow-talk-debugging)
    - [A real-time object recognition application using Google's TensorFlow Object Detection API and OpenCV.](https://github.com/datitran/Object-Detector-App)
    - [A set of Deep Reinforcement Learning Agents implemented in Tensorflow.](https://github.com/awjuliani/DeepRL-Agents) :star:
    - [A simple baseline for 3d human pose estimation in tensorflow.](https://github.com/una-dinosauria/3d-pose-baseline)
    - [Aspect Based Sentiment Analysis using End-to-End Memory Networks](https://github.com/ganeshjawahar/mem_absa)
    - [A tensorflow implementation for SqueezeDet, a convolutional neural network for object detection.](https://github.com/BichenWuUCB/squeezeDet)
    - [A Tensorflow implementation of CNN-LSTM image caption generator architecture](https://github.com/mosessoh/CNN-LSTM-Caption-Generator)
    - [A TensorFlow Implementation of DC-TTS: yet another text-to-speech model](https://github.com/Kyubyong/dc_tts)
    - [A tensorflow implementation of "Deep Convolutional Generative Adversarial Networks"](https://github.com/carpedm20/DCGAN-tensorflow) :star:
    - [A TensorFlow implementation of Baidu's DeepSpeech architecture](https://github.com/mozilla/DeepSpeech) :star:
    - [A tiny implementation of Deep Q Learning, using TensorFlow and OpenAI gym](https://github.com/ageron/tiny-dqn)
    - [Char-RNN implemented using TensorFlow.](https://github.com/crazydonkey200/tensorflow-char-rnn)
    - [Chinese Handwriting Recognition with CNNs](https://github.com/atgambardella/handwriting)
    - [Chinese Named Entity Recognition with IDCNN/biLSTM+CRF, and Relation Extraction with biGRU+2ATT](https://github.com/crownpku/Information-Extraction-Chinese)
    - [Collection of generative models in Tensorflow](https://github.com/hwalsuklee/tensorflow-generative-model-collections)
    - [Convolutional Neural Network for Multi-label Multi-instance Relation Extraction in Tensorflow](https://github.com/may-/cnn-re-tf)
    - [Deep-Atrous-CNN-Text-Network: End-to-end word level model for sentiment analysis and other text classifications](https://github.com/randomrandom/deep-atrous-cnn-sentiment)
    - [DeepColor: Automatic coloring and shading of manga-style lineart](https://github.com/kvfrans/deepcolor)
    - [Deep Learning based Python Library for Stock Market Prediction and Modelling](https://github.com/achillesrasquinha/bulbea)
    - [Deep LSTM siamese network for text similarity](https://github.com/dhwajraj/deep-siamese-text-similarity)
    - [Deep neural networks for voice conversion (voice style transfer) in Tensorflow](https://github.com/andabi/deep-voice-conversion)
    - [Deepnlp:Deep Learning NLP Pipeline implemented on Tensorflow](https://github.com/rockingdingo/deepnlp)
    - [Dynamic Memory Network implementation in TensorFlow](https://github.com/barronalex/Dynamic-Memory-Networks-in-TensorFlow)
    - [EAST : An Efficient and Accurate Scene Text Detector](https://github.com/argman/EAST) :star:
    - [Embedding Watermarks into Deep Neural Networks](https://github.com/yu4u/dnn-watermark)
    - [End-to-end Neural Coreference Resolution](https://github.com/kentonl/e2e-coref)
    - [End to End self learning chat Bot implemented using TensorFlow](https://github.com/binojohnthomas/AIChatBot-TensorFlow)
    - [Face Rank - Rank Face by CNN Model based on TensorFlow](https://github.com/fendouai/FaceRank)
    - [Fast Multi(Interpolative) Style Transfer](https://github.com/Heumi/Fast_Multi_Style_Transfer-tf)
    - [Fast PixelCNN++: speedy image generation](https://github.com/PrajitR/fast-pixel-cnn)
    - [Feature Importance in the Inception (v1) Network](https://github.com/ankurtaly/Attributions)
    - [Fully Convlutional Neural Networks for state-of-the-art time series classification](https://github.com/cauchyturing/UCR_Time_Series_Classification_Deep_Learning_Baseline)
    - [Fully differentiable deep-neural decision forest in tensorflow](https://github.com/chrischoy/fully-differentiable-deep-ndf-tf)
    - [GA3C: Reinforcement Learning through Asynchronous Advantage Actor-Critic on a GPU](https://github.com/NVlabs/GA3C)
    - [Generic U-Net Tensorflow implementation for image segmentation](https://github.com/jakeret/tf_unet)
    - [Implement SC-LSTM model for text generation in control of words, in Python/TensorFlow](https://github.com/hit-computer/SC-LSTM)
    - [Implementation of Generative Adversarial Networks, for Audio.](https://github.com/usernaamee/audio-GAN)
    - [Implementation of Google's Tacotron in TensorFlow](https://github.com/barronalex/Tacotron)
    - [Implementations of deep RL papers and random experimentation](https://github.com/steveKapturowski/tensorflow-rl) :star:
    - [Implementation of Monte Carlo Word Movers Distance in Python with TensorFlow](https://github.com/jwbaum91/MCWMD)
    - [Implementation of Restricted Boltzmann Machine (RBM) and its variants in Tensorflow](https://github.com/omimo/xRBM)
    - [Implementation of SmoothGrad as well as several other saliency techniques](https://github.com/tensorflow/saliency)
    - [Implementation of the Differentiable Neural Computer in Tensorflow](https://github.com/bgavran/DNC)
    - [Interactive, node-by-node debugging and visualization for TensorFlow](https://github.com/ericjang/tdb) :star:
    - [LSTM Language Model with Subword Units Input Representations](https://github.com/claravania/subword-lstm-lm)
    - [Machine Learning on Sequential Data Using a Recurrent Weighted Average](https://github.com/jostmey/rwa)
    - [Matrix factorization using TensorFlow](https://github.com/katbailey/factorizer)
    - [Metasploit for machine learning.](https://github.com/cchio/deep-pwning)
    - [Multilabel time series classification with LSTM](https://github.com/aqibsaeed/Multilabel-timeseries-classification-with-LSTM)
    - [Named Entity Recognition using multilayered bidirectional LSTM](https://github.com/monikkinom/ner-lstm)
    - [Named Entity Recognition using Recurrent Neural Networks in Tensorflow and TFLearn](https://github.com/dhwajraj/NER-RNN)
    - [NeuroNER: Named-entity recognition using neural networks.](https://github.com/Franck-Dernoncourt/NeuroNER)
    - [Neural Relation Extraction implemented with LSTM in TensorFlow](https://github.com/thunlp/TensorFlow-NRE)
    - [Object Tracking in Tensorflow ( Localization Detection Classification ) developed to partecipate to ImageNET VID competition](https://github.com/DrewNF/Tensorflow_Object_Tracking_Video) :star:
    - [OCR text recognition using tensorflow with attention](https://github.com/pannous/tensorflow-ocr) :star:
    - [Open Source Neural Machine Translation in TensorFlow](https://github.com//OpenNMT/OpenNMT-tf) :star:
    - [Photographic Image Synthesis with Cascaded Refinement Networks](https://github.com/CQFIO/PhotographicImageSynthesis)
    - [PixelVAE with or without regularization](https://github.com/ShengjiaZhao/Generalized-PixelVAE)
    - [PointNet: Deep Learning on Point Sets for 3D Classification and Segmentation](https://github.com/charlesq34/pointnet) :star:
    - [Realistic Handwriting with Tensorflow](https://github.com/greydanus/scribe)
    - [Real-time Joint Semantic Reasoning for Autonomous Driving](https://github.com/MarvinTeichmann/MultiNet)
    - [RL course experiments](https://github.com/Scitator/rl-course-experiments)
    - [Raccoon Detector Dataset](https://github.com/datitran/raccoon-dataset)
    - [Self-Driving Car Engineer Nanodegree](https://github.com/upul/Behavioral-Cloning)
    - [Semantic Segmentation Suite in TensorFlow](https://github.com/GeorgeSeif/Semantic-Segmentation-Suite)
    - [Sentiment Analysis with LSTMs in Tensorflow](https://github.com/adeshpande3/LSTM-Sentiment-Analysis)
    - [Separating singing voice from music based on deep neural net in Tensorflow](https://github.com/andabi/music-source-separation)
    - [Seq2Seq Chatbot](https://github.com/zsdonghao/seq2seq-chatbot)
    - [Sequence prediction using recurrent neural networks(LSTM) with TensorFlow](https://github.com/mouradmourafiq/tensorflow-lstm-regression)
    - [Sequence Semantic Embedding](https://github.com/eBay/Sequence-Semantic-Embedding)
    - [Sequence-to-Sequence Grapheme-to-Phoneme toolkit](https://github.com/cmusphinx/g2p-seq2seq)
    - [Simple embedding based text classifier inspired by fastText, implemented in tensorflow](https://github.com/apcode/tensorflow_fasttext)
    - [Simple Recommender System using Denoising AutoEncoder, implemented using TensorFlow](https://github.com/smajida/RecSys-DAE-tensorflow)
    - [Somiao Pinyin: Train your own Chinese Input Method with Seq2seq Model](https://github.com/crownpku/Somiao-Pinyin)
    - [Source code and pretrained model for webcam pix2pix](https://github.com/memo/webcam-pix2pix-tensorflow)
    - [Speech-to-Text-WaveNet : End-to-end sentence level English speech recognition based on DeepMind's WaveNet and tensorflow](https://github.com/buriburisuri/speech-to-text-wavenet)
    - [SSD in TensorFlow: Traffic Sign Detection and Classification](https://github.com/georgesung/ssd_tensorflow_traffic_sign_detection)
    - [SSD: Single Shot MultiBox Detector in TensorFlow](https://github.com/balancap/SSD-Tensorflow) :star:
    - [Teach machine to write all we want](https://github.com/zzw922cn/Neural_Writing_Machine) :star:
    - [Tensorflow-based Distributed Factorization Machine](https://github.com/kopopt/fast_tffm) :star:
    - [TensorFlow CNN for fast style transfer](https://github.com/lengstrom/fast-style-transfer) :star:
    - [Tensorflow implementation of Facebook TagSpace](https://github.com/flrngel/TagSpace-tensorflow)
    - [Tensorflow implementation of attention mechanism for text classification tasks.](https://github.com/ilivans/tf-rnn-attention)
    - [Tensorflow Implementation of Convolutional Neural Network for Relation Extraction](https://github.com/roomylee/cnn-relation-extraction)
    - [Tensorflow implementation of DeepFM for CTR prediction.](https://github.com/ChenglongChen/tensorflow-DeepFM)
    - [Tensorflow implementation of Dynamic Coattention Networks for Question Answering.](https://github.com/marshmelloX/dynamic-coattention-network)
    - [Tensorflow implementation of fast neural style transfer](https://github.com/ghwatson/faststyle)
    - [Tensorflow implementation of Fully Convolutional Networks for Semantic Segmentation](https://github.com/shekkizh/FCN.tensorflow)
    - [TensorFlow implementation of SqueezeDet, trained on the KITTI dataset](https://github.com/fregu856/2D_detection)
    - [Tensorflow implementation of YOLO : Real-Time Object Detection](https://github.com/nilboy/tensorflow-yolo)
    - [Tensorflow for Time Series Applications](https://github.com/abhishekmalali/TimeFlow)
    - [TensorFlow on iOS demo](https://github.com/hollance/TensorFlow-iOS-Example)
    - [TensorFlow on Spark](https://github.com/yahoo/TensorFlowOnSpark)
    - [Tensorflow port of Image-to-Image Translation with Conditional Adversarial Nets](https://github.com/affinelayer/pix2pix-tensorflow) :star:
    - [Tensorflow Tutorial files and Implementations of various Deep NLP and CV Models](https://github.com/siddk/deep-nlp)
    - [TensorForce: A TensorFlow library for applied reinforcement learning](https://github.com/reinforceio/tensorforce)
    - [Training and running an extractive question answering model on the SQuAD dataset](https://github.com/google/mipsqa) :star:
    - [Tutorials for deep learning](https://github.com/oduerr/dl_tutorial)
    - [使用TensorFlow实现的Sequence to Sequence的聊天机器人模型](https://github.com/qhduan/Seq2Seq_Chatbot_QA)
    - [Udacity SDC: Vehicle Detection](https://github.com/balancap/SDC-Vehicle-Detection) :star:
    - [Using neural networks to build an automatic number plate recognition system](https://github.com/matthewearl/deep-anpr) :star:
    - [Various models and code for the paraphrase identification task, specifically with the Quora Question Pairs dataset.](https://github.com/nelson-liu/paraphrase-id-tensorflow)
    - [基于LSTM的中文问答系统](https://github.com/S-H-Y-GitHub/QA)
    - [中文古诗自动作诗机器人](https://github.com/jinfagang/tensorflow_poems)
- Keras
    - [A DCGAN to generate anime faces using custom mined dataset](https://github.com/pavitrakumar78/Anime-Face-GAN-Keras)
    - [A facial expression classification system that recognizes 6 basic emotions: happy, sad, surprise, fear, anger and neutral.](https://github.com/JostineHo/mememoji)
    - [A neural network trained to help writing neural network code using autocomplete](https://github.com/kootenpv/neural_complete)
    - [Attention mechanism Implementation for Keras.](https://github.com/philipperemy/keras-attention-mechanism)
    - [Automated deep neural network design with genetic programming](https://github.com/joeddav/devol) :star:
    - [Bidirectional LSTM-CRF for Sequence Labeling. Easy-to-use and state-of-the-art performance.](https://github.com/Hironsan/anago)
    - [Code for Document Similarity on Reuters dataset using Encode, Embed, Attend, Predict recipe](https://github.com/sujitpal/eeap-examples)
    - [Deep Voice: Real-time Neural Text-to-Speech](https://github.com/israelg99/deepvoice)
    - [Embedding Watermarks into Deep Neural Networks](https://github.com/yu4u/dnn-watermark)
    - [Experimental implementation of novel neural network structures](https://github.com/DingKe/nn_playground)
    - [Five video classification methods](https://github.com/harvitronix/five-video-classification-methods)
    - [Inception-v4, Inception - Resnet-v1 and v2 Architectures in Keras](https://github.com/titu1994/Inception-v4)
    - [Implementation of all-neural speech recognition systems using Keras and Tensorflow](https://github.com/igormq/asr-study)
    - [Implementation of some basic GAN architectures in Keras](https://github.com/erilyth/DCGANs)
    - [Isolating vocals from music with a Convolutional Neural Network.](https://github.com/madebyollin/acapellabot)
    - [Keras Audio Preprocessors](https://github.com/keunwoochoi/kapre) :star:
    - [Keras code and weights files for popular deep learning models.](https://github.com/fchollet/deep-learning-models)
    - [keras-emoji-embeddings](https://github.com/bradleypallen/keras-emoji-embeddings) 
    - [Keras implementation of a CNN network for age and gender estimation](https://github.com/yu4u/age-gender-estimation)
    - [Keras implementation of Deep Clustering](https://github.com/jcsilva/deep-clustering)
    - [Keras implementation of Faster R-CNN: Towards Real-Time Object Detection with Region Proposal Networks](https://github.com/yhenon/keras-frcnn)
    - [Keras implementations of Generative Adversarial Networks.](https://github.com/eriklindernoren/Keras-GAN)
    - [Keras implementation of yolo v3 object detection.](https://github.com/xiaochus/YOLOv3)
    - [Keras package for region-based convolutional neural networks](https://github.com/broadinstitute/keras-rcnn)
    - [Python toolbox to create adversarial examples that fool neural networks](https://github.com/bethgelab/foolbox)
    - [Realtime Multi-Person Pose Estimation](https://github.com/ZheC/Realtime_Multi-Person_Pose_Estimation)
    - [Sis: simple image search engine](https://github.com/matsui528/sis)
    - [Trained image classification models for Keras](https://github.com/fchollet/deep-learning-models) :star:
    - [Traffic Sign Recognition - Fine tuning VGG16 + GTSRB](https://github.com/alessiamarcolini/deepstreet)
    - [Transfer learning for flight-delay prediction via variational autoencoders in Keras](https://github.com/cavaunpeu/flight-delays)
    - [Using Keras to implement recommender systems](https://github.com/sonyisme/keras-recommendation) :star:
    - [Wasserstein DCGAN in Tensorflow/Keras](https://github.com/kuleshov/tf-wgan)
    - [W-net: Self-Supervised Learning of Depthmap from Stereo Images.](https://github.com/LouisFoucard/w-net)
- Mxnet
    - [使用MXNet的动态图接口Gluon实现Char RNN生成古诗和周杰伦的歌词](https://github.com/SherlockLiao/Char-RNN-Gluon)
    