# Awesome Deep learning papers and other resources

![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)

A list of recent papers regarding deep learning and deep reinforcement learning. They are sorted by time to see the recent papers first.
I will renew the recent papers and add notes to these papers.

You should find the papers and software with star flag are more important or popular.

## Table of Contents

- [Papers](#papers)
- [Model Zoo](#model-zoo)
- [Pretrained Model](#pre-trained-model)
- [Courses](#courses)
- [Books](#books)
- [Tutorials](#tutorials)
- [Software](#software)
- [Applications](#applications)
- [Awesome Projects](#awesome-projects)
- [Corpus](#corpus)

# Papers
- [2021 year](papers/2021/cv.md)
    - [computer vision](papers/2021/cv.md)
    - [natural language process](papers/2021/nlp.md) 
    - [multi model](papers/2021/mm.md)
- [2020 year](papers/2020/dl.md)
    - [deep learning](papers/2020/dl.md)
    - [deep reinforcement learning](papers/2020/rl.md) 
    - [natural language process](papers/2020/nlp.md)
    - [computer vision](papers/2020/cv.md)
- [2019 year](papers/2019/dl.md)
    - [deep learning](papers/2019/dl.md)
    - [deep reinforcement learning](papers/2019/rl.md) 
    - [natural language process](papers/2019/nlp.md)
    - [computer vision](papers/2019/cv.md)
- [2018 year](papers/2018/dl.md)
    - [deep learning](papers/2018/dl.md)
    - [deep reinforcement learning](papers/2018/rl.md) 
    - [natural language process](papers/2018/nlp.md)
    - [computer vision](papers/2018/cv.md)
- [2017 year](papers/2017/dl.md)
    - [deep learning](papers/2017/dl.md)
    - [deep reinforcement learning](papers/2017/rl.md) 
    - [natural language process](papers/2017/nlp.md)
    - [computer vision](papers/2017/cv.md)
- [2016 year](papers/2016/dl.md)
    - [deep learning](papers/2016/dl.md)
    - [deep reinforcement learning](papers/2016/rl.md)
    - [natural language process](papers/2016/nlp.md)
    - [computer vision](papers/2016/cv.md)
- [2015 year](papers/2015.md)
- [2014 year](papers/2014.md)
- [2013 year](papers/2013.md) 
- [2012 year](papers/2012.md)
- [2011 year](papers/2011.md)
- [2010 year](papers/2010.md)
- [before 2010 year](papers/before-2010.md)

# Model Zoo

* 2012 | AlexNet: ImageNet Classification with Deep Convolutional Neural Networks. [`pdf`](https://papers.nips.cc/paper/4824-imagenet-classification-with-deep-convolutional-neural-networks.pdf) [`code`](https://github.com/kratzert/finetune_alexnet_with_tensorflow)
* 2013 | RCNN: Rich feature hierarchies for accurate object detection and semantic segmentation.  [`arxiv`](https://arxiv.org/abs/1311.2524)  [`code`](https://github.com/rbgirshick/rcnn) 
* 2014 | CGNA: Conditional Generative Adversarial Nets. [`arxiv`](https://arxiv.org/abs/1411.1784)  [`code`](https://github.com/zhangqianhui/Conditional-Gans) 
* 2014 | DeepFaceVariant: Deep Learning Face Representation from Predicting 10,000 Classes. [`pdf`](http://mmlab.ie.cuhk.edu.hk/pdf/YiSun_CVPR14.pdf)  [`code`](https://github.com/joyhuang9473/deepid-implementation) 
* 2014 | GAN: Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1406.2661)  [`code`](https://github.com/goodfeli/adversarial) 
* 2014 | GoogLeNet: Going Deeper with Convolutions. [`pdf`](https://www.cs.unc.edu/~wliu/papers/GoogLeNet.pdf)  [`code`](https://github.com/google/inception) 

More details in [Model Zoo](model_zoo.md)

# Pre Trained Model

* [Aligning the fastText vectors of 78 languages](https://github.com/Babylonpartners/fastText_multilingual)
* [Available pretrained word embeddings](https://github.com/vzhong/embeddings)
* [Inception-v3 of imagenet](http://download.tensorflow.org/models/image/imagenet/inception-v3-2016-03-01.tar.gz)
* [Caffe2 Model Repository](https://github.com/caffe2/models)

More details in [Pretrained Model](pre_trained.md)

# Courses

* [Berkeley] [CS294: Deep Reinforcement Learning](http://rll.berkeley.edu/deeprlcourse/)
* [Berkeley] [Stat212b：Topics Course on Deep Learning](http://joanbruna.github.io/stat212b/)
* [CUHK] [ELEG 5040: Advanced Topics in Signal Processing(Introduction to Deep Learning)](https://piazza.com/cuhk.edu.hk/spring2015/eleg5040/home)
* [CMU] [Deep Reinforcement Learning and Control](https://katefvision.github.io/)
* [CMU] [Neural networks for NLP](http://phontron.com/class/nn4nlp2017/)
)

More details in [courses](courses.md)

# Books

* [Deep Learning by Ian Goodfellow, Yoshua Bengio, and Aaron Courville](http://www.deeplearningbook.org/). [`中文版本`](https://github.com/exacity/deeplearningbook-chinese)
* [Deep Learning Tutorial by LISA lab, University of Montreal](http://deeplearning.net/tutorial/deeplearning.pdf)
* [Deep Learning Crash Course](https://www.manning.com/livevideo/deep-learning-crash-course)
* [Documentation on all topics that I learn on both Artificial intelligence and machine learning.](https://leonardoaraujosantos.gitbooks.io/artificial-inteligence/content/)
* [Interpretable Machine Learning](https://christophm.github.io/interpretable-ml-book/)
* [Deep Learning and the Game of Go](https://www.manning.com/books/deep-learning-and-the-game-of-go)
* [Deep Learning for Search](https://www.manning.com/books/deep-learning-for-search)
* [Deep Learning with PyTorch](https://www.manning.com/books/deep-learning-with-pytorch)
* [Deep Reinforcement Learning in Action](https://www.manning.com/books/deep-reinforcement-learning-in-action)
* [Grokking Deep Reinforcement Lerning](https://www.manning.com/books/grokking-deep-reinforcement-learning)
* [Grokking Deep Learning for Computer Vision](https://www.manning.com/books/grokking-deep-learning-for-computer-vision)
* [Probabilistic Deep Learning with Python](https://www.manning.com/books/probabilistic-deep-learning-with-python)
* [Math and Architectures of Deep Learning](https://www.manning.com/books/math-and-architectures-of-deep-learning)
* [Inside Deep Learning](https://www.manning.com/books/inside-deep-learning)
* [Engineering Deep Learning Platforms](https://www.manning.com/books/engineering-deep-learning-platforms)
* [Deep Learning with R, Second Edition](https://www.manning.com/books/deep-learning-with-r-second-edition)
* [Regularization in Deep Learning](https://www.manning.com/books/regularization-in-deep-learning)
* [Jax in Action](https://www.manning.com/books/jax-in-action)
* [Deep Learning with PyTorch, Second Edition](https://www.manning.com/books/deep-learning-with-pytorch-second-edition)

More details in [books](books.md)

# Tutorials

*  [UFLDL Tutorial 1](http://deeplearning.stanford.edu/wiki/index.php/UFLDL_Tutorial)
*  [UFLDL Tutorial 2](http://ufldl.stanford.edu/tutorial/supervised/LinearRegression/)
*  [Deep Learning for NLP (without Magic)](http://www.socher.org/index.php/DeepLearningTutorial/DeepLearningTutorial)
*  [A Deep Learning Tutorial: From Perceptrons to Deep Networks](http://www.toptal.com/machine-learning/an-introduction-to-deep-learning-from-perceptrons-to-deep-networks)
*  [Deep Learning from the Bottom up](http://www.metacademy.org/roadmaps/rgrosse/deep_learning)
*  [Theano Tutorial](http://deeplearning.net/tutorial/deeplearning.pdf)
*  [TensorFlow tutorials](https://github.com/nlintz/TensorFlow-Tutorials)
*  [Deep Learning with R in Motion](https://www.manning.com/livevideo/deep-learning-with-r-in-motion)
*  [Grokking Deep Learning in Motion](https://www.manning.com/livevideo/grokking-deep-learning-in-motion)
*  [Machine Learning, Data Science and Deep Learning with Python](https://www.manning.com/livevideo/machine-learning-data-science-and-deep-learning-with-python)

More details in [tutorials](tutorials.md)

# Software

- <b>`Keras`</b> [Deep Learning library for Theano and TensorFlow.](https://keras.io/)  :star:
- <b>`Kur`</b> [Descriptive Deep Learning.](https://github.com/deepgram/kur)  :star:
- <b>`Caffe`</b> [Deep learning framework by the BVLC](http://caffe.berkeleyvision.org/) :star:
- <b>`CNTK` </b>[The Microsoft Cognitive Toolkit.](https://github.com/Microsoft/CNTK) 
- <b>`Dlib`</b> [A modern C++ toolkit containing machine learning algorithms and tools for creating complex software in C++.](http://dlib.net/)
- <b>`PyTorch`</b> [Tensors and Dynamic neural networks in Python with strong GPU acceleration.](http://pytorch.org/) :star:
- <b>`Scikit-Learn`</b> [Machine learning in Python.](http://scikit-learn.org)  :star:
   - <b>`Semisup-Learn`</b> [Semi-supervised learning frameworks for Python](https://github.com/tmadl/semisup-learn)   
- <b>`Tensorflow`</b> [An open source software library for numerical computation using data flow graph by Google](https://www.tensorflow.org/) :star:

More details in [software](software.md)

# Applications

- pytorch
    - [2D and 3D Face alignment library build using pytorch](https://github.com/1adrianb/face-alignment)
    - [Adversarial Autoencoders](https://github.com/fducau/AAE_pytorch)
    - [A implementation of WaveNet with fast generation](https://github.com/vincentherrmann/pytorch-wavenet)
    - [A fast and differentiable QP solver for PyTorch.](https://github.com/locuslab/qpth)
    - [A method to generate speech across multiple speakers](https://github.com/facebookresearch/loop)
    - [A model for style-specific music generation](https://github.com/calclavia/DeepJ) :star:
    - [A natural language processing toolkit using state-of-the-art deep learning models.](https://github.com/allenai/allennlp) :star:
    - [使用PyTorch实现Char RNN生成古诗和周杰伦的歌词](https://github.com/SherlockLiao/Char-RNN-PyTorch)
- theano
    - [CNN-yelp-challenge-2016-sentiment-classification](https://github.com/haoopeng/CNN-yelp-challenge-2016-sentiment-classification)
    - [Deep learning tutorial for PyData](https://github.com/Britefury/deep-learning-tutorial-pydata)
    - [Deep Neural Network for Sentiment Analysis on Twitter](https://github.com/xiaohan2012/twitter-sent-dnn)
    - [Implementations of many popular deep learning models in Theano+Lasagne](https://github.com/kuleshov/deep-learning-models)
- tensorflow
    - [A generic image detection program that uses tensorflow and a pre-trained Inception.](https://github.com/ArunMichaelDsouza/tensorflow-image-detection)
    - [All kinds of text classificaiton models and more with deep learning](https://github.com/brightmart/text_classification) :star:
    - [Applying transfer learning to a custom dataset by retraining Inception's final layer](https://github.com/HusainZafar/TransferLearningTutorial)
    - [An easy implement of VGG19 with tensorflow, which has a detailed explanation.](https://github.com/hjptriplebee/VGG19_with_tensorflow)
    - [An experimentation system for Reinforcement Learning using OpenAI Gym, Tensorflow, and Keras.](https://github.com/kengz/openai_lab) :star:
    - [An implementation of Pix2Pix in Tensorflow for use with frames from films](https://github.com/awjuliani/Pix2Pix-Film)
- Keras
    - [A DCGAN to generate anime faces using custom mined dataset](https://github.com/pavitrakumar78/Anime-Face-GAN-Keras)
    - [A facial expression classification system that recognizes 6 basic emotions: happy, sad, surprise, fear, anger and neutral.](https://github.com/JostineHo/mememoji)
    - [A neural network trained to help writing neural network code using autocomplete](https://github.com/kootenpv/neural_complete)
    - [Attention mechanism Implementation for Keras.](https://github.com/philipperemy/keras-attention-mechanism)
    - [Automated deep neural network design with genetic programming](https://github.com/joeddav/devol) :star:
    - [Attention based Neural Machine Translation for Keras](https://github.com/divamgupta/attention-translation-keras)   
    - [Keras Implementation of Ladder Network for Semi-Supervised Learning](https://github.com/divamgupta/ladder_network_keras)

- Mxnet
    - [使用MXNet的动态图接口Gluon实现Char RNN生成古诗和周杰伦的歌词](https://github.com/SherlockLiao/Char-RNN-Gluon)

More details in [applications](applications.md)

# Awesome Projects

- [15 AI and Machine Learning Events](http://botunity.co/14-ai-and-machine-learning-events/)
- [188 examples of artificial intelligence in action](https://poo.ai/)
- [A curated list of automated machine learning papers, articles, tutorials, slides and projects](https://github.com/hibayesian/awesome-automl-papers) :star:
- [A curated list of awesome Machine Learning frameworks, libraries and software.](https://github.com/josephmisiti/awesome-machine-learning)
- [A curated list of awesome places to learn and/or practice algorithms.](https://github.com/tayllan/awesome-algorithms)
- [A curated list of awesome R packages and tools](https://github.com/qinwf/awesome-R)
- [A curated list of awesome SLAM tutorials, projects and communities.](https://github.com/kanster/awesome-slam)
- [A curated list of resources dedicated to bridge between coginitive science and deep learning](https://github.com/robi56/awesome-cognitive-science-and-deep-learning)
- [A curated list of resources dedicated to Natural Language Processing (NLP)](https://github.com/keon/awesome-nlp)
- [A curated list of resources for NLP (Natural Language Processing) for Chinese](https://github.com/crownpku/awesome-chinese-nlp#corpus-%E4%B8%AD%E6%96%87%E8%AF%AD%E6%96%99)
- [Another curated list of deep learning resources](https://github.com/guillaume-chevalier/Awesome-Deep-Learning-Resources)
- [A list of artificial intelligence tools you can use today](https://hackernoon.com/a-list-of-artificial-intelligence-tools-you-can-use-today-for-personal-use-1-3-7f1b60b6c94f)
- [A list of deep learning implementations in biology](https://github.com/hussius/deeplearning-biology)
- [Awesome-2vec](https://github.com/MaxwellRebo/awesome-2vec) 
- [Awesome Action Recognition](https://github.com/jinwchoi/awesome-action-recognition)

More details in [awesome projects](awesome_projects.md)

# Corpus

- [用于对话系统的中英文语料](https://github.com/candlewill/Dialog_Corpus)
- [搜狗实验室](http://www.sogou.com/labs/)
- [情感分析︱网络公开的免费文本语料训练数据集汇总](http://blog.csdn.net/sinat_26917383/article/details/51321505)
- [中文情感分析用词语集](http://www.keenage.com/html/c_bulletin_2007.htm)
- [人民日报切分/标注语料库](http://www.icl.pku.edu.cn/icl_res/)
- [哈工大信息检索研究中心(HIT CIR)语言技术平台共享资源](http://ir.hit.edu.cn/demo/ltp/Sharing_Plan.htm)
- [中文句结构树资料库](http://turing.iis.sinica.edu.tw/treesearch/)
- [中文对白语料 chinese conversation corpus](https://github.com/rustch3n/dgk_lost_conv)
- [中文语料小数据：Some useful Chinese corpus datasets](https://github.com/crownpku/Small-Chinese-Corpus)
- [中文人名语料库。中文姓名,姓氏,名字,称呼,日本人名,翻译人名,英文人名](https://github.com/wainshine/Chinese-Names-Corpus)
- [联合国平行语料库](https://conferences.unite.un.org/UNCorpus/zh)
- [保险行业语料库](https://github.com/Samurais/insuranceqa-corpus-zh)
- [用于训练中英文对话系统的语料库 Datasets for Training Chatbot System](https://github.com/candlewill/Dialog_Corpus)
- [PTT 八卦版問答中文語料](https://github.com/zake7749/Gossiping-Chinese-Corpus)
- [3 Million Instacart Orders, Open Sourced](https://www.instacart.com/datasets/grocery-shopping-2017)
- [ACM Multimedia Systems Conference Dataset Archive](http://traces.cs.umass.edu/index.php/Mmsys/Mmsys)
- [A dataset for book recommendations: ten thousand books, one million ratings](https://www.kaggle.com/zygmunt/goodbooks-10k)
- [A dataset for personalized highlight detection](https://github.com/gifs/personalized-highlights-dataset)
- [A dataset of 200k English plaintext jokes.](https://github.com/taivop/joke-dataset)
- [A large-scale and high-qualityFMA: A Dataset For Music Analysis dataset of annotated musical notes.](https://magenta.tensorflow.org/datasets/nsynth)
- [A large-scale dataset of manually annotated audio events](https://research.google.com/audioset/) :star:
- [Alphabetical list of free/public domain datasets with text data for use in NLP](https://github.com/niderhoff/nlp-datasets)

More details in [corpus](corpus.md)

# Other Resources

- [Synthical](https://synthical.com) - AI-powered collaborative research environment. You can use it to get recommendations of articles based on reading history, simplify papers, find out what articles are trending, search articles by meaning (not just keywords), create and share folders of articles, see lists of articles from specific companies and universities, and so on.

# Contributors

Special thanks to everyone who contributed to this project.

- raer6
- isikdogan
- outlace
- divamgupta
- Naman-Bhalla
- ppuliu
- benedekrozemberczki
- roziunicorn
- von-latinski 

# License

The details in [License](LICENCE)
