/*
Source: https://github.com/enchant97/js-theme-changer
Version: v2.0.0
Commit Hash: 11c2c2e5f32969b6ec5cb3c0d177537c0569011b
License: MIT - Copyright (c) 2022 Leo Spratt
*/
"use-strict";class ThemeChanger{static saved_theme_key="theme";static theme_picker_id="theme-picker-selector";static theme_picker_parent=null;static selected_theme_css_class="current";static dataset_theme_name="theme";static themes={os:"OS",light:"Light",dark:"Dark"};static os_theme="os";static curr_theme;static use_local=false;static get_theme_keys(){return Object.keys(ThemeChanger.themes)}static get_item_from_storage(key,default_value){return window.localStorage.getItem(key)||window.sessionStorage.getItem(key)||default_value}static set_item_to_storage(key,value){if(ThemeChanger.use_local){window.localStorage.setItem(key,value);window.sessionStorage.removeItem(key)}else{window.sessionStorage.setItem(key,value);window.localStorage.removeItem(key)}}static set_current_theme(){document.documentElement.dataset[ThemeChanger.dataset_theme_name]=ThemeChanger.curr_theme}static change_current_theme(theme_key){ThemeChanger.set_item_to_storage(ThemeChanger.saved_theme_key,theme_key);ThemeChanger.curr_theme=theme_key;ThemeChanger.set_current_theme()}static on_load(){ThemeChanger.curr_theme=ThemeChanger.get_item_from_storage(ThemeChanger.saved_theme_key,ThemeChanger.os_theme);ThemeChanger.set_current_theme()}static create_theme_picker_button(theme_key){const bnt_text=ThemeChanger.themes[theme_key];const element=document.createElement("button");element.addEventListener("click",_event=>{ThemeChanger.remove_theme_picker();ThemeChanger.change_current_theme(theme_key)});element.innerText=bnt_text;if(ThemeChanger.curr_theme===theme_key){element.classList.add(ThemeChanger.selected_theme_css_class)}return element}static insert_theme_picker(){const picker_element=document.createElement("dialog");picker_element.setAttribute("open",true);picker_element.setAttribute("id",ThemeChanger.theme_picker_id);for(let key of ThemeChanger.get_theme_keys()){picker_element.appendChild(ThemeChanger.create_theme_picker_button(key))}if(ThemeChanger.theme_picker_parent===null){ThemeChanger.theme_picker_parent=document.body}ThemeChanger.theme_picker_parent.insertAdjacentElement("afterbegin",picker_element)}static remove_theme_picker(){const picker_element=document.getElementById(ThemeChanger.theme_picker_id);picker_element?.remove()}static toggle_theme_picker(){const picker_element=document.getElementById(ThemeChanger.theme_picker_id);if(picker_element===null){ThemeChanger.insert_theme_picker()}else{ThemeChanger.remove_theme_picker()}}}
