##
# This file should be included by extbld Makefiles.
#

ifeq ($(strip $(ROOT_DIR)),)
$(error ROOT_DIR is not set)
endif

ifeq ($(strip $(BUILD_DIR)),)
$(error BUILD_DIR is not set)
endif

include $(ROOT_DIR)/mk/core/common.mk
include $(ROOT_DIR)/mk/core/string.mk

.PHONY : all download extract patch configure build install

all : download extract patch configure build install

PKG_INSTALL_DIR  := $(BUILD_DIR)/install
PKG_SOURCE_DIR   = $(filter-out %/install,$(wildcard $(BUILD_DIR)/*))
DOWNLOAD_BASEDIR := $(ROOT_DIR)/download
ifeq ($(value PKG_DOWNLOADS_SEPARATE),)
DOWNLOAD_DIR     := $(DOWNLOAD_BASEDIR)
else
DOWNLOAD_DIR     := $(DOWNLOAD_BASEDIR)/$(PKG_NAME)
endif

$(DOWNLOAD_DIR) $(BUILD_DIR) $(PKG_INSTALL_DIR):
	mkdir -p $@

PKG_NAME    ?=
PKG_VER     ?=
PKG_SOURCES ?=

sources_git := $(filter %.git,$(PKG_SOURCES))
targets_git = $(basename $(notdir $1))
sources_archive_mirrors := $(filter-out %.git,$(PKG_SOURCES))

pkg_ext ?=
first_url := $(word 1,$(sources_archive_mirrors))
ifneq ($(filter %.tar.gz %.tar.bz %.tar.bz2 %.tar.xz,$(first_url)),)
	pkg_ext := .tar$(suffix $(first_url))
else ifneq ($(filter %.tgz %.tbz %.zip %.gz,$(first_url)),)
	pkg_ext := $(suffix $(first_url))
endif

ifneq ($(PKG_VER),)
	pkg_archive_name := $(PKG_NAME)-$(PKG_VER)$(pkg_ext)
else
	pkg_archive_name := $(PKG_NAME)$(pkg_ext)
endif

DOWNLOAD  := $(BUILD_DIR)/.downloaded
$(DOWNLOAD): | $(DOWNLOAD_DIR) $(BUILD_DIR)
	$(foreach d,$(sources_archive_mirrors), \
		if [ ! -f $(DOWNLOAD_DIR)/$(pkg_archive_name) ] ; then \
			cd $(DOWNLOAD_DIR); \
			curl -o $(pkg_archive_name) -f -k -L '$d' && \
			($(MD5) $(pkg_archive_name) | $(AWK) '{print $$1}' | grep $(PKG_MD5) 2>&1 >/dev/null;) || \
			$(RM) $(pkg_archive_name); \
		fi;) \
	$(foreach g,$(sources_git), \
		dir_to_clone=$(DOWNLOAD_DIR)/$(call targets_git,$g); \
		if [ ! -d $$dir_to_clone ]; then \
			if [ ! "$(PKG_VER)" ]; then \
				cd $(DOWNLOAD_DIR); \
				git clone $g; \
			else \
				mkdir $$dir_to_clone; \
				cd $$dir_to_clone; \
				git init . ; \
				git remote add origin '$g'; \
				git remote set-url origin '$g'; \
				git fetch origin ; \
				git fetch origin -t ; \
				git checkout -f -q '$(PKG_VER)'; \
				git clean -ffdx; \
			fi; \
		fi;)
	touch $@

DOWNLOAD_CHECK  := $(BUILD_DIR)/.download_checked
$(DOWNLOAD_CHECK) : $(DOWNLOAD)
    # check md5sum only for source archives and skip the check for git repos
	if [ "$(sources_archive_mirrors)" ] ; then \
		cd $(DOWNLOAD_DIR) && ( \
				$(MD5) $(pkg_archive_name) | $(AWK) '{print $$1}' | grep $(PKG_MD5) 2>&1 >/dev/null; \
			); \
    fi;
	touch $@

download : $(DOWNLOAD) $(DOWNLOAD_CHECK)

EXTRACT  := $(BUILD_DIR)/.extracted
extract : $(EXTRACT)
$(EXTRACT): $(DOWNLOAD) | $(DOWNLOAD_DIR) $(BUILD_DIR)
	$(if $(first_url),$(if $(filter %zip,$(pkg_ext)), \
		unzip -q $(DOWNLOAD_DIR)/$(pkg_archive_name) -d $(BUILD_DIR);, \
		$(if $(filter-out %tar.gz %tgz,$(filter %gz,$(pkg_ext))), \
		gzip -dk $(DOWNLOAD_DIR)/$(pkg_archive_name); mv $(DOWNLOAD_DIR)/$(PKG_NAME) $(BUILD_DIR);, \
		tar -xf $(DOWNLOAD_DIR)/$(pkg_archive_name) -C $(BUILD_DIR);)))
	COPY_FILES="$(addprefix $(DOWNLOAD_DIR)/, \
			$(call targets_git,$(sources_git)))"; \
		if [ "$$COPY_FILES" ]; then \
			cp -R $$COPY_FILES $(BUILD_DIR); \
		fi;
	touch $@

PATCH  := $(BUILD_DIR)/.patched
patch : $(PATCH)
PKG_PATCHES ?=
$(PATCH): $(EXTRACT) $(PKG_PATCHES) | $(BUILD_DIR)
	if [ -d tree ]; then \
		cd tree; \
		cp -l -u -f --parents -t $(PKG_SOURCE_DIR) `find . -not -path '*/.*' -and -type f`; \
		cd ..; \
	fi
	for i in $(PKG_PATCHES); do \
		patch -d $(BUILD_DIR) -p0 < $$PWD/$$i; \
	done
	touch $@

CONFIGURE  := $(BUILD_DIR)/.configured
configure : $(CONFIGURE)
$(CONFIGURE): $(PATCH) | $(BUILD_DIR)

BUILD  := $(BUILD_DIR)/.built
build : $(BUILD)
$(BUILD): $(CONFIGURE) | $(BUILD_DIR)

INSTALL  := $(BUILD_DIR)/.installed
install : $(INSTALL)
$(INSTALL): $(BUILD) | $(BUILD_DIR) $(PKG_INSTALL_DIR)

# Definitions used by user Makefile

ifneq ($(MKGEN_DIR),)
include $(MKGEN_DIR:.%=$(ROOT_DIR)%)/build.mk
ifeq ($(ARCH),x86)
AUTOCONF_ARCH := i386
else
AUTOCONF_ARCH := $(ARCH)
endif
AUTOCONF_TARGET_TRIPLET=$(AUTOCONF_ARCH)-unknown-none
endif

ifeq ($(COMPILER),clang)
EMBOX_GCC := $(ROOT_DIR)/mk/extbld/arch-embox-clang
else
EMBOX_GCC := $(ROOT_DIR)/mk/extbld/arch-embox-gcc
EMBOX_GXX := $(ROOT_DIR)/mk/extbld/arch-embox-g++
endif
