#region License, Terms and Author(s)
//
// ELMAH - Error Logging Modules and Handlers for ASP.NET
// Copyright (c) 2004-9 Atif Aziz. All rights reserved.
//
//  Author(s):
//
//      Atif Aziz, http://www.raboof.com
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#endregion

extern alias e;

namespace Elmah.Tests
{
    #region Imports

    using System;
    using System.Collections.Generic;
    using System.Linq;
    using Xunit;
    using e::Elmah;

    #endregion

    /// <summary>
    /// Extension methods for <see cref="ErrorLog"/>.
    /// </summary>
    
    static class ErrorLogExtensions
    {
        public static ErrorLogEntry GetLastError(this ErrorLog errorLog)
        {
            if (errorLog == null) throw new ArgumentNullException("errorLog");
            var errors = new List<ErrorLogEntry>();
            Assert.Equal(1, errorLog.GetErrors(0, 1, errors));
            return errors.FirstOrDefault();
        }
    }
}