---
title: Navigation
lang: en-US
---

<style>
:root {
  --categories-c-bg: #F9FAFC;
  --categories-c-page: #E5E9F2;
  --categories-c-overlay: white;
  --categories-c-text: #99A9BF;
  --categories-c-icon: #E5E9F2;
  --categories-c-line: #E5E9F2;
}

.dark {
  --categories-c-bg: #1D1E1F;
  --categories-c-page: #0A0A0A;
  --categories-c-overlay: #141414;
  --categories-c-text: #53637A;
  --categories-c-icon: #2F333D;
  --categories-c-line: #242529;
}
</style>

# Navigation

Navigation focuses on solving the users' problems of where to go and how to get
there. Generally it can be categorized into 'sidebar navigation' and 'top navigation'.

## Choose the right navigation

An appropriate navigation gives users a smooth experience, while an inappropriate
one leads to confusion. Here are the differences between sidebar navigation and
top navigation.

## Side Navigation

Affix the navigation at the left edge, thus improves its visibility, making it
easier to switch between pages. In this case, the top area of the page holds
commonly used tools, e.g. search bar, help button, notice button, etc. Suitable
for background management or utility websites.

### Level 1 categories

Suitable for simply structured sites with only one level of pages. No breadcrumb is needed.

<L1Categories />

### Level 2 categories

Sidebar displays up to two levels of navigation. Breadcrumbs are recommended in
combination of second level navigation, making it easier for the users to locate
and navigate.

<L2Categories />

### Level 3 categories

Suitable for complicated utility websites. The left sidebar holds first level
navigation, and the middle column displays second level navigation or other utility
options.

<L3Categories />

## Top Navigation

Conforms to the normal browsing order from top to bottom, which makes things more
natural. The navigation amount and text length are limited to the width of the top.

Suitable for sites with few navigation and large chunks.

<TopNavigationExample />
