---
title: Internationalization
lang: en-US
---

# Internationalization

Element Plus components are using English **by default**, if you wish you use other
languages, you can get you answer by keep reading.

## Global configuration

Element Plus provides global configurations

```ts
import ElementPlus from 'element-plus'
import zhCn from 'element-plus/es/locale/lang/zh-cn'

app.use(ElementPlus, {
  locale: zhCn,
})
```

## ConfigProvider

Element Plus also provides a Vue component [ConfigProvider](/en-US/component/config-provider)
for globally configuring locale and other settings.

```vue
<template>
  <el-config-provider :locale="zhCn">
    <app />
  </el-config-provider>
</template>

<script setup lang="ts">
import { ElConfigProvider } from 'element-plus'
import zhCn from 'element-plus/es/locale/lang/zh-cn'
</script>
```

## Date and time localization

We use [Day.js](https://day.js.org/docs/en/i18n/i18n) library to manage date and time in components like `DatePicker`. It is important to set a proper locale in Day.js to make the internationalization fully works. You have to import Day.js's locale config separately.

```ts
import 'dayjs/locale/zh-cn'
```

## CDN Usage

If you are using Element Plus via CDN, then you need to do this, let's again take
unpkg as an example

```html
<script src="//unpkg.com/element-plus/dist/locale/zh-cn"></script>
<script>
  app.use(ElementPlus, {
    locale: ElementPlusLocaleZhCn,
  })
</script>
```

Full documentation refer to: [ConfigProvider](/en-US/component/config-provider)

[Supported Language List](https://github.com/element-plus/element-plus/tree/dev/packages/locale/lang)

<ul class="language-list">
  <li>Simplified Chinese (zh-cn)</li>
  <li>American English (en)</li>
  <li>Azerbaijani (az)</li>
  <li>German (de)</li>
  <li>Portuguese (pt)</li>
  <li>Spanish (es)</li>
  <li>Danish (da)</li>
  <li>French (fr)</li>
  <li>Norwegian (nb-NO)</li>
  <li>Traditional Chinese (zh-tw)</li>
  <li>Italian (it)</li>
  <li>Korean (ko)</li>
  <li>Japanese (ja)</li>
  <li>Dutch (nl)</li>
  <li>Vietnamese (vi)</li>
  <li>Russian (ru)</li>
  <li>Turkish (tr)</li>
  <li>Brazilian Portuguese (pt-br)</li>
  <li>Farsi (fa)</li>
  <li>Thai (th)</li>
  <li>Indonesian (id)</li>
  <li>Bulgarian (bg)</li>
  <li>Pashto (pa)</li>
  <li>Polish (pl)</li>
  <li>Finnish (fi)</li>
  <li>Swedish (sv)</li>
  <li>Greek (el)</li>
  <li>Slovak (sk)</li>
  <li>Catalunya (ca)</li>
  <li>Czech (cs)</li>
  <li>Ukrainian (uk)</li>
  <li>Turkmen (tk)</li>
  <li>Tamil (ta)</li>
  <li>Latvian (lv)</li>
  <li>Afrikaans (af)</li>
  <li>Estonian (et)</li>
  <li>Slovenian (sl)</li>
  <li>Arabic (ar)</li>
  <li>Hebrew (he)</li>
  <li>Lithuanian (lt)</li>
  <li>Mongolian (mn)</li>
  <li>Kazakh (kk)</li>
  <li>Hungarian (hu)</li>
  <li>Romanian (ro)</li>
  <li>Kurdish (ku)</li>
  <li>Kurdish (ckb)</li>
  <li>Uighur (ug-cn)</li>
  <li>Khmer (km)</li>
  <li>Serbian (sr)</li>
  <li>Basque (eu)</li>
  <li>Kyrgyz (ky)</li>
  <li>Armenian (hy-am)</li>
  <li>Croatian (hr)</li>
  <li>Esperanto (eo)</li>
  <li>Bengali (bn)</li>
  <li>Malay (ms)</li>
</ul>

If you need any other languages, [PR](https://github.com/element-plus/element-plus/pulls)
is always welcomed, you only need to add a language file at
[here](https://github.com/element-plus/element-plus/tree/dev/packages/locale/lang).

<style>
  .language-list {
    list-style: disc
  }
</style>
