---
title: DatePicker
lang: en-US
---

# DatePicker

Use Date Picker for date input.

## Enter Date

Basic date picker measured by 'day'.

:::demo The measurement is determined by the `type` attribute. You can enable quick options via `shortcuts` property. The disabled date is set by `disabledDate`, which is a function.

date-picker/enter-date

:::

## Other measurements

You can choose week, month, year or multiple dates by extending the standard date picker component.

:::demo

date-picker/other-measurements

:::

## Date Range

Picking a date range is supported.

:::demo When in range mode, the left and right panels are linked by default. If you want the two panels to switch current months independently, you can use the `unlink-panels` attribute.

date-picker/date-range

:::

## Month Range

Picking a month range is supported.

:::demo When in range mode, the left and right panels are linked by default. If you want the two panels to switch current years independently, you can use the `unlink-panels` attribute.

date-picker/month-range

:::

## Year Range ^(2.8.0)

Picking a year range is supported.

:::demo When in range mode, the left and right panels are linked by default. If you want the two panels to switch years independently, you can use the `unlink-panels` attribute.

date-picker/year-range

:::

## Default Value

If user hasn't picked a date, shows today's calendar by default. You can use `default-value` to set another date. Its value should be parsable by `new Date()`.

If type is `daterange`, `default-value` sets the left side calendar.

:::demo

date-picker/default-value

:::

## Date Formats

Use `format` to control displayed text's format in the input box. Use `value-format` to control binding value's format.

By default, the component accepts and emits a `Date` object.

Check the list [here](https://day.js.org/docs/en/display/format#list-of-all-available-formats) of all available formats of Day.js.

:::warning

Pay attention to capitalization

:::

:::demo

date-picker/date-formats

:::

## Default time for start date and end date

When picking a date range, you can assign the time part for start date and end date.

:::demo By default, the time part of start date and end date are both `00:00:00`. Setting `default-time` can change their time respectively. It accepts an array of up to two Date objects. The first string sets the time for the start date, and the second for the end date.

date-picker/default-time

:::

## Set custom content of prefix

The content of prefix can be customized.

:::demo Setting `prefix-icon` to component which you import form other .vue or generated by the render function.

date-picker/custom-prefix-icon

:::

## Custom content

The content of cell can be customized, in scoped-slot you can get the cell data. Note that the custom content structure should be consistent with the default structure, otherwise style misalignment may occur.

:::demo

date-picker/custom-content

:::

## Custom icon ^(2.8.0)

Custom icons available with slots.

:::demo

date-picker/custom-icon

:::

For data details, please refer:

```ts
interface DateCell {
  column: number
  customClass: string
  disabled: boolean
  end: boolean
  inRange: boolean
  row: number
  selected: Dayjs
  isCurrent: boolean
  isSelected: boolean
  start: boolean
  text: number
  timestamp: number
  date: Date
  dayjs: Dayjs
  type: 'normal' | 'today' | 'week' | 'next-month' | 'prev-month'
}
```

## Localization

The default locale of is English, if you need to use other languages, please check [Internationalization](/en-US/guide/i18n)

Note, date time locale (month name, first day of the week ...) are also configured in localization.

## API

### Attributes

| Name                         | Description                                                                                                                  | Type                                                                                                                                                           | Default       |
| ---------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------- |
| model-value / v-model        | binding value, if it is an array, the length should be 2                                                                     | ^[number] / ^[string] / ^[object]`Date \| [Date, Date] \| [string, string]`                                                                                    | ''            |
| readonly                     | whether DatePicker is read only                                                                                              | ^[boolean]                                                                                                                                                     | false         |
| disabled                     | whether DatePicker is disabled                                                                                               | ^[boolean]                                                                                                                                                     | false         |
| size                         | size of Input                                                                                                                | ^[enum]`'' \| 'large' \| 'default' \| 'small'`                                                                                                                 | —             |
| editable                     | whether the input is editable                                                                                                | ^[boolean]                                                                                                                                                     | true          |
| clearable                    | whether to show clear button                                                                                                 | ^[boolean]                                                                                                                                                     | true          |
| placeholder                  | placeholder in non-range mode                                                                                                | ^[string]                                                                                                                                                      | ''            |
| start-placeholder            | placeholder for the start date in range mode                                                                                 | ^[string]                                                                                                                                                      | —             |
| end-placeholder              | placeholder for the end date in range mode                                                                                   | ^[string]                                                                                                                                                      | —             |
| type                         | type of the picker                                                                                                           | ^[enum]`'year' \| 'years' \|'month' \| 'months' \| 'date' \| 'dates' \| 'datetime' \| 'week' \| 'datetimerange' \| 'daterange' \| 'monthrange' \| 'yearrange'` | date          |
| format                       | format of the displayed value in the input box                                                                               | ^[string] see [date formats](/en-US/component/date-picker#date-formats)                                                                                        | YYYY-MM-DD    |
| popper-class                 | custom class name for DatePicker's dropdown                                                                                  | ^[string]                                                                                                                                                      | —             |
| popper-options               | Customized popper option see more at [popper.js](https://popper.js.org/docs/v2/)                                             | ^[object]`Partial<PopperOptions>`                                                                                                                              | {}            |
| range-separator              | range separator                                                                                                              | ^[string]                                                                                                                                                      | '-'           |
| default-value                | optional, default date of the calendar                                                                                       | ^[object]`Date \| [Date, Date]`                                                                                                                                | —             |
| default-time                 | optional, the time value to use when selecting date range                                                                    | ^[object]`Date \| [Date, Date]`                                                                                                                                | —             |
| value-format                 | optional, format of binding value. If not specified, the binding value will be a Date object                                 | ^[string] see [date formats](/en-US/component/date-picker#date-formats)                                                                                        | —             |
| id                           | same as `id` in native input                                                                                                 | ^[string] / ^[object]`[string, string]`                                                                                                                        | —             |
| name                         | same as `name` in native input                                                                                               | ^[string] / ^[object]`[string, string]`                                                                                                                        | ''            |
| unlink-panels                | unlink two date-panels in range-picker                                                                                       | ^[boolean]                                                                                                                                                     | false         |
| prefix-icon                  | custom prefix icon component. By default, if the value of `type` is `TimeLikeType`, the value is `Clock`, else is `Calendar` | ^[string] / ^[object]`Component`                                                                                                                               | ''            |
| clear-icon                   | custom clear icon component                                                                                                  | ^[string] / ^[object]`Component`                                                                                                                               | `CircleClose` |
| validate-event               | whether to trigger form validation                                                                                           | ^[boolean]                                                                                                                                                     | true          |
| disabled-date                | a function determining if a date is disabled with that date as its parameter. Should return a Boolean                        | ^[Function]`(data: Date) => boolean`                                                                                                                           | —             |
| shortcuts                    | an object array to set shortcut options                                                                                      | ^[object]`Array<{ text: string, value: Date \| Function }>`                                                                                                    | []            |
| cell-class-name              | set custom className                                                                                                         | ^[Function]`(data: Date) => string`                                                                                                                            | —             |
| teleported                   | whether date-picker dropdown is teleported to the body                                                                       | ^[boolean]                                                                                                                                                     | true          |
| empty-values ^(2.7.0)        | empty values of component, [see config-provider](/en-US/component/config-provider#empty-values-configurations)               | ^[array]                                                                                                                                                       | —             |
| value-on-clear ^(2.7.0)      | clear return value, [see config-provider](/en-US/component/config-provider#empty-values-configurations)                      | ^[string] / ^[number] / ^[boolean] / ^[Function]                                                                                                               | —             |
| fallback-placements ^(2.8.4) | list of possible positions for Tooltip [popper.js](https://popper.js.org/docs/v2/modifiers/flip/#fallbackplacements)         | ^[arrary]`Placement[]`                                                                                                                                         | —             |
| placement ^(2.8.4)           | position of dropdown                                                                                                         | `Placement`                                                                                                                                                    | bottom        |

### Events

| Name            | Description                                                       | Type                                                                                      |
| --------------- | ----------------------------------------------------------------- | ----------------------------------------------------------------------------------------- |
| change          | triggers when user confirms the value                             | ^[Function]`(val: typeof v-model) => void`                                                |
| blur            | triggers when Input blurs                                         | ^[Function]`(e: FocusEvent) => void`                                                      |
| focus           | triggers when Input focuses                                       | ^[Function]`(e: FocusEvent) => void`                                                      |
| clear ^(2.7.7)  | triggers when the clear icon is clicked in a clearable DatePicker | ^[Function]`() => void`                                                                   |
| calendar-change | triggers when the calendar selected date is changed.              | ^[Function]`(val: [Date, null \| Date]) => void`                                          |
| panel-change    | triggers when the navigation button click.                        | ^[Function]`(date: Date \| [Date, Date], mode: 'month' \| 'year', view?: string) => void` |
| visible-change  | triggers when the DatePicker's dropdown appears/disappears        | ^[Function]`(visibility: boolean) => void`                                                |

### Slots

| Name                | Description                    |
| ------------------- | ------------------------------ |
| default             | custom cell content            |
| range-separator     | custom range separator content |
| prev-month ^(2.8.0) | prev month icon                |
| next-month ^(2.8.0) | next month icon                |
| prev-year ^(2.8.0)  | prev year icon                 |
| next-year ^(2.8.0)  | next year icon                 |

### Exposes

| Name                  | Description                    | Type                    |
| --------------------- | ------------------------------ | ----------------------- |
| focus                 | focus the DatePicker component | ^[Function]`() => void` |
| blur ^(2.8.7)         | blur the DatePicker component  | ^[Function]`() => void` |
| handleOpen ^(2.2.16)  | open the DatePicker popper     | ^[Function]`() => void` |
| handleClose ^(2.2.16) | close the DatePicker popper    | ^[Function]`() => void` |

## Type Declarations

<details>
  <summary>Show declarations</summary>

```ts
import type { Options as PopperOptions } from '@popperjs/core'

type TimeLikeType = 'datetime' | 'datetimerange'

type Placement =
  | 'top'
  | 'top-start'
  | 'top-end'
  | 'bottom'
  | 'bottom-start'
  | 'bottom-end'
  | 'left'
  | 'left-start'
  | 'left-end'
  | 'right'
  | 'right-start'
  | 'right-end'
```

</details>
