+++
pre = "<b>3.4. </b>"
title = "失效转移"
weight = 4
chapter = true
+++

ElasticJob 不会在本次执行过程中进行重新分片，而是等待下次调度之前才开启重新分片流程。
当作业执行过程中服务器宕机，失效转移允许将该次未完成的任务在另一作业节点上补偿执行。

## 概念

失效转移是当前执行作业的临时补偿执行机制，在下次作业运行时，会通过重分片对当前作业分配进行调整。
举例说明，若作业以每小时为间隔执行，每次执行耗时 30 分钟。如下如图所示。

![定时作业](https://shardingsphere.apache.org/elasticjob/current/img/failover/job.png)

图中表示作业分别于 12:00，13:00 和 14:00 执行。图中显示的当前时间点为 13:00 的作业执行中。

如果作业的其中一个分片服务器在 13:10 的时候宕机，那么剩余的 20 分钟应该处理的业务未得到执行，并且需要在 14:00 时才能再次开始执行下一次作业。
也就是说，在不开启失效转移的情况下，位于该分片的作业有 50 分钟空档期。如下如图所示。

![作业宕机](https://shardingsphere.apache.org/elasticjob/current/img/failover/job-crash.png)

在开启失效转移功能之后，ElasticJob 的其他服务器能够在感知到宕机的作业服务器之后，补偿执行该分片作业。如下图所示。

![补偿执行](https://shardingsphere.apache.org/elasticjob/current/img/failover/job-failover.png)

在资源充足的情况下，作业仍然能够在 13:30 完成执行。

## 执行机制

当作业执行节点宕机时，会触发失效转移流程。ElasticJob 根据触发时的分布式作业执行的不同状况来决定失效转移的执行时机。

### 通知执行

当其他服务器感知到有失效转移的作业需要处理时，且该作业服务器已经完成了本次任务，则会实时的拉取待失效转移的分片项，并开始补偿执行。
也称为实时执行。

### 问询执行

作业服务在本次任务执行结束后，会向注册中心问询待执行的失效转移分片项，如果有，则开始补偿执行。
也称为异步执行。

## 适用场景

开启失效转移功能，ElasticJob 会监控作业每一分片的执行状态，并将其写入注册中心，供其他节点感知。

在一次运行耗时较长且间隔较长的作业场景，失效转移是提升作业运行实时性的有效手段；
对于间隔较短的作业，会产生大量与注册中心的网络通信，对集群的性能产生影响。
而且间隔较短的作业并未见得关注单次作业的实时性，可以通过下次作业执行的重分片使所有的分片正确执行，因此不建议短间隔作业开启失效转移。

另外需要注意的是，作业本身的幂等性，是保证失效转移正确性的前提。
