<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

/**
 * Export routing registration
 */
Route::prefix('export')->group(function () {
    Route::get('tmpls', [App\Http\Controllers\TmplController::class, 'export']);
});

Route::resource('tmpls', App\Http\Controllers\TmplController::class);

Route::middleware(['auth:sanctum', 'verified'])->get('/dashboard', function () {
    return view('dashboard');
})->name('dashboard');


Route::resource('tmpls', App\Http\Controllers\TmplController::class);
