#!/usr/bin/env bash

set -o errexit -o pipefail -o noclobber -o nounset

# Listing binary dependencies here. Nix will replace it with absolute
# paths to the exact version. Without nix they must be in $PATH.
JQ="jq"
CAT="cat"
DSC="dsc"

info() {
    >&2 echo "$@"
}

fail() {
    info "$@"
    exit 2
}

info "Running addon"
info "User Input: $1"
info "Addon: $ADDON_DIR"
info "Tempdir: $TMPDIR"

if ! [ -z ${ITEM_DATA_JSON+x} ]; then
    info "Item JSON: $ITEM_DATA_JSON"
else
    info "Item JSON: <not set>"
fi

$DSC -vv -f json version >&2
$DSC -f json search --limit 5 'date>ms0' >&2

# Check if directories exist
[ -d "$ADDON_DIR" ] || fail "Addon dir doesn't exist"
[ -d "$TMPDIR" ] || fail "Tmpdir doesn't exist"
[ -e "$1" ] || fail "User input file doesn't exist"

itemid="unset"
if [ -e "$ITEM_DATA_JSON" ]; then
    info "Retrieve item id"
    itemid=$($CAT "$ITEM_DATA_JSON" | $JQ -r '.id')
fi

$CAT <<-EOF
{ "commands": [
    {
      "itemId" : "$itemid",
      "actions" : [
        {
          "tags" : [
            "tag1",
            "tag2"
          ],
          "action" : "add-tags"
        }
      ],
      "command" : "item-update"
    }
  ]
}
EOF
