+++
title = "Usage"
insert_anchor_links = "right"
description = "How to use addons"
weight = 20
template = "docs.html"
+++

# Using Addons

This shows with an example, how to install and use an addon. If the ui
doesn't show these forms, addons are probably disabled. Addons need to
be enabled in the config file of the rest server.

## Discovering

Addons can be installed from any URL to a zip file. One way is to use
URLs generated by forges like github or gitlab. They provide zip files
containing the repository contents. Alternatively an addon may provide
specific files in their release section.

For example, this is the url to the first release of the rotate-pdf
addon:

- <https://github.com/docspell/rotate-pdf-addon/archive/refs/tags/v0.1.0.zip>

This url points to a fixed version. It is also possible to use urls
that are "moving targets":

- <https://github.com/docspell/rotate-pdf-addon/archive/refs/heads/master.zip>

The contents behind the above url will very likely change over time.

For better discoverability, repositories for addons on public forges
can be tagged with *docspell-addon*.

## Install

With an URL like above, you can go to *Manage Data -> Addons -> New*
and insert the url:

{{ figure2(light="addon-install-01.png", dark="addon-install-01_dark.png") }}

It might take a while for Docspell to download, extract and verify the
addon. The addon will be downloaded into the database. Once installed,
the given URL is not used anymore, unless a manual update is issued.

After this finishes, you cannot change the URL anymore:

{{ figure2(light="addon-install-02.png", dark="addon-install-02_dark.png") }}

When using URLs pointing to "moving targets", you could click the
*Update Addon* button to re-download the contents at the url. This
doesn't make much sense for URLs to fixed versions (in *theory* these
could change as well, of course) and it is not without risk. It can be
useful for own addons to have them quickly updated.

Now the addon is installed. It can now be used by creating a *run configuration*.

## Run Configuration

A run configuration is comprised of one or more addons, their inputs
and some settings regarding their runtime environment.

The name is used for displaying in the webapp. You can disable/enable
a run configuration.

It is possible that addons use [dsc](@/docs/tools/cli.md) or call the
rest-server otherwise. Usually a valid session is required (to set
tags or do searches). When selecting to run *on behalf of a user*, a
valid authenticator for that user is injected into the environment of
the addon run.

The *Trigger Run* setting specfies when this run configuraiton should
be executed. You can choose from options that all addons in the list
must support. In this example, only `existing-item` is used. This
means the run configuration can be selected to run on any item.

Other options include:
- `final-process-item`: executes automatically as the last step when
  processing uploaded files
- `final-reprocess-item`: like `final-process-item` but applies when
  an existing item is reprocessed.
- `scheduled`: runs periodically based on a schedule (and independent
  from any item)

Each addon may require arguments. Click on *Configure* to enable the
*Arguments* section and add arguments for the corresponding addon.
What to insert here is completely specific to the addon. In this case,
it expects a JSON object with only one field `"degree"` that indicates
how to rotate. In this example, it should be rotated by 90°
counter-clockwise. You need to click *Update* to set it into the addon
and then *Submit* to save everything.

{{ figure2(light="addon-install-03.png", dark="addon-install-03_dark.png") }}


With this run configuration in place, you can try it out on some item:

{{ figure2(light="addon-install-04.png", dark="addon-install-04_dark.png") }}

This example configured the *rotate-pdf-addon* to rotate left by 90°.
Create a simlar run configuration to rotate to the right.
