/* DESCRIPTION: E93 Screen Color Constants Header File
 * AUTHOR: Erdem Ersoy (eersoy93)
 * COPYRIGHT: Copyright (c) 2023-2024 Erdem Ersoy (eersoy93).
 * LICENSE: Licensed with MIT License. See LICENSE file for details.
 */

#ifndef SCREEN_COLORS_H
#define SCREEN_COLORS_H

// Video Color Constants Definitions

#define BLACK_ON_BLACK 0x00
#define BLUE_ON_BLACK 0x01
#define GREEN_ON_BLACK 0x02
#define CYAN_ON_BLACK 0x03
#define RED_ON_BLACK 0x04
#define MAGENTA_ON_BLACK 0x05
#define BROWN_ON_BLACK 0x06
#define WHITE_ON_BLACK 0x07
#define GRAY_ON_BLACK 0x08
#define LIGHTBLUE_ON_BLACK 0x09
#define LIGHTGREEN_ON_BLACK 0x0a
#define LIGHTCYAN_ON_BLACK 0x0b
#define LIGHTRED_ON_BLACK 0x0c
#define LIGHTMAGENTA_ON_BLACK 0x0d
#define YELLOW_ON_BLACK 0x0e
#define BRIGHTWHITE_ON_BLACK 0x0f

#define BLACK_ON_BLUE 0x10
#define BLUE_ON_BLUE 0x11
#define GREEN_ON_BLUE 0x12
#define CYAN_ON_BLUE 0x13
#define RED_ON_BLUE 0x14
#define MAGENTA_ON_BLUE 0x15
#define BROWN_ON_BLUE 0x16
#define WHITE_ON_BLUE 0x17
#define GRAY_ON_BLUE 0x18
#define LIGHTBLUE_ON_BLUE 0x19
#define LIGHTGREEN_ON_BLUE 0x1a
#define LIGHTCYAN_ON_BLUE 0x1b
#define LIGHTRED_ON_BLUE 0x1c
#define LIGHTMAGENTA_ON_BLUE 0x1d
#define YELLOW_ON_BLUE 0x1e
#define BRIGHTWHITE_ON_BLUE 0x1f

#define BLACK_ON_GREEN 0x20
#define BLUE_ON_GREEN 0x21
#define GREEN_ON_GREEN 0x22
#define CYAN_ON_GREEN 0x23
#define RED_ON_GREEN 0x24
#define MAGENTA_ON_GREEN 0x25
#define BROWN_ON_GREEN 0x26
#define WHITE_ON_GREEN 0x27
#define GRAY_ON_GREEN 0x28
#define LIGHTBLUE_ON_GREEN 0x29
#define LIGHTGREEN_ON_GREEN 0x2a
#define LIGHTCYAN_ON_GREEN 0x2b
#define LIGHTRED_ON_GREEN 0x2c
#define LIGHTMAGENTA_ON_GREEN 0x2d
#define YELLOW_ON_GREEN 0x2e
#define BRIGHTWHITE_ON_GREEN 0x2f

#define BLACK_ON_CYAN 0x30
#define BLUE_ON_CYAN 0x31
#define GREEN_ON_CYAN 0x32
#define CYAN_ON_CYAN 0x33
#define RED_ON_CYAN 0x34
#define MAGENTA_ON_CYAN 0x35
#define BROWN_ON_CYAN 0x36
#define WHITE_ON_CYAN 0x37
#define GRAY_ON_CYAN 0x38
#define LIGHTBLUE_ON_CYAN 0x39
#define LIGHTGREEN_ON_CYAN 0x3a
#define LIGHTCYAN_ON_CYAN 0x3b
#define LIGHTRED_ON_CYAN 0x3c
#define LIGHTMAGENTA_ON_CYAN 0x3d
#define YELLOW_ON_CYAN 0x3e
#define BRIGHTWHITE_ON_CYAN 0x3f

#define BLACK_ON_RED 0x40
#define BLUE_ON_RED 0x41
#define GREEN_ON_RED 0x42
#define CYAN_ON_RED 0x43
#define RED_ON_RED 0x44
#define MAGENTA_ON_RED 0x45
#define BROWN_ON_RED 0x46
#define WHITE_ON_RED 0x47
#define GRAY_ON_RED 0x48
#define LIGHTBLUE_ON_RED 0x49
#define LIGHTGREEN_ON_RED 0x4a
#define LIGHTCYAN_ON_RED 0x4b
#define LIGHTRED_ON_RED 0x4c
#define LIGHTMAGENTA_ON_RED 0x4d
#define YELLOW_ON_RED 0x4e
#define BRIGHTWHITE_ON_RED 0x4f

#define BLACK_ON_MAGENTA 0x50
#define BLUE_ON_MAGENTA 0x51
#define GREEN_ON_MAGENTA 0x52
#define CYAN_ON_MAGENTA 0x53
#define RED_ON_MAGENTA 0x54
#define MAGENTA_ON_MAGENTA 0x55
#define BROWN_ON_MAGENTA 0x56
#define WHITE_ON_MAGENTA 0x57
#define GRAY_ON_MAGENTA 0x58
#define LIGHTBLUE_ON_MAGENTA 0x59
#define LIGHTGREEN_ON_MAGENTA 0x5a
#define LIGHTCYAN_ON_MAGENTA 0x5b
#define LIGHTRED_ON_MAGENTA 0x5c
#define LIGHTMAGENTA_ON_MAGENTA 0x5d
#define YELLOW_ON_MAGENTA 0x5e
#define BRIGHTWHITE_ON_MAGENTA 0x5f

#define BLACK_ON_BROWN 0x60
#define BLUE_ON_BROWN 0x61
#define GREEN_ON_BROWN 0x62
#define CYAN_ON_BROWN 0x63
#define RED_ON_BROWN 0x64
#define MAGENTA_ON_BROWN 0x65
#define BROWN_ON_BROWN 0x66
#define WHITE_ON_BROWN 0x67
#define GRAY_ON_BROWN 0x68
#define LIGHTBLUE_ON_BROWN 0x69
#define LIGHTGREEN_ON_BROWN 0x6a
#define LIGHTCYAN_ON_BROWN 0x6b
#define LIGHTRED_ON_BROWN 0x6c
#define LIGHTMAGENTA_ON_BROWN 0x6d
#define YELLOW_ON_BROWN 0x6e
#define BRIGHTWHITE_ON_BROWN 0x6f

#define BLACK_ON_WHITE 0x70
#define BLUE_ON_WHITE 0x71
#define GREEN_ON_WHITE 0x72
#define CYAN_ON_WHITE 0x73
#define RED_ON_WHITE 0x74
#define MAGENTA_ON_WHITE 0x75
#define BROWN_ON_WHITE 0x76
#define WHITE_ON_WHITE 0x77
#define GRAY_ON_WHITE 0x78
#define LIGHTBLUE_ON_WHITE 0x79
#define LIGHTGREEN_ON_WHITE 0x7a
#define LIGHTCYAN_ON_WHITE 0x7b
#define LIGHTRED_ON_WHITE 0x7c
#define LIGHTMAGENTA_ON_WHITE 0x7d
#define YELLOW_ON_WHITE 0x7e
#define BRIGHTWHITE_ON_WHITE 0x7f

#define BLACK_ON_GRAY 0x80
#define BLUE_ON_GRAY 0x81
#define GREEN_ON_GRAY 0x82
#define CYAN_ON_GRAY 0x83
#define RED_ON_GRAY 0x84
#define MAGENTA_ON_GRAY 0x85
#define BROWN_ON_GRAY 0x86
#define WHITE_ON_GRAY 0x87
#define GRAY_ON_GRAY 0x88
#define LIGHTBLUE_ON_GRAY 0x89
#define LIGHTGREEN_ON_GRAY 0x8a
#define LIGHTCYAN_ON_GRAY 0x8b
#define LIGHTRED_ON_GRAY 0x8c
#define LIGHTMAGENTA_ON_GRAY 0x8d
#define YELLOW_ON_GRAY 0x8e
#define BRIGHTWHITE_ON_GRAY 0x8f

#define BLACK_ON_LIGHTBLUE 0x90
#define BLUE_ON_LIGHTBLUE 0x91
#define GREEN_ON_LIGHTBLUE 0x92
#define CYAN_ON_LIGHTBLUE 0x93
#define RED_ON_LIGHTBLUE 0x94
#define MAGENTA_ON_LIGHTBLUE 0x95
#define BROWN_ON_LIGHTBLUE 0x96
#define WHITE_ON_LIGHTBLUE 0x97
#define GRAY_ON_LIGHTBLUE 0x98
#define LIGHTBLUE_ON_LIGHTBLUE 0x99
#define LIGHTGREEN_ON_LIGHTBLUE 0x9a
#define LIGHTCYAN_ON_LIGHTBLUE 0x9b
#define LIGHTRED_ON_LIGHTBLUE 0x9c
#define LIGHTMAGENTA_ON_LIGHTBLUE 0x9d
#define YELLOW_ON_LIGHTBLUE 0x9e
#define BRIGHTWHITE_ON_LIGHTBLUE 0x9f

#define BLACK_ON_LIGHTGREEN 0xa0
#define BLUE_ON_LIGHTGREEN 0xa1
#define GREEN_ON_LIGHTGREEN 0xa2
#define CYAN_ON_LIGHTGREEN 0xa3
#define RED_ON_LIGHTGREEN 0xa4
#define MAGENTA_ON_LIGHTGREEN 0xa5
#define BROWN_ON_LIGHTGREEN 0xa6
#define WHITE_ON_LIGHTGREEN 0xa7
#define GRAY_ON_LIGHTGREEN 0xa8
#define LIGHTBLUE_ON_LIGHTGREEN 0xa9
#define LIGHTGREEN_ON_LIGHTGREEN 0xaa
#define LIGHTCYAN_ON_LIGHTGREEN 0xab
#define LIGHTRED_ON_LIGHTGREEN 0xac
#define LIGHTMAGENTA_ON_LIGHTGREEN 0xad
#define YELLOW_ON_LIGHTGREEN 0xae
#define BRIGHTWHITE_ON_LIGHTGREEN 0xaf

#define BLACK_ON_LIGHTCYAN 0xb0
#define BLUE_ON_LIGHTCYAN 0xb1
#define GREEN_ON_LIGHTCYAN 0xb2
#define CYAN_ON_LIGHTCYAN 0xb3
#define RED_ON_LIGHTCYAN 0xb4
#define MAGENTA_ON_LIGHTCYAN 0xb5
#define BROWN_ON_LIGHTCYAN 0xb6
#define WHITE_ON_LIGHTCYAN 0xb7
#define GRAY_ON_LIGHTCYAN 0xb8
#define LIGHTBLUE_ON_LIGHTCYAN 0xb9
#define LIGHTGREEN_ON_LIGHTCYAN 0xba
#define LIGHTCYAN_ON_LIGHTCYAN 0xbb
#define LIGHTRED_ON_LIGHTCYAN 0xbc
#define LIGHTMAGENTA_ON_LIGHTCYAN 0xbd
#define YELLOW_ON_LIGHTCYAN 0xbe
#define BRIGHTWHITE_ON_LIGHTCYAN 0xbf

#define BLACK_ON_LIGHTRED 0xc0
#define BLUE_ON_LIGHTRED 0xc1
#define GREEN_ON_LIGHTRED 0xc2
#define CYAN_ON_LIGHTRED 0xc3
#define RED_ON_LIGHTRED 0xc4
#define MAGENTA_ON_LIGHTRED 0xc5
#define BROWN_ON_LIGHTRED 0xc6
#define WHITE_ON_LIGHTRED 0xc7
#define GRAY_ON_LIGHTRED 0xc8
#define LIGHTBLUE_ON_LIGHTRED 0xc9
#define LIGHTGREEN_ON_LIGHTRED 0xca
#define LIGHTCYAN_ON_LIGHTRED 0xcb
#define LIGHTRED_ON_LIGHTRED 0xcc
#define LIGHTMAGENTA_ON_LIGHTRED 0xcd
#define YELLOW_ON_LIGHTRED 0xce
#define BRIGHTWHITE_ON_LIGHTRED 0xcf

#define BLACK_ON_LIGHTMAGENTA 0xd0
#define BLUE_ON_LIGHTMAGENTA 0xd1
#define GREEN_ON_LIGHTMAGENTA 0xd2
#define CYAN_ON_LIGHTMAGENTA 0xd3
#define RED_ON_LIGHTMAGENTA 0xd4
#define MAGENTA_ON_LIGHTMAGENTA 0xd5
#define BROWN_ON_LIGHTMAGENTA 0xd6
#define WHITE_ON_LIGHTMAGENTA 0xd7
#define GRAY_ON_LIGHTMAGENTA 0xd8
#define LIGHTBLUE_ON_LIGHTMAGENTA 0xd9
#define LIGHTGREEN_ON_LIGHTMAGENTA 0xda
#define LIGHTCYAN_ON_LIGHTMAGENTA 0xdb
#define LIGHTRED_ON_LIGHTMAGENTA 0xdc
#define LIGHTMAGENTA_ON_LIGHTMAGENTA 0xdd
#define YELLOW_ON_LIGHTMAGENTA 0xde
#define BRIGHTWHITE_ON_LIGHTMAGENTA 0xdf

#define BLACK_ON_YELLOW 0xe0
#define BLUE_ON_YELLOW 0xe1
#define GREEN_ON_YELLOW 0xe2
#define CYAN_ON_YELLOW 0xe3
#define RED_ON_YELLOW 0xe4
#define MAGENTA_ON_YELLOW 0xe5
#define BROWN_ON_YELLOW 0xe6
#define WHITE_ON_YELLOW 0xe7
#define GRAY_ON_YELLOW 0xe8
#define LIGHTBLUE_ON_YELLOW 0xe9
#define LIGHTGREEN_ON_YELLOW 0xea
#define LIGHTCYAN_ON_YELLOW 0xeb
#define LIGHTRED_ON_YELLOW 0xec
#define LIGHTMAGENTA_ON_YELLOW 0xed
#define YELLOW_ON_YELLOW 0xee
#define BRIGHTWHITE_ON_YELLOW 0xef

#define BLACK_ON_BRIGHTWHITE 0xf0
#define BLUE_ON_BRIGHTWHITE 0xf1
#define GREEN_ON_BRIGHTWHITE 0xf2
#define CYAN_ON_BRIGHTWHITE 0xf3
#define RED_ON_BRIGHTWHITE 0xf4
#define MAGENTA_ON_BRIGHTWHITE 0xf5
#define BROWN_ON_BRIGHTWHITE 0xf6
#define WHITE_ON_BRIGHTWHITE 0xf7
#define GRAY_ON_BRIGHTWHITE 0xf8
#define LIGHTBLUE_ON_BRIGHTWHITE 0xf9
#define LIGHTGREEN_ON_BRIGHTWHITE 0xfa
#define LIGHTCYAN_ON_BRIGHTWHITE 0xfb
#define LIGHTRED_ON_BRIGHTWHITE 0xfc
#define LIGHTMAGENTA_ON_BRIGHTWHITE 0xfd
#define YELLOW_ON_BRIGHTWHITE 0xfe
#define BRIGHTWHITE_ON_BRIGHTWHITE 0xff

// Output Colors For Video Type

#define CLRSCR_COLOR   WHITE_ON_BLACK
#define DEFAULT_COLOR  WHITE_ON_BLACK
#define ERROR_COLOR    LIGHTRED_ON_BLACK
#define ERROR_COLOR_2  RED_ON_BRIGHTWHITE
#define HALT_COLOR     LIGHTRED_ON_BLACK
#define INPUT_COLOR    GREEN_ON_BLACK
#define OUTPUT_COLOR   CYAN_ON_BLACK
#define PROMPT_COLOR   MAGENTA_ON_BLACK
#define VARIABLE_COLOR GREEN_ON_BLACK
#define WARNING_COLOR  BROWN_ON_BLACK

#endif //SCREEN_COLORS_H
