<!-- Add your reference image and URL to images/reference/ and then run `python3 update_readme.py` to update this file. See CONTRIBUTING.md for more details -->
# Reference Images

A visual guide to check if the Super Tiny Icons match the shape and colour of organisation's official SVG logo.
Where possible this links to the organisation's brand guidelines page.

> ⚠️ Contributors: Avoid using GIFs, as they ignore the `width` attribute on GitHub.

Name | Super&nbsp;Tiny&nbsp;SVG | Official&nbsp;Logo | Source
-|-|-|-
1Password | <img src="https://edent.github.io/SuperTinyIcons/images/svg/1password.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/1password.png" width="256"> | https://1password.social/@1password
Acast | <img src="https://edent.github.io/SuperTinyIcons/images/svg/acast.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/acast.svg" width="256"> | https://acast.com
Access | <img src="https://edent.github.io/SuperTinyIcons/images/svg/access.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/access.svg" width="256"> | https://en.wikipedia.org/wiki/International_Symbol_of_Access
ActivityPub | <img src="https://edent.github.io/SuperTinyIcons/images/svg/activitypub.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/activitypub.svg" width="256"> | https://activitypub.rocks/
Adobe | <img src="https://edent.github.io/SuperTinyIcons/images/svg/adobe.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/adobe.jpg" width="256"> | https://partners.adobe.com/content/dam/tep_assets/public/public_1/documents/Adobe-Creative-Cloud-Developer-Brand-Guide-062218.pdf
Airbnb | <img src="https://edent.github.io/SuperTinyIcons/images/svg/airbnb.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/airbnb.png" width="256"> | https://press.atairbnb.com/media-assets/?categ=Logos
Amazon | <img src="https://edent.github.io/SuperTinyIcons/images/svg/amazon.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/amazon.jpg" width="256"> | http://www.turnerduckworth.com/work/amazon/
Amazon Alexa | <img src="https://edent.github.io/SuperTinyIcons/images/svg/amazon_alexa.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/amazon_alexa.png" width="256"> | https://developer.amazon.com/docs/alexa-voice-service/logo-and-brand.html
Amazon Simple Storage Service | <img src="https://edent.github.io/SuperTinyIcons/images/svg/amazon_s3.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/amazon_s3.svg" width="256"> | https://aws.amazon.com/architecture/icons/
Amber Framework | <img src="https://edent.github.io/SuperTinyIcons/images/svg/amberframework.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/amberframework.png" width="256"> | https://amberframework.org/media
andOTP | <img src="https://edent.github.io/SuperTinyIcons/images/svg/andotp.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/andotp.png" width="256"> | https://github.com/andOTP/andOTP
Android | <img src="https://edent.github.io/SuperTinyIcons/images/svg/android.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/android.svg" width="256"> | https://developer.android.com/distribute/marketing-tools/brand-guidelines.html
AngelList | <img src="https://edent.github.io/SuperTinyIcons/images/svg/angellist.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/angellist.svg" width="256"> | https://angel.co/logo
Angular | <img src="https://edent.github.io/SuperTinyIcons/images/svg/angular.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/angular.svg" width="256"> | https://angular.io/presskit
Ansible | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ansible.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ansible.svg" width="256"> | https://www.ansible.com/logos
Apereo Foundation | <img src="https://edent.github.io/SuperTinyIcons/images/svg/apereo.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/apereo.png" width="256"> | https://www.apereo.org
Apple | <img src="https://edent.github.io/SuperTinyIcons/images/svg/apple.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/apple.svg" width="256"> | https://developer.apple.com/softwarelicensing/agreements/pdf/mac_logo_gdlns.pdf
Apple Music | <img src="https://edent.github.io/SuperTinyIcons/images/svg/apple_music.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/apple_music.png" width="256"> | https://www.apple.com/in/apple-music/
Apple Podcasts | <img src="https://edent.github.io/SuperTinyIcons/images/svg/applepodcasts.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/applepodcasts.svg" width="256"> | https://www.apple.com/legal/intellectual-property/guidelinesfor3rdparties.html
Arch Linux | <img src="https://edent.github.io/SuperTinyIcons/images/svg/arch_linux.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/arch_linux.svg" width="256"> | https://commons.wikimedia.org/wiki/File:Archlinux-icon-crystal-64.svg
Atom | <img src="https://edent.github.io/SuperTinyIcons/images/svg/atom.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/atom.png" width="256"> | https://atom.io/
Auth0 | <img src="https://edent.github.io/SuperTinyIcons/images/svg/auth0.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/auth0.svg" width="256"> | 
Authy | <img src="https://edent.github.io/SuperTinyIcons/images/svg/authy.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/authy.svg" width="256"> | https://support.authy.com/hc/en-us#
Azure | <img src="https://edent.github.io/SuperTinyIcons/images/svg/azure.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/azure.png" width="256"> | 
Backbone | <img src="https://edent.github.io/SuperTinyIcons/images/svg/backbone.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/backbone.svg" width="256"> | https://backbonejs.org/
Badoo | <img src="https://edent.github.io/SuperTinyIcons/images/svg/badoo.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/badoo.svg" width="256"> | https://badoo.com/
Baidu | <img src="https://edent.github.io/SuperTinyIcons/images/svg/baidu.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/baidu.svg" width="256"> | http://www.baidu.com/img/bd_logo1.png
Bandcamp | <img src="https://edent.github.io/SuperTinyIcons/images/svg/bandcamp.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/bandcamp.png" width="256"> | https://bandcamp.com/buttons
Bash | <img src="https://edent.github.io/SuperTinyIcons/images/svg/bash.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/bash.svg" width="256"> | https://github.com/odb/official-bash-logo
Behance | <img src="https://edent.github.io/SuperTinyIcons/images/svg/behance.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/behance.png" width="256"> | https://www.behance.net/
Bing | <img src="https://edent.github.io/SuperTinyIcons/images/svg/bing.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/bing.svg" width="256"> | https://query.prod.cms.rt.microsoft.com/cms/api/am/binary/RE1q9FS
Bitbucket | <img src="https://edent.github.io/SuperTinyIcons/images/svg/bitbucket.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/bitbucket.svg" width="256"> | https://www.atlassian.com/company/news/press-kit
Bitcoin | <img src="https://edent.github.io/SuperTinyIcons/images/svg/bitcoin.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/bitcoin.svg" width="256"> | https://commons.wikimedia.org/wiki/File:Bitcoin.svg
Bitwarden | <img src="https://edent.github.io/SuperTinyIcons/images/svg/bitwarden.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/bitwarden.svg" width="256"> | https://github.com/bitwarden/brand
Blender | <img src="https://edent.github.io/SuperTinyIcons/images/svg/blender.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/blender.svg" width="256"> | https://www.blender.org/
Blogger | <img src="https://edent.github.io/SuperTinyIcons/images/svg/blogger.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/blogger.png" width="256"> | https://www.blogger.com/img/blogger-logotype-color-black-2x.png
Bluesky | <img src="https://edent.github.io/SuperTinyIcons/images/svg/bluesky.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/bluesky.png" width="256"> | https://docs.bsky.app/
Bluetooth | <img src="https://edent.github.io/SuperTinyIcons/images/svg/bluetooth.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/bluetooth.svg" width="256"> | https://www.bluetooth.com/develop-with-bluetooth/marketing-branding
Brave | <img src="https://edent.github.io/SuperTinyIcons/images/svg/brave.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/brave.svg" width="256"> | https://brave.com/brave-branding-assets/
Briar | <img src="https://edent.github.io/SuperTinyIcons/images/svg/briar.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/briar.png" width="256"> | 
Buffer | <img src="https://edent.github.io/SuperTinyIcons/images/svg/buffer.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/buffer.jpg" width="256"> | https://buffer.com/press
Bugcrowd | <img src="https://edent.github.io/SuperTinyIcons/images/svg/bugcrowd.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/bugcrowd.png" width="256"> | 
Bun | <img src="https://edent.github.io/SuperTinyIcons/images/svg/bun.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/bun.svg" width="256"> | https://bun.sh/
Calendar | <img src="https://edent.github.io/SuperTinyIcons/images/svg/calendar.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/calendar.png" width="256"> | https://medium.com/@theunitedindian200/2024-a-leap-year-e71c01bd293f
CentOS | <img src="https://edent.github.io/SuperTinyIcons/images/svg/centos.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/centos.svg" width="256"> | https://wiki.centos.org/ArtWork/Brand/Logo
Chrome | <img src="https://edent.github.io/SuperTinyIcons/images/svg/chrome.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/chrome.svg" width="256"> | https://www.google.com/chrome/static/images/chrome-logo.svg
Chromium | <img src="https://edent.github.io/SuperTinyIcons/images/svg/chromium.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/chromium.svg" width="256"> | https://www.chromium.org/
Citrix | <img src="https://edent.github.io/SuperTinyIcons/images/svg/citrix.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/citrix.svg" width="256"> | https://brand.citrix.com/brand-system/logo/
Citrix | <img src="https://edent.github.io/SuperTinyIcons/images/svg/citrix_compact.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/citrix_compact.png" width="256"> | https://brand.citrix.com/brand-system/compact-mark/
Clojure | <img src="https://edent.github.io/SuperTinyIcons/images/svg/clojure.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/clojure.png" width="256"> | https://clojure.org/index
Cloudflare | <img src="https://edent.github.io/SuperTinyIcons/images/svg/cloudflare.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/cloudflare.svg" width="256"> | https://www.cloudflare.com/logo/
Codeberg | <img src="https://edent.github.io/SuperTinyIcons/images/svg/codeberg.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/codeberg.svg" width="256"> | https://codeberg.org/img/logo.svg
CodePen | <img src="https://edent.github.io/SuperTinyIcons/images/svg/codepen.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/codepen.svg" width="256"> | https://blog.codepen.io/documentation/logos/
Coderwall | <img src="https://edent.github.io/SuperTinyIcons/images/svg/coderwall.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/coderwall.svg" width="256"> | https://coderwall.com/tos
CoffeeScript | <img src="https://edent.github.io/SuperTinyIcons/images/svg/coffeescript.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/coffeescript.svg" width="256"> | http://coffeescript.org/
Coil | <img src="https://edent.github.io/SuperTinyIcons/images/svg/coil.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/coil.svg" width="256"> | https://coil.com/
coinpot | <img src="https://edent.github.io/SuperTinyIcons/images/svg/coinpot.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/coinpot.png" width="256"> | 
Google Colab | <img src="https://edent.github.io/SuperTinyIcons/images/svg/colaboratory.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/colaboratory.svg" width="256"> | https://colab.research.google.com
C++ | <img src="https://edent.github.io/SuperTinyIcons/images/svg/cplusplus.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/cplusplus.png" width="256"> | https://isocpp.org/home/terms-of-use
Crystal | <img src="https://edent.github.io/SuperTinyIcons/images/svg/crystal.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/crystal.svg" width="256"> | https://crystal-lang.org/media/
CSS3 | <img src="https://edent.github.io/SuperTinyIcons/images/svg/css3.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/css3.svg" width="256"> | 
Dart | <img src="https://edent.github.io/SuperTinyIcons/images/svg/dart.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/dart.png" width="256"> | https://dart.dev/brand
DataCamp | <img src="https://edent.github.io/SuperTinyIcons/images/svg/datacamp.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/datacamp.png" width="256"> | https://www.datacamp.com/
Debian | <img src="https://edent.github.io/SuperTinyIcons/images/svg/debian.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/debian.svg" width="256"> | https://www.debian.org/logos/
Deezer | <img src="https://edent.github.io/SuperTinyIcons/images/svg/deezer.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/deezer.png" width="256"> | https://deezerbrand.com/
Delicious | <img src="https://edent.github.io/SuperTinyIcons/images/svg/delicious.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/delicious.png" width="256"> | https://del.icio.us/static/img/logo_delicious_sprite.png
dev.to | <img src="https://edent.github.io/SuperTinyIcons/images/svg/dev_to.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/dev_to.svg" width="256"> | https://dev.to/p/badges
DeviantArt | <img src="https://edent.github.io/SuperTinyIcons/images/svg/deviantart.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/deviantart.png" width="256"> | https://www.deviantart.com/
Digidentity | <img src="https://edent.github.io/SuperTinyIcons/images/svg/digidentity.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/digidentity.jpg" width="256"> | https://www.digidentity.eu/en/blog/
DigitalOcean | <img src="https://edent.github.io/SuperTinyIcons/images/svg/digitalocean.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/digitalocean.svg" width="256"> | https://www.digitalocean.com/company/logos-and-badges/
Discord | <img src="https://edent.github.io/SuperTinyIcons/images/svg/discord.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/discord.svg" width="256"> | https://discordapp.com/branding
Disqus | <img src="https://edent.github.io/SuperTinyIcons/images/svg/disqus.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/disqus.svg" width="256"> | https://disqus.com/brand/
Django Project | <img src="https://edent.github.io/SuperTinyIcons/images/svg/djangoproject.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/djangoproject.png" width="256"> | https://djangoproject.org/trademarks/
Docker | <img src="https://edent.github.io/SuperTinyIcons/images/svg/docker.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/docker.svg" width="256"> | https://www.docker.com/brand-guidelines
Dribble | <img src="https://edent.github.io/SuperTinyIcons/images/svg/dribbble.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/dribbble.png" width="256"> | https://dribbble.com/branding
Drone | <img src="https://edent.github.io/SuperTinyIcons/images/svg/drone.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/drone.png" width="256"> | https://github.com/drone/brand
Dropbox | <img src="https://edent.github.io/SuperTinyIcons/images/svg/dropbox.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/dropbox.svg" width="256"> | https://www.dropbox.com/branding
Drupal | <img src="https://edent.github.io/SuperTinyIcons/images/svg/drupal.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/drupal.svg" width="256"> | https://www.drupal.org/about/media-kit/logos
DuckDuckGo | <img src="https://edent.github.io/SuperTinyIcons/images/svg/duckduckgo.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/duckduckgo.svg" width="256"> | https://duckduckgo.com/press
Electronic Arts | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ea.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ea.svg" width="256"> | https://commons.wikimedia.org/wiki/File:EA-Logo.svg
eBay | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ebay.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ebay.svg" width="256"> | https://go.developer.ebay.com/logos
Ecosia | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ecosia.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ecosia.png" width="256"> | https://ecosia.co/ecosialogos
Edge | <img src="https://edent.github.io/SuperTinyIcons/images/svg/edge.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/edge.svg" width="256"> | https://www.microsoft.com/en-us/edge
elastic | <img src="https://edent.github.io/SuperTinyIcons/images/svg/elastic.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/elastic.svg" width="256"> | https://www.elastic.co
Element | <img src="https://edent.github.io/SuperTinyIcons/images/svg/element.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/element.svg" width="256"> | https://element.io/images/logo-mark-primary.svg
Elementary OS | <img src="https://edent.github.io/SuperTinyIcons/images/svg/elementaryos.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/elementaryos.png" width="256"> | https://elementary.io/images/brand/logomark.png
Email | <img src="https://edent.github.io/SuperTinyIcons/images/svg/email.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/email.png" width="256"> | https://commons.wikimedia.org/wiki/File:Mail_%28iOS%29.svg
Endeavour OS | <img src="https://edent.github.io/SuperTinyIcons/images/svg/endeavouros.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/endeavouros.png" width="256"> | https://github.com/endeavouros-team/endeavouros-theming
ePub | <img src="https://edent.github.io/SuperTinyIcons/images/svg/epub.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/epub.svg" width="256"> | http://idpf.org/sites/default/files/epub-logo.gif
Espressif | <img src="https://edent.github.io/SuperTinyIcons/images/svg/espressif.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/espressif.svg" width="256"> | 
Ethereum | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ethereum.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ethereum.svg" width="256"> | https://www.ethereum.org/
Etsy | <img src="https://edent.github.io/SuperTinyIcons/images/svg/etsy.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/etsy.png" width="256"> | https://www.etsy.com/uk/press?ref=ftr
Evernote | <img src="https://edent.github.io/SuperTinyIcons/images/svg/evernote.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/evernote.svg" width="256"> | https://evernote.com/media/pdf/evernote_quick_brand_guidelines.pdf
ExpressionEngine | <img src="https://edent.github.io/SuperTinyIcons/images/svg/expressionengine.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/expressionengine.png" width="256"> | https://expressionengine.com/about/trademark-use-policy
F-Droid | <img src="https://edent.github.io/SuperTinyIcons/images/svg/f-droid.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/f-droid.svg" width="256"> | https://gitlab.com/fdroid/fdroid-website/-/blob/master/assets/fdroid-logo.svg
Facebook | <img src="https://edent.github.io/SuperTinyIcons/images/svg/facebook.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/facebook.svg" width="256"> | https://en.facebookbrand.com/
Fediverse | <img src="https://edent.github.io/SuperTinyIcons/images/svg/fediverse.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/fediverse.svg" width="256"> | https://commons.wikimedia.org/wiki/File:Fediverse_logo_proposal.svg
Filestash | <img src="https://edent.github.io/SuperTinyIcons/images/svg/filestash.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/filestash.svg" width="256"> | https://www.filestash.app/
Finder | <img src="https://edent.github.io/SuperTinyIcons/images/svg/finder.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/finder.png" width="256"> | https://support.apple.com/en-us/HT201732/
Firefox | <img src="https://edent.github.io/SuperTinyIcons/images/svg/firefox.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/firefox.svg" width="256"> | https://mozilla.design/firefox/logos-usage/
Flattr | <img src="https://edent.github.io/SuperTinyIcons/images/svg/flattr.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/flattr.svg" width="256"> | https://commons.wikimedia.org/wiki/File:Flattrlogo250.svg
Flickr | <img src="https://edent.github.io/SuperTinyIcons/images/svg/flickr.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/flickr.png" width="256"> | https://www.flickr.com/images/opensearch-flickr-logo.png
Floatplane | <img src="https://edent.github.io/SuperTinyIcons/images/svg/floatplane.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/floatplane.svg" width="256"> | https://www.floatplane.com/
Flutter | <img src="https://edent.github.io/SuperTinyIcons/images/svg/flutter.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/flutter.svg" width="256"> | https://flutter.dev/brand
foobar2000 | <img src="https://edent.github.io/SuperTinyIcons/images/svg/foobar2000.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/foobar2000.png" width="256"> | https://www.foobar2000.org/
FreeBSD | <img src="https://edent.github.io/SuperTinyIcons/images/svg/freebsd.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/freebsd.png" width="256"> | https://freebsdfoundation.org/about-us/about-the-foundation/project/
freeCodeCamp | <img src="https://edent.github.io/SuperTinyIcons/images/svg/freecodecamp.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/freecodecamp.svg" width="256"> | https://design-style-guide.freecodecamp.org
Friendica | <img src="https://edent.github.io/SuperTinyIcons/images/svg/friendica.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/friendica.png" width="256"> | https://github.com/friendica/friendica/tree/develop/images
Fritz! | <img src="https://edent.github.io/SuperTinyIcons/images/svg/fritz.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/fritz.svg" width="256"> | https://en.wikipedia.org/wiki/Fritz!Box#/media/File:Fritz!.svg
Gandi | <img src="https://edent.github.io/SuperTinyIcons/images/svg/gandi.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/gandi.png" width="256"> | https://v4.gandi.net/static/images/illustrations/press/Gandi_LogoGuidelines_EN.pdf
GateHub | <img src="https://edent.github.io/SuperTinyIcons/images/svg/gatehub.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/gatehub.png" width="256"> | https://gatehub.net/
Gemini | <img src="https://edent.github.io/SuperTinyIcons/images/svg/gemini.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/gemini.svg" width="256"> | https://deepmind.google/technologies/gemini/
Ghost | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ghost.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ghost.svg" width="256"> | https://ghost.org/design/
Git | <img src="https://edent.github.io/SuperTinyIcons/images/svg/git.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/git.svg" width="256"> | https://git-scm.com/downloads/logos
Gitea | <img src="https://edent.github.io/SuperTinyIcons/images/svg/gitea.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/gitea.png" width="256"> | https://github.com/go-gitea/gitea/tree/master/assets
GitHub | <img src="https://edent.github.io/SuperTinyIcons/images/svg/github.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/github.svg" width="256"> | https://github.com/logos
GitLab | <img src="https://edent.github.io/SuperTinyIcons/images/svg/gitlab.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/gitlab.svg" width="256"> | https://about.gitlab.com/press/
Gitpod | <img src="https://edent.github.io/SuperTinyIcons/images/svg/gitpod.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/gitpod.svg" width="256"> | https://www.gitpod.io/media-kit
Glitch | <img src="https://edent.github.io/SuperTinyIcons/images/svg/glitch.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/glitch.svg" width="256"> | https://glitch.com/about/press/
Gmail | <img src="https://edent.github.io/SuperTinyIcons/images/svg/gmail.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/gmail.png" width="256"> | https://www.blog.google/press/
Go | <img src="https://edent.github.io/SuperTinyIcons/images/svg/go.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/go.svg" width="256"> | https://blog.golang.org/go-brand
Godot | <img src="https://edent.github.io/SuperTinyIcons/images/svg/godot.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/godot.svg" width="256"> | https://godotengine.org/press/
GOG.com | <img src="https://edent.github.io/SuperTinyIcons/images/svg/gogcom.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/gogcom.png" width="256"> | https://www.cdprojekt.com/en/media/logotypes/
Gojek | <img src="https://edent.github.io/SuperTinyIcons/images/svg/gojek.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/gojek.svg" width="256"> | https://www.gojek.com/id/terms-of-service/
Goodreads | <img src="https://edent.github.io/SuperTinyIcons/images/svg/goodreads.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/goodreads.png" width="256"> | https://www.goodreads.com/about/press
Google | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/google.svg" width="256"> | https://developers.google.com/identity/branding-guidelines
Google Assistant | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_assistant.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/google_assistant.png" width="256"> | https://www.blog.google/press/
Google Calendar | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_calendar.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/google_calendar.png" width="256"> | https://www.blog.google/press/
Google Collaborative content tools | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_collaborative_content_tools.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/google_collaborative_content_tools.png" width="256"> | https://www.blog.google/press/
Google Drive | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_drive.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/google_drive.png" width="256"> | https://developers.google.com/drive/api/v2/branding
Google Maps | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_maps.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/google_maps.svg" width="256"> | https://www.google.com/maps/about/
Google Meet | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_meet.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/google_meet.png" width="256"> | https://www.blog.google/press/
Google Play | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_play.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/google_play.svg" width="256"> | https://play.google.com/intl/en_us/badges/
Google+ | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_plus.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/google_plus.png" width="256"> | https://plus.google.com/+googleplus
Google Podcasts | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_podcasts.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/google_podcasts.png" width="256"> | https://play.google.com/store/apps/details?id=com.google.android.apps.podcasts&hl=en_GB
Google Scholar | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_scholar.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/google_scholar.ico" width="256"> | https://scholar.google.com/
Gradle | <img src="https://edent.github.io/SuperTinyIcons/images/svg/gradle.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/gradle.svg" width="256"> | 
Grafana | <img src="https://edent.github.io/SuperTinyIcons/images/svg/grafana.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/grafana.svg" width="256"> | https://github.com/grafana/grafana/blob/master/public/img/grafana_icon.svg
Guacamole | <img src="https://edent.github.io/SuperTinyIcons/images/svg/guacamole.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/guacamole.svg" width="256"> | https://www.apache.org/logos/?#guacamole
Guilded | <img src="https://edent.github.io/SuperTinyIcons/images/svg/guilded.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/guilded.png" width="256"> | https://www.guilded.gg/brand
h-card | <img src="https://edent.github.io/SuperTinyIcons/images/svg/h-card.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/h-card.svg" width="256"> | https://indieweb.org/IndieWebCamp:Copyrights
h-entry | <img src="https://edent.github.io/SuperTinyIcons/images/svg/h-entry.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/h-entry.svg" width="256"> | https://indieweb.org/IndieWebCamp:Copyrights
h-feed | <img src="https://edent.github.io/SuperTinyIcons/images/svg/h-feed.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/h-feed.svg" width="256"> | https://indieweb.org/IndieWebCamp:Copyrights
Hacker News | <img src="https://edent.github.io/SuperTinyIcons/images/svg/hackernews.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/hackernews.png" width="256"> | https://www.ycombinator.com/favicon.ico
HackerOne | <img src="https://edent.github.io/SuperTinyIcons/images/svg/hackerone.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/hackerone.png" width="256"> | https://www.hackerone.com/branding
HAML | <img src="https://edent.github.io/SuperTinyIcons/images/svg/haml.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/haml.svg" width="256"> | https://github.com/haml/haml/issues/819
Heroku | <img src="https://edent.github.io/SuperTinyIcons/images/svg/heroku.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/heroku.png" width="256"> | https://brand.heroku.com/
Homekit | <img src="https://edent.github.io/SuperTinyIcons/images/svg/homekit.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/homekit.svg" width="256"> | https://developer.apple.com/design/human-interface-guidelines/homekit/overview/icons/
HP | <img src="https://edent.github.io/SuperTinyIcons/images/svg/hp.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/hp.png" width="256"> | https://www.hp.com/
HTML5 | <img src="https://edent.github.io/SuperTinyIcons/images/svg/html5.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/html5.svg" width="256"> | https://www.w3.org/html/logo/
Hulu | <img src="https://edent.github.io/SuperTinyIcons/images/svg/hulu.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/hulu.svg" width="256"> | https://thisis.hulu.com/#hulu-logo
Humble Bundle | <img src="https://edent.github.io/SuperTinyIcons/images/svg/humblebundle.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/humblebundle.svg" width="256"> | https://cdn.worldvectorlogo.com/logos/humblebundle.svg
i18next | <img src="https://edent.github.io/SuperTinyIcons/images/svg/i18next.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/i18next.png" width="256"> | https://www.i18next.com/
IBM | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ibm.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ibm.svg" width="256"> | https://www-03.ibm.com/ibm/history/exhibits/logo/logo_8.html
iHeartRadio | <img src="https://edent.github.io/SuperTinyIcons/images/svg/iheartradio.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/iheartradio.png" width="256"> | https://www.iheart.com/
IMDb | <img src="https://edent.github.io/SuperTinyIcons/images/svg/imdb.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/imdb.svg" width="256"> | https://imdb.com/
Imgur | <img src="https://edent.github.io/SuperTinyIcons/images/svg/imgur.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/imgur.svg" width="256"> | https://imgurinc.com/press
Instagram | <img src="https://edent.github.io/SuperTinyIcons/images/svg/instagram.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/instagram.svg" width="256"> | https://en.instagram-brand.com/
Intel | <img src="https://edent.github.io/SuperTinyIcons/images/svg/intel.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/intel.svg" width="256"> | https://www.intel.com/content/www/us/en/company-overview/visual-brand-identity.html
Intercom | <img src="https://edent.github.io/SuperTinyIcons/images/svg/intercom.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/intercom.svg" width="256"> | https://www.intercom.com/press
Internet Archive | <img src="https://edent.github.io/SuperTinyIcons/images/svg/internet_archive.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/internet_archive.svg" width="256"> | https://commons.wikimedia.org/wiki/File:Internet_Archive_logo_and_wordmark.svg
itch.io | <img src="https://edent.github.io/SuperTinyIcons/images/svg/itch_io.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/itch_io.svg" width="256"> | https://itch.io/press-kit
iTunes | <img src="https://edent.github.io/SuperTinyIcons/images/svg/itunes_podcasts.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/itunes_podcasts.svg" width="256"> | https://www.apple.com/itunes/marketing-on-podcasts/identity-guidelines.html
Jacobin | <img src="https://edent.github.io/SuperTinyIcons/images/svg/jacobin.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/jacobin.svg" width="256"> | https://www.jacobinmag.com/contact
Java | <img src="https://edent.github.io/SuperTinyIcons/images/svg/java.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/java.svg" width="256"> | http://www.oracle.com/us/technologies/java/java-licensing-logo-guidelines-1908204.pdf
JavaScript | <img src="https://edent.github.io/SuperTinyIcons/images/svg/javascript.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/javascript.svg" width="256"> | https://commons.wikimedia.org/wiki/File:Unofficial_JavaScript_logo_2.svg
Jellyfin | <img src="https://edent.github.io/SuperTinyIcons/images/svg/jellyfin.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/jellyfin.png" width="256"> | https://raw.githubusercontent.com/jellyfin/jellyfin-web/master/src/assets/img/banner-dark.png
jQuery | <img src="https://edent.github.io/SuperTinyIcons/images/svg/jquery.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/jquery.svg" width="256"> | https://brand.jquery.org/logos
JSON-LD | <img src="https://edent.github.io/SuperTinyIcons/images/svg/json-ld.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/json-ld.svg" width="256"> | https://json-ld.org/images/
JSON | <img src="https://edent.github.io/SuperTinyIcons/images/svg/json.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/json.png" width="256"> | https://json.org/
JSON Feed | <img src="https://edent.github.io/SuperTinyIcons/images/svg/jsonfeed.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/jsonfeed.svg" width="256"> | https://www.jsonfeed.org/
JSR | <img src="https://edent.github.io/SuperTinyIcons/images/svg/jsr.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/jsr.svg" width="256"> | https://jsr.io/
Julia | <img src="https://edent.github.io/SuperTinyIcons/images/svg/julia.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/julia.svg" width="256"> | https://julialang.org
JustGiving | <img src="https://edent.github.io/SuperTinyIcons/images/svg/justgiving.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/justgiving.png" width="256"> | https://justgiving-developer.zendesk.com/hc/en-us/articles/14308756536337
Kaggle | <img src="https://edent.github.io/SuperTinyIcons/images/svg/kaggle.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/kaggle.png" width="256"> | https://www.kaggle.com/
KeePassDX | <img src="https://edent.github.io/SuperTinyIcons/images/svg/keepassdx.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/keepassdx.svg" width="256"> | https://www.keepassdx.com/
Kemal Framework | <img src="https://edent.github.io/SuperTinyIcons/images/svg/kemal.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/kemal.png" width="256"> | https://raw.githubusercontent.com/kemalcr/kemalcr.com/master/img/kemal.png
Keskonfai | <img src="https://edent.github.io/SuperTinyIcons/images/svg/keskonfai.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/keskonfai.png" width="256"> | https://www.keskonfai.fr/
Keybase | <img src="https://edent.github.io/SuperTinyIcons/images/svg/keybase.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/keybase.svg" width="256"> | https://github.com/keybase/client/blob/master/shared/images/iconfont/kb-iconfont-keybase-16.svg
Kickstarter | <img src="https://edent.github.io/SuperTinyIcons/images/svg/kickstarter.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/kickstarter.svg" width="256"> | https://www.kickstarter.com/help/brand_assets
Ko-Fi | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ko-fi.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ko-fi.jpg" width="256"> | https://ko-fi.com/
Kodi | <img src="https://edent.github.io/SuperTinyIcons/images/svg/kodi.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/kodi.svg" width="256"> | https://kodi.tv/
Kotlin | <img src="https://edent.github.io/SuperTinyIcons/images/svg/kotlin.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/kotlin.svg" width="256"> | https://resources.jetbrains.com/storage/products/kotlin/docs/kotlin_logos.zip
Laravel | <img src="https://edent.github.io/SuperTinyIcons/images/svg/laravel.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/laravel.svg" width="256"> | https://github.com/laravel/art/blob/master/Laravel-l-slant.svg
LastPass | <img src="https://edent.github.io/SuperTinyIcons/images/svg/lastpass.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/lastpass.svg" width="256"> | https://lastpass.com/press-room/
LeetCode Logo | <img src="https://edent.github.io/SuperTinyIcons/images/svg/leetcode.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/leetcode.png" width="256"> | https://leetcode.com/
Liberapay | <img src="https://edent.github.io/SuperTinyIcons/images/svg/liberapay.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/liberapay.svg" width="256"> | https://github.com/liberapay/liberapay.com/blob/master/www/assets/liberapay/icon-v2_yellow-r.svg
LibreSpeed | <img src="https://edent.github.io/SuperTinyIcons/images/svg/librespeed.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/librespeed.svg" width="256"> | https://github.com/librespeed/speedtest/blob/master/.logo/LibreSpeed.svg
LINE | <img src="https://edent.github.io/SuperTinyIcons/images/svg/line.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/line.svg" width="256"> | https://line.me/en/logo
Linear | <img src="https://edent.github.io/SuperTinyIcons/images/svg/linearapp.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/linearapp.svg" width="256"> | https://linear.app/brand
LinkedIn | <img src="https://edent.github.io/SuperTinyIcons/images/svg/linkedin.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/linkedin.svg" width="256"> | https://brand.linkedin.com/
Linux | <img src="https://edent.github.io/SuperTinyIcons/images/svg/linux.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/linux.svg" width="256"> | https://www.linuxfoundation.org/trademark-usage/
Linux Mint | <img src="https://edent.github.io/SuperTinyIcons/images/svg/linux_mint.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/linux_mint.svg" width="256"> | https://commons.wikimedia.org/wiki/File:Linux_Mint_logo_without_wordmark.svg
Lobste.rs | <img src="https://edent.github.io/SuperTinyIcons/images/svg/lobsters.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/lobsters.png" width="256"> | https://lobste.rs/
Lock | <img src="https://edent.github.io/SuperTinyIcons/images/svg/lock.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/lock.png" width="256"> | https://www.freepik.com/icon/lock_449932
Logitech | <img src="https://edent.github.io/SuperTinyIcons/images/svg/logitech.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/logitech.png" width="256"> | https://www.logitech.com/en-au
Lucky Framework | <img src="https://edent.github.io/SuperTinyIcons/images/svg/luckyframework.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/luckyframework.png" width="256"> | https://luckyframework.org/
macOS | <img src="https://edent.github.io/SuperTinyIcons/images/svg/macos.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/macos.svg" width="256"> | https://www.apple.com/mac/
Mail | <img src="https://edent.github.io/SuperTinyIcons/images/svg/mail.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/mail.png" width="256"> | https://www.flaticon.com/free-icon/at-sign_9192388
Mailchimp | <img src="https://edent.github.io/SuperTinyIcons/images/svg/mailchimp.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/mailchimp.svg" width="256"> | https://mailchimp.com/about/brand-assets/
Malt | <img src="https://edent.github.io/SuperTinyIcons/images/svg/malt.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/malt.svg" width="256"> | 
Manjaro | <img src="https://edent.github.io/SuperTinyIcons/images/svg/manjaro.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/manjaro.svg" width="256"> | https://manjaro.org/img/logo.svg
Markdown | <img src="https://edent.github.io/SuperTinyIcons/images/svg/markdown.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/markdown.png" width="256"> | https://www.markdownguide.org/
mastercard | <img src="https://edent.github.io/SuperTinyIcons/images/svg/mastercard.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/mastercard.svg" width="256"> | https://www.mastercard.com/global/en.html
Mastodon | <img src="https://edent.github.io/SuperTinyIcons/images/svg/mastodon.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/mastodon.svg" width="256"> | https://github.com/tootsuite/joinmastodon/blob/master/public/press-kit.zip
matrix | <img src="https://edent.github.io/SuperTinyIcons/images/svg/matrix.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/matrix.svg" width="256"> | 
Mattermost | <img src="https://edent.github.io/SuperTinyIcons/images/svg/mattermost.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/mattermost.png" width="256"> | https://www.mattermost.org/brand-guidelines/
McDonald's | <img src="https://edent.github.io/SuperTinyIcons/images/svg/mcdonald_s.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/mcdonald_s.png" width="256"> | https://corporate.mcdonalds.com/corpmcd/our-stories/media-assets-library/media-article/golden_arches_logo.html
Medium | <img src="https://edent.github.io/SuperTinyIcons/images/svg/medium.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/medium.svg" width="256"> | https://medium.design/logos-and-brand-guidelines-f1a01a733592
Meetup | <img src="https://edent.github.io/SuperTinyIcons/images/svg/meetup.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/meetup.png" width="256"> | https://a248.e.akamai.net/secure.meetupstatic.com/photos/event/8/f/1/d/highres_454596637.jpeg
Messenger | <img src="https://edent.github.io/SuperTinyIcons/images/svg/messenger.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/messenger.svg" width="256"> | https://en.facebookbrand.com/assets/messenger/
microformats | <img src="https://edent.github.io/SuperTinyIcons/images/svg/microformats.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/microformats.png" width="256"> | 
Microsoft | <img src="https://edent.github.io/SuperTinyIcons/images/svg/microsoft.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/microsoft.png" width="256"> | https://news.microsoft.com/mssurfacehub_logo_stacked_c-white_rgb/
Minecraft | <img src="https://edent.github.io/SuperTinyIcons/images/svg/minecraft.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/minecraft.png" width="256"> | https://account.mojang.com/terms
MongoDB | <img src="https://edent.github.io/SuperTinyIcons/images/svg/mongodb.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/mongodb.svg" width="256"> | https://www.mongodb.com/brand-resources
MySQL | <img src="https://edent.github.io/SuperTinyIcons/images/svg/mysql.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/mysql.svg" width="256"> | https://www.mysql.com/about/legal/logos.html
NetBeans | <img src="https://edent.github.io/SuperTinyIcons/images/svg/netbeans.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/netbeans.png" width="256"> | https://www.apache.org/logos/res/netbeans/netbeans.png
NetBSD | <img src="https://edent.github.io/SuperTinyIcons/images/svg/netbsd.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/netbsd.png" width="256"> | https://www.netbsd.org/gallery/logos.html
Netflix | <img src="https://edent.github.io/SuperTinyIcons/images/svg/netflix.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/netflix.png" width="256"> | https://brand.netflix.com/en/assets/brand-symbol/
NextCloud | <img src="https://edent.github.io/SuperTinyIcons/images/svg/nextcloud.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/nextcloud.svg" width="256"> | https://nextcloud.com/press/
NGINX | <img src="https://edent.github.io/SuperTinyIcons/images/svg/nginx.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/nginx.svg" width="256"> | https://www.nginx.com/
NHS | <img src="https://edent.github.io/SuperTinyIcons/images/svg/nhs.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/nhs.jpg" width="256"> | https://www.england.nhs.uk/nhsidentity/identity-guidelines/nhs-logo/
NixOS | <img src="https://edent.github.io/SuperTinyIcons/images/svg/nixos.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/nixos.svg" width="256"> | https://github.com/NixOS/nixos-artwork/blob/master/logo/README.md
Node.js | <img src="https://edent.github.io/SuperTinyIcons/images/svg/nodejs.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/nodejs.svg" width="256"> | https://nodejs.org/static/documents/foundation-visual-guidelines.pdf
npm | <img src="https://edent.github.io/SuperTinyIcons/images/svg/npm.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/npm.svg" width="256"> | https://github.com/npm/logos
OK.ru | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ok.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ok.png" width="256"> | https://insideok.ru/brandbook
Olympic Rings | <img src="https://edent.github.io/SuperTinyIcons/images/svg/olympics.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/olympics.svg" width="256"> | 
OnlyFans | <img src="https://edent.github.io/SuperTinyIcons/images/svg/onlyfans.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/onlyfans.svg" width="256"> | https://onlyfans.com/brand
OpenBenches | <img src="https://edent.github.io/SuperTinyIcons/images/svg/openbenches.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/openbenches.svg" width="256"> | https://openbenches.org/
Open Bug Bounty | <img src="https://edent.github.io/SuperTinyIcons/images/svg/openbugbounty.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/openbugbounty.svg" width="256"> | https://www.openbugbounty.org
Opencast | <img src="https://edent.github.io/SuperTinyIcons/images/svg/opencast.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/opencast.svg" width="256"> | http://www.opencast.org/
Open Collective | <img src="https://edent.github.io/SuperTinyIcons/images/svg/opencollective.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/opencollective.svg" width="256"> | https://docs.opencollective.com/help/about/introduction#media-logo
OpenCores | <img src="https://edent.github.io/SuperTinyIcons/images/svg/opencores.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/opencores.png" width="256"> | https://opencores.org
Open Source | <img src="https://edent.github.io/SuperTinyIcons/images/svg/opensource.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/opensource.png" width="256"> | https://opensource.org/logo-usage-guidelines
OpenStreetMap | <img src="https://edent.github.io/SuperTinyIcons/images/svg/openstreetmap.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/openstreetmap.png" width="256"> | https://wiki.openstreetmap.org/wiki/Logos#Other_logos
OpenVPN | <img src="https://edent.github.io/SuperTinyIcons/images/svg/openvpn.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/openvpn.svg" width="256"> | https://openvpn.net/
Opera | <img src="https://edent.github.io/SuperTinyIcons/images/svg/opera.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/opera.svg" width="256"> | https://brand.opera.com/1472-2/opera-logos/
Orcid | <img src="https://edent.github.io/SuperTinyIcons/images/svg/orcid.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/orcid.png" width="256"> | https://orcid.org/
Origin | <img src="https://edent.github.io/SuperTinyIcons/images/svg/origin.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/origin.png" width="256"> | https://www.origin.com/
Outlook | <img src="https://edent.github.io/SuperTinyIcons/images/svg/outlook.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/outlook.jpg" width="256"> | https://ow2.res.office365.com/owalanding/2021.8.25.01/images/outlook-icon.jpg
Overcast | <img src="https://edent.github.io/SuperTinyIcons/images/svg/overcast.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/overcast.svg" width="256"> | https://overcast.fm
Overleaf | <img src="https://edent.github.io/SuperTinyIcons/images/svg/overleaf.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/overleaf.svg" width="256"> | https://www.overleaf.com/for/partners/logos
Patreon | <img src="https://edent.github.io/SuperTinyIcons/images/svg/patreon.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/patreon.svg" width="256"> | https://www.patreon.com/brand/guidelines
PayPal | <img src="https://edent.github.io/SuperTinyIcons/images/svg/paypal.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/paypal.png" width="256"> | https://www.paypal-marketing.com/html/partner/na/pdf/PayPal_Cobranding_guidelines_dec_2013.pdf
PDF | <img src="https://edent.github.io/SuperTinyIcons/images/svg/pdf.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/pdf.svg" width="256"> | https://www.adobe.com/content/dam/acom/en/legal/documents/Adobe_Trademark_Guidelines_11012014.pdf
PeerTube | <img src="https://edent.github.io/SuperTinyIcons/images/svg/peertube.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/peertube.png" width="256"> | https://joinpeertube.org
Phone | <img src="https://edent.github.io/SuperTinyIcons/images/svg/phone.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/phone.png" width="256"> | https://iconscout.com/free-icon/apple-phone-2
PHP | <img src="https://edent.github.io/SuperTinyIcons/images/svg/php.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/php.svg" width="256"> | https://secure.php.net/download-logos.php
Pinboard | <img src="https://edent.github.io/SuperTinyIcons/images/svg/pinboard.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/pinboard.png" width="256"> | https://twitter.com/pinboard
Pinterest | <img src="https://edent.github.io/SuperTinyIcons/images/svg/pinterest.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/pinterest.svg" width="256"> | https://business.pinterest.com/en-gb/brand-guidelines
Pixelfed | <img src="https://edent.github.io/SuperTinyIcons/images/svg/pixelfed.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/pixelfed.svg" width="256"> | https://pixelfed.org/
PlayStation | <img src="https://edent.github.io/SuperTinyIcons/images/svg/playstation.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/playstation.svg" width="256"> | https://www.playstation.com/en-gb/
Plex | <img src="https://edent.github.io/SuperTinyIcons/images/svg/plex.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/plex.svg" width="256"> | http://brand.plex.tv/d/qxmJ3odkK0fj/plex-style-guide
Pocket | <img src="https://edent.github.io/SuperTinyIcons/images/svg/pocket.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/pocket.svg" width="256"> | https://blog.getpocket.com/press/
Pocket Casts | <img src="https://edent.github.io/SuperTinyIcons/images/svg/pocketcasts.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/pocketcasts.png" width="256"> | https://static2.pocketcasts.com/assets/pc_press_kit.zip
Pop!_OS | <img src="https://edent.github.io/SuperTinyIcons/images/svg/popos.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/popos.png" width="256"> | 
Pornhub | <img src="https://edent.github.io/SuperTinyIcons/images/svg/pornhub.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/pornhub.png" width="256"> | https://www.pornhub.org/press
Postman | <img src="https://edent.github.io/SuperTinyIcons/images/svg/postman.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/postman.svg" width="256"> | https://www.postman.com/company/press-media/#:~:text=Logo%20guidelines,process%20and%20submit%20a%20requ
PowerShell | <img src="https://edent.github.io/SuperTinyIcons/images/svg/powershell.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/powershell.svg" width="256"> | https://learn.microsoft.com/en-us/powershell/scripting/community/digital-art?view=powershell-7.3
Preact | <img src="https://edent.github.io/SuperTinyIcons/images/svg/preact.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/preact.svg" width="256"> | https://preactjs.com
Printer | <img src="https://edent.github.io/SuperTinyIcons/images/svg/print.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/print.svg" width="256"> | https://www.iconfinder.com/icons/326675/print_icon#size=512
Proton Mail | <img src="https://edent.github.io/SuperTinyIcons/images/svg/protonmail.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/protonmail.svg" width="256"> | https://protonmail.com/media-kit
Python | <img src="https://edent.github.io/SuperTinyIcons/images/svg/python.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/python.svg" width="256"> | https://www.python.org/community/logos/
QQ | <img src="https://edent.github.io/SuperTinyIcons/images/svg/qq.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/qq.png" width="256"> | http://www.imqq.com/English1033.html
quora | <img src="https://edent.github.io/SuperTinyIcons/images/svg/quora.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/quora.jpg" width="256"> | https://www.quora.com/
Raspberry Pi | <img src="https://edent.github.io/SuperTinyIcons/images/svg/raspberry_pi.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/raspberry_pi.png" width="256"> | https://www.raspberrypi.org/trademark-rules/
React | <img src="https://edent.github.io/SuperTinyIcons/images/svg/react.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/react.svg" width="256"> | https://github.com/facebook/react/blob/master/fixtures/dom/public/react-logo.svg
Reddit | <img src="https://edent.github.io/SuperTinyIcons/images/svg/reddit.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/reddit.svg" width="256"> | https://web.archive.org/web/20160306165444/https://www.reddit.com/about/alien/
RedHat | <img src="https://edent.github.io/SuperTinyIcons/images/svg/redhat.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/redhat.svg" width="256"> | https://www.redhat.com/
Research Gate | <img src="https://edent.github.io/SuperTinyIcons/images/svg/researchgate.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/researchgate.png" width="256"> | https://mobile.twitter.com/ResearchGate/photo
Rockstar Games | <img src="https://edent.github.io/SuperTinyIcons/images/svg/rockstar.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/rockstar.svg" width="256"> | https://www.rockstargames.com/
Roundcube | <img src="https://edent.github.io/SuperTinyIcons/images/svg/roundcube.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/roundcube.svg" width="256"> | https://roundcube.net/images/roundcube_logo_icon.svg
RSS | <img src="https://edent.github.io/SuperTinyIcons/images/svg/rss.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/rss.svg" width="256"> | http://www.feedicons.com/
Ruby | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ruby.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ruby.svg" width="256"> | https://www.ruby-lang.org/en/about/logo/
Ruby Gems | <img src="https://edent.github.io/SuperTinyIcons/images/svg/rubygems.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/rubygems.png" width="256"> | https://rubygems.org
Ruby On Rails | <img src="https://edent.github.io/SuperTinyIcons/images/svg/rubyonrails.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/rubyonrails.png" width="256"> | https://rubyonrails.org/trademarks/
Rust | <img src="https://edent.github.io/SuperTinyIcons/images/svg/rust.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/rust.svg" width="256"> | https://www.rust-lang.org/policies/media-guide
Safari | <img src="https://edent.github.io/SuperTinyIcons/images/svg/safari.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/safari.svg" width="256"> | https://www.apple.com/uk/safari/
Samsung | <img src="https://edent.github.io/SuperTinyIcons/images/svg/samsung.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/samsung.svg" width="256"> | https://commons.wikimedia.org/wiki/File:Samsung_Logo.svg
Samsung Internet | <img src="https://edent.github.io/SuperTinyIcons/images/svg/samsung_internet.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/samsung_internet.svg" width="256"> | https://commons.wikimedia.org/wiki/File:Samsung_Internet_logo.svg
Samsung | <img src="https://edent.github.io/SuperTinyIcons/images/svg/samsung_s.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/samsung_s.svg" width="256"> | https://www.svgrepo.com/svg/349501/samsung-s
Samsung | <img src="https://edent.github.io/SuperTinyIcons/images/svg/samsung_swoop.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/samsung_swoop.png" width="256"> | https://www.samsung.com/in/?srsltid=AfmBOorcWZ_DcTEx1whMJ4bv9Y6BTBISGULV7GzsMNk5GvF1PWDxyrrj
Sass | <img src="https://edent.github.io/SuperTinyIcons/images/svg/sass.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/sass.png" width="256"> | https://sass-lang.com/styleguide/brand
Semaphore CI | <img src="https://edent.github.io/SuperTinyIcons/images/svg/semaphoreci.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/semaphoreci.png" width="256"> | https://twitter.com/semaphoreci
Sentry | <img src="https://edent.github.io/SuperTinyIcons/images/svg/sentry.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/sentry.svg" width="256"> | https://sentry.io/branding/
Signal | <img src="https://edent.github.io/SuperTinyIcons/images/svg/signal.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/signal.png" width="256"> | https://signal.org/
Sketch | <img src="https://edent.github.io/SuperTinyIcons/images/svg/sketch.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/sketch.svg" width="256"> | https://www.sketchapp.com/
Skype | <img src="https://edent.github.io/SuperTinyIcons/images/svg/skype.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/skype.svg" width="256"> | https://www.skype.com/en/legal/brand-guidelines/
Slack | <img src="https://edent.github.io/SuperTinyIcons/images/svg/slack.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/slack.svg" width="256"> | https://slack.com/media-kit
SlideShare | <img src="https://edent.github.io/SuperTinyIcons/images/svg/slideshare.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/slideshare.png" width="256"> | https://www.slideshare.net/about/logos
Snapchat | <img src="https://edent.github.io/SuperTinyIcons/images/svg/snapchat.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/snapchat.svg" width="256"> | https://www.snap.com/en-US/brand-guidelines/
SOGo | <img src="https://edent.github.io/SuperTinyIcons/images/svg/sogo.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/sogo.svg" width="256"> | https://www.sogo.nu/
Solidity | <img src="https://edent.github.io/SuperTinyIcons/images/svg/solidity.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/solidity.svg" width="256"> | https://docs.soliditylang.org/en/latest/brand-guide.html
SoundCloud | <img src="https://edent.github.io/SuperTinyIcons/images/svg/soundcloud.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/soundcloud.png" width="256"> | https://developers.soundcloud.com/docs/api/buttons-logos
Spotify | <img src="https://edent.github.io/SuperTinyIcons/images/svg/spotify.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/spotify.svg" width="256"> | https://developer.spotify.com/design/
Square Cash | <img src="https://edent.github.io/SuperTinyIcons/images/svg/square_cash.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/square_cash.jpg" width="256"> | https://squareup.com/us/en/press
Stack Exchange | <img src="https://edent.github.io/SuperTinyIcons/images/svg/stackexchange.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/stackexchange.svg" width="256"> | https://stackoverflow.com/company/logos
Stack Overflow | <img src="https://edent.github.io/SuperTinyIcons/images/svg/stackoverflow.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/stackoverflow.svg" width="256"> | https://stackoverflow.com/company/logos
Steam | <img src="https://edent.github.io/SuperTinyIcons/images/svg/steam.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/steam.svg" width="256"> | https://steamcdn-a.akamaihd.net/steamcommunity/public/images/steamworks_docs/english/Steam_Guidelines_20170524.pdf
Stitcher | <img src="https://edent.github.io/SuperTinyIcons/images/svg/stitcher.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/stitcher.png" width="256"> | https://itunes.apple.com/us/app/stitcher-for-podcasts/id288087905
Strava | <img src="https://edent.github.io/SuperTinyIcons/images/svg/strava.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/strava.png" width="256"> | https://www.strava.com/settings/badges
StumbleUpon | <img src="https://edent.github.io/SuperTinyIcons/images/svg/stumbleupon.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/stumbleupon.png" width="256"> | https://en.wikipedia.org/wiki/StumbleUpon#/media/File:StumbleUpon_Logo.svg
Sublime Merge | <img src="https://edent.github.io/SuperTinyIcons/images/svg/sublimemerge.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/sublimemerge.png" width="256"> | https://www.sublimehq.com/
Sublime Text | <img src="https://edent.github.io/SuperTinyIcons/images/svg/sublimetext.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/sublimetext.png" width="256"> | https://www.sublimetext.com/
SubscribeStar | <img src="https://edent.github.io/SuperTinyIcons/images/svg/subscribestar.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/subscribestar.png" width="256"> | https://www.subscribestar.com/brand
Svelte | <img src="https://edent.github.io/SuperTinyIcons/images/svg/svelte.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/svelte.png" width="256"> | https://github.com/sveltejs/branding
SVG | <img src="https://edent.github.io/SuperTinyIcons/images/svg/svg.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/svg.svg" width="256"> | https://www.w3.org/Graphics/SVG/
Swift | <img src="https://edent.github.io/SuperTinyIcons/images/svg/swift.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/swift.svg" width="256"> | https://developer.apple.com/swift/resources/
Symantec | <img src="https://edent.github.io/SuperTinyIcons/images/svg/symantec.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/symantec.png" width="256"> | https://www.symantec.com/about/newsroom/digital-asset-gallery/logos
Symfony | <img src="https://edent.github.io/SuperTinyIcons/images/svg/symfony.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/symfony.svg" width="256"> | https://symfony.com/logo
taiga.io | <img src="https://edent.github.io/SuperTinyIcons/images/svg/taiga.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/taiga.svg" width="256"> | 
tailwindCss | <img src="https://edent.github.io/SuperTinyIcons/images/svg/tailwindCss.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/tailwindCss.svg" width="256"> | https://tailwindcss.com/brand
TATA | <img src="https://edent.github.io/SuperTinyIcons/images/svg/tata.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/tata.png" width="256"> | https://www.tata.com/
Teamspeak | <img src="https://edent.github.io/SuperTinyIcons/images/svg/teamspeak.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/teamspeak.png" width="256"> | https://www.teamspeak.com/en/
Telegram | <img src="https://edent.github.io/SuperTinyIcons/images/svg/telegram.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/telegram.svg" width="256"> | https://telegram.org/tour/screenshots
Terraform | <img src="https://edent.github.io/SuperTinyIcons/images/svg/terraform.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/terraform.svg" width="256"> | https://www.terraform.io/logos.html
This American Life | <img src="https://edent.github.io/SuperTinyIcons/images/svg/thisamericanlife.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/thisamericanlife.png" width="256"> | https://www.npr.org/about-npr/179876898/terms-of-use
Threads | <img src="https://edent.github.io/SuperTinyIcons/images/svg/threads.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/threads.svg" width="256"> | https://en.wikipedia.org/wiki/File:Threads_(app)_logo.svg
Threema | <img src="https://edent.github.io/SuperTinyIcons/images/svg/threema.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/threema.svg" width="256"> | https://threema.ch/en/press
TikTok | <img src="https://edent.github.io/SuperTinyIcons/images/svg/tiktok.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/tiktok.svg" width="256"> | https://www.tiktok.com
Todoist | <img src="https://edent.github.io/SuperTinyIcons/images/svg/todoist.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/todoist.png" width="256"> | https://doist.com/press
Tox | <img src="https://edent.github.io/SuperTinyIcons/images/svg/tox.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/tox.svg" width="256"> | https://github.com/Tox/tox.chat/blob/master/themes/website/static/img/icon.svg
Trello | <img src="https://edent.github.io/SuperTinyIcons/images/svg/trello.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/trello.svg" width="256"> | https://www.atlassian.com/company/news/press-kit
TripAdvisor | <img src="https://edent.github.io/SuperTinyIcons/images/svg/tripadvisor.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/tripadvisor.svg" width="256"> | https://tripadvisor.mediaroom.com/download/TheNewTripAdvisor_StyleGuide.pdf
Tumblr | <img src="https://edent.github.io/SuperTinyIcons/images/svg/tumblr.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/tumblr.svg" width="256"> | https://www.tumblr.com/logo
TuneIn | <img src="https://edent.github.io/SuperTinyIcons/images/svg/tunein.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/tunein.svg" width="256"> | https://cms.tunein.com/wp-content/uploads/2018/08/TuneIn-Media-Kit-Q3-2018-.pdf
Tutanota | <img src="https://edent.github.io/SuperTinyIcons/images/svg/tutanota.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/tutanota.svg" width="256"> | 
Twilio | <img src="https://edent.github.io/SuperTinyIcons/images/svg/twilio.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/twilio.svg" width="256"> | https://www.twilio.com/marketing/bundles/company-brand/resources/Twilio-Logos.zip
Twitch | <img src="https://edent.github.io/SuperTinyIcons/images/svg/twitch.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/twitch.svg" width="256"> | https://www.twitch.tv/p/brand/
Twitter | <img src="https://edent.github.io/SuperTinyIcons/images/svg/twitter.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/twitter.svg" width="256"> | https://about.twitter.com/en/who-we-are/brand-toolkit
TypeScript | <img src="https://edent.github.io/SuperTinyIcons/images/svg/typescript.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/typescript.svg" width="256"> | 
Uber | <img src="https://edent.github.io/SuperTinyIcons/images/svg/uber.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/uber.jpg" width="256"> | https://brand.uber.com/guide#logo-clearspace
Ubiquiti | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ubiquiti.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ubiquiti.jpg" width="256"> | https://pbs.twimg.com/profile_images/862701781368713216/B7oW421__400x400.jpg
Ubisoft | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ubisoft.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ubisoft.png" width="256"> | https://icon-icons.com/download/136078/PNG/512/
Ubuntu | <img src="https://edent.github.io/SuperTinyIcons/images/svg/ubuntu.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/ubuntu.svg" width="256"> | https://design.ubuntu.com/brand/ubuntu-logo/
Udemy | <img src="https://edent.github.io/SuperTinyIcons/images/svg/udemy.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/udemy.png" width="256"> | 
Unicode | <img src="https://edent.github.io/SuperTinyIcons/images/svg/unicode.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/unicode.svg" width="256"> | https://www.unicode.org/policies/logo_policy.html
Untappd | <img src="https://edent.github.io/SuperTinyIcons/images/svg/untappd.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/untappd.svg" width="256"> | https://commons.wikimedia.org/wiki/File:Untappd.svg
Uphold | <img src="https://edent.github.io/SuperTinyIcons/images/svg/uphold.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/uphold.png" width="256"> | https://uphold.com/en/press-media
Vagrant | <img src="https://edent.github.io/SuperTinyIcons/images/svg/vagrant.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/vagrant.png" width="256"> | https://www.vagrantup.com/files/press-kit.zip
Vegetarian | <img src="https://edent.github.io/SuperTinyIcons/images/svg/vegetarian.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/vegetarian.png" width="256"> | https://www.v-label.com/
Venmo | <img src="https://edent.github.io/SuperTinyIcons/images/svg/venmo.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/venmo.svg" width="256"> | https://venmo.com/about/brand
Viber | <img src="https://edent.github.io/SuperTinyIcons/images/svg/viber.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/viber.png" width="256"> | https://www.viber.com/en/
Vim | <img src="https://edent.github.io/SuperTinyIcons/images/svg/vim.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/vim.png" width="256"> | https://www.vim.org/logos.php
Vimeo | <img src="https://edent.github.io/SuperTinyIcons/images/svg/vimeo.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/vimeo.svg" width="256"> | https://press.vimeo.com/brand-guidelines
visa | <img src="https://edent.github.io/SuperTinyIcons/images/svg/visa.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/visa.png" width="256"> | https://www.merchantsignage.visa.com/brand_guidelines
Visual Studio Code | <img src="https://edent.github.io/SuperTinyIcons/images/svg/visualstudiocode.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/visualstudiocode.svg" width="256"> | https://code.visualstudio.com/brand
Vivino | <img src="https://edent.github.io/SuperTinyIcons/images/svg/vivino.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/vivino.svg" width="256"> | https://www.vivino.com/press
VK | <img src="https://edent.github.io/SuperTinyIcons/images/svg/vk.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/vk.png" width="256"> | https://vk.com/public47200950
VLC | <img src="https://edent.github.io/SuperTinyIcons/images/svg/vlc.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/vlc.png" width="256"> | https://www.videolan.org/
Vue | <img src="https://edent.github.io/SuperTinyIcons/images/svg/vue.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/vue.svg" width="256"> | https://github.com/vuejs/art/blob/master/logo.svg
W3C | <img src="https://edent.github.io/SuperTinyIcons/images/svg/w3c.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/w3c.png" width="256"> | https://www.w3.org/Consortium/Legal/logo-usage-20000308
Wayland | <img src="https://edent.github.io/SuperTinyIcons/images/svg/wayland.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/wayland.png" width="256"> | https://wayland.freedesktop.org/
WebAssembly | <img src="https://edent.github.io/SuperTinyIcons/images/svg/webassembly.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/webassembly.png" width="256"> | https://webassembly.org/
WebMention | <img src="https://edent.github.io/SuperTinyIcons/images/svg/webmention.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/webmention.svg" width="256"> | https://indieweb.org/File:webmention-logo.svg
WebToons | <img src="https://edent.github.io/SuperTinyIcons/images/svg/webtoons.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/webtoons.jpg" width="256"> | https://www.webtoons.com/en
WeChat | <img src="https://edent.github.io/SuperTinyIcons/images/svg/wechat.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/wechat.svg" width="256"> | https://wechat.design/?locale=en_US
Wekan | <img src="https://edent.github.io/SuperTinyIcons/images/svg/wekan.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/wekan.svg" width="256"> | https://github.com/wekan/wekan/blob/master/public/wekan-logo-150.svg
WhatsApp | <img src="https://edent.github.io/SuperTinyIcons/images/svg/whatsapp.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/whatsapp.svg" width="256"> | https://www.whatsappbrand.com/
WHATWG | <img src="https://edent.github.io/SuperTinyIcons/images/svg/whatwg.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/whatwg.svg" width="256"> | https://whatwg.org/ipr-policy
WiFi | <img src="https://edent.github.io/SuperTinyIcons/images/svg/wifi.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/wifi.png" width="256"> | https://www.wi-fi.org/download.php?file=/sites/default/files/private/Wi-Fi_Alliance_Brand_Styleguide_201709.pdf
Wikipedia | <img src="https://edent.github.io/SuperTinyIcons/images/svg/wikipedia.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/wikipedia.svg" width="256"> | https://wikimediafoundation.org/wiki/Visual_identity_guidelines
Windows | <img src="https://edent.github.io/SuperTinyIcons/images/svg/windows.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/windows.png" width="256"> | https://query.prod.cms.rt.microsoft.com/cms/api/am/binary/RE1voQq
Wire | <img src="https://edent.github.io/SuperTinyIcons/images/svg/wire.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/wire.svg" width="256"> | https://brand.wire.com/symbol/
WireGuard | <img src="https://edent.github.io/SuperTinyIcons/images/svg/wireguard.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/wireguard.svg" width="256"> | https://www.wireguard.com/img/emblem-circle.svg
WordPress | <img src="https://edent.github.io/SuperTinyIcons/images/svg/wordpress.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/wordpress.svg" width="256"> | https://wordpress.org/about/logos/
Workato | <img src="https://edent.github.io/SuperTinyIcons/images/svg/workato.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/workato.svg" width="256"> | https://workato.com
X | <img src="https://edent.github.io/SuperTinyIcons/images/svg/x.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/x.svg" width="256"> | https://about.twitter.com/en/who-we-are/brand-toolkit
X11 | <img src="https://edent.github.io/SuperTinyIcons/images/svg/x11.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/x11.png" width="256"> | https://www.netbsd.org/gallery/logos.html
XING | <img src="https://edent.github.io/SuperTinyIcons/images/svg/xing.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/xing.png" width="256"> | https://dev.xing.com/logo_rules
XMPP | <img src="https://edent.github.io/SuperTinyIcons/images/svg/xmpp.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/xmpp.svg" width="256"> | https://xmpp.org/about/press-kit/
Yahoo! | <img src="https://edent.github.io/SuperTinyIcons/images/svg/yahoo.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/yahoo.jpg" width="256"> | https://www.pentagram.com/work/yahoo/story
Yammer | <img src="https://edent.github.io/SuperTinyIcons/images/svg/yammer.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/yammer.svg" width="256"> | https://yammerassets.blob.core.windows.net/assets/sites/12/2014/07/Yammer_BrandIdentityGuidelines-1.pdf
Yarn | <img src="https://edent.github.io/SuperTinyIcons/images/svg/yarn.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/yarn.svg" width="256"> | https://yarnpkg.com/en/
Yelp | <img src="https://edent.github.io/SuperTinyIcons/images/svg/yelp.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/yelp.png" width="256"> | https://www.yelp.co.uk/brand
Yii | <img src="https://edent.github.io/SuperTinyIcons/images/svg/yii.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/yii.svg" width="256"> | https://www.yiiframework.com/logo
YouTube | <img src="https://edent.github.io/SuperTinyIcons/images/svg/youtube.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/youtube.svg" width="256"> | https://www.youtube.com/intl/en/yt/about/brand-resources/#logos-icons-colors
Yubico | <img src="https://edent.github.io/SuperTinyIcons/images/svg/yubico.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/yubico.png" width="256"> | https://github.com/Yubico/yubikey-manager-qt/blob/master/resources/icons/ykman.png
Zoom | <img src="https://edent.github.io/SuperTinyIcons/images/svg/zoom.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/zoom.png" width="256"> | https://www.zoom.us/
Zorinos | <img src="https://edent.github.io/SuperTinyIcons/images/svg/zorinos.svg" width="256" /> | <img src="https://edent.github.io/SuperTinyIcons/images/reference/zorinos.png" width="256"> | https://zorin.com/press/
<h2>No Reference Image Found</h2>

Name | Icon | Filename
-|-|-
Gmail | <img src="https://edent.github.io/SuperTinyIcons/images/svg/gmail_old.svg" width="256" /> | gmail_old.svg 
Google Docs Editors | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_docs_editors.svg" width="256" /> | google_docs_editors.svg 
Google Drive | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_drive_old.svg" width="256" /> | google_drive_old.svg 
Google Maps | <img src="https://edent.github.io/SuperTinyIcons/images/svg/google_maps_old.svg" width="256" /> | google_maps_old.svg 
Uplay | <img src="https://edent.github.io/SuperTinyIcons/images/svg/uplay.svg" width="256" /> | uplay.svg 
Upwork | <img src="https://edent.github.io/SuperTinyIcons/images/svg/upwork.svg" width="256" /> | upwork.svg 
