/*
* apito-aspnet is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* apito-aspnet is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with apito-aspnet. If not, see <https://www.gnu.org/licenses/>.
*/

using Apito.Common;

namespace Apito.Referees;

public interface IRefereeService
{
    Task<ResponseDTO<IEnumerable<RefereeDTO>?>> GetAll(string status);
    Task<ResponseDTO<RefereeDTO?>> Get(Guid id, string status);
    Task<ResponseDTO<RefereeDTO?>> Save(RefereeDTO referee, string status);
    Task<bool> Remove(Guid id);
}
