﻿using System.ComponentModel;
using DevExpress.Xpo;
using Xpand.Persistent.Base.General.Controllers;
using Xpand.Persistent.Base.PersistentMetaData;
using Xpand.Persistent.Base.PersistentMetaData.PersistentAttributeInfos;

namespace Xpand.Persistent.BaseImpl.PersistentMetaData.PersistentAttributeInfos {
    [InterfaceRegistrator(typeof(IPersistentKeyAttribute))]
    [DefaultProperty("KeyName")]
    [System.ComponentModel.DisplayName("Key")]
    [CreateableItem(typeof(IPersistentMemberInfo))]
    [CreateableItem(typeof(IExtendedMemberInfo))]
    public class PersistentKeyAttribute : PersistentAttributeInfo, IPersistentKeyAttribute {
        public PersistentKeyAttribute(Session session)
            : base(session) {
        }
        [Browsable(false)]
        [MemberDesignTimeVisibility(false)]
        public string KeyName => "Key";

        private bool _autoGenerated;

        public bool AutoGenerated {
            get { return _autoGenerated; }
            set { SetPropertyValue("AutoGenerated", ref _autoGenerated, value); }
        }
        public override AttributeInfoAttribute Create() {
            return new AttributeInfoAttribute(typeof(KeyAttribute).GetConstructor(new[] { typeof(bool) }), AutoGenerated);
        }
    }
}
