﻿using DevExpress.DashboardCommon;
using DevExpress.ExpressApp.Dashboards;
using DevExpress.Persistent.Base;
using Xpand.ExpressApp.Dashboard.BusinessObjects;

namespace Xpand.ExpressApp.Dashboard.Services{
    public class XpandDashboardDataProvider : DashboardDataProvider {
        protected override IObjectDataSourceCustomFillService CreateService(IDashboardData dashboardData) {
            return dashboardData is IDashboardDefinition ? CreateServiceCore(dashboardData) : base.CreateService(dashboardData);
        }

        private static IObjectDataSourceCustomFillService CreateServiceCore(IDashboardData dashboardData){
            return dashboardData != null && ((IDashboardDefinition) dashboardData).DataViewService
                ? (IObjectDataSourceCustomFillService) new XpandDashboardViewDataSourceFillService()
                : new XpandDashboardCollectionDataSourceFillService(){AllowObjectSpaceDisposing = false};
        }

        protected override IObjectDataSourceCustomFillService CreateViewService(IDashboardData dashboardData){
            return dashboardData is IDashboardDefinition ? CreateServiceCore(dashboardData) : base.CreateViewService(dashboardData);
        }
    }
}