[![image](https://img.shields.io/badge/JOIN-LinkedIn.eXpandFramework.com-blue)](http://linkedin.expandframework.com/) [![image](https://img.shields.io/badge/SUBSRCIBE-YouTube.eXpandFramework.com-blue)](http://youtube.expandframework.com/) [![image](https://img.shields.io/badge/FOLLOW-twitter/eXpandFramework-blue)](https://twitter.com/expandframework/)

![GitHub Repo stars](https://img.shields.io/github/stars/expand/expand?label=Star%20the%20project%20if%20you%20think%20it%20deserves%20it&style=social)  ![GitHub forks](https://img.shields.io/github/forks/expandframework/eXpand?label=Fork%20the%20project%20to%20extend%20and%20contribute&style=social)



![image](https://user-images.githubusercontent.com/159464/66713086-c8c5a800-edae-11e9-9bc1-73ffc0c215fb.png) | Nuget
|--------|--------
[![GitHub release](https://img.shields.io/github/release/expandframework/expand.svg)](https://github.com/expandframework/expand/releases/latest) ![GitHub Releases](https://img.shields.io/github/downloads/expandframework/expand/latest/total.svg?label=Github) ![Custom badge](https://img.shields.io/endpoint.svg?label=Nuget&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2Flatest%3Fid%3DeXpand)|```nuget.exe list author:eXpandFramework``` 
[![](https://img.shields.io/azure-devops/build/eXpandDevOps/dc0010e5-9ecf-45ac-b89d-2d51897f3855/32/master.svg?label=Lab%20build&style=flat)](https://dev.azure.com/eXpandDevOps/eXpandFramework/_build/latest?definitionId=32&branchName=master)|```nuget.exe list Xpand -source https://xpandnugetserver.azurewebsites.net/nuget```

<sub><sup>[How do I set up a package source in Visual Studio?](https://go.microsoft.com/fwlink/?linkid=698608), [Efficient package management](https://github.com/eXpandFramework/DevExpress.XAF/wiki/Efficient-package-management)<br>[How to Debug](https://github.com/eXpandFramework/eXpand/wiki/HowToDebug), [How to boost your DevExpress Debugging Experience](https://github.com/eXpandFramework/DevExpress.XAF/wiki/How-to-boost-your-DevExpress-Debugging-Experience)</sup></sub>

[![Custom badge](https://img.shields.io/endpoint.svg?label=Nuget.org&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpand)](https://www.nuget.org/packages?q=expandframework) [![](https://img.shields.io/github/downloads/eXpand/expand/total.svg?label=github%20downloads&style=flat)](releases.expandframework.com)

[![GitHub open issues](https://img.shields.io/github/issues/eXpandFramework/eXpand.svg)](https://github.com/eXpandFramework/eXpand/issues) [![GitHub close issues](https://img.shields.io/github/issues-closed/eXpandFramework/eXpand.svg)](https://github.com/eXpandFramework/eXpand/issues?q=is%3Aissue+sort%3Aupdated-desc+is%3Aclosed)

# About
[![image](https://img.shields.io/badge/Exclusive%20services%3F-Head%20to%20the%20dashboard-Blue)](https://github.com/sponsors/apobekiaris)

_eXpandFramework_ is an independent open-source project and is not affiliated with Developer Express Inc.

_eXpandFramework_ is a **FREE** extension for **DevExpress-XAF** and operates within the **Microsoft Public License (Ms-PL)**. 

The [eXpandFramework](https://github.com/eXpandFramework) organization consist of three projects. The main project, this one, the Standalone low dependency well tested and well documented [Reactive.XAF](https://github.com/eXpandFramework/DevExpress.XAF) and the [XpandPwsh](https://github.com/eXpandFramework/XpandPwsh) powershell module where you can find all you need for your everyday development tasks. The main project acts as a container to the standalone project. Eventually all modules of main project will be puzzled from the standalone modules.

The architecture is similar to XAF. We recommend you go through the [Getting Started](https://github.com/eXpandFramework/eXpand/wiki/Getting-Started) document to get the feeling on how to get the most out of it. Afterwards just install the modules you want and go through the blogs linked in the list below and feel free to post [Issues](https://github.com/eXpandFramework/eXpand/issues).

## Modules

Examples of those modules include (in the two right columns you can see the supported platform):

Module Name | Description | Win | Web | Nuget.org
------------|-------------|---------|-------|---------
[ExcelImporter](#excelimporter) |    Imports Excel, csv files. |    Y |    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandExcelImporter%2A)
[WorldCreator](#worldcreator) |  Design runtime assemblies | Y | Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandWorldCreator%2A)
[ModelDifference](#model-difference) | Model management | Y | Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandModelDifference%2A)
[Dashboard](#dashboard) |    Enables native XAF dashboard collaboration and integrates the Dashboard suite |    Y |    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpand%2ADashboard%2A)
Email |     Send emails using business rules from application model without coding (see <http://goo.gl/Hkx6PK)> |    Y|Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandEmail)
[WorkFlow](#workflow) |    Contains workflow related features (Scheduled workflows) |    Y |    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandWorkFlow%2A)
[System](#system-modules)|    Support multiple datastore , calculable properties at runtime ,dynamic model creation,control grid options, datacaching, web master detail, view inheritance etc.    |Y|    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandSystem%2A)
JobSheduler    | Acts as a wrapper for the powerful Quartz.Net, providing a flexible UI for managing Jobs at runtime |    Y |    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandJob%2A)
[DBMapper](#dbmapper) |    Map 14 different types of databases at runtime into worldcreator persistent objects    | Y |    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandWorldCreatorDbMapper)
[IO](#io) |    Export & Import object graphs |    Y |    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandIO%2A)
MapView |     Google Maps integration for XAF web apps. Blog posts. |     Y |    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandMapView%2A)
FileAttachments |     Provides support for file system storage as per E965 |    Y |    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandFileAttach%2A)
Scheduler |     Please explore the XVideoRental module found in Demos/XVideoRental folder (Blog posts) |    Y |    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandScheduler%2A)
Reports |     Please explore the XVideoRental module found in Demos/XVideoRental folder    | Y |    N|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandReports%2A)
Chart |      Please explore the XVideoRental module found in Demos/XVideoRental folder     |Y |    N|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandChart%2A)
PivotGrid |      Please explore the XVideoRental module found in Demos/XVideoRental folder |    Y |    N| ![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandPivotGridWin)
[Import Wizard](#importwizard) |    Universal module for importing excel files into any XAF application.     |Y|    N|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandImportWizard%2A)
AuditTrail    |Configures XAF Audit Trail module using the Application Modules. (see Declarative data auditing)|    Y|     Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandAuditTrail%2A)
[StateMachine](#statemachine)|    Enhance XAF's statemachine module in order to control transitions using permissions    |Y|    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandStateMachine%2A)
[Logic](#logic)|    Define conditional architecture    |Y|    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandLogic%2A)
[ModelArtifact](#modelartifactstate)|    Parameterize model artifacts (Controllers, Actions, Views)|    Y|    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandModelArtifact%2A)
[AdditionalViewControlsProvider](#additionalviewcontrolsprovider)    |Decorate your views with custom controls|    Y    |Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandAdditionalViewControlsProvider%2A)
MasterDetail|    XtraGrid support for master-detail data presentation using the model.    Y|    N||![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandMasterDetai%2A)
[PivotChart](#pivotchart)|    Enhance analysis procedures / controls|    Y|    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandPivotChar%2A)
Security|    Provides extension methods, authentication providers, login remember me, custom security objects|     Y|    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandSecuri%2A)
[Wizard](#wizardui)|    Design wizard driven views|    Y    |N|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandWizard%2A)
[ViewVariants](#viewvariants)|    Create views without the use of model editor|    Y|    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandViewVariants%2A)
[Validation](#validation)|    More rules , permission validation, warning/info support, Action contexts etc|    Y|    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandValidation%2A)
ConditionalObjectViews|    Allows the conditional navigation to your detailviews/listviews-->Merged with ModelArtifact    |Y|    Y
EasyTests|    Custom command and extensions for EasyTest see <http://apobekiaris.blogspot.gr/search/label/EasyTest>|    Y|    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandEasyTes%2A)
[TreelistView](#treelistview)|    Enhance hierarchy controls, map XtraTreeList options to model|    Y|    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandTreelistView%2A)
[NCarousel](#ncarousel)|    Loads images asynchronously and displays them using a configurable carousel listeditor|    N|    Y|![Custom badge](https://img.shields.io/endpoint.svg?color=%20&label=%20&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FeXpandNCarousel%2A)
VSIX Package|    Enhance Model Editor, Explore Xaf Errors, Drop Database at design time, ProjectConverter invocation|

## Standalone XAF Modules

Below is a list of DevExpress XAF Modules distributed from the [DevExpress.XAF](https://github.com/eXpandFramework/DevExpress.XAF) repository.

<moduleslist>

|PackageName|[![Custom badge](https://img.shields.io/endpoint.svg?label=Downloads&url=https%3A%2F%2Fxpandnugetstats.azurewebsites.net%2Fapi%2Ftotals%2FXAF)](https://www.nuget.org/packages?q=Xpand.XAF)<br>Platform/Target|About
|---|---|---|
[AutoCommit](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/AutoCommit)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.AutoCommit.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.AutoCommit.svg?label=&style=flat)|The `AutoCommit` package can be used to enable specific autocommit scenarios by setting the `IModelObjectView.AutoCommit`.
[Blazor](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Blazor)|![](https://img.shields.io/badge/Web-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Blazor.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Blazor.svg?label=&style=flat)|The `Blazor` package hosts and activates Blazor specific XAF artifacts (Editors, Services, etc).
[BulkObjectUpdate](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/BulkObjectUpdate)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.BulkObjectUpdate.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.BulkObjectUpdate.svg?label=&style=flat)|The `BulkObjectUpdate` module updates your Businesses data in bulk guided from flexible model configurations.
[CloneMemberValue](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/CloneMemberValue)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.CloneMemberValue.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.CloneMemberValue.svg?label=&style=flat)|The `CloneMemberValue` module will help you to selectively `clone` Business object `members`.
[CloneModelView](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/CloneModelView)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.CloneModelView.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.CloneModelView.svg?label=&style=flat)|The `CloneModelView` package generated additional default design time model views.
[Email](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Email)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Email.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Email.svg?label=&style=flat)|The `Email` module sends your Business Object as email.
[GridListEditor](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/GridListEditor)|![](https://img.shields.io/badge/Win-net6.0-windows-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.GridListEditor.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.GridListEditor.svg?label=&style=flat)|The `GridListEditor` module hosts features related to XAF GridListEditor.
[HideToolBar](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/HideToolBar)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.HideToolBar.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.HideToolBar.svg?label=&style=flat)|The `HideToolBar` package uses the the `IModelListView.HideToolBar` attribute to hide the toolbar.
[JobScheduler.Hangfire](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/JobScheduler.Hangfire)|![](https://img.shields.io/badge/Web-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.JobScheduler.Hangfire.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.JobScheduler.Hangfire.svg?label=&style=flat)|The `JobScheduler.Hangfire` package integrates Hangfire for fire & forget job schedules.
[JobScheduler.Notification](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/JobScheduler.Notification)|![](https://img.shields.io/badge/Web-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.JobScheduler.Notification.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.JobScheduler.Notification.svg?label=&style=flat)|The `JobScheduler.Notification` emits Object creation events and offers a Blazor UI for fine tuning them.
[LookupCascade](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/LookupCascade)|![](https://img.shields.io/badge/Web--yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.LookupCascade.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.LookupCascade.svg?label=&style=flat)|
[MasterDetail](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/MasterDetail)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.MasterDetail.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.MasterDetail.svg?label=&style=flat)|The `MasterDetail` module can help you create platform agnostic master detail `XAF` views using only the Model Editor.
[ModelMapper](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/ModelMapper)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.ModelMapper.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.ModelMapper.svg?label=&style=flat)|The `ModelMapper` allows to control all XAF components from the application model.
[ModelViewInheritance](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/ModelViewInheritance)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.ModelViewInheritance.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.ModelViewInheritance.svg?label=&style=flat)|The `ModuleViewInheritance` changes the default Model View generation without coding.
[Office.Cloud.Google](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Office.Cloud.Google)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Office.Cloud.Google.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Office.Cloud.Google.svg?label=&style=flat)|The `Google` package authenticates against the Google Cloud services.
[Office.Cloud.Google.Calendar](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Office.Cloud.Google.Calendar)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Office.Cloud.Google.Calendar.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Office.Cloud.Google.Calendar.svg?label=&style=flat)|The `Google.Calendar` package integrates with the Google Calendar cloud service.
[Office.Cloud.Google.Tasks](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Office.Cloud.Google.Tasks)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Office.Cloud.Google.Tasks.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Office.Cloud.Google.Tasks.svg?label=&style=flat)|This package integrates with the Google Tasks cloud service.
[Office.Cloud.Microsoft](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Office.Cloud.Microsoft)|![](https://img.shields.io/badge/Agnostic--yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Office.Cloud.Microsoft.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Office.Cloud.Microsoft.svg?label=&style=flat)|
[Office.DocumentStyleManager](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Office.DocumentStyleManager)|![](https://img.shields.io/badge/Agnostic-net6.0-windows7.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Office.DocumentStyleManager.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Office.DocumentStyleManager.svg?label=&style=flat)|The DocumentStyleManager can re-brand a large number of documents using style templates.
[OneView](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/OneView)|![](https://img.shields.io/badge/Win-net6.0-windows7.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.OneView.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.OneView.svg?label=&style=flat)|The `OneView` will display one view only with the option to edit the model.
[PositionInListView](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/PositionInListView)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.PositionInListView.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.PositionInListView.svg?label=&style=flat)|The `PositionInListView`, controls how objects are positioned in a ListView at runtime.
[ProgressBarViewItem](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/ProgressBarViewItem)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.ProgressBarViewItem.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.ProgressBarViewItem.svg?label=&style=flat)|The `ProgressBarViewItem` package integrates a UI progress for long running tasks.
[RazorView](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/RazorView)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.RazorView.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.RazorView.svg?label=&style=flat)|The `RazorView` module uses the Razor c# syntax to generate views out of Business data.
[Reactive](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Reactive)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Reactive.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Reactive.svg?label=&style=flat)|The `Reactive` module provides a XAF DSL API for functional/stateless implementations.
[Reactive.Logger](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Reactive.Logger)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Reactive.Logger.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Reactive.Logger.svg?label=&style=flat)|The `Reactive.Logger` module monitors calls to the RX delegates OnNext, OnSubscribe, OnDispose, OnCompleted, OnError
[Reactive.Logger.Client.Win](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Reactive.Logger.Client.Win)|![](https://img.shields.io/badge/Win-net6.0-windows7.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Reactive.Logger.Client.Win.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Reactive.Logger.Client.Win.svg?label=&style=flat)|The `Reactive.Logger.Client.Win` is an executable able connect to any XAF app that uses the `Reactive.Logger.Hub`.
[Reactive.Logger.Hub](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Reactive.Logger.Hub)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Reactive.Logger.Hub.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Reactive.Logger.Hub.svg?label=&style=flat)|The `Reactive.Logger.Hub` transmits or receives the execution pipeLine flow.
[Reactive.Rest](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Reactive.Rest)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Reactive.Rest.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Reactive.Rest.svg?label=&style=flat)|The `Reactive.Rest` integrates with any REST Service using a simple declarative process.
[RefreshView](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/RefreshView)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.RefreshView.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.RefreshView.svg?label=&style=flat)|The `RefreshView` module refreshes the View datasource periodically.
[SequenceGenerator](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/SequenceGenerator)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.SequenceGenerator.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.SequenceGenerator.svg?label=&style=flat)|The `SequenceGenerator` updates Business Objects members with unique sequential values.
[Speech](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Speech)|![](https://img.shields.io/badge/Win-net6.0-windows7.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Speech.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Speech.svg?label=&style=flat)|
[SpellChecker](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/SpellChecker)|![](https://img.shields.io/badge/Win-net6.0-windows7.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.SpellChecker.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.SpellChecker.svg?label=&style=flat)|The `StoreToDisk` package provides partial and secured serialization for your Business Object
[StoreToDisk](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/StoreToDisk)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.StoreToDisk.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.StoreToDisk.svg?label=&style=flat)|The `StoreToDisk` package provides partial and secured serialization for your Business Object
[SuppressConfirmation](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/SuppressConfirmation)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.SuppressConfirmation.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.SuppressConfirmation.svg?label=&style=flat)|The `SuppressConfirmation` suppresses ObjectViews modification confirmations.
[TenantManager](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/TenantManager)|![](https://img.shields.io/badge/Web-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.TenantManager.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.TenantManager.svg?label=&style=flat)|The `TenantManager` integrates cloud authentication with dedicated datastore Organizations over a certainly controlled management;
[ViewEditMode](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/ViewEditMode)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.ViewEditMode.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.ViewEditMode.svg?label=&style=flat)|The `ViewEditMode` module controls the DetailView.ViewEditMode.
[ViewItemValue](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/ViewItemValue)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.ViewItemValue.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.ViewItemValue.svg?label=&style=flat)|The `ViewItemValue` helps end-users to configure the default values for lookup view items.
[ViewWizard](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/ViewWizard)|![](https://img.shields.io/badge/Agnostic-net6.0-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.ViewWizard.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.ViewWizard.svg?label=&style=flat)|
[Windows](https://github.com/eXpandFramework/Reactive.XAF/tree/master/src/Modules/Windows)|![](https://img.shields.io/badge/Win-net6.0-windows-yellowgreen)<br>![](https://img.shields.io/nuget/v/Xpand.XAF.Modules.Windows.svg?label=&style=flat)![](https://img.shields.io/nuget/dt/Xpand.XAF.Modules.Windows.svg?label=&style=flat)|The `Application.Windows` module hosts Windows Env related features like HideOnExit, Prompt, Startup, MultiInstance, NotifyIcon.


</moduleslist>
### Dashboard

Blogs:\
<http://apobekiaris.blogspot.gr/search/label/dashboard>

### Model Difference

Extends XAF by adding great new features for example:

* the ability to generate runtime members for your objects
* creating Application/Role/User models in the database
* storing your web cookies in the database
* handling of external application models
* combine end user modifications with application model
* support for multiple models at design time

<a href="http://lh3.ggpht.com/_5YPm4JGkfwE/TKS-Dto4vJI/AAAAAAAAA2M/23ElRzSeGxY/s1600-h/1%5B4%5D.png" ><img src="http://lh4.ggpht.com/_5YPm4JGkfwE/TKS-EDVfWVI/AAAAAAAAA2U/C4q0TgSBQxA/1_thumb%5B2%5D.png?imgmax=800" width="244" height="119"/></a>|
<a href="http://lh6.ggpht.com/_5YPm4JGkfwE/TKS-GpI3V0I/AAAAAAAAA2g/ir7JM5yPYAI/s1600-h/2%5B4%5D.png" target="_blank"><img src="http://lh4.ggpht.com/_5YPm4JGkfwE/TKS-He26FgI/AAAAAAAAA2k/sGqr-d1q8no/2_thumb%5B2%5D.png?imgmax=800" width="244" height="146"  /></a>

Blogs:\
<http://apobekiaris.blogspot.com/search/label/ModelDifference>

### WorldCreator
Creates dynamic persistent assemblies. The XAF user interface allows us to create an assembly without writing a single line of code. Advanced users can even use c# scripting and create new code generation templates.  

<a href="http://lh5.ggpht.com/_5YPm4JGkfwE/TKS-JsXS8zI/AAAAAAAAA2s/GealQVYGk2I/s1600-h/3%5B4%5D.png" target="_blank"><img src="http://lh4.ggpht.com/_5YPm4JGkfwE/TKS-KYRSs6I/AAAAAAAAA20/RBORqaxDbQk/3_thumb%5B2%5D.png?imgmax=800" width="244" height="132"/></a>

Blogs:\
<http://apobekiaris.blogspot.com/search/label/WorldCreator>

### JobScheduler
For those who are not familiar with the concept of job scheduling, [here](http://en.wikipedia.org/wiki/Job_scheduler) is some background information. Also, there is great Quartz [tutorial](http://quartznet.sourceforge.net/tutorial/index.html), which provides an excellent introduction.

Blogs:\
<http://apobekiaris.blogspot.com/search/label/JobSceduler>

### DBMapper
DBMapper has the same functionality as SqlDbMapper however is based on the powerful [XPO](http://www.devexpress.com/Products/NET/ORM/) . Thus  DBMapper module is capable of transforming into WorldCreator persistent classes the following list of databases: Access, [Advantage](http://www.sybase.com/products/databasemanagement/advantagedatabaseserver), [Adaptive Server Anywhere](http://www.isug.com/Sybase_FAQ/ASA/index.html), Ase, [DB2](http://www-01.ibm.com/software/data/db2/), [FireBird](http://www.firebirdsql.org/), [FireBirdSql](http://www.firebirdsql.org/), [SqlServerCe](http://www.microsoft.com/sqlserver/en/us/editions/compact.aspx), [SqlServer](http://www.microsoft.com/sqlserver/en/us/default.aspx), [ODP](http://www.oracle.com/technetwork/topics/dotnet/index-085163.html),  [Oracle](http://www.oracle.com/index.html), [PersasizeSql](http://www.pervasive.com/), [PostgreSql](http://www.postgresql.org/), [SQLite](http://www.sqlite.org/), [VistaDB](http://www.vistadb.net/)  

<a href="http://lh6.ggpht.com/_5YPm4JGkfwE/TKS-NKe9gpI/AAAAAAAAA3E/sQhwSk0lqXA/s1600-h/4%5B4%5D.png" target="_blank" ><img src="http://lh6.ggpht.com/_5YPm4JGkfwE/TKS-NnEnx1I/AAAAAAAAA3M/3RRz9c0dvYQ/4_thumb%5B2%5D.png?imgmax=800" alt="4" width="244" height="137"  /></a>

Blogs:\
<http://apobekiaris.blogspot.com/search/label/SqlDbMapper>

### Import Export Module
Provides collaboration between a xaf application and another system by allowing you to create object serialization graphs. The complexity of a graph can be configured using either UI or design time attributes. Changing object keys and choosing serialization strategies are straightforward as seen in this screenshot.

<a href="http://lh4.ggpht.com/_5YPm4JGkfwE/TKS-RG9vtqI/AAAAAAAAA3Q/atE-te0RBpc/s1600-h/5%5B4%5D.png" target="_blank" ><img src="http://lh6.ggpht.com/_5YPm4JGkfwE/TKS-SBm18GI/AAAAAAAAA3k/MKVWkLOblqo/5_thumb%5B2%5D.png?imgmax=800" alt="5" width="244" height="175"/></a>|<a href="http://lh4.ggpht.com/_5YPm4JGkfwE/TKTGP8hA8jI/AAAAAAAAA8A/VPi85wauaew/s1600-h/6%5B11%5D.png" target="_blank" ><img src="http://lh6.ggpht.com/_5YPm4JGkfwE/TKTGRLKZmZI/AAAAAAAAA8E/IoJPGHtg4nU/6_thumb%5B5%5D.png?imgmax=800" alt="6" width="244" height="203"  /></a>\
<a href="http://lh6.ggpht.com/_5YPm4JGkfwE/TKTGRoqHwvI/AAAAAAAAA8I/NnOAO9BJ-SY/s1600-h/7%5B8%5D.png" target="_blank" ><img src="http://lh4.ggpht.com/_5YPm4JGkfwE/TKTGSVcaUII/AAAAAAAAA8M/cHWqle8GUUs/7_thumb%5B4%5D.png?imgmax=800" alt="7" width="244" height="175" /></a>\
Blogs:\
<http://apobekiaris.blogspot.com/search/label/IO>

### Import Wizard
Windows module for importing excel files into any XAF application.\
<img src="http://1.bp.blogspot.com/_qoNyZHelrQw/TGv4_qFc08I/AAAAAAAAQu4/baach20MnHk/s640/Excel+Import+3.png" alt="Import Wizard Preview" width="244" />\
Blogs:\
http://mdworkstuff.blogspot.gr/search/label/wizard

### AdditionalViewControlsProvider
Allows us to place a Win or Web control in any given position in its respective XAF view and control its visibility, text decoration, font, height, width, etc. using conditional model rules.\
<a href="http://lh6.ggpht.com/_5YPm4JGkfwE/TKTGS0pCiuI/AAAAAAAAA8Q/lMY4nHkkeJk/s1600-h/8%5B9%5D.png" target="_blank" ><img src="http://lh6.ggpht.com/_5YPm4JGkfwE/TKTGTiQHUVI/AAAAAAAAA8U/VoWwfpX--_4/8_thumb%5B5%5D.png?imgmax=800" alt="8" width="244" height="188" /></a>|<a href="http://lh6.ggpht.com/_5YPm4JGkfwE/TKTGUkErwRI/AAAAAAAAA8Y/Ymr3orssvz8/s1600-h/9%5B8%5D.png" target="_blank" ><img src="http://lh6.ggpht.com/_5YPm4JGkfwE/TKTGVNRtVuI/AAAAAAAAA8c/LglYVygFdKg/9_thumb%5B4%5D.png?imgmax=800" alt="9" width="244" height="108" /></a>\
Blogs:\
http://apobekiaris.blogspot.com/search/label/AdditionalViewControlsProvider

### ModelArtifactState
Apply conditional logic to the artifacts of your model (Controllers, Actions). It means that you can enable,disable,hide,execute etc. at many contexts or combination of them.

<a href="http://lh4.ggpht.com/_5YPm4JGkfwE/TKTGWzkYSJI/AAAAAAAAA8g/cWtL1GB9XRA/s1600-h/10%5B8%5D.png" target="_blank" ><img src="http://lh3.ggpht.com/_5YPm4JGkfwE/TKTGYHIKvXI/AAAAAAAAA8k/O1JYHungAdE/10_thumb%5B4%5D.png?imgmax=800" alt="10" width="222" height="244"  /></a>\
Blogs:\
http://apobekiaris.blogspot.com/search/label/ModelArtifactState

### StateMachine
Enhance XAF's statemachine module in order to control transitions using permissions.

Blogs:\
http://apobekiaris.blogspot.com/search/label/Xpandstatemachine  

### PivotChart 
Using it you can connect your analysis objects with any object and display/position them at any view. A big number of pivot features are also supported  . Controlling Pivotgrid options is also available at runtime.

<a href="http://lh6.ggpht.com/_5YPm4JGkfwE/TKTGa5lGuVI/AAAAAAAAA8w/Jp7oyPEq48c/s1600-h/12%5B9%5D.png" target="_blank" rel="noopener" ><img src="http://lh3.ggpht.com/_5YPm4JGkfwE/TKTGbx4fMxI/AAAAAAAAA80/fyszg5Wy_7U/12_thumb%5B5%5D.png?imgmax=800" alt="12" width="244" height="159" /></a>|<a href="http://lh4.ggpht.com/_5YPm4JGkfwE/TLYN-Fe5lrI/AAAAAAAAA-k/W9HIdgO-7ng/s1600-h/image%5B4%5D.png" target="_blank" rel="noopener" ><img src="http://lh3.ggpht.com/_5YPm4JGkfwE/TLYN_K3cjnI/AAAAAAAAA-o/6uR5EOP7gbE/image_thumb%5B1%5D.png?imgmax=800" alt="image" width="244" height="171" /></a>\
Blogs:\
http://apobekiaris.blogspot.com/search/label/PivotChart

### Logic
Provides the architecture / engine upon many of eXpand modules have been designed (AdditionalViewControlsProvider, ModeArtifactState, MasterDetail, ConditionalDetailViews) . Very valuable to the developers that want to implement a conditional module.

Blogs:\
http://apobekiaris.blogspot.com/search/label/Logic 

### System modules 
The features here are endless . Some interesting features are multiple datastore support, create calculable properties at runtime, dynamic model creation, GridView,GridColumn options…etc.

Blogs:\
http://apobekiaris.blogspot.com/search/label/Core.Web\
http://apobekiaris.blogspot.com/search/label/Core.Win\

### ConditionalObjectView

Allows the conditional navigation to your detailviews / listviews.

<a href="http://lh4.ggpht.com/_5YPm4JGkfwE/TKTGe7dYA0I/AAAAAAAAA9I/OuN5Cs7uVAw/s1600-h/15%5B9%5D.png" target="_blank" rel="noopener" ><img src="http://lh6.ggpht.com/_5YPm4JGkfwE/TKTGfoUv_gI/AAAAAAAAA9M/Wlt00bo5UFM/15_thumb%5B5%5D.png?imgmax=800" alt="15" width="244" height="129"  /></a>


### ViewVariants 
End user can design views at runtime.

<a href="http://lh6.ggpht.com/_5YPm4JGkfwE/TKTGhYoMiKI/AAAAAAAAA9Q/MowHd45EMwA/s1600-h/16%5B9%5D.png" target="_blank" rel="noopener" ><img src="http://lh3.ggpht.com/_5YPm4JGkfwE/TKTGh6wP6yI/AAAAAAAAA9U/3XO4zHU3fy4/16_thumb%5B5%5D.png?imgmax=800" alt="16" width="244" height="126" /></a>

Blogs:\
http://apobekiaris.blogspot.com/search/label/ViewVariants

### Validation
![Validation](http://www.expandframework.com/media/kunena/attachments/65/detailviewwarning.png)

Blogs:\
http://apobekiaris.blogspot.com/search/label/Validation\
([warning/Info](http://www.expandframework.com/forum/8-discussion/1319-validation-rule-warning-support.html))

### WizardUI
Enables designing of wizard views using the model editor.

<a href="http://lh6.ggpht.com/_5YPm4JGkfwE/TLRDaDgdjVI/AAAAAAAAA-E/w2od5jXerx8/s1600-h/image%5B14%5D.png" ><img src="http://lh4.ggpht.com/_5YPm4JGkfwE/TLRDaqzZjBI/AAAAAAAAA-I/7iDtoy2U3Fc/image_thumb%5B6%5D.png?imgmax=800" alt="image" width="244" height="196" /></a>|<a href="http://lh5.ggpht.com/_5YPm4JGkfwE/TLRDayM9LUI/AAAAAAAAA-M/3ycTZyxeEkA/s1600-h/image%5B7%5D.png" ><img src="http://lh4.ggpht.com/_5YPm4JGkfwE/TLRDbe-2vLI/AAAAAAAAA-Q/CIoDmYlXnro/image_thumb%5B3%5D.png?imgmax=800" alt="image" width="332" height="130" /></a>

<a href="http://lh6.ggpht.com/_5YPm4JGkfwE/TLRDbyGy01I/AAAAAAAAA-U/IVyHb52EZ68/s1600-h/image%5B6%5D.png" ><img src="http://lh6.ggpht.com/_5YPm4JGkfwE/TLRDcTa0GEI/AAAAAAAAA-Y/Vidgg103loI/image_thumb%5B2%5D.png?imgmax=800" alt="image" width="325" height="126" /></a>|<a href="http://lh4.ggpht.com/_5YPm4JGkfwE/TLRDc7oQYcI/AAAAAAAAA-c/jdKoI7aFca8/s1600-h/image%5B11%5D.png" ><img src="http://lh5.ggpht.com/_5YPm4JGkfwE/TLRDdnPeo-I/AAAAAAAAA-g/tIcRuHgK-Ps/image_thumb%5B5%5D.png?imgmax=800" alt="image" width="306" height="133" /></a>

### TreelistView 
Enable recursive filtering and viewing for your listviews ,map XtraTreeList options to model, support for conditional appearance module.

Blogs:\
http://apobekiaris.blogspot.com/search/label/TreeListEditors

### NCarousel
Web skinable listeditor based on JCarousel. Image loading is asynchronous , multiple editor with different configurations is allowed.

<img src="http://www.expandframework.com/images/site/firstpage/ncarouseleditor.png" alt="ncarouseleditor" width="300" height="196" />

 Blogs:\
 http://apobekiaris.blogspot.com/search/label/NCaousel

### Workflow

Blogs:\
http://apobekiaris.blogspot.com/search/label/XpandWF

### ExcelImporter

![Windows ExcelImporter](http://www.expandframework.com/images/site/firstpage/excelimporter.win.png)

![Web ExcelImporter](http://www.expandframework.com/images/site/firstpage/excelimporter.web.png)

Blogs:\
http://apobekiaris.blogspot.gr/search/label/ExcelImporter
