const lassoLoader = require("lasso-loader");
module.exports = {
    load: function () {
        return new Promise((resolve, reject) => {
            lassoLoader.async(function (err) {
                if (err) reject(err);
                else {
                    const highcharts = require("highcharts");
                    const accessibility = require("highcharts/modules/accessibility");
                    const patternFill = require("highcharts/modules/pattern-fill");

                    window.Highcharts = highcharts;
                    accessibility(window.Highcharts);
                    patternFill(window.Highcharts);
                    resolve({
                        highcharts,
                        accessibility,
                        patternFill,
                    });
                }
            });
        });
    },
};
