# jekyll-content-security-policy-generator Plugin

![Jekyll Image Cover](Cover.png)

[![Gem Version](https://badge.fury.io/rb/jekyll-content-security-policy-generator.svg)](https://badge.fury.io/rb/jekyll-content-security-policy-generator)

This Jekyll plugin automatically builds an HTML content-security-policy for a Jekyll site. The plugin
will scan ```.html``` files generated by Jekyll and attempt to locate images, styles, scripts, frames etc and build a
content security policy HTML meta tag. The script will also generate SHA256 hashes for inline scripts and styles. If
the script finds elements with style attributes ```<div style="color: red"></div>```, the script will extract the style
information and build a style element to which will also pass through the content security policy generation.

## Goal

To speed up development of Jekyll based sites whilst also helping to generate secure HTML files protected from XSS.

## Features

* Scans for ```.html``` files generated by Jekyll.
* Finds inline scripts such as ```<script>alert("Hello World!");</script>``` and generates an SHA256 hash.
* Finds inline styles such as ```<style>.hello { color: "red"; }</style>``` and generates an SHA256 hash.
* Creates or reuses an HTTP meta tag for the content security policy.
* Finds all images, styles, scripts and frames with external URLs and builds CSP.
* Converts style attributes into ```<style>``` elements.
* If a page already has a content-security-policy tag, (such as your index.html file), the script will reuse it.
* Image URLs such as https://strongscot.com/images/logo.svg will have a rule such as https://strongscot.com/images/

## Upcoming Features

* Ability to specify how lax the domain rules can be. For example, ```https://strongscot.com/images/logo.svg``` would be converted to
```https://strongscot.com/images/``` under strict and ```https://strongscot.com``` under relaxed.
* Ability in site.yaml file to specify what files it should parse, at the moment its only ```.html```.

## Installation

Add the plugin your Gemfile within the jekyll_plugins group:

```
group :jekyll_plugins do
  gem 'jekyll-content-security-policy-generator'
  ... other gem files
end
```

Then install

```
bundle install
```

## Nokogiri Error on Mac?

For some reason, Nokogiri will install with both the ARM (M1) and x86 variants which will confuse bundler. Best way I found to fix this was to open the Gemfile.lock and remove the:

```
nokogiri (1.11.3-arm64-darwin)
  racc (~> 1.4)
```

Or the x86 if you have an M1 mac.

Alternatively, you can add ```nokogiri``` to your Gemfile, like so:

```
group :jekyll_plugins do
  gem 'nokogiri'
  gem 'jekyll-content-security-policy-generator'
  ... other gem files
end
```

## Support

https://strongscot.com
