// Package api provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.16.3 DO NOT EDIT.
package api

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/url"
	"path"
	"strings"

	"github.com/getkin/kin-openapi/openapi3"
)

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+xbX2/bOBL/KgTvHrWxm3YXe35L2t5esG03aNK9A4LgQEvjmBuK1JKUEyPwdz/wjyRK",
	"omzZ+XPp4Z7qisPhcOY3w+EM84BTkReCA9cKzx5wQSTJQYO0/5uXlGVnH8xPyvEMF0QvcYI5yQHP6tEE",
	"S/izpBIyPNOyhASrdAk5MdP0ujCkSkvKb/Bmk2BFeDYX94Ncm/H9+GrIC0Y0DDIOCPbhvDHEqhBcgdXJ",
	"u+nU/JMKroFr85MUBaMp0VTwyR9KcPOt4fdXCQs8w3+ZNIqeuFE1+SilkG6NDFQqaWGY4Bk+JRkyIoLS",
	"eJPgd9M3z7/mSamXwLXnisDRmcXfPf/iX4RGC1HyzKz440uo+ALkCmS1zU0FAWvj9+ff3ovSLd2e9f78",
	"G0qFBIUWQiK9BOTxihO8EDInGs8w5frtMU5wTu5pXuZ49nOCc8rd7zdJBTHKNdyA1fFHvvqdOJ8jWUbN",
	"YoSdS1GA1NThri3HR76iUvAcuEYrIimZs6hMfT9xCjGu3mKfigwiyxhiZMci++vvIwelyM0Qo6g8jSde",
	"Yb9QxeV6k+DPkAu5/nzaZ+lGuntGlKPPp9ut8eZvx6FBjn+ObeUL3F14NfaUBY25tmLPk1nFaJIRvROu",
	"fsnPFXkvsLV1cJYZj11QkEgsrBoqdaJqWl/pCdY0B1F6eC9IyTSevfmx6yGXNAekBWJ0BTE1K0gFz9RR",
	"VNmVdqd93XaMHuzPGPxryTnlN4O6J4ySiEOcmM+VErbtPWUUuB6nTEcb5VKUdYTYZs86kmwSDDw7iYQU",
	"q+a7JfCWfu8oYwjuCypbrpcRDT8Y88WEygNf2SZU7VOPA2brJN+lysGQlGClidSwj26IQn7SaN3s50UV",
	"NVpIkaO7JU2XiKqWEKkE4gTYHtNaaUeY3NRADDUQICuwZ4Ud4x+v3DGAr7LfQSrqDuk2Iz9QcTG0SDp/",
	"NwFlF06eCG+vGgqh/gJzfxI3fWE/iRsEXMs1uqN6iQz0lSZ5gQjPEKPcmLmNEfsxyseMoCrjGjgyLPO4",
	"k7p1vcpYJddI7+yqqV4qcQK39aD60Gf+a29bqg8HqiFXI6Od0fqmFpdISdY9ae3agYSfg4A6LperZuyE",
	"7ibBl0DyiOsX9FdYR3z//AzdQpMjaTM7YlyqPlRpQJfFP5egl9BMr7Dv84YOy7kQDAg3PN2tq8vuC8mh",
	"8ay4NOb7WN+Mceh5nWXnJUoqZYW7vvaa/aYgkhpDTiiLpLTmcyVJaWbGNJuN2YefXftKWdLd0cSSONmc",
	"/D60xw8GGDoaIHY41E7SN07LFxJXBBi4LH0p87nfpHHpdjg1h7iZrMfdLIJSxC5tMqI0UmWaglKLktlV",
	"MusDN3RlUolth+ABeZ0P/7vzl9bem0NjXALj6U/XzqTstwWeXW0Xsob05jrBvGTM3BJdxWOTYKOmi4Lc",
	"8b1Ftwou1R7CH5KZFuWc0XRXRPJiUYUcPRISCc7WiFj70zkDNF9HokUQqpTRwqEY7uqBcv3TuyiED8s7",
	"Yuosi+wAxDmzuakHnsxhAtOU/+Ipq7df6B+h5CGiu2BsmaQVY8JId2o+98PdHpHCksYU3CQU/li8uu6V",
	"6GxUsYT7xEuliS4jsfjCfo8YH7i5Rl+5bRmmxiQkM0pztavrJ0txD7W/31PS5EItE331hcynv7EcEKwz",
	"kd6CXFAWSU4+1GNBxjS8/CFBzd703udZFABSo1TkucnetUBwD2lpQlvHlclC++g3CN8nzqACnYXG/WZ9",
	"edC6LxW/bW1XQVpKqtcXRudu/RPL4FLcAj8p9dKGBiAS5N+rwOeW+Lc2JNgXgC1rS9YstdS6MGo9sZlj",
	"xcy2GJZAMkvqmwz/+uHk/OwHl19Wru/yTSsm5QthwwTVBoD44/EpOjk/wwleVXdmPD16czQ1y4kCOCko",
	"nuG3R9OjqQmpRC/t3iZLIMyJcQORU+AfdhilS0hvseUkbfH8LMMz/AtoN447rY1jV3dvs/L2dUWXOqkK",
	"uhIx6NdsJ4bImWji7zVurajYn6jSiDBWFwWaKZFNXASDsX2M7h/U0XtcWtWpUG6u+1fEfreh1hxbIwm6",
	"lByyga1a1U7HqHa6nxnqzsp2WkMU+pRVSIj9q2uTUGpizsgr3AhuFFEIFWub2KMekbpkYospnQDbNvC5",
	"UB0LWxyeimz9ZM2hoMa/aQc9nyN3YPV0XbjWsp0MrlPp9GlS4Hxs/T1jpBUKJg91HWzjYMNAR47mXylj",
	"DXx6YPlgp9VwuQhqa2FHe8CxG5JJU5Uz4nfM/y6SbneMdUsZi9pqvP59v3UX7bv/qq0mVYYcjeO/gK61",
	"4jPk4ehdG+uTozzYYEk0pTKxVUcqlOYqRzRSS1GyDM2hicqUo5wyRn1/y6T3htufJdiKZvVOwTDH4cuB",
	"3hVwexOsVwZ0/UnE6xvnNikHpGI0p22pmgbfdDrdt1N3/ciTdVyNVY0/McOyu0XW/6RzSVhIUEufR0dP",
	"1K+OpKUQuNfAM9tM0cqCvmrfbj9daw/8Wq/72Lh52FndvkBkpRM4clHzI/aa5loyoR4ab7mFwiSUdAVB",
	"wzp8C/D2J+MUO7rV/pOY/wGp9tns7qOhA2Cn2RaCnw+8Tw3I4MFAHI4XoF065wi7zwWO0GW8t43uK6sE",
	"KSFtegQeSUfoPWHMhvIlVSgHvRQZykumacHAl+bECuSdpNpX6S4vPyUISOoaY6hUbjqgtJQSuA77Zb6f",
	"V50XhaBmXKAciColtLZWwfJopFNdet29BpdqPfzolg3N5hovaewR6stXHwZ9rv9i4ZAXIV7K6ydxPeWh",
	"WUlacf/OTw4NJB9xk3Zkkfzr0g+85M3Zdi8feV92G3q5O023itS2CjHfKoO4m+woo1SkUcM0g52IEcv4",
	"6vZmmPIdVPS7fmkw+Jv/owFR6eu1gKKRaERFhMPd9iJIiIfnKIJEa/WjyiHHTy7DUD3EtXDNBZukKRQa",
	"sldp7FYYmDw07ZKttQ1XvEBkGAaOogbCZdiG2S+pCDo44wscrS6i28XjShwv5XlEp8v+llzfYovTmWnP",
	"ouznc952L2aU905HGNu3a7+H2uPjQ/JXcGGG8JEB+fuAxv/j+jPG9YndgZo8+G74ZssV2TZ4w77tKGhZ",
	"86nTutl+OM6SndRVSz9yNBzHo4Uz4DJ4kP2d22/SPNAYLG3XIdLt3jZ1tyXyA8a8qJ5NvIhJe/XmM57B",
	"ff3mtCp9zKtnLYPlcffWuPNeMFaKFjfqt8VCwUA9+lUVo9tvivYqR9dqeJ0FhT28xM6VqwqHpWT+8YOa",
	"TSakoEdwPD/KYIUDDg/dP69UFmrtP+Zsf7R35s315j8BAAD//50DdTB8OgAA",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %w", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	res := make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	resolvePath := PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		pathToFile := url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
