/*
 * Decompiled with CFR 0.152.
 */
package fr.s0me1ne.simpleupdater;

import fr.s0me1ne.simpleupdater.Checker;
import fr.s0me1ne.simpleupdater.Downloader;
import fr.s0me1ne.simpleupdater.File;
import fr.s0me1ne.simpleupdater.GetEvent;
import fr.s0me1ne.simpleupdater.SimpleUpdaterEvents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleUpdater {
    private String server_url;
    private String installation_path;
    private Boolean canDownload;
    private Boolean canCheck;
    private long numberOfBytesToDownload;
    private int statusCode;
    private Map<String, File> server_files;
    private List<SimpleUpdaterEvents> listeners = new ArrayList<SimpleUpdaterEvents>();
    Checker checker;
    Downloader downloader;
    GetEvent getEvents = new GetEvent(this);

    public String getServerUrl() {
        return this.server_url;
    }

    public String getInstallationPath() {
        return this.installation_path;
    }

    public Boolean CanDownload() {
        return this.canDownload;
    }

    public Boolean CanCheck() {
        return this.canCheck;
    }

    public long getNumberOfBytesToDownlaod() {
        return this.numberOfBytesToDownload;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public SimpleUpdater(String server_url, String installation_path) {
        this.server_url = server_url;
        this.installation_path = installation_path;
        this.canDownload = false;
        this.canCheck = true;
        this.statusCode = 0;
        this.addListener(this.getEvents);
    }

    public void addListener(SimpleUpdaterEvents e) {
        this.listeners.add(e);
    }

    public void CheckFilesFromServerAndDeleteOutdated() {
        if (!this.canCheck.booleanValue()) {
            System.out.println("Check not authorized. Are you downloading ?");
            return;
        }
        this.server_files = new HashMap<String, File>();
        this.canCheck = false;
        this.canDownload = false;
        this.checker = new Checker(this.installation_path, this.server_url, this.listeners);
        Thread threadChecker = new Thread(this.checker);
        threadChecker.start();
    }

    public void DownloadFiles() {
        if (!this.canDownload.booleanValue() || this.server_files == null) {
            System.out.println("Download not authorized. Have you checked out server files ?");
            return;
        }
        this.canDownload = false;
        this.canCheck = false;
        this.downloader = new Downloader(this.installation_path, this.server_url, this.checker.server_files, this.checker.numberOfBytesToDownload, this.listeners);
        this.downloader.DownloadFiles_Downloader();
    }

    void setCanCheckAndDownloadTrue() {
        this.canCheck = true;
        this.canDownload = true;
    }
}

