/*
 * Decompiled with CFR 0.152.
 */
package fr.s0me1ne.simpleupdater;

import fr.s0me1ne.simpleupdater.File;
import fr.s0me1ne.simpleupdater.SimpleUpdaterEvents;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

class Downloader {
    String installation_path;
    String server_url;
    List<SimpleUpdaterEvents> listeners;
    private Queue<String> file_to_download;
    private long bytesdownloaded;
    private long numberOfBytesToDownload;
    Map<String, File> server_files;

    public Downloader(String installation_path, String server_url, Map<String, File> server_files, long numberOfBytesToDownload, List<SimpleUpdaterEvents> listeners) {
        this.server_url = server_url;
        this.installation_path = installation_path;
        this.listeners = listeners;
        this.server_files = server_files;
        this.numberOfBytesToDownload = numberOfBytesToDownload;
    }

    void DownloadFiles_Downloader() {
        this.bytesdownloaded = 0L;
        this.file_to_download = new LinkedList<String>();
        for (Map.Entry<String, File> entry : this.server_files.entrySet()) {
            try {
                Path dest_path_file = Paths.get(this.installation_path, entry.getValue().filename);
                new java.io.File(dest_path_file.getParent().toString()).mkdirs();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.file_to_download.add(entry.getValue().filename);
        }
        Thread download = new Thread(){

            @Override
            public void run() {
                try {
                    Downloader.this.ThrowEvent_StatusCodeChanged(4);
                    Downloader.this.DownloadFile();
                }
                catch (Exception e) {
                    Downloader.this.ThrowEvent_StatusCodeChanged(6);
                    e.printStackTrace();
                }
            }
        };
        download.start();
    }

    private Runnable DownloadProgress_Changed(long bytesreceived, long numberOfBytesToDownload) {
        float percent;
        try {
            percent = (float)bytesreceived / (float)numberOfBytesToDownload;
        }
        catch (Exception e) {
            percent = 100.0f;
        }
        for (SimpleUpdaterEvents e : this.listeners) {
            e.OnDownloadProgressChanged(bytesreceived, percent * 100.0f);
        }
        return null;
    }

    private void DownloadFile() throws Exception {
        if (!this.file_to_download.isEmpty()) {
            String filename = this.file_to_download.poll();
            URL website = new URL(String.valueOf(this.server_url) + "/files/" + URLEncoder.encode(filename, "UTF-8").replaceAll("\\+", "%20").replaceAll("%5C", "/"));
            HttpURLConnection httpConnection = (HttpURLConnection)website.openConnection();
            BufferedInputStream in = new BufferedInputStream(httpConnection.getInputStream());
            FileOutputStream fos = new FileOutputStream(Paths.get(this.installation_path, filename).toString());
            BufferedOutputStream bout = new BufferedOutputStream(fos, 2048);
            byte[] data = new byte[2048];
            int x = 0;
            while ((x = in.read(data, 0, 2048)) >= 0) {
                this.bytesdownloaded += (long)x;
                new Thread(this.DownloadProgress_Changed(this.bytesdownloaded, this.numberOfBytesToDownload)).start();
                bout.write(data, 0, x);
            }
            bout.close();
            in.close();
            this.ThrowEvent_StatusCodeChanged(5);
            this.DownloadFile();
        } else {
            this.Download_Finished();
        }
    }

    private void Download_Finished() {
        for (SimpleUpdaterEvents e : this.listeners) {
            e.OnDownloadFinished(this.bytesdownloaded);
            e.OnStatusChanged(8);
            e.OnStatusChanged(0);
        }
    }

    private void ThrowEvent_StatusCodeChanged(int code) {
        for (SimpleUpdaterEvents e : this.listeners) {
            e.OnStatusChanged(code);
        }
    }
}

