/*
 * Decompiled with CFR 0.152.
 */
package fr.s0me1ne.simpleupdater;

import fr.s0me1ne.simpleupdater.File;
import fr.s0me1ne.simpleupdater.SimpleUpdaterEvents;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

class Checker
implements Runnable {
    long numberOfBytesToDownload;
    String installation_path;
    String server_url;
    List<SimpleUpdaterEvents> listeners;
    Map<String, File> server_files;
    private List<String> ignore_list_files;
    private Map<String, Boolean> ignore_list_folders;
    int nbrLocalFiles;
    int nbrFilesDeleted;

    public Checker(String installation_path, String server_url, List<SimpleUpdaterEvents> listeners) {
        this.server_url = server_url;
        this.installation_path = installation_path;
        this.listeners = listeners;
    }

    private void Check() {
        Path install_path = Paths.get(this.installation_path, new String[0]);
        if (!Files.exists(install_path, new LinkOption[0]) && Files.isDirectory(install_path, new LinkOption[0])) {
            try {
                Files.createDirectory(install_path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.ThrowEvent_StatusCodeChanged(1);
        this.server_files = this.parseFileServer();
        int nbrServerFiles = this.server_files.size();
        this.nbrFilesDeleted = 0;
        this.nbrLocalFiles = 0;
        this.ThrowEvent_StatusCodeChanged(2);
        this.SearchLocalFiles(this.installation_path, false, false);
        this.nbrLocalFiles -= this.nbrFilesDeleted;
        int nbrFilesToDownload = this.server_files.size();
        this.numberOfBytesToDownload = 0L;
        for (Map.Entry<String, File> entry : this.server_files.entrySet()) {
            this.numberOfBytesToDownload += entry.getValue().filesize;
        }
        this.ThrowEvent_CheckFinished(this.nbrLocalFiles, nbrServerFiles, nbrFilesToDownload, this.nbrFilesDeleted, this.numberOfBytesToDownload);
    }

    private Map<String, File> parseFileServer() {
        String jsonString = "";
        URL url = null;
        String finalString = "";
        try {
            url = new URL(this.server_url);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((jsonString = reader.readLine()) != null) {
                finalString = String.valueOf(finalString) + jsonString + '\n';
            }
            reader.close();
        }
        catch (Exception e) {
            this.ThrowEvent_StatusCodeChanged(7);
            e.printStackTrace();
            return new HashMap<String, File>();
        }
        if (finalString != null && !finalString.isEmpty()) {
            ScriptEngineManager sem = new ScriptEngineManager();
            ScriptEngine engine = sem.getEngineByName("javascript");
            String script = "Java.asJSONCompatible(" + finalString + ")";
            Object result = null;
            try {
                result = engine.eval(script);
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
            HashMap<String, File> files_arr_tmp = new HashMap<String, File>();
            Map ServerResponse = (Map)result;
            List filesList = (List)ServerResponse.get("files");
            for (Object file : filesList) {
                Map f = (Map)file;
                File newFile = new File((String)f.get("filename"), (String)f.get("md5"), ((Number)f.get("filesize")).intValue());
                files_arr_tmp.put(newFile.filename, newFile);
            }
            Map ignoreList = (Map)ServerResponse.get("ignore");
            this.ignore_list_files = new ArrayList<String>();
            List ignoreFilesList = (List)ignoreList.get("files");
            for (Object ignoredFile : ignoreFilesList) {
                this.ignore_list_files.add((String)ignoredFile);
            }
            this.ignore_list_folders = new HashMap<String, Boolean>();
            List ignoreFolderList = (List)ignoreList.get("folders");
            for (Object ignoredFolder : ignoreFolderList) {
                Map f = (Map)ignoredFolder;
                this.ignore_list_folders.put((String)f.get("folder_path"), (Boolean)f.get("all_subfolders"));
            }
            return files_arr_tmp;
        }
        return new HashMap<String, File>();
    }

    private Boolean SearchLocalFiles(String dir, Boolean ignoreFilesInThisFolder, Boolean ignoreAllSubfolder) {
        Boolean checkFolderEmpty = false;
        try {
            java.io.File[] fileArray = new java.io.File(dir).listFiles(java.io.File::isFile);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                java.io.File file = fileArray[n2];
                String md5 = this.getMD5(file);
                String file_path = file.getPath().substring(this.installation_path.length() + 1);
                ++this.nbrLocalFiles;
                if (!(this.ignore_list_files.contains(file_path) || !this.server_files.containsKey(file_path) && ignoreFilesInThisFolder.booleanValue())) {
                    if (this.server_files.containsKey(file_path) && (this.server_files.get((Object)file_path).md5.equals(md5) || ignoreFilesInThisFolder.booleanValue())) {
                        this.server_files.remove(file_path);
                    } else {
                        file.delete();
                        checkFolderEmpty = true;
                        ++this.nbrFilesDeleted;
                    }
                }
                ++n2;
            }
            java.io.File pathFolder = new java.io.File(dir);
            if (pathFolder.listFiles().length == 0) {
                pathFolder.delete();
            } else {
                Boolean oldValueIgnore = ignoreAllSubfolder;
                java.io.File[] fileArray2 = pathFolder.listFiles(java.io.File::isDirectory);
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    java.io.File directory = fileArray2[n4];
                    String path_dir = directory.getCanonicalPath().substring(this.installation_path.length() + 1);
                    ignoreFilesInThisFolder = ignoreAllSubfolder != false || this.ignore_list_folders.containsKey(path_dir);
                    if (!ignoreAllSubfolder.booleanValue() && this.ignore_list_folders.containsKey(path_dir)) {
                        ignoreAllSubfolder = this.ignore_list_folders.get(path_dir);
                    }
                    if (this.SearchLocalFiles(directory.getCanonicalPath(), ignoreFilesInThisFolder, ignoreAllSubfolder).booleanValue() && directory.listFiles().length == 0) {
                        directory.delete();
                        checkFolderEmpty = true;
                    }
                    ignoreAllSubfolder = oldValueIgnore;
                    ++n4;
                }
            }
            return checkFolderEmpty;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getMD5(java.io.File file) {
        try {
            int numRead;
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            ((InputStream)fis).close();
            byte[] b = complete.digest();
            String result = "";
            int i = 0;
            while (i < b.length) {
                result = String.valueOf(result) + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
                ++i;
            }
            return result;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void run() {
        this.Check();
    }

    private void ThrowEvent_CheckFinished(int nbrLocalFiles, int nbrServerFiles, int nbrFilesToDownload, int nbrFilesDeleted, long numberOfBytesToDownload) {
        for (SimpleUpdaterEvents e : this.listeners) {
            e.OnCheckFinished(nbrLocalFiles, nbrServerFiles, nbrFilesToDownload, nbrFilesDeleted, numberOfBytesToDownload);
            e.OnStatusChanged(3);
            e.OnStatusChanged(0);
        }
    }

    private void ThrowEvent_StatusCodeChanged(int code) {
        for (SimpleUpdaterEvents e : this.listeners) {
            e.OnStatusChanged(code);
        }
    }
}

