const startupExample = {
  columns: [
    {
      name: 'AI Agent Startup',
      description: 'The name of the AI agent startup company',
    },
    {
      name: 'Founded',
      description: 'The year the AI agent startup was founded',
    },
    {
      name: 'Funding',
      description:
        'The total amount of funding raised by the startup in millions USD',
    },
    {
      name: 'Valuation',
      description:
        'The current valuation of the AI agent startup in millions USD',
    },
    {
      name: 'Product',
      description:
        'A brief description of the AI agent product the startup is developing',
    },
    {
      name: 'Founders',
      description: 'The names of the key founders of the AI agent startup',
    },
  ],
  table: [
    [
      {
        text: 'Deasie',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'Deasie: Data governance for language models in the enterprise  | Y Combinator',
            url: 'https://www.ycombinator.com/companies/deasie',
          },
        ],
      },
      {
        text: '2.9',
        confidence: 1,
        sources: [
          {
            title:
              'Deasie wants to rank and filter data to make generative AI more reliable',
            url: 'https://techcrunch.com/2023/10/12/deasie-wants-to-rank-and-filter-data-to-make-generative-ai-more-reliable/',
          },
          {
            title: 'Deasie Raises $2.9 Million in Seed Round  | The SaaS News',
            url: 'https://www.thesaasnews.com/news/deasie-raises-2-9-million-in-seed-round',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Deasie is a data governance layer to support safe & reliable use of language models in the enterprise. Our product connects to thousands of documents, auto-tags everything in terms of contents & sensitivity, and ensures that AI models are only ever fed with data that is relevant, safe & high-quality.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Our three founders (from Amazon, McKinsey/QuantumBlack & MIT) previously built an ML data governance tool from 0 to 1 within McKinsey, which we deployed with 11 Fortune 500 companies. The founders are Reece Griffiths, Mikko Peiponen and Leonard Platzer.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
          {
            title:
              'Deasie: Data governance for language models in the enterprise  | Y Combinator',
            url: 'https://www.ycombinator.com/companies/deasie',
          },
          {
            title:
              'Deasie wants to rank and filter data to make generative AI more reliable',
            url: 'https://techcrunch.com/2023/10/12/deasie-wants-to-rank-and-filter-data-to-make-generative-ai-more-reliable/',
          },
        ],
      },
    ],
    [
      {
        text: 'Watto AI',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'Watto AI: AI-powered McKinsey-quality reports in seconds | Y Combinator',
            url: 'https://www.ycombinator.com/companies/watto-ai',
          },
        ],
      },
      {
        text: '$0.5',
        confidence: 1,
        sources: [
          {
            title:
              'Watto AI Company Profile: Valuation, Funding & Investors | PitchBook',
            url: 'https://pitchbook.com/profiles/company/534584-98',
          },
        ],
      },
      {
        text: '$0.5',
        confidence: 1,
        sources: [
          {
            title:
              'Watto AI Company Profile: Valuation, Funding & Investors | PitchBook',
            url: 'https://pitchbook.com/profiles/company/534584-98',
          },
        ],
      },
      {
        text: 'Watto AI uses LLMs to generate McKinsey quality reports in seconds. Customers use us to generate anything from high-quality marketing reports, custom white papers to product documents and more.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Rishabh Panwar, Ishita Bhandari, and Suryansh Soni are the founders of Watto AI.',
        confidence: 1,
        sources: [
          {
            title:
              'Watto AI: AI-powered McKinsey-quality reports in seconds | Y Combinator',
            url: 'https://www.ycombinator.com/companies/watto-ai',
          },
          {
            title:
              'Watto AI Company Profile: Valuation, Funding & Investors | PitchBook',
            url: 'https://pitchbook.com/profiles/company/534584-98',
          },
          {
            title: 'Watto AI Makers | Product Hunt',
            url: 'https://www.producthunt.com/products/watto-ai/makers',
          },
        ],
      },
    ],
    [
      {
        text: 'Basepilot',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2024',
        confidence: 1,
        sources: [
          {
            title:
              'Basepilot: AI employees to automate repetitive work, in minutes. | Y Combinator',
            url: 'https://www.ycombinator.com/companies/basepilot',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
          {
            title:
              'Pascal Wieler on LinkedIn: Super excited to now officially share that Ken Hendricks and I got into… | 55 comments',
            url: 'https://www.linkedin.com/posts/pascal-wieler_super-excited-to-now-officially-share-that-activity-7174085042988576768-zrUQ',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Bloomberg reported in January that Sierra was seeking to raise funds at almost a $1 billion valuation.',
        confidence: 1,
        sources: [
          {
            title:
              'Exclusive: Ex-Salesforce co-CEO Bret Taylor and longtime Googler Clay Bavor raised $110 million to bring AI ‘agents’ to business',
            url: 'https://fortune.com/2024/02/13/bret-taylor-clay-bavor-ai-startup-sierra-110-million-funding-sequoia-benchmark/',
          },
        ],
      },
      {
        text: 'Basepilot creates AI assistants to automate repetitive and manual work. We help companies save 30% of their time weekly and cut costs, freeing up resources for more high-value tasks. For example, finance, recruitment, or sales teams can automate mundane back-office tasks within a few clicks and a quick demonstration.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Ken Hendricks and Pascal Wieler',
        confidence: 1,
        sources: [
          {
            title:
              'Basepilot: AI employees to automate repetitive work, in minutes. | Y Combinator',
            url: 'https://www.ycombinator.com/companies/basepilot',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
    ],
    [
      {
        text: 'Marblism',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '6.7',
        confidence: 1,
        sources: [
          {
            title:
              'Marble Raises Another $4.2M to Be the Centralized Platform to Manage and Save Money on All Types of Insurance',
            url: 'https://www.alleywatch.com/2023/06/marble-insurance-cost-optimization-coverage-comparison-platform-stuart-winchester/',
          },
          {
            title:
              'Marble Secures $2.5M in Seed Round Funding, Launches First Digital Wallet and Rewards for Insurance',
            url: 'https://www.prnewswire.com/news-releases/marble-secures-2-5m-in-seed-round-funding-launches-first-digital-wallet-and-rewards-for-insurance-301225547.html',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Marblism is a startup that generates the database, back-end, front-end, and deploys web applications based on a description provided by the user. It aims to automate the initial setup and development of SaaS, marketplaces, social apps, and AI apps, allowing users to launch their ideas in days instead of months.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
    ],
    [
      {
        text: 'Venta',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Venta finds leads with buying intent in Europe by tracking website visitors, online searches, news and other signals. You can qualify leads by asking our AI assistant questions and create hyper-personalized outreach in five languages based on their intent signals.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
    ],
    [
      {
        text: 'Stack AI',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 0.8,
        sources: [
          {
            title:
              'StackAI on LinkedIn: #ai #ml #nocode #innovation #timessquare',
            url: 'https://www.linkedin.com/posts/stackai_ai-ml-nocode-activity-7134964815445327872-PvKb',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '1000',
        confidence: 1,
        sources: [
          {
            title:
              'The Week’s 10 Biggest Funding Rounds: Stack AV And Ascend Elements Lead Another Huge Week',
            url: 'https://news.crunchbase.com/venture/biggest-funding-rounds-unicorn-ai-stack-ascend/',
          },
          {
            title:
              "SoftBank places big bet autonomous trucks will 'fundamentally change' supply chains",
            url: 'https://fortune.com/2023/09/07/softbank-backs-ai-startup-stack-av-as-it-tries-to-automate-trucking/',
          },
        ],
      },
      {
        text: '$1000',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'With Stack AI, any organization can build and deploy custom AI Assistants in minutes. Our no-code interface allows teams to leverage AI for searching through knowledge bases, automating workflows, and building chatbots.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Bernardo Aceituno and Antoni Rosinol',
        confidence: 1,
        sources: [
          {
            title:
              'Stack AI: The Generative AI No-Code Platform | Y Combinator',
            url: 'https://www.ycombinator.com/companies/stack-ai',
          },
        ],
      },
    ],
    [
      {
        text: 'Latentspace',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'Latentspace: Streamline work with the help of AI-Powered Assistants | Y Combinator',
            url: 'https://www.ycombinator.com/companies/latentspace',
          },
        ],
      },
      {
        text: 'I could not find the total amount of funding raised by Latentspace in the given sources. The sources mention funding raised by other AI companies like OpenAI and Cohere, as well as general startup funding trends, but do not provide a specific number for how much Latentspace has raised.',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Latentspace has built a super smart AI colleague to help you get this kind of work done quickly. Our AI Data Expert can help you… ✅ Get instant data answers without asking your data team, writing an SQL query, or waiting 🔎 Automatically spot anomalies, correlations, and trends in your data ⚡ Enable stakeholders to self-service answers their own business questions',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Qasim Munye and Mariam Ahmed',
        confidence: 1,
        sources: [
          {
            title:
              'Latentspace: Streamline work with the help of AI-Powered Assistants | Y Combinator',
            url: 'https://www.ycombinator.com/companies/latentspace',
          },
        ],
      },
    ],
    [
      {
        text: 'Skyvern',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'Skyvern: AI Agents to automate browser workflows | Y Combinator',
            url: 'https://www.ycombinator.com/companies/skyvern',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Skyvern helps companies automate browser based workflows using LLMs and Computer Vision, fully automating manual workflows and replacing brittle or unreliable scripts. Examples include: 1. Automating materials procurement from commerce websites 2. Completing complex multi-step workflows (ie getting an insurance quote from Geico.com)',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Suchintan Singh and Shuchang Zheng are the founders of Skyvern.',
        confidence: 1,
        sources: [
          {
            title:
              'Skyvern: AI Agents to automate browser workflows | Y Combinator',
            url: 'https://www.ycombinator.com/companies/skyvern',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
          {
            title:
              'Skyvern: AI agents for browser-based workflows. | Y Combinator posted on the topic | LinkedIn',
            url: 'https://www.linkedin.com/posts/y-combinator_launch-yc-skyvern-automate-browser-based-activity-7154181874674757632-WLK6',
          },
        ],
      },
    ],
    [
      {
        text: 'Leena AI',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2015',
        confidence: 1,
        sources: [
          {
            title: 'Y Combinator Invests In AI-Based HRTech Startup Leena AI',
            url: 'https://inc42.com/buzz/y-combinator-invests-in-ai-based-hrtech-startup-leena-ai/',
          },
        ],
      },
      {
        text: 'over $40M',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '$2200',
        confidence: 1,
        sources: [
          {
            title: 'Meet The New AI Unicorns Of 2023',
            url: 'https://news.crunchbase.com/ai/new-ai-unicorns-2023-list-llm-platforms-cohere/',
          },
        ],
      },
      {
        text: "Leena AI consumes company's enterprise knowledge & starts answering all employee questions just like a human would. It can even answer complex personalized questions like Why is my salary less this month? Employees can access Leena AI from commonly used UIs like MS Teams or Slack.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Adit Jain, Mayank Goal and Anand Prajapati',
        confidence: 1,
        sources: [
          {
            title: '',
            url: 'https://2969040.fs1.hubspotusercontent-na1.net/hubfs/2969040/Leena%20AI%20-%20Company%20Profile.pdf',
          },
          {
            title:
              'AITech Interview with Adit Jain, Co-Founder & CEO at Leena AI',
            url: 'https://ai-techpark.com/aitech-interview-adit-jain-leena-ai/',
          },
          {
            title:
              'Adit Jain on LinkedIn: #scalingstartups #revupyourgrowth #ceoconfessions #startupstories',
            url: 'https://www.linkedin.com/posts/adit-jain-leena-ai_scalingstartups-revupyourgrowth-ceoconfessions-activity-7094546222723604480-lGLs',
          },
        ],
      },
    ],
    [
      {
        text: 'Quivr',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2024',
        confidence: 1,
        sources: [
          {
            title:
              'Quivr: Open Source Chat-Powered Second Brain | Y Combinator',
            url: 'https://www.ycombinator.com/companies/quivr',
          },
          {
            title:
              'Stan Girard on LinkedIn: Launch YC: 🧠 Quivr: Open source, chat-powered second brain with 28k+ ⭐ |…',
            url: 'https://www.linkedin.com/posts/stan-girard_launch-yc-quivr-open-source-chat-powered-activity-7165405987535839234-lD_G',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
          {
            title: '',
            url: 'https://twitter.com/quine_sh/status/1763545403037790210',
          },
        ],
      },
      {
        text: '3.55',
        confidence: 1,
        sources: [
          {
            title:
              'QUIVR, A DECENTRALIZED SOCIAL IDENTIFICATION AND VERIFICATION PLATFORM, RAISES $3.55M IN SEED ROUND FUNDING',
            url: 'https://www.prnewswire.com/news-releases/quivr-a-decentralized-social-identification-and-verification-platform-raises-3-55m-in-seed-round-funding-301609941.html',
          },
          {
            title:
              'Decentralised social ID and verification platform QUIVR raises $3.55 million',
            url: 'https://coinjournal.net/news/decentralised-social-id-and-verification-platform-quivr-raises-3-55-million/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Quivr is an AI open-source platform where enterprises connect to their tools, docs, APIs and databases to chat with them. The app can be deployed to the cloud, or self-hosted on existing infrastructure to answer any data privacy concerns.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Stan Girard, Antoine Dewez, and Brian Laleye are the co-founders of Quivr.',
        confidence: 1,
        sources: [
          {
            title:
              'Quivr: Open Source Chat-Powered Second Brain | Y Combinator',
            url: 'https://www.ycombinator.com/companies/quivr',
          },
        ],
      },
    ],
    [
      {
        text: 'AlphaWatch AI',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2022',
        confidence: 1,
        sources: [
          {
            title:
              'Products, Competitors, Financials, Employees, Headquarters Locations',
            url: 'https://www.cbinsights.com/company/alphawatch-ai',
          },
          {
            title:
              'AlphaWatch AI: AI copilot for hedge funds with trusted data | Y Combinator',
            url: 'https://www.ycombinator.com/companies/alphawatch-ai',
          },
        ],
      },
      {
        text: '0.5',
        confidence: 1,
        sources: [
          {
            title:
              'AlphaWatch AI Stock Price, Funding, Valuation, Revenue & Financial Statements',
            url: 'https://www.cbinsights.com/company/alphawatch-ai/financials',
          },
        ],
      },
      {
        text: '99M',
        confidence: 1,
        sources: [
          {
            title:
              'AlphaWatch AI Stock Price, Funding, Valuation, Revenue & Financial Statements',
            url: 'https://www.cbinsights.com/company/alphawatch-ai/financials',
          },
        ],
      },
      {
        text: 'AlphaWatch AI is a research and analysis platform designed for hedge funds and private equity firms. By using custom LLMs, specialized embedding models, and integrating with both trusted external data sources and secure private data, AlphaWatch AI offers a reliable chat interface that cites its sources, saving financial professionals time on research.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Varun Varahabhotla and Jackson Chen',
        confidence: 1,
        sources: [
          {
            title:
              'AlphaWatch AI: AI copilot for hedge funds with trusted data | Y Combinator',
            url: 'https://www.ycombinator.com/companies/alphawatch-ai',
          },
        ],
      },
    ],
    [
      {
        text: 'Kater',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'kater.ai: Answer Data Questions in Plain English | Y Combinator',
            url: 'https://www.ycombinator.com/companies/kater-ai',
          },
        ],
      },
      {
        text: 'I could not find any information about the total funding amount raised by the startup Kater in the given sources.',
        confidence: 0,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "Kater is the self-learning data analyst that organizes, understands, and remembers all the nuances of your company's data estate. The more you use Kater, the better it gets. With a simple chat-like interface and an innovative data discovery catalog, Kater saves data teams 10-20 weekly hours of adhoc requests, and allows stakeholders to receive answers in 10 seconds rather than 10 days.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Yvonne Chou and Robin Seitz',
        confidence: 1,
        sources: [
          {
            title:
              'kater.ai: Answer Data Questions in Plain English | Y Combinator',
            url: 'https://www.ycombinator.com/companies/kater-ai',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
    ],
    [
      {
        text: 'Million.js',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2024',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Million.js is an open source tool that makes React.js 70% faster. We want to make Million a web embed that allows developers to select and ask why parts of a page are slow and automatically generate a GitHub pull request with a fix using AI.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Aiden Bai',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'Magic Patterns',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2022',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '145',
        confidence: 0.3,
        sources: [
          {
            title:
              'Magic AI Secures $117 Million to Build an AI Software Engineer',
            url: 'https://www.maginative.com/article/magic-ai-secures-117-million-to-build-an-ai-software-engineer/',
          },
          {
            title:
              'Magic announces $52M Strategic Funding Round led by PayPal Ventures',
            url: 'https://www.prnewswire.com/news-releases/magic-announces-52m-strategic-funding-round-led-by-paypal-ventures-301838352.html',
          },
        ],
      },
      {
        text: '$145 million',
        confidence: 0.3,
        sources: [],
      },
      {
        text: "Get design inspiration and generate production-ready frontend code from a text prompt, image, or Figma mockup. Engineers and designers at large and small companies use Magic Patterns to speed up time to launch. We support generating UI from your company's existing design system.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Alex Danilowicz and Teddy Ni',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'Marr Labs',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'Marr Labs: AI-voice agents that are indistinguishable from humans. | Y Combinator',
            url: 'https://www.ycombinator.com/companies/marr-labs',
          },
        ],
      },
      {
        text: '$300M',
        confidence: 1,
        sources: [
          {
            title: 'Top 10 Most Successful Seed Stage Raises [2023 Report] ',
            url: 'https://www.linkedin.com/pulse/top-10-most-successful-seed-stage-raises-2023-report-startuproi',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Marr Labs is making AI-voice agents that are indistinguishable from humans. They build task-specific agents for roles like scheduling, sales, customer service and more. Their first product is the Vox Scheduling Agent targeted at the Home Services Industry where every lost call is a lost revenue opportunity.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: "Han and Dave previously created Vlingo, the speech-to-text tech that powered Siri and created Samsung's Siri competitor, S-Voice. Vlingo was acquired for $225M.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
    ],
    [
      {
        text: 'Brewit',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'Brewit: Conversational data analytics for every team | Y Combinator',
            url: 'https://www.ycombinator.com/companies/brewit',
          },
          {
            title:
              'Leo Lu on LinkedIn: The Truth About Building AI Startups Today',
            url: 'https://www.linkedin.com/posts/songanglu_the-truth-about-building-ai-startups-today-activity-7161488749661544449--Fis',
          },
          {
            title:
              "Leo Lu on LinkedIn: 🎉 Excited to announce that Brewit (YC W23) is now one of YC's top 100…",
            url: 'https://www.linkedin.com/posts/songanglu_excited-to-announce-that-brewit-yc-w23-activity-7165150333285941248-vogv',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
          {
            title:
              'Brewit Company Profile: Valuation, Funding & Investors | PitchBook',
            url: 'https://pitchbook.com/profiles/company/539210-89',
          },
        ],
      },
      {
        text: 'Total funding: $250 million in equity and $210 million in debt.',
        confidence: 1,
        sources: [
          {
            title:
              'Startups Raise Over $840.1M, Investors Raise $3.428B for New Funds, and $13.22B in M&A',
            url: 'https://www.linkedin.com/pulse/startups-raise-over-8401m-investors-3428b-new-funds-1322b-ma-dtsle',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Brewit helps companies to create their role-specific BI agents, trained on their database (through feeding sample queries, metric definitions, column descriptions, etc. to create a semantic layer) that can answer data questions/provide data insights (write SQL, generate plots) through a natural language experience.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Leo Lu is the co-founder and CEO of Brewit. Mark Ding is the co-founder and CTO of Brewit. Sam Ding is the co-founder of Brewit.',
        confidence: 1,
        sources: [
          {
            title:
              'Brewit: Conversational data analytics for every team | Y Combinator',
            url: 'https://www.ycombinator.com/companies/brewit',
          },
          {
            title:
              'Brewit: Conversational data analytics for every team | Y Combinator',
            url: 'https://www.ycombinator.com/companies/brewit',
          },
          {
            title:
              'Brewit: Conversational data analytics for every team | Y Combinator',
            url: 'https://www.ycombinator.com/companies/brewit',
          },
        ],
      },
    ],
    [
      {
        text: 'Khoj',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'Khoj: Open-source AI assistant that knows you | Y Combinator',
            url: 'https://www.ycombinator.com/companies/khoj',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
          {
            title:
              'Harsh Singhal on LinkedIn: Khoj: An AI Personal Assistant for your Digital Brain',
            url: 'https://www.linkedin.com/posts/harshsinghal_khoj-an-ai-personal-assistant-for-your-digital-activity-7095300813694066688-pIAz',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Khoj is available on your desktop, mobile or cloud. You can search and chat with notes, document and images across your work and personal life. It can run on your laptop or enterprise cloud completely privately.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Debanjum Singh Solanky and Saba Imran',
        confidence: 1,
        sources: [
          {
            title:
              'Khoj: Open-source AI assistant that knows you | Y Combinator',
            url: 'https://www.ycombinator.com/companies/khoj',
          },
        ],
      },
    ],
    [
      {
        text: 'Oda',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2019',
        confidence: 1,
        sources: [
          {
            title: 'Oda: AI Agent for Home Design | Y Combinator',
            url: 'https://www.ycombinator.com/companies/oda',
          },
        ],
      },
      {
        text: '630.5',
        confidence: 1,
        sources: [
          {
            title: 'Grocery Delivery Startup Oda Nabs $151M — At A Price',
            url: 'https://news.crunchbase.com/retail/grocery-delivery-startup-oda/',
          },
          {
            title:
              'Oda, the Norwegian grocery delivery startup, raises a fresh $151M, but at a lowered valuation of $353M',
            url: 'https://techcrunch.com/2022/12/06/oda-the-norwegian-grocery-delivery-startup-raises-a-fresh-151m-but-at-a-lowered-valuation-of-353m/',
          },
        ],
      },
      {
        text: '353',
        confidence: 1,
        sources: [
          {
            title:
              'Oda, the Norwegian grocery delivery startup, raises a fresh $151M, but at a lowered valuation of $353M',
            url: 'https://techcrunch.com/2022/12/06/oda-the-norwegian-grocery-delivery-startup-raises-a-fresh-151m-but-at-a-lowered-valuation-of-353m/',
          },
          {
            title:
              'Online grocer Oda raises €150m — loses unicorn valuation | Sifted',
            url: 'https://sifted.eu/articles/online-grocer-oda-raises-150m',
          },
        ],
      },
      {
        text: 'Oda is an AI agent for home design. Homebuyers and renters alike can use Oda to discover their interior design preferences, apply those preferences to their new home, and then find the best furniture, décor, and appliances aggregated from many different online retailers.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Mine Kansu\nMert Karakus\nEge Ozgirin',
        confidence: 1,
        sources: [
          {
            title: 'Oda: AI Agent for Home Design | Y Combinator',
            url: 'https://www.ycombinator.com/companies/oda',
          },
        ],
      },
    ],
    [
      {
        text: 'Sweep',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'Sweep: AI-powered Python junior developer for software teams | Y Combinator',
            url: 'https://www.ycombinator.com/companies/sweep',
          },
        ],
      },
      {
        text: '27',
        confidence: 1,
        sources: [
          {
            title:
              'Sweep raises a $22M to aim at large corporates scrambling to deal with carbon',
            url: 'https://techcrunch.com/2021/12/16/sweep-raises-a-22m-to-aim-at-large-corporates-scrambling-to-deal-with-carbon/',
          },
          {
            title:
              'French Greentech startup Sweep raises USD 22 million in Series A',
            url: 'https://www.vcbay.news/2021/12/15/french-greentech-startup-sweep-raises-usd-22-million-in-series-a/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Sweep is an AI assistant to automate your software chores like bug fixes and version upgrades.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'William Zeng and Kevin Lu',
        confidence: 1,
        sources: [
          {
            title:
              'Sweep: AI-powered Python junior developer for software teams | Y Combinator',
            url: 'https://www.ycombinator.com/companies/sweep',
          },
          {
            title:
              'Sweep founders share learnings from building an AI coding assistant',
            url: 'https://e2b.dev/blog/sweep-founders-share-learnings-from-building-an-ai-coding-assistant',
          },
          {
            title:
              'Y Combinator on LinkedIn: Launch YC: 🧹 Sweep - AI developer that handles your tech debt | Y… | 40 comments',
            url: 'https://www.linkedin.com/posts/y-combinator_launch-yc-sweep-ai-developer-that-handles-activity-7079156362970075136-uTtS',
          },
          {
            title:
              'Launch HN: Sweep (YC S23) – A bot to create simple PRs in your codebase',
            url: 'https://news.ycombinator.com/item?id=36987454',
          },
          {
            title:
              'Sweep closes $2M seed funding to automate software chores with natural language models. | Y Combinator posted on the topic | LinkedIn',
            url: 'https://www.linkedin.com/posts/y-combinator_sweep-aims-to-automate-basic-dev-tasks-using-activity-7125884410528153602-lo2F',
          },
        ],
      },
    ],
    [
      {
        text: 'Milo',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2019',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Milo has raised $24 million to date, including a $6 million seed round and a $17 million Series A round.',
        confidence: 1,
        sources: [
          {
            title:
              'Milo Raises $6 Million in Seed Funding from QED and MetaProp',
            url: 'https://www.prnewswire.com/news-releases/milo-raises-6-million-in-seed-funding-from-qed-and-metaprop-301215920.html',
          },
          {
            title:
              'Milo’s $17 million Series A will help crypto investors make the most of their holdings - Refresh Miami',
            url: 'https://refreshmiami.com/milos-17-million-series-a-will-help-crypto-investors-make-the-most-of-their-holdings/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "Milo is the Family AI. We give busy parents back time + mindshare by tackling the daily details with a behind the scenes co-pilot. By pairing a human in the loop with the latest in LLM capabilities we're able to effectively build a copilot for detailed, high context and noisy tasks, via a simple conversational SMS interface.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Avni Patel Thompson and Archa Jain are the founders of Milo.',
        confidence: 1,
        sources: [
          {
            title:
              'Meet the OpenAI-backed startup Milo, an AI-powered personal assistant for parents',
            url: 'https://www.businessinsider.com/milo-ai-personal-assistant-for-parents-kids-openai-2023-8',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
    ],
    [
      {
        text: 'Argon AI, Inc.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '1000',
        confidence: 1,
        sources: [
          {
            title:
              'Global VC Funding Settles Around $20B In February But AI Share Increases',
            url: 'https://news.crunchbase.com/venture/monthly-global-funding-recap-february-2024/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Argon AI is a platform where biopharma and life sciences professionals can execute complex and data driven workflows using natural language. We help professionals get thorough answers to questions about clinical trials, existing treatments, healthcare landscape, and the competitive market in minutes rather than months.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Samy, Cyrus and Frances',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
    ],
    [
      {
        text: 'DaLMatian',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title: 'DaLMatian: Supercharge your data team | Y Combinator',
            url: 'https://www.ycombinator.com/companies/dalmatian',
          },
        ],
      },
      {
        text: '22',
        confidence: 1,
        sources: [
          {
            title: 'Series Funding: A, B, and C',
            url: 'https://www.investopedia.com/articles/personal-finance/102015/series-b-c-funding-what-it-all-means-and-how-it-works.asp',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'DaLMatian empowers data teams to focus on what matters most by answering ad-hoc questions from business stakeholders instantly.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Jason Cai, Alan Du, Derrick Xin',
        confidence: 1,
        sources: [
          {
            title: 'DaLMatian: Supercharge your data team | Y Combinator',
            url: 'https://www.ycombinator.com/companies/dalmatian',
          },
        ],
      },
    ],
    [
      {
        text: 'Paradigm',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'Paradigm: Your AI intern to automate repetitive tasks. | Y Combinator',
            url: 'https://www.ycombinator.com/companies/paradigm',
          },
          {
            title:
              'Paradigm AI Company Profile: Valuation, Funding & Investors | PitchBook',
            url: 'https://pitchbook.com/profiles/company/537883-48',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '203',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "Paradigm is building AI agents that integrate with your existing tools and workflows to automate tasks. We think of these agents as able to handle the most repetitive parts of your work while iterating with your feedback, just like an intern would. We are currently focused on sales, automating everything from lead generation to personalized outreach. Paradigm integrates with hundreds of third-party data sources to find leads and make insights customers can't get anywhere else, including event-based triggers on new incorporations and product launches. It then drafts bespoke emails for each lead that imitate your exact tone and style.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Anna Monaco\nCo-Founder & CEO at Paradigm | Penn CS & Entrepreneurship\n\nClaire Oxner\nCo-Founder at Paradigm | Wharton Entrepreneurship & Penn CS',
        confidence: 1,
        sources: [
          {
            title:
              'Paradigm: Your AI intern to automate repetitive tasks. | Y Combinator',
            url: 'https://www.ycombinator.com/companies/paradigm',
          },
        ],
      },
    ],
    [
      {
        text: 'Leaping',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 0.3,
        sources: [],
      },
      {
        text: "I could not find any information about the total funding raised by a startup called 'Leaping' in the given sources. The sources mention funding details for companies like Magic Leap, Leap Inc., Leal, EOS blockchain, Flywire, Gusto, Convene, and startups on AngelList, but nothing specific about a company named 'Leaping'.",
        confidence: 0.3,
        sources: [],
      },
      {
        text: '1900',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Leaping autonomously root causes bugs and generates tested code fixes.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
    ],
    [
      {
        text: 'Hona',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2022',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "Hona integrates with electronic health record systems to collect and condense medical histories, enabling providers to fully understand their patients by finding data previously lost in mountains of charts. It searches nationwide for patient data based on providers' schedules, condensing notes, lab results, and more into specialty-specific clinical summaries with links to original sources. Hona then converts its clinical summaries into value-based care metrics, risk scores, and quality measures for practice-level insights.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
    ],
    [
      {
        text: 'Bytebot',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2021',
        confidence: 1,
        sources: [
          {
            title: 'Bytebot: Browser automations powered by AI. | Y Combinator',
            url: 'https://www.ycombinator.com/companies/bytebot',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '2500',
        confidence: 1,
        sources: [
          {
            title:
              'New AI, Robotics, Spacetech And Fintech Unicorns Trot Onto Leaderboard In February',
            url: 'https://news.crunchbase.com/ai/new-unicorn-board-companies-february-2024-moonshot-ai/',
          },
        ],
      },
      {
        text: 'Bytebot simplifies and streamlines web tasks by translating natural language prompts into browser automation, including clicks, form filling, and data extraction. The platform and SDK enables users to develop robust, dynamic web automation scripts that adapt alongside changing web environments.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Carl Atupem',
        confidence: 1,
        sources: [
          {
            title: 'Bytebot: Browser automations powered by AI. | Y Combinator',
            url: 'https://www.ycombinator.com/companies/bytebot',
          },
          {
            title:
              'Carl Atupem on LinkedIn: Bytebot - Leverage the power of AI in your web scraping, automation…',
            url: 'https://www.linkedin.com/posts/carl-atupem-94873245_bytebot-leverage-the-power-of-ai-in-your-activity-7163252718034141185-ZEe7',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
    ],
    [
      {
        text: 'Superagent.sh',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title: 'Superagent.sh: Run any workflow using AI | Y Combinator',
            url: 'https://www.ycombinator.com/companies/superagent-sh',
          },
        ],
      },
      {
        text: '0.5',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '1000',
        confidence: 0.3,
        sources: [],
      },
      {
        text: "Superagent makes it easy for anyone to use AI to do complex tasks. Enterprises and startups already use it for things like managing R&D projects, customer support, and market research. It's open-source, and it's designed for everyone - not just AI experts.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Ismail Pelaseyed and Alan Zabihi',
        confidence: 1,
        sources: [
          {
            title:
              'Dylan Boudro on LinkedIn: Superagent - AI agents & Large Language Model Discussion with Founder…',
            url: 'https://www.linkedin.com/posts/dylanboudro_superagent-ai-agents-large-language-model-activity-7077640789845053442-r05O',
          },
          {
            title: 'SuperAgent.sh: Your 24/7 AI Assistant',
            url: 'https://www.youtube.com/watch?v=VMLG-5ZZg6Q',
          },
        ],
      },
    ],
    [
      {
        text: 'OffDeal',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'OffDeal: AI agents that help individual buyers find & acquire small businesses | Y Combinator',
            url: 'https://www.ycombinator.com/companies/offdeal',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'OffDeal is building AI agents that help individual buyers find and acquire small businesses. Our AI broker acts much like a human M&A advisor would - it finds targets, diligences them, and then reaches out to them on your behalf. However, unlike a human, our AI broker can do this for thousands of companies at a time',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Ori Eldarov and Alston Lin',
        confidence: 1,
        sources: [
          {
            title:
              'OffDeal: AI agents that help individual buyers find & acquire small businesses | Y Combinator',
            url: 'https://www.ycombinator.com/companies/offdeal',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
          {
            title:
              'Jason Kim on LinkedIn: Private ECDSA Verification using ZK: Motivation, Optimizations & Security',
            url: 'https://www.linkedin.com/posts/jasonkimbc_private-ecdsa-verification-using-zk-motivation-activity-7017168312887320576-WJ86',
          },
        ],
      },
    ],
    [
      {
        text: 'OpenCopilot',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2024',
        confidence: 1,
        sources: [
          {
            title:
              'OpenCopilot: Helping businesses embed an AI copilot that can take actions. | Y Combinator',
            url: 'https://www.ycombinator.com/companies/opencopilot',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '2100',
        confidence: 0.3,
        sources: [
          {
            title:
              'AI (Artificial Intelligence) Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai',
          },
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: 'OpenCopilot is an open-source tool that lets any product easily add AI assistants capable of guiding and helping users with simple English commands. For example, a music app can now understand and execute "play my favorite playlist" or "create a playlist based on listening history" without any complex coding.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Mohammad Gharbat and Shanur Rahman',
        confidence: 1,
        sources: [
          {
            title:
              'OpenCopilot: Helping businesses embed an AI copilot that can take actions. | Y Combinator',
            url: 'https://www.ycombinator.com/companies/opencopilot',
          },
          {
            title:
              'Propeller on LinkedIn: OpenCopilot: Build an AI copilot for your own product. | Y Combinator',
            url: 'https://www.linkedin.com/posts/propeller-inc_opencopilot-build-an-ai-copilot-for-your-activity-7136976645961216000-XnI_?trk=public_profile_like_view',
          },
        ],
      },
    ],
    [
      {
        text: 'Draftaid',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'Draftaid: AI-copilot for manufacturing drawings | Y Combinator',
            url: 'https://www.ycombinator.com/companies/draftaid',
          },
        ],
      },
      {
        text: '320',
        confidence: 1,
        sources: [
          {
            title:
              'Startups Raise Over $840.1M, Investors Raise $3.428B for New Funds, and $13.22B in M&A',
            url: 'https://www.linkedin.com/pulse/startups-raise-over-8401m-investors-3428b-new-funds-1322b-ma-dtsle',
          },
        ],
      },
      {
        text: '150',
        confidence: 0.3,
        sources: [],
      },
      {
        text: "DraftAid is the world's first generative AI for CAD manufacturing drawings, akin to GitHub Copilot but for CAD. It drastically shortens drawing creation time, turning hours into seconds.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Abdullah, Tahsin, and Mohammed are the key founders of Draftaid mentioned in the source.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
    ],
    [
      {
        text: 'Soundry AI',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'Soundry AI: We provide an AI audio generator for music creators | Y Combinator',
            url: 'https://www.ycombinator.com/companies/soundry-ai',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "We have built a universal text-to-sound AI generator for musicians and sound designers. Music producers build songs with samples that they've hand crafted with our AI, and sound designers can incorporate generated sound effects into film, TV, and video games.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Mark Buckler, Justin Parus, and Diandre Ruiz',
        confidence: 1,
        sources: [
          {
            title:
              'Soundry AI: We provide an AI audio generator for music creators | Y Combinator',
            url: 'https://www.ycombinator.com/companies/soundry-ai',
          },
          {
            title:
              'Mark Buckler, PhD on LinkedIn: Launch YC: 🔊 Soundry AI - Generative AI for musicians | Y Combinator',
            url: 'https://www.linkedin.com/posts/markbuckler_launch-yc-soundry-ai-generative-ai-activity-7170574613813420032-h5uj',
          },
          {
            title:
              'Soundry AI builds generative audio tools for musicians. | Y Combinator posted on the topic | LinkedIn',
            url: 'https://www.linkedin.com/posts/y-combinator_launch-yc-soundry-ai-generative-ai-activity-7170523409674649601-yj_N',
          },
        ],
      },
    ],
    [
      {
        text: 'Lumina',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'Lumina: AI Search Engine for Scientific Research | Y Combinator',
            url: 'https://www.ycombinator.com/companies/lumina-2',
          },
          {
            title:
              'The Journal by Fondo | Lumina Launches 🚀 Accelerating Research with AI',
            url: 'https://www.tryfondo.com/blog/lumina-launches',
          },
          {
            title:
              'Launch YC: ⚛️  Lumina - Accelerating Research with AI  🚀 | Y Combinator',
            url: 'https://www.ycombinator.com/launches/K9L-lumina-accelerating-research-with-ai',
          },
        ],
      },
      {
        text: '18.5',
        confidence: 1,
        sources: [
          {
            title: 'Lumina Secures $5 Million In Capital Raise',
            url: 'https://www.prnewswire.com/news-releases/lumina-secures-5-million-in-capital-raise-300882735.html',
          },
          {
            title:
              'Follow the Money: AT&T Part of $10M Lumina Round, Retail Startup Raises $5.7M, Buffett Unit Buys Ebby Halliday',
            url: 'https://dallasinnovates.com/follow-the-money-att-part-of-10m-lumina-round-retail-startup-raises-5-7m-buffett-unit-buys-ebby-halliday/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Lumina leverages Deep Retrieval & Agentic AI to augment complex research tasks. Our current focus is discovery, extraction and curation from scientific journal articles. This helps our >8000 users create and interact with multiple knowledge bases for their research queries and writing tasks. Key features include cited answers, robust extraction tables, agentic search, and an interactive reading experience.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Mehul Chadda, Ishaan Kapoor, and Akhilesh Sharma',
        confidence: 1,
        sources: [
          {
            title:
              'Lumina: AI Search Engine for Scientific Research | Y Combinator',
            url: 'https://www.ycombinator.com/companies/lumina-2',
          },
          {
            title:
              'Launch YC: ⚛️  Lumina - Accelerating Research with AI  🚀 | Y Combinator',
            url: 'https://www.ycombinator.com/launches/K9L-lumina-accelerating-research-with-ai',
          },
          {
            title:
              'The Journal by Fondo | Lumina Launches 🚀 Accelerating Research with AI',
            url: 'https://www.tryfondo.com/blog/lumina-launches',
          },
        ],
      },
    ],
    [
      {
        text: 'Circleback',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2020',
        confidence: 0.3,
        sources: [
          {
            title:
              'Circleback: AI-powered meeting notes and workflows | Y Combinator',
            url: 'https://www.ycombinator.com/companies/circleback',
          },
          {
            title: 'Our Story - About CircleBack',
            url: 'https://circleback.com/our-story/',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
          {
            title:
              'Products, Competitors, Financials, Employees, Headquarters Locations',
            url: 'https://www.cbinsights.com/company/circleback',
          },
          {
            title:
              'Circleback: AI Meeting Assistant - Summarize Calls in Seconds  | Deepgram',
            url: 'https://deepgram.com/ai-apps/circleback',
          },
        ],
      },
      {
        text: '12',
        confidence: 1,
        sources: [
          {
            title:
              'CircleBack raises $12M to smartly manage your business contacts',
            url: 'https://technical.ly/startups/circleback-raises-12-million-smartly-manage-business-contacts/',
          },
        ],
      },
      {
        text: '1000',
        confidence: 1,
        sources: [
          {
            title:
              "Ex-Google employees' A.I. chatbot startup valued at $1 billion after Andreessen Horowitz funding",
            url: 'https://www.cnbc.com/2023/03/23/characterai-valued-at-1-billion-after-150-million-round-from-a16z.html',
          },
        ],
      },
      {
        text: "Circleback helps you get more out of every conversation–whether it's on Zoom, Google Meet, or in-person–by automatically writing notes and taking action on insights you care about. For example, you can have Circleback identify feature requests that come up in product demo calls and create Linear tasks for each of them.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Ali and Kevin met at UBC where they were both in the Business and Computer Science program.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
    ],
    [
      {
        text: 'Ponyrun',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2021',
        confidence: 1,
        sources: [
          {
            title: 'Ponyrun: ChatGPT for Sales Data | Y Combinator',
            url: 'https://www.ycombinator.com/companies/ponyrun',
          },
        ],
      },
      {
        text: '726',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'The sources do not provide a clear valuation for Ponyrun, an AI agent startup. Based on the information that AI startups at the seed stage can command 20% higher valuations (document 5), and that some AI startups like Glean have reached over $2 billion valuations (document 6), my best guess is that Ponyrun could potentially be valued in the hundreds of millions of dollars range, but there is no specific figure given.',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Ponyrun is like ChatGPT for sales data. We help you answer complex questions like "is this deal real?" and recurring questions like "how did my pipeline change?". Talk to us if you want to understand the sales pipeline better, answer questions faster, or want to save time and money on sales analytics infrastructure.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Liusha Huang, Neil Chen, and Nishothan Ithayakumar',
        confidence: 1,
        sources: [
          {
            title: 'Ponyrun: ChatGPT for Sales Data | Y Combinator',
            url: 'https://www.ycombinator.com/companies/ponyrun',
          },
        ],
      },
    ],
    [
      {
        text: 'Trebu',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2022',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
          {
            title:
              'trebu: Extract and organize order requests, supplier availabilities, and… | Y Combinator',
            url: 'https://www.ycombinator.com/companies/trebu',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "The sources do not provide the current valuation of the AI startup Trebu in millions of USD. Based on my general knowledge, early stage AI startups can sometimes achieve valuations in the hundreds of millions or even over $1 billion if they have promising technology and strong investor interest. However, I do not have enough specific information to make an accurate guess for Trebu's valuation.",
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Trebu helps logistics companies to reliably detect and structure incoming sales orders by scanning and interpreting the thousands of incoming Whatsapp messages and emails they receive every day. For example, we help a logistics broker to double the amount of daily reported shipment requests by automatically detecting messages asking for a shipping service and transferring the details into a structured database.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Bret Taylor and Clay Bavor are mentioned as the co-founders of the AI agent startup Sierra, but there is no clear information provided about the founders of Trebu.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'Phind',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2022',
        confidence: 1,
        sources: [
          {
            title: 'Phind: AI answer engine | Y Combinator',
            url: 'https://www.ycombinator.com/companies/phind',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "Phind is an intelligent answer engine for developers. Focused on helping you solve challenging problems, it uses generative AI to give you the answer you're looking for in seconds instead of hours. Connected to the internet and your codebase, Phind has the context it needs to get you the right answer.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Michael Royzen and Justin Wei - Co-founders of Phind',
        confidence: 1,
        sources: [
          {
            title: 'Phind: AI answer engine | Y Combinator',
            url: 'https://www.ycombinator.com/companies/phind',
          },
        ],
      },
    ],
    [
      {
        text: 'HelperAI',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2020',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '1000',
        confidence: 1,
        sources: [
          {
            title:
              "Ex-Google employees' A.I. chatbot startup valued at $1 billion after Andreessen Horowitz funding",
            url: 'https://www.cnbc.com/2023/03/23/characterai-valued-at-1-billion-after-150-million-round-from-a16z.html',
          },
        ],
      },
      {
        text: 'HelperAI: Your enterprise AI agents creation platform. Businesses can easily create customized AI agents to automate workflows. For example, customize 24/7 AI customer support agents by connecting to internal APIs and knowledge bases, and interact through channels like Intercom or Slack.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Siddhant Goswami',
        confidence: 1,
        sources: [
          {
            title:
              'Siddhant Goswami on LinkedIn: AI Agents Built A Start-Up & Launched a Product : ChatDev Full Tutorial',
            url: 'https://www.linkedin.com/posts/siddhant-goswami-6444b0146_ai-agents-built-a-start-up-launched-a-product-activity-7130538642762059776-vi0v',
          },
        ],
      },
    ],
    [
      {
        text: 'Flair Labs',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2022',
        confidence: 1,
        sources: [
          {
            title:
              'Flair Labs: Unlock insights from conversation data with LLMs | Y Combinator',
            url: 'https://www.ycombinator.com/companies/flair-labs',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '0.5',
        confidence: 1,
        sources: [
          {
            title:
              'Flair Labs Company Profile: Valuation, Funding & Investors | PitchBook',
            url: 'https://pitchbook.com/profiles/company/539812-54',
          },
        ],
      },
      {
        text: '$300 million',
        confidence: 1,
        sources: [
          {
            title:
              'AI Startup for Aerospace Valued at About $300 Million in New Financing -  BNN Bloomberg',
            url: 'https://www.bnnbloomberg.ca/ai-startup-for-aerospace-valued-at-about-300-million-in-new-financing-1.2008599',
          },
        ],
      },
      {
        text: 'Flair ingests unstructured voice data with LLMs, so businesses can uncover customer insights and revenue opportunities at scale, without listening to calls.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
    ],
    [
      {
        text: 'Cambio',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2022',
        confidence: 1,
        sources: [
          {
            title:
              'Cambio: AI voice agents for the financial services industry | Y Combinator',
            url: 'https://www.ycombinator.com/companies/cambio',
          },
          {
            title:
              'Tom Kane on LinkedIn: YC-backed Cambio puts AI bots on the phone to negotiate debt, talk to a…',
            url: 'https://www.linkedin.com/posts/thomaskane_yc-backed-cambio-puts-ai-bots-on-the-phone-activity-7163512039464710144-Uvlv',
          },
        ],
      },
      {
        text: '3.2',
        confidence: 1,
        sources: [
          {
            title:
              'Cambio secures $3m in seed funding to revolutionise debt negotiation with AI',
            url: 'https://fintech.global/2024/02/14/cambio-secures-3m-in-seed-funding-to-revolutionise-debt-negotiation-with-ai/',
          },
          {
            title:
              'Cambio (Business/Productivity Software) Company Profile: Valuation, Funding & Investors | PitchBook',
            url: 'https://pitchbook.com/profiles/company/507264-85',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "Cambio is helping the financial services industry drive revenue and engagement with AviaryAI, the industry's first outbound AI sales team for banks, credit unions and insurance companies. AviaryAI provides a suite of private LLMs designed to help institutions leverage Generative AI while meeting regulatory standards.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Blesson Abraham (CEO), Jay Patel, and Julian Allen',
        confidence: 1,
        sources: [
          {
            title: 'Cambio (YC S22) | LinkedIn',
            url: 'https://www.linkedin.com/company/cambiomoney',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
          {
            title:
              'YC-backed Cambio puts AI bots on the phone to negotiate debt, talk to a bank’s customers',
            url: 'https://techcrunch.com/2024/02/13/yc-backed-cambio-puts-ai-bots-on-the-phone-to-negotiate-debt-talk-to-a-banks-customers/',
          },
        ],
      },
    ],
    [
      {
        text: 'Mendable',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2022',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "Our customers include MongoDB, Doordash, Snapchat, and Coinbase - where we're helping teams with an LLM assistant that answers questions and automates tasks. This assistant can access a continuously improving knowledge base aggregated from the entirety of the sales stack.",
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Caleb Peffer, Garrett Frohman, Eric Ciarla',
        confidence: 1,
        sources: [
          {
            title: 'Mendable - Service List',
            url: 'https://servicelist.io/company/mendable?ab374ee6_page=1',
          },
        ],
      },
    ],
    [
      {
        text: 'Nara',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: '2019',
        confidence: 1,
        sources: [
          {
            title:
              'Nara: Answer 70% of your support and sales questions. Instantly | Y Combinator',
            url: 'https://www.ycombinator.com/companies/nara',
          },
        ],
      },
      {
        text: '4',
        confidence: 1,
        sources: [
          {
            title:
              'Nara Wants To Build A Better Recommendation Platform, Starts With Restaurants And A $4 Million Series A Round',
            url: 'https://techcrunch.com/2012/06/26/nara-funding-series-a/',
          },
        ],
      },
      {
        text: '500 million',
        confidence: 1,
        sources: [
          {
            title:
              'AI 50 2021: America’s Most Promising Artificial Intelligence Companies',
            url: 'https://www.forbes.com/sites/alanohnsman/2021/04/26/ai-50-americas-most-promising-artificial-intelligence-companies/',
          },
        ],
      },
      {
        text: 'We make it easy for small and medium businesses to build an AI sales agents for their websites and social media, augmenting their sales capacity. This assistant provides personalized shopping recommendations to customers and is available 24/7 to answer their questions.',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
        ],
      },
      {
        text: 'Angela Castillo, Felipe Abello, Oscar Rojas',
        confidence: 1,
        sources: [
          {
            title:
              'Nara: Answer 70% of your support and sales questions. Instantly | Y Combinator',
            url: 'https://www.ycombinator.com/companies/nara',
          },
          {
            title:
              'Launch YC: 🔘 Nara: The AI-driven sales assistant for SMBs | Y Combinator',
            url: 'https://www.ycombinator.com/launches/Jat-nara-the-ai-driven-sales-assistant-for-smbs',
          },
        ],
      },
    ],
    [
      {
        text: 'AutoGPT',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title:
              'The Rise of Hyper-Intelligent AI Agents: Revolutionizing Industries with AutoGPT & BabyAGI',
            url: 'https://liatbenzur.com/2023/04/16/mind-blowing-future-autogpt-babyagi-unlocking-limitless-possibilities/',
          },
          {
            title:
              'The Astounding Progress of AI: AutoGPT — An Autonomous AI Agent',
            url: 'https://medium.com/@munish.munagala/the-astounding-progress-of-ai-autogpt-an-autonomous-ai-agent-813af58e5286',
          },
          {
            title:
              'Michael Spencer on LinkedIn: What is Auto-GPT? Everything to know about the next powerful AI tool',
            url: 'https://ug.linkedin.com/posts/michaelkspencer_what-is-auto-gpt-everything-to-know-about-activity-7053553225072840704-Ws-l',
          },
        ],
      },
      {
        text: '12',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: '$12 million',
        confidence: 0.3,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: 'What Is AutoGPT?',
            url: 'https://www.fool.com/terms/a/autogpt/',
          },
        ],
      },
      {
        text: 'AutoGPT is an experimental open-source application showcasing the capabilities of modern Large Language Models. This program, driven by GPT-4, chains together LLM "thoughts", to autonomously achieve whatever goal you set.',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: 'Toran Bruce Richards (Torantulino) - Significant Gravitas, original founder of Auto-GPT',
        confidence: 1,
        sources: [
          {
            title: 'Meet The Team',
            url: 'https://news.agpt.co/meet-the-team/',
          },
          {
            title:
              'Hype grows over “autonomous” AI agents that loop GPT-4 outputs',
            url: 'https://arstechnica.com/information-technology/2023/04/hype-grows-over-autonomous-ai-agents-that-loop-gpt-4-outputs/',
          },
          {
            title:
              'ChatGPT, Next Level: Meet 10 Autonomous AI Agents – Auto-GPT, BabyAGI, AgentGPT, Microsoft Jarvis, ChaosGPT & Friends – HIVE : Big Picture Blog',
            url: 'https://blog.big-picture.com/en/chatgpt-next-level-meet-10-autonomous-ai-agents-auto-gpt-babyagi-agentgpt-microsoft-jarvis-chaosgpt-friends/',
          },
          {
            title:
              'ChatGPT, Next Level: Meet 10 Autonomous AI Agents: Auto-GPT, BabyAGI, AgentGPT, Microsoft Jarvis, ChaosGPT & friends',
            url: 'https://medium.com/the-generator/chatgpts-next-level-is-agent-ai-auto-gpt-babyagi-agentgpt-microsoft-jarvis-friends-d354aa18f21',
          },
        ],
      },
    ],
    [
      {
        text: 'Relevance AI',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: '2020',
        confidence: 1,
        sources: [
          {
            title: 'Relevance AI raises $15m in Series A round',
            url: 'https://www.businessnewsaustralia.com/articles/relevance-ai-raises--15m-in-series-a-amid-surge-in-clients-for-its-low-code-platform.html',
          },
        ],
      },
      {
        text: '18',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: "The sources do not explicitly mention Relevance AI's current valuation. However, based on the information that they raised $18M in funding over 2 rounds, with the latest Series A round being $10M, a reasonable guess for their current valuation could be in the range of $50M - $100M, which is typical for a Series A AI startup.",
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Relevance AI is a no-code AI agent builder that allows you to train agents with natural language and onboard them as your co-worker. It enables you to distill expertise into AI Tools with a no-code builder, connect with other systems, orchestrate and delegate across many agents, and monitor and manage output of tasks.',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: 'Daniel Vassilev, Daniel Palmer and Jacky Koh',
        confidence: 1,
        sources: [
          {
            title: 'Relevance AI raises $15m in Series A round',
            url: 'https://www.businessnewsaustralia.com/articles/relevance-ai-raises--15m-in-series-a-amid-surge-in-clients-for-its-low-code-platform.html',
          },
        ],
      },
    ],
    [
      {
        text: 'LangChain',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '2022',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '10',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '200',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: "LangChain describes itself as a platform to build context-aware, reasoning applications with LangChain's flexible abstractions and AI-first toolkit. LangChain's platform offers support for various model types, prompt management, memory, indexing, chains, and agents to help developers build LLM-focused applications.",
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: 'Harrison Chase is the co-founder and CEO of LangChain.',
        confidence: 1,
        sources: [
          {
            title:
              'Arize:Observe - Future of Agents with Harrison Chase, Founder of LangChain',
            url: 'https://arize.com/resource/langchain/',
          },
          {
            title: 'Winning in AI means mastering the new stack',
            url: 'https://blog.langchain.dev/winning-in-ai-means-mastering-the-new-stack/',
          },
          {
            title:
              'Harrison Chase on LinkedIn: Ep 28: LangChain CEO Harrison Chase on the Current State of Eval and…',
            url: 'https://www.linkedin.com/posts/harrison-chase-961287118_ep-28-langchain-ceo-harrison-chase-on-the-activity-7165802428745854976-QcMD',
          },
          {
            title:
              'The Building Blocks of Generative AI - Jonathan Shriftman - Medium',
            url: 'https://shriftman.medium.com/the-building-blocks-of-generative-ai-a75350466a2f',
          },
        ],
      },
    ],
    [
      {
        text: 'Cohere',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: '7 Top AI Companies to Watch in 2024',
            url: 'https://aibusiness.com/nlp/7-top-ai-companies-to-watch-in-2024',
          },
        ],
      },
      {
        text: '2019',
        confidence: 1,
        sources: [
          {
            title:
              'Products, Competitors, Financials, Employees, Headquarters Locations',
            url: 'https://www.cbinsights.com/company/cohere-3',
          },
          {
            title: 'AI startup Cohere Raising $500 Million: A Closer Look',
            url: 'https://medium.com/@tech_business/ai-startup-cohere-raising-500-million-a-closer-look-f87bce9373c1',
          },
          {
            title: 'Cohere valuation, funding & analysis',
            url: 'https://sacra.com/c/cohere/',
          },
        ],
      },
      {
        text: '445',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: '7 Top AI Companies to Watch in 2024',
            url: 'https://aibusiness.com/nlp/7-top-ai-companies-to-watch-in-2024',
          },
        ],
      },
      {
        text: '2100',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: '7 Top AI Companies to Watch in 2024',
            url: 'https://aibusiness.com/nlp/7-top-ai-companies-to-watch-in-2024',
          },
        ],
      },
      {
        text: "Cohere's vision extends to developing AI agents capable of performing tasks autonomously.",
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: '7 Top AI Companies to Watch in 2024',
            url: 'https://aibusiness.com/nlp/7-top-ai-companies-to-watch-in-2024',
          },
        ],
      },
      {
        text: 'Aidan Gomez, Ivan Zhang, Nick Frosst',
        confidence: 1,
        sources: [
          {
            title: 'About',
            url: 'https://cohere.com/about',
          },
          {
            title: 'Cohere',
            url: 'https://en.wikipedia.org/wiki/Cohere',
          },
        ],
      },
    ],
    [
      {
        text: 'Second',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: '2023',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '0.5',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: '$350 million',
        confidence: 0.3,
        sources: [],
      },
      {
        text: "[Second](https://www.second.dev/?ref=mlq.ai) is another developer-focused startup that automates codebase migrations and upgrades for developers using AI agents. The platform is capable of generating pull requests, and it can be connected to a GitHub repository.\n\nSecond's AI agents are controlled by hand-crafted, purpose-built modules that are engineered for specific code migrations, eliminating prompt drift common with generic AI agents.",
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: 'Bret Taylor and Clay Bavor',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'Lindy.ai',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title: '',
            url: 'https://twitter.com/getlindy?lang=en',
          },
        ],
      },
      {
        text: '50',
        confidence: 1,
        sources: [
          {
            title: 'FF Rising Stars: Flo Crivello, Lindy',
            url: 'https://ff.co/flo-crivello-lindy/',
          },
        ],
      },
      {
        text: '11.77',
        confidence: 1,
        sources: [
          {
            title: 'DNA Capital - Autonomous AI Agents',
            url: 'https://dnacap.fund/insights/autonomous-ai-agents',
          },
        ],
      },
      {
        text: 'Lindy.ai is another AI agent startup that allows you to build AI employees, which they refer to as "Lindies". The platform is no-code and allows you to build agents that go beyond simple text generation tasks and are capable of performing a wide range of actions autonomously.',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: 'Flo Crivello',
        confidence: 1,
        sources: [
          {
            title:
              'Flo Crivello on LinkedIn: Excited to announce Lindy.ai, the AI assistant putting your life on… | 42 comments',
            url: 'https://www.linkedin.com/posts/florentcrivello_excited-to-announce-lindyai-the-ai-assistant-activity-7044338337536491520-UZvB',
          },
          {
            title:
              'Episode 234: Flo Crivello, CEO \\u0026 Founder of Lindy | Host: Julian Torres',
            url: 'https://www.youtube.com/watch?v=uprgUD-1S1k',
          },
          {
            title:
              'Episode 234: Flo Crivello, CEO \\u0026 Founder of Lindy | Host: Julian Torres',
            url: 'https://www.youtube.com/watch?v=uprgUD-1S1k',
          },
          {
            title:
              'Flo Crivello on LinkedIn: I’m going to take a break from startups and remote work to talk about…',
            url: 'https://www.linkedin.com/posts/florentcrivello_im-going-to-take-a-break-from-startups-and-activity-6991028477030252544-cHz7?trk=public_profile_post_view',
          },
          {
            title: 'FF Rising Stars: Flo Crivello, Lindy',
            url: 'https://ff.co/flo-crivello-lindy/',
          },
          {
            title: 'The AI Assistant Revolution with Flo Crivello of Lindy.AI',
            url: 'https://www.youtube.com/watch?v=tGKULKTsapA',
          },
          {
            title:
              "Lindy AI Founder Flo Crivello on Biden's Executive Order and AI Safety",
            url: 'https://www.youtube.com/watch?v=e4EvKX7GICM',
          },
        ],
      },
    ],
    [
      {
        text: 'Spell.so',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: '2023',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Spell.so is another no-code AI agent startup that allows you to create autonomous agents with web access, plugin integrations, and parallel execution. The platform is built around GPT4 and plugins, enabling it to handle a range of tasks such as stock research, competitive analysis, and more.',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
    ],
    [
      {
        text: 'Fixie.ai',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '17',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: '$17 million',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title:
              'Fixie wants to make it easier for companies to build on top of language models',
            url: 'https://techcrunch.com/2023/03/30/fixie-wants-to-make-it-easier-for-companies-to-build-on-top-of-language-models/',
          },
        ],
      },
      {
        text: "Fixie.ai is developing customizable and action-oriented AI agents called Sidekicks. These agents are grounded in the user's data to provide relevant and accurate responses. They have multimodal capabilities to handle text, images, videos, and more, including a generative UI feature to dynamically render UI components as part of their responses.",
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: 'Matt Welsh (CEO and Co-Founder), Justin Uberti (CTO and Co-Founder), Zach Koch (CPO and Co-Founder), and Hessam Bagherinezhad (Chief AI Officer and Co-Founder)',
        confidence: 1,
        sources: [
          {
            title:
              'Sunil Chhaya on LinkedIn: Introducing Fixie.ai: A new way to build with Large Language Models',
            url: 'https://www.linkedin.com/posts/sunil-chhaya_introducing-fixieai-a-new-way-to-build-activity-7033499187912609792-3Z6q',
          },
          {
            title:
              'Matt Welsh - Co-Founder \\u0026 CEO Of Fixie (B2B AI Agent Platform)',
            url: 'https://www.youtube.com/watch?v=Wb9BwryNNbw',
          },
          {
            title: 'The End of Programming | Hacker News',
            url: 'https://news.ycombinator.com/item?id=34087000',
          },
          {
            title: 'The End of Programming | Hacker News',
            url: 'https://news.ycombinator.com/item?id=34087000',
          },
          {
            title:
              'Fixie wants to make it easier for companies to build on top of language models',
            url: 'https://techcrunch.com/2023/03/30/fixie-wants-to-make-it-easier-for-companies-to-build-on-top-of-language-models/',
          },
        ],
      },
    ],
    [
      {
        text: 'Adept',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: '2022',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: '350',
        confidence: 1,
        sources: [
          {
            title:
              'Adept Raises $350 Million To Build AI That Learns How To Use Software For You',
            url: 'https://www.forbes.com/sites/kenrickcai/2023/03/14/adept-ai-startup-raises-350-million-series-b/',
          },
          {
            title:
              'Essential AI reveals funding, development of full-stack AI automation tools',
            url: 'https://www.computerworld.com/article/3711620/essential-ai-reveals-funding-development-of-full-stack-ai-automation-tools.html',
          },
          {
            title: 'Announcing our Series B',
            url: 'https://www.adept.ai/blog/series-b',
          },
        ],
      },
      {
        text: '1000',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Founded in 2022, Adept is "building a machine learning model that can interact with everything on your computer". Their key development so far is a model called Action Transformer (ACT-1), which is: Designed and trained specifically for taking actions on computers in response to your natural language commands.',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
        ],
      },
      {
        text: 'The key founders of Adept are David Luan (CEO), Ashish Vaswani (Chief Scientist), and Niki Parmar (CTO). Luan was previously at OpenAI and Google, while Vaswani and Parmar were researchers at Google Brain who co-authored the paper that invented the transformer architecture.',
        confidence: 1,
        sources: [
          {
            title:
              'Adept Raises $350 Million To Build AI That Learns How To Use Software For You',
            url: 'https://www.forbes.com/sites/kenrickcai/2023/03/14/adept-ai-startup-raises-350-million-series-b/',
          },
          {
            title: "Alexa, what's next for digital assistants?",
            url: 'https://fortune.com/2022/07/05/a-i-digital-assistants-adept-eye-on-ai/',
          },
          {
            title: 'What Is Adept AI? - FourWeekMBA',
            url: 'https://fourweekmba.com/adept-ai/',
          },
          {
            title: 'Introducing Adept',
            url: 'https://www.adept.ai/blog/introducing-adept',
          },
        ],
      },
    ],
    [
      {
        text: 'OpenAI',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2015',
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'OpenAI has raised around $10.3 billion in total funding, with $10 billion coming from Microsoft and around $300 million from other venture capital investors at a valuation of $27-29 billion.',
        confidence: 0.8,
        sources: [
          {
            title:
              'OpenAI Completes Deal That Values the Company at $80 Billion',
            url: 'https://www.nytimes.com/2024/02/16/technology/openai-artificial-intelligence-deal-valuation.html',
          },
          {
            title:
              'January Monthly Recap: OpenAI Raised A Third Of All Funding',
            url: 'https://news.crunchbase.com/venture/monthly-vc-funding-openai-recap-january-2023/',
          },
          {
            title:
              'Global VC Funding Settles Around $20B In February But AI Share Increases',
            url: 'https://news.crunchbase.com/venture/monthly-global-funding-recap-february-2024/',
          },
          {
            title:
              "Sam Altman's OpenAI to be second-most valuable U.S. startup behind Elon Musk's SpaceX based on early-talks funding round",
            url: 'https://fortune.com/2023/12/23/openai-valuation-100-billion-funding-round/',
          },
          {
            title: 'OpenAI closes $300M share sale at $27B-29B valuation',
            url: 'https://techcrunch.com/2023/04/28/openai-funding-valuation-chatgpt/',
          },
        ],
      },
      {
        text: "OpenAI's latest valuation is $29,000 million or $29 billion.",
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: "OpenAI's recent release of GPT-4 Turbo and the Assistants API will likely lead to a Cambrian explosion of AI agent startups in the coming years. An Assistant has instructions and can leverage models, tools, and knowledge to respond to user queries. The Assistants API currently supports three types of tools: Code Interpreter, Retrieval, and Function calling.",
        confidence: 1,
        sources: [
          {
            title: 'AI Agent Startups to Watch',
            url: 'https://www.mlq.ai/ai-agent-startups-to-watch/',
          },
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'In 2015, OpenAI was established by the efforts of Elon Musk, Ilya Sutskever, Greg Brockman, Sam Altman, and Wojciech Zaremba in San Francisco, California.',
        confidence: 1,
        sources: [
          {
            title: 'Success Story of OpenAI- The Makers of the ChatGPT',
            url: 'https://startuptalky.com/openai-success-story/',
          },
        ],
      },
    ],
    [
      {
        text: 'Glean',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '2019',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '360',
        confidence: 1,
        sources: [
          {
            title:
              'Glean wants to beat ChatGPT at its own game — in the enterprise',
            url: 'https://techcrunch.com/2024/02/27/glean-wants-to-beat-chatgpt-at-its-own-game-in-the-enterprise/',
          },
        ],
      },
      {
        text: '2200',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: "Work assistant that searches across all your company's apps to help you find what you need",
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: 'Arvind Jain',
        confidence: 1,
        sources: [
          {
            title:
              'Conversations in Collaboration: Glean’s Arvind Jain on Searching Enterprise Data',
            url: 'https://www.nojitter.com/ai-automation/conversations-collaboration-glean%E2%80%99s-arvind-jain-searching-enterprise-data',
          },
          {
            title: 'How Glean found product-market fit',
            url: 'https://www.unusual.vc/post/how-glean-found-product-market-fit-arvind-jain-on-enterprise-search-and-ai',
          },
          {
            title:
              'US enterprise AI search startup Glean raises $200 million, plans hiring spree',
            url: 'https://malaysia.news.yahoo.com/us-enterprise-ai-search-startup-212416294.html',
          },
          {
            title:
              'AI-Powered Work Assistant Glean Grabs $200M At $2.2B Valuation',
            url: 'https://news.crunchbase.com/ai/work-assistant-unicorn-startup-venture-glean/',
          },
        ],
      },
    ],
    [
      {
        text: 'Ambience Healthcare',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '2020',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '70',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '$126 million post-money when it raised its Series A in 2022',
        confidence: 1,
        sources: [
          {
            title:
              'Ambience Healthcare raises $70M for its AI assistant led by OpenAI and Kleiner Perkins',
            url: 'https://techcrunch.com/2024/02/06/ambience-healthcare-raises-70m-for-its-ai-assistant-led-by-openai-and-kleiner-perkins/',
          },
        ],
      },
      {
        text: 'Ambience Healthcare is developing a suite of AI-powered products for healthcare providers, including:\n\nAutoScribe - A real-time AI medical scribe that generates comprehensive clinical notes by listening to provider-patient conversations across all specialties. It integrates with major EMRs.\n\nAutoCDI - A point-of-care clinical documentation improvement assistant that analyzes conversations and EMR data to ensure proper coding of diagnoses, procedures, and documentation.\n\nAutoRefer - AI software that composes referral letters to specialists with relevant clinical details.\n\nAutoAVS - Generates tailored after-visit summaries for patients and caregivers in their preferred language.\n\nAutoPrep (coming soon) - Intelligent pre-charting to provide context and suggestions for the upcoming visit.',
        confidence: 1,
        sources: [
          {
            title:
              'Leading AI operating system for healthcare | Ambience Healthcare',
            url: 'https://www.ambiencehealthcare.com/',
          },
          {
            title:
              'Ambience Healthcare raises $70M for its AI assistant led by OpenAI and Kleiner Perkins',
            url: 'https://techcrunch.com/2024/02/06/ambience-healthcare-raises-70m-for-its-ai-assistant-led-by-openai-and-kleiner-perkins/',
          },
          {
            title:
              'Julie Yoo on LinkedIn: Ambience Healthcare Launches Fully Automated AI Medical Scribe to Address…',
            url: 'https://www.linkedin.com/posts/juliekyoo_ambience-healthcare-launches-fully-automated-activity-7035789825051955200-eFCq',
          },
          {
            title:
              'Julie Yoo on LinkedIn: Ambience Healthcare Launches Fully Automated AI Medical Scribe to Address…',
            url: 'https://www.linkedin.com/posts/juliekyoo_ambience-healthcare-launches-fully-automated-activity-7035789825051955200-eFCq',
          },
          {
            title:
              'Ambience Healthcare Raises $70M to Scale the Most Comprehensive AI Operating System for Healthcare Organizations',
            url: 'https://www.prnewswire.com/news-releases/ambience-healthcare-raises-70m-to-scale-the-most-comprehensive-ai-operating-system-for-healthcare-organizations-302054056.html',
          },
        ],
      },
      {
        text: 'Michael Ng and Nikhil Buduma',
        confidence: 1,
        sources: [
          {
            title:
              'Ambience Healthcare raises $70M for its AI assistant led by OpenAI and Kleiner Perkins',
            url: 'https://techcrunch.com/2024/02/06/ambience-healthcare-raises-70m-for-its-ai-assistant-led-by-openai-and-kleiner-perkins/',
          },
          {
            title:
              'Ambience Healthcare Raises $70M to Scale the Most Comprehensive AI Operating System for Healthcare Organizations',
            url: 'https://www.prnewswire.com/news-releases/ambience-healthcare-raises-70m-to-scale-the-most-comprehensive-ai-operating-system-for-healthcare-organizations-302054056.html',
          },
          {
            title:
              'Julie Yoo on LinkedIn: Ambience Healthcare Launches Fully Automated AI Medical Scribe to Address…',
            url: 'https://www.linkedin.com/posts/juliekyoo_ambience-healthcare-launches-fully-automated-activity-7035789825051955200-eFCq',
          },
          {
            title:
              'Ambience Healthcare Rakes In $70M for Documentation Tech That One Customer Calls ‘Close to Perfection’',
            url: 'https://medcitynews.com/2024/02/healthcare-clinical-documentation-ai/',
          },
        ],
      },
    ],
    [
      {
        text: 'Instawork',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '2015',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '160',
        confidence: 1,
        sources: [
          {
            title:
              'Instawork Raises $60M to Invest in Artificial Intelligence, Optimizing How Businesses Connect With Skilled Hourly Workers',
            url: 'https://markets.businessinsider.com/news/stocks/instawork-raises-60m-to-invest-in-artificial-intelligence-optimizing-how-businesses-connect-with-skilled-hourly-workers-1032337199',
          },
          {
            title:
              'USA-based Instawork raises USD 60 million in recent financing ',
            url: 'https://www.vcbay.news/2023/05/20/usa-based-instawork-raises-usd-60-million-in-recent-financing/',
          },
        ],
      },
      {
        text: '$760M valuation',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: 'Instawork is developing an AI-powered platform and mobile app that leverages billions of data signals about its pool of over 4 million hourly workers to optimize worker fit for specific roles, increase worker reliability in showing up for shifts, and maximize the return rate of high-performing workers. The AI aims to make better matches between businesses and hourly workers for staffing needs.',
        confidence: 1,
        sources: [
          {
            title:
              'Instawork invests in AI to optimize how businesses find the workers they need',
            url: 'https://www.instawork.com/blog/instawork-invests-in-artificial-intelligence-to-optimize-how-businesses-find-the-workers-they-need',
          },
          {
            title:
              'Instawork invests in AI to optimize how businesses find the workers they need',
            url: 'https://www.instawork.com/blog/instawork-invests-in-artificial-intelligence-to-optimize-how-businesses-find-the-workers-they-need',
          },
          {
            title:
              'Instawork invests in AI to optimize how businesses find the workers they need',
            url: 'https://www.instawork.com/blog/instawork-invests-in-artificial-intelligence-to-optimize-how-businesses-find-the-workers-they-need',
          },
          {
            title:
              'Y Combinator on LinkedIn: Instawork invests in Artificial Intelligence to optimize how businesses…',
            url: 'https://ng.linkedin.com/posts/y-combinator_instawork-invests-in-artificial-intelligence-activity-7065424791712772097-w1xZ',
          },
          {
            title: 'Revolutionizing the hourly workforce with AI',
            url: 'https://www.instawork.com/ai',
          },
          {
            title: 'What is Instawork? | Our platform and mission',
            url: 'https://www.instawork.com/about',
          },
        ],
      },
      {
        text: 'Sumir Meghani (CEO), Saureen Shah',
        confidence: 1,
        sources: [
          {
            title: 'Next Billion-Dollar Startups 2022',
            url: 'https://www.forbes.com/sites/amyfeldman/2022/08/16/next-billion-dollar-startups-2022/',
          },
        ],
      },
    ],
    [
      {
        text: 'Rasa',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '2016',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '70',
        confidence: 1,
        sources: [
          {
            title:
              'Conversational AI startup Rasa Technologies raises $30M to combine LLMs with traditional chatbots - SiliconANGLE',
            url: 'https://siliconangle.com/2024/02/14/draft-conversational-ai-startup-rasa-technologies-raises-30m-combine-llms-traditional-chatbots/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Rasa is the leading open source machine learning toolkit that lets developers build conversational bots.',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: 'Alex Weidauer and Alan Nichol',
        confidence: 1,
        sources: [
          {
            title: 'Meet the Rasa Team',
            url: 'https://rasa.com/about/',
          },
          {
            title: 'Meet the Rasa Team',
            url: 'https://rasa.com/about/',
          },
          {
            title:
              'Alan Nichol on LinkedIn: Rasa, an enterprise-focused dev platform for conversational GenAI, raises… | 25 comments',
            url: 'https://www.linkedin.com/posts/anichol_rasa-an-enterprise-focused-dev-platform-activity-7163612611706630147-l46_',
          },
          {
            title:
              'Rasa Secures $13M Series A Investment Led by Accel To Power Conversational AI',
            url: 'https://www.prnewswire.com/news-releases/rasa-secures-13m-series-a-investment-led-by-accel-to-power-conversational-ai-300830545.html',
          },
          {
            title: 'The Rasa Summit 2021',
            url: 'https://rasa.com/summit/',
          },
          {
            title:
              'Rasa, an enterprise-focused dev platform for conversational GenAI, raises $30M',
            url: 'https://techcrunch.com/2024/02/14/rasa-an-enterprise-focused-dev-platform-for-conversational-genai-raises-30m/',
          },
          {
            title:
              'Accel - Enterprise automation and conversational AI: Our investment in Rasa',
            url: 'https://www.accel.com/noteworthy/enterprise-automation-and-conversational-ai-our-investment-in-rasa',
          },
        ],
      },
    ],
    [
      {
        text: 'Pika',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '35',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '200',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: 'Idea-to-video platform that brings your creativity to motion',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: 'Demi Guo and Chenlin Meng',
        confidence: 1,
        sources: [
          {
            title: "Pika's Imagination Engine",
            url: 'https://www.linkedin.com/pulse/pikas-imagination-engine-michael-mignano-9l9hc',
          },
          {
            title:
              'Pika Launches AI Video Editing App And Announces $55 Million In Funding',
            url: 'https://www.forbes.com/sites/kenrickcai/2023/11/27/pika-ai-video-generator-editor-series-a/',
          },
          {
            title:
              'AI&YOU#46: Pika Labs Profile + AI Lip Syncing With ElevenLabs Partnership',
            url: 'https://www.linkedin.com/pulse/aiyou46-pika-labs-profile-ai-lip-syncing-elevenlabs-greggory-elias-marde',
          },
          {
            title:
              'Pika, which is building AI tools to generate and edit videos, raises $55M',
            url: 'https://techcrunch.com/2023/11/28/pika-labs-which-is-building-ai-tools-to-generate-and-edit-videos-raises-55m/',
          },
          {
            title:
              'The Story of Pika: 4 People Changing The AI Game - kinson chow - Medium',
            url: 'https://medium.com/@tofujoy77/the-story-of-pika-4-people-changing-the-ai-game-72d20861758a',
          },
          {
            title:
              'Pika Launches Impressive AI-Powered Video Platform, Raises $55M',
            url: 'https://www.maginative.com/article/pika-launches-impressive-ai-powered-video-platform-raises-55m/',
          },
          {
            title: 'Pika Labs Founders',
            url: 'https://pikalabs.org/pika-labs-founders/',
          },
          {
            title: 'What is Pika Labs?',
            url: 'https://datasciencelearningcenter.substack.com/p/what-is-pika-labs',
          },
        ],
      },
    ],
    [
      {
        text: 'Airspace Intelligence',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '2018',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '34',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '300',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: 'Airspace Intelligence does not appear to be developing an AI agent product based on the given sources. The sources mention an AI-powered operating system called Flyways for air traffic management and flight optimization, but do not provide details about an AI agent product for customer service or personal assistance.',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Nick Bulcao, CEO and Co-Founder, and Ryan Rusnak, CTO and Co-Founder',
        confidence: 1,
        sources: [
          {
            title:
              "Founder Spotlight: Airspace's Nick Bulcao and Ryan Rusnak on Using AI to Transform Logistics",
            url: 'https://www.qualcommventures.com/insights/blog/founder-spotlight-airspaces-nick-bulcao-and-ryan-rusnak-on-transforming-logistics/',
          },
          {
            title:
              "Founder Spotlight: Airspace's Nick Bulcao and Ryan Rusnak on Using AI to Transform Logistics",
            url: 'https://www.qualcommventures.com/insights/blog/founder-spotlight-airspaces-nick-bulcao-and-ryan-rusnak-on-transforming-logistics/',
          },
        ],
      },
    ],
    [
      {
        text: 'Mistral.ai',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '2023',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '415',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '2000',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: 'Mistral AI is developing an AI assistant also named Mistral that can engage in natural, multi-turn conversations on a variety of topics. Mistral leverages large language models and reinforcement learning to understand context, ask clarifying questions, and provide helpful information. According to the company, Mistral can chat about casual topics like sports and movies, answer general knowledge questions, provide advice and recommendations, and even roleplay different personas. Mistral AI boasts advanced conversational abilities that allow it to have natural, human-like conversations. It utilizes sophisticated natural language processing techniques to deeply understand natural language queries and requests.',
        confidence: 1,
        sources: [
          {
            title:
              'Mistral AI’s New 8x7B Model: How to Harness the Power of Artificial Intelligence',
            url: 'https://medium.com/@nik.cp13/mistral-ais-new-8x7b-model-how-to-harness-the-power-of-artificial-intelligence-e315c1c8489d',
          },
          {
            title:
              "Mistral Living Large, Google's Open Source Challenger, Robot Chemist, and more",
            url: 'https://www.deeplearning.ai/the-batch/issue-239/',
          },
        ],
      },
      {
        text: 'Guillaume Lample, Arthur Mensch, Timothée Lacroix',
        confidence: 1,
        sources: [
          {
            title: 'Meet Europe’s Next Great Generative AI Startup: Mistral AI',
            url: 'https://medium.com/lightspeed-venture-partners/meet-europes-next-great-generative-ai-startup-mistral-ai-25ee537b1f9e',
          },
          {
            title:
              'France’s Mistral AI blows in with a $113M seed round at a $260M valuation to take on OpenAI',
            url: 'https://techcrunch.com/2023/06/13/frances-mistral-ai-blows-in-with-a-113m-seed-round-at-a-260m-valuation-to-take-on-openai/',
          },
          {
            title: 'Meet the French startup hoping to take on OpenAI',
            url: 'https://www.economist.com/business/2024/02/26/meet-the-french-startup-hoping-to-take-on-openai',
          },
        ],
      },
    ],
    [
      {
        text: 'Squint',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '2021',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '13',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '$13M',
        confidence: 1,
        sources: [
          {
            title:
              'Squint peers at $13M led by Sequoia for AR aimed at B2B to interact with physical objects',
            url: 'https://techcrunch.com/2023/11/29/squint-ai-ar/',
          },
        ],
      },
      {
        text: 'Squint is a mobile app that uses AI and AR to automate data entry, generate custom procedures, and make every operator an expert. It presents contextual information at the right time and place. With Squint, new employees at a manufacturing facility can hold up their phone or tablet at a machine and learn how to use it safely and adequately with instructions in front of them while they work. Squint is also unveiling Procedure Generation, which uses multimodal generative AI to instantly generate precise, step-by-step instructions from just a video recording of a task.',
        confidence: 1,
        sources: [
          {
            title: 'About',
            url: 'https://www.squint.ai/about',
          },
          {
            title:
              'Devin Bhushan, Squint: Accelerating Human Potential with Augmented Reality',
            url: 'https://www.boringbusinessnerd.com/post/devin-bhushan-squint',
          },
          {
            title:
              'Devin Bhushan, Squint: Accelerating Human Potential with Augmented Reality',
            url: 'https://www.boringbusinessnerd.com/post/devin-bhushan-squint',
          },
          {
            title:
              'Why We Raised $13M from Sequoia to Empower More Industrial Workers',
            url: 'https://www.squint.ai/blog/series-a',
          },
        ],
      },
      {
        text: 'Devin Bhushan, Founder & CEO\nDylan Conway, Founding Product Lead\nJim Zhu, Founding Engineering Lead',
        confidence: 1,
        sources: [
          {
            title: 'Meet The Team',
            url: 'https://www.squint.ai/blog/meet-the-team',
          },
        ],
      },
    ],
    [
      {
        text: 'Harvey',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '2021',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '$80M Series B in 2023',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '715',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: 'Harvey AI is an AI-powered legal assistant that can assist lawyers with tasks like contract analysis, due diligence, litigation, and regulatory compliance. It leverages large language models trained on legal data to understand user intent and generate relevant outputs. Instead of manually editing documents or doing research, lawyers can describe the task in plain English and Harvey will generate the desired result.',
        confidence: 1,
        sources: [
          {
            title:
              'Harvey, which uses AI to answer legal questions, lands cash from OpenAI',
            url: 'https://techcrunch.com/2022/11/23/harvey-which-uses-ai-to-answer-legal-questions-lands-cash-from-openai/',
          },
          {
            title: 'Harvey AI: What We Know About the Company So Far',
            url: 'https://www.gavel.io/resources/harvey-ai-what-we-know-about-the-company-so-far',
          },
          {
            title:
              'Introducing Harvey AI: Revolutionizing the Legal Field with Artificial Intelligence',
            url: 'https://www.martindale-avvo.com/blog/harvey-ai-artificial-intelligence/',
          },
        ],
      },
      {
        text: "Winston Weinberg, formerly an associate at law firm O'Melveny & Myers, and Gabriel Pereyra, formerly a research scientist at DeepMind and a machine learning engineer at Meta AI.",
        confidence: 1,
        sources: [
          {
            title:
              'The Strange Case of the Two Legal AI Companies Named Harvey, and their Coincidental Connection to Winston',
            url: 'https://www.lawnext.com/2023/03/the-strange-case-of-the-two-legal-ai-companies-named-harvey-and-their-coincidental-connection-to-winston.html',
          },
          {
            title:
              'Harvey Eyes ‘All Sorts’ of Lawyers in AI Legal Hiring Spree (1)',
            url: 'https://news.bloomberglaw.com/business-and-practice/ai-startup-harvey-seeking-all-sorts-of-lawyers-in-hiring-spree',
          },
          {
            title:
              'Harvey, which uses AI to answer legal questions, lands cash from OpenAI',
            url: 'https://techcrunch.com/2022/11/23/harvey-which-uses-ai-to-answer-legal-questions-lands-cash-from-openai/',
          },
          {
            title:
              'Generative AI Legal and Professional Services Startup Harvey Raises $80M - Voicebot.ai',
            url: 'https://voicebot.ai/2023/12/21/generative-ai-legal-and-professional-services-startup-harvey-raises-80m/',
          },
        ],
      },
    ],
    [
      {
        text: 'Memora Health',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '2017',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '30',
        confidence: 1,
        sources: [
          {
            title: 'Top Startups — Funded by Sequoia, A16Z, YC',
            url: 'https://topstartups.io/?industries=Artificial%20Intelligence',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Memora Health provides an intelligent care enablement platform that leverages conversational AI and natural language processing (NLP) to automate patient outreach and engagement. Their platform uses AI to assess and answer patient questions, send reminders and treatment instructions, collect patient-reported outcomes, and triage patient concerns to the appropriate care team members. The AI agent product digitizes and automates complex clinical workflows, guiding patients through care episodes via automated text messaging.',
        confidence: 1,
        sources: [
          {
            title: 'Intro to Healthcare AI and NLP | Memora Health',
            url: 'https://www.memorahealth.com/news/intro-to-healthcare-ai-and-nlp-intelligently-improving-care-management',
          },
          {
            title:
              'Memora Health - Digital Health Products for Complex Populations - Center for Health Care Strategies',
            url: 'https://www.chcs.org/digital-health-products/memora-health/',
          },
          {
            title: 'Intro to Memora Health | Memora Health',
            url: 'https://www.memorahealth.com/news/intro-to-using-memora-health-platform-for-better-care-management-and-patient-navigation',
          },
          {
            title: 'Memora Health Mission, Values, Culture & Jobs',
            url: 'https://www.tealhq.com/company/memora-health',
          },
        ],
      },
      {
        text: 'Manav Sevak and Kunaal Naik - Co-Founders of Memora Health',
        confidence: 1,
        sources: [
          {
            title: 'About Us | Memora Health',
            url: 'https://www.memorahealth.com/about-us',
          },
          {
            title: 'Memora Health',
            url: 'https://www.forbes.com/profile/memora-health/',
          },
        ],
      },
    ],
    [
      {
        text: 'DeepL',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2009',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '$100M',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '$1.085 billion',
        confidence: 1,
        sources: [
          {
            title:
              'Germany’s Translation Tech Firm DeepL Becomes Latest AI Unicorn',
            url: 'https://www.pymnts.com/news/investment-tracker/2023/germanys-translation-tech-firm-deepl-becomes-latest-ai-unicorn/',
          },
        ],
      },
      {
        text: "DeepL is a neural machine translation platform that uses advanced algorithms to translate text from one language to another with exceptional accuracy and fluency. With support for over 30 languages, DeepL's technology combines neural network models, deep learning techniques, and natural language processing (NLP) to provide high-quality translations for a wide range of content types, including websites, documents, and emails.",
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Jaroslaw Kutylowski',
        confidence: 1,
        sources: [
          {
            title: '',
            url: 'https://www.deepl.com/files/press/companyProfile_EN.pdf',
          },
          {
            title: 'DeepL Translator',
            url: 'https://en.wikipedia.org/wiki/DeepL_Translator',
          },
        ],
      },
    ],
    [
      {
        text: 'Frame AI',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2016',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '17.9',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '$7.6M',
        confidence: 1,
        sources: [
          {
            title:
              'Frame.ai Company Profile: Valuation, Funding & Investors | PitchBook',
            url: 'https://pitchbook.com/profiles/company/168052-87',
          },
        ],
      },
      {
        text: 'Frame is building one of the leading customer success platforms by providing leading artificial intelligence software around a robust solutions framework aimed at solving numerous customer challenges. By building "The Voice of the Customer engine", teams can use Frame to detect themes among customers, identify patterns for retention or acquisition of customers, and turn qualitative feedback into quantitative data for leadership.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'George Davis, Robbie Mitchell, Jesse St. Charles, and Brandon Reiss',
        confidence: 1,
        sources: [
          {
            title:
              'Twilio Ventures Founder Spotlight: George Davis, Robbie Mitchell, Jesse St. Charles, and Brandon Reiss, Frame AI',
            url: 'https://www.twilio.com/en-us/blog/twilio-ventures-founder-spotlight-george-robbie-jesse-brandon-frame-ai',
          },
          {
            title:
              'Frame.ai Company Profile: Valuation, Funding & Investors | PitchBook',
            url: 'https://pitchbook.com/profiles/company/168052-87',
          },
        ],
      },
    ],
    [
      {
        text: 'Uizard',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2018',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '$18.6M (Series A)',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "Uizard is an AI-powered platform that helps users create professional-looking designs for websites and mobile apps with minimal coding or design experience. Uizard's proprietary technology uses machine learning algorithms to translate sketches and wireframes into functional code and designs, reducing the time and effort required to create a prototype.",
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Tony Beltramelli, Florian van Schreven, Henrik Haugbølle, Ioannis Sintos',
        confidence: 1,
        sources: [
          {
            title: 'Uizard - Startup Company Profile | TRUiC',
            url: 'https://startupsavant.com/startup-center/uizard',
          },
          {
            title: '42 Top AI Startups to Watch in 2024 | TRUiC',
            url: 'https://startupsavant.com/startups-to-watch/ai',
          },
          {
            title:
              'Uizard Company Profile: Valuation, Funding & Investors | PitchBook',
            url: 'https://pitchbook.com/profiles/company/181491-67',
          },
        ],
      },
    ],
    [
      {
        text: 'Moveworks',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2016',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '305M',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2100',
        confidence: 1,
        sources: [
          {
            title: 'About Us | Moveworks',
            url: 'https://www.moveworks.com/us/en/company/about',
          },
          {
            title:
              'Workplace Chatbot Firm Moveworks Reaches $2.1 Billion Valuation',
            url: 'https://www.bloomberg.com/news/articles/2021-06-30/workplace-chatbot-firm-moveworks-reaches-2-1-billion-valuation/undefined',
          },
          {
            title:
              'AI-powered automatic IT support startup Moveworks raises $200M at $2.1B valuation',
            url: 'https://www.moveworks.com/us/en/company/news/media-coverage/ai-powered-automatic-it-support-startup-moveworks-raises--200m-a',
          },
          {
            title: 'How Moveworks raised $200 million in Series C funding',
            url: 'https://www.moveworks.com/us/en/resources/blog/moveworks-raises-200-million-in-series-c-funding',
          },
        ],
      },
      {
        text: "Moveworks is an AI platform that helps employers create a better workplace. By using natural language understanding (NLU), conversational AI and probabilistic machine learning, the platform is able to support employees' issues end-to-end. Examples of AI in action include troubleshooting common questions, such as getting access to software and routing document approvals to the correct person.",
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Bhavin Shah (CEO and co-founder), Vaibhav Nivargi (CTO and co-founder), Varun Singh (President and co-founder), Jiang Chen (CTO of AI and co-founder)',
        confidence: 1,
        sources: [
          {
            title: 'About Us | Moveworks',
            url: 'https://www.moveworks.com/us/en/company/about',
          },
          {
            title:
              'Varun Singh on LinkedIn: As founders, Bhavin, Jiang, Vaibhav, and I are zealots about embracing the…',
            url: 'https://www.linkedin.com/posts/vsingh3_as-founders-bhavin-jiang-vaibhav-and-activity-6904838404677222400-dtmh',
          },
          {
            title: 'Moveworks',
            url: 'https://en.wikipedia.org/wiki/Moveworks',
          },
        ],
      },
    ],
    [
      {
        text: 'Tome',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2020',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '75.3',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: "Tome's current valuation is $600 million according to reports that the company is seeking that valuation in a new funding round just five months after securing a $43 million investment at a $300 million valuation.",
        confidence: 1,
        sources: [
          {
            title:
              'Tome is Pitching a $600M Valuation on $2M ARR for Generative AI Presentation Software - But Is it Any Good?',
            url: 'https://synthedia.substack.com/p/tome-is-pitching-a-600m-valuation',
          },
        ],
      },
      {
        text: "Meta AI is a new assistant you can interact with like a person, available on WhatsApp, Messenger, Instagram, and coming soon to Ray-Ban Meta smart glasses and Quest 3. It's powered by a custom model that leverages technology from Llama 2 and Meta's latest large language model (LLM) research. In text-based chats, Meta AI has access to real-time information through a search partnership with Bing and offers a tool for image generation.",
        confidence: 1,
        sources: [
          {
            title:
              'Introducing New AI Experiences Across Our Family of Apps and Devices',
            url: 'https://about.fb.com/news/2023/09/introducing-ai-powered-assistants-characters-and-creative-tools/',
          },
        ],
      },
      {
        text: 'Keith Peiris and Henri Liriani',
        confidence: 1,
        sources: [
          {
            title: 'AI Storytelling Platform Tome Raises $43M',
            url: 'https://www.builtinsf.com/2022/02/22/tome-raises-43m-generative-ai',
          },
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
          {
            title:
              'Buzzy Storytelling Startup Tome Raises $43 Million From A Who’s Who In AI',
            url: 'https://www.forbes.com/sites/alexkonrad/2023/02/22/storytelling-ai-startup-tome-raises-43-million/',
          },
        ],
      },
    ],
    [
      {
        text: 'Synthesia',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2017',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '156.6',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '1000',
        confidence: 1,
        sources: [
          {
            title:
              'Nvidia-backed platform that turns text into A.I.-generated avatars boosts valuation to $1 billion',
            url: 'https://www.cnbc.com/2023/06/13/ai-firm-synthesia-hits-1-billion-valuation-in-nvidia-backed-series-c.html',
          },
          {
            title:
              'AI-Generated Video Platform Synthesia Receives Nvidia Backing At Unicorn Valuation',
            url: 'https://news.crunchbase.com/ai-robotics/synthesia-artificial-intelligence-nvidia-unicorn/',
          },
          {
            title: 'Meet The New AI Unicorns Of 2023',
            url: 'https://news.crunchbase.com/ai/new-ai-unicorns-2023-list-llm-platforms-cohere/',
          },
          {
            title:
              'TUM Spin-off Synthesia Attains Unicorn Status, Now Valued At Over $1 billion, Making Video Creation Effortless with AI',
            url: 'https://news.europawire.eu/tum-spin-off-synthesia-attains-unicorn-status-now-valued-at-over-1-billion-making-video-creation-effortless-with-ai/eu-press-release/2023/07/12/22/15/59/118851/',
          },
          {
            title:
              'Synthesia secures $90M for AI that generates custom avatars',
            url: 'https://techcrunch.com/2023/06/14/synthesia-secures-90m-for-ai-that-generates-custom-avatars/',
          },
        ],
      },
      {
        text: 'Synthesia is an AI-powered platform that enables businesses to create and personalize video content at scale. The platform can generate realistic and engaging videos with human-like avatars, making it ideal for a variety of applications, from e-learning and marketing to news reporting and virtual events.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Victor Riparbelli\nSteffen Tjerrild\nProf. Matt Niessner\nProf. Lourdes Agapito',
        confidence: 1,
        sources: [
          {
            title: 'About Synthesia | Read our story here',
            url: 'https://www.synthesia.io/about',
          },
          {
            title: 'Synthesia (company)',
            url: 'https://en.wikipedia.org/wiki/Synthesia_(company)',
          },
          {
            title:
              'Synthesia Company Profile: Valuation, Funding & Investors | PitchBook',
            url: 'https://pitchbook.com/profiles/company/267090-49',
          },
        ],
      },
    ],
    [
      {
        text: 'Jasper',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2021',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '131',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: "Jasper's current internal valuation is approximately $1.2 billion, after cutting its valuation by 20% amid slowing growth.",
        confidence: 1,
        sources: [
          {
            title:
              'Jasper Appoints New CEO and Cuts Internal Valuation as AI Growth Slows',
            url: 'https://www.maginative.com/article/jasper-cuts-internal-valuation-as-ai-growth-slows/',
          },
        ],
      },
      {
        text: 'Jasper is an AI-powered platform that has slowly evolved from an AI writing tool to a "copilot for enterprise marketing teams". Specifically, Jasper is now positioned as a collaboration platform that marketer teams can use to develop campaigns, create content and collaborate on projects.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Dave Rogenmoser, JP Morgan, Chris Hull',
        confidence: 1,
        sources: [
          {
            title:
              'Jasper.ai: Jasper is a leader in creating content using Artificial Intelligence | Y Combinator',
            url: 'https://www.ycombinator.com/companies/jasper-ai',
          },
        ],
      },
    ],
    [
      {
        text: 'Accubits',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2012',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '$200 million',
        confidence: 1,
        sources: [
          {
            title:
              'Why AI Startup Accubits Left ICOs Behind To Focus On Automation, Self-Driving Cars',
            url: 'https://inc42.com/features/accubits-journey-from-icos-to-working-on-ai-autonomous-cars/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "Agent is your go-to AI platform for harnessing the power of personalized AI agents. Whether you're a professional, student, or enthusiast, this all-in-one platform empowers you to effortlessly train and utilize AI agents tailored to your specific needs. With a user-friendly interface and no prior AI knowledge required, Agent makes AI accessible to everyone. Key Features and Capabilities: Wide Industry Coverage: Agent caters to diverse industries, including internet marketing, e-commerce, legal, education, real estate, relationships, engineering, entertainment, entrepreneurship, and more. Personalized AI Agents: Access a variety of AI agents with distinct personalities, styles, and specializations, tailored to meet your specific needs. Unlimited Knowledge: Ask your AI agents anything and gain infinite knowledge, making it your virtual companion for learning and personal growth. Versatile Assistance: Use AI agents for content writing, code debugging, replicating human behavior, and more, enhancing your productivity and efficiency. Secure Conversations: Share conversations securely with others via unique links and enjoy advanced encryption for data privacy. Future-Ready: Stay ahead with upcoming features like an AI app store, voice calls, ChatGPT plugins, and teamspaces.",
        confidence: 1,
        sources: [
          {
            title: 'Accubits  AI - Read Review, Details, Pricing, & Features',
            url: 'https://openfuture.ai/tool/accubits',
          },
        ],
      },
      {
        text: 'Jithin V G is the founder and CEO of Accubits Technologies Inc. Michael Gord is the managing director of Accubits Technologies Canada.',
        confidence: 1,
        sources: [
          {
            title:
              'Accubits’ CEO Featured on Entrepreneur Magazine’s ‘35 under 35’ List.',
            url: 'https://accubits.com/news/accubits-ceo-featured-on-entrepreneur-magazines-35-under-35-list/',
          },
          {
            title:
              'Accubits Technologies and Global Digital Assets Form Joint Venture to Expand in North America',
            url: 'https://accubits.com/news/global-digital-assets-and-accubits-technologies-form-joint-venture-to-expand-in-north-america/',
          },
          {
            title:
              'Accubits Technologies and Global Digital Assets Form Joint Venture to Expand in North America',
            url: 'https://accubits.com/news/global-digital-assets-and-accubits-technologies-form-joint-venture-to-expand-in-north-america/',
          },
        ],
      },
    ],
    [
      {
        text: 'Soundful',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2019',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '4.5M',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "Soundful is an AI-powered platform that enables businesses to create and customize high-quality soundtracks for their digital content, such as videos, podcasts, and advertisements. Soundful's technology uses deep learning algorithms to analyze the emotions, tone, and context of the content and generate soundtracks that complement and enhance the viewer's experience.",
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Diaa El All - Founder and CEO of Soundful',
        confidence: 1,
        sources: [
          {
            title:
              'Soundful founder and CEO Diaa El All: ‘There is a way to create disruptive technological advances in AI',
            url: 'https://www.musicbusinessworldwide.com/soundful-founder-and-ceo-there-is-a-way-to-create-disruptive-technological-advances-in-ai-while-keeping-the-integrity-of-artists-rights-at-the-forefront12/',
          },
        ],
      },
    ],
    [
      {
        text: 'GoodVision',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2017',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '$4M',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'GoodVision plays in the traffic analytics space, using AI to break down data from traffic cameras and drones. This gives logistics officials the ability to understand traffic patterns in real time with comprehensive analytics and suggestions. Their Video Insights platform is their bread and butter, with claims that it saves traffic professionals 95% of their time by automating tedious processes and freeing up time for focusing on traffic solutions.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Daniel Stofan, Lukas Hruby',
        confidence: 1,
        sources: [
          {
            title: '42 Top AI Startups to Watch in 2024 | TRUiC',
            url: 'https://startupsavant.com/startups-to-watch/ai',
          },
          {
            title:
              'GoodVision raises 2.7 mil EUR to make traffic flow and cities breath again',
            url: 'https://blog.goodvisionlive.com/goodvision-ltd-raises-2.7-million-eur-to-make-traffic-flow-and-cities-breath-again',
          },
        ],
      },
    ],
    [
      {
        text: 'Writesonic',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2021',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2.6M',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "Writesonic is enables users to generate content (such as blog posts, ad copy, and product descriptions) in a fraction of the time it would take to do so manually. Using natural language processing (NLP) and machine learning (ML) algorithms, Writesonic's technology can analyze a user's prompts and generate human-like text that matches the desired tone, style, and structure. The platform also allows users to fine-tune and edit the generated text to meet their specific needs, while also providing suggestions for improvements.",
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Samanyou Garg',
        confidence: 1,
        sources: [
          {
            title:
              'Samanyou Garg - The Writesonic Blog - Making Content Your Superpower',
            url: 'https://writesonic.com/blog/author/samanyou-garg/',
          },
          {
            title: 'Writesonic',
            url: 'https://en.wikipedia.org/wiki/Writesonic',
          },
          {
            title: '25 Top Generative AI Startups to Watch in 2024 | TRUiC',
            url: 'https://startupsavant.com/startups-to-watch/generative-ai',
          },
        ],
      },
    ],
    [
      {
        text: 'Atomic AI',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2020',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '42M',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Atomic AI has raised over $42 million in funding, and has a valuation of between $140 to $210 million.',
        confidence: 1,
        sources: [
          {
            title: 'Buy Atomic AI stock and other Pre-IPO shares on UpMarket',
            url: 'https://www.upmarket.co/private-markets/pre-ipo/atomic-ai/',
          },
        ],
      },
      {
        text: 'Atomic AI operates a content intelligence platform that leverages AI to facilitate the efficient development of new molecules and medicines. Through its proprietary platform, the company collects and analyzes engagement data from client analytics platforms, generating predictive reports on topics, publishing times, and distribution channels.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Raphael Townshend',
        confidence: 1,
        sources: [
          {
            title:
              'With new funding, Atomic AI envisions RNA as the next frontier in drug discovery',
            url: 'https://techcrunch.com/2023/01/25/with-new-funding-atomic-ai-envisions-rna-as-the-next-frontier-in-drug-discovery/',
          },
          {
            title: '42 Top AI Startups to Watch in 2024 | TRUiC',
            url: 'https://startupsavant.com/startups-to-watch/ai',
          },
        ],
      },
    ],
    [
      {
        text: 'MindsDB',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2017',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '54.4',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '160',
        confidence: 0.8,
        sources: [
          {
            title: 'How MindsDB became a hot AI startup worth $160 million',
            url: 'https://www.businessinsider.com/how-mindsdb-became-hot-ai-startup-2023-6',
          },
          {
            title: 'MindsDB',
            url: 'https://en.wikipedia.org/wiki/MindsDB',
          },
        ],
      },
      {
        text: 'MindsDB is an open-source, automated machine learning (AutoML) platform that helps businesses of all sizes to develop and deploy predictive models with ease. MindsDB empowers users to easily train and auto deploy ML models, even without prior coding experience.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Jorge Torres (CEO) and Adam Carrigan (COO)',
        confidence: 1,
        sources: [
          {
            title: 'TheQuickPitch Episode 9 - Founders Of MindsDB',
            url: 'https://mindsdb.com/newsroom/thequickpitch-episode-9-founders-of-mindsdb',
          },
          {
            title:
              'MindsDB Announces San Francisco AI Collective: A Network for Open-source Machine Learning and AI Projects',
            url: 'https://mindsdb.com/newsroom/mindsdb-announces-san-francisco-ai-collective-a-network-for-open-source-machine-learning-and-ai-projects',
          },
          {
            title:
              'MindsDB Raises $25 Million led by Mayfield to Supercharge Developers with its Cloud for Serving Artificial Intelligence Logic',
            url: 'https://mindsdb.com/newsroom/mindsdb-raises-25-million-led-by-mayfield-to-supercharge-developers-with-its-cloud-for-serving-artificial-intelligence-logic',
          },
          {
            title: 'Join Our Mission To Democratize Machine Learning',
            url: 'https://mindsdb.com/about',
          },
          {
            title: 'MariaDB and MindsDB Raise the IQ for Cloud Databases',
            url: 'https://mindsdb.com/newsroom/mariadb-and-mindsdb-raise-the-iq-for-cloud-databases',
          },
          {
            title:
              'AI in 2024: Art Thrives, Open-Source Battles GPT - MindsDB - Medium',
            url: 'https://medium.com/mindsdb/ai-in-2024-art-thrives-open-source-battles-gpt-115d54ed0f28',
          },
          {
            title:
              'MindsDB Announces San Francisco AI Collective: A Network for Open-source Machine Learning and AI Projects',
            url: 'https://www.prnewswire.com/news-releases/mindsdb-announces-san-francisco-ai-collective-a-network-for-open-source-machine-learning-and-ai-projects-301939057.html',
          },
        ],
      },
    ],
    [
      {
        text: 'Shield AI',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2015',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '773.1',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2800',
        confidence: 1,
        sources: [
          {
            title:
              "Shield AI\\'s Series F expands, raising $300M, hitting $2.8B valuation",
            url: 'https://www.opengrowth.com/resources/shield-ai-s-series-f-expands-raising-m-hitting-b-valuation',
          },
          {
            title:
              'Shield AI expands massive Series F with another $300M in equity, debt, scaling valuation to $2.8B',
            url: 'https://www.linkedin.com/pulse/shield-ai-expands-massive-series-f-another-300m-equity-g2igc?trk=article-ssr-frontend-pulse_more-articles_related-content-card',
          },
        ],
      },
      {
        text: "[Shield AI's products include autonomous drones](https://shield.ai/about-us/), which are used for reconnaissance, surveillance, and other mission-critical tasks, and an AI-powered command and control software platform, which enables operators to control and manage multiple unmanned systems simultaneously.",
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Brandon Tseng, Ryan Tseng, and Andrew Reiter',
        confidence: 1,
        sources: [
          {
            title: 'Shield AI',
            url: 'https://en.wikipedia.org/wiki/Shield_AI',
          },
          {
            title:
              "Shield AI's Founders: Talk Scaling Tech Startup in San Diego, Valued at $2.7 Billion",
            url: 'https://businessofsandiego.substack.com/p/shield-ais-founders-talk-scaling',
          },
          {
            title: 'Shield AI Co-Founders Honored by WIRED',
            url: 'https://www.prnewswire.com/news-releases/shield-ai-co-founders-honored-by-wired-301127908.html',
          },
        ],
      },
    ],
    [
      {
        text: 'Eightfold',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2016',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '396.8',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2100',
        confidence: 1,
        sources: [
          {
            title:
              'AI startup Eightfold valued at $2.1B in SoftBank-led $220M funding',
            url: 'https://techcrunch.com/2021/06/10/ai-startup-eightfold-valued-at-2-1b-in-softbank-led-220m-funding/',
          },
        ],
      },
      {
        text: 'Eightfold is using AI to power a suite of HR-related products aimed at retaining, training, and finding the best talent in the marketplace.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Ashutosh Garg and Varun Kacholia',
        confidence: 1,
        sources: [
          {
            title: 'Eightfold AI Inc.  Asset Profile | Preqin',
            url: 'https://www.preqin.com/data/profile/asset/eightfold-ai-inc-/273495',
          },
          {
            title:
              'Eightfold founder Ashutosh Garg on how to achieve “pitch-market fit”',
            url: 'https://www.zendesk.com/blog/eightfold-ashutosh-garg/',
          },
        ],
      },
    ],
    [
      {
        text: 'Netra',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2013',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '3.9M',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '1000',
        confidence: 1,
        sources: [
          {
            title:
              "Ex-Google employees' A.I. chatbot startup valued at $1 billion after Andreessen Horowitz funding",
            url: 'https://www.cnbc.com/2023/03/23/characterai-valued-at-1-billion-after-150-million-round-from-a16z.html',
          },
        ],
      },
      {
        text: 'Netra is a comprehensive video analysis platform using the power of artificial intelligence to make on-the-fly recommendations or collect video data. Offering tools like safety analysis, metadata analysis, and object detection, users can quickly and easily break down video content or analyze live streams in real-time.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Amit Phansalkar and Shashi Kant are mentioned as co-founders of Netra, an AI startup focused on video analysis.',
        confidence: 1,
        sources: [
          {
            title: 'Improving the way videos are organized',
            url: 'https://news.mit.edu/2021/netra-video-ai-0520',
          },
          {
            title:
              'Shreyas Waghmare on LinkedIn: AI Entrepreneurs - Amit Phansalkar - Netra Inc',
            url: 'https://www.linkedin.com/posts/ssw1983_ai-entrepreneurs-amit-phansalkar-netra-activity-7140931703090429952-CYD2',
          },
        ],
      },
    ],
    [
      {
        text: 'Deepgram',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2015',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '85.9',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: "Deepgram is an AI-powered speech recognition platform that helps businesses transcribe and analyze large volumes of audio and video content with high accuracy and speed. Using advanced neural network models, Deepgram's technology can transcribe and understand speech in multiple languages and dialects, even in noisy and low-quality audio environments.",
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Scott Stephenson and Noah Shutty',
        confidence: 1,
        sources: [
          {
            title: 'Scott Stephenson | Deepgram',
            url: 'https://deepgram.com/authors/scott-stephenson',
          },
          {
            title: 'AiThority Interview With Scott Stephenson, CEO at Deepgram',
            url: 'https://aithority.com/machine-learning/neural-networks/deep-learning/aithority-interview-with-scott-stephenson-at-deepgram/',
          },
          {
            title:
              'Deepgram Raises $47M to Enhance Its AI Speech Recognition Tech',
            url: 'https://www.builtinsf.com/2022/11/29/deepgram-raises-47m-hiring',
          },
        ],
      },
    ],
    [
      {
        text: 'Arthur AI',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2017',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '60.3',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: "The sources do not mention Arthur AI's valuation. However, based on the $42 million Series B funding round mentioned, a reasonable guess for Arthur AI's current valuation could be in the range of $100-300 million.",
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Arthur AI has built a suite of products to protect LLMs, including Arthur Shield. This is the first-ever firewall for large language models. It validates user prompts and model responses and provides real-time protection against any harmful or elicit prompts and outputs.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Adam Wenchel - CEO, John Dickerson - Chief Scientist',
        confidence: 1,
        sources: [
          {
            title: 'Team',
            url: 'https://www.arthur.ai/team',
          },
          {
            title: 'Deploy AI with Confidence: The Story of Arthur AI',
            url: 'https://www.toolify.ai/ai-news/deploy-ai-with-confidence-the-story-of-arthur-ai-8662',
          },
          {
            title:
              'We’ve Just Raised Our Series A, and the Journey is Just Beginning',
            url: 'https://www.arthur.ai/blog/announcing-series-a',
          },
        ],
      },
    ],
    [
      {
        text: 'Capacity',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2017',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '61.5',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '$1000',
        confidence: 1,
        sources: [
          {
            title:
              'AI Lab Imbue Gets $200M From Nvidia, Others; Hits $1B Valuation',
            url: 'https://news.crunchbase.com/ai-robotics/new-ai-unicorn-imbue-astera-nvidia/',
          },
          {
            title: 'AI startup Imbue tops $1 billion valuation',
            url: 'https://www.wionews.com/business-economy/ai-startup-imbue-tops-1-billion-valuation-633583',
          },
        ],
      },
      {
        text: 'Capacity has built the first fully AI-powered Helpdesk, which continuously learns from interactions between employees and customers while automating processes and decisions in real time.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
    ],
    [
      {
        text: 'Read AI',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2020',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '10M',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: "The sources do not provide a clear valuation for an AI startup called 'Read AI'. Based on the valuations mentioned for other AI companies like Anthropic ($4 billion), Inflection AI ($4 billion), Mistral AI ($2 billion), Imbue ($1 billion), OpenAI ($80 billion), and Moonshot AI ($2.5 billion), a reasonable guess for the valuation of Read AI could be in the range of $1-5 billion if it is a prominent AI startup working on large language models or generative AI.",
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Read AI is a digital tool that measures the engagement of online meeting attendees with AI, NLP, and computer vision technology. It functions as a real-time dashboard with detailed insights like attendee engagement scores, talk-time of each participant, and live sentiment analysis. The suite of tools continues to grow and now integrates an AI-powered smart scheduler, meeting reports, and an AI project manager.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Based out of Seattle, WA, Read was founded in 2021 by David Shim, Robert Williams, Elliott Waldron and backed by Madrona Venture Group.',
        confidence: 1,
        sources: [
          {
            title: 'About Us, Building The Future of Work with AI | Read',
            url: 'https://www.read.ai/about',
          },
        ],
      },
    ],
    [
      {
        text: 'Dataiku',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2013',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '846.8',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '3700',
        confidence: 1,
        sources: [
          {
            title: 'Dataiku bags $200m Series F funding at $3.7bn valuation',
            url: 'https://www.fintechfutures.com/2022/12/dataiku-bags-200m-series-f-funding-at-3-7bn-valuation/',
          },
        ],
      },
      {
        text: "[Dataiku](https://www.dataiku.com/) is a large-scale, enterprise AI platform that allows data analysts or tech-savvy developers to develop their own AI solutions and applications that uniquely suit their business. Instead of a one size fits all approach, Dataiku provides a workbench for customized AI solutions. With training, toolboxes, and sandboxes built into their platform, [Dataiku is one of Gartner's leaders in the data science and machine learning](https://pages.dataiku.com/gartner-2021) space.",
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Florian Douetteau, Clément Stenac, Thomas Cabrol, and Marc Batty',
        confidence: 1,
        sources: [
          {
            title: 'The Dataiku Story | Dataiku',
            url: 'https://www.dataiku.com/stories/detail/the-dataiku-story/',
          },
          {
            title: 'About Dataiku | Dataiku',
            url: 'https://www.dataiku.com/company/',
          },
          {
            title: 'Dataiku',
            url: 'https://en.wikipedia.org/wiki/Dataiku',
          },
          {
            title: "Dataiku: The World's Leading Platform for Everyday AI",
            url: 'https://growfers.com/story/dataiku/',
          },
          {
            title:
              'AI 50 2021: America’s Most Promising Artificial Intelligence Companies',
            url: 'https://www.forbes.com/sites/alanohnsman/2021/04/26/ai-50-americas-most-promising-artificial-intelligence-companies/',
          },
        ],
      },
    ],
    [
      {
        text: 'SupportLogic',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2016',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '62',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'SupportLogic is a customer service AI platform. With 30 different signal categories and thousands of keywords, the company has helped analyze over 60M customer interactions and provide actionable feedback.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Krishna Raj Raja, founder and CEO of SupportLogic',
        confidence: 1,
        sources: [
          {
            title: 'Leadership & Investors | SupportLogic',
            url: 'https://www.supportlogic.com/leadership-investors/',
          },
          {
            title:
              'SupportLogic Announces $50 Million Series B Funding from WestBridge Capital and General Catalyst',
            url: 'https://www.prnewswire.com/news-releases/supportlogic-announces-50-million-series-b-funding-from-westbridge-capital-and-general-catalyst-301397406.html',
          },
          {
            title:
              'About the SupportLogic Team, Culture, and Values | SupportLogic',
            url: 'https://www.supportlogic.com/about-supportlogic/',
          },
        ],
      },
    ],
    [
      {
        text: 'DNSFilter',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2015',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '62.1',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: "The sources do not provide a clear valuation figure for DNSFilter. Based on the $62.1 million in funding raised, including a $30 million Series A and $15 million Series A extension, a reasonable guess for DNSFilter's current valuation could be in the range of $200-500 million.",
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'DNSFilter is an AI-powered cybersecurity platform. Users are protected from phishing, ransomware and malware attacks using real-time AI analysis. According to the company, they identify 58% more threats than Cisco and 75% more threats identified by Webtitan.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
    ],
    [
      {
        text: 'Spot AI',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2018',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '62',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '62',
        confidence: 0.3,
        sources: [
          {
            title:
              'Spot AI raises $40M to build smarter CCTV security camera tech',
            url: 'https://techcrunch.com/2022/11/17/spot-ai-raises-40m-to-build-smarter-cctv-security-camera-tech/',
          },
        ],
      },
      {
        text: 'Spot AI is an AI-powered platform that helps businesses improve their customer engagement and sales through advanced analytics and insights. Their in-house developed technology analyzes consumer behavior and preferences using machine learning algorithms, delivering individualized recommendations and insights to boost the effectiveness of marketing campaigns.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Tanuj Thapliyal, Rish Gupta and Sud Bhatija',
        confidence: 1,
        sources: [
          {
            title:
              'AI Assistant Startups funded by Y Combinator (YC) 2024 | Y Combinator',
            url: 'https://www.ycombinator.com/companies/industry/ai-assistant',
          },
          {
            title: 'The 10 Hottest AI Startups Of 2023 (So Far) | CRN',
            url: 'https://www.crn.com/news/cloud/the-10-hottest-ai-startups-of-2023-so-far',
          },
          {
            title:
              'Spot AI emerges from stealth with $22M for a platform to draw out more intelligence from organizations’ basic security videos',
            url: 'https://techcrunch.com/2021/10/15/spot-ai-emerges-from-stealth-with-22m-with-a-platform-to-draw-out-more-intelligence-from-organizations-basic-security-videos/',
          },
        ],
      },
    ],
    [
      {
        text: 'Interactions',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2013',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '162.8',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: "OpenAI's current valuation is $80 billion, while Anthropic's current valuation is around $15 billion.",
        confidence: 0.8,
        sources: [],
      },
      {
        text: 'Interactions is a virtual assistant platform that helps enterprises improve customer experience and cut costs. The platform is used across all customer care channels, allowing for a consistent user experience. Used by many Fortune 500 companies, the startup handles more than 2B annual conversation transactions.',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Bret Taylor and Clay Bavor are the founders of the AI agent startup Sierra, according to document 1.',
        confidence: 1,
        sources: [
          {
            title:
              'Exclusive: Ex-Salesforce co-CEO Bret Taylor and longtime Googler Clay Bavor raised $110 million to bring AI ‘agents’ to business',
            url: 'https://fortune.com/2024/02/13/bret-taylor-clay-bavor-ai-startup-sierra-110-million-funding-sequoia-benchmark/',
          },
        ],
      },
    ],
    [
      {
        text: 'Character.ai',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2021',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '150',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '1000',
        confidence: 1,
        sources: [
          {
            title:
              'Chatbot Start-Up Character.AI Valued at $1 Billion in New Funding Round',
            url: 'https://www.nytimes.com/2023/03/23/technology/chatbot-characterai-chatgpt-valuation.html',
          },
          {
            title:
              "Ex-Google employees' A.I. chatbot startup valued at $1 billion after Andreessen Horowitz funding",
            url: 'https://www.cnbc.com/2023/03/23/characterai-valued-at-1-billion-after-150-million-round-from-a16z.html',
          },
          {
            title:
              'Silicon Valley Investclub on LinkedIn: Character.AI Raises $150 Million at $1 Billion Valuation\n \nCharacter.AI is…',
            url: 'https://www.linkedin.com/posts/investclubsv_characterai-raises-150-million-at-1-billion-activity-7044716363797454848-rTgX',
          },
          {
            title:
              'Character.AI Hits Unicorn Status With $150M Raise As AI Craze Continues',
            url: 'https://news.crunchbase.com/ai-robotics/character-ai-unicorn-venture-funding/',
          },
        ],
      },
      {
        text: "Character.ai is an AI-powered platform that enables users to create and animate 3D characters with ease. Character.ai allows users to customize their characters' appearance, movements, and behavior, and generate realistic animations in real-time.",
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: 'Daniel De Freitas and Noam Shazeer',
        confidence: 1,
        sources: [
          {
            title:
              'Chatbot Start-Up Character.AI Valued at $1 Billion in New Funding Round',
            url: 'https://www.nytimes.com/2023/03/23/technology/chatbot-characterai-chatgpt-valuation.html',
          },
          {
            title:
              'Here are the 12 generative AI unicorns to watch in addition to OpenAI',
            url: 'https://www.linkedin.com/pulse/here-12-generative-ai-unicorns-watch-addition-openai-tanya-dua',
          },
          {
            title: 'TIME100 AI 2023: Noam Shazeer',
            url: 'https://time.com/collection/time100-ai/6310599/noam-shazeer/',
          },
          {
            title: 'Character.ai',
            url: 'https://en.wikipedia.org/wiki/Character.ai',
          },
        ],
      },
    ],
    [
      {
        text: 'Circulo Health',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '2020',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '50',
        confidence: 1,
        sources: [
          {
            title: '60 Growing AI Companies & Startups In 2024',
            url: 'https://explodingtopics.com/blog/ai-startups',
          },
        ],
      },
      {
        text: '50',
        confidence: 1,
        sources: [
          {
            title: '57 Healthcare Companies & Startups to Watch (2024)',
            url: 'https://explodingtopics.com/blog/healthcare-startups',
          },
          {
            title:
              "With $50M, Circulo will tackle Medicaid insurance using Olive's AI tech",
            url: 'https://www.mobihealthnews.com/news/50m-circulo-will-tackle-medicaid-insurance-using-olives-ai-tech',
          },
        ],
      },
      {
        text: "Circulo Health is developing an AI-powered insurtech platform and system built on top of Olive's technology to automate administrative tasks for their Medicaid insurance business. However, there are no specific details provided about an 'AI agent product' they may be working on.",
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Juan Carlos Riveiro, Andreas Melder, Liya Sharif Lancia, Lucy Huang, Shannon Kelly',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'Anthropic',
        confidence: 1,
        sources: [
          {
            title: '7 Top AI Companies to Watch in 2024',
            url: 'https://aibusiness.com/nlp/7-top-ai-companies-to-watch-in-2024',
          },
        ],
      },
      {
        text: '2021',
        confidence: 1,
        sources: [
          {
            title:
              'The $1 billion gamble to ensure AI doesn’t destroy humanity',
            url: 'https://www.vox.com/future-perfect/23794855/anthropic-ai-openai-claude-2',
          },
          {
            title:
              'Google invested $300 million in AI firm founded by former OpenAI researchers',
            url: 'https://www.theverge.com/2023/2/3/23584540/google-anthropic-investment-300-million-openai-chatgpt-rival-claude',
          },
        ],
      },
      {
        text: '1000',
        confidence: 1,
        sources: [
          {
            title:
              'Inside the Funding Frenzy at Anthropic, One of A.I.’s Hottest Start-Ups',
            url: 'https://www.nytimes.com/2024/02/20/technology/anthropic-funding-ai.html',
          },
          {
            title:
              'AI Startup Anthropic Raising Another $300M At $4.1B Valuation — Report',
            url: 'https://news.crunchbase.com/ai-robotics/anthropic-raise-google/',
          },
          {
            title: 'Anthropic raises $450M to build next-gen AI assistants',
            url: 'https://techcrunch.com/2023/05/23/anthropic-raises-350m-to-build-next-gen-ai-assistants/',
          },
          {
            title:
              'Inside AI Unicorn Anthropic’s Unusual $750 Million Fundraise',
            url: 'https://www.forbes.com/sites/alexkonrad/2024/01/11/anthropic-750million-funding-round-menlo-ventures/',
          },
          {
            title:
              'AI Startup Anthropic Raises $450 Million for Safety-Focused Chatbot',
            url: 'https://www.bloomberg.com/news/articles/2023-05-23/ai-startup-anthropic-raises-450-million-for-safety-focused-chatbot',
          },
        ],
      },
      {
        text: '18400',
        confidence: 1,
        sources: [
          {
            title:
              'Anthropic Reportedly In Talks To Raise $750M At $18B-Plus Valuation',
            url: 'https://news.crunchbase.com/ai/unicorn-anthropic-funding-menlo-goog-amzn/',
          },
          {
            title:
              'Anthropic, an AI startup valued at USD 15 billion, is reportedly in talks to raise USD 750 million',
            url: 'https://enterprisetalk.com/quick-bytes/anthropic-an-ai-startup-valued-at-usd-15-billion-is-reportedly-in-talks-to-raise-usd-750-million/',
          },
          {
            title:
              'FTX estate selling majority stake in AI startup Anthropic for $884 million, with bulk going to UAE',
            url: 'https://www.nbcphiladelphia.com/news/national-international/ftx-estate-selling-majority-stake-in-ai-startup-anthropic-for-884-million-with-bulk-going-to-uae/3812581/',
          },
        ],
      },
      {
        text: "Anthropic's flagship product is Claude, an AI assistant focused on being helpful, harmless, and honest. Claude is a next-generation AI assistant based on Anthropic's research into training helpful, honest, and harmless AI systems. It is capable of a wide variety of conversational and text processing tasks while maintaining a high degree of reliability and predictability.",
        confidence: 1,
        sources: [
          {
            title: 'Introducing Claude',
            url: 'https://www.anthropic.com/news/introducing-claude',
          },
          {
            title:
              'Amazon and Anthropic Announce Strategic Collaboration to Advance Generative AI',
            url: 'https://press.aboutamazon.com/2023/9/amazon-and-anthropic-announce-strategic-collaboration-to-advance-generative-ai',
          },
        ],
      },
      {
        text: 'Dario Amodei and Daniela Amodei',
        confidence: 1,
        sources: [
          {
            title:
              '[Explained] Where Can I Invest Anthropic Stock? Who Are the Anthropic AI Investors?',
            url: 'http://anakin.ai/blog/anthropic-stock-who-owns-ahtropic-ai/',
          },
          {
            title: "Who Owns Anthropic? Breaking Down the AI Startup's [2023]",
            url: 'https://claudeai.uk/who-owns-anthropic-breaking-down-the-ai-startups/',
          },
        ],
      },
    ],
    [
      {
        text: 'AI21 Labs',
        confidence: 1,
        sources: [
          {
            title: '7 Top AI Companies to Watch in 2024',
            url: 'https://aibusiness.com/nlp/7-top-ai-companies-to-watch-in-2024',
          },
        ],
      },
      {
        text: '2017',
        confidence: 1,
        sources: [
          {
            title: 'AI21 Labs -  About',
            url: 'https://www.ai21.com/about',
          },
          {
            title:
              'Goldman Sachs Investment Banking on LinkedIn: On August 31, AI21 Labs announced a $155 million Series C funding…',
            url: 'https://www.linkedin.com/posts/goldman-sachs-investment-banking_on-august-31-ai21-labs-announced-a-155-activity-7107395307025350656-R9_l?trk=public_profile_like_view',
          },
          {
            title:
              'Generative AI startup AI21 Labs lands $155M at a $1.4B valuation',
            url: 'https://techcrunch.com/2023/08/30/generative-ai-startup-ai21-labs-lands-155m-at-a-1-4b-valuation/',
          },
          {
            title: '50 Generative AI Startups to Watch This Year',
            url: 'https://www.eweek.com/artificial-intelligence/generative-ai-startups/',
          },
        ],
      },
      {
        text: '336',
        confidence: 1,
        sources: [
          {
            title: 'AI21 Completes $208 Million Oversubscribed Series C Round',
            url: 'https://www.ai21.com/blog/ai21-completes-208-million-oversubscribed-series-c-round',
          },
          {
            title:
              'Israeli startup AI21 raises US$208 million in funding round, valued at US$1.4 billion',
            url: 'https://www.businesstimes.com.sg/startups-tech/startups/israeli-startup-ai21-raises-us208-million-funding-round-valued-us14-billion',
          },
        ],
      },
      {
        text: '1400',
        confidence: 1,
        sources: [
          {
            title:
              'Generative AI startup AI21 Labs lands $155M at a $1.4B valuation',
            url: 'https://techcrunch.com/2023/08/30/generative-ai-startup-ai21-labs-lands-155m-at-a-1-4b-valuation/',
          },
          {
            title:
              'AI21 Labs Announces Series C Funding Round at $1.4 Billion Valuation',
            url: 'https://www.ai21.com/blog/series-c-funding',
          },
          {
            title:
              'OpenAI Competitor AI21 Labs Raises $155M At A $1.4B Valuation From Investors Including Google, Nvidia',
            url: 'https://news.crunchbase.com/ai-robotics/ai21-funding-ai-startup-goog-nvda-openai-competitor/',
          },
          {
            title: 'AI21 Labs Secures $155M at $1.4 Billion Valuation',
            url: 'https://www.maginative.com/article/ai21-labs-secures-155m-at-1-4-billion-valuation/',
          },
          {
            title:
              'AI startup AI21 Labs valued at $1.4 billion after latest fund raise',
            url: 'https://www.aol.com/ai-startup-ai21-labs-valued-220819589.html',
          },
          {
            title:
              'Generative AI startup AI21 Labs raises cash in the midst of OpenAI chaos',
            url: 'https://techcrunch.com/2023/11/21/generative-ai-startup-ai21-labs-raises-cash-in-the-midst-of-openai-chaos/',
          },
          {
            title:
              'Funding in AI Startups Sept-1 Issue: ConverSight, Voxel, AI21, and Gesund',
            url: 'https://www.marktechpost.com/2023/08/31/funding-in-ai-startups-sept-1-issue-conversight-voxel-ai21-and-gesund/',
          },
        ],
      },
      {
        text: "AI21 Labs creates tools that focus heavily on contextual natural language processing for reading and writing. Third-party developers can build on AI21 Labs' language models for their own text-based apps and services with AI21 Studio. The startup's products include Wordtune, Wordtune Read, and AI21 Studio.",
        confidence: 1,
        sources: [
          {
            title: '50 Generative AI Startups to Watch This Year',
            url: 'https://www.eweek.com/artificial-intelligence/generative-ai-startups/',
          },
        ],
      },
      {
        text: 'Yoav Shoham, Ori Goshen, and Amnon Shashua',
        confidence: 1,
        sources: [
          {
            title: 'AI21 Labs -  About',
            url: 'https://www.ai21.com/about',
          },
          {
            title: 'AI21 Labs',
            url: 'https://en.wikipedia.org/wiki/AI21_Labs',
          },
          {
            title:
              'HU’s Amnon Shashua’s latest AI start-up focuses on understanding language and writing',
            url: 'https://www.cfhu.org/news/hus-amnon-shashuas-latest-ai-start-up-focuses-on-understanding-language-and-writing/',
          },
          {
            title:
              'HU’s Amnon Shashua’s latest AI start-up focuses on understanding language and writing',
            url: 'https://www.cfhu.org/news/hus-amnon-shashuas-latest-ai-start-up-focuses-on-understanding-language-and-writing/',
          },
          {
            title:
              'HU’s Amnon Shashua’s latest AI start-up focuses on understanding language and writing',
            url: 'https://www.cfhu.org/news/hus-amnon-shashuas-latest-ai-start-up-focuses-on-understanding-language-and-writing/',
          },
          {
            title: '50 Generative AI Startups to Watch This Year',
            url: 'https://www.eweek.com/artificial-intelligence/generative-ai-startups/',
          },
        ],
      },
    ],
    [
      {
        text: 'Hugging Face',
        confidence: 1,
        sources: [
          {
            title: '7 Top AI Companies to Watch in 2024',
            url: 'https://aibusiness.com/nlp/7-top-ai-companies-to-watch-in-2024',
          },
        ],
      },
      {
        text: '2016',
        confidence: 1,
        sources: [
          {
            title: 'Hugging Face is the new GitHub for LLMs',
            url: 'https://www.linkedin.com/pulse/hugging-face-new-github-llms-arvind-bhardwaj-ab-',
          },
          {
            title: 'Our Investment In Hugging Face - Brandon Reeves - Medium',
            url: 'https://brandon-reeves.medium.com/our-investment-in-hugging-face-c8497a3519eb',
          },
        ],
      },
      {
        text: '395',
        confidence: 1,
        sources: [
          {
            title:
              'AI Startup Hugging Face Valued at $4.5 Billion After Raising $235 Million',
            url: 'https://www.bloomberg.com/news/articles/2023-08-24/ai-startup-hugging-face-valued-at-4-5-billion-after-fundraising',
          },
          {
            title:
              'Hugging Face raises $235M from investors, including Salesforce and Nvidia',
            url: 'https://techcrunch.com/2023/08/24/hugging-face-raises-235m-from-investors-including-salesforce-and-nvidia/',
          },
        ],
      },
      {
        text: '4500',
        confidence: 1,
        sources: [
          {
            title:
              'Hugging Face raises $235M from investors, including Salesforce and Nvidia',
            url: 'https://techcrunch.com/2023/08/24/hugging-face-raises-235m-from-investors-including-salesforce-and-nvidia/',
          },
          {
            title: 'Tech Giants Invest $235 Million in AI Startup Hugging Face',
            url: 'https://www.pymnts.com/news/investment-tracker/2023/tech-giants-invest-235-million-dollars-artificial-intelligence-startup-hugging-face/',
          },
        ],
      },
      {
        text: "Hugging Face's new free product offering allows users of Hugging Chat, the startup's open source alternative to OpenAI's ChatGPT, to easily create their own customized AI chatbots with specific capabilities, similar both in functionality and intention to OpenAI's custom GPT Builder.",
        confidence: 1,
        sources: [
          {
            title:
              "Jay van Zyl on LinkedIn: Hugging Face launches open source AI assistant maker to rival OpenAI's…",
            url: 'https://www.linkedin.com/posts/jayvanzyl_hugging-face-launches-open-source-ai-assistant-activity-7159463098091778048-kgj7',
          },
        ],
      },
      {
        text: 'Clément Delangue (CEO), Julien Chaumond (CTO), Thomas Wolf (CSO)',
        confidence: 1,
        sources: [
          {
            title: 'Hugging Face',
            url: 'https://en.wikipedia.org/wiki/Hugging_Face',
          },
        ],
      },
    ],
    [
      {
        text: 'Aleph Alpha',
        confidence: 1,
        sources: [
          {
            title: '7 Top AI Companies to Watch in 2024',
            url: 'https://aibusiness.com/nlp/7-top-ai-companies-to-watch-in-2024',
          },
        ],
      },
      {
        text: '2019',
        confidence: 1,
        sources: [
          {
            title: 'Aleph Alpha',
            url: 'https://en.wikipedia.org/wiki/Aleph_Alpha',
          },
          {
            title:
              'Lidl owner and Bosch Ventures co-lead $500M Series B into German AI startup Aleph Alpha',
            url: 'https://techcrunch.com/2023/11/06/lidl-owner-and-bosch-ventures-co-lead-500m-series-b-into-german-ai-start-up-aleph-alpha/',
          },
          {
            title:
              'Aleph Alpha on LinkedIn: Meet Aleph Alpha, Europe’s Answer to OpenAI',
            url: 'https://www.linkedin.com/posts/aleph-alpha_meet-aleph-alpha-europes-answer-to-openai-activity-7103002963555536896-2Khn',
          },
          {
            title:
              'Products, Competitors, Financials, Employees, Headquarters Locations',
            url: 'https://www.cbinsights.com/company/alpha-ai',
          },
          {
            title: 'Top generative AI services start-ups',
            url: 'https://www.ventureradar.com/startup/generative%20AI%20services',
          },
        ],
      },
      {
        text: '500M$',
        confidence: 1,
        sources: [
          {
            title:
              'Aleph Alpha on LinkedIn: Aleph Alpha raises a total investment of more than half a billion US… | 172 comments',
            url: 'https://www.linkedin.com/posts/aleph-alpha_aleph-alpha-raises-a-total-investment-of-activity-7127275625408540672-OY4O?trk=public_profile_like_view',
          },
          {
            title:
              'Aleph Alpha raises follow-on investment of more than half a billion US Dollars',
            url: 'https://www.uvcpartners.com/blog/aleph-alpha-raises-follow-on-investment-of-more-than-half-a-billion-us-dollars',
          },
          {
            title:
              'Nico Kreiling on LinkedIn: Aleph Alpha raises a total investment of more than half a billion US…',
            url: 'https://www.linkedin.com/posts/nico-kreiling_aleph-alpha-raises-a-total-investment-of-activity-7127306447016599554-ZJ8F',
          },
          {
            title:
              'The Biggest Of The Big: AI Startups Raised Huge — These Were The Largest Deals Of 2023',
            url: 'https://news.crunchbase.com/ai/biggest-ai-startups-openai-msft-eoy-2023/',
          },
          {
            title:
              'German Giants Pour Over $500 Million Into AI Startup Aleph Alpha -  BNN Bloomberg',
            url: 'https://www.bnnbloomberg.ca/german-giants-pour-over-500-million-into-ai-startup-aleph-alpha-1.1994547',
          },
          {
            title:
              'German AI Firm Aleph Alpha Raises Over US$500 Million in Series B Funding',
            url: 'https://www.jumpstartmag.com/german-ai-firm-aleph-alpha-raises-over-us500-million-in-series-b-funding/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Aleph Alpha has raised almost $30 million from VCs. In addition to a very good pure speech interface, Aleph Alpha has the ability to process multimodal input.',
        confidence: 1,
        sources: [
          {
            title:
              'Transformers – Rise of the New Beasts: A 100% subjective test of the systems AI21, ALEPH ALPHA, MUSE versus GPT-3 – with amazing results. – HIVE : Big Picture Blog',
            url: 'https://blog.big-picture.com/en/transformers-rise-of-the-new-beats-a-100-subjective-test-of-the-systems-ai21-aleph-alpha-muse-versus-gpt-3-with-amazing-results/',
          },
        ],
      },
      {
        text: 'Jonas Andrulis, Samuel Weinbach',
        confidence: 1,
        sources: [
          {
            title: 'Aleph Alpha',
            url: 'https://en.wikipedia.org/wiki/Aleph_Alpha',
          },
          {
            title:
              'German startup Aleph Alpha raises $27M Series A round to build ‘Europe’s OpenAI’',
            url: 'https://techcrunch.com/2021/07/27/german-startup-aleph-alpha-raises-27m-series-a-round-to-build-europes-openai/',
          },
        ],
      },
    ],
    [
      {
        text: 'Scale AI',
        confidence: 1,
        sources: [
          {
            title: '7 Top AI Companies to Watch in 2024',
            url: 'https://aibusiness.com/nlp/7-top-ai-companies-to-watch-in-2024',
          },
        ],
      },
      {
        text: '2016',
        confidence: 1,
        sources: [
          {
            title:
              'How Alexandr Wang turned an army of clickworkers into an AI unicorn; the psychology behind blue checkmarks; and more',
            url: 'https://www.linkedin.com/pulse/how-alexandr-wang-turned-army-clickworkers-ai-unicorn',
          },
          {
            title:
              'Field Guide: From First Check to AI Unicorn, Why We Bet Early on Scale AI + Imbue - Paige Craig',
            url: 'https://outlander.vc/fieldguide/from-first-check-to-ai-unicorn-why-we-bet-early-on-scale-ai-and-imbue/',
          },
        ],
      },
      {
        text: '100',
        confidence: 1,
        sources: [
          {
            title:
              'Scale AI and its 22-year-old CEO lock down $100 million to label Silicon Valley’s data',
            url: 'https://techcrunch.com/2019/08/05/scale-ai-and-its-22-year-old-ceo-lock-down-100-million-to-help-label-silicon-valleys-data/',
          },
        ],
      },
      {
        text: '7300',
        confidence: 1,
        sources: [
          {
            title: 'Scale AI cuts 20% of its workforce',
            url: 'https://techcrunch.com/2023/01/10/scale-ai-cuts-20-of-its-workforce/',
          },
          {
            title: 'Is San Francisco the Best Place to Start an AI Company?',
            url: 'https://www.govtech.com/artificial-intelligence/is-san-francisco-the-best-place-to-start-an-ai-company',
          },
        ],
      },
      {
        text: 'Scale AI is developing an AI agent product that can help companies reimagine and transform their core business processes end-to-end using AI. The product likely involves using AI models and techniques to automate and optimize key business functions like customer service, supply chain, or operations. However, the sources do not provide specific details about the AI agent product itself.',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Alexandr Wang and Lucy Guo',
        confidence: 1,
        sources: [
          {
            title:
              'Field Guide: From First Check to AI Unicorn, Why We Bet Early on Scale AI + Imbue - Paige Craig',
            url: 'https://outlander.vc/fieldguide/from-first-check-to-ai-unicorn-why-we-bet-early-on-scale-ai-and-imbue/',
          },
          {
            title: 'Scale AI Business Model - FourWeekMBA',
            url: 'https://fourweekmba.com/scale-ai/',
          },
        ],
      },
    ],
    [
      {
        text: 'Tenstorrent',
        confidence: 1,
        sources: [
          {
            title: '7 Top AI Companies to Watch in 2024',
            url: 'https://aibusiness.com/nlp/7-top-ai-companies-to-watch-in-2024',
          },
        ],
      },
      {
        text: '2016',
        confidence: 1,
        sources: [
          {
            title:
              'AI chip startup Tenstorrent lands $100M investment from Hyundai and Samsung',
            url: 'https://techcrunch.com/2023/08/04/ai-chip-startup-tenstorrent-lands-100m-investment-from-hyundai-and-samsung/',
          },
          {
            title: 'Hyundai & Samsung Invest In AI Startup Tenstorrent - SN',
            url: 'https://www.socialnationnow.com/hyundai-motor-corp-and-samsung-invest-in-tenstorrent',
          },
          {
            title:
              'Justin Kinsey on LinkedIn: #ai #semiconductors #semiconductorindustry',
            url: 'https://www.linkedin.com/posts/justinkinseysbt_ai-semiconductors-semiconductorindustry-activity-7142895833137516545-RC88',
          },
        ],
      },
      {
        text: '334.5',
        confidence: 1,
        sources: [
          {
            title:
              'AI chip startup Tenstorrent lands $100M investment from Hyundai and Samsung',
            url: 'https://techcrunch.com/2023/08/04/ai-chip-startup-tenstorrent-lands-100m-investment-from-hyundai-and-samsung/',
          },
          {
            title:
              'Tenstorrent Raises a $100M Strategic Up-round Co-led by Hyundai Motor Group and the Samsung Catalyst Fund',
            url: 'https://tenstorrent.com/research/tenstorrent-raises-a-strategic-up-round/',
          },
          {
            title:
              'Samsung, Hyundai, Kia back AI chip manufacturer Tenstorrent in $100-million USD round',
            url: 'https://betakit.com/samsung-hyundai-kia-back-ai-chip-manufacturer-tenstorrent-in-100-million-usd-round/',
          },
          {
            title:
              'AI chip firm Tenstorrent raises $100 million from Hyundai, Samsung',
            url: 'https://malaysia.news.yahoo.com/ai-chip-firm-tenstorrent-raises-234211328.html',
          },
        ],
      },
      {
        text: '1000',
        confidence: 0.3,
        sources: [],
      },
      {
        text: "Tenstorrent is developing an AI accelerator chip called Grayskull, designed to accelerate AI model training in data centers, public and private clouds, on-premises servers and edge servers. It features Tenstorrent's proprietary Tensix cores. Tenstorrent is also co-developing a chiplet-based edge AI accelerator with LSTC that incorporates LSTC's AI chiplet along with Tenstorrent's RISC-V CPU and peripheral chiplet technology.",
        confidence: 1,
        sources: [
          {
            title:
              'AI chip startup Tenstorrent lands $100M investment from Hyundai and Samsung',
            url: 'https://techcrunch.com/2023/08/04/ai-chip-startup-tenstorrent-lands-100m-investment-from-hyundai-and-samsung/',
          },
          {
            title:
              'Tenstorrent RISC-V and Chiplet Technology Selected to Build the Future of AI in Japan',
            url: 'https://tenstorrent.com/research/tenstorrent-risc-v-and-chiplet-technology-selected-to-build-the-future-of-ai-in-japan/',
          },
          {
            title:
              'Tenstorrent RISC-V and Chiplet Technology Selected to Build the Future of AI in Japan',
            url: 'https://www.prnewswire.com/news-releases/tenstorrent-risc-v-and-chiplet-technology-selected-to-build-the-future-of-ai-in-japan-302071439.html',
          },
        ],
      },
      {
        text: 'Ljubisa Bajic, Drago Ignjatovic, and Lejla Bajic',
        confidence: 1,
        sources: [
          {
            title:
              'Tenstorrent Founder and Engineers Say Taalas AI Chip Outperforms a Small GPU Data Center',
            url: 'https://insidehpc.com/2024/03/tenstorrent-founder-and-engineers-say-their-taalas-ai-chip-outperforms-a-small-gpu-data-center/',
          },
          {
            title:
              'Tenstorrent founder reveals new AI chip startup Taalas with $50 million in funding | BetaKit',
            url: 'https://betakit.com/tenstorrent-founder-reveals-new-ai-chip-startup-taalas-with-50-million-in-funding/',
          },
        ],
      },
    ],
  ],
};

const laptopExample = {
  columns: [
    {
      name: 'Laptop',
      description: 'The model name of the laptop',
    },
    {
      name: 'Brand',
      description: 'The brand that manufactures the laptop',
    },
    {
      name: 'Price',
      description: 'The current starting price of the laptop',
    },
    {
      name: 'CPU',
      description: 'The processor in the laptop',
    },
    {
      name: 'RAM',
      description: 'The amount of RAM in GB in the base configuration',
    },
    {
      name: 'Storage',
      description: 'The amount of SSD storage in GB in the base configuration',
    },
    {
      name: 'Display',
      description: "The size and resolution of the laptop's display",
    },
    {
      name: 'Battery Life',
      description: 'The advertised battery life of the laptop',
    },
  ],
  table: [
    [
      {
        text: 'MacBook Air M2',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'Apple',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '$999',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'Apple M2',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '8 GB',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '256GB',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'The MacBook Air M2 has a 13.6-inch display with a 2560x1664 resolution.',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'The MacBook Air M2 powered through over 14 hours of battery life testing in our lab.',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
    ],
    [
      {
        text: 'Asus Zenbook 14 OLED',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'Asus',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '$1299.99',
        confidence: 1,
        sources: [
          {
            title: 'ASUS Launches All-New Zenbook 14 OLED (UX3405)',
            url: 'https://www.asus.com/us/news/1lub5syy5mkfxoj6/',
          },
        ],
      },
      {
        text: 'Intel Core i5-1240P',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '8GB',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '256GB',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '14-inch, 1800p',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'The Asus Zenbook 14 OLED is equipped with a 75Wh battery, providing a quoted 15 hours of battery life.',
        confidence: 1,
        sources: [
          {
            title:
              'ASUS Zenbook 14 OLED (UX3405) Review: Is This the MacBook of Windows?',
            url: 'https://www.makeuseof.com/asus-zenbook-14-oled-ux3405-review/',
          },
        ],
      },
    ],
    [
      {
        text: 'Dell XPS 15',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'Dell',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '$1,299',
        confidence: 1,
        sources: [
          {
            title: 'Dell XPS 15 (9530) (2023) Review',
            url: 'https://www.pcmag.com/reviews/dell-xps-15-9530-2023',
          },
        ],
      },
      {
        text: 'Intel Core i7-13700H',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '8 GB',
        confidence: 1,
        sources: [
          {
            title: 'XPS 15 7590 Setup and Specifications',
            url: 'https://www.dell.com/support/manuals/en-us/xps-15-7590-laptop/xps-15-7590-setup-and-specifications/memory?guid=guid-f07064b8-2eb4-49ec-88a8-43b102e42417&lang=en-us',
          },
        ],
      },
      {
        text: '256 GB',
        confidence: 1,
        sources: [
          {
            title: 'XPS 15 9520 Setup and Specifications',
            url: 'https://www.dell.com/support/manuals/en-us/xps-15-9520-laptop/xps-15-9520-setup-and-specifications/storage?guid=guid-d79f17ca-e619-43e7-82a5-a0b0e7fb5c0a&lang=en-us',
          },
          {
            title: 'XPS 15 9510 Setup and Specifications',
            url: 'https://www.dell.com/support/manuals/en-us/xps-15-9510-laptop/xps-15-9510-setup-and-specifications/storage?guid=guid-a00459e0-2a64-449c-9f02-581bf2e3c2cf&lang=en-us',
          },
          {
            title: 'XPS 15 7590 Setup and Specifications',
            url: 'https://www.dell.com/support/manuals/en-us/xps-15-7590-laptop/xps-15-7590-setup-and-specifications/storage?guid=guid-05db9429-1e46-40f5-b709-7c66b3324d4e&lang=en-us',
          },
          {
            title: 'Dell XPS 15 RAM and SSD Hard Drive DIY Upgrade',
            url: 'https://www.youtube.com/watch?v=8hT3D5NHwUw',
          },
          {
            title: 'XPS 15 7590 Setup and Specifications',
            url: 'https://www.dell.com/support/manuals/en-in/xps-15-7590-laptop/xps-15-7590-setup-and-specifications/storage?guid=guid-05db9429-1e46-40f5-b709-7c66b3324d4e&lang=en-us',
          },
        ],
      },
      {
        text: '15.6-inch, 2160',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'According to the sources, the advertised battery life for the Dell XPS 15 laptop is:\n\n- 9+ hours (source 0)\n- 10 hours (source 1)\n- 11 hours for web surfing at mid brightness setting (source 5)\n\nHowever, the actual battery life reported by users is often lower, ranging from around 2 hours (sources 0, 3) to 5-7 hours for web browsing (source 5).',
        confidence: 0.9,
        sources: [
          {
            title: 'Battery Life very small | DELL Technologies',
            url: 'https://www.dell.com/community/en/conversations/xps/battery-life-very-small/657c290a01c3da5c88f00e7c',
          },
          {
            title:
              'Dell XPS 15 OLED (2022) review: A great MacBook Pro alternative',
            url: 'https://www.tomsguide.com/reviews/dell-xps-15-oled-2022-review-a-great-macbook-pro-alternative',
          },
          {
            title: 'XPS 15 9530 Battery Life | DELL Technologies',
            url: 'https://www.dell.com/community/en/conversations/laptops-general-locked-topics/xps-15-9530-battery-life/647f3d2af4ccf8a8de461207',
          },
        ],
      },
    ],
    [
      {
        text: 'Acer Chromebook Spin 714',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'Acer',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '$499',
        confidence: 1,
        sources: [
          {
            title:
              'Acer Chromebook Spin 714 review: An outstanding choice for power users and pros',
            url: 'https://www.androidpolice.com/acer-chromebook-spin-714-review/',
          },
          {
            title:
              'Acer Chromebook Spin 714 Intel Evo Laptop 14" 16:10 WUXGA 1920 x 1200 Touch Intel Core i5-1335U 8GB RAM 256GB SSD Steel Gray CP714-2W-56B2 - Best Buy',
            url: 'https://www.bestbuy.com/site/acer-chromebook-spin-714-intel-evo-laptop-14-1610-wuxga-1920-x-1200-touch-intel-core-i5-1335u-8gb-ram-256gb-ssd-steel-gray/6541841.p?skuId=6541841',
          },
        ],
      },
      {
        text: 'Intel Core i5-1335U',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '8GB',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '256GB SSD',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '14-inch, 1600',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'The Acer Chromebook Spin 714 lasted 12 hours and 43 minutes in the battery test.',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
    ],
    [
      {
        text: 'Lenovo ThinkPad X1 Carbon',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
      {
        text: 'Lenovo',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
      {
        text: '$1,433.99',
        confidence: 1,
        sources: [
          {
            title:
              'ThinkPad X1 Carbon Gen 11 | 14 inch ultralight, super-powerful Intel® Evo™ laptop',
            url: 'https://www.lenovo.com/us/en/p/laptops/thinkpad/thinkpadx1/thinkpad-x1-carbon-gen-11-(14-inch-intel)/len101t0049',
          },
        ],
      },
      {
        text: 'Intel Core i7-1355U',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
      {
        text: '512GB',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
      {
        text: '14-inch, 1200',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
      {
        text: 'The Lenovo ThinkPad X1 Carbon lasted a whopping 13 hours and 45 minutes on our battery test.',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
    ],
    [
      {
        text: 'Acer Swift 14',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
      {
        text: 'Acer',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
      {
        text: '$1,499.99',
        confidence: 1,
        sources: [
          {
            title: 'Acer Swift X 14 review: Portable, muscular, and OLED charm',
            url: 'https://www.pcworld.com/article/2026099/acer-swift-x-14-review.html',
          },
        ],
      },
      {
        text: 'Intel Core i7-13700H',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
      {
        text: '1TB SSD',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
      {
        text: '14-inch, 2560 x 1600',
        confidence: 1,
        sources: [
          {
            title: 'Best laptop 2024: 10 best laptops tested and rated',
            url: 'https://www.laptopmag.com/reviews/best-laptops-1',
          },
        ],
      },
      {
        text: 'The advertised battery life of the Acer Swift 14 laptop is up to 9.5 hours.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'Acer Aspire 3 - Best budget laptop',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'Acer',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: '$329.99',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'The Acer Aspire 3 is available with the following CPUs:\n\n- AMD Ryzen 7 7320U (quad-core)\n- AMD Ryzen 5 7520U (quad-core)\n- AMD Ryzen 3 7320U (quad-core)\n- Intel Core i3-N305 (8 efficiency cores)\n\nThe AMD Ryzen 5 7520U and Ryzen 7 7320U are the best CPU options for this budget laptop, offering decent quad-core performance. However, the Ryzen CPUs are based on the older Zen 2 architecture rather than the newer Zen 3.',
        confidence: 1,
        sources: [
          {
            title:
              'Acer Aspire 3 review: A standout budget laptop for school and work',
            url: 'https://www.pcworld.com/article/1989517/acer-aspire-3-review.html',
          },
          {
            title: 'Acer Aspire 3 15 (2023) Review',
            url: 'https://www.rtings.com/laptop/reviews/acer/aspire-3-15-2023',
          },
          {
            title: 'Acer Aspire 3 (A315-24P) Review',
            url: 'https://www.pcmag.com/reviews/acer-aspire-3-a315-24p',
          },
          {
            title: 'Acer Aspire 3 (2023 AMD Ryzen) Review',
            url: 'https://www.youtube.com/watch?v=vHsWeDdutFk',
          },
        ],
      },
      {
        text: '4 GB',
        confidence: 1,
        sources: [
          {
            title:
              'acer aspire 3 A315-23 RAM upgrade want to add another 4gb to my laptop but no idea what to buy',
            url: 'https://community.acer.com/en/discussion/620327/acer-aspire-3-a315-23-ram-upgrade-want-to-add-another-4gb-to-my-laptop-but-no-idea-what-to-buy',
          },
        ],
      },
      {
        text: '256GB SSD',
        confidence: 1,
        sources: [
          {
            title: 'Acer Aspire 3 15 (2023) Review',
            url: 'https://www.rtings.com/laptop/reviews/acer/aspire-3-15-2023',
          },
          {
            title:
              'The Acer Aspire 3 Proves the Dangers of Buying a Budget Laptop | Digital Trends',
            url: 'https://www.digitaltrends.com/computing/acer-aspire-3-budget-laptop-bust/',
          },
        ],
      },
      {
        text: '1080p display',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'The Acer Aspire 3 laptop lasted over 8 hours on a single charge (light load).',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
    ],
    [
      {
        text: 'Dell Inspiron Plus 16 7630 - Best midrange laptop',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'Dell',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: '$1,249.99',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'The Dell Inspiron 16 7630 packs a lot of power for the price thanks to the Intel Core i7-13700H CPU and the Nvidia GeForce RTX 4060 GPU.',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title: 'Dell Inspiron 16 Plus (7630) Review',
            url: 'https://www.pcmag.com/reviews/dell-inspiron-16-plus-7630',
          },
          {
            title: 'Dell Inspiron 16 Plus laptop review: A sleeper powerhouse',
            url: 'https://www.pcworld.com/article/2089244/dell-inspiron-plus-16-7630-laptop-review.html',
          },
          {
            title:
              'Dell Inspiron 16 Plus 7630 Review: Big, Fast Display for Video Creators and Gamers',
            url: 'https://www.cnet.com/tech/computing/dell-inspiron-16-plus-7630-review-big-fast-display-for-video-creators-and-gamers/',
          },
          {
            title: 'Dell Inspiron 16 Plus 7630 (RTX 4060) Review',
            url: 'https://www.youtube.com/watch?v=TEPZDNOKgnY',
          },
          {
            title: 'Inspiron 16 Plus | Dell USA',
            url: 'https://www.dell.com/en-us/shop/dell-laptops/inspiron-16-plus-laptop/spd/inspiron-16-7630-laptop',
          },
        ],
      },
      {
        text: '1 TB',
        confidence: 1,
        sources: [
          {
            title: 'Dell Inspiron 16 Plus (7630) Review',
            url: 'https://www.pcmag.com/reviews/dell-inspiron-16-plus-7630',
          },
          {
            title: 'Dell Inspiron 16 Plus laptop review: A sleeper powerhouse',
            url: 'https://www.pcworld.com/article/2089244/dell-inspiron-plus-16-7630-laptop-review.html',
          },
          {
            title: 'Dell Inspiron 16 Plus 7630 (RTX 4060) Review',
            url: 'https://www.youtube.com/watch?v=TEPZDNOKgnY',
          },
          {
            title: 'Inspiron 16 Plus | Dell USA',
            url: 'https://www.dell.com/en-us/shop/dell-laptops/inspiron-16-plus-laptop/spd/inspiron-16-7630-laptop',
          },
        ],
      },
      {
        text: 'The Dell Inspiron 16 7630 has a 1600p display with a taller 16:10 aspect ratio screen.',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'The battery lasted over 11 hours on a single charge.',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
    ],
    [
      {
        text: 'Lenovo Flex 5i Chromebook Plus - Best Chromebook',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'Lenovo',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: '$499',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'The Lenovo Flex 5i Chromebook Plus is powered by an Intel Core i3-1315U processor.',
        confidence: 1,
        sources: [
          {
            title: 'Lenovo Flex 5i Chromebook Plus Review',
            url: 'https://www.pcmag.com/reviews/lenovo-flex-5i-chromebook-plus',
          },
          {
            title:
              'Lenovo Flex 5i Chromebook Plus review: A luxurious, affordable 2-in-1',
            url: 'https://www.pcworld.com/article/2158103/lenovo-flex-5i-chromebook-plus-review-a-luxurious-affordable-2-in-1.html',
          },
          {
            title:
              'Lenovo IdeaPad Flex 5i Chromebook Plus: The best $499 ChromeOS laptop I’ve used',
            url: 'https://www.aboutchromebooks.com/news/lenovo-ideapad-flex-5i-chromebook-plus-review/',
          },
        ],
      },
      {
        text: '8GB',
        confidence: 1,
        sources: [
          {
            title: 'Lenovo IdeaPad Flex 5i Chromebook Plus review',
            url: 'https://www.laptopmag.com/laptops/lenovo-ideapad-flex-5i-chromebook-plus-review',
          },
          {
            title: 'Lenovo Flex 5i Chromebook Plus',
            url: 'https://me.pcmag.com/en/laptops/20125/lenovo-flex-5i-chromebook-plus',
          },
          {
            title: 'The Lenovo Flex 5i Chromebook Plus is a steal at just $379',
            url: 'https://chromeunboxed.com/deal-lenovo-flex-5i-chromebook-plus-379/',
          },
        ],
      },
      {
        text: '128GB eMMC 5.1 storage',
        confidence: 1,
        sources: [
          {
            title: 'Lenovo Flex 5i Chromebook Plus Review',
            url: 'https://www.pcmag.com/reviews/lenovo-flex-5i-chromebook-plus',
          },
          {
            title:
              'Lenovo IdeaPad Flex 5i Chromebook Plus: The best $499 ChromeOS laptop I’ve used',
            url: 'https://www.aboutchromebooks.com/news/lenovo-ideapad-flex-5i-chromebook-plus-review/',
          },
          {
            title: 'Lenovo Flex 5i Chromebook Plus',
            url: 'https://me.pcmag.com/en/laptops/20125/lenovo-flex-5i-chromebook-plus',
          },
          {
            title: '',
            url: 'https://psref.lenovo.com/syspool/Sys/PDF/IdeaPad/IP_Flex_5_Chrome_14IAU7_Plus/IP_Flex_5_Chrome_14IAU7_Plus_Spec.pdf',
          },
          {
            title: 'The Best Chromebook',
            url: 'https://www.nytimes.com/wirecutter/reviews/best-chromebook/',
          },
        ],
      },
      {
        text: 'Boasting the 13th Gen Intel® Core™ processors, as well as large memory and storage, the IdeaPad Flex 5i Chromebook Plus allows you to edit Google Docs, photos, and videos, while watching your favorite shows in full HD on a 1080p display. Plus, more power means faster gameplay\\*. Click, zoom, and drag with the touchscreen. And with a large aspect ratio, view more rows and scroll less.',
        confidence: 1,
        sources: [
          {
            title: 'IdeaPad Flex 5i Chromebook Plus Gen 7 (14″ Intel)',
            url: 'https://www.lenovo.com/us/en/p/laptops/ideapad/ideapad-flex-series/ideapad-flex-5i-chromebook-plus-gen-7-(14-inch-intel)/len101i0087',
          },
        ],
      },
      {
        text: 'With up to 10 hours of battery life**, the Chromebook Plus packs enough stamina for a long flight, full workday, or streaming marathon.',
        confidence: 1,
        sources: [
          {
            title: 'IdeaPad Flex 5i Chromebook Plus Gen 7 (14″ Intel)',
            url: 'https://www.lenovo.com/us/en/p/laptops/ideapad/ideapad-flex-series/ideapad-flex-5i-chromebook-plus-gen-7-(14-inch-intel)/len101i0087',
          },
        ],
      },
    ],
    [
      {
        text: 'HP Dragonfly G4 - Best ultraportable',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'HP',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: '$1,769',
        confidence: 1,
        sources: [
          {
            title: "HP Dragonfly G4 review: the keyboard is *chef's kiss*",
            url: 'https://www.laptopmag.com/reviews/hp-elite-dragonfly-g4-review-is-it-better-than-the-thinkpad-x1-carbon',
          },
          {
            title:
              'An Impressive Travel Laptop: Living With an HP Dragonfly G4',
            url: 'https://www.pcmag.com/news/living-with-hp-dragonfly-g4-laptop',
          },
        ],
      },
      {
        text: 'The HP Dragonfly G4 comes with 13th Generation Intel Core processors. The base model has an Intel Core i5-1335U, while the review unit has an Intel Core i7-1365U. The top configuration also has an Intel Core i5-1335U.',
        confidence: 1,
        sources: [
          {
            title: 'HP Dragonfly G4 Review',
            url: 'https://www.pcmag.com/reviews/hp-dragonfly-g4',
          },
          {
            title:
              'Introducing HP Dragonfly: The Ultimate Lightweight Learning Laptop',
            url: 'https://www.hp.com/gb-en/shop/tech-takes/dragonfly-laptops-for-education',
          },
          {
            title:
              'HP Dragonfly G4 review: the perfect travel laptop for professionals',
            url: 'https://www.techradar.com/computing/laptops/hp-dragonfly-g4-review',
          },
          {
            title: 'HP Dragonfly G4 Review: Minor Additions and Adjustments',
            url: 'https://www.tomshardware.com/reviews/hp-dragonfly-g4',
          },
          {
            title: 'HP Dragonfly G4 Review',
            url: 'https://www.thurrott.com/hardware/285865/hp-dragonfly-g4-review',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title: 'HP Dragonfly G4 Review',
            url: 'https://www.thurrott.com/hardware/285865/hp-dragonfly-g4-review',
          },
          {
            title: 'HP Dragonfly G4 Review',
            url: 'https://www.pcmag.com/reviews/hp-dragonfly-g4',
          },
          {
            title: 'HP Dragonfly G4 Review: Minor Additions and Adjustments',
            url: 'https://www.tomshardware.com/reviews/hp-dragonfly-g4',
          },
          {
            title: 'hp-dragonfly-notebook-pc-g4-customizable-6q249av-mb',
            url: 'https://www.hp.com/us-en/shop/pdp/hp-elite-dragonfly-notebook-pc-g4-customizable-6q249av-mb',
          },
          {
            title:
              'HP Dragonfly G4 review: the perfect travel laptop for professionals',
            url: 'https://www.techradar.com/computing/laptops/hp-dragonfly-g4-review',
          },
          {
            title: "HP Dragonfly G4 review: the keyboard is *chef's kiss*",
            url: 'https://www.laptopmag.com/reviews/hp-elite-dragonfly-g4-review-is-it-better-than-the-thinkpad-x1-carbon',
          },
        ],
      },
      {
        text: '512GB PCIe NVMe SSD',
        confidence: 1,
        sources: [
          {
            title: 'HP Dragonfly G4 Review',
            url: 'https://www.pcmag.com/reviews/hp-dragonfly-g4',
          },
          {
            title: 'HP Dragonfly G4 Review: Minor Additions and Adjustments',
            url: 'https://www.tomshardware.com/reviews/hp-dragonfly-g4',
          },
          {
            title:
              'HP Dragonfly 13.5 inch G4 Notebook PC Wolf Pro Security Edition',
            url: 'https://www.hp.com/us-en/shop/pdp/hp-dragonfly-135-inch-g4-notebook-pc-wolf-pro-security-edition-p-878f9ut-aba-1',
          },
        ],
      },
      {
        text: 'The HP Dragonfly G4 laptop offers a 13.5-inch display with a 3:2 aspect ratio and 1920x1280 resolution. There are also options for a higher resolution 3000x2000 OLED touch display.',
        confidence: 1,
        sources: [
          {
            title: 'HP Dragonfly G4 Review',
            url: 'https://www.pcmag.com/reviews/hp-dragonfly-g4',
          },
          {
            title:
              'HP Dragonfly G4 Review: Elegant, Long-Running Ultraportable for Traveling Execs',
            url: 'https://www.cnet.com/tech/computing/hp-dragonfly-g4-review-elegant-long-running-ultraportable-for-traveling-execs/',
          },
          {
            title: 'hp-dragonfly-notebook-pc-g4-customizable-6q249av-mb',
            url: 'https://www.hp.com/us-en/shop/pdp/hp-elite-dragonfly-notebook-pc-g4-customizable-6q249av-mb',
          },
          {
            title: 'HP Dragonfly G4: A Complete Review',
            url: 'https://www.hp.com/us-en/shop/tech-takes/dragonfly-g4-review',
          },
          {
            title: 'HP Dragonfly G4 Review',
            url: 'https://www.thurrott.com/hardware/285865/hp-dragonfly-g4-review',
          },
          {
            title: 'HP Dragonfly G4',
            url: 'https://me.pcmag.com/en/laptops/18450/hp-dragonfly-g4',
          },
        ],
      },
      {
        text: '17.5 hours',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
    ],
    [
      {
        text: 'Acer Swift Edge 16 - Best budget ultraportable',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'Acer',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: '$1,299.99',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'The Acer Swift Edge 16 laptop comes with either an AMD Ryzen 7 6800U processor or an AMD Ryzen 7 7840U processor, depending on the configuration.',
        confidence: 1,
        sources: [
          {
            title: 'Acer Swift Edge 16 Review',
            url: 'https://www.pcmag.com/reviews/acer-swift-edge-16',
          },
          {
            title:
              'Acer Swift Edge 16 Review: OLED Goodness in a Thin and Light Chassis',
            url: 'https://www.tomshardware.com/reviews/acer-swift-edge-16',
          },
          {
            title:
              "Acer Swift Edge 16 (2023) Review: Large OLED Laptop That's Also Impossibly Light",
            url: 'https://www.cnet.com/tech/computing/acer-swift-edge-16-2023-review-large-oled-laptop-thats-also-impossibly-light/',
          },
          {
            title: 'Acer Swift Edge 16 review',
            url: 'https://www.laptopmag.com/reviews/acer-swift-edge-16',
          },
          {
            title: 'Acer Swift Edge 16',
            url: 'https://me.pcmag.com/en/laptops/15685/acer-swift-edge-16',
          },
          {
            title:
              'Acer Swift Edge 16 review: A stunning OLED laptop with a crazy-good AMD Ryzen CPU',
            url: 'https://www.xda-developers.com/acer-swift-edge-16-2023-review/',
          },
          {
            title:
              'Acer Swift Edge (SFA16-41) Review: Big Screen OLED Laptop That Weighs Next to Nothing',
            url: 'https://www.cnet.com/tech/computing/acer-swift-edge-sfa16-41-review/',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title: 'Acer Swift Edge 16 Review',
            url: 'https://www.pcmag.com/reviews/acer-swift-edge-16',
          },
          {
            title: 'Acer Swift Edge 16 (Late 2023) Review',
            url: 'https://www.pcmag.com/reviews/acer-swift-edge-16-late-2023',
          },
          {
            title:
              'Acer Swift Edge 16 laptop review: This ultralight OLED challenger is almost perfect for traveling workers',
            url: 'https://www.windowscentral.com/hardware/laptops/acer-swift-edge-16-review',
          },
          {
            title:
              'Acer Swift Edge (SFA16-41) Review: Big Screen OLED Laptop That Weighs Next to Nothing',
            url: 'https://www.cnet.com/tech/computing/acer-swift-edge-sfa16-41-review/',
          },
          {
            title:
              'Amazon.com: acer Swift Edge 16 Thin and Light Business Laptop 16" 4K OLED CineCrystal 400 nits AMD Octa-core Ryzen 7 7735U (Beats i7-1255u) 16GB RAM 1TB SSD Fingerprint Backlit FHD Camera Win11 Gray + HDMI Cable : Electronics',
            url: 'https://www.amazon.com/acer-Business-CineCrystal-Octa-core-Fingerprint/dp/B0CQRKD5L1',
          },
        ],
      },
      {
        text: '1TB',
        confidence: 1,
        sources: [
          {
            title: 'Acer Swift Edge 16 Review',
            url: 'https://www.pcmag.com/reviews/acer-swift-edge-16',
          },
          {
            title:
              "Acer Swift Edge 16 (2023) Review: Large OLED Laptop That's Also Impossibly Light",
            url: 'https://www.cnet.com/tech/computing/acer-swift-edge-16-2023-review-large-oled-laptop-thats-also-impossibly-light/',
          },
          {
            title:
              'Acer Swift Edge 16 Review: OLED Goodness in a Thin and Light Chassis',
            url: 'https://www.tomshardware.com/reviews/acer-swift-edge-16',
          },
          {
            title:
              'Acer Swift Edge 16 review: A super-thin laptop that’s light on your wallet',
            url: 'https://www.pcworld.com/article/2092812/acer-swift-edge-16-review.html',
          },
          {
            title: 'Acer Swift Edge 16 review',
            url: 'https://www.laptopmag.com/reviews/acer-swift-edge-16',
          },
          {
            title:
              'Acer Swift Edge (SFA16-41) Review: Big Screen OLED Laptop That Weighs Next to Nothing',
            url: 'https://www.cnet.com/tech/computing/acer-swift-edge-sfa16-41-review/',
          },
        ],
      },
      {
        text: 'The Acer Swift Edge 16 has a 2000p OLED display.',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: "Acer claims the Swift Edge's 54 Wh battery can last up to 10.5 hours of video playback, 8 hours browsing the web, and 7.5 hours on the MobileMark 2018 benchmark.",
        confidence: 1,
        sources: [
          {
            title:
              'Acer’s Ryzen 6000-powered Swift Edge laptop has a 16-inch OLED screen for $1,500',
            url: 'https://arstechnica.com/civis/threads/acer%E2%80%99s-ryzen-6000-powered-swift-edge-laptop-has-a-16-inch-oled-screen-for-1-500.1486996/',
          },
        ],
      },
    ],
    [
      {
        text: 'Alienware m16 R2 - Best gaming laptop',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
        ],
      },
      {
        text: 'Alienware',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
        ],
      },
      {
        text: '$1,849.99',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
        ],
      },
      {
        text: 'Intel Core Ultra 7 155H CPU',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
        ],
      },
      {
        text: '16GB, 2x8GB, DDR5, 5600 MT/s',
        confidence: 1,
        sources: [
          {
            title:
              'Alienware m16 R2 Gaming Laptop with NVIDIA RTX 4070 Laptop GPUs | Dell USA',
            url: 'https://www.dell.com/en-us/shop/gaming-laptops/alienware-m16-r2-gaming-laptop/spd/alienware-m16-r2-laptop',
          },
          {
            title:
              'Alienware m16 R2 review: This gaming laptop can be your daily driver',
            url: 'https://www.pcworld.com/article/2254934/alienware-m16-r2-review.html',
          },
          {
            title: 'Alienware m16 R2 review: A stealthy gaming laptop',
            url: 'https://www.tomsguide.com/reviews/alienware-m16-r2',
          },
          {
            title: 'Alienware m16 R2 review: Now more mainstream',
            url: 'https://www.tomshardware.com/laptops/gaming-laptops/alienware-m16-r2-review',
          },
        ],
      },
      {
        text: '1TB',
        confidence: 1,
        sources: [
          {
            title:
              'Alienware m16 R2 Gaming Laptop with NVIDIA RTX 4070 Laptop GPUs | Dell USA',
            url: 'https://www.dell.com/en-us/shop/gaming-laptops/alienware-m16-r2-gaming-laptop/spd/alienware-m16-r2-laptop',
          },
          {
            title:
              'Alienware m16 R2 QHD+ 240Hz Gaming Laptop Intel Core Ultra 7 16GB Memory NVIDIA GeForce RTX 4060 1TB SSD Dark Metallic Moon AWM16-7032BLK-PUS - Best Buy',
            url: 'https://www.bestbuy.com/site/alienware-m16-r2-qhd-240hz-gaming-laptop-intel-core-ultra-7-16gb-memory-nvidia-geforce-rtx-4060-1tb-ssd-dark-metallic-moon/6571483.p?skuId=6571483',
          },
          {
            title:
              "Alienware m16 R2 (2024) review: One of the smoothest gaming laptops I've ever experienced",
            url: 'https://www.windowscentral.com/laptops/alienware-m16-r2-review',
          },
          {
            title: 'Alienware m16 R2 review: Now more mainstream',
            url: 'https://www.tomshardware.com/laptops/gaming-laptops/alienware-m16-r2-review',
          },
          {
            title: 'Alienware m16 R2 Review',
            url: 'https://www.pcmag.com/reviews/alienware-m16-r2',
          },
          {
            title:
              'Alienware m16 R2 review: This gaming laptop can be your daily driver',
            url: 'https://www.pcworld.com/article/2254934/alienware-m16-r2-review.html',
          },
          {
            title:
              'Alienware m16 R2 review: Excellent redesign thwarted by a subpar display',
            url: 'https://www.laptopmag.com/reviews/alienware-m16-r2',
          },
        ],
      },
      {
        text: 'The 16-inch IPS display also has a resolution of 2560×1600 and a refresh rate of 240Hz.',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
        ],
      },
      {
        text: 'It lasted a respectable 11 hours and fifteen minutes on a single charge',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
        ],
      },
    ],
    [
      {
        text: 'Asus TUF Gaming A16 Advantage Edition - Best budget gaming laptop',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'Asus',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: '$1,099.99',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'The ASUS TUF Gaming A16 Advantage Edition laptop is available with the AMD Ryzen 7 7735HS processor. It has 8 cores, 16 threads, and can boost up to 4.7GHz with 16MB of L3 cache. It is a 35W CPU designed for high performance in laptops.',
        confidence: 1,
        sources: [
          {
            title: 'ASUS TUF Gaming A16 Advantage Edition (2023) Review',
            url: 'https://www.rtings.com/laptop/reviews/asus/tuf-gaming-a16-advantage-edition-2023',
          },
          {
            title:
              'Best gaming laptops under $1,000: Best overall, best battery life, and more',
            url: 'https://www.pcworld.com/article/630093/best-gaming-laptops-under-1000.html',
          },
          {
            title: 'Asus TUF Gaming A16 Laptop Only $799 at Best Buy',
            url: 'https://www.tomshardware.com/laptops/asus-tuf-gaming-a16-laptop-only-dollar799-at-best-buy',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title:
              'Asus TUF Gaming A16 Advantage Edition review: All-day gaming at a great price',
            url: 'https://www.pcworld.com/article/1801913/asus-tuf-gaming-a16-advantage-edition-review.html',
          },
          {
            title:
              'ASUS TUF Gaming A16 Advantage Edition FA617NS - 16" FHD+ 165Hz - Ryzen 7 7735HS - RX 7600S',
            url: 'https://www.hidevolution.com/asus-tuf-gaming-a16-advantage-edition-fa617ns-16-fhd-165hz-ryzen-7-7735hs-rx-7600s.html',
          },
          {
            title:
              'The 3 Best Budget And Cheap Gaming Laptops - Spring 2024: Reviews',
            url: 'https://www.rtings.com/laptop/reviews/best/budget-gaming',
          },
        ],
      },
      {
        text: '512GB',
        confidence: 1,
        sources: [
          {
            title:
              'ASUS TUF Gaming A16 16" 165Hz Gaming Laptop FHD-AMD Ryzen 7 7735HS with 16GB DDR5 Memory- Radeon RX7600S 512GB PCIe SSD OFF BLACK FA617NS-A16.R77600 - Best Buy',
            url: 'https://www.bestbuy.com/site/asus-tuf-gaming-a16-16-165hz-gaming-laptop-fhd-amd-ryzen-7-7735hs-with-16gb-ddr5-memory-radeon-rx7600s-512gb-pcie-ssd-off-black/6535499.p?skuId=6535499',
          },
          {
            title: 'ASUS TUF A16 Advantage Edition 2023 Review',
            url: 'https://www.well-played.com.au/asus-tuf-a16-advantage-edition-2023-review/',
          },
        ],
      },
      {
        text: 'Gorgeous 16:10 display',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'The Asus TUF managed an incredible 11 and a half hours on a single charge.',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
    ],
    [
      {
        text: 'Asus Zenbook 14 Flip OLED - Best 2-in-1',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'Asus',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '1199.99',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'The Asus Zenbook 14 Flip OLED has an Intel Core i7-1360P CPU.',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title:
              'Zenbook 14 Flip OLED (UP5401, 12th Gen Intel)｜Laptops For Home｜ASUS Global',
            url: 'https://www.asus.com/laptops/for-home/zenbook/zenbook-14-flip-oled-up5401-12th-gen-intel/',
          },
          {
            title: 'Zenbook 14 Flip OLED (UP3404)｜Laptops For Home｜ASUS USA',
            url: 'https://www.asus.com/us/laptops/for-home/zenbook/zenbook-14-flip-oled-up3404/',
          },
          {
            title:
              'Asus Zenbook 14 Flip OLED review: A versatile, long-lasting OLED 2-in-1',
            url: 'https://www.pcworld.com/article/2040974/asus-zenbook-14-flip-oled-review-a-versatile-oled-2-in-1-with-an-all-day-battery.html',
          },
          {
            title:
              'Zenbook 14 Flip OLED (UN5401, AMD Ryzen 6000 series)｜Laptops For Home｜ASUS USA',
            url: 'https://www.asus.com/us/laptops/for-home/zenbook/zenbook-14-flip-oled-un5401-amd-ryzen-6000-series/',
          },
          {
            title: 'ASUS Zenbook 14 Flip OLED (2023) Review',
            url: 'https://www.rtings.com/laptop/reviews/asus/zenbook-14-flip-oled-2023',
          },
          {
            title: 'Zenbook 14 OLED (UX3402)｜Laptops For Home｜ASUS USA',
            url: 'https://www.asus.com/us/laptops/for-home/zenbook/zenbook-14-oled-ux3402/',
          },
          {
            title:
              'Amazon.com: ASUS Zenbook 14 Flip OLED Ultra Slim Laptop, 14” 4K 16:10 OLED Touch Display, AMD Ryzen 7 6800H CPU, 16GB RAM, 1TB SSD, NumberPad, Windows 11 Home, Jade Black, UN5401RA-DH74T : Electronics',
            url: 'https://www.amazon.com/ASUS-Zenbook-Flip-Ultra-Laptop/dp/B0BT8VSD1F',
          },
        ],
      },
      {
        text: '512GB',
        confidence: 1,
        sources: [
          {
            title: 'ASUS Zenbook 14 Flip OLED (2023) Review',
            url: 'https://www.rtings.com/laptop/reviews/asus/zenbook-14-flip-oled-2023',
          },
          {
            title:
              'Asus Zenbook 14 Flip OLED review: The best 2-in-1 for the money',
            url: 'https://www.tomsguide.com/reviews/asus-zenbook-14-flip-oled',
          },
        ],
      },
      {
        text: 'The Asus Zenbook 14 Flip OLED has a 14-inch 2.8K OLED panel.',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'The advertised battery life of the Asus Zenbook 14 Flip OLED is not explicitly stated in the given sources.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'Dell XPS 17 (2023) - Best content creation laptop',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'Dell',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'From $2,449',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'It comes armed with an Intel Core i7-13700H CPU',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: '16 GB',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '1TB',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'The Dell XPS 17 comes with a big 17-inch 4K panel.',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'Amazing battery life',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
    ],
    [
      {
        text: 'HP Pavilion Plus 14 - Best OLED display under $1,000',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'HP',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: '828.99',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'For $1,029, you get a gorgeous 14-inch 2.8K OLED display, excellent build quality, and an Intel 12th Gen H-series processor (aka the powerful 45-watt one). Our $1,210 model has the Core i7-12700H processor, 16GB of RAM, 1TB SSD, Iris Xe graphics, and the 2.8K OLED panel.',
        confidence: 1,
        sources: [
          {
            title:
              'HP Pavilion Plus 14 review: The best $1,000 you can spend on a powerful OLED laptop right now',
            url: 'https://www.windowscentral.com/hardware/laptops/hp-pavilion-plus-14-the-best-dollar1000-you-can-spend-on-a-powerful-oled-laptop-right-now',
          },
        ],
      },
      {
        text: '',
        confidence: 0.8,
        sources: [
          {
            title: 'HP Pavilion Plus 14 Review',
            url: 'https://www.pcmag.com/reviews/hp-pavilion-plus-14',
          },
          {
            title: 'HP Pavilion Plus 14 Review',
            url: 'https://www.thurrott.com/hardware/270788/hp-pavilion-plus-14-review',
          },
          {
            title: 'HP Pavilion Plus 14 (2023, AMD) Review',
            url: 'https://www.pcmag.com/reviews/hp-pavilion-plus-14-2023-amd',
          },
          {
            title:
              'HP Pavilion Plus 14 review: Premium style and performance at a mainstream price',
            url: 'https://www.pcworld.com/article/827304/hp-pavilion-plus-14-review-premium-style-and-performance-at-mainstream-price.html',
          },
        ],
      },
      {
        text: '256 GB',
        confidence: 1,
        sources: [
          {
            title: 'HP Pavilion Plus 14 Review',
            url: 'https://www.pcmag.com/reviews/hp-pavilion-plus-14',
          },
          {
            title:
              'HP’s Pavilion Plus 14 is a powerful, confusing OLED machine',
            url: 'https://www.theverge.com/23440913/hp-pavilion-plus-14-intel-oled-laptop-review-price-specs-features-design',
          },
          {
            title:
              'HP Pavilion Plus 14 review: Premium style and performance at a mainstream price',
            url: 'https://www.pcworld.com/article/827304/hp-pavilion-plus-14-review-premium-style-and-performance-at-mainstream-price.html',
          },
        ],
      },
      {
        text: 'The HP Pavilion Plus 14 has a 1800p OLED display.',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
      {
        text: 'Long battery life',
        confidence: 1,
        sources: [
          {
            title:
              'Best laptops 2024: Premium, budget, gaming, 2-in-1s, and more',
            url: 'https://www.pcworld.com/article/436674/the-best-pc-laptops-of-the-year.html',
          },
        ],
      },
    ],
    [
      {
        text: 'Dell XPS 13 Plus',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: 'Dell',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '$1,349 at Dell',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '13th-gen Intel Core',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '8 GB',
        confidence: 1,
        sources: [
          {
            title: 'XPS 13 9310 Setup and Specifications',
            url: 'https://www.dell.com/support/manuals/en-us/xps-13-9310-laptop/xps-13-9310-setup-and-specifications/memory?guid=guid-ba7ad7a6-eb2f-4019-8f8d-b26333a636fe&lang=en-us',
          },
          {
            title:
              'Dell XPS 13 Plus laptop review: Is the base configuration the best choice?',
            url: 'https://www.notebookcheck.net/Dell-XPS-13-Plus-laptop-review-Is-the-base-configuration-the-best-choice.640441.0.html',
          },
          {
            title:
              'Dell XPS 13 Plus buying guide: What to buy, what to avoid | Digital Trends',
            url: 'https://www.digitaltrends.com/computing/dell-xps-13-plus-buying-guide/',
          },
        ],
      },
      {
        text: '512 GB',
        confidence: 1,
        sources: [
          {
            title: 'XPS 13 Plus Laptop : Dell XPS Laptop Computers | Dell USA',
            url: 'https://www.dell.com/en-us/shop/dell-laptops/xps-13-plus-laptop/spd/xps-13-9320-laptop',
          },
          {
            title:
              'Dell XPS 13 Plus laptop review: Is the base configuration the best choice?',
            url: 'https://www.notebookcheck.net/Dell-XPS-13-Plus-laptop-review-Is-the-base-configuration-the-best-choice.640441.0.html',
          },
          {
            title:
              'Dell XPS 13 Plus buying guide: What to buy, what to avoid | Digital Trends',
            url: 'https://www.digitaltrends.com/computing/dell-xps-13-plus-buying-guide/',
          },
        ],
      },
      {
        text: '13.4-inch InfinityEdge',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: 'The advertised battery life for the Dell XPS 13 Plus laptop is not explicitly stated in the given sources.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'ASUS ROG Zephyrus G14',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'ASUS',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '$1,499 at Amazon',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'AMD Ryzen 9',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '1TB',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: '14-inch | 2,560 x 1,600 pixels',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
      {
        text: 'Up to 8 hours',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
          {
            title: 'Best laptops 2024 tested — find the best laptop for you',
            url: 'https://www.tomsguide.com/best-picks/best-laptops',
          },
        ],
      },
    ],
    [
      {
        text: 'Lenovo IdeaPad Flex 5i Chromebook',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: 'Lenovo',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '$438 at Amazon',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '10th-generation Intel Core i3',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '4GB',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '128GB',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '13.3-inch FHD',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: 'eight hours of battery life',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
    ],
    [
      {
        text: 'HP Pavilion Aero',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: 'HP',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '$799',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: 'AMD Ryzen 5000 series',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '16 GB',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '256GB',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '13.3-inch micro-edge',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: 'all-day battery life',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
    ],
    [
      {
        text: 'Microsoft Surface Pro 9',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: 'Microsoft',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '$999.99',
        confidence: 1,
        sources: [
          {
            title:
              'Microsoft Surface Pro 9 13" Touch-Screen Intel Core i5 8GB Memory 128GB SSD Device Only (Latest Model) Platinum QCB-00001 - Best Buy',
            url: 'https://www.bestbuy.com/site/microsoft-surface-pro-9-13-touch-screen-intel-core-i5-8gb-memory-128gb-ssd-device-only-latest-model-platinum/6517654.p?skuId=6517654',
          },
          {
            title:
              'The Surface Pro 9 is more than $500 off, matching its all-time low',
            url: 'https://www.theverge.com/2024/2/3/24059630/microsoft-surface-pro-9-beats-studio-buds-plus-samsung-frame-tv-deal-sale',
          },
        ],
      },
      {
        text: 'Intel Evo i5',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '8GB',
        confidence: 1,
        sources: [
          {
            title: 'What configurations does the Surface Pro 9 come in?',
            url: 'https://www.xda-developers.com/what-configurations-does-the-surface-pro-9-come-in/',
          },
        ],
      },
      {
        text: '256 GB',
        confidence: 1,
        sources: [
          {
            title: 'Surface storage options and hard drive sizes',
            url: 'https://support.microsoft.com/en-us/surface/surface-storage-options-and-hard-drive-sizes-9915981d-3e38-f06c-4706-82b5dedf33bc',
          },
          {
            title: 'Microsoft Surface Pro 9 (Intel) Review',
            url: 'https://www.pcmag.com/reviews/microsoft-surface-pro-9-intel',
          },
        ],
      },
      {
        text: '13-inch PixelSense',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: 'The Surface Pro 9 (Intel) is advertised with up to 15.5 hours of battery life based on typical Surface device usage.',
        confidence: 1,
        sources: [
          {
            title: 'Surface Pro 9 battery life',
            url: 'https://answers.microsoft.com/en-us/surface/forum/all/surface-pro-9-battery-life/eeffa1c0-f104-47ce-8c17-a74bd4fe625f',
          },
        ],
      },
    ],
    [
      {
        text: 'Apple 15-inch MacBook Air M3',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: 'Apple',
        confidence: 1,
        sources: [
          {
            title: 'The best laptops for 2024',
            url: 'https://www.engadget.com/best-laptops-120008636.html',
          },
        ],
      },
      {
        text: '$1,299',
        confidence: 1,
        sources: [
          {
            title: 'M3 MacBook Air: Everything you need to know',
            url: 'https://www.macworld.com/article/2000691/13-15-inch-macbook-air-m3-release-date-specs-rumors-html.html',
          },
          {
            title: 'Apple MacBook Air 15-Inch (2024, M3) Review',
            url: 'https://www.pcmag.com/reviews/apple-macbook-air-15-inch-2024-m3',
          },
          {
            title:
              'Apple MacBook Air 15-inch (M3) review: Bigger, bolder, faster, better',
            url: 'https://www.techradar.com/computing/macbooks/apple-macbook-air-15-inch-m3',
          },
          {
            title:
              'Apple M3 MacBook Air Review: The 15-Inch Is The Perfect Digital Nomad Machine',
            url: 'https://www.forbes.com/sites/bensin/2024/03/11/apple-m3-macbook-air-review-the-15-inch-is-the-perfect-digital-nomad-machine/',
          },
          {
            title:
              'Apple 13- and 15-inch M3 MacBook Air: Price, Specs, Availability',
            url: 'https://www.wired.com/story/apple-new-13-and-15-inch-macbook-air-m3-chip/',
          },
          {
            title:
              '15-inch MacBook Air (M3) review: Simply the best, but better',
            url: 'https://www.macworld.com/article/2259608/15-inch-macbook-air-m3-review.html',
          },
        ],
      },
      {
        text: 'The 15-inch MacBook Air is powered by the Apple M3 chip, which features an 8-core CPU with 4 performance cores and 4 efficiency cores, and a 10-core GPU. It also has a 16-core Neural Engine, 100GB/s memory bandwidth, and hardware acceleration for various video codecs like H.264, HEVC, ProRes, ProRes RAW, and AV1 decode.',
        confidence: 1,
        sources: [
          {
            title:
              'Apple unveils the new 13- and 15‑inch MacBook Air with the powerful M3 chip',
            url: 'https://www.apple.com/newsroom/2024/03/apple-unveils-the-new-13-and-15-inch-macbook-air-with-the-powerful-m3-chip/',
          },
          {
            title: 'MacBook Air 13- and 15-inch with M3 or M2 - Tech Specs',
            url: 'https://www.apple.com/macbook-air/specs/',
          },
          {
            title: 'M3 MacBook Air: Everything you need to know',
            url: 'https://www.macworld.com/article/2000691/13-15-inch-macbook-air-m3-release-date-specs-rumors-html.html',
          },
          {
            title: 'Apple MacBook Air 15-Inch (2024, M3) Review',
            url: 'https://www.pcmag.com/reviews/apple-macbook-air-15-inch-2024-m3',
          },
        ],
      },
      {
        text: '8GB',
        confidence: 1,
        sources: [
          {
            title: 'MacBook Air 13- and 15-inch with M3 or M2 - Tech Specs',
            url: 'https://www.apple.com/macbook-air/specs/',
          },
          {
            title:
              'MacBook Air (15-inch, M2, 2023) - Technical Specifications - Apple Support',
            url: 'https://support.apple.com/en-us/111346',
          },
          {
            title: 'Apple MacBook Air 15-Inch M3 Preview',
            url: 'https://www.thurrott.com/mobile/mac-and-macos/299508/apple-macbook-air-15-inch-m3-preview',
          },
          {
            title: 'MacBook Pro - Tech Specs',
            url: 'https://www.apple.com/macbook-pro/specs/',
          },
        ],
      },
      {
        text: '256GB SSD',
        confidence: 1,
        sources: [
          {
            title:
              'MacBook Air (15-inch, M3, 2024) - Technical Specifications - Apple Support',
            url: 'https://support.apple.com/en-us/118552',
          },
          {
            title: 'Buy 15-inch MacBook Air with M3 Chip',
            url: 'https://www.apple.com/shop/buy-mac/macbook-air/15-inch-m3',
          },
          {
            title: 'Buy MacBook Air',
            url: 'https://www.apple.com/shop/buy-mac/macbook-air',
          },
          {
            title: "The MacBook Air 15-inch has an SSD problem — here's why",
            url: 'https://www.tomsguide.com/news/the-macbook-air-15-inch-is-incredible-but-its-cheapest-model-has-a-storage-problem',
          },
        ],
      },
      {
        text: 'The 15-inch MacBook Air M3 has a 15.3-inch Liquid Retina display with 2880-by-1864 resolution at 224 pixels per inch.',
        confidence: 1,
        sources: [
          {
            title:
              'MacBook Air (15-inch, M2, 2023) - Technical Specifications - Apple Support',
            url: 'https://support.apple.com/en-us/111346',
          },
          {
            title:
              'Apple MacBook Air 15-inch (M3) review: Bigger, bolder, faster, better',
            url: 'https://www.techradar.com/computing/macbooks/apple-macbook-air-15-inch-m3',
          },
          {
            title:
              'Review: Apple’s 15-inch MacBook Air says what it is and is what it says',
            url: 'https://arstechnica.com/gadgets/2023/06/review-apples-15-inch-macbook-air-says-what-it-is-and-is-what-it-says/',
          },
          {
            title:
              'MacBook Air (2024) review: M3 updates come to 13 and 15-inch laptops',
            url: 'https://www.tomshardware.com/laptops/ultrabooks-ultraportables/apple-macbook-air-m3-review-13-15-2024',
          },
          {
            title:
              "Apple MacBook Air's 15-inch screen makes a surprising difference",
            url: 'https://www.youtube.com/watch?v=PtGvrXGgNm4',
          },
        ],
      },
      {
        text: 'Up to 18 hours of video playback (with the Apple TV app), Up to 15 hours of wireless web',
        confidence: 1,
        sources: [
          {
            title: "M3 MacBook Air battery life: Here's what you get - 9to5Mac",
            url: 'https://9to5mac.com/2024/03/04/m3-macbook-air-battery-life/',
          },
        ],
      },
    ],
    [
      {
        text: 'Acer Predator Helios 300',
        confidence: 1,
        sources: [
          {
            title: 'Best Gaming Laptops 2023, Showing Maximum Performance',
            url: 'https://best.kevin.games/gaming-laptops/top-10-best-gaming-laptops',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'Acer',
        confidence: 1,
        sources: [
          {
            title: 'Best Gaming Laptops 2023, Showing Maximum Performance',
            url: 'https://best.kevin.games/gaming-laptops/top-10-best-gaming-laptops',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: '1,500$',
        confidence: 1,
        sources: [
          {
            title: 'Best Gaming Laptops 2023, Showing Maximum Performance',
            url: 'https://best.kevin.games/gaming-laptops/top-10-best-gaming-laptops',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'It has nothing special but a great price of 1,500$ along with promising components installed. Among other upsides is a speedy 240Hz high-refresh display providing a deep vibrant picture. This budget guest can boast the latest Intel Core i7 processor.',
        confidence: 1,
        sources: [
          {
            title: 'Best Gaming Laptops 2023, Showing Maximum Performance',
            url: 'https://best.kevin.games/gaming-laptops/top-10-best-gaming-laptops',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title: 'Best Gaming Laptops 2023, Showing Maximum Performance',
            url: 'https://best.kevin.games/gaming-laptops/top-10-best-gaming-laptops',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: '512GB',
        confidence: 1,
        sources: [
          {
            title: 'Best Gaming Laptops 2023, Showing Maximum Performance',
            url: 'https://best.kevin.games/gaming-laptops/top-10-best-gaming-laptops',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'It has nothing special but a great price of 1,500$ along with promising components installed. Among other upsides is a speedy 240Hz high-refresh display providing a deep vibrant picture.',
        confidence: 1,
        sources: [
          {
            title: 'Best Gaming Laptops 2023, Showing Maximum Performance',
            url: 'https://best.kevin.games/gaming-laptops/top-10-best-gaming-laptops',
          },
          {
            title: 'Best Gaming Laptop Reddit 2023',
            url: 'https://techbylight.com/best-gaming-notebook-reddit/',
          },
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'The battery life is advertised as "up to" 7 hours.',
        confidence: 1,
        sources: [
          {
            title: 'Battery life options?',
            url: 'https://community.acer.com/en/discussion/532943/battery-life-options',
          },
        ],
      },
    ],
    [
      {
        text: 'Dell G5 - Best Gaming Laptop under 1000',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'Dell',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: '$879.99',
        confidence: 1,
        sources: [
          {
            title:
              'Dell’s G5 15 SE is both an affordable and excellent gaming laptop',
            url: 'https://www.theverge.com/21328344/dell-g5-15-se-review-2020-gaming-laptop-amd-ryzen',
          },
        ],
      },
      {
        text: 'CPU: AMD Ryzen 5 4600H 6-core processor',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: Newest Dell G5 SE 5505 15.6" FHD IPS High Performance Gaming Laptop, AMD 4th Gen Ryzen 5 4600H 6-core, 8GB RAM, 256GB PCIe SSD, Backlit Keyboard, AMD Radeon RX 5600M, Windows 10 : Electronics',
            url: 'https://www.amazon.com/Dell-Performance-Backlit-Keyboard-Windows/dp/B08BFM94BX',
          },
        ],
      },
      {
        text: '16 Gigs of 2666Mhz DDR 4 RAM',
        confidence: 1,
        sources: [
          {
            title: 'Dell G5 Gaming Laptop Review — World Bolding',
            url: 'https://www.worldbolding.com/home/2018/7/12/dell-g5-gaming-laptop-review',
          },
        ],
      },
      {
        text: '256 Gigabyte SATA SSD',
        confidence: 1,
        sources: [
          {
            title: 'Dell G5 Gaming Laptop Review — World Bolding',
            url: 'https://www.worldbolding.com/home/2018/7/12/dell-g5-gaming-laptop-review',
          },
        ],
      },
      {
        text: '15.6/1920 x 1080',
        confidence: 1,
        sources: [
          {
            title: 'The best cheap gaming laptops in 2024',
            url: 'https://www.laptopmag.com/articles/sub-1000-gaming-laptops',
          },
        ],
      },
      {
        text: 'The massive 90 watt-hour battery lasted 11 hours on a single charge, which is impressive for a gaming laptop. Gaming rigs tend to fizzle out at the five- or six-hour mark.',
        confidence: 1,
        sources: [
          {
            title:
              'Best gaming laptops under $1,000: Best overall, best battery life, and more',
            url: 'https://www.pcworld.com/article/630093/best-gaming-laptops-under-1000.html',
          },
        ],
      },
    ],
    [
      {
        text: 'Alienware Gaming AW17R5 - Best Gaming Laptop under 1500',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'Dell',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'The current starting price for the Alienware AW17R5 gaming laptop is likely around $1,299.99 based on the student discount mentioned in one of the sources.',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Intel Core i7-8750H',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: Alienware 17 R5 AW17R5, 17.3" FHD, Intel Core i7-8750H, GTX 1070 Graphics, 16GB DDR4 Ram, 256GB SSD+1TB HDD, Windows 10 : Everything Else',
            url: 'https://www.amazon.com/Alienware-AW17R5-i7-8750H-Graphics-Windows/dp/B07CWHWYPK',
          },
          {
            title: 'Robot or human?',
            url: 'https://www.walmart.com/ip/Alienware-17-R5-Gaming-Laptop-17-3-Intel-Core-i7-8750H-NVIDIA-GeForce-GTX-1060-OC-1TB-HDD-256GB-PCIe-M-2-SSD-Storage-8GB-RAM-AW17R5-7108SLV-PUS/928660780',
          },
          {
            title: 'Amazon.com',
            url: 'https://www.amazon.com/Alienware-AW17R5-7405SLV-PUS-Processor-GeForce-Display/dp/B07CV7614D',
          },
          {
            title: 'Robot or human?',
            url: 'https://www.walmart.com/ip/Alienware-17-R5-Gaming-Laptop-17-3-Intel-Core-i7-8750H-NVIDIA-GeForce-GTX-1070-Max-Q-8GB-1-TB-HDD-8GB-SSD-Hybrid-Drive-16GB-RAM-AW17R5-7092SLV-PUS/200764270',
          },
        ],
      },
      {
        text: '8GB',
        confidence: 1,
        sources: [
          {
            title: 'Amazon.com',
            url: 'https://www.amazon.com/Alienware-Ready-17-3-Gaming-Notebook/dp/B07DJRP9XG',
          },
          {
            title: 'Robot or human?',
            url: 'https://www.walmart.com/ip/Alienware-17-R5-Gaming-Laptop-17-3-Intel-Core-i7-8750H-NVIDIA-GeForce-GTX-1060-OC-1TB-HDD-256GB-PCIe-M-2-SSD-Storage-8GB-RAM-AW17R5-7108SLV-PUS/928660780',
          },
          {
            title: 'Robot or human?',
            url: 'https://www.walmart.com/ip/Alienware-17-R5-Gaming-Laptop-17-3-Intel-Core-i7-8750H-NVIDIA-GeForce-GTX-1070-Max-Q-8GB-1-TB-HDD-8GB-SSD-Hybrid-Drive-16GB-RAM-AW17R5-7092SLV-PUS/200764270',
          },
          {
            title: 'Alienware m17 R5 Review',
            url: 'https://www.pcmag.com/reviews/alienware-m17-r5',
          },
        ],
      },
      {
        text: '256GB',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: Alienware 17 R5 AW17R5, 17.3" FHD, Intel Core i7-8750H, GTX 1070 Graphics, 16GB DDR4 Ram, 256GB SSD+1TB HDD, Windows 10 : Everything Else',
            url: 'https://www.amazon.com/Alienware-AW17R5-i7-8750H-Graphics-Windows/dp/B07CWHWYPK',
          },
          {
            title: 'Alienware 17 R5 Setup and Specifications',
            url: 'https://www.dell.com/support/manuals/en-us/alienware-17-r5/alienware-17-r5-setupspecs/storage?guid=guid-82b84b7b-af12-46fb-bb74-5669a64c7ecc&lang=en-us',
          },
          {
            title: 'Alienware m17 R5 AMD Setup and Specifications',
            url: 'https://www.dell.com/support/manuals/en-us/alienware-m17-r5-amd-gaming-laptop/alienware-m17-ryzen-edition-r5-setup-and-specs/storage?guid=guid-a00459e0-2a64-449c-9f02-581bf2e3c2cf&lang=en-us',
          },
          {
            title:
              'Best Buy: Alienware 17.3" Gaming Laptop Intel Core i7 16GB Memory NVIDIA GeForce GTX 1070 1TB Hard Drive + 256GB Solid State Drive Black AW17R5-7811BLK-PUS',
            url: 'https://www.bestbuy.com/site/alienware-17-3-gaming-laptop-intel-core-i7-16gb-memory-nvidia-geforce-gtx-1070-1tb-hard-drive-256gb-solid-state-drive-black/6228319.p?skuId=6228319',
          },
        ],
      },
      {
        text: '17.3" FHD Display',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: Alienware 17 R5 AW17R5, 17.3" FHD, Intel Core i7-8750H, GTX 1070 Graphics, 16GB DDR4 Ram, 256GB SSD+1TB HDD, Windows 10 : Everything Else',
            url: 'https://www.amazon.com/Alienware-AW17R5-i7-8750H-Graphics-Windows/dp/B07CWHWYPK',
          },
          {
            title: 'Amazon.com',
            url: 'https://www.amazon.com/Alienware-AW17R5-7405SLV-PUS-Processor-GeForce-Display/dp/B07CV7614D',
          },
          {
            title:
              'Best Buy: Alienware 17.3" Gaming Laptop Intel Core i7 16GB Memory NVIDIA GeForce GTX 1070 1TB Hard Drive + 256GB Solid State Drive Black AW17R5-7811BLK-PUS',
            url: 'https://www.bestbuy.com/site/alienware-17-3-gaming-laptop-intel-core-i7-16gb-memory-nvidia-geforce-gtx-1070-1tb-hard-drive-256gb-solid-state-drive-black/6228319.p?skuId=6228319',
          },
        ],
      },
      {
        text: 'The sources do not provide any specific information about the advertised battery life of the Alienware AW17R5 laptop. Gaming laptops generally have shorter battery life compared to regular laptops due to their high performance components.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'MSI GS65 Stealth',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'MSI',
        confidence: 1,
        sources: [
          {
            title: 'MSI GS65 Stealth - The Game Just Got Real',
            url: 'https://www.msi.com/Laptop/GS65-Stealth-9SX',
          },
          {
            title:
              'MSI GS65 Stealth GS65 Stealth 1668 15.6 Gaming Notebook 1920 x 1080 Intel Core i7 i7 9750H 16 GB RAM 512 GB SSD Windows 10 NVIDIA GeForce GTX 1660 Ti 8 Hour Battery - ODP Business Solutions',
            url: 'https://www.odpbusiness.com/a/products/6751831/MSI-GS65-Stealth-GS65-Stealth-1668/',
          },
        ],
      },
      {
        text: '$1,799',
        confidence: 1,
        sources: [
          {
            title: 'MSI GS65 Stealth Thin - Full Review and Benchmarks',
            url: 'https://www.laptopmag.com/reviews/laptops/msi-gs65-stealth-thin',
          },
          {
            title: 'MSI GS65 Stealth review',
            url: 'https://www.techradar.com/reviews/msi-gs65-stealth',
          },
        ],
      },
      {
        text: 'Intel Core i7-9750H Processor',
        confidence: 1,
        sources: [
          {
            title:
              'MSI GS65 Stealth MSI Laptop - TEXON-WARE - Hardcore Gaming Hardware Store',
            url: 'http://www.texonware.com/product/msi-gs65-stealth-msi-laptop/',
          },
          {
            title: 'MSI GS65 Stealth (2019) Review',
            url: 'https://www.pcmag.com/reviews/msi-gs65-stealth-2019',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title: 'MSI GS65 Stealth-666 RAM and SSD Upgrade Question',
            url: 'https://forum-en.msi.com/index.php?threads/msi-gs65-stealth-666-ram-and-ssd-upgrade-question.334374/',
          },
          {
            title: 'Upgrading the RAM and SSD of MSI GS65 Stealth Thin 8RE?',
            url: 'https://forum-en.msi.com/index.php?threads/upgrading-the-ram-and-ssd-of-msi-gs65-stealth-thin-8re.384539/',
          },
          {
            title: 'MSI GS65 Stealth Thin - Full Review and Benchmarks',
            url: 'https://www.laptopmag.com/reviews/laptops/msi-gs65-stealth-thin',
          },
        ],
      },
      {
        text: '512GB SSD',
        confidence: 1,
        sources: [
          {
            title:
              'Questions and Answers: MSI GS Series Stealth 15.6" Gaming Laptop Intel Core i7 16GB Memory NVIDIA GeForce GTX 1660Ti 512GB SSD Matte Black With Gold Diamond Cut GS65 STEALTH-296',
            url: 'https://www.bestbuy.com/site/questions/msi-gs-series-stealth-15-6-gaming-laptop-intel-core-i7-16gb-memory-nvidia-geforce-gtx-1660ti-512gb-ssd-matte-black-with-gold-diamond-cut/6343295',
          },
          {
            title: 'MSI GS65 Stealth Thin Review',
            url: 'https://www.pcmag.com/reviews/msi-gs65-stealth-thin',
          },
          {
            title: 'A gaming laptop that does split-personality with style',
            url: 'https://www.cnet.com/reviews/msi-gs65-stealth-thin-review/',
          },
        ],
      },
      {
        text: '15.6 inches; 1,920x1,080; 144Hz refresh IPS',
        confidence: 1,
        sources: [
          {
            title: 'A gaming laptop that does split-personality with style',
            url: 'https://www.cnet.com/reviews/msi-gs65-stealth-thin-review/',
          },
        ],
      },
      {
        text: 'MSI advertises 8+ hours of battery life for the GS65 Stealth laptop.',
        confidence: 1,
        sources: [
          {
            title: 'Review: 2019 MSI GS65 w/RTX 2080 Max-Q',
            url: 'https://www.theeverydayenthusiast.com/post/review-2019-msi-gs65',
          },
        ],
      },
    ],
    [
      {
        text: 'Razer Blade 15 - Best Overall Gaming Laptop',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'Razer',
        confidence: 1,
        sources: [
          {
            title:
              'Still the Best 15 inch Gaming Laptop - Razer Blade 15 💻 | Razer United States',
            url: 'https://www.razer.com/gaming-laptops/razer-blade-15',
          },
          {
            title:
              'Gaming Laptops - Laptop Computers for PC Gaming - Razer Blade💻 | Razer United States',
            url: 'https://www.razer.com/pc/gaming-laptops',
          },
          {
            title:
              'Razer Blade 15 (2022) Review: Still a Stylish Gaming Laptop for the Deep Pocketed',
            url: 'https://www.cnet.com/tech/computing/razer-blade-15-2022-review-still-a-stylish-gaming-laptop-for-the-deep-pocketed/',
          },
          {
            title: 'Amazon.com',
            url: 'https://www.amazon.com/Razer-Blade-Gaming-Laptop-Thunderbolt/dp/B09RBJC8Y9',
          },
          {
            title:
              'Amazon.com: Razer Blade 15 Advanced Gaming Laptop 2020: Intel Core i7-10875H 8-Core, NVIDIA GeForce RTX 2070 Super Max-Q, 15.6” FHD 300Hz, 16GB RAM, 512GB SSD, CNC Aluminum, Chroma RGB Lighting, Thunderbolt 3 : Everything Else',
            url: 'https://www.amazon.com/Razer-Blade-Advanced-Gaming-Laptop/dp/B086M8PQYR',
          },
          {
            title:
              'What sets the Razer Blade 15 Advanced apart from other gaming laptops?',
            url: 'https://www.quora.com/What-sets-the-Razer-Blade-15-Advanced-apart-from-other-gaming-laptops',
          },
          {
            title:
              'World’s Smallest Gaming Laptop - The Razer Blade 15 | Razer United States',
            url: 'https://www.razer.com/gaming-laptops/razer-blade-2020',
          },
          {
            title:
              'Razer Blade 15 (2022) Review - The Best Built Gaming Laptop!',
            url: 'https://www.youtube.com/watch?v=Pe_gC8nuX2w',
          },
          {
            title:
              'Razer Blade 15 (2022) Review - The Best Built Gaming Laptop!',
            url: 'https://www.youtube.com/watch?v=Pe_gC8nuX2w',
          },
          {
            title: 'The best Razer laptops in 2024',
            url: 'https://www.gamesradar.com/razer-laptops/',
          },
          {
            title:
              'The Razer Blade 15 - The Most Powerful Gaming Laptop | Razer United States',
            url: 'https://www.razer.com/gaming-laptops/razer-blade-15-2022',
          },
        ],
      },
      {
        text: '$2,499 / £2,499 for the baseline model featuring an RTX 4060 graphics card and Intel Core i7-13800H CPU',
        confidence: 1,
        sources: [
          {
            title: 'The best Razer Blade gaming laptop deals for March 2024',
            url: 'https://www.techradar.com/deals/razer-blade-laptop-deals-sales-price',
          },
        ],
      },
      {
        text: 'Intel Core i7-12800H',
        confidence: 1,
        sources: [
          {
            title:
              'Razer Blade 15 review: One click makes this sublime gaming laptop even faster',
            url: 'https://www.pcworld.com/article/1064746/razer-blade-15-review-2.html',
          },
          {
            title:
              'Razer Blade 15 (2022) Review: Still a Stylish Gaming Laptop for the Deep Pocketed',
            url: 'https://www.cnet.com/tech/computing/razer-blade-15-2022-review-still-a-stylish-gaming-laptop-for-the-deep-pocketed/',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title:
              'Razer Blade 15 (2022) Review: Still a Stylish Gaming Laptop for the Deep Pocketed',
            url: 'https://www.cnet.com/tech/computing/razer-blade-15-2022-review-still-a-stylish-gaming-laptop-for-the-deep-pocketed/',
          },
          {
            title: 'Razer Blade 15” Base (2020)',
            url: 'https://mysupport.razer.com/app/answers/detail/a_id/3641/~/razer-blade-15%E2%80%9D-base-%282020%29-%7C-rz09-0328x-support-%26-faqs',
          },
        ],
      },
      {
        text: '512 GB SSD (M.2 NVMe), Open M.2 PCIe 3.0 x4 Slot',
        confidence: 1,
        sources: [
          {
            title: 'Razer Blade 15” Base (2020)',
            url: 'https://mysupport.razer.com/app/answers/detail/a_id/3641/~/razer-blade-15%E2%80%9D-base-%282020%29-%7C-rz09-0328x-support-%26-faqs',
          },
        ],
      },
      {
        text: '15.6-inch 1,920x1,080 360Hz matte display',
        confidence: 1,
        sources: [
          {
            title:
              'Razer Blade 15 (2022) Review: Still a Stylish Gaming Laptop for the Deep Pocketed',
            url: 'https://www.cnet.com/tech/computing/razer-blade-15-2022-review-still-a-stylish-gaming-laptop-for-the-deep-pocketed/',
          },
        ],
      },
      {
        text: 'The advertised battery life for the Razer Blade 15 gaming laptop is not explicitly stated in the given sources.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'Lenovo IdeaPad Gaming 3 - 2022 - Everyday Gaming Laptop',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'Lenovo',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: '$659.99',
        confidence: 1,
        sources: [
          {
            title: 'Lenovo Ideapad Gaming',
            url: 'https://www.walmart.com/c/kp/lenovo-ideapad-gaming',
          },
        ],
      },
      {
        text: 'The Lenovo IdeaPad Gaming 3 - 2022 model has an AMD Ryzen 5 6600H processor.',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: Lenovo IdeaPad Gaming 3 - (2022) - Essential Gaming Laptop Computer - 15.6" FHD - 120Hz - AMD Ryzen 5 6600H - NVIDIA GeForce RTX 3050 - 8GB DDR5 RAM - 256GB NVMe Storage - Windows 11 Home : Electronics',
            url: 'https://www.amazon.com/Lenovo-IdeaPad-Essential-Computer-Graphics/dp/B09RND1LP2',
          },
          {
            title: 'Lenovo IdeaPad Gaming 3 (2022) Review',
            url: 'https://www.pcmag.com/reviews/lenovo-ideapad-gaming-3-2022',
          },
        ],
      },
      {
        text: '8GB DDR5 RAM',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: Lenovo IdeaPad Gaming 3 - (2022) - Essential Gaming Laptop Computer - 15.6" FHD - 120Hz - AMD Ryzen 5 6600H - NVIDIA GeForce RTX 3050 - 8GB DDR5 RAM - 256GB NVMe Storage - Windows 11 Home : Electronics',
            url: 'https://www.amazon.com/Lenovo-IdeaPad-Essential-Computer-Graphics/dp/B09RND1LP2',
          },
        ],
      },
      {
        text: '256GB',
        confidence: 1,
        sources: [
          {
            title: 'Lenovo IdeaPad Gaming 3 (2022) Review',
            url: 'https://www.pcmag.com/reviews/lenovo-ideapad-gaming-3-2022',
          },
          {
            title: 'Lenovo IdeaPad Gaming 3 Review: 1080p Gaming for $700?',
            url: 'https://www.tomshardware.com/reviews/lenovo-ideapad-gaming-3',
          },
        ],
      },
      {
        text: 'The Lenovo IdeaPad Gaming 3 (2022) has a 15.6" FHD (1920 x 1080) display with a 120Hz refresh rate and anti-glare surface.',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: Lenovo IdeaPad Gaming 3 - (2022) - Essential Gaming Laptop Computer - 15.6" FHD - 120Hz - AMD Ryzen 5 6600H - NVIDIA GeForce RTX 3050 - 8GB DDR5 RAM - 256GB NVMe Storage - Windows 11 Home : Electronics',
            url: 'https://www.amazon.com/Lenovo-IdeaPad-Essential-Computer-Graphics/dp/B09RND1LP2',
          },
          {
            title:
              'Amazon.com: Lenovo IdeaPad Gaming 3i - 2022 - Everyday Gaming Laptop - NVIDIA GeForce RTX 3050Ti Graphics - 15.6" FHD Display - 8GB Memory - 512GB Storage - Intel i7 12th Gen - Onyx Grey : Electronics',
            url: 'https://www.amazon.com/Lenovo-IdeaPad-Gaming-3i-Everyday/dp/B0B4PQNGDM',
          },
          {
            title:
              'Best Buy: Lenovo Ideapad Gaming 3 15.6" FHD Laptop Ryzen 5 5600H 8GB Memory NVIDIA GeForce RTX 3050 Ti 256GB SSD Shadow Black 82K201XCUS',
            url: 'https://www.bestbuy.com/site/lenovo-ideapad-gaming-3-15-6-fhd-laptop-ryzen-5-5600h-8gb-memory-nvidia-geforce-rtx-3050-ti-256gb-ssd-shadow-black/6513216.p?skuId=6513216',
          },
        ],
      },
      {
        text: 'The advertised battery life of the Lenovo IdeaPad Gaming 3 (2022) is not explicitly stated in the given sources.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'ASUS TUF F15 Gaming Laptop',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'ASUS',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: '$799',
        confidence: 1,
        sources: [
          {
            title:
              'Asus TUF Gaming F15 hits lowest price ever at $799 in Amazon Big Spring Sale deal [Update]',
            url: 'https://www.laptopmag.com/deals/gaming-laptops-pcs/asus-tuf-gaming-f15-hits-lowest-price-ever-at-dollar799-in-amazon-big-spring-sale-deal',
          },
        ],
      },
      {
        text: 'Armed for combat, the TUF Gaming F15 features up to a 10th Gen Intel® Core™ i7 CPU with 6 cores and 12 threads to tear through serious gaming, streaming, and heavy duty multitasking. Paired with up to a GeForce® GTX 1660 Ti discrete GPU, it can pump out reliably high frame rates in a wide range of games.',
        confidence: 1,
        sources: [
          {
            title: 'ASUS TUF Gaming F15｜Laptops For Gaming｜ASUS USA',
            url: 'https://www.asus.com/us/laptops/for-gaming/tuf-gaming/asus-tuf-gaming-f15/',
          },
        ],
      },
      {
        text: '8GB DDR4-3200Mhz RAM',
        confidence: 1,
        sources: [
          {
            title: 'TUF F15 FX506HM with 128GB maximum RAM capacity?',
            url: 'https://rog-forum.asus.com/t5/tuf-asus-gaming-notebooks/tuf-f15-fx506hm-with-128gb-maximum-ram-capacity/td-p/938219',
          },
          {
            title:
              'ASUS TUF Gaming F15 - Tech Specs｜Laptops For Gaming｜ASUS USA',
            url: 'https://www.asus.com/us/laptops/for-gaming/tuf-gaming/asus-tuf-gaming-f15/techspec/',
          },
          {
            title: 'Max Ram Supported on Asus TUF Gaming F15 Laptop (FX506HF)',
            url: 'https://rog-forum.asus.com/t5/tuf-asus-gaming-notebooks/max-ram-supported-on-asus-tuf-gaming-f15-laptop-fx506hf/td-p/956474',
          },
        ],
      },
      {
        text: '512GB',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: ASUS TUF F15 Gaming Laptop, 15.6" 144Hz FHD IPS-Type Display, Intel Core i5-10300H Processor, GeForce GTX 1650, 8GB DDR4 RAM, 512GB PCIe SSD, Wi-Fi 6, Windows 11 Home, FX506LH-AS51 : Electronics',
            url: 'https://www.amazon.com/ASUS-IPS-Type-i5-10300H-Processor-FX506LH-AS51/dp/B09SVQ25XH',
          },
          {
            title: 'TUF F15 FX506HM with 128GB maximum RAM capacity?',
            url: 'https://rog-forum.asus.com/t5/tuf-asus-gaming-notebooks/tuf-f15-fx506hm-with-128gb-maximum-ram-capacity/td-p/938219',
          },
        ],
      },
      {
        text: '15.6" 144Hz FHD IPS-Type Display, 1920 x 1080 resolution',
        confidence: 1,
        sources: [
          {
            title: 'ASUS TUF Gaming F15｜Laptops For Gaming｜ASUS USA',
            url: 'https://www.asus.com/us/laptops/for-gaming/tuf-gaming/asus-tuf-gaming-f15/',
          },
          {
            title:
              'Amazon.com: ASUS TUF F15 Gaming Laptop, 15.6" 144Hz FHD IPS-Type Display, Intel Core i5-10300H Processor, GeForce GTX 1650, 8GB DDR4 RAM, 512GB PCIe SSD, Wi-Fi 6, Windows 11 Home, FX506LH-AS51 : Electronics',
            url: 'https://www.amazon.com/ASUS-IPS-Type-i5-10300H-Processor-FX506LH-AS51/dp/B09SVQ25XH',
          },
          {
            title:
              'Amazon.com: ASUS TUF Gaming F15 Gaming Laptop, 15.6” 144Hz FHD IPS-Type Display, Intel Core i7-11800H Processor, GeForce RTX 3060, 16GB DDR4 RAM, 1TB PCIe SSD, Wi-Fi 6, Windows 10 Home, TUF506HM-ES76 : Electronics',
            url: 'https://www.amazon.com/ASUS-IPS-Type-i7-11800H-Processor-TUF506HM-ES76/dp/B096VBG93J',
          },
          {
            title: 'ASUS TUF F15 FX507VU ES93 Gaming Laptop: iBUYPOWER®',
            url: 'https://www.ibuypower.com/store/asus-tuf-f15-fx507vu-es93-gaming-laptop',
          },
        ],
      },
      {
        text: 'The advertised battery life of the ASUS TUF F15 gaming laptop is likely around 8-10 hours for general usage based on the reviews mentioning battery test results in that range.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'Acer Nitro 5 AN515-57-79TD Gaming Laptop',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'Acer',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'The starting price for the Acer Nitro 5 AN515-57-79TD Gaming Laptop is likely around $800 to $1000 based on typical pricing for laptops with similar specs.',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Intel Core i7-11800H',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: Acer Nitro 5 AN515-57-79TD Gaming Laptop | Intel Core i7-11800H | NVIDIA GeForce RTX 3050 Ti Laptop GPU | 15.6" FHD 144Hz IPS Display | 8GB DDR4 | 512GB NVMe SSD | Killer Wi-Fi 6 | Backlit Keyboard : Electronics',
            url: 'https://www.amazon.com/Acer-AN515-57-79TD-i7-11800H-GeForce-Keyboard/dp/B09R65RN43',
          },
          {
            title: 'AN515-57-79TD - Tech Specs | Laptops | Acer United States',
            url: 'https://www.acer.com/us-en/laptops/nitro/nitro-5/pdp/NH.QESAA.005',
          },
          {
            title:
              'Amazon.com: Acer Nitro 5 AN515-57-79TD, Intel i7-11800H, NVIDIA GeForce RTX 3050 Ti, 15.6" FHD 144Hz IPS Display, 8GB DDR4, 512GB SSD, Killer Wi-Fi 6 with Crucial 8GB DDR4 3200MHz CL22 Laptop Memory CT8G4SFRA32A : Electronics',
            url: 'https://www.amazon.com/Acer-AN515-57-79TD-i7-11800H-GeForce-CT8G4SFRA32A/dp/B0BDKVXXH1',
          },
          {
            title: 'Robot or human?',
            url: 'https://www.walmart.com/ip/Acer-Nitro-5-AN515-57-79TD-Gaming-Laptop-Intel-Core-i7-11800H-NVIDIA-GeForce-RTX-3050-Ti-GPU-15-6-FHD-144Hz-IPS-Display-8GB-DDR4-512GB-NVMe-SSD-Kille/1986958693',
          },
          {
            title: 'Acer Nitro 5 AN515-57 review (Intel Core i7 + RTX)',
            url: 'https://www.ultrabookreview.com/48602-acer-nitro-5-an515-57/',
          },
        ],
      },
      {
        text: '8 GB',
        confidence: 1,
        sources: [
          {
            title: 'AN515-57-79TD - Tech Specs | Laptops | Acer United States',
            url: 'https://www.acer.com/us-en/laptops/nitro/nitro-5/pdp/NH.QESAA.005',
          },
        ],
      },
      {
        text: '512 GB',
        confidence: 1,
        sources: [
          {
            title: 'AN515-57-79TD - Tech Specs | Laptops | Acer United States',
            url: 'https://www.acer.com/us-en/laptops/nitro/nitro-5/pdp/NH.QESAA.005',
          },
        ],
      },
      {
        text: '15.6 inches, 1920 x 1080 pixels, 144 Hz refresh rate, IPS LCD',
        confidence: 1,
        sources: [
          {
            title: 'AN515-57-79TD - Tech Specs | Laptops | Acer United States',
            url: 'https://www.acer.com/us-en/laptops/nitro/nitro-5/pdp/NH.QESAA.005',
          },
          {
            title: 'Acer Nitro 5 AN515-57: full specs, tests and user reviews',
            url: 'https://nanoreview.net/en/laptop/acer-nitro-5-an515-57',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
    ],
    [
      {
        text: 'ASUS TUF Dash 15 (2022) Gaming Laptop',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'ASUS',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: '$1,000',
        confidence: 1,
        sources: [
          {
            title: 'Asus TUF Dash F15 (2022) Review',
            url: 'https://reviewed.usatoday.com/laptops/content/asus-tuf-dash-f15-2022-review',
          },
          {
            title:
              'Asus TUF Dash F15 review (FX517ZM model - Core i7-12650H, RTX 3060)',
            url: 'https://www.ultrabookreview.com/55313-asus-tuf-dash-f15-review-2022/',
          },
          {
            title: 'Asus TUF Dash F15 (2022)',
            url: 'https://www.techradar.com/reviews/asus-tuf-dash-F15-2022-new',
          },
        ],
      },
      {
        text: 'The ASUS TUF Dash 15 (2022) Gaming Laptop is available with the following CPUs:\n    - Intel Core i5-12450H (8 cores: 4 P-cores and 4 E-cores, up to 4.4 GHz, 12MB cache)\n    - Intel Core i7-12650H (10 cores: 6 P-cores and 4 E-cores, up to 4.7 GHz, 24MB cache)',
        confidence: 1,
        sources: [
          {
            title: 'ASUS TUF Dash F15 (2022)',
            url: 'https://www.asus.com/us/laptops/for-gaming/tuf-gaming/asus-tuf-dash-f15-2022/techspec/',
          },
          {
            title:
              'Amazon.com: ASUS TUF Dash 15 (2022) Gaming Laptop, 15.6" 144Hz FHD Display, Intel Core i7-12650H, GeForce RTX 3060, 16GB DDR5, 512GB SSD, Thunderbolt 4, Windows 11 Home, Off Black, FX517ZM-AS73 : Everything Else',
            url: 'https://www.amazon.com/ASUS-Display-i7-12650H-Thunderbolt-FX517ZM-AS73/dp/B09RMH9B6F',
          },
          {
            title: 'ASUS TUF Dash F15 (2022)',
            url: 'https://www.asus.com/ph/laptops/for-gaming/tuf-gaming/asus-tuf-dash-f15-2022/techspec/',
          },
          {
            title:
              'ASUS TUF Dash F15 (2022) Gaming Laptop, Intel Core i7-12650H, 16GB Ram, 512GB SSD - Foretec Marketplace',
            url: 'https://foreteconline.com/product/asus-tuf-dash-f15-2022-gaming-laptop-intel-core-i7-12650h-16gb-ram-512gb-ssd/',
          },
          {
            title: 'ASUS TUF Dash F15 (2022) Review',
            url: 'https://www.rtings.com/laptop/reviews/asus/tuf-dash-f15-2022',
          },
        ],
      },
      {
        text: '8GB DDR5-4800, SO-DIMM x 2 slot, Max Capacity: 32GB\n16GB DDR5-4800, SO-DIMM x 2 slot, Max Capacity: 32GB',
        confidence: 1,
        sources: [
          {
            title: 'ASUS TUF Dash F15 (2022)',
            url: 'https://www.asus.com/us/laptops/for-gaming/tuf-gaming/asus-tuf-dash-f15-2022/techspec/',
          },
          {
            title:
              'Amazon.com: ASUS TUF Dash F15 Gaming Laptop (15.6 inches 144Hz, Intel 12th Gen i7-12650H, 16GB DDR5 RAM, 512GB PCle SSD, Geforce RTX 3070 8GB), Thunderbolt 4, Backlit KB, WiFi 6, IST Cable, Win 11 Home - Black : Electronics',
            url: 'https://www.amazon.com/ASUS-TUF-Dash-F15-Thunderbolt/dp/B0C9HLC45Y',
          },
        ],
      },
      {
        text: '512GB M.2 NVMe PCIe 3.0 SSD',
        confidence: 1,
        sources: [
          {
            title: 'ASUS TUF Dash F15 (2022)',
            url: 'https://www.asus.com/us/laptops/for-gaming/tuf-gaming/asus-tuf-dash-f15-2022/techspec/',
          },
          {
            title:
              'Amazon.com: ASUS TUF Dash 15 (2022) Gaming Laptop, 15.6" 144Hz FHD Display, Intel Core i7-12650H, GeForce RTX 3060, 16GB DDR5, 512GB SSD, Thunderbolt 4, Windows 11 Home, Off Black, FX517ZM-AS73 : Everything Else',
            url: 'https://www.amazon.com/ASUS-Display-i7-12650H-Thunderbolt-FX517ZM-AS73/dp/B09RMH9B6F',
          },
        ],
      },
      {
        text: '15.6-inch, FHD (1920 x 1080) 16:9, anti-glare display, sRGB:62.5%, Adobe:47.34%, Refresh Rate:144Hz, IPS-level, Adaptive-Sync, MUX Switch + Optimus\n15.6-inch, WQHD (2560 x 1440) 16:9, anti-glare display, DCI-P3:100, Refresh Rate:165Hz, Response Time:3ms, IPS-level, Adaptive-Sync, MUX Switch + Optimus\n15.6-inch, FHD (1920 x 1080) 16:9, anti-glare display, sRGB:100%, Adobe:75.35%, Refresh Rate:300Hz, IPS-level, Adaptive-Sync, MUX Switch + Optimus',
        confidence: 1,
        sources: [
          {
            title: 'ASUS TUF Dash F15 (2022)',
            url: 'https://www.asus.com/us/laptops/for-gaming/tuf-gaming/asus-tuf-dash-f15-2022/techspec/',
          },
          {
            title: 'ASUS TUF Dash F15 (2022)｜Laptops For Gaming｜ASUS USA',
            url: 'https://www.asus.com/us/laptops/for-gaming/tuf-gaming/asus-tuf-dash-f15-2022/',
          },
          {
            title: 'ASUS TUF Gaming F15 (2022)｜Laptops For Gaming｜ASUS USA',
            url: 'https://www.asus.com/us/laptops/for-gaming/tuf-gaming/asus-tuf-gaming-f15-2022/',
          },
          {
            title: 'ASUS TUF Dash F15 (2022) Review',
            url: 'https://www.rtings.com/laptop/reviews/asus/tuf-dash-f15-2022',
          },
        ],
      },
      {
        text: 'The advertised battery life of the ASUS TUF Dash 15 (2022) gaming laptop is not explicitly stated in the given sources.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'MSI Titan GT77 17.3" UHD 120Hz Gaming Laptop',
        confidence: 1,
        sources: [
          {
            title: '▷ BestGamingLaptopPro.com - By Price and Brand',
            url: 'https://bestgaminglaptoppro.com/',
          },
        ],
      },
      {
        text: 'MSI',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: MSI Titan GT77 17.3" UHD 120Hz Gaming Laptop: Intel Core i9-12900HX RTX 3080 Ti 64GB DDR5 2TB NVMe SSD, Thunderbolt 4, USB-Type C, Cooler Boost Titan, Win11 Pro: Core Black 12UHS-006 : Electronics',
            url: 'https://www.amazon.com/MSI-Titan-120Hz-Gaming-Laptop/dp/B0B444CTHL',
          },
          {
            title:
              'Amazon.com: MSI Titan GT77 17.3" UHD 120Hz Gaming Laptop: Intel Core i7-12800HX RTX 3080 Ti 32GB DDR5 1TB NVMe SSD, Thunderbolt 4, USB-Type C, Cooler Boost Titan, Win11 Pro: Core Black 12UHS-007 : Electronics',
            url: 'https://www.amazon.com/MSI-Titan-120Hz-Gaming-Laptop/dp/B0B43N5K3D',
          },
          {
            title: 'MSI Titan GT77 12UX - Total Dominance',
            url: 'https://us.msi.com/Laptop/Titan-GT77-12UX',
          },
          {
            title: 'MSI Titan GT77 HX 13V - Total Dominance',
            url: 'https://www.msi.com/Laptop/Titan-GT77-HX-13VX',
          },
          {
            title: 'MSI Titan GT77 12UX - Total Dominance',
            url: 'https://us.msi.com/Laptop/Titan-GT77-12UX/Specification',
          },
          {
            title: 'MSI Titan GT77 HX - Total Dominance',
            url: 'https://us.msi.com/Laptop/Titan-GT77-HX-13VX',
          },
        ],
      },
      {
        text: '$3,199.00',
        confidence: 1,
        sources: [
          {
            title: 'MSI GT77 Titan Review',
            url: 'https://www.pcmag.com/reviews/msi-gt77-titan',
          },
          {
            title:
              'MSI TITAN GT77 17.3" UHD 120Hz Gaming Laptop Intel Core i7-12800HX RTX3080TI 32GBDDR5 1TB NVMe SSD Win11PRO (12UHS-007)',
            url: 'https://www.mobileadvance.com/msi-titan-gt77-17-3-uhd-120hz-gaming-laptop-intel-core-i7-12800hx-rtx3080ti-32gbddr5-1tb-nvme-ssd-win11pro-12uhs-007/',
          },
        ],
      },
      {
        text: 'Intel Core i9-12900HX',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: MSI Titan GT77 17.3" UHD 120Hz Gaming Laptop: Intel Core i9-12900HX RTX 3080 Ti 64GB DDR5 2TB NVMe SSD, Thunderbolt 4, USB-Type C, Cooler Boost Titan, Win11 Pro: Core Black 12UHS-006 : Electronics',
            url: 'https://www.amazon.com/MSI-Titan-120Hz-Gaming-Laptop/dp/B0B444CTHL',
          },
          {
            title: 'MSI GT77 Titan Review',
            url: 'https://www.pcmag.com/reviews/msi-gt77-titan',
          },
          {
            title: 'MSI Titan GT77 12U - Total Dominance',
            url: 'https://www.msi.com/Laptop/Titan-GT77-12UX/Specification',
          },
        ],
      },
      {
        text: '32GB',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: MSI Titan GT77 17.3" UHD 120Hz Gaming Laptop: Intel Core i7-12800HX RTX 3080 Ti 32GB DDR5 1TB NVMe SSD, Thunderbolt 4, USB-Type C, Cooler Boost Titan, Win11 Pro: Core Black 12UHS-007 : Electronics',
            url: 'https://www.amazon.com/MSI-Titan-120Hz-Gaming-Laptop/dp/B0B43N5K3D',
          },
        ],
      },
      {
        text: '1TB',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: MSI Titan GT77 17.3" UHD 120Hz Gaming Laptop: Intel Core i7-12800HX RTX 3080 Ti 32GB DDR5 1TB NVMe SSD, Thunderbolt 4, USB-Type C, Cooler Boost Titan, Win11 Pro: Core Black 12UHS-007 : Electronics',
            url: 'https://www.amazon.com/MSI-Titan-120Hz-Gaming-Laptop/dp/B0B43N5K3D',
          },
        ],
      },
      {
        text: '17.3" UHD (3840x2160)',
        confidence: 1,
        sources: [
          {
            title: 'MSI Titan GT77 HX 13V - Total Dominance',
            url: 'https://www.msi.com/Laptop/Titan-GT77-HX-13VX',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
    ],
    [
      {
        text: 'ASUS L406 - Best Lightweight Laptop Under $400',
        confidence: 1,
        sources: [
          {
            title:
              'Best Laptop Under $400 In 2023 - Top Picks Review - TinyGrab 🔥',
            url: 'https://tinygrab.com/best-laptops-under-400/',
          },
        ],
      },
      {
        text: 'ASUS',
        confidence: 1,
        sources: [
          {
            title:
              'Best Laptop Under $400 In 2023 - Top Picks Review - TinyGrab 🔥',
            url: 'https://tinygrab.com/best-laptops-under-400/',
          },
        ],
      },
      {
        text: '$399',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Running this laptop is the ultra-efficient dual-core Intel Celeron N4000 processor. To conserve power and keep things cool, the processor idles at 1.1GHz but then can boost to 2.6GHz for more demanding tasks.',
        confidence: 1,
        sources: [
          {
            title:
              'Best Laptop Under $400 In 2023 - Top Picks Review - TinyGrab 🔥',
            url: 'https://tinygrab.com/best-laptops-under-400/',
          },
        ],
      },
      {
        text: '4GB',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: ASUS Laptop L406 Thin and Light Laptop, 14” HD Display, Intel Celeron N4000 Processor, 4GB RAM, 64GB eMMC Storage, Wi-Fi 5, Windows 10, Microsoft 365, Slate Gray, L406MA-WH02 : Electronics',
            url: 'https://www.amazon.com/ASUS-Display-Processor-Microsoft-L406MA-WH02/dp/B0892WCGZM',
          },
          {
            title:
              'Amazon.com: ASUS VivoBook L203MA Ultra-Thin Laptop, Intel Celeron N4000 Processor, 4GB LPDDR4, 64GB eMMC, 11.6” HD, USB-C, Windows 10 in S Mode (Switchable to Pro), L203MA-DS04, One Year of Microsoft Office 365 : Electronics',
            url: 'https://www.amazon.com/ASUS-Ultra-Thin-Processor-L203MA-DS04-Microsoft/dp/B07N6S4SY1',
          },
          {
            title:
              'The best cheap Windows laptops for 2024: Acer, Dell and more compared',
            url: 'https://www.zdnet.com/article/best-cheap-windows-laptop/',
          },
          {
            title: 'Asus Laptop L410 (L410MA-DB02) Review',
            url: 'https://www.pcmag.com/reviews/asus-laptop-l410-l410ma-db02',
          },
        ],
      },
      {
        text: '64GB eMMC Storage',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: ASUS Laptop L406 Thin and Light Laptop, 14” HD Display, Intel Celeron N4000 Processor, 4GB RAM, 64GB eMMC Storage, Wi-Fi 5, Windows 10, Microsoft 365, Slate Gray, L406MA-WH02 : Electronics',
            url: 'https://www.amazon.com/ASUS-Display-Processor-Microsoft-L406MA-WH02/dp/B0892WCGZM',
          },
          {
            title: 'Robot or human?',
            url: 'https://www.walmart.com/ip/Restored-ASUS-Laptop-L406-Thin-Light-Laptop-14-HD-Display-Intel-Celeron-N4000-Processor-4GB-RAM-64GB-eMMC-Storage-WiFi-5-Windows-10-S-Slate-Gray-L406/153749169',
          },
          {
            title: 'Asus Laptop L410 (L410MA-DB02) Review',
            url: 'https://www.pcmag.com/reviews/asus-laptop-l410-l410ma-db02',
          },
        ],
      },
      {
        text: '14" HD Display, Intel Celeron N4000 Processor, 4GB RAM, 64GB eMMC Storage',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: ASUS Laptop L406 Thin and Light Laptop, 14” HD Display, Intel Celeron N4000 Processor, 4GB RAM, 64GB eMMC Storage, Wi-Fi 5, Windows 10, Microsoft 365, Slate Gray, L406MA-WH02 : Electronics',
            url: 'https://www.amazon.com/ASUS-Display-Processor-Microsoft-L406MA-WH02/dp/B0892WCGZM',
          },
          {
            title: 'Robot or human?',
            url: 'https://www.walmart.com/ip/Restored-Asus-L406-Laptop-L406MA-WH02-Slate-Gray-Intel-Celeron-N4000-1-1GHz-4GB-14-64GB-SSD-Refurbished/278092009',
          },
          {
            title: 'Robot or human?',
            url: 'https://www.walmart.com/ip/Restored-Asus-L406-Laptop-L406MA-WH02-Slate-Gray-Intel-Celeron-N4000-1-1GHz-4GB-14-64GB-SSD-Refurbished/370128042',
          },
        ],
      },
      {
        text: 'The vendor claimed battery lifetime for the ASUS L406 laptop is "up to 13hr" according to the sources.',
        confidence: 1,
        sources: [
          {
            title: 'Asus L406 user experience',
            url: 'http://www.galexander.org/laptops/l406/',
          },
        ],
      },
    ],
    [
      {
        text: 'Acer Swift X SFX14-41G-R1S6 Creator Laptop',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'Acer',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '$1,099.99',
        confidence: 1,
        sources: [
          {
            title: 'Acer Swift X (AMD) Review',
            url: 'https://www.pcmag.com/reviews/acer-swift-x-amd',
          },
        ],
      },
      {
        text: 'AMD Ryzen 7 5800U',
        confidence: 1,
        sources: [
          {
            title: 'Acer Swift X 14 (2021) Review',
            url: 'https://reviewed.usatoday.com/laptops/content/acer-swift-x-sfx14-41g-r1s6-review',
          },
          {
            title: 'Acer Swift X review: A rare ultraportable laptop with bite',
            url: 'https://www.pcworld.com/article/395111/acer-swift-x-review-a-rare-ultraportable-laptop-with-bite.html',
          },
          {
            title: 'Acer Swift X (AMD) Review',
            url: 'https://www.pcmag.com/reviews/acer-swift-x-amd',
          },
        ],
      },
      {
        text: '16 GB LPDDR4X',
        confidence: 1,
        sources: [
          {
            title: 'SFX14-41G-R1S6 - RAM Upgrade',
            url: 'https://community.acer.com/en/discussion/652533/sfx14-41g-r1s6-ram-upgrade',
          },
          {
            title:
              'Acer Swift X (SFX14-41G): full specs, tests and user reviews',
            url: 'https://nanoreview.net/en/laptop/acer-swift-x-2021',
          },
        ],
      },
      {
        text: '512 GB',
        confidence: 1,
        sources: [
          {
            title: 'SFX14-41G-R1S6 - RAM Upgrade',
            url: 'https://community.acer.com/en/discussion/652533/sfx14-41g-r1s6-ram-upgrade',
          },
          {
            title: 'Acer Swift X (AMD) Review',
            url: 'https://www.pcmag.com/reviews/acer-swift-x-amd',
          },
          {
            title: 'Acer Swift X review: A rare ultraportable laptop with bite',
            url: 'https://www.pcworld.com/article/395111/acer-swift-x-review-a-rare-ultraportable-laptop-with-bite.html',
          },
        ],
      },
      {
        text: '14" Full HD 100% sRGB',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'The Acer Swift X SFX14-41G-R1S6 laptop is advertised to provide up to 17 hours of battery life based on MobileMark 2014 test results.',
        confidence: 1,
        sources: [
          {
            title:
              'Acer Swift X (2021) review: A lot of power for a three-pound laptop',
            url: 'https://www.xda-developers.com/acer-swift-x-2021-review/',
          },
        ],
      },
    ],
    [
      {
        text: 'ASUS ZenBook UX534FAC 4K Laptop',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'ASUS',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'The starting price for the ASUS ZenBook UX534FAC 4K laptop is around 1500 EUR or $1399 USD for the i7/16GB RAM/512GB SSD/FHD screen variant. The 4K UHD panel will likely have a $200-300 premium over the FHD model.',
        confidence: 0.3,
        sources: [
          {
            title:
              'Asus ZenBook 15 UX534 review (UX534FTC - Core i7, GTX 1650, 4K or FHD screen)',
            url: 'https://www.ultrabookreview.com/31869-asus-zenbook-ux534-review/',
          },
        ],
      },
      {
        text: 'Intel i7-10510U',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '16 GB RAM',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '512 GB',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '15.6 Inch Ultra HD (4K)',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'Up to 15.3 hours battery life',
        confidence: 1,
        sources: [
          {
            title: 'ASUS Zenbook 15 UX534｜Laptops For Home｜ASUS USA',
            url: 'https://www.asus.com/us/laptops/for-home/zenbook/asus-zenbook-15-ux534/',
          },
        ],
      },
    ],
    [
      {
        text: 'ASUS ROG Strix Scar 17 (2022) Gaming Laptop',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'ASUS',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '$1,999 (starting); $2,499 (reviewed)',
        confidence: 1,
        sources: [
          {
            title: 'Asus ROG Strix Scar 17 (2022) G733Z review',
            url: 'https://www.laptopmag.com/reviews/asus-rog-strix-scar-17-2022-g733z-review',
          },
        ],
      },
      {
        text: 'AMD Ryzen 9 5900HX',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title:
              'ROG Strix SCAR 17 (2022) | Gaming Laptops｜ROG - Republic of Gamers｜ROG USA',
            url: 'https://rog.asus.com/us/laptops/rog-strix/rog-strix-scar-17-2022-series/spec/',
          },
          {
            title: 'DDR5 RAM Upgrade ||  2022 Asus ROG Strix Scar 17',
            url: 'https://www.youtube.com/watch?v=3jp7bek9Cok',
          },
        ],
      },
      {
        text: '1TB SSD',
        confidence: 1,
        sources: [
          {
            title: 'DDR5 RAM Upgrade ||  2022 Asus ROG Strix Scar 17',
            url: 'https://www.youtube.com/watch?v=3jp7bek9Cok',
          },
        ],
      },
      {
        text: '17.3" 360Hz IPS FHD',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'The ASUS ROG Strix Scar 17 (2022) has a 90 Wh 4-cell lithium-ion battery. ASUS claims it can last up to 10.5 hours of video playback and can be charged from 0 to 50% in 30 minutes using the supplied 280W/330W power adapter.',
        confidence: 1,
        sources: [
          {
            title:
              'ROG Strix SCAR 17 (2022) | Gaming Laptops｜ROG - Republic of Gamers｜ROG USA',
            url: 'https://rog.asus.com/us/laptops/rog-strix/rog-strix-scar-17-2022-series/',
          },
          {
            title:
              'ROG STRIX SCAR 17 SE (2022) G733 review: Perfect for gaming on the move',
            url: 'https://eftm.com/2023/04/rog-strix-scar-17-se-2022-g733-review-perfect-for-gaming-on-the-move-232818',
          },
        ],
      },
    ],
    [
      {
        text: 'Acer Swift 3 Thin & Light Laptop',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'Acer',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: "The 14-inch Swift 3 starts at $699.99 with an Intel Core i5 CPU, 8GB of RAM, and a 512GB solid-state drive. At the entry level, it's $850 for a 28-watt 12-core/16-thread Core i5-1540P running at up to 4.4GHz, with 16GB of RAM, a 512GB SSD, and a 14-inch 16:9 Full HD (1,920 x 1,080) IPS display. At the high end, the Swift 3 costs $1,130 for a 28-watt 12-core/16-watt Core i7-1260P with a Turbo boost of 4.7GHz, 16GB of RAM, a 1TB SSD, and a 14-inch 16:9 QHD IPS display. For example, at 2.7 pounds (1.2 kg), it's incredibly light for a 14-inch laptop at its $620 starting price.",
        confidence: 1,
        sources: [
          {
            title: 'Acer Swift 3 (2021) Review',
            url: 'https://www.pcmag.com/reviews/acer-swift-3-2021',
          },
          {
            title:
              'Acer Swift 3 (2022) review: a solid system for the price | Digital Trends',
            url: 'https://www.digitaltrends.com/computing/acer-swift-3-2022-review/',
          },
          {
            title:
              'Acer Swift 3 (14-inch, 2020) review: A featherweight laptop with performance to spare at a fair price',
            url: 'https://www.cnet.com/reviews/acer-swift-3-14-inch-2020-review/',
          },
        ],
      },
      {
        text: 'AMD Ryzen 7 4700U Octa-Core',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '8GB',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '512GB SSD',
        confidence: 1,
        sources: [
          {
            title: '',
            url: 'https://www.amazon.com/Acer-Octa-Core-Graphics-Fingerprint-SF314-42-R9YN/dp/B086KKKT15',
          },
          {
            title: 'Acer Swift 3 (2021) Review',
            url: 'https://www.pcmag.com/reviews/acer-swift-3-2021',
          },
          {
            title: 'Acer Swift 3 review',
            url: 'https://www.laptopmag.com/reviews/acer-swift-3-review',
          },
        ],
      },
      {
        text: '14" Full HD IPS',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'The sources do not explicitly state the advertised battery life of the Acer Swift 3 Thin & Light Laptop. However, based on the reviews and tests, it seems the battery life can range from around 3.5 hours for intensive tasks up to 11-14 hours for light usage like web browsing and video playback.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'Acer Aspire 5 A515-55-56VK Laptop',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'Acer',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '$463',
        confidence: 1,
        sources: [
          {
            title:
              'Acer Aspire 5 review: Intel Ice Lake comes to the budget Aspire line',
            url: 'https://www.pcworld.com/article/393517/acer-aspire-5-a515-55-56vk-review.html',
          },
        ],
      },
      {
        text: '10th Gen Intel Core i5-1035G1',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '4GB',
        confidence: 1,
        sources: [
          {
            title:
              '[SOLVED] - What is the maximum RAM capacity per slot allowed by Acer laptop A515-55-54SZ?',
            url: 'https://forums.tomshardware.com/threads/what-is-the-maximum-ram-capacity-per-slot-allowed-by-acer-laptop-a515-55-54sz.3752879/',
          },
        ],
      },
      {
        text: '256GB PCIe NVMe SSD',
        confidence: 1,
        sources: [
          {
            title: 'Acer Aspire 5 (2020) review',
            url: 'https://www.laptopmag.com/reviews/acer-aspire-5-2020',
          },
        ],
      },
      {
        text: '15.6" Full HD IPS Display',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'The advertised battery life for the Acer Aspire 5 A515-55-56VK laptop is around 8-12 hours, based on typical claims from Acer for the Aspire 5 series.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'Lenovo Legion 5 15 Gaming Laptop',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'Lenovo',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '$769',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'AMD Ryzen 7 5800H',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title:
              'LENOVO LEGION 5 MEMORY UPGRADE COMPLETE INSTALLATION GUIDE, REVIEW \\u0026 SPEED TESTS TRANSCEND JM3200HSE',
            url: 'https://www.youtube.com/watch?v=p75dvbZiR-A',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: '15.6" FHD (1920 x 1080) Display',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
    ],
    [
      {
        text: 'Acer Spin 5 Convertible Laptop',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'Acer',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '$999',
        confidence: 1,
        sources: [
          {
            title: 'Acer Spin 5 (2020) review',
            url: 'https://www.techradar.com/reviews/acer-spin-5-2020',
          },
          {
            title: 'Acer Spin 5 2020 review',
            url: 'https://www.laptopmag.com/reviews/acer-spin-5-2020-review',
          },
        ],
      },
      {
        text: '10th Gen Intel Core',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '16GB',
        confidence: 1,
        sources: [
          {
            title: 'RAM upgrade on the new Spin 5 SP515-51GN Kaby Lake R',
            url: 'https://community.acer.com/en/discussion/534338/ram-upgrade-on-the-new-spin-5-sp515-51gn-kaby-lake-r',
          },
          {
            title:
              'Amazon.com: Acer Spin 5 Convertible Laptop, 13.5" 2K 2256 x 1504 IPS Touch, 10th Gen Intel Core i7-1065G7, 16GB LPDDR4X, 512GB NVMe SSD, Wi-Fi 6, Backlit KB, FPR, Rechargeable Active Stylus, SP513-54N-74V2 : Electronics',
            url: 'https://www.amazon.com/Acer-Convertible-i7-1065G7-Rechargeable-SP513-54N-74V2/dp/B086KJCJDM',
          },
          {
            title: 'Acer Spin 5 (2022) Review',
            url: 'https://www.pcmag.com/reviews/acer-spin-5-2022',
          },
          {
            title: 'Acer Spin 5 2020 review',
            url: 'https://www.laptopmag.com/reviews/acer-spin-5-2020-review',
          },
          {
            title: 'Acer Spin 5 (2020) review',
            url: 'https://www.techradar.com/reviews/acer-spin-5-2020',
          },
        ],
      },
      {
        text: '512GB NVMe SSD',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: Acer Spin 5 Convertible Laptop, 13.5" 2K 2256 x 1504 IPS Touch, 10th Gen Intel Core i7-1065G7, 16GB LPDDR4X, 512GB NVMe SSD, Wi-Fi 6, Backlit KB, FPR, Rechargeable Active Stylus, SP513-54N-74V2 : Electronics',
            url: 'https://www.amazon.com/Acer-Convertible-i7-1065G7-Rechargeable-SP513-54N-74V2/dp/B086KJCJDM',
          },
          {
            title: 'Acer Spin 5 2020 review',
            url: 'https://www.laptopmag.com/reviews/acer-spin-5-2020-review',
          },
        ],
      },
      {
        text: '13.5" 2K 2256 x 1504 IPS Touch',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'The advertised battery life of the Acer Spin 5 convertible laptop is around 13 hours, but real-world usage seems to be lower, around 7-10 hours depending on tasks.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'Lenovo ThinkPad E15 Laptop',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'Lenovo',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
      {
        text: 'Intel Core i7-10510U Processor',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '16GB RAM',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '256GB or 512GB',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '15.6" FHD (1920x1080) IPS Anti-Glare Display',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'With the Intel Wi-Fi 6E support, a battery life of up to 8 hours and rapid charging feature, continue working from anywhere, unhindered. With 3 USB ports, including USB 3.2 Gen 1 and Thunderbolt 4, this device prepares users for any situation – whether plugging in for a quick client presentation or connecting to surrounding POS systems, external monitors and peripherals. Loaded with smart security features such as Discrete TPM 2.0 chip, Kensington locks and BIOS security, this device ensures crucial data is safe at all times. This entry-level ThinkPad is perfect for buyers looking to maximize the number of devices for their budget without compromising on device reliability or the productivity needs of their users.',
        confidence: 1,
        sources: [
          {
            title: '',
            url: 'https://most.lenovo.com/api/v2/library/pdf/device2pager/Device_ThinkPad_E15_Gen_4_Intel?locale=en',
          },
        ],
      },
    ],
    [
      {
        text: 'Acer Nitro 5 Gaming Laptop',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'Acer',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '$699',
        confidence: 1,
        sources: [
          {
            title: 'Acer Nitro 5 (2022) Review - IGN',
            url: 'https://www.ign.com/articles/acer-nitro-5-2022-review',
          },
        ],
      },
      {
        text: '9th Gen Intel Core i5-9300H',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '8GB',
        confidence: 1,
        sources: [
          {
            title: 'I want to upgrade my ram  Nitro 5 - AN515-57',
            url: 'https://community.acer.com/en/discussion/651519/i-want-to-upgrade-my-ram-nitro-5-an515-57',
          },
          {
            title: 'Maximum RAM supported by Acer nitro 5 AN515-54',
            url: 'https://community.acer.com/en/discussion/613499/maximum-ram-supported-by-acer-nitro-5-an515-54',
          },
        ],
      },
      {
        text: '256GB',
        confidence: 1,
        sources: [
          {
            title:
              'Amazon.com: Acer Nitro 5 Gaming Laptop, 9th Gen Intel Core i5-9300H, NVIDIA GeForce GTX 1650, 15.6" Full HD IPS Display, 8GB DDR4, 256GB NVMe SSD, Wi-Fi 6, Backlit Keyboard, Alexa Built-in, AN515-54-5812 : Electronics',
            url: 'https://www.amazon.com/Acer-i5-9300H-GeForce-Keyboard-AN515-54-5812/dp/B086KJBKDW',
          },
          {
            title:
              'I want to upgrade the storage for my Acer Nitro 5 A515-53 and I have a couple of questions',
            url: 'https://community.acer.com/en/discussion/660493/i-want-to-upgrade-the-storage-for-my-acer-nitro-5-a515-53-and-i-have-a-couple-of-questions',
          },
        ],
      },
      {
        text: '15.6" Full',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'The advertised battery life of the Acer Nitro 5 gaming laptop is around 5-7 hours according to Acer, but real-world usage shows it gets around 4-5 hours of battery life.',
        confidence: 0.3,
        sources: [],
      },
    ],
    [
      {
        text: 'MSI Prestige 14 A10SC-020 Laptop',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'MSI',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: 'The price of the MSI Prestige 14 A10SC-020 laptop is not explicitly stated in the given sources.',
        confidence: 0.3,
        sources: [],
      },
      {
        text: 'Intel Core i5-10210U',
        confidence: 1,
        sources: [
          {
            title: 'Smart Tech Laptops Reviews | Smart Tech Brief',
            url: 'https://www.smarttechbrief.com/category/smart-tech-laptops-reviews/',
          },
        ],
      },
      {
        text: '16 GB',
        confidence: 1,
        sources: [
          {
            title:
              'MSI Prestige 14 A10SC A10SC 020 14 Gaming Notebook 1920 x 1080 Intel Core i5 i5 10210U 1.60 GHz 16 GB RAM 512 GB SSD Gray with Blue Diamond Cut Windows 10 Pro NVIDIA GeForce GTX 1650 Max Q with 4 GB 10 Hour Battery - Office Depot',
            url: 'https://www.officedepot.com/a/products/6785504/MSI-Prestige-14-A10SC-A10SC-020/',
          },
          {
            title:
              'MSI Prestige 14 A10SC A10SC-020 14" Notebook - 1920 x 1080 - Intel Core i5 10th Gen i5-10210U 1.60 GHz - 16 GB Total RAM - 512 GB SSD - Gray with Blue Diamond Cut',
            url: 'https://buy.bluum.com/msi-prestige-14-a10sc-a10sc-020-14-notebook-1920-x-1080-intel-core-i5-10th-gen-i5-10210u-1-60-ghz-16-gb-total-ram-512-gb-ssd-gray-with-blue-diamond-cut/',
          },
          {
            title:
              'MSI Prestige 14 A10SC-020 14" Ultra Thin and Light Professional Laptop Intel Core i5-10210U GTX1650 MAX-Q 16GB DDR4 512GB NVMe SSD Win10 Pro',
            url: 'https://www.mobileadvance.com/msi-prestige-14-a10sc-020-14-ultra-thin-and-light-professional-laptop-intel-core-i5-10210u-gtx1650-max-q-16gb-ddr4-512gb-nvme-ssd-win10-pro/',
          },
          {
            title: 'MSI Prestige 14 – Create Timeless Moments',
            url: 'https://us.msi.com/Business-Productivity/Prestige-14-A10X-r/Specification',
          },
        ],
      },
      {
        text: '512 GB',
        confidence: 1,
        sources: [
          {
            title:
              'MSI Prestige 14 A10SC-020 14" Ultra Thin and Light Professional Laptop Intel Core i5-10210U GTX1650 MAX-Q 16GB DDR4 512GB NVMe SSD Win10 Pro',
            url: 'https://www.mobileadvance.com/msi-prestige-14-a10sc-020-14-ultra-thin-and-light-professional-laptop-intel-core-i5-10210u-gtx1650-max-q-16gb-ddr4-512gb-nvme-ssd-win10-pro/',
          },
          {
            title: 'MSI Prestige 14 – Create Timeless Moments',
            url: 'https://us.msi.com/Business-Productivity/Prestige-14-A10X-r/Specification',
          },
          {
            title:
              'MSI Prestige 14 A10SC A10SC 020 14 Gaming Notebook 1920 x 1080 Intel Core i5 i5 10210U 1.60 GHz 16 GB RAM 512 GB SSD Gray with Blue Diamond Cut Windows 10 Pro NVIDIA GeForce GTX 1650 Max Q with 4 GB 10 Hour Battery - Office Depot',
            url: 'https://www.officedepot.com/a/products/6785504/MSI-Prestige-14-A10SC-A10SC-020/',
          },
          {
            title:
              'MSI Prestige 14 A10SC A10SC-020 14" Notebook - 1920 x 1080 - Intel Core i5 10th Gen i5-10210U 1.60 GHz - 16 GB Total RAM - 512 GB SSD - Gray with Blue Diamond Cut',
            url: 'https://buy.bluum.com/msi-prestige-14-a10sc-a10sc-020-14-notebook-1920-x-1080-intel-core-i5-10th-gen-i5-10210u-1-60-ghz-16-gb-total-ram-512-gb-ssd-gray-with-blue-diamond-cut/',
          },
        ],
      },
      {
        text: '14" FHD (1920 x 1080), IPS level Anti-Glare Wide View Angle Thin Bezel 100% sRGB',
        confidence: 1,
        sources: [
          {
            title:
              'MSI Prestige 14 A10SC-020 14" Ultra Thin and Light Professional Laptop Intel Core i5-10210U GTX1650 MAX-Q 16GB DDR4 512GB NVMe SSD Win10 Pro',
            url: 'https://www.mobileadvance.com/msi-prestige-14-a10sc-020-14-ultra-thin-and-light-professional-laptop-intel-core-i5-10210u-gtx1650-max-q-16gb-ddr4-512gb-nvme-ssd-win10-pro/',
          },
          {
            title:
              'MSI Prestige 14 A10SC A10SC 020 14 Gaming Notebook 1920 x 1080 Intel Core i5 i5 10210U 1.60 GHz 16 GB RAM 512 GB SSD Gray with Blue Diamond Cut Windows 10 Pro NVIDIA GeForce GTX 1650 Max Q with 4 GB 10 Hour Battery - Office Depot',
            url: 'https://www.officedepot.com/a/products/6785504/MSI-Prestige-14-A10SC-A10SC-020/',
          },
          {
            title:
              'MSI Prestige 14 A10SC A10SC-020 14" Notebook - 1920 x 1080 - Intel Core i5 10th Gen i5-10210U 1.60 GHz - 16 GB Total RAM - 512 GB SSD - Gray with Blue Diamond Cut',
            url: 'https://buy.bluum.com/msi-prestige-14-a10sc-a10sc-020-14-notebook-1920-x-1080-intel-core-i5-10th-gen-i5-10210u-1-60-ghz-16-gb-total-ram-512-gb-ssd-gray-with-blue-diamond-cut/',
          },
          {
            title:
              'MSI Prestige 14 A10SC-051 14" Ultra Thin and Light Professional Laptop Intel Core i7-10710U GTX1650 MAX-Q 16GB DDR4 512GB NVMe SSD Win10 Pro',
            url: 'https://www.mobileadvance.com/msi-prestige-14-a10sc-051-14-ultra-thin-and-light-professional-laptop-intel-core-i7-10710u-gtx1650-max-q-16gb-ddr4-512gb-nvme-ssd-win10-pro/',
          },
        ],
      },
      {
        text: '',
        confidence: 0,
        sources: [],
      },
    ],
    [
      {
        text: 'Asus TUF Gaming FX705',
        confidence: 1,
        sources: [
          {
            title:
              'The Best Cheap Gaming Laptops 2023 - Top 10 Budget Laptops For Gamers',
            url: 'https://best.kevin.games/gaming-laptops/the-best-cheap-budget-gaming-laptops-for-gamers',
          },
        ],
      },
      {
        text: 'Asus',
        confidence: 1,
        sources: [
          {
            title:
              'The Best Cheap Gaming Laptops 2023 - Top 10 Budget Laptops For Gamers',
            url: 'https://best.kevin.games/gaming-laptops/the-best-cheap-budget-gaming-laptops-for-gamers',
          },
        ],
      },
      {
        text: '$999',
        confidence: 1,
        sources: [
          {
            title:
              'The Best Cheap Gaming Laptops 2023 - Top 10 Budget Laptops For Gamers',
            url: 'https://best.kevin.games/gaming-laptops/the-best-cheap-budget-gaming-laptops-for-gamers',
          },
        ],
      },
      {
        text: 'Intel Core i5-8300H',
        confidence: 1,
        sources: [
          {
            title:
              'The Best Cheap Gaming Laptops 2023 - Top 10 Budget Laptops For Gamers',
            url: 'https://best.kevin.games/gaming-laptops/the-best-cheap-budget-gaming-laptops-for-gamers',
          },
        ],
      },
      {
        text: '8GB',
        confidence: 1,
        sources: [
          {
            title:
              'The Best Cheap Gaming Laptops 2023 - Top 10 Budget Laptops For Gamers',
            url: 'https://best.kevin.games/gaming-laptops/the-best-cheap-budget-gaming-laptops-for-gamers',
          },
        ],
      },
      {
        text: '1TB',
        confidence: 1,
        sources: [
          {
            title:
              'The Best Cheap Gaming Laptops 2023 - Top 10 Budget Laptops For Gamers',
            url: 'https://best.kevin.games/gaming-laptops/the-best-cheap-budget-gaming-laptops-for-gamers',
          },
        ],
      },
      {
        text: 'The Asus TUF Gaming FX705 has a 17.3-inch display with a resolution of 1920 x 1080.',
        confidence: 1,
        sources: [
          {
            title:
              'The Best Cheap Gaming Laptops 2023 - Top 10 Budget Laptops For Gamers',
            url: 'https://best.kevin.games/gaming-laptops/the-best-cheap-budget-gaming-laptops-for-gamers',
          },
        ],
      },
      {
        text: 'It can stay alive for up to 4 hours without a charger attached.',
        confidence: 1,
        sources: [
          {
            title:
              'The Best Cheap Gaming Laptops 2023 - Top 10 Budget Laptops For Gamers',
            url: 'https://best.kevin.games/gaming-laptops/the-best-cheap-budget-gaming-laptops-for-gamers',
          },
        ],
      },
    ],
  ],
};

const paperExample = {
  columns: [
    {
      name: 'Research paper',
      description:
        'The title of the research paper on 3D generative AI for dynamic scene composition',
    },
    {
      name: 'Authors',
      description: 'The authors of the research paper',
    },
    {
      name: 'Model',
      description: 'The 3D generative AI model proposed in the paper',
    },
    {
      name: 'Dataset',
      description:
        'The dataset used to train and evaluate the 3D generative model',
    },
    {
      name: 'Key Techniques',
      description:
        'The key novel techniques introduced in the paper for dynamic 3D scene composition',
    },
    {
      name: 'Results',
      description:
        "The main quantitative and qualitative results demonstrating the model's performance",
    },
  ],
  table: [
    [
      {
        text: 'LLM-Guided Compositional 4D Scene Generation',
        confidence: 1,
        sources: [
          {
            url: 'https://arxiv.org/pdf/2401.17807',
            title: '',
          },
          {
            url: 'https://arxiv.org/html/2403.16993v1',
            title: 'LLM-Guided Compositional 4D Scene Generation',
          },
          {
            url: 'https://www.marktechpost.com/2023/01/03/this-ai-research-presents-discoscene-a-3d-aware-generative-model-for-high-quality-and-controllable-scene-ynthesis/',
            title:
              'This AI Research Presents DisCoScene: A 3D-Aware Generative Model For High-Quality And Controllable Scene Synthesis',
          },
        ],
      },
      {
        text: 'Dejia Xu, Hanwen Liang, Neel P. Bhatt, Hezhen Hu, Hanxue Liang, Konstantinos N. Plataniotis, Zhangyang Wang',
        confidence: 1,
        sources: [
          {
            url: 'https://arxiv.org/pdf/2401.17807',
            title: '',
          },
          {
            url: 'https://arxiv.org/html/2403.16993v1',
            title: 'LLM-Guided Compositional 4D Scene Generation',
          },
          {
            url: 'https://www.marktechpost.com/2023/01/03/this-ai-research-presents-discoscene-a-3d-aware-generative-model-for-high-quality-and-controllable-scene-ynthesis/',
            title:
              'This AI Research Presents DisCoScene: A 3D-Aware Generative Model For High-Quality And Controllable Scene Synthesis',
          },
        ],
      },
      {
        text: 'The proposed model in the paper is called Comp4D, which stands for Compositional 4D Scene Generation. It is a framework that generates compositional 4D scenes from text input by decomposing the scene into individual 3D objects and modeling their interactions and motions.',
        confidence: 1,
        sources: [
          {
            url: 'https://arxiv.org/pdf/2401.17807',
            title: '',
          },
          {
            url: 'https://arxiv.org/html/2403.16993v1',
            title: 'LLM-Guided Compositional 4D Scene Generation',
          },
          {
            url: 'https://www.marktechpost.com/2023/01/03/this-ai-research-presents-discoscene-a-3d-aware-generative-model-for-high-quality-and-controllable-scene-ynthesis/',
            title:
              'This AI Research Presents DisCoScene: A 3D-Aware Generative Model For High-Quality And Controllable Scene Synthesis',
          },
        ],
      },
      {
        text: 'The Objaverse dataset',
        confidence: 0.3,
        sources: [],
      },
      {
        text: '1) Scene decomposition into individual 3D objects using an LLM to extract entities from the text prompt. \n  2) LLM-guided trajectory design for global object displacement using kinematics templates.\n  3) Compositional 4D representation with deformable 3D Gaussians for each object to model local deformations.\n  4) Compositional score distillation technique utilizing pre-trained diffusion models across text-to-image, text-to-video, and text-to-3D domains to refine the 4D scene.',
        confidence: 1,
        sources: [
          {
            url: 'https://arxiv.org/pdf/2401.17807',
            title: '',
          },
          {
            url: 'https://arxiv.org/html/2403.16993v1',
            title: 'LLM-Guided Compositional 4D Scene Generation',
          },
          {
            url: 'https://www.marktechpost.com/2023/01/03/this-ai-research-presents-discoscene-a-3d-aware-generative-model-for-high-quality-and-controllable-scene-ynthesis/',
            title:
              'This AI Research Presents DisCoScene: A 3D-Aware Generative Model For High-Quality And Controllable Scene Synthesis',
          },
        ],
      },
      {
        text: "The main quantitative and qualitative results demonstrating the model's performance are:\n\nQuantitative Results:\n- Table 1 reports the average quality assessment scores from Q-Align on four views of the test samples. The proposed method outperforms existing methods like 4dfy and animate124 by a large margin across all metrics.\n\nQualitative Results:\n- Figure 5 provides detailed visualizations comparing the generated 4D scenes at different timesteps from various views against 4dfy and animate124. The proposed method excels in generating lifelike single objects with expansive motions while enhancing fidelity in object interactions, as indicated by the distinct motions like flapping butterfly wings, jumping frog, and running animals.\n- The proposed method can render videos at 1024x1024 resolution during score distillation, aligning with the training resolution of the video diffusion model used. At inference time, the efficient 3D Gaussian representation enables real-time rendering at 70 FPS for 1024x1024 resolution.\n",
        confidence: 1,
        sources: [
          {
            url: 'https://arxiv.org/pdf/2401.17807',
            title: '',
          },
          {
            url: 'https://arxiv.org/html/2403.16993v1',
            title: 'LLM-Guided Compositional 4D Scene Generation',
          },
          {
            url: 'https://www.marktechpost.com/2023/01/03/this-ai-research-presents-discoscene-a-3d-aware-generative-model-for-high-quality-and-controllable-scene-ynthesis/',
            title:
              'This AI Research Presents DisCoScene: A 3D-Aware Generative Model For High-Quality And Controllable Scene Synthesis',
          },
        ],
      },
    ],
    [
      {
        text: '3D-Aware Video Generation',
        confidence: 1,
        sources: [
          {
            url: 'https://www.mdpi.com/2313-7673/8/4/371',
            title:
              'A Robust Semi-Direct 3D SLAM for Mobile Robot Based on Dense Optical Flow in Dynamic Scenes',
          },
          {
            url: 'https://arxiv.org/abs/2211.11082',
            title: 'DynIBaR: Neural Dynamic Image-Based Rendering',
          },
          {
            url: 'https://arxiv.org/abs/2211.14902',
            title:
              '3inGAN: Learning a 3D Generative Model from Images of a Self-similar Scene',
          },
          {
            url: 'https://arxiv.org/abs/2206.14797v2',
            title: '3D-Aware Video Generation',
          },
          {
            url: 'https://browse.arxiv.org/html/2312.17142v2',
            title: 'DreamGaussian4D: Generative 4D Gaussian Splatting',
          },
          {
            url: 'https://arxiv.org/abs/2212.13056v2',
            title:
              'MonoNeRF: Learning a Generalizable Dynamic Radiance Field from Monocular Videos',
          },
          {
            url: 'https://arxiv.org/abs/2210.01202',
            title:
              'SinGRAV: Learning a Generative Radiance Volume from a Single Natural Scene',
          },
          {
            url: 'https://arxiv.org/abs/2210.15947',
            title:
              'NeRFPlayer: A Streamable Dynamic Scene Representation with Decomposed Neural Radiance Fields',
          },
          {
            url: 'https://arxiv.org/abs/2209.13284',
            title:
              'Frame Interpolation for Dynamic Scenes with Implicit Flow Encoding',
          },
        ],
      },
      {
        text: 'Jingwen Luo',
        confidence: 1,
        sources: [
          {
            url: 'https://www.mdpi.com/2313-7673/8/4/371',
            title:
              'A Robust Semi-Direct 3D SLAM for Mobile Robot Based on Dense Optical Flow in Dynamic Scenes',
          },
          {
            url: 'https://arxiv.org/abs/2211.11082',
            title: 'DynIBaR: Neural Dynamic Image-Based Rendering',
          },
          {
            url: 'https://arxiv.org/abs/2211.14902',
            title:
              '3inGAN: Learning a 3D Generative Model from Images of a Self-similar Scene',
          },
          {
            url: 'https://arxiv.org/abs/2206.14797v2',
            title: '3D-Aware Video Generation',
          },
          {
            url: 'https://browse.arxiv.org/html/2312.17142v2',
            title: 'DreamGaussian4D: Generative 4D Gaussian Splatting',
          },
          {
            url: 'https://arxiv.org/abs/2212.13056v2',
            title:
              'MonoNeRF: Learning a Generalizable Dynamic Radiance Field from Monocular Videos',
          },
          {
            url: 'https://arxiv.org/abs/2210.01202',
            title:
              'SinGRAV: Learning a Generative Radiance Volume from a Single Natural Scene',
          },
          {
            url: 'https://arxiv.org/abs/2210.15947',
            title:
              'NeRFPlayer: A Streamable Dynamic Scene Representation with Decomposed Neural Radiance Fields',
          },
          {
            url: 'https://arxiv.org/abs/2209.13284',
            title:
              'Frame Interpolation for Dynamic Scenes with Implicit Flow Encoding',
          },
        ],
      },
      {
        text: 'Our generator networks take as input two independent noise vectors, m and z, that respectively modulate the motion and the content of the 4D fields. To render an image at a specific time step t, we sample the camera extrinsics according to dataset-dependent distribution and conduct volume rendering through the time-conditioned radiance and density fields. Our time-aware discriminator measures the realism of a pair of frames, given their time difference, to promote plausible 3D video generation.',
        confidence: 1,
        sources: [
          {
            title: '3D-Aware Video Generation',
            url: 'https://sherwinbahmani.github.io/3dvidgen/',
          },
        ],
      },
      {
        text: 'The datasets used are FaceForensics, TaiChi, and MEAD. FaceForensics and MEAD were resized to 256x256 resolution, and TaiChi was resized to 128x128 resolution.',
        confidence: 0.3,
        sources: [
          {
            title:
              'GitHub - sherwinbahmani/3dvideogeneration: 3D-Aware Video Generation',
            url: 'https://github.com/sherwinbahmani/3dvideogeneration',
          },
        ],
      },
      {
        text: 'The key novel techniques introduced in the paper are:\n  1) A high-precision dynamic object detection method based on dense optical flow to accurately determine dynamic regions in images.\n  2) A high-performance keyframe selection strategy to reduce the influence of dynamic objects on keyframe quality.\n  3) An effective relocation method by introducing feature point extraction and matching to improve the success rate of relocalization and robustness.',
        confidence: 1,
        sources: [
          {
            url: 'https://www.mdpi.com/2313-7673/8/4/371',
            title:
              'A Robust Semi-Direct 3D SLAM for Mobile Robot Based on Dense Optical Flow in Dynamic Scenes',
          },
          {
            url: 'https://arxiv.org/abs/2211.11082',
            title: 'DynIBaR: Neural Dynamic Image-Based Rendering',
          },
          {
            url: 'https://arxiv.org/abs/2211.14902',
            title:
              '3inGAN: Learning a 3D Generative Model from Images of a Self-similar Scene',
          },
          {
            url: 'https://arxiv.org/abs/2206.14797v2',
            title: '3D-Aware Video Generation',
          },
          {
            url: 'https://browse.arxiv.org/html/2312.17142v2',
            title: 'DreamGaussian4D: Generative 4D Gaussian Splatting',
          },
          {
            url: 'https://arxiv.org/abs/2212.13056v2',
            title:
              'MonoNeRF: Learning a Generalizable Dynamic Radiance Field from Monocular Videos',
          },
          {
            url: 'https://arxiv.org/abs/2210.01202',
            title:
              'SinGRAV: Learning a Generative Radiance Volume from a Single Natural Scene',
          },
          {
            url: 'https://arxiv.org/abs/2210.15947',
            title:
              'NeRFPlayer: A Streamable Dynamic Scene Representation with Decomposed Neural Radiance Fields',
          },
          {
            url: 'https://arxiv.org/abs/2209.13284',
            title:
              'Frame Interpolation for Dynamic Scenes with Implicit Flow Encoding',
          },
        ],
      },
      {
        text: 'Figure 1: 3D-Aware video generation. We show multiple frames and viewpoints of two 3D videos, generated using our model trained on the FaceForensics dataset (Rössler et al., 2019). Our 4D GAN generates 3D content of high quality while permitting control of time and camera extrinsics. Video results can be viewed on our website: https://sherwinbahmani.github.io/3dvidgen...Results on FaceForensics Dataset, MEAD Dataset, TaiChi Dataset, SkyTimelapse Dataset are shown with samples generated by varying camera viewpoints, zoom effects, motion and content decomposition.',
        confidence: 1,
        sources: [
          {
            title: '',
            url: 'https://openreview.net/pdf?id=xuUpqbdScV',
          },
          {
            title: '3D-Aware Video Generation',
            url: 'https://ar5iv.labs.arxiv.org/html/2206.14797',
          },
          {
            title: '3D-Aware Video Generation',
            url: 'https://sherwinbahmani.github.io/3dvidgen/',
          },
        ],
      },
    ],
  ],
};

const examples = {
  laptop: laptopExample,
  startup: startupExample,
  paper: paperExample,
};

export default examples;
