/*
 tags_table_view.h     MindForger thinking notebook

 Copyright (C) 2016-2024 Martin Dvorak <martin.dvorak@mindforger.com>

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef M8RUI_TAGS_TABLE_VIEW_H
#define M8RUI_TAGS_TABLE_VIEW_H

#include "../../../lib/src/debug.h"

#include <QtWidgets>

#include "qt_commons.h"

namespace m8r {

class TagsTableView : public QTableView
{
    Q_OBJECT

public:
    explicit TagsTableView(QWidget* parent);
    TagsTableView(const TagsTableView&) = delete;
    TagsTableView(const TagsTableView&&) = delete;
    TagsTableView &operator=(const TagsTableView&) = delete;
    TagsTableView &operator=(const TagsTableView&&) = delete;
    virtual ~TagsTableView() override {}

    virtual void keyPressEvent(QKeyEvent* event) override;
    virtual void mouseDoubleClickEvent(QMouseEvent* event) override;
    virtual void resizeEvent(QResizeEvent* event) override;

signals:
    void signalShowDialogForTag();
};

}
#endif // M8RUI_TAGS_TABLE_VIEW_H
