"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/p-retry";
exports.ids = ["vendor-chunks/p-retry"];
exports.modules = {

/***/ "(rsc)/./node_modules/p-retry/index.js":
/*!***************************************!*\
  !*** ./node_modules/p-retry/index.js ***!
  \***************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\nconst retry = __webpack_require__(/*! retry */ \"(rsc)/./node_modules/retry/index.js\");\n\nconst networkErrorMsgs = [\n\t'Failed to fetch', // Chrome\n\t'NetworkError when attempting to fetch resource.', // Firefox\n\t'The Internet connection appears to be offline.', // Safari\n\t'Network request failed' // `cross-fetch`\n];\n\nclass AbortError extends Error {\n\tconstructor(message) {\n\t\tsuper();\n\n\t\tif (message instanceof Error) {\n\t\t\tthis.originalError = message;\n\t\t\t({message} = message);\n\t\t} else {\n\t\t\tthis.originalError = new Error(message);\n\t\t\tthis.originalError.stack = this.stack;\n\t\t}\n\n\t\tthis.name = 'AbortError';\n\t\tthis.message = message;\n\t}\n}\n\nconst decorateErrorWithCounts = (error, attemptNumber, options) => {\n\t// Minus 1 from attemptNumber because the first attempt does not count as a retry\n\tconst retriesLeft = options.retries - (attemptNumber - 1);\n\n\terror.attemptNumber = attemptNumber;\n\terror.retriesLeft = retriesLeft;\n\treturn error;\n};\n\nconst isNetworkError = errorMessage => networkErrorMsgs.includes(errorMessage);\n\nconst pRetry = (input, options) => new Promise((resolve, reject) => {\n\toptions = {\n\t\tonFailedAttempt: () => {},\n\t\tretries: 10,\n\t\t...options\n\t};\n\n\tconst operation = retry.operation(options);\n\n\toperation.attempt(async attemptNumber => {\n\t\ttry {\n\t\t\tresolve(await input(attemptNumber));\n\t\t} catch (error) {\n\t\t\tif (!(error instanceof Error)) {\n\t\t\t\treject(new TypeError(`Non-error was thrown: \"${error}\". You should only throw errors.`));\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif (error instanceof AbortError) {\n\t\t\t\toperation.stop();\n\t\t\t\treject(error.originalError);\n\t\t\t} else if (error instanceof TypeError && !isNetworkError(error.message)) {\n\t\t\t\toperation.stop();\n\t\t\t\treject(error);\n\t\t\t} else {\n\t\t\t\tdecorateErrorWithCounts(error, attemptNumber, options);\n\n\t\t\t\ttry {\n\t\t\t\t\tawait options.onFailedAttempt(error);\n\t\t\t\t} catch (error) {\n\t\t\t\t\treject(error);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (!operation.retry(error)) {\n\t\t\t\t\treject(operation.mainError());\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n});\n\nmodule.exports = pRetry;\n// TODO: remove this in the next major version\nmodule.exports[\"default\"] = pRetry;\n\nmodule.exports.AbortError = AbortError;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/p-retry/index.js\n");

/***/ })

};
;