"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/hast-util-to-jsx-runtime";
exports.ids = ["vendor-chunks/hast-util-to-jsx-runtime"];
exports.modules = {

/***/ "(ssr)/./node_modules/hast-util-to-jsx-runtime/lib/index.js":
/*!************************************************************!*\
  !*** ./node_modules/hast-util-to-jsx-runtime/lib/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   toJsxRuntime: () => (/* binding */ toJsxRuntime)\n/* harmony export */ });\n/* harmony import */ var comma_separated_tokens__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! comma-separated-tokens */ \"(ssr)/./node_modules/comma-separated-tokens/index.js\");\n/* harmony import */ var devlop__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! devlop */ \"(ssr)/./node_modules/devlop/lib/development.js\");\n/* harmony import */ var estree_util_is_identifier_name__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! estree-util-is-identifier-name */ \"(ssr)/./node_modules/estree-util-is-identifier-name/lib/index.js\");\n/* harmony import */ var hast_util_whitespace__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! hast-util-whitespace */ \"(ssr)/./node_modules/hast-util-whitespace/lib/index.js\");\n/* harmony import */ var property_information__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! property-information */ \"(ssr)/./node_modules/property-information/index.js\");\n/* harmony import */ var property_information__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! property-information */ \"(ssr)/./node_modules/property-information/lib/find.js\");\n/* harmony import */ var property_information__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! property-information */ \"(ssr)/./node_modules/property-information/lib/hast-to-react.js\");\n/* harmony import */ var space_separated_tokens__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! space-separated-tokens */ \"(ssr)/./node_modules/space-separated-tokens/index.js\");\n/* harmony import */ var style_to_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! style-to-object */ \"(ssr)/./node_modules/style-to-object/esm/index.mjs\");\n/* harmony import */ var unist_util_position__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! unist-util-position */ \"(ssr)/./node_modules/unist-util-position/lib/index.js\");\n/* harmony import */ var vfile_message__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! vfile-message */ \"(ssr)/./node_modules/vfile-message/lib/index.js\");\n/**\n * @import {Identifier, Literal, MemberExpression} from 'estree'\n * @import {Jsx, JsxDev, Options, Props} from 'hast-util-to-jsx-runtime'\n * @import {Element, Nodes, Parents, Root, Text} from 'hast'\n * @import {MdxFlowExpressionHast, MdxTextExpressionHast} from 'mdast-util-mdx-expression'\n * @import {MdxJsxFlowElementHast, MdxJsxTextElementHast} from 'mdast-util-mdx-jsx'\n * @import {MdxjsEsmHast} from 'mdast-util-mdxjs-esm'\n * @import {Position} from 'unist'\n * @import {Child, Create, Field, State, Style} from './types.js'\n */\n\n\n\n\n\n\n\n\n\n\n\n// To do: next major: `Object.hasOwn`.\nconst own = {}.hasOwnProperty\n\n/** @type {Map<string, number>} */\nconst emptyMap = new Map()\n\nconst cap = /[A-Z]/g\nconst dashSomething = /-([a-z])/g\n\n// `react-dom` triggers a warning for *any* white space in tables.\n// To follow GFM, `mdast-util-to-hast` injects line endings between elements.\n// Other tools might do so too, but they don’t do here, so we remove all of\n// that.\n\n// See: <https://github.com/facebook/react/pull/7081>.\n// See: <https://github.com/facebook/react/pull/7515>.\n// See: <https://github.com/remarkjs/remark-react/issues/64>.\n// See: <https://github.com/rehypejs/rehype-react/pull/29>.\n// See: <https://github.com/rehypejs/rehype-react/pull/32>.\n// See: <https://github.com/rehypejs/rehype-react/pull/45>.\nconst tableElements = new Set(['table', 'tbody', 'thead', 'tfoot', 'tr'])\n\nconst tableCellElement = new Set(['td', 'th'])\n\nconst docs = 'https://github.com/syntax-tree/hast-util-to-jsx-runtime'\n\n/**\n * Transform a hast tree to preact, react, solid, svelte, vue, etc.,\n * with an automatic JSX runtime.\n *\n * @param {Nodes} tree\n *   Tree to transform.\n * @param {Options} options\n *   Configuration (required).\n * @returns {JSX.Element}\n *   JSX element.\n */\n\nfunction toJsxRuntime(tree, options) {\n  if (!options || options.Fragment === undefined) {\n    throw new TypeError('Expected `Fragment` in options')\n  }\n\n  const filePath = options.filePath || undefined\n  /** @type {Create} */\n  let create\n\n  if (options.development) {\n    if (typeof options.jsxDEV !== 'function') {\n      throw new TypeError(\n        'Expected `jsxDEV` in options when `development: true`'\n      )\n    }\n\n    create = developmentCreate(filePath, options.jsxDEV)\n  } else {\n    if (typeof options.jsx !== 'function') {\n      throw new TypeError('Expected `jsx` in production options')\n    }\n\n    if (typeof options.jsxs !== 'function') {\n      throw new TypeError('Expected `jsxs` in production options')\n    }\n\n    create = productionCreate(filePath, options.jsx, options.jsxs)\n  }\n\n  /** @type {State} */\n  const state = {\n    Fragment: options.Fragment,\n    ancestors: [],\n    components: options.components || {},\n    create,\n    elementAttributeNameCase: options.elementAttributeNameCase || 'react',\n    evaluater: options.createEvaluater ? options.createEvaluater() : undefined,\n    filePath,\n    ignoreInvalidStyle: options.ignoreInvalidStyle || false,\n    passKeys: options.passKeys !== false,\n    passNode: options.passNode || false,\n    schema: options.space === 'svg' ? property_information__WEBPACK_IMPORTED_MODULE_1__.svg : property_information__WEBPACK_IMPORTED_MODULE_1__.html,\n    stylePropertyNameCase: options.stylePropertyNameCase || 'dom',\n    tableCellAlignToStyle: options.tableCellAlignToStyle !== false\n  }\n\n  const result = one(state, tree, undefined)\n\n  // JSX element.\n  if (result && typeof result !== 'string') {\n    return result\n  }\n\n  // Text node or something that turned into nothing.\n  return state.create(\n    tree,\n    state.Fragment,\n    {children: result || undefined},\n    undefined\n  )\n}\n\n/**\n * Transform a node.\n *\n * @param {State} state\n *   Info passed around.\n * @param {Nodes} node\n *   Current node.\n * @param {string | undefined} key\n *   Key.\n * @returns {Child | undefined}\n *   Child, optional.\n */\nfunction one(state, node, key) {\n  if (node.type === 'element') {\n    return element(state, node, key)\n  }\n\n  if (node.type === 'mdxFlowExpression' || node.type === 'mdxTextExpression') {\n    return mdxExpression(state, node)\n  }\n\n  if (node.type === 'mdxJsxFlowElement' || node.type === 'mdxJsxTextElement') {\n    return mdxJsxElement(state, node, key)\n  }\n\n  if (node.type === 'mdxjsEsm') {\n    return mdxEsm(state, node)\n  }\n\n  if (node.type === 'root') {\n    return root(state, node, key)\n  }\n\n  if (node.type === 'text') {\n    return text(state, node)\n  }\n}\n\n/**\n * Handle element.\n *\n * @param {State} state\n *   Info passed around.\n * @param {Element} node\n *   Current node.\n * @param {string | undefined} key\n *   Key.\n * @returns {Child | undefined}\n *   Child, optional.\n */\nfunction element(state, node, key) {\n  const parentSchema = state.schema\n  let schema = parentSchema\n\n  if (node.tagName.toLowerCase() === 'svg' && parentSchema.space === 'html') {\n    schema = property_information__WEBPACK_IMPORTED_MODULE_1__.svg\n    state.schema = schema\n  }\n\n  state.ancestors.push(node)\n\n  const type = findComponentFromName(state, node.tagName, false)\n  const props = createElementProps(state, node)\n  let children = createChildren(state, node)\n\n  if (tableElements.has(node.tagName)) {\n    children = children.filter(function (child) {\n      return typeof child === 'string' ? !(0,hast_util_whitespace__WEBPACK_IMPORTED_MODULE_2__.whitespace)(child) : true\n    })\n  }\n\n  addNode(state, props, type, node)\n  addChildren(props, children)\n\n  // Restore.\n  state.ancestors.pop()\n  state.schema = parentSchema\n\n  return state.create(node, type, props, key)\n}\n\n/**\n * Handle MDX expression.\n *\n * @param {State} state\n *   Info passed around.\n * @param {MdxFlowExpressionHast | MdxTextExpressionHast} node\n *   Current node.\n * @returns {Child | undefined}\n *   Child, optional.\n */\nfunction mdxExpression(state, node) {\n  if (node.data && node.data.estree && state.evaluater) {\n    const program = node.data.estree\n    const expression = program.body[0]\n    ;(0,devlop__WEBPACK_IMPORTED_MODULE_3__.ok)(expression.type === 'ExpressionStatement')\n\n    // Assume result is a child.\n    return /** @type {Child | undefined} */ (\n      state.evaluater.evaluateExpression(expression.expression)\n    )\n  }\n\n  crashEstree(state, node.position)\n}\n\n/**\n * Handle MDX ESM.\n *\n * @param {State} state\n *   Info passed around.\n * @param {MdxjsEsmHast} node\n *   Current node.\n * @returns {Child | undefined}\n *   Child, optional.\n */\nfunction mdxEsm(state, node) {\n  if (node.data && node.data.estree && state.evaluater) {\n    // Assume result is a child.\n    return /** @type {Child | undefined} */ (\n      state.evaluater.evaluateProgram(node.data.estree)\n    )\n  }\n\n  crashEstree(state, node.position)\n}\n\n/**\n * Handle MDX JSX.\n *\n * @param {State} state\n *   Info passed around.\n * @param {MdxJsxFlowElementHast | MdxJsxTextElementHast} node\n *   Current node.\n * @param {string | undefined} key\n *   Key.\n * @returns {Child | undefined}\n *   Child, optional.\n */\nfunction mdxJsxElement(state, node, key) {\n  const parentSchema = state.schema\n  let schema = parentSchema\n\n  if (node.name === 'svg' && parentSchema.space === 'html') {\n    schema = property_information__WEBPACK_IMPORTED_MODULE_1__.svg\n    state.schema = schema\n  }\n\n  state.ancestors.push(node)\n\n  const type =\n    node.name === null\n      ? state.Fragment\n      : findComponentFromName(state, node.name, true)\n  const props = createJsxElementProps(state, node)\n  const children = createChildren(state, node)\n\n  addNode(state, props, type, node)\n  addChildren(props, children)\n\n  // Restore.\n  state.ancestors.pop()\n  state.schema = parentSchema\n\n  return state.create(node, type, props, key)\n}\n\n/**\n * Handle root.\n *\n * @param {State} state\n *   Info passed around.\n * @param {Root} node\n *   Current node.\n * @param {string | undefined} key\n *   Key.\n * @returns {Child | undefined}\n *   Child, optional.\n */\nfunction root(state, node, key) {\n  /** @type {Props} */\n  const props = {}\n\n  addChildren(props, createChildren(state, node))\n\n  return state.create(node, state.Fragment, props, key)\n}\n\n/**\n * Handle text.\n *\n * @param {State} _\n *   Info passed around.\n * @param {Text} node\n *   Current node.\n * @returns {Child | undefined}\n *   Child, optional.\n */\nfunction text(_, node) {\n  return node.value\n}\n\n/**\n * Add `node` to props.\n *\n * @param {State} state\n *   Info passed around.\n * @param {Props} props\n *   Props.\n * @param {unknown} type\n *   Type.\n * @param {Element | MdxJsxFlowElementHast | MdxJsxTextElementHast} node\n *   Node.\n * @returns {undefined}\n *   Nothing.\n */\nfunction addNode(state, props, type, node) {\n  // If this is swapped out for a component:\n  if (typeof type !== 'string' && type !== state.Fragment && state.passNode) {\n    props.node = node\n  }\n}\n\n/**\n * Add children to props.\n *\n * @param {Props} props\n *   Props.\n * @param {Array<Child>} children\n *   Children.\n * @returns {undefined}\n *   Nothing.\n */\nfunction addChildren(props, children) {\n  if (children.length > 0) {\n    const value = children.length > 1 ? children : children[0]\n\n    if (value) {\n      props.children = value\n    }\n  }\n}\n\n/**\n * @param {string | undefined} _\n *   Path to file.\n * @param {Jsx} jsx\n *   Dynamic.\n * @param {Jsx} jsxs\n *   Static.\n * @returns {Create}\n *   Create a production element.\n */\nfunction productionCreate(_, jsx, jsxs) {\n  return create\n  /** @type {Create} */\n  function create(_, type, props, key) {\n    // Only an array when there are 2 or more children.\n    const isStaticChildren = Array.isArray(props.children)\n    const fn = isStaticChildren ? jsxs : jsx\n    return key ? fn(type, props, key) : fn(type, props)\n  }\n}\n\n/**\n * @param {string | undefined} filePath\n *   Path to file.\n * @param {JsxDev} jsxDEV\n *   Development.\n * @returns {Create}\n *   Create a development element.\n */\nfunction developmentCreate(filePath, jsxDEV) {\n  return create\n  /** @type {Create} */\n  function create(node, type, props, key) {\n    // Only an array when there are 2 or more children.\n    const isStaticChildren = Array.isArray(props.children)\n    const point = (0,unist_util_position__WEBPACK_IMPORTED_MODULE_4__.pointStart)(node)\n    return jsxDEV(\n      type,\n      props,\n      key,\n      isStaticChildren,\n      {\n        columnNumber: point ? point.column - 1 : undefined,\n        fileName: filePath,\n        lineNumber: point ? point.line : undefined\n      },\n      undefined\n    )\n  }\n}\n\n/**\n * Create props from an element.\n *\n * @param {State} state\n *   Info passed around.\n * @param {Element} node\n *   Current element.\n * @returns {Props}\n *   Props.\n */\nfunction createElementProps(state, node) {\n  /** @type {Props} */\n  const props = {}\n  /** @type {string | undefined} */\n  let alignValue\n  /** @type {string} */\n  let prop\n\n  for (prop in node.properties) {\n    if (prop !== 'children' && own.call(node.properties, prop)) {\n      const result = createProperty(state, prop, node.properties[prop])\n\n      if (result) {\n        const [key, value] = result\n\n        if (\n          state.tableCellAlignToStyle &&\n          key === 'align' &&\n          typeof value === 'string' &&\n          tableCellElement.has(node.tagName)\n        ) {\n          alignValue = value\n        } else {\n          props[key] = value\n        }\n      }\n    }\n  }\n\n  if (alignValue) {\n    // Assume style is an object.\n    const style = /** @type {Style} */ (props.style || (props.style = {}))\n    style[state.stylePropertyNameCase === 'css' ? 'text-align' : 'textAlign'] =\n      alignValue\n  }\n\n  return props\n}\n\n/**\n * Create props from a JSX element.\n *\n * @param {State} state\n *   Info passed around.\n * @param {MdxJsxFlowElementHast | MdxJsxTextElementHast} node\n *   Current JSX element.\n * @returns {Props}\n *   Props.\n */\nfunction createJsxElementProps(state, node) {\n  /** @type {Props} */\n  const props = {}\n\n  for (const attribute of node.attributes) {\n    if (attribute.type === 'mdxJsxExpressionAttribute') {\n      if (attribute.data && attribute.data.estree && state.evaluater) {\n        const program = attribute.data.estree\n        const expression = program.body[0]\n        ;(0,devlop__WEBPACK_IMPORTED_MODULE_3__.ok)(expression.type === 'ExpressionStatement')\n        const objectExpression = expression.expression\n        ;(0,devlop__WEBPACK_IMPORTED_MODULE_3__.ok)(objectExpression.type === 'ObjectExpression')\n        const property = objectExpression.properties[0]\n        ;(0,devlop__WEBPACK_IMPORTED_MODULE_3__.ok)(property.type === 'SpreadElement')\n\n        Object.assign(\n          props,\n          state.evaluater.evaluateExpression(property.argument)\n        )\n      } else {\n        crashEstree(state, node.position)\n      }\n    } else {\n      // For JSX, the author is responsible of passing in the correct values.\n      const name = attribute.name\n      /** @type {unknown} */\n      let value\n\n      if (attribute.value && typeof attribute.value === 'object') {\n        if (\n          attribute.value.data &&\n          attribute.value.data.estree &&\n          state.evaluater\n        ) {\n          const program = attribute.value.data.estree\n          const expression = program.body[0]\n          ;(0,devlop__WEBPACK_IMPORTED_MODULE_3__.ok)(expression.type === 'ExpressionStatement')\n          value = state.evaluater.evaluateExpression(expression.expression)\n        } else {\n          crashEstree(state, node.position)\n        }\n      } else {\n        value = attribute.value === null ? true : attribute.value\n      }\n\n      // Assume a prop.\n      props[name] = /** @type {Props[keyof Props]} */ (value)\n    }\n  }\n\n  return props\n}\n\n/**\n * Create children.\n *\n * @param {State} state\n *   Info passed around.\n * @param {Parents} node\n *   Current element.\n * @returns {Array<Child>}\n *   Children.\n */\nfunction createChildren(state, node) {\n  /** @type {Array<Child>} */\n  const children = []\n  let index = -1\n  /** @type {Map<string, number>} */\n  // Note: test this when Solid doesn’t want to merge my upcoming PR.\n  /* c8 ignore next */\n  const countsByName = state.passKeys ? new Map() : emptyMap\n\n  while (++index < node.children.length) {\n    const child = node.children[index]\n    /** @type {string | undefined} */\n    let key\n\n    if (state.passKeys) {\n      const name =\n        child.type === 'element'\n          ? child.tagName\n          : child.type === 'mdxJsxFlowElement' ||\n              child.type === 'mdxJsxTextElement'\n            ? child.name\n            : undefined\n\n      if (name) {\n        const count = countsByName.get(name) || 0\n        key = name + '-' + count\n        countsByName.set(name, count + 1)\n      }\n    }\n\n    const result = one(state, child, key)\n    if (result !== undefined) children.push(result)\n  }\n\n  return children\n}\n\n/**\n * Handle a property.\n *\n * @param {State} state\n *   Info passed around.\n * @param {string} prop\n *   Key.\n * @param {Array<number | string> | boolean | number | string | null | undefined} value\n *   hast property value.\n * @returns {Field | undefined}\n *   Field for runtime, optional.\n */\nfunction createProperty(state, prop, value) {\n  const info = (0,property_information__WEBPACK_IMPORTED_MODULE_5__.find)(state.schema, prop)\n\n  // Ignore nullish and `NaN` values.\n  if (\n    value === null ||\n    value === undefined ||\n    (typeof value === 'number' && Number.isNaN(value))\n  ) {\n    return\n  }\n\n  if (Array.isArray(value)) {\n    // Accept `array`.\n    // Most props are space-separated.\n    value = info.commaSeparated ? (0,comma_separated_tokens__WEBPACK_IMPORTED_MODULE_6__.stringify)(value) : (0,space_separated_tokens__WEBPACK_IMPORTED_MODULE_7__.stringify)(value)\n  }\n\n  // React only accepts `style` as object.\n  if (info.property === 'style') {\n    let styleObject =\n      typeof value === 'object' ? value : parseStyle(state, String(value))\n\n    if (state.stylePropertyNameCase === 'css') {\n      styleObject = transformStylesToCssCasing(styleObject)\n    }\n\n    return ['style', styleObject]\n  }\n\n  return [\n    state.elementAttributeNameCase === 'react' && info.space\n      ? property_information__WEBPACK_IMPORTED_MODULE_8__.hastToReact[info.property] || info.property\n      : info.attribute,\n    value\n  ]\n}\n\n/**\n * Parse a CSS declaration to an object.\n *\n * @param {State} state\n *   Info passed around.\n * @param {string} value\n *   CSS declarations.\n * @returns {Style}\n *   Properties.\n * @throws\n *   Throws `VFileMessage` when CSS cannot be parsed.\n */\nfunction parseStyle(state, value) {\n  /** @type {Style} */\n  const result = {}\n\n  try {\n    ;(0,style_to_object__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(value, replacer)\n  } catch (error) {\n    if (!state.ignoreInvalidStyle) {\n      const cause = /** @type {Error} */ (error)\n      const message = new vfile_message__WEBPACK_IMPORTED_MODULE_9__.VFileMessage('Cannot parse `style` attribute', {\n        ancestors: state.ancestors,\n        cause,\n        ruleId: 'style',\n        source: 'hast-util-to-jsx-runtime'\n      })\n      message.file = state.filePath || undefined\n      message.url = docs + '#cannot-parse-style-attribute'\n\n      throw message\n    }\n  }\n\n  return result\n\n  /**\n   * Add a CSS property (normal, so with dashes) to `result` as a DOM CSS\n   * property.\n   *\n   * @param {string} name\n   *   Key.\n   * @param {string} value\n   *   Value\n   * @returns {undefined}\n   *   Nothing.\n   */\n  function replacer(name, value) {\n    let key = name\n\n    if (key.slice(0, 2) !== '--') {\n      if (key.slice(0, 4) === '-ms-') key = 'ms-' + key.slice(4)\n      key = key.replace(dashSomething, toCamel)\n    }\n\n    result[key] = value\n  }\n}\n\n/**\n * Create a JSX name from a string.\n *\n * @param {State} state\n *   To do.\n * @param {string} name\n *   Name.\n * @param {boolean} allowExpression\n *   Allow member expressions and identifiers.\n * @returns {unknown}\n *   To do.\n */\nfunction findComponentFromName(state, name, allowExpression) {\n  /** @type {Identifier | Literal | MemberExpression} */\n  let result\n\n  if (!allowExpression) {\n    result = {type: 'Literal', value: name}\n  } else if (name.includes('.')) {\n    const identifiers = name.split('.')\n    let index = -1\n    /** @type {Identifier | Literal | MemberExpression | undefined} */\n    let node\n\n    while (++index < identifiers.length) {\n      /** @type {Identifier | Literal} */\n      const prop = (0,estree_util_is_identifier_name__WEBPACK_IMPORTED_MODULE_10__.name)(identifiers[index])\n        ? {type: 'Identifier', name: identifiers[index]}\n        : {type: 'Literal', value: identifiers[index]}\n      node = node\n        ? {\n            type: 'MemberExpression',\n            object: node,\n            property: prop,\n            computed: Boolean(index && prop.type === 'Literal'),\n            optional: false\n          }\n        : prop\n    }\n\n    (0,devlop__WEBPACK_IMPORTED_MODULE_3__.ok)(node, 'always a result')\n    result = node\n  } else {\n    result =\n      (0,estree_util_is_identifier_name__WEBPACK_IMPORTED_MODULE_10__.name)(name) && !/^[a-z]/.test(name)\n        ? {type: 'Identifier', name}\n        : {type: 'Literal', value: name}\n  }\n\n  // Only literals can be passed in `components` currently.\n  // No identifiers / member expressions.\n  if (result.type === 'Literal') {\n    const name = /** @type {keyof JSX.IntrinsicElements} */ (result.value)\n\n    return own.call(state.components, name) ? state.components[name] : name\n  }\n\n  // Assume component.\n  if (state.evaluater) {\n    return state.evaluater.evaluateExpression(result)\n  }\n\n  crashEstree(state)\n}\n\n/**\n * @param {State} state\n * @param {Position | undefined} [place]\n * @returns {never}\n */\nfunction crashEstree(state, place) {\n  const message = new vfile_message__WEBPACK_IMPORTED_MODULE_9__.VFileMessage(\n    'Cannot handle MDX estrees without `createEvaluater`',\n    {\n      ancestors: state.ancestors,\n      place,\n      ruleId: 'mdx-estree',\n      source: 'hast-util-to-jsx-runtime'\n    }\n  )\n  message.file = state.filePath || undefined\n  message.url = docs + '#cannot-handle-mdx-estrees-without-createevaluater'\n\n  throw message\n}\n\n/**\n * Transform a DOM casing style object to a CSS casing style object.\n *\n * @param {Style} domCasing\n * @returns {Style}\n */\nfunction transformStylesToCssCasing(domCasing) {\n  /** @type {Style} */\n  const cssCasing = {}\n  /** @type {string} */\n  let from\n\n  for (from in domCasing) {\n    if (own.call(domCasing, from)) {\n      cssCasing[transformStyleToCssCasing(from)] = domCasing[from]\n    }\n  }\n\n  return cssCasing\n}\n\n/**\n * Transform a DOM casing style field to a CSS casing style field.\n *\n * @param {string} from\n * @returns {string}\n */\nfunction transformStyleToCssCasing(from) {\n  let to = from.replace(cap, toDash)\n  // Handle `ms-xxx` -> `-ms-xxx`.\n  if (to.slice(0, 3) === 'ms-') to = '-' + to\n  return to\n}\n\n/**\n * Make `$1` capitalized.\n *\n * @param {string} _\n *   Whatever.\n * @param {string} $1\n *   Single ASCII alphabetical.\n * @returns {string}\n *   Capitalized `$1`.\n */\nfunction toCamel(_, $1) {\n  return $1.toUpperCase()\n}\n\n/**\n * Make `$0` dash cased.\n *\n * @param {string} $0\n *   Capitalized ASCII leter.\n * @returns {string}\n *   Dash and lower letter.\n */\nfunction toDash($0) {\n  return '-' + $0.toLowerCase()\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvaGFzdC11dGlsLXRvLWpzeC1ydW50aW1lL2xpYi9pbmRleC5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7QUFBQTtBQUNBLFlBQVksdUNBQXVDO0FBQ25ELFlBQVksNkJBQTZCO0FBQ3pDLFlBQVkscUNBQXFDO0FBQ2pELFlBQVksOENBQThDO0FBQzFELFlBQVksOENBQThDO0FBQzFELFlBQVksY0FBYztBQUMxQixZQUFZLFVBQVU7QUFDdEIsWUFBWSxvQ0FBb0M7QUFDaEQ7O0FBRTBEO0FBQ3ZCO0FBQ29DO0FBQ3hCO0FBQ2tCO0FBQ1A7QUFDZjtBQUNHO0FBQ0o7O0FBRTFDO0FBQ0EsY0FBYzs7QUFFZCxXQUFXLHFCQUFxQjtBQUNoQzs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBOztBQUVBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVyxPQUFPO0FBQ2xCO0FBQ0EsV0FBVyxTQUFTO0FBQ3BCO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7O0FBRU87QUFDUDtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxhQUFhLFFBQVE7QUFDckI7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EsSUFBSTtBQUNKO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQSxhQUFhLE9BQU87QUFDcEI7QUFDQTtBQUNBO0FBQ0Esd0NBQXdDO0FBQ3hDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0NBQXNDLHFEQUFHLEdBQUcsc0RBQUk7QUFDaEQ7QUFDQTtBQUNBOztBQUVBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSyw4QkFBOEI7QUFDbkM7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsT0FBTztBQUNsQjtBQUNBLFdBQVcsT0FBTztBQUNsQjtBQUNBLFdBQVcsb0JBQW9CO0FBQy9CO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxPQUFPO0FBQ2xCO0FBQ0EsV0FBVyxTQUFTO0FBQ3BCO0FBQ0EsV0FBVyxvQkFBb0I7QUFDL0I7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLGFBQWEscURBQUc7QUFDaEI7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLDBDQUEwQyxnRUFBVTtBQUNwRCxLQUFLO0FBQ0w7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLE9BQU87QUFDbEI7QUFDQSxXQUFXLCtDQUErQztBQUMxRDtBQUNBLGFBQWE7QUFDYjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxJQUFJLDJDQUFNOztBQUVWO0FBQ0Esc0JBQXNCLG1CQUFtQjtBQUN6QztBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLE9BQU87QUFDbEI7QUFDQSxXQUFXLGNBQWM7QUFDekI7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHNCQUFzQixtQkFBbUI7QUFDekM7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxPQUFPO0FBQ2xCO0FBQ0EsV0FBVywrQ0FBK0M7QUFDMUQ7QUFDQSxXQUFXLG9CQUFvQjtBQUMvQjtBQUNBLGFBQWE7QUFDYjtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EsYUFBYSxxREFBRztBQUNoQjtBQUNBOztBQUVBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsT0FBTztBQUNsQjtBQUNBLFdBQVcsTUFBTTtBQUNqQjtBQUNBLFdBQVcsb0JBQW9CO0FBQy9CO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBLGFBQWEsT0FBTztBQUNwQjs7QUFFQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsT0FBTztBQUNsQjtBQUNBLFdBQVcsTUFBTTtBQUNqQjtBQUNBLGFBQWE7QUFDYjtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsT0FBTztBQUNsQjtBQUNBLFdBQVcsT0FBTztBQUNsQjtBQUNBLFdBQVcsU0FBUztBQUNwQjtBQUNBLFdBQVcseURBQXlEO0FBQ3BFO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxPQUFPO0FBQ2xCO0FBQ0EsV0FBVyxjQUFjO0FBQ3pCO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLFdBQVcsb0JBQW9CO0FBQy9CO0FBQ0EsV0FBVyxLQUFLO0FBQ2hCO0FBQ0EsV0FBVyxLQUFLO0FBQ2hCO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsYUFBYSxRQUFRO0FBQ3JCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EsV0FBVyxvQkFBb0I7QUFDL0I7QUFDQSxXQUFXLFFBQVE7QUFDbkI7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhLFFBQVE7QUFDckI7QUFDQTtBQUNBO0FBQ0Esa0JBQWtCLCtEQUFVO0FBQzVCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE9BQU87QUFDUDtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLE9BQU87QUFDbEI7QUFDQSxXQUFXLFNBQVM7QUFDcEI7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0EsYUFBYSxPQUFPO0FBQ3BCO0FBQ0EsYUFBYSxvQkFBb0I7QUFDakM7QUFDQSxhQUFhLFFBQVE7QUFDckI7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0EsNkJBQTZCLE9BQU8sb0NBQW9DO0FBQ3hFO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsT0FBTztBQUNsQjtBQUNBLFdBQVcsK0NBQStDO0FBQzFEO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBLGFBQWEsT0FBTztBQUNwQjs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsUUFBUSwyQ0FBTTtBQUNkO0FBQ0EsUUFBUSwyQ0FBTTtBQUNkO0FBQ0EsUUFBUSwyQ0FBTTs7QUFFZDtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0E7QUFDQSxpQkFBaUIsU0FBUztBQUMxQjs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVSwyQ0FBTTtBQUNoQjtBQUNBLFVBQVU7QUFDVjtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7O0FBRUE7QUFDQSwrQkFBK0Isb0JBQW9CO0FBQ25EO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLE9BQU87QUFDbEI7QUFDQSxXQUFXLFNBQVM7QUFDcEI7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0EsYUFBYSxjQUFjO0FBQzNCO0FBQ0E7QUFDQSxhQUFhLHFCQUFxQjtBQUNsQztBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLGVBQWUsb0JBQW9CO0FBQ25DOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsT0FBTztBQUNsQjtBQUNBLFdBQVcsUUFBUTtBQUNuQjtBQUNBLFdBQVcsdUVBQXVFO0FBQ2xGO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBLGVBQWUsMERBQUk7O0FBRW5CO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0Esa0NBQWtDLGlFQUFNLFVBQVUsaUVBQU07QUFDeEQ7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLFFBQVEsNkRBQVc7QUFDbkI7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxPQUFPO0FBQ2xCO0FBQ0EsV0FBVyxRQUFRO0FBQ25CO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhLE9BQU87QUFDcEI7O0FBRUE7QUFDQSxJQUFJLDREQUFhO0FBQ2pCLElBQUk7QUFDSjtBQUNBLCtCQUErQixPQUFPO0FBQ3RDLDBCQUEwQix1REFBWTtBQUN0QztBQUNBO0FBQ0E7QUFDQTtBQUNBLE9BQU87QUFDUDtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWEsUUFBUTtBQUNyQjtBQUNBLGFBQWEsUUFBUTtBQUNyQjtBQUNBLGVBQWU7QUFDZjtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxPQUFPO0FBQ2xCO0FBQ0EsV0FBVyxRQUFRO0FBQ25CO0FBQ0EsV0FBVyxTQUFTO0FBQ3BCO0FBQ0EsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBLGFBQWEseUNBQXlDO0FBQ3REOztBQUVBO0FBQ0EsY0FBYztBQUNkLElBQUk7QUFDSjtBQUNBO0FBQ0EsZUFBZSxxREFBcUQ7QUFDcEU7O0FBRUE7QUFDQSxpQkFBaUIsc0JBQXNCO0FBQ3ZDLG1CQUFtQixxRUFBZ0I7QUFDbkMsV0FBVztBQUNYLFdBQVc7QUFDWDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxJQUFJLDBDQUFNO0FBQ1Y7QUFDQSxJQUFJO0FBQ0o7QUFDQSxNQUFNLHFFQUFnQjtBQUN0QixXQUFXO0FBQ1gsV0FBVztBQUNYOztBQUVBO0FBQ0E7QUFDQTtBQUNBLDRCQUE0Qiw2QkFBNkI7O0FBRXpEO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBLFdBQVcsT0FBTztBQUNsQixXQUFXLHNCQUFzQjtBQUNqQyxhQUFhO0FBQ2I7QUFDQTtBQUNBLHNCQUFzQix1REFBWTtBQUNsQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsT0FBTztBQUNsQixhQUFhO0FBQ2I7QUFDQTtBQUNBLGFBQWEsT0FBTztBQUNwQjtBQUNBLGFBQWEsUUFBUTtBQUNyQjs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxRQUFRO0FBQ25CLGFBQWE7QUFDYjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLFFBQVE7QUFDbkI7QUFDQSxXQUFXLFFBQVE7QUFDbkI7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLFFBQVE7QUFDbkI7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL3RodW5kZXItc2VhcmNoLy4vbm9kZV9tb2R1bGVzL2hhc3QtdXRpbC10by1qc3gtcnVudGltZS9saWIvaW5kZXguanM/ZDkxMiJdLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBpbXBvcnQge0lkZW50aWZpZXIsIExpdGVyYWwsIE1lbWJlckV4cHJlc3Npb259IGZyb20gJ2VzdHJlZSdcbiAqIEBpbXBvcnQge0pzeCwgSnN4RGV2LCBPcHRpb25zLCBQcm9wc30gZnJvbSAnaGFzdC11dGlsLXRvLWpzeC1ydW50aW1lJ1xuICogQGltcG9ydCB7RWxlbWVudCwgTm9kZXMsIFBhcmVudHMsIFJvb3QsIFRleHR9IGZyb20gJ2hhc3QnXG4gKiBAaW1wb3J0IHtNZHhGbG93RXhwcmVzc2lvbkhhc3QsIE1keFRleHRFeHByZXNzaW9uSGFzdH0gZnJvbSAnbWRhc3QtdXRpbC1tZHgtZXhwcmVzc2lvbidcbiAqIEBpbXBvcnQge01keEpzeEZsb3dFbGVtZW50SGFzdCwgTWR4SnN4VGV4dEVsZW1lbnRIYXN0fSBmcm9tICdtZGFzdC11dGlsLW1keC1qc3gnXG4gKiBAaW1wb3J0IHtNZHhqc0VzbUhhc3R9IGZyb20gJ21kYXN0LXV0aWwtbWR4anMtZXNtJ1xuICogQGltcG9ydCB7UG9zaXRpb259IGZyb20gJ3VuaXN0J1xuICogQGltcG9ydCB7Q2hpbGQsIENyZWF0ZSwgRmllbGQsIFN0YXRlLCBTdHlsZX0gZnJvbSAnLi90eXBlcy5qcydcbiAqL1xuXG5pbXBvcnQge3N0cmluZ2lmeSBhcyBjb21tYXN9IGZyb20gJ2NvbW1hLXNlcGFyYXRlZC10b2tlbnMnXG5pbXBvcnQge29rIGFzIGFzc2VydH0gZnJvbSAnZGV2bG9wJ1xuaW1wb3J0IHtuYW1lIGFzIGlzSWRlbnRpZmllck5hbWV9IGZyb20gJ2VzdHJlZS11dGlsLWlzLWlkZW50aWZpZXItbmFtZSdcbmltcG9ydCB7d2hpdGVzcGFjZX0gZnJvbSAnaGFzdC11dGlsLXdoaXRlc3BhY2UnXG5pbXBvcnQge2ZpbmQsIGhhc3RUb1JlYWN0LCBodG1sLCBzdmd9IGZyb20gJ3Byb3BlcnR5LWluZm9ybWF0aW9uJ1xuaW1wb3J0IHtzdHJpbmdpZnkgYXMgc3BhY2VzfSBmcm9tICdzcGFjZS1zZXBhcmF0ZWQtdG9rZW5zJ1xuaW1wb3J0IHN0eWxlVG9PYmplY3QgZnJvbSAnc3R5bGUtdG8tb2JqZWN0J1xuaW1wb3J0IHtwb2ludFN0YXJ0fSBmcm9tICd1bmlzdC11dGlsLXBvc2l0aW9uJ1xuaW1wb3J0IHtWRmlsZU1lc3NhZ2V9IGZyb20gJ3ZmaWxlLW1lc3NhZ2UnXG5cbi8vIFRvIGRvOiBuZXh0IG1ham9yOiBgT2JqZWN0Lmhhc093bmAuXG5jb25zdCBvd24gPSB7fS5oYXNPd25Qcm9wZXJ0eVxuXG4vKiogQHR5cGUge01hcDxzdHJpbmcsIG51bWJlcj59ICovXG5jb25zdCBlbXB0eU1hcCA9IG5ldyBNYXAoKVxuXG5jb25zdCBjYXAgPSAvW0EtWl0vZ1xuY29uc3QgZGFzaFNvbWV0aGluZyA9IC8tKFthLXpdKS9nXG5cbi8vIGByZWFjdC1kb21gIHRyaWdnZXJzIGEgd2FybmluZyBmb3IgKmFueSogd2hpdGUgc3BhY2UgaW4gdGFibGVzLlxuLy8gVG8gZm9sbG93IEdGTSwgYG1kYXN0LXV0aWwtdG8taGFzdGAgaW5qZWN0cyBsaW5lIGVuZGluZ3MgYmV0d2VlbiBlbGVtZW50cy5cbi8vIE90aGVyIHRvb2xzIG1pZ2h0IGRvIHNvIHRvbywgYnV0IHRoZXkgZG9u4oCZdCBkbyBoZXJlLCBzbyB3ZSByZW1vdmUgYWxsIG9mXG4vLyB0aGF0LlxuXG4vLyBTZWU6IDxodHRwczovL2dpdGh1Yi5jb20vZmFjZWJvb2svcmVhY3QvcHVsbC83MDgxPi5cbi8vIFNlZTogPGh0dHBzOi8vZ2l0aHViLmNvbS9mYWNlYm9vay9yZWFjdC9wdWxsLzc1MTU+LlxuLy8gU2VlOiA8aHR0cHM6Ly9naXRodWIuY29tL3JlbWFya2pzL3JlbWFyay1yZWFjdC9pc3N1ZXMvNjQ+LlxuLy8gU2VlOiA8aHR0cHM6Ly9naXRodWIuY29tL3JlaHlwZWpzL3JlaHlwZS1yZWFjdC9wdWxsLzI5Pi5cbi8vIFNlZTogPGh0dHBzOi8vZ2l0aHViLmNvbS9yZWh5cGVqcy9yZWh5cGUtcmVhY3QvcHVsbC8zMj4uXG4vLyBTZWU6IDxodHRwczovL2dpdGh1Yi5jb20vcmVoeXBlanMvcmVoeXBlLXJlYWN0L3B1bGwvNDU+LlxuY29uc3QgdGFibGVFbGVtZW50cyA9IG5ldyBTZXQoWyd0YWJsZScsICd0Ym9keScsICd0aGVhZCcsICd0Zm9vdCcsICd0ciddKVxuXG5jb25zdCB0YWJsZUNlbGxFbGVtZW50ID0gbmV3IFNldChbJ3RkJywgJ3RoJ10pXG5cbmNvbnN0IGRvY3MgPSAnaHR0cHM6Ly9naXRodWIuY29tL3N5bnRheC10cmVlL2hhc3QtdXRpbC10by1qc3gtcnVudGltZSdcblxuLyoqXG4gKiBUcmFuc2Zvcm0gYSBoYXN0IHRyZWUgdG8gcHJlYWN0LCByZWFjdCwgc29saWQsIHN2ZWx0ZSwgdnVlLCBldGMuLFxuICogd2l0aCBhbiBhdXRvbWF0aWMgSlNYIHJ1bnRpbWUuXG4gKlxuICogQHBhcmFtIHtOb2Rlc30gdHJlZVxuICogICBUcmVlIHRvIHRyYW5zZm9ybS5cbiAqIEBwYXJhbSB7T3B0aW9uc30gb3B0aW9uc1xuICogICBDb25maWd1cmF0aW9uIChyZXF1aXJlZCkuXG4gKiBAcmV0dXJucyB7SlNYLkVsZW1lbnR9XG4gKiAgIEpTWCBlbGVtZW50LlxuICovXG5cbmV4cG9ydCBmdW5jdGlvbiB0b0pzeFJ1bnRpbWUodHJlZSwgb3B0aW9ucykge1xuICBpZiAoIW9wdGlvbnMgfHwgb3B0aW9ucy5GcmFnbWVudCA9PT0gdW5kZWZpbmVkKSB7XG4gICAgdGhyb3cgbmV3IFR5cGVFcnJvcignRXhwZWN0ZWQgYEZyYWdtZW50YCBpbiBvcHRpb25zJylcbiAgfVxuXG4gIGNvbnN0IGZpbGVQYXRoID0gb3B0aW9ucy5maWxlUGF0aCB8fCB1bmRlZmluZWRcbiAgLyoqIEB0eXBlIHtDcmVhdGV9ICovXG4gIGxldCBjcmVhdGVcblxuICBpZiAob3B0aW9ucy5kZXZlbG9wbWVudCkge1xuICAgIGlmICh0eXBlb2Ygb3B0aW9ucy5qc3hERVYgIT09ICdmdW5jdGlvbicpIHtcbiAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoXG4gICAgICAgICdFeHBlY3RlZCBganN4REVWYCBpbiBvcHRpb25zIHdoZW4gYGRldmVsb3BtZW50OiB0cnVlYCdcbiAgICAgIClcbiAgICB9XG5cbiAgICBjcmVhdGUgPSBkZXZlbG9wbWVudENyZWF0ZShmaWxlUGF0aCwgb3B0aW9ucy5qc3hERVYpXG4gIH0gZWxzZSB7XG4gICAgaWYgKHR5cGVvZiBvcHRpb25zLmpzeCAhPT0gJ2Z1bmN0aW9uJykge1xuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcignRXhwZWN0ZWQgYGpzeGAgaW4gcHJvZHVjdGlvbiBvcHRpb25zJylcbiAgICB9XG5cbiAgICBpZiAodHlwZW9mIG9wdGlvbnMuanN4cyAhPT0gJ2Z1bmN0aW9uJykge1xuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcignRXhwZWN0ZWQgYGpzeHNgIGluIHByb2R1Y3Rpb24gb3B0aW9ucycpXG4gICAgfVxuXG4gICAgY3JlYXRlID0gcHJvZHVjdGlvbkNyZWF0ZShmaWxlUGF0aCwgb3B0aW9ucy5qc3gsIG9wdGlvbnMuanN4cylcbiAgfVxuXG4gIC8qKiBAdHlwZSB7U3RhdGV9ICovXG4gIGNvbnN0IHN0YXRlID0ge1xuICAgIEZyYWdtZW50OiBvcHRpb25zLkZyYWdtZW50LFxuICAgIGFuY2VzdG9yczogW10sXG4gICAgY29tcG9uZW50czogb3B0aW9ucy5jb21wb25lbnRzIHx8IHt9LFxuICAgIGNyZWF0ZSxcbiAgICBlbGVtZW50QXR0cmlidXRlTmFtZUNhc2U6IG9wdGlvbnMuZWxlbWVudEF0dHJpYnV0ZU5hbWVDYXNlIHx8ICdyZWFjdCcsXG4gICAgZXZhbHVhdGVyOiBvcHRpb25zLmNyZWF0ZUV2YWx1YXRlciA/IG9wdGlvbnMuY3JlYXRlRXZhbHVhdGVyKCkgOiB1bmRlZmluZWQsXG4gICAgZmlsZVBhdGgsXG4gICAgaWdub3JlSW52YWxpZFN0eWxlOiBvcHRpb25zLmlnbm9yZUludmFsaWRTdHlsZSB8fCBmYWxzZSxcbiAgICBwYXNzS2V5czogb3B0aW9ucy5wYXNzS2V5cyAhPT0gZmFsc2UsXG4gICAgcGFzc05vZGU6IG9wdGlvbnMucGFzc05vZGUgfHwgZmFsc2UsXG4gICAgc2NoZW1hOiBvcHRpb25zLnNwYWNlID09PSAnc3ZnJyA/IHN2ZyA6IGh0bWwsXG4gICAgc3R5bGVQcm9wZXJ0eU5hbWVDYXNlOiBvcHRpb25zLnN0eWxlUHJvcGVydHlOYW1lQ2FzZSB8fCAnZG9tJyxcbiAgICB0YWJsZUNlbGxBbGlnblRvU3R5bGU6IG9wdGlvbnMudGFibGVDZWxsQWxpZ25Ub1N0eWxlICE9PSBmYWxzZVxuICB9XG5cbiAgY29uc3QgcmVzdWx0ID0gb25lKHN0YXRlLCB0cmVlLCB1bmRlZmluZWQpXG5cbiAgLy8gSlNYIGVsZW1lbnQuXG4gIGlmIChyZXN1bHQgJiYgdHlwZW9mIHJlc3VsdCAhPT0gJ3N0cmluZycpIHtcbiAgICByZXR1cm4gcmVzdWx0XG4gIH1cblxuICAvLyBUZXh0IG5vZGUgb3Igc29tZXRoaW5nIHRoYXQgdHVybmVkIGludG8gbm90aGluZy5cbiAgcmV0dXJuIHN0YXRlLmNyZWF0ZShcbiAgICB0cmVlLFxuICAgIHN0YXRlLkZyYWdtZW50LFxuICAgIHtjaGlsZHJlbjogcmVzdWx0IHx8IHVuZGVmaW5lZH0sXG4gICAgdW5kZWZpbmVkXG4gIClcbn1cblxuLyoqXG4gKiBUcmFuc2Zvcm0gYSBub2RlLlxuICpcbiAqIEBwYXJhbSB7U3RhdGV9IHN0YXRlXG4gKiAgIEluZm8gcGFzc2VkIGFyb3VuZC5cbiAqIEBwYXJhbSB7Tm9kZXN9IG5vZGVcbiAqICAgQ3VycmVudCBub2RlLlxuICogQHBhcmFtIHtzdHJpbmcgfCB1bmRlZmluZWR9IGtleVxuICogICBLZXkuXG4gKiBAcmV0dXJucyB7Q2hpbGQgfCB1bmRlZmluZWR9XG4gKiAgIENoaWxkLCBvcHRpb25hbC5cbiAqL1xuZnVuY3Rpb24gb25lKHN0YXRlLCBub2RlLCBrZXkpIHtcbiAgaWYgKG5vZGUudHlwZSA9PT0gJ2VsZW1lbnQnKSB7XG4gICAgcmV0dXJuIGVsZW1lbnQoc3RhdGUsIG5vZGUsIGtleSlcbiAgfVxuXG4gIGlmIChub2RlLnR5cGUgPT09ICdtZHhGbG93RXhwcmVzc2lvbicgfHwgbm9kZS50eXBlID09PSAnbWR4VGV4dEV4cHJlc3Npb24nKSB7XG4gICAgcmV0dXJuIG1keEV4cHJlc3Npb24oc3RhdGUsIG5vZGUpXG4gIH1cblxuICBpZiAobm9kZS50eXBlID09PSAnbWR4SnN4Rmxvd0VsZW1lbnQnIHx8IG5vZGUudHlwZSA9PT0gJ21keEpzeFRleHRFbGVtZW50Jykge1xuICAgIHJldHVybiBtZHhKc3hFbGVtZW50KHN0YXRlLCBub2RlLCBrZXkpXG4gIH1cblxuICBpZiAobm9kZS50eXBlID09PSAnbWR4anNFc20nKSB7XG4gICAgcmV0dXJuIG1keEVzbShzdGF0ZSwgbm9kZSlcbiAgfVxuXG4gIGlmIChub2RlLnR5cGUgPT09ICdyb290Jykge1xuICAgIHJldHVybiByb290KHN0YXRlLCBub2RlLCBrZXkpXG4gIH1cblxuICBpZiAobm9kZS50eXBlID09PSAndGV4dCcpIHtcbiAgICByZXR1cm4gdGV4dChzdGF0ZSwgbm9kZSlcbiAgfVxufVxuXG4vKipcbiAqIEhhbmRsZSBlbGVtZW50LlxuICpcbiAqIEBwYXJhbSB7U3RhdGV9IHN0YXRlXG4gKiAgIEluZm8gcGFzc2VkIGFyb3VuZC5cbiAqIEBwYXJhbSB7RWxlbWVudH0gbm9kZVxuICogICBDdXJyZW50IG5vZGUuXG4gKiBAcGFyYW0ge3N0cmluZyB8IHVuZGVmaW5lZH0ga2V5XG4gKiAgIEtleS5cbiAqIEByZXR1cm5zIHtDaGlsZCB8IHVuZGVmaW5lZH1cbiAqICAgQ2hpbGQsIG9wdGlvbmFsLlxuICovXG5mdW5jdGlvbiBlbGVtZW50KHN0YXRlLCBub2RlLCBrZXkpIHtcbiAgY29uc3QgcGFyZW50U2NoZW1hID0gc3RhdGUuc2NoZW1hXG4gIGxldCBzY2hlbWEgPSBwYXJlbnRTY2hlbWFcblxuICBpZiAobm9kZS50YWdOYW1lLnRvTG93ZXJDYXNlKCkgPT09ICdzdmcnICYmIHBhcmVudFNjaGVtYS5zcGFjZSA9PT0gJ2h0bWwnKSB7XG4gICAgc2NoZW1hID0gc3ZnXG4gICAgc3RhdGUuc2NoZW1hID0gc2NoZW1hXG4gIH1cblxuICBzdGF0ZS5hbmNlc3RvcnMucHVzaChub2RlKVxuXG4gIGNvbnN0IHR5cGUgPSBmaW5kQ29tcG9uZW50RnJvbU5hbWUoc3RhdGUsIG5vZGUudGFnTmFtZSwgZmFsc2UpXG4gIGNvbnN0IHByb3BzID0gY3JlYXRlRWxlbWVudFByb3BzKHN0YXRlLCBub2RlKVxuICBsZXQgY2hpbGRyZW4gPSBjcmVhdGVDaGlsZHJlbihzdGF0ZSwgbm9kZSlcblxuICBpZiAodGFibGVFbGVtZW50cy5oYXMobm9kZS50YWdOYW1lKSkge1xuICAgIGNoaWxkcmVuID0gY2hpbGRyZW4uZmlsdGVyKGZ1bmN0aW9uIChjaGlsZCkge1xuICAgICAgcmV0dXJuIHR5cGVvZiBjaGlsZCA9PT0gJ3N0cmluZycgPyAhd2hpdGVzcGFjZShjaGlsZCkgOiB0cnVlXG4gICAgfSlcbiAgfVxuXG4gIGFkZE5vZGUoc3RhdGUsIHByb3BzLCB0eXBlLCBub2RlKVxuICBhZGRDaGlsZHJlbihwcm9wcywgY2hpbGRyZW4pXG5cbiAgLy8gUmVzdG9yZS5cbiAgc3RhdGUuYW5jZXN0b3JzLnBvcCgpXG4gIHN0YXRlLnNjaGVtYSA9IHBhcmVudFNjaGVtYVxuXG4gIHJldHVybiBzdGF0ZS5jcmVhdGUobm9kZSwgdHlwZSwgcHJvcHMsIGtleSlcbn1cblxuLyoqXG4gKiBIYW5kbGUgTURYIGV4cHJlc3Npb24uXG4gKlxuICogQHBhcmFtIHtTdGF0ZX0gc3RhdGVcbiAqICAgSW5mbyBwYXNzZWQgYXJvdW5kLlxuICogQHBhcmFtIHtNZHhGbG93RXhwcmVzc2lvbkhhc3QgfCBNZHhUZXh0RXhwcmVzc2lvbkhhc3R9IG5vZGVcbiAqICAgQ3VycmVudCBub2RlLlxuICogQHJldHVybnMge0NoaWxkIHwgdW5kZWZpbmVkfVxuICogICBDaGlsZCwgb3B0aW9uYWwuXG4gKi9cbmZ1bmN0aW9uIG1keEV4cHJlc3Npb24oc3RhdGUsIG5vZGUpIHtcbiAgaWYgKG5vZGUuZGF0YSAmJiBub2RlLmRhdGEuZXN0cmVlICYmIHN0YXRlLmV2YWx1YXRlcikge1xuICAgIGNvbnN0IHByb2dyYW0gPSBub2RlLmRhdGEuZXN0cmVlXG4gICAgY29uc3QgZXhwcmVzc2lvbiA9IHByb2dyYW0uYm9keVswXVxuICAgIGFzc2VydChleHByZXNzaW9uLnR5cGUgPT09ICdFeHByZXNzaW9uU3RhdGVtZW50JylcblxuICAgIC8vIEFzc3VtZSByZXN1bHQgaXMgYSBjaGlsZC5cbiAgICByZXR1cm4gLyoqIEB0eXBlIHtDaGlsZCB8IHVuZGVmaW5lZH0gKi8gKFxuICAgICAgc3RhdGUuZXZhbHVhdGVyLmV2YWx1YXRlRXhwcmVzc2lvbihleHByZXNzaW9uLmV4cHJlc3Npb24pXG4gICAgKVxuICB9XG5cbiAgY3Jhc2hFc3RyZWUoc3RhdGUsIG5vZGUucG9zaXRpb24pXG59XG5cbi8qKlxuICogSGFuZGxlIE1EWCBFU00uXG4gKlxuICogQHBhcmFtIHtTdGF0ZX0gc3RhdGVcbiAqICAgSW5mbyBwYXNzZWQgYXJvdW5kLlxuICogQHBhcmFtIHtNZHhqc0VzbUhhc3R9IG5vZGVcbiAqICAgQ3VycmVudCBub2RlLlxuICogQHJldHVybnMge0NoaWxkIHwgdW5kZWZpbmVkfVxuICogICBDaGlsZCwgb3B0aW9uYWwuXG4gKi9cbmZ1bmN0aW9uIG1keEVzbShzdGF0ZSwgbm9kZSkge1xuICBpZiAobm9kZS5kYXRhICYmIG5vZGUuZGF0YS5lc3RyZWUgJiYgc3RhdGUuZXZhbHVhdGVyKSB7XG4gICAgLy8gQXNzdW1lIHJlc3VsdCBpcyBhIGNoaWxkLlxuICAgIHJldHVybiAvKiogQHR5cGUge0NoaWxkIHwgdW5kZWZpbmVkfSAqLyAoXG4gICAgICBzdGF0ZS5ldmFsdWF0ZXIuZXZhbHVhdGVQcm9ncmFtKG5vZGUuZGF0YS5lc3RyZWUpXG4gICAgKVxuICB9XG5cbiAgY3Jhc2hFc3RyZWUoc3RhdGUsIG5vZGUucG9zaXRpb24pXG59XG5cbi8qKlxuICogSGFuZGxlIE1EWCBKU1guXG4gKlxuICogQHBhcmFtIHtTdGF0ZX0gc3RhdGVcbiAqICAgSW5mbyBwYXNzZWQgYXJvdW5kLlxuICogQHBhcmFtIHtNZHhKc3hGbG93RWxlbWVudEhhc3QgfCBNZHhKc3hUZXh0RWxlbWVudEhhc3R9IG5vZGVcbiAqICAgQ3VycmVudCBub2RlLlxuICogQHBhcmFtIHtzdHJpbmcgfCB1bmRlZmluZWR9IGtleVxuICogICBLZXkuXG4gKiBAcmV0dXJucyB7Q2hpbGQgfCB1bmRlZmluZWR9XG4gKiAgIENoaWxkLCBvcHRpb25hbC5cbiAqL1xuZnVuY3Rpb24gbWR4SnN4RWxlbWVudChzdGF0ZSwgbm9kZSwga2V5KSB7XG4gIGNvbnN0IHBhcmVudFNjaGVtYSA9IHN0YXRlLnNjaGVtYVxuICBsZXQgc2NoZW1hID0gcGFyZW50U2NoZW1hXG5cbiAgaWYgKG5vZGUubmFtZSA9PT0gJ3N2ZycgJiYgcGFyZW50U2NoZW1hLnNwYWNlID09PSAnaHRtbCcpIHtcbiAgICBzY2hlbWEgPSBzdmdcbiAgICBzdGF0ZS5zY2hlbWEgPSBzY2hlbWFcbiAgfVxuXG4gIHN0YXRlLmFuY2VzdG9ycy5wdXNoKG5vZGUpXG5cbiAgY29uc3QgdHlwZSA9XG4gICAgbm9kZS5uYW1lID09PSBudWxsXG4gICAgICA/IHN0YXRlLkZyYWdtZW50XG4gICAgICA6IGZpbmRDb21wb25lbnRGcm9tTmFtZShzdGF0ZSwgbm9kZS5uYW1lLCB0cnVlKVxuICBjb25zdCBwcm9wcyA9IGNyZWF0ZUpzeEVsZW1lbnRQcm9wcyhzdGF0ZSwgbm9kZSlcbiAgY29uc3QgY2hpbGRyZW4gPSBjcmVhdGVDaGlsZHJlbihzdGF0ZSwgbm9kZSlcblxuICBhZGROb2RlKHN0YXRlLCBwcm9wcywgdHlwZSwgbm9kZSlcbiAgYWRkQ2hpbGRyZW4ocHJvcHMsIGNoaWxkcmVuKVxuXG4gIC8vIFJlc3RvcmUuXG4gIHN0YXRlLmFuY2VzdG9ycy5wb3AoKVxuICBzdGF0ZS5zY2hlbWEgPSBwYXJlbnRTY2hlbWFcblxuICByZXR1cm4gc3RhdGUuY3JlYXRlKG5vZGUsIHR5cGUsIHByb3BzLCBrZXkpXG59XG5cbi8qKlxuICogSGFuZGxlIHJvb3QuXG4gKlxuICogQHBhcmFtIHtTdGF0ZX0gc3RhdGVcbiAqICAgSW5mbyBwYXNzZWQgYXJvdW5kLlxuICogQHBhcmFtIHtSb290fSBub2RlXG4gKiAgIEN1cnJlbnQgbm9kZS5cbiAqIEBwYXJhbSB7c3RyaW5nIHwgdW5kZWZpbmVkfSBrZXlcbiAqICAgS2V5LlxuICogQHJldHVybnMge0NoaWxkIHwgdW5kZWZpbmVkfVxuICogICBDaGlsZCwgb3B0aW9uYWwuXG4gKi9cbmZ1bmN0aW9uIHJvb3Qoc3RhdGUsIG5vZGUsIGtleSkge1xuICAvKiogQHR5cGUge1Byb3BzfSAqL1xuICBjb25zdCBwcm9wcyA9IHt9XG5cbiAgYWRkQ2hpbGRyZW4ocHJvcHMsIGNyZWF0ZUNoaWxkcmVuKHN0YXRlLCBub2RlKSlcblxuICByZXR1cm4gc3RhdGUuY3JlYXRlKG5vZGUsIHN0YXRlLkZyYWdtZW50LCBwcm9wcywga2V5KVxufVxuXG4vKipcbiAqIEhhbmRsZSB0ZXh0LlxuICpcbiAqIEBwYXJhbSB7U3RhdGV9IF9cbiAqICAgSW5mbyBwYXNzZWQgYXJvdW5kLlxuICogQHBhcmFtIHtUZXh0fSBub2RlXG4gKiAgIEN1cnJlbnQgbm9kZS5cbiAqIEByZXR1cm5zIHtDaGlsZCB8IHVuZGVmaW5lZH1cbiAqICAgQ2hpbGQsIG9wdGlvbmFsLlxuICovXG5mdW5jdGlvbiB0ZXh0KF8sIG5vZGUpIHtcbiAgcmV0dXJuIG5vZGUudmFsdWVcbn1cblxuLyoqXG4gKiBBZGQgYG5vZGVgIHRvIHByb3BzLlxuICpcbiAqIEBwYXJhbSB7U3RhdGV9IHN0YXRlXG4gKiAgIEluZm8gcGFzc2VkIGFyb3VuZC5cbiAqIEBwYXJhbSB7UHJvcHN9IHByb3BzXG4gKiAgIFByb3BzLlxuICogQHBhcmFtIHt1bmtub3dufSB0eXBlXG4gKiAgIFR5cGUuXG4gKiBAcGFyYW0ge0VsZW1lbnQgfCBNZHhKc3hGbG93RWxlbWVudEhhc3QgfCBNZHhKc3hUZXh0RWxlbWVudEhhc3R9IG5vZGVcbiAqICAgTm9kZS5cbiAqIEByZXR1cm5zIHt1bmRlZmluZWR9XG4gKiAgIE5vdGhpbmcuXG4gKi9cbmZ1bmN0aW9uIGFkZE5vZGUoc3RhdGUsIHByb3BzLCB0eXBlLCBub2RlKSB7XG4gIC8vIElmIHRoaXMgaXMgc3dhcHBlZCBvdXQgZm9yIGEgY29tcG9uZW50OlxuICBpZiAodHlwZW9mIHR5cGUgIT09ICdzdHJpbmcnICYmIHR5cGUgIT09IHN0YXRlLkZyYWdtZW50ICYmIHN0YXRlLnBhc3NOb2RlKSB7XG4gICAgcHJvcHMubm9kZSA9IG5vZGVcbiAgfVxufVxuXG4vKipcbiAqIEFkZCBjaGlsZHJlbiB0byBwcm9wcy5cbiAqXG4gKiBAcGFyYW0ge1Byb3BzfSBwcm9wc1xuICogICBQcm9wcy5cbiAqIEBwYXJhbSB7QXJyYXk8Q2hpbGQ+fSBjaGlsZHJlblxuICogICBDaGlsZHJlbi5cbiAqIEByZXR1cm5zIHt1bmRlZmluZWR9XG4gKiAgIE5vdGhpbmcuXG4gKi9cbmZ1bmN0aW9uIGFkZENoaWxkcmVuKHByb3BzLCBjaGlsZHJlbikge1xuICBpZiAoY2hpbGRyZW4ubGVuZ3RoID4gMCkge1xuICAgIGNvbnN0IHZhbHVlID0gY2hpbGRyZW4ubGVuZ3RoID4gMSA/IGNoaWxkcmVuIDogY2hpbGRyZW5bMF1cblxuICAgIGlmICh2YWx1ZSkge1xuICAgICAgcHJvcHMuY2hpbGRyZW4gPSB2YWx1ZVxuICAgIH1cbiAgfVxufVxuXG4vKipcbiAqIEBwYXJhbSB7c3RyaW5nIHwgdW5kZWZpbmVkfSBfXG4gKiAgIFBhdGggdG8gZmlsZS5cbiAqIEBwYXJhbSB7SnN4fSBqc3hcbiAqICAgRHluYW1pYy5cbiAqIEBwYXJhbSB7SnN4fSBqc3hzXG4gKiAgIFN0YXRpYy5cbiAqIEByZXR1cm5zIHtDcmVhdGV9XG4gKiAgIENyZWF0ZSBhIHByb2R1Y3Rpb24gZWxlbWVudC5cbiAqL1xuZnVuY3Rpb24gcHJvZHVjdGlvbkNyZWF0ZShfLCBqc3gsIGpzeHMpIHtcbiAgcmV0dXJuIGNyZWF0ZVxuICAvKiogQHR5cGUge0NyZWF0ZX0gKi9cbiAgZnVuY3Rpb24gY3JlYXRlKF8sIHR5cGUsIHByb3BzLCBrZXkpIHtcbiAgICAvLyBPbmx5IGFuIGFycmF5IHdoZW4gdGhlcmUgYXJlIDIgb3IgbW9yZSBjaGlsZHJlbi5cbiAgICBjb25zdCBpc1N0YXRpY0NoaWxkcmVuID0gQXJyYXkuaXNBcnJheShwcm9wcy5jaGlsZHJlbilcbiAgICBjb25zdCBmbiA9IGlzU3RhdGljQ2hpbGRyZW4gPyBqc3hzIDoganN4XG4gICAgcmV0dXJuIGtleSA/IGZuKHR5cGUsIHByb3BzLCBrZXkpIDogZm4odHlwZSwgcHJvcHMpXG4gIH1cbn1cblxuLyoqXG4gKiBAcGFyYW0ge3N0cmluZyB8IHVuZGVmaW5lZH0gZmlsZVBhdGhcbiAqICAgUGF0aCB0byBmaWxlLlxuICogQHBhcmFtIHtKc3hEZXZ9IGpzeERFVlxuICogICBEZXZlbG9wbWVudC5cbiAqIEByZXR1cm5zIHtDcmVhdGV9XG4gKiAgIENyZWF0ZSBhIGRldmVsb3BtZW50IGVsZW1lbnQuXG4gKi9cbmZ1bmN0aW9uIGRldmVsb3BtZW50Q3JlYXRlKGZpbGVQYXRoLCBqc3hERVYpIHtcbiAgcmV0dXJuIGNyZWF0ZVxuICAvKiogQHR5cGUge0NyZWF0ZX0gKi9cbiAgZnVuY3Rpb24gY3JlYXRlKG5vZGUsIHR5cGUsIHByb3BzLCBrZXkpIHtcbiAgICAvLyBPbmx5IGFuIGFycmF5IHdoZW4gdGhlcmUgYXJlIDIgb3IgbW9yZSBjaGlsZHJlbi5cbiAgICBjb25zdCBpc1N0YXRpY0NoaWxkcmVuID0gQXJyYXkuaXNBcnJheShwcm9wcy5jaGlsZHJlbilcbiAgICBjb25zdCBwb2ludCA9IHBvaW50U3RhcnQobm9kZSlcbiAgICByZXR1cm4ganN4REVWKFxuICAgICAgdHlwZSxcbiAgICAgIHByb3BzLFxuICAgICAga2V5LFxuICAgICAgaXNTdGF0aWNDaGlsZHJlbixcbiAgICAgIHtcbiAgICAgICAgY29sdW1uTnVtYmVyOiBwb2ludCA/IHBvaW50LmNvbHVtbiAtIDEgOiB1bmRlZmluZWQsXG4gICAgICAgIGZpbGVOYW1lOiBmaWxlUGF0aCxcbiAgICAgICAgbGluZU51bWJlcjogcG9pbnQgPyBwb2ludC5saW5lIDogdW5kZWZpbmVkXG4gICAgICB9LFxuICAgICAgdW5kZWZpbmVkXG4gICAgKVxuICB9XG59XG5cbi8qKlxuICogQ3JlYXRlIHByb3BzIGZyb20gYW4gZWxlbWVudC5cbiAqXG4gKiBAcGFyYW0ge1N0YXRlfSBzdGF0ZVxuICogICBJbmZvIHBhc3NlZCBhcm91bmQuXG4gKiBAcGFyYW0ge0VsZW1lbnR9IG5vZGVcbiAqICAgQ3VycmVudCBlbGVtZW50LlxuICogQHJldHVybnMge1Byb3BzfVxuICogICBQcm9wcy5cbiAqL1xuZnVuY3Rpb24gY3JlYXRlRWxlbWVudFByb3BzKHN0YXRlLCBub2RlKSB7XG4gIC8qKiBAdHlwZSB7UHJvcHN9ICovXG4gIGNvbnN0IHByb3BzID0ge31cbiAgLyoqIEB0eXBlIHtzdHJpbmcgfCB1bmRlZmluZWR9ICovXG4gIGxldCBhbGlnblZhbHVlXG4gIC8qKiBAdHlwZSB7c3RyaW5nfSAqL1xuICBsZXQgcHJvcFxuXG4gIGZvciAocHJvcCBpbiBub2RlLnByb3BlcnRpZXMpIHtcbiAgICBpZiAocHJvcCAhPT0gJ2NoaWxkcmVuJyAmJiBvd24uY2FsbChub2RlLnByb3BlcnRpZXMsIHByb3ApKSB7XG4gICAgICBjb25zdCByZXN1bHQgPSBjcmVhdGVQcm9wZXJ0eShzdGF0ZSwgcHJvcCwgbm9kZS5wcm9wZXJ0aWVzW3Byb3BdKVxuXG4gICAgICBpZiAocmVzdWx0KSB7XG4gICAgICAgIGNvbnN0IFtrZXksIHZhbHVlXSA9IHJlc3VsdFxuXG4gICAgICAgIGlmIChcbiAgICAgICAgICBzdGF0ZS50YWJsZUNlbGxBbGlnblRvU3R5bGUgJiZcbiAgICAgICAgICBrZXkgPT09ICdhbGlnbicgJiZcbiAgICAgICAgICB0eXBlb2YgdmFsdWUgPT09ICdzdHJpbmcnICYmXG4gICAgICAgICAgdGFibGVDZWxsRWxlbWVudC5oYXMobm9kZS50YWdOYW1lKVxuICAgICAgICApIHtcbiAgICAgICAgICBhbGlnblZhbHVlID0gdmFsdWVcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBwcm9wc1trZXldID0gdmFsdWVcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgfVxuXG4gIGlmIChhbGlnblZhbHVlKSB7XG4gICAgLy8gQXNzdW1lIHN0eWxlIGlzIGFuIG9iamVjdC5cbiAgICBjb25zdCBzdHlsZSA9IC8qKiBAdHlwZSB7U3R5bGV9ICovIChwcm9wcy5zdHlsZSB8fCAocHJvcHMuc3R5bGUgPSB7fSkpXG4gICAgc3R5bGVbc3RhdGUuc3R5bGVQcm9wZXJ0eU5hbWVDYXNlID09PSAnY3NzJyA/ICd0ZXh0LWFsaWduJyA6ICd0ZXh0QWxpZ24nXSA9XG4gICAgICBhbGlnblZhbHVlXG4gIH1cblxuICByZXR1cm4gcHJvcHNcbn1cblxuLyoqXG4gKiBDcmVhdGUgcHJvcHMgZnJvbSBhIEpTWCBlbGVtZW50LlxuICpcbiAqIEBwYXJhbSB7U3RhdGV9IHN0YXRlXG4gKiAgIEluZm8gcGFzc2VkIGFyb3VuZC5cbiAqIEBwYXJhbSB7TWR4SnN4Rmxvd0VsZW1lbnRIYXN0IHwgTWR4SnN4VGV4dEVsZW1lbnRIYXN0fSBub2RlXG4gKiAgIEN1cnJlbnQgSlNYIGVsZW1lbnQuXG4gKiBAcmV0dXJucyB7UHJvcHN9XG4gKiAgIFByb3BzLlxuICovXG5mdW5jdGlvbiBjcmVhdGVKc3hFbGVtZW50UHJvcHMoc3RhdGUsIG5vZGUpIHtcbiAgLyoqIEB0eXBlIHtQcm9wc30gKi9cbiAgY29uc3QgcHJvcHMgPSB7fVxuXG4gIGZvciAoY29uc3QgYXR0cmlidXRlIG9mIG5vZGUuYXR0cmlidXRlcykge1xuICAgIGlmIChhdHRyaWJ1dGUudHlwZSA9PT0gJ21keEpzeEV4cHJlc3Npb25BdHRyaWJ1dGUnKSB7XG4gICAgICBpZiAoYXR0cmlidXRlLmRhdGEgJiYgYXR0cmlidXRlLmRhdGEuZXN0cmVlICYmIHN0YXRlLmV2YWx1YXRlcikge1xuICAgICAgICBjb25zdCBwcm9ncmFtID0gYXR0cmlidXRlLmRhdGEuZXN0cmVlXG4gICAgICAgIGNvbnN0IGV4cHJlc3Npb24gPSBwcm9ncmFtLmJvZHlbMF1cbiAgICAgICAgYXNzZXJ0KGV4cHJlc3Npb24udHlwZSA9PT0gJ0V4cHJlc3Npb25TdGF0ZW1lbnQnKVxuICAgICAgICBjb25zdCBvYmplY3RFeHByZXNzaW9uID0gZXhwcmVzc2lvbi5leHByZXNzaW9uXG4gICAgICAgIGFzc2VydChvYmplY3RFeHByZXNzaW9uLnR5cGUgPT09ICdPYmplY3RFeHByZXNzaW9uJylcbiAgICAgICAgY29uc3QgcHJvcGVydHkgPSBvYmplY3RFeHByZXNzaW9uLnByb3BlcnRpZXNbMF1cbiAgICAgICAgYXNzZXJ0KHByb3BlcnR5LnR5cGUgPT09ICdTcHJlYWRFbGVtZW50JylcblxuICAgICAgICBPYmplY3QuYXNzaWduKFxuICAgICAgICAgIHByb3BzLFxuICAgICAgICAgIHN0YXRlLmV2YWx1YXRlci5ldmFsdWF0ZUV4cHJlc3Npb24ocHJvcGVydHkuYXJndW1lbnQpXG4gICAgICAgIClcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIGNyYXNoRXN0cmVlKHN0YXRlLCBub2RlLnBvc2l0aW9uKVxuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICAvLyBGb3IgSlNYLCB0aGUgYXV0aG9yIGlzIHJlc3BvbnNpYmxlIG9mIHBhc3NpbmcgaW4gdGhlIGNvcnJlY3QgdmFsdWVzLlxuICAgICAgY29uc3QgbmFtZSA9IGF0dHJpYnV0ZS5uYW1lXG4gICAgICAvKiogQHR5cGUge3Vua25vd259ICovXG4gICAgICBsZXQgdmFsdWVcblxuICAgICAgaWYgKGF0dHJpYnV0ZS52YWx1ZSAmJiB0eXBlb2YgYXR0cmlidXRlLnZhbHVlID09PSAnb2JqZWN0Jykge1xuICAgICAgICBpZiAoXG4gICAgICAgICAgYXR0cmlidXRlLnZhbHVlLmRhdGEgJiZcbiAgICAgICAgICBhdHRyaWJ1dGUudmFsdWUuZGF0YS5lc3RyZWUgJiZcbiAgICAgICAgICBzdGF0ZS5ldmFsdWF0ZXJcbiAgICAgICAgKSB7XG4gICAgICAgICAgY29uc3QgcHJvZ3JhbSA9IGF0dHJpYnV0ZS52YWx1ZS5kYXRhLmVzdHJlZVxuICAgICAgICAgIGNvbnN0IGV4cHJlc3Npb24gPSBwcm9ncmFtLmJvZHlbMF1cbiAgICAgICAgICBhc3NlcnQoZXhwcmVzc2lvbi50eXBlID09PSAnRXhwcmVzc2lvblN0YXRlbWVudCcpXG4gICAgICAgICAgdmFsdWUgPSBzdGF0ZS5ldmFsdWF0ZXIuZXZhbHVhdGVFeHByZXNzaW9uKGV4cHJlc3Npb24uZXhwcmVzc2lvbilcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBjcmFzaEVzdHJlZShzdGF0ZSwgbm9kZS5wb3NpdGlvbilcbiAgICAgICAgfVxuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdmFsdWUgPSBhdHRyaWJ1dGUudmFsdWUgPT09IG51bGwgPyB0cnVlIDogYXR0cmlidXRlLnZhbHVlXG4gICAgICB9XG5cbiAgICAgIC8vIEFzc3VtZSBhIHByb3AuXG4gICAgICBwcm9wc1tuYW1lXSA9IC8qKiBAdHlwZSB7UHJvcHNba2V5b2YgUHJvcHNdfSAqLyAodmFsdWUpXG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHByb3BzXG59XG5cbi8qKlxuICogQ3JlYXRlIGNoaWxkcmVuLlxuICpcbiAqIEBwYXJhbSB7U3RhdGV9IHN0YXRlXG4gKiAgIEluZm8gcGFzc2VkIGFyb3VuZC5cbiAqIEBwYXJhbSB7UGFyZW50c30gbm9kZVxuICogICBDdXJyZW50IGVsZW1lbnQuXG4gKiBAcmV0dXJucyB7QXJyYXk8Q2hpbGQ+fVxuICogICBDaGlsZHJlbi5cbiAqL1xuZnVuY3Rpb24gY3JlYXRlQ2hpbGRyZW4oc3RhdGUsIG5vZGUpIHtcbiAgLyoqIEB0eXBlIHtBcnJheTxDaGlsZD59ICovXG4gIGNvbnN0IGNoaWxkcmVuID0gW11cbiAgbGV0IGluZGV4ID0gLTFcbiAgLyoqIEB0eXBlIHtNYXA8c3RyaW5nLCBudW1iZXI+fSAqL1xuICAvLyBOb3RlOiB0ZXN0IHRoaXMgd2hlbiBTb2xpZCBkb2VzbuKAmXQgd2FudCB0byBtZXJnZSBteSB1cGNvbWluZyBQUi5cbiAgLyogYzggaWdub3JlIG5leHQgKi9cbiAgY29uc3QgY291bnRzQnlOYW1lID0gc3RhdGUucGFzc0tleXMgPyBuZXcgTWFwKCkgOiBlbXB0eU1hcFxuXG4gIHdoaWxlICgrK2luZGV4IDwgbm9kZS5jaGlsZHJlbi5sZW5ndGgpIHtcbiAgICBjb25zdCBjaGlsZCA9IG5vZGUuY2hpbGRyZW5baW5kZXhdXG4gICAgLyoqIEB0eXBlIHtzdHJpbmcgfCB1bmRlZmluZWR9ICovXG4gICAgbGV0IGtleVxuXG4gICAgaWYgKHN0YXRlLnBhc3NLZXlzKSB7XG4gICAgICBjb25zdCBuYW1lID1cbiAgICAgICAgY2hpbGQudHlwZSA9PT0gJ2VsZW1lbnQnXG4gICAgICAgICAgPyBjaGlsZC50YWdOYW1lXG4gICAgICAgICAgOiBjaGlsZC50eXBlID09PSAnbWR4SnN4Rmxvd0VsZW1lbnQnIHx8XG4gICAgICAgICAgICAgIGNoaWxkLnR5cGUgPT09ICdtZHhKc3hUZXh0RWxlbWVudCdcbiAgICAgICAgICAgID8gY2hpbGQubmFtZVxuICAgICAgICAgICAgOiB1bmRlZmluZWRcblxuICAgICAgaWYgKG5hbWUpIHtcbiAgICAgICAgY29uc3QgY291bnQgPSBjb3VudHNCeU5hbWUuZ2V0KG5hbWUpIHx8IDBcbiAgICAgICAga2V5ID0gbmFtZSArICctJyArIGNvdW50XG4gICAgICAgIGNvdW50c0J5TmFtZS5zZXQobmFtZSwgY291bnQgKyAxKVxuICAgICAgfVxuICAgIH1cblxuICAgIGNvbnN0IHJlc3VsdCA9IG9uZShzdGF0ZSwgY2hpbGQsIGtleSlcbiAgICBpZiAocmVzdWx0ICE9PSB1bmRlZmluZWQpIGNoaWxkcmVuLnB1c2gocmVzdWx0KVxuICB9XG5cbiAgcmV0dXJuIGNoaWxkcmVuXG59XG5cbi8qKlxuICogSGFuZGxlIGEgcHJvcGVydHkuXG4gKlxuICogQHBhcmFtIHtTdGF0ZX0gc3RhdGVcbiAqICAgSW5mbyBwYXNzZWQgYXJvdW5kLlxuICogQHBhcmFtIHtzdHJpbmd9IHByb3BcbiAqICAgS2V5LlxuICogQHBhcmFtIHtBcnJheTxudW1iZXIgfCBzdHJpbmc+IHwgYm9vbGVhbiB8IG51bWJlciB8IHN0cmluZyB8IG51bGwgfCB1bmRlZmluZWR9IHZhbHVlXG4gKiAgIGhhc3QgcHJvcGVydHkgdmFsdWUuXG4gKiBAcmV0dXJucyB7RmllbGQgfCB1bmRlZmluZWR9XG4gKiAgIEZpZWxkIGZvciBydW50aW1lLCBvcHRpb25hbC5cbiAqL1xuZnVuY3Rpb24gY3JlYXRlUHJvcGVydHkoc3RhdGUsIHByb3AsIHZhbHVlKSB7XG4gIGNvbnN0IGluZm8gPSBmaW5kKHN0YXRlLnNjaGVtYSwgcHJvcClcblxuICAvLyBJZ25vcmUgbnVsbGlzaCBhbmQgYE5hTmAgdmFsdWVzLlxuICBpZiAoXG4gICAgdmFsdWUgPT09IG51bGwgfHxcbiAgICB2YWx1ZSA9PT0gdW5kZWZpbmVkIHx8XG4gICAgKHR5cGVvZiB2YWx1ZSA9PT0gJ251bWJlcicgJiYgTnVtYmVyLmlzTmFOKHZhbHVlKSlcbiAgKSB7XG4gICAgcmV0dXJuXG4gIH1cblxuICBpZiAoQXJyYXkuaXNBcnJheSh2YWx1ZSkpIHtcbiAgICAvLyBBY2NlcHQgYGFycmF5YC5cbiAgICAvLyBNb3N0IHByb3BzIGFyZSBzcGFjZS1zZXBhcmF0ZWQuXG4gICAgdmFsdWUgPSBpbmZvLmNvbW1hU2VwYXJhdGVkID8gY29tbWFzKHZhbHVlKSA6IHNwYWNlcyh2YWx1ZSlcbiAgfVxuXG4gIC8vIFJlYWN0IG9ubHkgYWNjZXB0cyBgc3R5bGVgIGFzIG9iamVjdC5cbiAgaWYgKGluZm8ucHJvcGVydHkgPT09ICdzdHlsZScpIHtcbiAgICBsZXQgc3R5bGVPYmplY3QgPVxuICAgICAgdHlwZW9mIHZhbHVlID09PSAnb2JqZWN0JyA/IHZhbHVlIDogcGFyc2VTdHlsZShzdGF0ZSwgU3RyaW5nKHZhbHVlKSlcblxuICAgIGlmIChzdGF0ZS5zdHlsZVByb3BlcnR5TmFtZUNhc2UgPT09ICdjc3MnKSB7XG4gICAgICBzdHlsZU9iamVjdCA9IHRyYW5zZm9ybVN0eWxlc1RvQ3NzQ2FzaW5nKHN0eWxlT2JqZWN0KVxuICAgIH1cblxuICAgIHJldHVybiBbJ3N0eWxlJywgc3R5bGVPYmplY3RdXG4gIH1cblxuICByZXR1cm4gW1xuICAgIHN0YXRlLmVsZW1lbnRBdHRyaWJ1dGVOYW1lQ2FzZSA9PT0gJ3JlYWN0JyAmJiBpbmZvLnNwYWNlXG4gICAgICA/IGhhc3RUb1JlYWN0W2luZm8ucHJvcGVydHldIHx8IGluZm8ucHJvcGVydHlcbiAgICAgIDogaW5mby5hdHRyaWJ1dGUsXG4gICAgdmFsdWVcbiAgXVxufVxuXG4vKipcbiAqIFBhcnNlIGEgQ1NTIGRlY2xhcmF0aW9uIHRvIGFuIG9iamVjdC5cbiAqXG4gKiBAcGFyYW0ge1N0YXRlfSBzdGF0ZVxuICogICBJbmZvIHBhc3NlZCBhcm91bmQuXG4gKiBAcGFyYW0ge3N0cmluZ30gdmFsdWVcbiAqICAgQ1NTIGRlY2xhcmF0aW9ucy5cbiAqIEByZXR1cm5zIHtTdHlsZX1cbiAqICAgUHJvcGVydGllcy5cbiAqIEB0aHJvd3NcbiAqICAgVGhyb3dzIGBWRmlsZU1lc3NhZ2VgIHdoZW4gQ1NTIGNhbm5vdCBiZSBwYXJzZWQuXG4gKi9cbmZ1bmN0aW9uIHBhcnNlU3R5bGUoc3RhdGUsIHZhbHVlKSB7XG4gIC8qKiBAdHlwZSB7U3R5bGV9ICovXG4gIGNvbnN0IHJlc3VsdCA9IHt9XG5cbiAgdHJ5IHtcbiAgICBzdHlsZVRvT2JqZWN0KHZhbHVlLCByZXBsYWNlcilcbiAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICBpZiAoIXN0YXRlLmlnbm9yZUludmFsaWRTdHlsZSkge1xuICAgICAgY29uc3QgY2F1c2UgPSAvKiogQHR5cGUge0Vycm9yfSAqLyAoZXJyb3IpXG4gICAgICBjb25zdCBtZXNzYWdlID0gbmV3IFZGaWxlTWVzc2FnZSgnQ2Fubm90IHBhcnNlIGBzdHlsZWAgYXR0cmlidXRlJywge1xuICAgICAgICBhbmNlc3RvcnM6IHN0YXRlLmFuY2VzdG9ycyxcbiAgICAgICAgY2F1c2UsXG4gICAgICAgIHJ1bGVJZDogJ3N0eWxlJyxcbiAgICAgICAgc291cmNlOiAnaGFzdC11dGlsLXRvLWpzeC1ydW50aW1lJ1xuICAgICAgfSlcbiAgICAgIG1lc3NhZ2UuZmlsZSA9IHN0YXRlLmZpbGVQYXRoIHx8IHVuZGVmaW5lZFxuICAgICAgbWVzc2FnZS51cmwgPSBkb2NzICsgJyNjYW5ub3QtcGFyc2Utc3R5bGUtYXR0cmlidXRlJ1xuXG4gICAgICB0aHJvdyBtZXNzYWdlXG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHJlc3VsdFxuXG4gIC8qKlxuICAgKiBBZGQgYSBDU1MgcHJvcGVydHkgKG5vcm1hbCwgc28gd2l0aCBkYXNoZXMpIHRvIGByZXN1bHRgIGFzIGEgRE9NIENTU1xuICAgKiBwcm9wZXJ0eS5cbiAgICpcbiAgICogQHBhcmFtIHtzdHJpbmd9IG5hbWVcbiAgICogICBLZXkuXG4gICAqIEBwYXJhbSB7c3RyaW5nfSB2YWx1ZVxuICAgKiAgIFZhbHVlXG4gICAqIEByZXR1cm5zIHt1bmRlZmluZWR9XG4gICAqICAgTm90aGluZy5cbiAgICovXG4gIGZ1bmN0aW9uIHJlcGxhY2VyKG5hbWUsIHZhbHVlKSB7XG4gICAgbGV0IGtleSA9IG5hbWVcblxuICAgIGlmIChrZXkuc2xpY2UoMCwgMikgIT09ICctLScpIHtcbiAgICAgIGlmIChrZXkuc2xpY2UoMCwgNCkgPT09ICctbXMtJykga2V5ID0gJ21zLScgKyBrZXkuc2xpY2UoNClcbiAgICAgIGtleSA9IGtleS5yZXBsYWNlKGRhc2hTb21ldGhpbmcsIHRvQ2FtZWwpXG4gICAgfVxuXG4gICAgcmVzdWx0W2tleV0gPSB2YWx1ZVxuICB9XG59XG5cbi8qKlxuICogQ3JlYXRlIGEgSlNYIG5hbWUgZnJvbSBhIHN0cmluZy5cbiAqXG4gKiBAcGFyYW0ge1N0YXRlfSBzdGF0ZVxuICogICBUbyBkby5cbiAqIEBwYXJhbSB7c3RyaW5nfSBuYW1lXG4gKiAgIE5hbWUuXG4gKiBAcGFyYW0ge2Jvb2xlYW59IGFsbG93RXhwcmVzc2lvblxuICogICBBbGxvdyBtZW1iZXIgZXhwcmVzc2lvbnMgYW5kIGlkZW50aWZpZXJzLlxuICogQHJldHVybnMge3Vua25vd259XG4gKiAgIFRvIGRvLlxuICovXG5mdW5jdGlvbiBmaW5kQ29tcG9uZW50RnJvbU5hbWUoc3RhdGUsIG5hbWUsIGFsbG93RXhwcmVzc2lvbikge1xuICAvKiogQHR5cGUge0lkZW50aWZpZXIgfCBMaXRlcmFsIHwgTWVtYmVyRXhwcmVzc2lvbn0gKi9cbiAgbGV0IHJlc3VsdFxuXG4gIGlmICghYWxsb3dFeHByZXNzaW9uKSB7XG4gICAgcmVzdWx0ID0ge3R5cGU6ICdMaXRlcmFsJywgdmFsdWU6IG5hbWV9XG4gIH0gZWxzZSBpZiAobmFtZS5pbmNsdWRlcygnLicpKSB7XG4gICAgY29uc3QgaWRlbnRpZmllcnMgPSBuYW1lLnNwbGl0KCcuJylcbiAgICBsZXQgaW5kZXggPSAtMVxuICAgIC8qKiBAdHlwZSB7SWRlbnRpZmllciB8IExpdGVyYWwgfCBNZW1iZXJFeHByZXNzaW9uIHwgdW5kZWZpbmVkfSAqL1xuICAgIGxldCBub2RlXG5cbiAgICB3aGlsZSAoKytpbmRleCA8IGlkZW50aWZpZXJzLmxlbmd0aCkge1xuICAgICAgLyoqIEB0eXBlIHtJZGVudGlmaWVyIHwgTGl0ZXJhbH0gKi9cbiAgICAgIGNvbnN0IHByb3AgPSBpc0lkZW50aWZpZXJOYW1lKGlkZW50aWZpZXJzW2luZGV4XSlcbiAgICAgICAgPyB7dHlwZTogJ0lkZW50aWZpZXInLCBuYW1lOiBpZGVudGlmaWVyc1tpbmRleF19XG4gICAgICAgIDoge3R5cGU6ICdMaXRlcmFsJywgdmFsdWU6IGlkZW50aWZpZXJzW2luZGV4XX1cbiAgICAgIG5vZGUgPSBub2RlXG4gICAgICAgID8ge1xuICAgICAgICAgICAgdHlwZTogJ01lbWJlckV4cHJlc3Npb24nLFxuICAgICAgICAgICAgb2JqZWN0OiBub2RlLFxuICAgICAgICAgICAgcHJvcGVydHk6IHByb3AsXG4gICAgICAgICAgICBjb21wdXRlZDogQm9vbGVhbihpbmRleCAmJiBwcm9wLnR5cGUgPT09ICdMaXRlcmFsJyksXG4gICAgICAgICAgICBvcHRpb25hbDogZmFsc2VcbiAgICAgICAgICB9XG4gICAgICAgIDogcHJvcFxuICAgIH1cblxuICAgIGFzc2VydChub2RlLCAnYWx3YXlzIGEgcmVzdWx0JylcbiAgICByZXN1bHQgPSBub2RlXG4gIH0gZWxzZSB7XG4gICAgcmVzdWx0ID1cbiAgICAgIGlzSWRlbnRpZmllck5hbWUobmFtZSkgJiYgIS9eW2Etel0vLnRlc3QobmFtZSlcbiAgICAgICAgPyB7dHlwZTogJ0lkZW50aWZpZXInLCBuYW1lfVxuICAgICAgICA6IHt0eXBlOiAnTGl0ZXJhbCcsIHZhbHVlOiBuYW1lfVxuICB9XG5cbiAgLy8gT25seSBsaXRlcmFscyBjYW4gYmUgcGFzc2VkIGluIGBjb21wb25lbnRzYCBjdXJyZW50bHkuXG4gIC8vIE5vIGlkZW50aWZpZXJzIC8gbWVtYmVyIGV4cHJlc3Npb25zLlxuICBpZiAocmVzdWx0LnR5cGUgPT09ICdMaXRlcmFsJykge1xuICAgIGNvbnN0IG5hbWUgPSAvKiogQHR5cGUge2tleW9mIEpTWC5JbnRyaW5zaWNFbGVtZW50c30gKi8gKHJlc3VsdC52YWx1ZSlcblxuICAgIHJldHVybiBvd24uY2FsbChzdGF0ZS5jb21wb25lbnRzLCBuYW1lKSA/IHN0YXRlLmNvbXBvbmVudHNbbmFtZV0gOiBuYW1lXG4gIH1cblxuICAvLyBBc3N1bWUgY29tcG9uZW50LlxuICBpZiAoc3RhdGUuZXZhbHVhdGVyKSB7XG4gICAgcmV0dXJuIHN0YXRlLmV2YWx1YXRlci5ldmFsdWF0ZUV4cHJlc3Npb24ocmVzdWx0KVxuICB9XG5cbiAgY3Jhc2hFc3RyZWUoc3RhdGUpXG59XG5cbi8qKlxuICogQHBhcmFtIHtTdGF0ZX0gc3RhdGVcbiAqIEBwYXJhbSB7UG9zaXRpb24gfCB1bmRlZmluZWR9IFtwbGFjZV1cbiAqIEByZXR1cm5zIHtuZXZlcn1cbiAqL1xuZnVuY3Rpb24gY3Jhc2hFc3RyZWUoc3RhdGUsIHBsYWNlKSB7XG4gIGNvbnN0IG1lc3NhZ2UgPSBuZXcgVkZpbGVNZXNzYWdlKFxuICAgICdDYW5ub3QgaGFuZGxlIE1EWCBlc3RyZWVzIHdpdGhvdXQgYGNyZWF0ZUV2YWx1YXRlcmAnLFxuICAgIHtcbiAgICAgIGFuY2VzdG9yczogc3RhdGUuYW5jZXN0b3JzLFxuICAgICAgcGxhY2UsXG4gICAgICBydWxlSWQ6ICdtZHgtZXN0cmVlJyxcbiAgICAgIHNvdXJjZTogJ2hhc3QtdXRpbC10by1qc3gtcnVudGltZSdcbiAgICB9XG4gIClcbiAgbWVzc2FnZS5maWxlID0gc3RhdGUuZmlsZVBhdGggfHwgdW5kZWZpbmVkXG4gIG1lc3NhZ2UudXJsID0gZG9jcyArICcjY2Fubm90LWhhbmRsZS1tZHgtZXN0cmVlcy13aXRob3V0LWNyZWF0ZWV2YWx1YXRlcidcblxuICB0aHJvdyBtZXNzYWdlXG59XG5cbi8qKlxuICogVHJhbnNmb3JtIGEgRE9NIGNhc2luZyBzdHlsZSBvYmplY3QgdG8gYSBDU1MgY2FzaW5nIHN0eWxlIG9iamVjdC5cbiAqXG4gKiBAcGFyYW0ge1N0eWxlfSBkb21DYXNpbmdcbiAqIEByZXR1cm5zIHtTdHlsZX1cbiAqL1xuZnVuY3Rpb24gdHJhbnNmb3JtU3R5bGVzVG9Dc3NDYXNpbmcoZG9tQ2FzaW5nKSB7XG4gIC8qKiBAdHlwZSB7U3R5bGV9ICovXG4gIGNvbnN0IGNzc0Nhc2luZyA9IHt9XG4gIC8qKiBAdHlwZSB7c3RyaW5nfSAqL1xuICBsZXQgZnJvbVxuXG4gIGZvciAoZnJvbSBpbiBkb21DYXNpbmcpIHtcbiAgICBpZiAob3duLmNhbGwoZG9tQ2FzaW5nLCBmcm9tKSkge1xuICAgICAgY3NzQ2FzaW5nW3RyYW5zZm9ybVN0eWxlVG9Dc3NDYXNpbmcoZnJvbSldID0gZG9tQ2FzaW5nW2Zyb21dXG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIGNzc0Nhc2luZ1xufVxuXG4vKipcbiAqIFRyYW5zZm9ybSBhIERPTSBjYXNpbmcgc3R5bGUgZmllbGQgdG8gYSBDU1MgY2FzaW5nIHN0eWxlIGZpZWxkLlxuICpcbiAqIEBwYXJhbSB7c3RyaW5nfSBmcm9tXG4gKiBAcmV0dXJucyB7c3RyaW5nfVxuICovXG5mdW5jdGlvbiB0cmFuc2Zvcm1TdHlsZVRvQ3NzQ2FzaW5nKGZyb20pIHtcbiAgbGV0IHRvID0gZnJvbS5yZXBsYWNlKGNhcCwgdG9EYXNoKVxuICAvLyBIYW5kbGUgYG1zLXh4eGAgLT4gYC1tcy14eHhgLlxuICBpZiAodG8uc2xpY2UoMCwgMykgPT09ICdtcy0nKSB0byA9ICctJyArIHRvXG4gIHJldHVybiB0b1xufVxuXG4vKipcbiAqIE1ha2UgYCQxYCBjYXBpdGFsaXplZC5cbiAqXG4gKiBAcGFyYW0ge3N0cmluZ30gX1xuICogICBXaGF0ZXZlci5cbiAqIEBwYXJhbSB7c3RyaW5nfSAkMVxuICogICBTaW5nbGUgQVNDSUkgYWxwaGFiZXRpY2FsLlxuICogQHJldHVybnMge3N0cmluZ31cbiAqICAgQ2FwaXRhbGl6ZWQgYCQxYC5cbiAqL1xuZnVuY3Rpb24gdG9DYW1lbChfLCAkMSkge1xuICByZXR1cm4gJDEudG9VcHBlckNhc2UoKVxufVxuXG4vKipcbiAqIE1ha2UgYCQwYCBkYXNoIGNhc2VkLlxuICpcbiAqIEBwYXJhbSB7c3RyaW5nfSAkMFxuICogICBDYXBpdGFsaXplZCBBU0NJSSBsZXRlci5cbiAqIEByZXR1cm5zIHtzdHJpbmd9XG4gKiAgIERhc2ggYW5kIGxvd2VyIGxldHRlci5cbiAqL1xuZnVuY3Rpb24gdG9EYXNoKCQwKSB7XG4gIHJldHVybiAnLScgKyAkMC50b0xvd2VyQ2FzZSgpXG59XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/hast-util-to-jsx-runtime/lib/index.js\n");

/***/ })

};
;