# Contributing Guidelines

Thank you for considering contributing to duckmath.org! We appreciate your help in making it better.

Join the discord for a special role!

## How to Contribute

1. Fork the repository and clone it to your local machine.
2. Create a new branch for your changes: `git checkout -b feature/your-feature-name`.
3. Make your changes and test them locally.
4. Commit your changes: `git commit -m "Add your commit message here"`.
5. Add your name and GitHub link to the [contributor list](https://github.com/duckmath/duckmath.github.io/blob/main/CONTRIBUTORS.md). Format: `- [Your Name](https://github.com/your-github-username)`
6. Push your changes to your forked repository: `git push origin feature/your-feature-name`.
7. Open a pull request to the main repository.

## Guidelines

To ensure a smooth contribution process, please follow these guidelines:

- Keep things simple and user-friendly.
- Listen to what the issue or feature request says and try to address it accordingly.
- Write clean and readable code.
- Test your changes thoroughly before submitting a pull request.
- Provide a clear and concise description of your changes in the pull request.

## Code Style

- Follow the existing code style and conventions.
- Use meaningful variable and function names.
- Comment your code when necessary to improve readability.

## Adding applications

- Use any existing application's format and update the name and icon, as well as the main frame (the gabe/application itself)
- _Please note that only '.webp' file images should be uploaded!_

## Reporting Issues

- If you encounter any issues or have suggestions for improvements, please open an issue on the repository.
- Provide as much detail as possible to help us understand and address the problem.

## Contact

If you have any questions or need further assistance, feel free to reach out to maddox05 at [maddox05](https://github.com/maddox05/).

We appreciate your contributions and look forward to making our unblocked games website even better together!
