# Decipher 📺️</h1>

AI-generated transcription subtitles are a way to automatically add subtitles to your videos by using artificial intelligence to transcribe the audio from the video. This eliminates the need for manual transcription and can make your videos more accessible to a wider audience. Decipher uses [whisper](#what-is-whisper) to transcribe the audio taken from the video and create subtitles

#### What is whisper?
[Whisper](https://github.com/openai/whisper) is an automatic State-of-the-Art speech recognition system from OpenAI that has been trained on 680,000 hours
of multilingual and multitask supervised data collected from the web. This large and diverse dataset leads to improved
robustness to accents, background noise and technical language.

## Getting Started

There are two different ways to begin using decipher, depending on your preferences:

* [`Google Colab`](#google-colab)
* [`Manual`](#manual)

### Google Colab
[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/dsymbol/decipher/blob/main/notebook.ipynb)

Notes:
- Requires a (free) Google account
- Instructions are embedded in the Colab Notebook

Google Colab is a cloud-based platform for machine learning and data science, for free without the need for a powerful GPU of your own. It offers the option to borrow a powerful GPU (Tesla K80, T4, P4, or P100) on their server for free for a maximum of 12 hours per session. For those who require even more powerful GPUs and longer runtimes, Colab Pro/Pro+ options are available.

### Manual

#### Dependencies

- [`Python`](https://www.python.org/downloads/)
- [`ffmpeg`](https://ffmpeg.org/)

#### Installation

```
pip install git+https://github.com/dsymbol/decipher
```

or

```
git clone https://github.com/dsymbol/decipher
cd decipher && pip install . 
```
*Note: Do NOT use 'pip install decipher'. It installs a different package.*

#### GUI (gradio) usage

```bash
decipher gui
# or
python -m decipher gui
```

#### Command-line usage

The `transcribe` subcommand allows you to transcribe a video file into a SubRip Subtitle (SRT) file. 
It also has the option to automatically add the generated subtitles to the video.

The `subtitle` subcommand allows you to add subtitles to a video using an already existing SRT file. 
This subcommand does not perform transcription, but rather assumes that the SRT file has already been created. 
It is typically used by people who want to validate the accuracy of a transcription generated by the transcribe subcommand.

To get started right away:

```bash
decipher --help
```

You can run decipher as a package if running it as a script doesn't work:

```bash
python -m decipher --help
```

#### Command-line examples:

Generate SRT subtitles for video:

```bash
decipher transcribe -i video.mp4 --model small
```

Burn generated subtitles into video:

```bash
decipher subtitle -i video.mp4 --subtitle_file video.srt --subtitle_action burn
```

Generate and burn subtitles into video without validating transcription:

```bash
decipher transcribe -i video.mp4 --model small --subtitle_action burn
```
