import { CodeBlockWriter } from "../../codeBlockWriter";
import { IndexSignatureDeclarationStructure, OptionalKind } from "../../structures";
import { NewLineFormattingStructuresPrinter } from "../formatting";
import { NodePrinter } from "../NodePrinter";

export class IndexSignatureDeclarationStructurePrinter extends NodePrinter<OptionalKind<IndexSignatureDeclarationStructure>> {
  readonly #multipleWriter = new NewLineFormattingStructuresPrinter(this);

  printTexts(writer: CodeBlockWriter, structures: ReadonlyArray<OptionalKind<IndexSignatureDeclarationStructure>> | undefined) {
    this.#multipleWriter.printText(writer, structures);
  }

  protected printTextInternal(writer: CodeBlockWriter, structure: OptionalKind<IndexSignatureDeclarationStructure>) {
    this.factory.forJSDoc().printDocs(writer, structure.docs);
    this.factory.forModifierableNode().printText(writer, structure);
    writer.write(`[${structure.keyName || "key"}: ${structure.keyType || "string"}]`);
    this.factory.forReturnTypedNode().printText(writer, structure);
    writer.write(";");
  }
}
