# Logging Bugs

1. Start logging an issue in the [issue tracker](https://github.com/dsherret/ts-morph/issues).
2. Clearly identify the problem and submit some reproduction code.
   - Prune the reproduction to remove needless details.
3. State the current and expected behaviour.
4. State the version of ts-morph (always show a reproduction of the bug on the latest version).

# Contributing Bug Fixes

1. Follow the instructions above about logging a bug. In addition:
   1. State that you are going to work on the bug.
   2. Discuss major structural changes in the issue before doing the work to ensure it makes sense and work isn't wasted.
2. Start working on the fix in a branch of `latest` and submit a PR when done.

# Contributing Features

- Only minor features will be accepted.
- Breaking changes that aren't bug or design fixes will not be merged.

# Getting Started

See [DEVELOPMENT.md](DEVELOPMENT.md)
