<?php

namespace app\admin\controller;
use think\facade\View;
use think\facade\Db;


use think\facade\Lang;

class Adminlog extends AdminControl
{
    const EXPORT_SIZE = 5000;

    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        Lang::load(base_path() . 'admin/lang/' . config('lang.default_lang') . '/adminlog.lang.php');
    }

    /**
     * 日志列表
     * @return type
     */
    public function index()
    {
        $condition = array();
        $time1 = '';
        $time2 = '';
        if (!empty(input('param.admin_name'))) {
            $condition[]=array('admin_name','=',input('param.admin_name'));
        }
        if (!empty(input('param.time_from'))) {
            $time1 = strtotime(input('param.time_from'));
        }
        if (!empty(input('param.time_to'))) {
            $time2 = strtotime(input('param.time_to'));
            if ($time2 !== false)
                $time2 = $time2 + 86400;
        }
        if ($time1 && $time2) {
            $condition[]=array('createtime','between', array($time1, $time2));
        } elseif ($time1) {
            $condition[]=array('createtime','egt', $time1);
        } elseif ($time2) {
            $condition[]=array('createtime','elt', $time2);
        }
        $list = Db::name('adminlog')->where($condition)->order('adminlog_id desc')->paginate(['list_rows'=>10,'query' => request()->param()],false);
        $page = $list->render();
        View::assign('list', $list);
        View::assign('page', $page);
        $this->setAdminCurItem('loglist');
        return View::fetch();
    }

    /**
     * 删除日志
     */
    public function list_del()
    {
        $adminlog_id = input('param.adminlog_id');
        $adminlog_id_array = ds_delete_param($adminlog_id);
        if ($adminlog_id_array == FALSE) {
            $this->error(lang('param_error'));
        }
        $condition = array();
        $condition[]=array('adminlog_id','in', $adminlog_id_array);
        if (Db::name('adminlog')->where($condition)->delete()) {
            $this->log(lang('ds_adminlog').'-'.lang('del_succ').'->' .lang('ds_number_id'). '[' . $adminlog_id . ']', null);
            $this->success(lang('admin_log_del_succ'), url('adminlog/index'));
        } else {
            $this->error(lang('admin_log_del_fail'));

        }
    }

    /**
     * 导出第一步
     */
    public function export_step1()
    {
        $time1 = '';
        $time2 = '';
        $condition = array();
        if (!empty(input('param.admin_name'))) {
            $condition[]=array('admin_name','=',input('param.admin_name'));
        }
        if (!empty(input('param.time_from'))) {
            $time1 = strtotime(input('param.time_from'));
        }
        if (!empty(input('param.time_to'))) {
            $time2 = strtotime(input('param.time_to'));
            if ($time2 !== false)
                $time2 = $time2 + 86400;
        }
        if ($time1 && $time2) {
            $condition[]=array('createtime','between', array($time1, $time2));
        } elseif ($time1) {
            $condition[]=array('createtime','egt', $time1);
        } elseif ($time2) {
            $condition[]=array('createtime','elt', $time2);
        }
        if (!is_numeric(input('param.curpage'))) {
            $count = Db::name('adminlog')->where($condition)->count();
            $array = array();
            if ($count > self::EXPORT_SIZE) {    //显示下载链接
                $page = ceil($count / self::EXPORT_SIZE);
                for ($i = 1; $i <= $page; $i++) {
                    $limit1 = ($i - 1) * self::EXPORT_SIZE + 1;
                    $limit2 = $i * self::EXPORT_SIZE > $count ? $count : $i * self::EXPORT_SIZE;
                    $array[$i] = $limit1 . ' ~ ' . $limit2;
                }
                View::assign('list', $array);
                View::assign('murl', url('adminlog/list'));
                return View::fetch('excel');
            } else {    //如果数量小，直接下载
                $data = Db::name('adminlog')->where($condition)->order('adminlog_id desc')->limit(self::EXPORT_SIZE)->select()->toArray();
                $this->createExcel($data);
            }
        } else {    //下载
            $limit1 = (input('param.curpage') - 1) * self::EXPORT_SIZE;
            $limit2 = self::EXPORT_SIZE;
            $data = Db::name('adminlog')->where($condition)->order('adminlog_id desc')->limit($limit1,$limit2)->select()->toArray();
            $this->createExcel($data);
        }
    }

    /**
     * 生成excel
     * @author csdeshang
     * @param array $data
     */
    private function createExcel($data = array())
    {
        Lang::load(base_path() . 'admin/lang/zh-cn/export.php');
        $excel_obj = new \excel\Excel();
        $excel_data = array();
        //设置样式
        $excel_obj->setStyle(array(
            'id' => 's_title', 'Font' => array('FontName' => '宋体', 'Size' => '12', 'Bold' => '1')
        ));
        //header
        $excel_data[0][] = array('styleid' => 's_title', 'data' => lang('admin_log_man'));
        $excel_data[0][] = array('styleid' => 's_title', 'data' => lang('admin_log_do'));
        $excel_data[0][] = array('styleid' => 's_title', 'data' => lang('admin_log_dotime'));
        $excel_data[0][] = array('styleid' => 's_title', 'data' => 'IP');
        foreach ((array)$data as $k => $v) {
            $tmp = array();
            $tmp[] = array('data' => $v['admin_name']);
            $tmp[] = array('data' => $v['content']);
            $tmp[] = array('data' => date('Y-m-d H:i:s', $v['createtime']));
            $tmp[] = array('data' => $v['ip']);
            $excel_data[] = $tmp;
        }
        $excel_data = $excel_obj->charset($excel_data, CHARSET);
        $excel_obj->addArray($excel_data);
        $excel_obj->addWorksheet($excel_obj->charset(lang('admin_log'), CHARSET));
        $excel_obj->generateXML($excel_obj->charset(lang('admin_log'), CHARSET) . input('param.curpage') . '-' . date('Y-m-d-H', TIMESTAMP));
    }

    /**
     * 获取栏目列表,针对控制器下的栏目
     * @return array
     */
    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'loglist',
                'text' => lang('admin_log'),
                'url' => url('adminlog/loglist')
            )
        );
        return $menu_array;

    }
}