package droidefense.sdk.helpers;

import droidefense.emulator.machine.base.struct.generic.IDroidefenseClass;
import droidefense.emulator.machine.base.struct.generic.IDroidefenseMethod;
import droidefense.emulator.machine.reader.DexClassReader;
import droidefense.exception.ConfigFileNotFoundException;
import droidefense.handler.FileIOHandler;
import droidefense.log4j.Log;
import droidefense.log4j.LoggerType;
import droidefense.sdk.util.InternalConstant;
import droidefense.sdk.util.Util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;

import static droidefense.rulengine.NodeCalculator.nodeTypeResolver;

public class DroidDefenseEnvironment implements Serializable {

    private static final String[] DEFAULT_ANDROID_APP_FILES_HASH_LIST = {
            "9290AB0FAF0BC754FC50223250F303F717F275056801AF8E9C3E9218C429597B",
            "636DAE40A54F15AAF4FF3A1F144072301EC9BB45302453BBEA0F7421649859CE",
            "AFEDF965914F9E0BB79F57F9083C4F44972F2E8C69F2645A9E12DFE648F22DB5",
            "E55953C8F214D63CFE9F16B9285046A270FE16AFAF35A9E1713CF244D41A7BCC",
            "5F997C46E51B3726B57A582F13663AEDFEED55E4E61FCFE6DCF9999EAD38F1D4",
            "A15AE3A3F24D8338C73F67D4D01563F64D54EB35688251526E728197BA9DBD39",
            "160F6327240B59EC3534EEFE0D4EA6DBD585E01D1357D870E910C5594016DC96",
            "C8720833A338E04082376B430530F4119D3F22EE14E5DD434C06CFE2F0BCCB53",
            "69176B45CF4189F6DFAF618EE19A1F77FC5AFCA0EC5F1E3BF275553ED27B2691",
            "2AE7387B4DB93F8ECBC01D288B752D41373CE7B7D808969FCA1E3B2E9D049219",
            "509264704725C5D7A5161E2880990BEAECC119BE5E1A667D543A08ACCE5D6E67",
            "55A22E9C2D79A2AE2775CEA72C0DAB42AD4BF7C5D88C902DF6FE9CD84C17C925",
            "D425AFB9669F33748229EE334B12A9D491AA4D445359B5A4C20B719464BCB959",
            "C131AB0E2EB9879BD063E736AB81313C5A4F47EAA2F4A0EC9ECA93A1A150ED79",
            "B17301EF0C491666445AEA5D6931356C50EAB99A321856F11ABBE4CEB3F00116",
            "C936C117B29419571725E32406D6732FF6C91BD0ACA6B03EC272A575E7BAEC3A",
            "55BC27772F6D35BE9334FB80C371B327DB25FAA9A6098C3C14049E92654AC1BF",
            "2A1A3F842D056E6E7E7E0CB9E075A13D3A3F0F8EDC4C41C40FA0BC3506132F55",
            "F548BA073616FF454BECA237BD2A7D35EA83E380377084C22DED4DF69C5AEBBD",
            "89BB69D41CC1E2D8C6EBEBC6297E08AB5F1C2D25E01423BC1E3E8ACC233BC64E",
            "646021CC77E7F4BD68AB59FB32D306F81A2042125E6CDAA16184A062A8183F79",
            "C092729C127E27A4C46D13006E1D264300F9B9B51497351033333AE1FC631160",
            "C7A19902A30C635C4708ADC2E0C2911FBDB30FA8BAF8878E96F44A8C9C012F65",
            "6BEFEEF85AC0E76BD1CB966CD24035DCD9D0332DEEECA98122BCE716F9BA7547",
            "302CBD143BAFF27AF1657C5CFE847ABA4B7204A0833AC72F91FAF4FE9CEA7391",
            "E7FE018225A9AF84DA1A9AA72312CD9F0412C0DAB2A5A26A24C8DC1E04D0251E",
            "C1DC9E967E0DE3A555DE310D14E98DBE92BC027B70822DAF576DAF968174D335",
            "5723F8DDE914DFA528F5D2AD0F9702B8EC8FBC5916D0B871DD2A1FB90DE50116",
            "AB557E73F726094807AFE8ECF2240EE3CD2B49116677003D35A617F6E4449B1D",
            "B7B075FB1B7A44A0426DC719ED5919441F31E7E1AF9D3441B70263B94196468F",
            "80B58CBE10317A142E23C37F15C6615C74C083AD6D3BBF0ED131687378DB3F92",
            "250783423FF48587108A208FDEAAD6E5A945F5AE6A0364EC6EBCE01CB87A87E2",
            "683691D79EF11E863FE4EC84DDC631696E5984B5584FC4549D6586DBACA220C7",
            "81119FE7CC8A57957EFE272F37979E5A9CDF429CE7A03CBDCF3332ED9C3482B9",
            "E8DAF1516AE90D3E8495C949ADED1170C44CBCC1A31A38489FD487A952ABE5CD",
            "336F0C15B74022C2BB378ED796FF03E3A156A0023F7F19FF8607992414D2F385",
            "3213A2451FE12008D00FAAF60E4BDF4D07277C8EE45F9508D2B12232BA5705B2",
            "6151450ECE3AB9667213C3987B6D8FFFA25BAF9FF43D53BCD9C94FD8EA7616D0",
            "0AB81661C03EF3DE41924963C8E8916170B1EE2ED7263608408C664B34220DC4",
            "6603EEC06D9B8A40B97BCE71337F1A40F912F02D31D84A8150611377006F9E96",
            "B1CBC88DF13B9CE605B7DC25119D727F9FA1E1F281233D3048EFF1B93DADE2EC",
            "0FECC437EE0B6811E0FB3DFEB4187A8EE2FC986CCB32AB013E23EB9CEB3D6E23",
            "8001ABBE5F6AB3407E2B3EF1BE9896DA0F193819C30DAF1A22ACC27B7CE066C1",
            "0EED99D0A5E36A468B557605E6CCEA495C029F3569844A45F4B5D8DADD77D4A7",
            "9EF598E2252C811BA1B0B031E5CF27DF847823B6253742F8073EE70B90981019",
            "B1E9C8FF1B5662B3A5C7BAB6B223FF14B68FE14E2D097FFC3CCDC3D5859EAC88",
            "21F0B55280BE10B187CEFF8EDEF4A5A7047683E6E9FCF47DE410AA3839F41094",
            "9C2DAC056737AFB90208B34AFF13281E312E0D0E9A81A9A62FCCB174AB78D841",
            "4B705E82FECE8445E2E57D16771D90360CBD35E08125B5430CD2C56F8F67D118",
            "6872DF4F2FBCEC3A48D369010B8ADD326A8BA31B17D05D26ED26F1CE3286BC8C",
            "D1DDFE5C4E6C8330A313B4BD9BA345FAE41A2E1BEF9EBBD09CCB8C4B45770AD8",
            "5358737CB680EA1CDD6BA400D33316FABF872FD44F6A0E127BFC8BDD1632B374",
            "2A0003B97CB37FBFCD79D777C20FF6BFE2297A23A0AD921B1E9FAD4BB1DC940F",
            "8C95D66A271B59CFF5FC9D3BE7E9C55DCB3F13E43EA1DD9ADBB00F64C4C84F73",
            "055D5F87B1BBB6677096BC7EB7EACE57E40216CB97F2B2B926D26C1263F9ABCE",
            "70253B82E6FFFEF3F8426B8EE7129B967212BF41788EAA1F4C6E8898AF6A173A",
            "FD227B0CC7108BCA496C4944878BD133E0AE39DB9F0C21B763960EF9EC336C02",
            "0D1F5A3E36D02311640190FD768EE8D2607BEBA7A90B411BE77A48A36427CB77",
            "4A68D1DBFD6B78A9D170339B850E188D4ACAC3AF6D3AF04EA14780E8C130C333",
            "C33C138BD35260D77BE5EEBAFA08EFBFE25D9EBB2D57D16DA31CAAF587FB0657",
            "CB374DDD7F6B44D028460F3629B1009387C00572717BF240C85F9A82651FAB41",
            "6174F17FB2FF9D8430A27A40DF50700D32E36F6F3369D10D42ADFB7978FE9BB3",
            "C0E4C8FDBF4FEF50F8A7033E529C3EF8DA2C994B3567D4E9D89CFA099E7AC15B",
            "F0BC6F14305322192EB32EDDCD3649025C712F8EEC3CFCB5B298D7F4708073F5",
            "2FA524CDA78D7EBD66164A896A042277B7A56B8658FB318FC700A114CB04F7B2",
            "AC11C9FF99D22E027FD415DC5C5CB8426E833E8A435346F32A39ABA60412E0B1",
            "7777C082DD900B3F0EA313944232BE401E5E7FA1F07DA15C543FFCFDA4CAEE28",
            "2310172CF1C75CA08B63BAA38D29B6A145DA35E9BD23AC0B78D2571F00D9D88A",
            "1E3B02E24FA431B1ABE0A97AD6723FAD43DF79FDA8176C1060B6FBD31178619F",
            "A8252F52638C80DF119DB031626198A4A8D4B32EE618E96C3A36B9B946E26894",
            "7CBCC9AD99E5C1ECE1EEE21DC50264D9475CF6FB4B450BE2359A4F5C9ADD17FB",
            "8DD453207AFC153E8F1712FB630568E05CF2697FA22CA1789E53C247DE2CB960",
            "1DB16875599F5738566F8B7D725004B0B988AEB93A3F818A9264359FFBB8FC9B",
            "247152BA9B093D65D697D071CC7E986AC7E64C4EC95CF42C40B6F054EF9BB661",
            "99C14D6855B8BE296D58017D3751B8DC849C47B6D1D80AB614FF9075080E461B",
            "4934257CEB20786074B52566EC6520B56ED0CBC646948962A747FF87E9CC4EEA",
            "AFBCAEDE66A97DDC9B54C4D9891C09415CB6944D79C4C1AE8440CDA553963957",
            "35C56471C6414F33645A376C0D1A8A126F4CDC728F2344D08BCCD3828E810E2E",
            "F296BB6B6F1478F4C844B681BC336590294F4A1BCEE38599C8115E4F27B4B858",
            "8C6E2A3C33890D72BE345310E6E531778C25B9C9B143762C6C2BDEE88F5FB0D0",
            "97CAEAF819A086DA7FF269296EDA8B3899CCDA2859820553772C2A9ED92B0C1D",
            "136A93D288E5D15011387A047C347C595E9789977DDA54891A368E0E693AB574",
            "579F0059D980CEBFE2104504AF5CADE0DB33F6A686CAA22752ABC864A2F71826",
            "E71502AC4D35951D0E063EF8B76885E27846A2DC0CDC616959D2A513F4852A2D",
            "0EF7B3D9F9D890A48E4FCCC0DB07315BD6FCCA7049452E20A27A69BD22080415",
            "5765229253EE4AB3B5D0D1FF67807C2D3774EB3C16951226C9B405E63BC09C54",
            "136D08FAB0FE416FC7E0ECA9C498E63C68357B2CAA4241F444BBC3F26F9A74C9",
            "2A2E39E7B3CAD91F830CCF44414ED4B449C290FECE685176F2FB0FA740058944",
            "9ACA579E09ED6D8A1EB275B59248755F8A117C05B96178232D31D66EA327971C",
            "4384D9E4E5D5EB24AA2CE48D21D486659D314FDECB65ABD9A6C2EE4A9870285D",
            "3BB7E79F3C1251E2124633B92AF3C6542FBFE334C83B8DD76AE4146DA8B5AFC0",
            "5CED2AB774853050255D7309E10B76217813D56F3F8AB8FB73AC3F635D90C676",
            "B576E32D41C77147925EEFB802B172C8D367206CD1A554E4E2AF45777DBB6CCB",
            "5D2632DFFB297A5257C092A1A9BD340692BC1CEF5274DCA2CBC4A1C9CD15F9CE",
            "E01E6A26771FFE290FB777903BF2DDEBE42260B680A6C899C82F9E68B1808BE0",
            "D6C3349860A3AF68198F0AFAB68B03332851DC2DC592347E027A20FDEED4EE66",
            "D449F91355EAC92DCAEABDCA61F9A9F874EC62A6883BB0753CABC723546E7A8F",
            "13C94291A33F4BE3DAD29CE46D9EF2491B9832CE1275E91466729934F021F769",
            "65200891E55859C0F9986F8DBF3A6BAFB5CB0D7F1199BA082EC195BBE93073C4",
            "71A2BA63A5D4E91F7C14324FA1C3EB9290B73CB7B3C7828018D05ADB1CFAAB45",
            "3AAC7C0D18E0F478C0741F4A338A5E4FFC71015651B3F24603C4812BFF8022AA",
            "932B2F1A5D1F714742551DF4E25B78AF1D68D8C3972A3D97AD8D2C24DC13777B",
            "9F856DD00A4F281D1198E6679AC8611FC67D301F28C07AEA97504244BA16CB44",
            "35B8D146DBD43D7B48448DA1E991E1E9CCFD98CBB3C4E73E67A9BD3E9E6B819A",
            "2563352B123E2218C2D1BF2F285A206BA1D9524D73D44DD2C5E7BCBA79A225A3",
            "A547431FEBF108CCFA9588AB89B1078E387BB351EB54D772394332187F770B74",
            "3CFD0554844896B500C33513B1E89ED62028D0C80DF73D3C5935479F49704A3C",
            "44C29766B2D88B78A71393B3E3A771CA7EEF5F552630C6074F33D6291241D0B9",
            "A42BB2C1EA4A5BF21B9C5EDB40E05D59C80F7E2194A6474E0DC795D031E01295",
            "42AEE0B03883E94DF5E543348A397D1302C1B8221895871A83B81899F5A9647B",
            "F662B87BE9D327E0E86E3F4DBA95531383ED0B19D3EC65857D87236D37FD2A35",
            "5A6CA1D0D2FEA53813DA5B3C9037408087F9F753F58DD2E128A4A48F7689769F",
            "229D563E40AAD3A0D519DF0971A5644BD22385140AFF3C8BC03A07D1D298452C",
            "3821A5412A0A4C6894EF633CFAE91297ECFA1A794CB5EA5047DC191656F2154B",
            "5BA9C2942AF438E91641866C30980E3F0B04E7B12F240A27065B25693C55B5D2",
            "606767686320846E692DA15CC85A4D10E3B21C79FD9DDC2F217F7FBDB8B5BEDA",
            "D68CBD5799FA3E1430FCC612BD1B036E1C8C718B1C8BD0D6B5A99F259ABD69E8",
            "FB15F23A85A276E03E48C57852CDFD68315689222E9123E7D919115CA759D947",
            "178C653F6FDF2201B3EB6575839AF350499F5C357A0FC2B7969A99824ADF88F2",
            "5D26DF4D838AAE8114F826706FEB8C665422738777D88C4FCDFCBB3918E5F713",
            "3596BF5EA9993828B9DFA8255BE85DBAC8257DEC5926E4AD5897AA3DEF90CC56",
            "866486F63941C0F78CB04D38334844806A87BC0A83F06A67C1935458B4A45AE2",
            "292122F7EEAE5806D057229D1F20FB640322EC5647696988EAADECDF8330A7F9",
            "3E09AFA21C45372C035598C017C8FB405A6D678E6CB84DC857581CB3B40E482D",
            "0C6217330BB8FB65EE3463638DA635F319B224F214F28D027381BAE8C82EF5A4",
            "FD1D8FF15F443FED99F64BB2DE4C8E59148E7F45F0272C9388A624B3FDB5BF47",
            "0DF6D1FE57B9B28BAC3A6A2B82941BCDDAB7E616A025201AACBE5E90C48C2068",
            "CF2D1096EDD99C09A185D330A8A202A35B0D21EC1305DF4AE7D359BCF0179B4D",
            "FCAE1F741C187496E31BEF506BFEA84F29F31294524AA52AAFC31762956CA5A5",
            "4F2F8C2A7B042E55AA8F43F4CE8134B3217EE9CDA432C5FF8D4C33D09D86DF68",
            "0EF7B3D9F9D890A48E4FCCC0DB07315BD6FCCA7049452E20A27A69BD22080415",
            "641AD19D3467A8E5C4D9714EB7581608DE2843F19E9A902A4E9223BE0661FB87",
            "559BF783D765C02338E97952BDC9C6689C7FF99090B8C9813369118DA8B080F0",
            "22C731ED19EFB90DEF7B091E2AF820383E593A71E8E13576E077BDA773F00F26",
            "D2C57EF44CA92374B76C92494097E8EBA9CB7B0395C02E8CE2A3C8CABA51C17A",
            "18BC8141516BAED4E675B3C647C9F63ABD7CBAE0260F6522F4067F1AE7932D14",
            "801A1F304A22A2C10E08A1A7A2F16E1BC80B8D1B1B7D4A3E34563FE56F2A41E3",
            "744D7C7D1D580BFE41F0E08FA0E1BE269EFDCD9068A5D893F8F2885FB8F751AA",
            "6598A6E07BD8876909EB886EBB75529BB91FA8677E0E5718AC38EB2962833DA3",
            "39AA138B792F6C1E1DF99E0C1B748406B50AA6DA3A864345F11BDEDB3C0710A7",
            "CA4F1A1FB757F2A43B213914DA7B135DB9F00221E877ECF61ABD22CB4136C4FF",
            "4CDCAFCE259E3BEB0CDCFCCD969F6B18FDAB421870934715CB4E0272230A36C8",
            "6DC6F70B602B524D6F097C3395E3FABBF986A00EBACCC8C771AAF12A185A59B8",
            "178445867B328F40D3AD06905A4C6334B78614515944F3C899C7BC04C48315DA",
            "E029144ED782DD1D311FB7962023EF69191C7736D63C6F436F73DFAE362F187B",
            "5D01A80F82B4C5874F20D78183037FB55504C6C3384458AD29B4535BDB951CAC",
            "7E12FCBD0C61E037CD1CAFE510C307B4074D156ADAC0022D91F3DCDCAE692818",
            "9E9A1933AF8C2B41E3E73EC273FDBB65E59542C397174F2A61486903072BEC38",
            "A466103AAB605670315457DE7F7072E26DCCEF8CFCE660906293E0CA44BFDC83",
            "E91E0D544DF2D72F2D531F598202A1101BACF69B041CEF77A7F31C9236563B64",
            "A9CA2573500E80796EBDD5301C6D747E637996D130FA68CDAEF1CD9FE8B0B170",
            "05B76FBF46593122597B8B4E2FD2358FA0734A9FBC2D24F5198EE2A72E77A9E9",
            "29DF2A94AD9C3206433C8BDF8DB67A18EDEB14440D9430849B1BB4D5B7DB7242",
            "85CD542A89C824382CC08D0466E952013953A8926B1A27036A2332FE1CC60E9C",
            "2C770F581A2CA530EDEB27812F9153CA16A7B79F5245E02D6911B534A4C80C5E",
            "ED2B544497195069D55663BD91B5CBFA5C732B9D4D264EF201394D8EF59DEB6E",
            "B2F70B2B54D2BE90CB84F34DB3D6A4CDD22B361013C01ED7BDDF7221CE0135C4",
            "40AE459DB3548AC42FB949D69ECD5D3C452866DB0FCF4D1B1081DD676A9431EC",
            "CAF1E473DF6702C2A6A95D738F1D6F2B73196766B504E5FF333B3C8E747E047B",
            "915CFE2E2A1F9F2AD498669B0B1C6EC4A26735B7E690C4FD6B8339AA1747E5D7",
            "8E103399F00E88D7E579DBFE883887FD096B11D7C74D7EDA4EA2374E70D60A14",
            "0FD2F53946EB93B3154F44BDAFC8896EA93195A64CE5FC64049E8B7293CD6801",
            "0BA072579DC4FF23D6C7B10BD02A42D0C8DAD68032685B48D33A102D9F156CB7",
            "4914C1F7B9F7185E0361AA4EA6BCC7B6E45A95D534B8F8299282BA45371734ED",
            "C7A9E8F4B746243321649495CB3EC6F4B926C0062DDBE12F8E05D6EE69A4DDFA",
            "0F5BD2F01B9689DB08E4DE977078E856427B126674AFA8EBE7F0A9FF80ACEEA2",
            "DFE5008780F6427172CCB49CD0C2F5CCD0AAA3BE3921B875362C9E65A08DF76C",
            "D3AE909287BD05DA576694FDF6A2081B298F09BAAC50B5B0D591083244A9CEBC",
            "3990D0047A49AB79C7417876FC0B298730F2D3525924F6D72A41A14EA84BB0B5",
            "395C5E56806478D86EB4FAE5570163962BC6845971DAD92EA29356690511EC56",
            "4DE0161B447CEA9B469D53BC1A6AC12D0287B92DA4C10D83BAA04F9080266CEF",
            "29953BD8019DD96B7701329B9A203CFF63460519549B9CCA9A5EB74F9B1B0930",
            "1D1D069210229BB9AF8AFC6C4BC344BF25543936D8FECA8F41BD0789CCC2AB7B",
            "489452A26BB9EAFF1DC953408A81C412028F45FE65B8C9DBCF30F32F82251FF8",
            "317DD9884F18C7F0ACD1A2DD986876C8F60A06FC3B71C05AEBA1DBCB883675C7",
            "892C980CB0F65D4FFDE85AD6F947795C4219720849B8E7A112C170DDD9C3FB22",
            "0147ED768271315FD1E9A0FF511A4AAF7F31763F1863B3F80242033D6FA41F5E",
            "24E31720F77BC442BFD450D80747A99DB2DF3675A53447A291622006DF52815A",
            "66055F4B925DAEF0E5640A8E3075CD7B176A34DA388085D52857D5C6F38BA632",
            "37C37DDDE38F5B3BC04D940F285D9A622745C9D180A5B2B37B3D0F1886C10591",
            "239D602C9C65F156FE024613207955AC8FBDD395AE6EC3EFA51BE98E3A4473F4",
            "C8AD92DB4E457D4816B775085BD4F9F8F225046A26C2C0DEC305402D6F3EF8C3",
            "294214C1572273F964A473C0D4571796484EBB7778A23FE39FE00763002C16A6",
            "DD8DBAB387958637A6B7D78C8D6CD88DA4370B82C6F2767562B959E1DB954B8E",
            "4133830F43F9BAA0B0ED3CC80D798B20071DA9F51FE12EF6B0BD09ABC8D5D33A",
            "DB6BD9C02C9D487D36E5722383DED1CF8CEB6C1B7F76EE6ED2B8EAECE351EC60",
            "9AD2A7AE746B1293988F5642BF07EA09A27C04CD8AD8A4F2D8E83661A4897D3E",
            "0EF7B3D9F9D890A48E4FCCC0DB07315BD6FCCA7049452E20A27A69BD22080415",
            "C81AA07FFC6CFC98D1D746CB63E52416114C2C6CD83B3815104DF84C1CE4ADCD",
            "DBC0AF61F440BB3F5382B8EA3FA578659F76C7A6AEF620A68AFC43A909F2E0E5",
            "A474ECB8578C539B514C1C9960DE8B0C177A867340854272440E0E3499591413",
            "428ED825AB284C918ED43866F9FA34C22F00553712924722B9B3186398B15551",
            "35700FBBB3249978AFE821DA76EF59DBC2CC41CB12DA4FE3F9E17746D4ECD430",
            "3C93DC6550E031DEC53F2C1646B46FE52E6C574A7B5EDDD33D029100363DF916",
            "3DBBAD926D540586D6BD1230F3293108774C95E73F6604F0BBF88C3A11530223",
            "8C6846F4105EF1C02107E842142E9CE60B08819296E9510B2D0C12CF4560C5E1",
            "43CCF1F0A5E9E9ED9A6DF33E1B3D378D49DBC8DC60D83B1CDB985E5E48F52497",
            "FC004F9CD7503A9C4B419B178C2BA3E24AA191A14588039865BE235507BDDBDA",
            "DDD2F39D1792E68FBE52935DFA8730C6D5BA845AC5CC6BB40A91AA5D8B68FFD5",
            "B6E9825DCB2642D75A4EC0B4FBBEC30C2FCD138C151290D3330682B588B3714F",
            "893E34D7ADB3AD5D8EC6B443B0791AC1DD77B8E43496E43A1E2E1F6E5F0AF975",
            "52D702EA8B7D978EB09DD5461181825003769FA3A2E99F96BDACEF6DD1FDE16D",
            "966103C0BB0723292DFBC415653363CD4AF2D874B7762A5C197A9A5AA1997330",
            "49903073AB23ABFC11A55E1333EB2905C743E1B382006C27C15434FD76E0207C",
            "141CAF2D5C65C7DBB00BDF0A27772F1B5D45B8AFC570B099FA019BA4CC17DA75",
            "7C8472B72441CC28A1AC53A08B4F0C14F310AF338175BA6C46FD6342AC8CE2FF",
            "E298888505E25EF030BCBDA4A272C00E41518C6B53520CB9B4EAAE19A8D5F7E9",
            "C8825CD637E59A02500D8B7518562F0C91BEF2EDD971BA3E5AD0F416794D618E",
            "DFC210D4A0201ECEE66B48C01A5668E82B8B64851D634D74EC413BD65016E645",
            "53340B0B0F529B26DB6AF632A0112708233BF312448C5B89A1357B2CD70B3F42",
            "3F6BCFDA110C0FD941415DD254623B7F3331542E3DE2ED150944BC4C5B235731",
            "643427C4BD60867ACAD34AA1445B11B4D9EAE3E9BB1EA5F5CD06B9606F68DC19",
            "B15C567058A56D15661E044BB4F8408512D87A79D11779EC8D7189DBB30EAEFB",
            "02AD0EA6FF5A560E947452C7D64F679AFA2056B44F86EA3B707A1CB175C2CEB0",
            "E17761ED280EDD93D7141BD504B70F9E9E15A8652288D9E6333BF4CE964EF844",
            "8154B2E598F4CD681133DB7634F89194EF4C7DD6D0F48EB48480F93234848400",
            "914E2E569845B363282B81EF1F7B6DA3124C1AC9EBC239B54C444D2EEC55D11E",
            "5B1F59A849330917D5F01108B36B240488BE9188FAE118B661E4D2464F4F7773",
            "27C227CAD79FA831621558B8AD808E28C939FB6DBDFA040AE57136B4B50F19D4",
            "BEAA49CF4C75CB5DDC40463767128E593773A9F0089D4ADCB5F2BDD92118CA73",
            "FE21F096AB18F8947A27624AE952E86BE4FF8D645AE714B653D398F64F8E39EE",
            "8B61B89360F1C5A33A544876BB9C071479E43631794598A7576362EF6C5DD0AE",
            "4BA313B3B8C9E8DD9536DC180D7BA6147B6954FA69A64E3BF38FC5DAC5F1863F",
            "432F71FC853E5145EF5BB660A9D1B9023F48EABB4E8BA61D8FAFDD1C1EC34D39",
            "DFD5AE1CEBC27420ABC8ED8A789C3645CAA665C1EA2A11577CB6468CB173F895",
            "CB00A0E8306AF78A96D6B4E9449B2F062F2B0F611ADEDCBBDBEA4608FF0565F7",
            "D8280405BE97F72F990DB0B74E32CA6468831959A04253264B0EEACACDA6FD10",
            "6B63259F9139A02B8129998F07D1BB9D7479381EDAB41DE32A773D05BF85F20F",
            "055EB7E5DBCFC542C8C8A73F9AFCC01716034A3C1EBF95B9C5FA5BE8A51F4192",
            "727D78FEC3F903A271C0476A50E8C064D28B32F7829B016AE0A07DA53B83B281",
            "1C006498E3E7A98DF88EAB5BC68B2D2A91465999832BDDB8F7301FCC1A53A9B1",
            "9ADD30707769385EF45B214819CB3AC057858FFF64A1249E84ECA43C38CCF71F",
            "D1085C65F242164C4595988135D5B5FDB08086D5CCA6D6C010D77C8530CCB204",
            "BCEF2CA650F39AF19262705E2A901B3E845A84C8C27AA99414A89AC71871F3E6",
            "7F537A60F30B3E56E0C091BAE0747A3407FDCD9D648E6FA61EC6B44331A8BB0D",
            "BFA384BA37A3E1024B738E0A82A7890F012F1A3291307135F7C819D0C9C3D425",
            "AAC59AF81B6F42FA5370475EF1EDD3CC8EDA4F7F1FBC370ABFEBE894594651A1",
            "B308DA630A8E8F1FF3E0082D8DFB13FA61273301D3E2884E254CD2F0A0A5A4E4",
            "550E8F5F4A6004C0FF14C681B20AE675C6943E5EE299DA36939F790FA8818FE0",
            "3D7BBF47C8AC2B75977A579CA1AA2C12BE8494F916450E971CF172BBC8A1F311",
            "B0AA010E7A885E4B7A669C16C7BA10FCD862A12DFF3F142C7354778442A63FDE",
            "4268B15D37EB27EC7AC1BB221A57000CEDE389FD34BEAF75E268AFB380901152",
            "36E3737C04CE9FF9322EA71C2908A36AE532437D0B899F70E4FF33F20F810BA8",
            "9032857CE4C65FB7F06726B1ADB5CD8E74B15C2BD88B6B12BC9C0D7E010E74A2",
            "9C05E26F9E74CE6D54E1E9E3D0FC1D6E7353CE7515E1195843FC627AD734156B",
            "9DE6E9F70F10768668002068EAEF6C021FF4B4E314E39639C3EDBFB51200AB92",
            "7E961B4DD339E62A4A5333C87A2B2C52C70FC59D7F598F605D2A68D3022E6E0E",
            "BDD6EB6FC49EEBDE70DA5E50FEE991CA856B202F1D4A1441E5C8A073C1D66919",
            "616D18E4D90E704CA10E53684A07DBB6F1A47F0C87528946A568ECC53421E8D8",
            "BCCD1BFBE6F5FEE32631474DF1A5A73F70FF1B0A1EDD9425B66BB1EFC2918CBB",
            "A1E1AA0774931B73151423FDE85AD5EE015E53CA9DDEA866326DA1266A12B285",
            "10DB3E5A773571A4EDA7D0BF0F4BB9E46B89298C283958855C59C25589EE7113",
            "A3D6BA61761E3957EF14110A4FB26FA2D0255605ACF496E7133093E01392A069",
            "FFF7725E2073C330D38F630C1FC94156A77307211BFA66C032ABFCDA8A05F961",
            "83A46279E2F65D852C9452C86E38326EF9F3DEF6F5BEC2EF1416C72815A5FBFA",
            "CD4459D1DF83D7137CAD2CB160889E4576E6DD1F385745A933008EE882A34A0C",
            "330791EC39B85952980FF0FA119F4360F6C68BE646EAE3FCC2E0129C485E017C",
            "AE964252406AC9465A442AD66C9FE077E8D16391DE4ECE7EAD6128B97F954362",
            "2447FD8357E9F05BEC90FE0D5B20D9E42C6610C4770D7CDB113B105702AA10CE",
            "412036121C3AE13A7363C8BC90ECD508EE060A066D4BA542EDBCFA173B75CF5C",
            "99223BD9B0D8E0A844E83C79176AB101DFD7517BDB82AFDA89E3043D610F5F77",
            "E058530DEE12014DA56ED723DECBE51E8F906D9657CCD109A7C9438ECDA1E44C",
            "8B04CC62CC340806C92E23CBB3F9F2D6B49049A07F6088C29736C36EE8240CD8",
            "B3C07BAFD2020314F00062AB3A55CCD2C262F4A2E578236016D4AD8CBC90F48D",
            "2AB0D18AA581997B2D36AC191151273995B212D3AC2E378EE2497E8AEE81BFA6",
            "F5F349C1E949F0E66374F83B667FC0D0F477379614F36912ADE22A299F2194D5",
            "A79B060D0EDB66331BEF8DD9A6C75B9506D15FD823C2A6B8579EFB6249B85309",
            "2F7FBDA0BA6E53E9A47E2FC0E24E32C447C613A5808C2D6285DC651E83A07AD7",
            "79E90CE85047134AC6F07F9932D094DCE6D15D6C2AF5E06E2C09739157EF68DF",
            "DF85C2AA13D87E85DCC58E515CF9747B6F1FDC56A1245087F8DE05CAB1916F04",
            "18B328D8017E677D5AAD3DBD66BAE356B5CAC978C6F0670938EA648E51D0EB66",
            "3EE0309A44AB9A709B050DC705B40C4560E393D10852F2A4C2815950E8684276",
            "DC08AF9D14E6B673BF9F31C248236F0457B322464036647473E3A32A23773F0E",
            "EFF1ADE8459830B9BFF2898348CA0DACF62D32E604E5E193615E61A4E56A32BA",
            "6002EB56783B956B5F91E6DDFFAF36CC867402A01A225E627B4C25C8D21A4E23",
            "777A1CF53820AA467267D1F64E5F923656F93047038EA6375BCCE257B517930E",
            "AD4D6C2D1A343D36781E16E81479C4A4CF75829D1BA2DCE23443ED22F909540C",
            "24F5DB226F1CD56E5E775F82C37F65F3D1EEC9091B26B74861629CAF0019C3BD",
            "F4812C6538630315D02CC3A182BA3FCFB85868A2AA98318EC5DD63677351F872",
            "49C8B7E40081D1D954B40F436122115078D20B4219C771A356DEAF50AB2D1F40",
            "0B1332B42AF152E06CBF9A43D4A44B14359C364AE1C53051E24B9485D2198F7E",
            "F4A3AF86CCE6EA60D9C08C506693461DC60E9FB22D7C01C80386F00B23698659",
            "0EEDC51DEEA0C0F3F675A400D667EB476553B92CBD12683B6154E36306031C19",
            "67691E44662856541BC59F56439342FD7EE9E985109D5A8819A4B746BC8718DA",
            "5E0799A0D0B5D43ED5AE3A378AAA0847A810CEEFF58DB9A0F7836EBF4EF17146",
            "08BD69A0F3296552F5FAB39C83C0678340B1A666284EC8368F91A5768CAE13DC",
            "A8676A1793AC8310FFB12986232DF66DF092D29C242AEEDC2B73556C010D38DC",
            "3D97740006E7A379B63FC034ED3CEBC35916650C920F15F78E830FAF2925A4DD",
            "E1849F5FCBF218894D53D19A7D3C18DBB1AA5DDA0334582C9931F9E6144CC5CF",
            "A39B674301942B3B4C9D25E88BFB0778EB39F89310728F0196A88D36AE0155B6",
            "C7A83DC923257C9BE3BC06250325B37B3706F0203D5955277F53A5BD003CA488",
            "1280837716AE0CFEDEC7F8700148B6EA1215178F524428192D151AFBCED69886",
            "EA50D85209D909ECD07013B992929444B7F51FD22DA25A6BE2936631AD1D28C4",
            "2C56C77B72876210D294EF8CA8E59CF358A1CC15B34441567ED94F381E1515B8",
            "36F351C77922F801D87479FE230012205412ED5E49B4DDC03B2D02EB30396EC3",
            "4BB4E2EC69DED3E748A26522B90A3D1318795687787374A05DC711F2925B4464",
            "50B3049DA5275342546813EB61495D611BB82DB21EF771846B9CA2B7D5C2D1FC",
            "0B8242EF6160F2D5744BB1F18D5D1009B80B9E23383C1273E8A1C6D94D402D38",
            "B4F8C3B4C42429379AB343815B7A7A52EE1A4348E83AB56C146A7AD3F6F5C2FC",
            "052762422B60E16802DD4DCDBC998F9C2EF911049E086592650FAF895EC2BCD4",
            "14C060F659D20B0D865F48DF245F39741D42F89CB86CDC5B1FD478FCC61EDD1A",
            "805839B77513EC41B4BF4B2E5EE12ED06138D319621EED15BB049D31165CE08B",
            "75C6F650F790493B89C50D6A3BC46BCECC677291A1AC1513B067CB4DD73AAFA6",
            "9D3A391047E0A49656489E94317FBB28B69439E6E003CD4CAA08DEDDCA412810",
            "EC1D0C9996C911BC9BE29DDA8CA2A521DA24DF882249CD5649A4B275E4E411FF",
            "EEFE1C1473B68EA606B3F490B054A07E82C30BFA6A3DCFD7A3D6E04B016EFCF6",
            "E64D5CF756AFFC561CCCB3B7D4005496D1B52A175418C871EAEFBE1F27FCE03B",
            "FAC58A1A36A318B22181FC7F86BDE36168570EE742AC0950C73F702F15B1EE16",
            "3F4396AD18482D483A073B29004DCAC7E70A630A9FBD53DCF85E85C42BDEAAA3",
            "7442CDA653ACBACDF9AEF256AA191E5EBB6071A1747312AEC45E1DB8252A3CFB",
            "07927F6D056C5E377BA08BE0589DD6E75D306CC0EC515247B3460BE332DDF1C0",
            "0387F407A039105055B61D2809E10266B624181EDF9585131377C570AB9BE9EF",
            "23188AF4E4D6A68ABC67666EED3232777905021E23B4D3C5843F0E05C4E89B30",
            "323F7FBB7907C8DF09C96BB41AE71EBC0B106A046CE4461510AD8F6424ED44A6",
            "0C8F6207A1593D412452FE8146653697692E2970ECF0CA8AA813617874830D0D",
            "76C07B8B91DAE0FFBE2CC2B0445245D3B7985054AFDC69AB29248C3DB12D0785",
            "C947E356E8FCE98095FA5E124450AF8E9C61FBEEBE740FA49415F484F4866B77",
            "A475594AE7C771092A3A2718981E2710C737844F44A4401F72D3953753649A7A",
            "387C23E784744E75A3611CE17ED156F1C18852C6B025A94D16B13C0B10AC4410",
            "1D9AECC0219BD579350CC8304F31D9FAAAAA796CB8947534382D03213B9F57CE",
            "C4219F89EF055955BF40E2BF0E398B3B51181389B005C245766A97F073940172",
            "63FAD0A19CB9E416586049D40B62161B0CC4C2513D83931D3852E2F5A72E6D13",
            "079843966864BF4099457CB72F1FEBE7C57BB5A70BF0F544A9169A078B7A5B01",
            "D1B51F4D11C689264D218A2B405A9C87B018C2CB065A96D05C5F96B071BE9EE6",
            "7B73C914C459938DC3257FA1151C736609EB37BB437EE42071B81EB4860BDC04",
            "0E631DBFE2575DD16D3FD6C59641DFA4ABB5E162D60F59049E4459F0AF29FBF6",
            "42066897DEC8C235CFFBF515F1F3F35B7341900F7C889EDB704905C7648810F9",
            "FE3E9AFAFACC6D85D8C92BDB5032D84652432D759570909847FA690B67EFC137",
            "54B757CED1278D78846C070AE2802CA65F88C17657236E4FD72E46E23A2C9A22",
            "9BE46560847B3596A1406BDA8B7A8449477F3314206C9A19B53E6703653DB4D7",
            "734C1F61BD507BB4F4C1FB28620D163EF158E2C19DFA94F344E18D4E2FD0EC5E",
            "D5C644B00EE79BD4F1FCB789EBBF89E79C0C6FEA878DFBC4A8C64C3BE34B5B03",
            "CD25887BE879D7EF9288D49E4DB1B3B641D5024D0D6B1B97D2C7CE92600CF3E8",
            "C1B23F1B9F16FCC1A91D929E06D954AE322CD3526B90C56719596A29637BBF98",
            "8436624220FBA246AE816A3AAB379DFD7FF2A484284AB24C3AF4989778705BB3",
            "E44D95E57172603AA992FFDB6BB9A302F945F00B632A5F7C6C29B873161E9AA9",
            "C0A75430053D4213D903EA82218D41E3AF2596D1D3444E34946B2E144A46D6B0",
            "1BCE645779D4C1B14CD0F88E53D553FD7B22F59933C8A8F1E335ED593200F3FA",
            "4FC6B5A031C6409E45FEEEC4A8825C5B41EF2C70980C21A06E0C8DBC35D92449",
            "D83543F0C82B62CF499F2618AD99431F9EF50DA60B415980EC8E0E50B90E3893",
            "D18819033A6F395FC26252CB90F714A560A36B618FB08E4118913849267E49A2",
            "0C6328C7B2420570A7EC38B3BEB3BAC9A29D895AC1AB7239315ABA7266418593",
            "61380EBAEB2D6ABF8DBD4EEB91BB8224B3B20E59A9CEB913E6AF9A4905A98D00",
            "076BE4630BB4F4BA10579CBA1B3900E3F3F2286CAFCBC15892D97FA4B45A27CE",
            "72645F8B4988600F1CEBD31470AB94BF4CECE93A6518D2C09253D8FB48100D44",
            "697F6DEDDBB0BEF2362E0D2AF4CC606D7916FB2F6B213E639849023937610DDA",
            "392E92A19607A8BAB2A30DC38B51B73AA8DDE956E30971C4413015F5C553EC9D",
            "A2F1A37AF8E699320A2FADBE54EEAA6112D5A3522D57D682EDF04FE97BE3B47E",
            "B84A277807F8F3BB5378E6353D99D1344AEE10BD9A05F47C30AFE3832D9CA7F0",
            "16A04F086D374B00BA759124C4A372DE58CB1B4EB070DB121CA747073FEF4745",
            "B0221120BE06170D42CCFFE92936CFDEF00C9034E2DBB9398863589E3EA6C9C5",
            "81FBBBC931441A4F6D64680A9D2F6C645C79209010A572F2EA0B732143039E73",
            "AB07F37B6DECFB6D159C9674538E3895892A77D99CAF8D84B196A77D5893E341",
            "270EC2C94BE001D62C967E5F5BEBD180E24C48C10CFD7C108FD667378CFC95A9",
            "4B787425A2B1EABB721CD99BD23EF235DB80F41900A66028C2872FA068011078",
            "5ECA0280BD38A6887B6E41765CF5DA573133874625001EB90156EAEB35FBE088",
            "975B16356B9AC687A0995C47086217DF52B0466A0A6C67C25AC007C119BD941A",
            "025D8A1155D2CE4769E307A89FF7EC6C175280DF90EC51A8C61CEA4551992CEF",
            "6B45AEF8BF43767C2C1C83DEE2BD9CEB9017994FBEF6613891E6BC215E2A5EE3",
            "B4C88C61A68D543C1982DED6B7E46134679D497D4F37C0322EF66347B8A71B5D",
            "D35D18A4F0A0E78EF99E1F032B4076B0533B6245C655C493E767A24FEB0E532B",
            "9D23DC94F9B1991657333849E20FCB1CB90FB734E6F43FD999A4801821B2BF76",
            "59ACF324BBE28EECCD97FE35AD6999A4AD01A36249BED046E06ABFC538D53E53",
            "AD2249BA5C94CCCB4EB4C9F669915B4CD97A35E5ED94F923654128FE0CAF1D0E",
            "D19092254AA4133FBA8B7795FB5DB560AD5DCD16C6F79201BEC31B0F1E9B608B",
            "52A0358E54439373CA39F99CD83CF3A7BE73C257F07FAE83EDD83C9B4891895D",
            "ABE7431E3F1D57CCF502AECD1CC6ABDC35B2D8D8023C440B6A4C3F0012A6B787",
            "9D2D007A0B452EFB5096107E0BB17F1F0F2F1E505252270C09ECED1B8C924797",
            "142E6897F5BDD0B5C8AD75D340D3DBEF2765C14BEE6F082132B3F43370DCB863",
            "CD32340B2937DD3FDA6B64FC5C4390866397F3EBD4B479370902C243B5D5EB77",
            "9E96A642AB9139CCA3FB822CE199C711443087B5A7463E0C7FED012D9A773285",
            "53FAFE0A562F0EDB759BDBEE020C5A3795201599347EF5B3E4BD839F8AA24F59",
            "3EE4340FD159E22AD2E7C7FC8912B28418E12F72A0D779AC9B83D6FFAE34EA1D",
            "B3ED59E93F866EE97F8F9C7D07D467C8D1D1E3378C1AFFCEDDA713750B3A5CCC",
            "3DE1DFFF6B58BB936D33A857A9CF5178996C80036FA31F41E71EF62DBB8BD77D",
            "EBD1E1432B6A54CC6161DA7F69837E8FA45ED95EB196B421D693FFFB040BE7BE",
            "EA66F88B27E335BFFDF92393EB6F120FAB4EE061B1A59B25156D9438D422EE64",
            "4372C7BFCDC00BAF76B263455EDB015F1081E9C45075F0D01C6EFA3C6C356652",
            "5080B07EB486BA05EDE737B567EB2BB89D7B79A3EDB5C2CA8141C6EBA012B75D",
            "12330EE3B3AC4A40235BC88887B748EF5E862C7F07B68E3681AC5B7B774A0EB1",
            "744D7C7D1D580BFE41F0E08FA0E1BE269EFDCD9068A5D893F8F2885FB8F751AA",
            "C6A403E2EE84F5BA230FC1ACAA5C6B87B9DEFAB26F7B679696AC885B7DFE4A21",
            "97041B198E7480CECE345B7CCB4D48C4405FC1BFB60AC21E74AAA01A064D9E04",
            "BE070C43088980F3BBD06C0B3C6D828DBCAD930317669BB6EC77F4461D8987A5",
            "D27AF435101CA4CBEC0C840BD30687918CD39EB83AAB1487420855623A45998B",
            "671D27E5A4B42111174B888D57118E05075A556D703BD54F9335202D2A416791",
            "37F74447BC4BF2A98FEF87ED3E0620CA1B90D22DCD730B34BFA88F7AFD1B6FEC",
            "65B4B6E22B9EA2865BCC6EB2AFC460A645CC39F642D6EAECEA5A69B794813396",
            "21B9BC9CA5BF09B7390DC9848395F81ACA27DC6A44DD71F44A4718EE2698176A",
            "51D83E107F732B13B915E32B185C78E4AD70FC6D0C23DAA200F5AD710E7D4525",
            "FB15F23A85A276E03E48C57852CDFD68315689222E9123E7D919115CA759D947",
            "993D8825B8932E0418EF3F6CC236455DD64C0AD9098A8FCA12956C6B9097E3E4",
            "D87483D4EEEEEECB4E0880A0EB0C161F047BFCE5004131BC46B1512C14C79CC0",
            "6948C22791982B06D1D911FD6212EE29BF8A819196EC01F60F5DDCF852F5394F",
            "C618FAFA6107721F6B07922AB06ED1922074412C7963DFCC9E34E1DB93DAACD5",
            "2B59BAA881561D74EED4A4019B0599145BFA65A822B6441FF31E69D9728A5F31",
            "203DAE73FFC57CABDB44DD3DBB7018CBC000899DA8430A91A1AE886A61576EAC",
            "8B0A0E649CC843E65E465D2DBA4ED784B8A4FEB548E337F445A56A8AD419BB3F",
            "18620C151330289BBA196C1CC1E2699F98061A35BE3551876296A8C4D592BA17",
            "C8AF57C8876530A9FCADF767B5CB4B9C3D870F1D6A743B2AB089C54AF4904955",
            "E20A638E6A4D5E2B2E05368288CB9DF41900354468D0E273454D70F890D9F365",
            "296561A5DD3461D7C187F0B0F8DB4ABA6275C0970B5B1FD7B0417CB5B99C32BF",
            "E81784CDC8AC38373621E586D28D488D585CCF2D695759ED611D848D2BF04CA7",
            "F0BF21254A829E472A56AB3DAF6315EAF89643C175983D07F4AD21E302D1FBA6",
            "8A33B5ECAA70A438F31B278B08BE121FB16519F37739DE24DF780345BDDA5C24",
            "56EA1548C8AB0DD7AB029C0AA6B19C06907BA1C9FFE1FD3E816798F6B47D8663",
            "2E28693300C8CD5DBDD49CBC71970454E9EBD2AA3AA62ED97A97DC1F6894843C",
            "3FA37BC34B0996B723974ED07A027D8B11DDA196E8DAEE006D379D10DA95B8FB",
            "13C88F810E24B11D0C568B5C37145CE2E96C28E742DDB7A96C6E765F3679B493",
            "ADD9ABCE47185FDAC6290FA13CC9CBF46CF4148C7DBF4F3147F0E7B821CA223F",
            "A5B49037B566E388D26EF4E781B7D287A558EF37B001A0319498EDD88CF65A67",
            "7F51C0F3F737DA3FB82EEFC7ED7C33A38D0F780DCDBE4425FDC0498419E6C4BD",
            "EE488C63592FF9F23E0E95DB62C53A33A5436563C2355278EA8F61D75550671E",
            "52549A8D0B6C35FAF2795EFDF6B4C5FE2CB34B7E8B1039CCA7AA2769B6CAB3D0",
            "20343222F9F79DD565C3A2248494D452E70820AC1C437173C38BADD45F962AFD",
            "4A5C839AB0CE8C0B23A47091BF6A69392C6E11E7E02F31E0889F12C0B1A27CCA",
            "500419896D42EE0818F210DB317439DF7458AD9F6F68F8B33690BD6F18C7D05A"
    };

    private static final HashSet<String> DEFAULT_APP_FILES_MAP = new HashSet<>();
    private static final DroidDefenseEnvironment instance = new DroidDefenseEnvironment();
    private static DroidDefenseEnvironmentConfig config;
    /* Extracted from official source folders */
    private transient HashSet<String> javaClassList;
    private transient HashSet<String> androidClassList;
    private transient HashSet<String> androidSupportClassList;

    private DroidDefenseEnvironment() {

        //read external config
        try {
            config = DroidDefenseEnvironmentConfig.getInstance();
            readEnvironmentalFiles();
        } catch (ConfigFileNotFoundException e) {
            Log.write(LoggerType.FATAL, "Error reading configuration file", e.getLocalizedMessage());
        }
    }

    public static DroidDefenseEnvironment getInstance() {
        return instance;
    }

    public static boolean isLoaded() {
        return instance != null;
    }

    private void readEnvironmentalFiles() {
        //load a list of native jdk8 classes

        String path = "";
        try {
            javaClassList = new HashSet<>();
            path = config.RESOURCE_FOLDER + File.separator + config.JAVA_SDK_CLASS_HASHSET_NAME;
            path = convertToAbsolute(path);
            ObjectInputStream jdk8ObjectFile = FileIOHandler.getResourceObjectStream(path);
            javaClassList = (HashSet<String>) FileIOHandler.readAsRAW(jdk8ObjectFile);
            Log.write(LoggerType.TRACE, "Java whitelisted dataset length: " + javaClassList.size());
        } catch (IOException e) {
            Log.write(LoggerType.ERROR, "Could not get java whitelist data on path: " + path + "\nError details: " + e.getLocalizedMessage());
        } catch (ClassNotFoundException e) {
            Log.write(LoggerType.ERROR, "Invalid whitelist file given on path " + path + "\nError details: " + e.getLocalizedMessage());
        } catch (Exception e) {
            Log.write(LoggerType.ERROR, "Droidefense error. Error details: " + e.getLocalizedMessage());
        }

        try {
            //load a list of native android sdk classes
            androidClassList = new HashSet<>();
            ObjectInputStream sdkFile = FileIOHandler.getResourceObjectStream(config.RESOURCE_FOLDER + File.separator + config.ANDROID_SDK_CLASS_HASHSET_NAME);
            androidClassList = (HashSet<String>) FileIOHandler.readAsRAW(sdkFile);
            Log.write(LoggerType.TRACE, "Android whitelisted dataset length: " + androidClassList.size());
        } catch (IOException e) {
            Log.write(LoggerType.ERROR, "Could not get android whitelist data on path: " + path + "\nError details: " + e.getLocalizedMessage());
        } catch (ClassNotFoundException e) {
            Log.write(LoggerType.ERROR, "Invalid android whitelist file given on path " + path + "\nError details: " + e.getLocalizedMessage());
        } catch (Exception e) {
            Log.write(LoggerType.ERROR, "Droidefense error. Error details: " + e.getLocalizedMessage());
        }

        try {
            //load a list of native android support sdk classes
            androidSupportClassList = new HashSet<>();
            ObjectInputStream supportFile = FileIOHandler.getResourceObjectStream(config.RESOURCE_FOLDER + File.separator + config.ANDROID_SDK_SUPPORT_CLASS_HASHSET_NAME);
            androidSupportClassList = (HashSet<String>) FileIOHandler.readAsRAW(supportFile);
            Log.write(LoggerType.TRACE, "Android support whitelisted dataset length: " + androidSupportClassList.size());
        } catch (IOException e) {
            Log.write(LoggerType.ERROR, "Could not get android support whitelist data on path: " + path + "\nError details: " + e.getLocalizedMessage());
        } catch (ClassNotFoundException e) {
            Log.write(LoggerType.ERROR, "Invalid android support whitelist file given on path " + path + "\nError details: " + e.getLocalizedMessage());
        } catch (Exception e) {
            Log.write(LoggerType.ERROR, "Droidefense error. Error details: " + e.getLocalizedMessage());
        }

        //init default app list map with array data
        DEFAULT_APP_FILES_MAP.addAll(Arrays.asList(DEFAULT_ANDROID_APP_FILES_HASH_LIST));

        Log.write(LoggerType.TRACE, "Droidefense environment loaded!!");
    }

    private String convertToAbsolute(String path) {
        path = path.replaceAll(File.separator + File.separator, File.separator);
        return path;
    }

    private String cleanClassName(String name) {
        name = name.replace("/", ".");
        int idx = name.indexOf("$");
        if (idx != -1)
            name = name.substring(0, idx);
        return name;
    }

    public boolean isAndroidNative(String name) {
        if (androidClassList == null)
            return false;
        name = cleanClassName(name);
        return androidClassList.contains(name);
    }

    public boolean isJavaNative(String name) {
        if (javaClassList == null)
            return false;
        name = cleanClassName(name);
        return javaClassList.contains(name);
    }

    public boolean isAndroidSupportClass(String name) {
        if (javaClassList == null)
            return false;
        name = cleanClassName(name);
        return androidSupportClassList.contains(name);
    }

    public boolean isDeveloperClass(IDroidefenseClass clas) {
        String className = clas.getAndroifiedClassName();
        return !isJavaNative(className) &&
                !isAndroidNative(className) &&
                !isAndroidSupportClass(className) &&
                clas.isDeveloperClass();
    }

    public boolean isBuildConfig(String className) {
        className = cleanClassName(className);
        //todo falta comprobar si un developer puede crear una clase con el nombre BuilConfig.java
        return className.endsWith(".BuildConfig");
    }

    //http://www.graphviz.org/doc/info/colors.html
    public String classifyNodeColor(String fullClassName, String nodeType) {
        boolean innerClass = fullClassName.contains("$");
        if (isAndroidNative(fullClassName)) {
            //android native class
            if (innerClass) {
                return "antiquewhite2";
            } else {
                return "antiquewhite3";
            }
        } else {
            //http://www.graphviz.org/doc/info/colors.html
            switch (nodeType) {
                case "Developer | InnerClass":
                    return "gold";
                case "Developer | Activity":
                case "Developer | AppCompatActivity":
                    return "chartreuse1";
                case "Developer | Service":
                    return "orangered";
                case "Developer | BroadcastReceiver":
                    return "firebrick1";
                default:
                    return "deepskyblue";
            }
        }
    }

    public boolean isDefaultFile(String sha256) {
        return DEFAULT_APP_FILES_MAP.contains(sha256);
    }

    public String classifyNode(String fullClassName) {

        if (isAndroidNative(fullClassName)) {
            return "Android | SDK";
        }
        boolean innerClass = fullClassName.contains("$");

        if (innerClass) {
            return "Developer | InnerClass";
        } else {

            IDroidefenseClass owner = DexClassReader.getInstance().load(fullClassName);
            String sc;
            sc = owner.getSuperClass();

            if (owner.isFake()) {
                //set the type of holding class
                IDroidefenseClass cls = DexClassReader.getInstance().load(owner.getName());
                return nodeTypeResolver(cls.getSuperClass());
            } else {
                return nodeTypeResolver(sc);
            }
        }
    }

    public String getSimpleNodeType(IDroidefenseMethod method) {
        IDroidefenseClass owner = method.getOwnerClass();
        String sc;
        sc = owner.getSuperClass();

        if (owner.isFake()) {
            //set the type of holding class
            IDroidefenseClass cls = DexClassReader.getInstance().load(owner.getName());
            return Util.getClassNameForFullPath(cls.getSuperClass());
        } else {
            return Util.getClassNameForFullPath(sc);
        }
    }

    public IDroidefenseClass getParentClass(IDroidefenseClass target) {

        if (target.isFake()) {
            return target;
        }
        IDroidefenseClass topParentClass = target.getTopParentClass();
        if (topParentClass == null) {
            topParentClass = findTopParentClass(target);
            target.setTopParentClass(topParentClass);
        }
        return topParentClass;
    }

    private IDroidefenseClass findTopParentClass(IDroidefenseClass target) {
        IDroidefenseClass topParentClass = null;
        String superClassname = target.getSuperClass();
        do {
            if (superClassname != null) {
                topParentClass = DexClassReader.getInstance().load(superClassname);
                superClassname = topParentClass.getSuperClass();
                if (superClassname != null) {
                    Log.write(LoggerType.TRACE, target.getAndroifiedClassName() + " inherits from " + superClassname);
                } else {
                    Log.write(LoggerType.TRACE, target.getAndroifiedClassName() + " inherits from java/lang/Object");
                }
            }
        } while (keepScalatingOnParents(topParentClass));
        return topParentClass;
    }

    private boolean keepScalatingOnParents(IDroidefenseClass owner) {
        return owner != null && owner.getSuperClass() != null && !owner.isFake() && !owner.getSuperClass().equals(InternalConstant.SUPERCLASS);
    }

    public IDroidefenseClass getParentClass(String clazz) {
        IDroidefenseClass requestedClass = DexClassReader.getInstance().load(clazz);
        return getParentClass(requestedClass);
    }
}
