﻿using BenchmarkDotNet.Attributes;
using BenchmarkDotNet.Tests.XUnit;

namespace BenchmarkDotNet.IntegrationTests
{
    public class PathTooLongTests : BenchmarkTestExecutor
    {
        [FactEnvSpecific("Testing Windows long path limitation", EnvRequirement.WindowsOnly)]
        public void PathTooLongTest() =>
            CanExecute<
                VeryLongName012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789>();

        [DryJob]
        public class
            VeryLongName012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789
        {
            [Benchmark]
            public void Foo() { }
        }
    }
}