﻿namespace BenchmarkDotNet.Toolchains.InProcess.Emit.Implementation
{
    /// <summary>
    /// A helper type that emits code that matches BenchmarkType.txt template.
    /// IMPORTANT: this type IS NOT thread safe.
    /// </summary>
    public class RunnableConstants
    {
        public const string IsByRefLikeAttributeTypeName = "System.Runtime.CompilerServices.IsByRefLikeAttribute";
        public const string OpImplicitMethodName = "op_Implicit";

        public const string DynamicAssemblySuffix = "Emitted";
        public const string EmittedTypePrefix = "BenchmarkDotNet.Autogenerated.Runnable_";
        public const string WorkloadDelegateTypeSuffix = "WorkloadDelegate";
        public const string OverheadDelegateTypeSuffix = "OverheadDelegate";
        public const string ArgFieldPrefix = "__argField";
        public const string ArgParamPrefix = "arg";

        public const string GlobalSetupActionFieldName = "globalSetupAction";
        public const string GlobalCleanupActionFieldName = "globalCleanupAction";
        public const string IterationSetupActionFieldName = "iterationSetupAction";
        public const string IterationCleanupActionFieldName = "iterationCleanupAction";
        public const string WorkloadDelegateFieldName = "workloadDelegate";
        public const string OverheadDelegateFieldName = "overheadDelegate";
        public const string NotElevenFieldName = "NotEleven";
        public const string DummyVarFieldName = "dummyVar";

        public const string TrickTheJitCoreMethodName = "__TrickTheJIT__";
        public const string Dummy1MethodName = "Dummy1";
        public const string Dummy2MethodName = "Dummy2";
        public const string Dummy3MethodName = "Dummy3";
        public const string WorkloadImplementationMethodName = "__Workload";
        public const string OverheadImplementationMethodName = "__Overhead";
        public const string OverheadActionUnrollMethodName = "OverheadActionUnroll";
        public const string OverheadActionNoUnrollMethodName = "OverheadActionNoUnroll";
        public const string WorkloadActionUnrollMethodName = "WorkloadActionUnroll";
        public const string WorkloadActionNoUnrollMethodName = "WorkloadActionNoUnroll";
        public const string ForDisassemblyDiagnoserMethodName = "__ForDisassemblyDiagnoser__";
        public const string InvokeCountParamName = "invokeCount";

        public const string ConsumerFieldName = "consumer";
        public const string NonGenericKeepAliveWithoutBoxingMethodName = "NonGenericKeepAliveWithoutBoxing";
        public const string DummyParamName = "_";
        public const string WorkloadDefaultValueHolderFieldName = "workloadDefaultValueHolder";

        public const string GlobalSetupMethodName = "GlobalSetup";
        public const string GlobalCleanupMethodName = "GlobalCleanup";
        public const string IterationSetupMethodName = "IterationSetup";
        public const string IterationCleanupMethodName = "IterationCleanup";

        public const string RunMethodName = "Run";

        public const int DummyUnrollFactor = 1 << 6;
    }
}