## Highlights

* New supported technologies
  * Add arm64 disassembler
    [#1422](https://github.com/dotnet/BenchmarkDotNet/issues/1422)
    [#2127](https://github.com/dotnet/BenchmarkDotNet/pull/2127)
    [#2107](https://github.com/dotnet/BenchmarkDotNet/pull/2107)
    [#2123](https://github.com/dotnet/BenchmarkDotNet/pull/2123)
    [#2070](https://github.com/dotnet/BenchmarkDotNet/issues/2070)
    [#2118](https://github.com/dotnet/BenchmarkDotNet/pull/2118)
    [#2119](https://github.com/dotnet/BenchmarkDotNet/pull/2119)
    [#2234](https://github.com/dotnet/BenchmarkDotNet/pull/2234)
    [#2222](https://github.com/dotnet/BenchmarkDotNet/pull/2222)
    [#2212](https://github.com/dotnet/BenchmarkDotNet/pull/2212)
    [9ee1/Capstone.NET#37](https://github.com/9ee1/Capstone.NET/pull/37)
  * Initial .NET 8 support
    [#2192](https://github.com/dotnet/BenchmarkDotNet/pull/2192)
  * .NET 6/7 MonoVM support
    [#2064](https://github.com/dotnet/BenchmarkDotNet/issues/2064)
    [#2142](https://github.com/dotnet/BenchmarkDotNet/pull/2142)
    [#2227](https://github.com/dotnet/BenchmarkDotNet/pull/2227)
    [#2230](https://github.com/dotnet/BenchmarkDotNet/pull/2230)
  * Armv6 and Ppc64le architectures support
    [#2216](https://github.com/dotnet/BenchmarkDotNet/issues/2216)
    [#2219](https://github.com/dotnet/BenchmarkDotNet/pull/2219)
* Improved support
  * Improved WASM support
    [#2201](https://github.com/dotnet/BenchmarkDotNet/pull/2201)
    [#2099](https://github.com/dotnet/BenchmarkDotNet/issues/2099)
    [#2154](https://github.com/dotnet/BenchmarkDotNet/pull/2154)
    [#2112](https://github.com/dotnet/BenchmarkDotNet/pull/2112)
  * Improved NativeAOT support
    [#2095](https://github.com/dotnet/BenchmarkDotNet/pull/2095)
    [#2221](https://github.com/dotnet/BenchmarkDotNet/pull/2221)
  * Improved Android support
    [#2231](https://github.com/dotnet/BenchmarkDotNet/pull/2231)
  * 32-bit benchmarks can now handle addresses larger than 2GB with the help of `LargeAddressAware`
    [#1469](https://github.com/dotnet/BenchmarkDotNet/issues/1469)
    [#2145](https://github.com/dotnet/BenchmarkDotNet/pull/2145)
  * Support 64bit affinity masks
    [#2211](https://github.com/dotnet/BenchmarkDotNet/issues/2211)
    [#2228](https://github.com/dotnet/BenchmarkDotNet/pull/2228)
* New features
  * Add `ExceptionDiagnoser`
    [#1736](https://github.com/dotnet/BenchmarkDotNet/issues/1736)
    [#2169](https://github.com/dotnet/BenchmarkDotNet/pull/2169)
    [#2182](https://github.com/dotnet/BenchmarkDotNet/pull/2182)
  * Add `PerfCollectProfiler`
    [#2117](https://github.com/dotnet/BenchmarkDotNet/pull/2117)
  * Incremental benchmark execution with the help of `--resume`
    [#1799](https://github.com/dotnet/BenchmarkDotNet/issues/1799)
    [#2164](https://github.com/dotnet/BenchmarkDotNet/pull/2164)
  * Taskbar progress
    [#2102](https://github.com/dotnet/BenchmarkDotNet/issues/2102)
    [#2158](https://github.com/dotnet/BenchmarkDotNet/pull/2158)
    [#2140](https://github.com/dotnet/BenchmarkDotNet/pull/2140)
  * Support `--noForcedGCs` to avoid forced GC between benchmark runs
    [#2101](https://github.com/dotnet/BenchmarkDotNet/pull/2101)
  * Added apples to apples comparison mode
    [#2116](https://github.com/dotnet/BenchmarkDotNet/pull/2116)
    [#2193](https://github.com/dotnet/BenchmarkDotNet/pull/2193)
  * Communication between the host process and the benchmark process is now using pipes instead of output parsing
    [#2092](https://github.com/dotnet/BenchmarkDotNet/pull/2092)
    [#1933](https://github.com/dotnet/BenchmarkDotNet/issues/1933)
    [#2189](https://github.com/dotnet/BenchmarkDotNet/issues/2189)
    [#2207](https://github.com/dotnet/BenchmarkDotNet/pull/2207)
    [#2200](https://github.com/dotnet/BenchmarkDotNet/pull/2200)
* Dozens of bugfixes

## Special Thanks

We would like to highlight some important contributors who helped us with this release:

1. [OpenHack'22 (devexperts.com)](https://code.devexperts.com/event/openhack22) hackathon sponsored by the DevExperts company.
  As part of this hackathon we have received following PRs:
  * [#2132](https://github.com/dotnet/BenchmarkDotNet/pull/2132) fix: include argument and param names in --filter (by [@blouflashdb](https://github.com/blouflashdb))
  * [#2140](https://github.com/dotnet/BenchmarkDotNet/pull/2140) Update console title with benchmark information (by [@franciscomoloureiro](https://github.com/franciscomoloureiro))
  * [#2142](https://github.com/dotnet/BenchmarkDotNet/pull/2142) Issue 2064: Mono70 moniker (by [@Serg046](https://github.com/Serg046))
  * [#2148](https://github.com/dotnet/BenchmarkDotNet/pull/2148) adding validation errors when the benchmarks are unsupported (by [@emanuel-v-r](https://github.com/emanuel-v-r))
  * [#2160](https://github.com/dotnet/BenchmarkDotNet/pull/2160) Corrected logic to restore foreground color in ConsoleLogger.cs (by [@farQtech](https://github.com/farQtech))
  * [#2164](https://github.com/dotnet/BenchmarkDotNet/pull/2164) 1799 adding resume arg (by [@melias](https://github.com/melias))
  * [#2169](https://github.com/dotnet/BenchmarkDotNet/pull/2169) Issue #1736: Add ExceptionDiagnoser (by [@Serg046](https://github.com/Serg046))
  * [#2161](https://github.com/dotnet/BenchmarkDotNet/pull/2161) add quiet logger (by [@franciscomoloureiro](https://github.com/franciscomoloureiro)) **(not merged yet)**
  * [#2171](https://github.com/dotnet/BenchmarkDotNet/pull/2171) Issue #1024: Calculate baseline by the fastest benchmark (by [@Serg046](https://github.com/Serg046)) **(not merged yet)**

2. Jan Vorlicek helped to implement arm64 disassembler during an internal Microsoft Hackathon:
  * [#2107](https://github.com/dotnet/BenchmarkDotNet/pull/2107) Implement TryGetReferencedAddress for relative branches (by [@janvorli](https://github.com/janvorli))
  * [#2123](https://github.com/dotnet/BenchmarkDotNet/pull/2123) Added other arm64 constant form extraction plus other changes (by [@janvorli](https://github.com/janvorli))

3. Ahmed Garhy (maintainer of Capstone.NET) helped to improve Capstone.NET, which was need to implement arm64 disassembler:
  * [9ee1/Capstone.NET#37](https://github.com/9ee1/Capstone.NET/pull/37) Sign Assembly with a Strong Name (by [@9ee1](https://github.com/9ee1))