﻿It's been few months since our last release, but we have been working hard and have some new features for you!

## Highlights

* **Features**
  * **BenchmarkDotNet as a global tool**: a new global tool which allows you to run benchmarks from given library.
    Now you can run benchmarks from the command line via `dotnet benchmark`.
    You can find more information about it in the documentation
    [#1006](https://github.com/dotnet/BenchmarkDotNet/pull/1006)
    [#213](https://github.com/dotnet/BenchmarkDotNet/issues/213)
  * **InProcessEmitToolchain**: new, full-featured InProcess toolchain which allows executing benchmarks in the current process
        without spawning additional process per benchmark.
    It supports `[Arguments]`, `[ArgumentsSource]`, passing the arguments by `out`, `ref` and returning stack-only types like `Span<T>`.
    [#919](https://github.com/dotnet/BenchmarkDotNet/issues/919),
    [#921](https://github.com/dotnet/BenchmarkDotNet/pull/921)
    [#843](https://github.com/dotnet/BenchmarkDotNet/issues/843)
  * **ARM support**: BenchmarkDotNet supports now ARM and ARM64.
    [#780](https://github.com/dotnet/BenchmarkDotNet/issues/780),
    [#979](https://github.com/dotnet/BenchmarkDotNet/pull/979)
    [#385](https://github.com/dotnet/BenchmarkDotNet/issues/385)
  * **Mono AOT support**: a new toolchain which allows running benchmarks using AOT version of Mono
    [#940](https://github.com/dotnet/BenchmarkDotNet/pull/940)
  * **NuGet symbol server support**: BenchmarkDotNet publishes now the symbols to NuGet.org symbol server and you can easily debug it.
    [#967](https://github.com/dotnet/BenchmarkDotNet/issues/967)
    [#968](https://github.com/dotnet/BenchmarkDotNet/pull/968)
  * **Experimental support for .NET Core 3.0 WPF benchmarks**
    [#1066](https://github.com/dotnet/BenchmarkDotNet/pull/1066)
    For a working example please go to [https://github.com/dotMorten/WPFBenchmarkTests](https://github.com/dotMorten/WPFBenchmarkTests)
* **Improvements:**
  * CoreRT Toolchain improvements - thanks to help from CoreRT Team we were able to make
      the CoreRT Toolchain work with the latest version of CoreRT
    [#1001](https://github.com/dotnet/BenchmarkDotNet/pull/1001),
    [#1057](https://github.com/dotnet/BenchmarkDotNet/pull/1057)
  * Display the number of benchmarks to run: we now display how many benchmarks are going to be executed
      before running them and how many remained after running each of them
    [#1048](https://github.com/dotnet/BenchmarkDotNet/issues/1048)
  * Better list of suggested benchmarks for wrong filter
    [#834](https://github.com/dotnet/BenchmarkDotNet/issues/834)
    [#957](https://github.com/dotnet/BenchmarkDotNet/pull/957)
  * Invalid assembly binding redirects generated by VS were a pain to many of our users,
      we have now implemented an approach that tries to work around this issue.
    [#895](https://github.com/dotnet/BenchmarkDotNet/issues/895),
    [#667](https://github.com/dotnet/BenchmarkDotNet/issues/667),
    [#896](https://github.com/dotnet/BenchmarkDotNet/issues/896),
    [#942](https://github.com/dotnet/BenchmarkDotNet/issues/942)
  * Handling duplicates in IConfig
    [#912](https://github.com/dotnet/BenchmarkDotNet/pull/912),
    [#938](https://github.com/dotnet/BenchmarkDotNet/issues/938),
    [#360](https://github.com/dotnet/BenchmarkDotNet/issues/360),
    [#463](https://github.com/dotnet/BenchmarkDotNet/issues/463)
  * Disassembly diagnoser should be kept in a separate directory to avoid dependency conflicts
    [#1059](https://github.com/dotnet/BenchmarkDotNet/issues/1059)
  * Give a warning when the `[Benchmark]` method is static - we now produce an error when users fail into this common issue
    [#983](https://github.com/dotnet/BenchmarkDotNet/issues/983)
    [#985](https://github.com/dotnet/BenchmarkDotNet/pull/985)
  * C# keywords are prohibited as benchmark names
    [#849](https://github.com/dotnet/BenchmarkDotNet/issues/849)
  * File names should be consistent across all OSes - `<` and `>` are valid on Unix, but not on Windows.
    We have unified that and now files produced on Unix and Windows have the same names.
    [#981](https://github.com/dotnet/BenchmarkDotNet/issues/981)
  * Improve restore, build and publish projects
    [#1002](https://github.com/dotnet/BenchmarkDotNet/issues/1002),
    [#1013](https://github.com/dotnet/BenchmarkDotNet/pull/1013)
  * Make it possible to disable OptimizationsValidator
    [#988](https://github.com/dotnet/BenchmarkDotNet/issues/988)
  * Sort enum parameters by value instead of name
    [#977](https://github.com/dotnet/BenchmarkDotNet/pull/977)
  * Detect .NET Core benchmark failures from LINQPad
    [#980](https://github.com/dotnet/BenchmarkDotNet/pull/980)
  * Improved error logging
    [#1008](https://github.com/dotnet/BenchmarkDotNet/pull/1008)
  * Improved disassembly diff
    [#1022](https://github.com/dotnet/BenchmarkDotNet/pull/1022)
  * Using invariant culture for Roslyn Toolchain error messages
    [#1042](https://github.com/dotnet/BenchmarkDotNet/pull/1042)
  * Use only full names in the auto-generated code to avoid any possible conflicts with user code
    [#1007](https://github.com/dotnet/BenchmarkDotNet/issues/1007),
    [#1009](https://github.com/dotnet/BenchmarkDotNet/pull/1009)
    [#1010](https://github.com/dotnet/BenchmarkDotNet/issues/1010)
  * Write the GitHub table format to the console by default
    [#1062](https://github.com/dotnet/BenchmarkDotNet/issues/1062)
  * Proper cleanup on Ctrl+C/console Window exit
    [#1061](https://github.com/dotnet/BenchmarkDotNet/pull/1061)
  * Introduce StoppingCriteria - the first step to writing your own heuristic that determines when benchmarking should be stopped
    [#984](https://github.com/dotnet/BenchmarkDotNet/pull/984)
* **Breaking changes:**
  * .NET Standard 2.0 only - BenchmarkDotNet has a single target now, which should help with some assembly resolving issues.
    We had to drop .NET 4.6 support because of that and .NET 4.6.1 is now the oldest supported .NET Framework.
    [#1032](https://github.com/dotnet/BenchmarkDotNet/pull/1032)
  * CustomCoreClrToolchain has been removed, it's recommended to use CoreRunToolchain instead
    [#928](https://github.com/dotnet/BenchmarkDotNet/issues/928)
* **Bug fixes:**
  * NRE in `Summary` ctor
    [#986](https://github.com/dotnet/BenchmarkDotNet/issues/986)
    [#987](https://github.com/dotnet/BenchmarkDotNet/pull/987)
  * ArgumentNullException when running benchmarks from published .NET Core app
    [#1018](https://github.com/dotnet/BenchmarkDotNet/issues/1018)
  * Dry jobs can eat iteration failures
    [#1045](https://github.com/dotnet/BenchmarkDotNet/issues/1045)
  * NullReferenceException in BenchmarkDotNet.Reports.SummaryTable after iteration failure
    [#1046](https://github.com/dotnet/BenchmarkDotNet/issues/1046)
  * Running the example throws NullReference
    [#1049](https://github.com/dotnet/BenchmarkDotNet/issues/1049)
  * Fix race condition in process output reader
    [#1051](https://github.com/dotnet/BenchmarkDotNet/issues/1051)
    [#1053](https://github.com/dotnet/BenchmarkDotNet/pull/1053)
  * Fix a rare but really annoying bug where for some reason we were sometimes setting ForegroundColor
      to the same color as BackgroundColor and some parts of the logged output were invisible
    [commit](https://github.com/dotnet/BenchmarkDotNet/commit/ea3036810ef60b483d766a097e6f3edfde28a834)
  * StopOnFirstError must be respected
    [commit](https://github.com/dotnet/BenchmarkDotNet/commit/87d281d7dbf52036819efff52e6661e436648b73)

---

