import 'package:flutter/services.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:elevenlabs/elevenlabs_method_channel.dart';

void main() {
  MethodChannelElevenlabs platform = MethodChannelElevenlabs();
  const MethodChannel channel = MethodChannel('elevenlabs');

  TestWidgetsFlutterBinding.ensureInitialized();

  setUp(() {
    channel.setMockMethodCallHandler((MethodCall methodCall) async {
      return '42';
    });
  });

  tearDown(() {
    channel.setMockMethodCallHandler(null);
  });

  test('getPlatformVersion', () async {
    expect(await platform.getPlatformVersion(), '42');
  });
}
