// This file has been autogenerated from a class added in the UI designer.

using BarcodeSDK.NET.iOS.Controllers.ClassicComponents.TableViewCells;
using BarcodeSDK.NET.iOS.Utils;
using ScanbotSDK.iOS;

namespace BarcodeSDK.NET.iOS.Controllers.ClassicComponents
{
    public partial class BarcodeScanAndCountResultViewController : UIViewController
    {
        List<SBSDKBarcodeScannerAccumulatingResult> ScannedBarcodes;
        public BarcodeScanAndCountResultViewController(IntPtr handle) : base(handle)
        {
        }

        internal void NavigateData(List<SBSDKBarcodeScannerAccumulatingResult> scannedBarcodes)
        {
            ScannedBarcodes = scannedBarcodes;
        }

        public override void ViewDidLoad()
        {
            base.ViewDidLoad();

            SetUpTableView();
            this.NavigationItem.LeftBarButtonItem = new UIBarButtonItem(Texts.Done, UIBarButtonItemStyle.Done, (sender, e) => NavigationController.PopToRootViewController(true));
        }

        private void SetUpTableView()
        {
            tableView.Source = new BarcodeScanAndCountResultSource(ScannedBarcodes);
            tableView.TableFooterView = new UIView();
            tableView.EstimatedRowHeight = 50;
            tableView.RowHeight = UITableView.AutomaticDimension;
            tableView.SeparatorStyle = UITableViewCellSeparatorStyle.None;
        }
    }

    internal class BarcodeScanAndCountResultSource : UITableViewSource
    {
        private List<SBSDKBarcodeScannerAccumulatingResult> scannedBarcodes;

        public BarcodeScanAndCountResultSource(List<SBSDKBarcodeScannerAccumulatingResult> scannedBarcodes)
        {
            this.scannedBarcodes = scannedBarcodes;
        }

        public override UITableViewCell GetCell(UITableView tableView, NSIndexPath indexPath)
        {
            var cell = tableView.DequeueReusableCell(nameof(BarcodeScanAndCountResultCell), indexPath) as BarcodeScanAndCountResultCell;
            cell.PopulateData(scannedBarcodes[indexPath.Row]);
            return cell;
        }

        public override nint RowsInSection(UITableView tableView, nint section)
        {
            return scannedBarcodes.Count;
        }
    }
}
