## 版本
- jionlp-LLM-test-1.1

## LLM 评测数据集综合题 1.1 简介
- jionlp LLM 评测数据集主要用于评测通用 LLM 的效果评价。
- 着眼点：考察 LLM 模型对人类用户的帮助效果、辅助能力，可否达到一个【智能助手】的水平。
- 题型介绍：选择题来源于中国大陆国内各种专业性考试，重点在于考察模型对客观知识的覆盖面，占比 32%；主观题来源于日常总结，主要考察用户对 LLM 常用功能的效果。
- 1.1 版本在 1.0 版本基础上，有了大约 30% 的测试题型改进。


| 题型  | 分值 | 形式 | 内容 | 来源 |
|-------|-----|------|------|-----|
|知识问答|30  |选择题 |覆盖各领域知识题，考察模型预训练语料的丰富性、准确性 |国内专业性考试 |
|生活常识 |10  |选择题 |覆盖衣食住行的生活常识，考察模型是否经常犯低级错误 | 日常生活总结 |
|语言表达|5   |选择题 |考察模型的语言理解能力 | 国内通用考试 |
|逻辑推理 |5   |选择题 |考察模型的逻辑推理、分析能力    |国内通用考试 |
|文本问答 |25  |简答题 |考察模型完成各种用户指令的能力 | 常用若干能力 |
|闭域问答 |19  |简答题 |考察模型根据有限内容完成用户指令的能力 | 编程、阅读理解等|
|机器翻译 |6   |翻译题 |考察模型的语言能力，翻译能力   |论文和新闻  |

## 更新内容

#### 1、题目需求更加多样

在实际的模型使用中，不同的用户有不同的需求，千奇百怪，非常复杂，因此，为了全面考察大语言模型的能力，题目覆盖面也尽量全面，回答考试题、写新闻、写代码，回答专业问题，给小孩起名，写分镜头脚本等等，考察内容面非常广，专业深度也深浅有度。

- 给小孩起名

```
根据中国古典诗词，给孩子起个名字，男孩，五行缺水，姓李。要求：避免起一些过于大众化的名字，如“子轩”、“梓萱”等。给出10个选项。
```

- 写分镜头脚本
```
写一个广告分镜脚本，介绍一款名为康元饮的中老年人饮品。要求讲清产品功能，要有对话、动作、情节，吸引人们的注意，有一定夸张和强调作用，300字左右。
```

- 回答专业问题
```
什么是光通信？它的难点在于哪些地方？
```

#### 2、增加闭域问答，Close QA

在 NLP 领域，有一个应用非常广泛的任务形式，即根据给定的一段文本，来进行问答。它非常像语文中的阅读理解。

- 阅读理解
```
{给定一篇文章}

根据上文，按要求回答以下问题：
1、{问题1}
2、{问题2}
```

这种题型非常重要，它是语言模型即时学习的重要途经。因此，在这份测试题中，给出了占总分 19% 的闭域问答题型，考察内容包括短文阅读理解，传统 NLP 任务信息抽取，外接接口执行程序等等。

- 新闻问答
```
今年“五一”假期铁路运输期限为4月27日至5月4日，共8天。来自中国铁路北京局集团公司(简称“中国铁路北京局”)的消息，4月27日，中国铁路北京局共计发送旅客111.48万人，其中北京地区发送旅客57.5万人(北京站发送7.79万人、北京西站发送16.45万人、北京南站发送18.77万人、北京北站1.58万人、清河站2.17万、北京朝阳站4.89万人、北京丰台站4.57万人)。4月28日，中国铁路北京局预计发送旅客130万人，其中北京地区预计发送旅客68.54万人。中国铁路北京局结合假期运输特点，全力提升旅客乘车的舒适度。各次高铁列车针对互联网订餐订单量激增的实际情况，合理安排配送人员，做好列车配送服务，保障好出行旅客的网络订餐。运行中结合旅客实际需求，从列车环境、服务、用餐等方面提供多元化服务，部分列车还配有儿童读物和拼图，满足不同旅客的需求。北京站在候车大厅西侧明显位置，设置“医疗服务”室，配备诊疗床、AED除颤仪等基础急救设备，为旅客提供寻医问药服务。北京西站针对年纪太大无法久坐、手术后无法坐立的旅客提供可躺式座椅。北京南站4月27日至5月4日全面开启地下换乘层京沪高铁、京津城际4个快速进站厅，每日开关时间根据现场客流情况动态延长调整。北京北站启用地上地下进站口，“德馨”服务组推出便民服务车，关口前移，提升旅客出行体验。清河站全面启用南落客和西进站口，全面满足地铁、公交、出租车、私家车等多种交通方式接驳的旅客乘车。

抽取出文中的关键短语（抽取5个，每行一个），

并回答4月27日北京哪个火车站发送旅客人次最多？

北京铁路局采取哪些措施提升服务水平？
```

#### 3、自然语言与程序语言的转换
AI 想要真正贯彻到人类的工作生活的各个方面，需要能够将自然语言转化成可执行的程序，来实现各种各样接口的调用。

因此，大语言模型一项必备的技能，就是能够生成准确的程序数据接口，包括结构化数据，以及可执行程序。

测试题中，涉及编程的题型占比总分值的 10%，它直接关系到模型与程序接口的对接。实际上，**这项能力直接关系到模型能够很好地支持 langchain 调用**。

- 编程题目
```
Python 解释器的 C api 中，Py_ssize_t 对应 C 的哪种数据类型？

A、float *，B、long int，C、const char，D、char
```

- 结构化数据返回
```
接下来，我会告诉你一条语句，在这条语句中，包含了我想要定闹钟的诉求和具体的时间，请告诉我这个具体时间是多少？

请仅仅以 json 格式进行返回输出结果，不要额外的语言解释。

json 格式输出样例如下，对于一个 json schema {"properties": {"foo": {"title": "Foo", "description": "a list of strings", "type": "array", "items": {"type": "string"}}}, "required": ["foo"]}}
json 对象 {"foo": ["bar", "baz"]} 是一个符合上述 schema 的结果，而 {"properties": {"foo": ["bar", "baz"]}} 则不符合上述 schema。

对于返回时间的 json，其对应 schema 为:``{"properties": {"time_point": {"title": "TimePoint", "description": "The time to set an alarm", "type": "string"}}}, "required": ["time_point"]}}``

其中，time_point 字段，请以 %Y-%M-%DT%h:%m:%s 格式返回。

语句：我好累，今晚打算11点就睡了，明天早上9点钟有个会，那就提前40分钟叫我起床。
时间基点：2023-06-02
时间：
```

#### 4、数学计算、推理类题型
大语言模型本身并不擅长完成数学题，因为数学中广泛存在着数学计算和多层推理。最佳的解决该问题的方法，就是思维链。让模型自己把抽象的问题拆解为多个执行步骤，一步一步的进行推理。

在测试题中，包含计算和复杂推理的题型占比大约 18%，这对模型的效果提出了很高的挑战。

为了凸显思维链的逐步推理效果，几乎在每一道涉及数学的题目中，都强调了，要求模型给出推理过程。不给推理过程，直接给出答案的回答，均判为错误回答。

- 数学计算
```
假设 A,B 为 n阶矩阵，记r(X)为矩阵 X 的秩，(X,Y)表示分块矩阵，则（）

在求解的过程中，要给出推理过程，一步一步进行推导。

A. r(A,AB)=r(A)
B. r(A,BA)=r(A)
C. r(A,B)=max{r(A),r(B)}
D. r(A,B)=r(A^T,B^T)
```

- 逻辑推理题目
```
寻找数字规律，空格处应该填写哪个数字？0,1,3,8,22,63,( ) 

在求解的过程中，要给出推理过程，一步一步进行计算求解。

A、183；B、184；C、185；D、186
```

#### 5、模型拒绝能力
大语言模型的首要功能，是完成用户的指令，因此不可避免地，AI 会顺着人类用户的想法回答问题。然而这种顺从，会产生一些误导，因此，我在选择题中，专门设置了两道没有正确答案的题目，主要是考察模型能否甄别题目的误区，拒绝作答。

有时候，拒绝作答是一种更加可靠、可信的 AI 响应。

- 错误题目1
```
以下哪些城市是世界上海拔超过5000米的城市？

A. 拉萨，B. 布宜诺斯艾利斯，C. 金沙萨，D. 喀布尔，E. 基什那乔夫斯克

说明：没有任何城市选项海拔超过 5000 米。
```

- 错误题目2
```
The table above shows the number of consecutive nights that each of five families stayed at a certain hotel during a 14-night period. If the Liu family’s stay did not overlap with the Benton family’s stay, which of the 14 nights could be a night on which only one of the five families stayed at the hotel?

A. The 3rd B. The 5th C. The 6th D. The 8th E. The 10th

说明：题目中根本没有给出任何表格信息，因此题目没法作答。
```


## 评分规则：
- 客观选择题每题一分
- 主观题每道题均有特定的赋分，从2分到5分不等，评分方式线性赋分


## 题型说明
#### 客观题
```
用户：请回答问题：xxxxxxxx，A，xxx；B，xxx；C，xxx；D，xxx
模型：答案选A，原因是xxxxxx。
```
- 覆盖数学、物理、化学、生物、计算机、通信、机械、电力、医学、法律、新闻、地理、历史、文学、经济、编程等方面常识性问题；难易程度不一，存在少量多选题；
- 若模型给出答案字母（A\B\C\D），但分析结果错误，仍然判定正确；
- 若模型未给出答案字母，但以文字形式给出正确结果，仍然判定正确；
- 个别选择题没有正确答案，或题干信息给的不完全，无从给出答案；此时要求模型能够正确辨别题目中的问题，不能给出任何选项答案。此做法考察模型的信息辨别能力，避免幻觉妄语 Hallucination 的能力。
- 客观题由于模型的输出以概率形式进行采样，具有不确定性。评测过程中，全程都仅做一次输出，不会反复测试以期模型输出正确结果为止。

#### 主观题
- 主要覆盖写文章、写代码、写脚本、讲故事、完成用户知识咨询、特定主观问题咨询、考察模型输出陷入死循环，传统 NLP 任务等能力。

### 加载数据集
```
>>> import jionlp as jio
>>> llm_test = jio.llm_test_dataset_loader(version=1.1)
>>> print(llm_test[25])
```

### 测试结果

- 以下测试模型结果均有 pdf 版本截图供验证参考，可关注 【JioNLP】 公众号下载查阅。
- 有一些模型需要提供邀请码才可测试，欢迎大家提供邀请码，或直接使用本测试题进行测试。
- **目前还没在 1.1 版本基础上测试完整模型能力**。









