## 版本
- jionlp-LLM-test-1.0

## LLM 评测数据集综合题 1.0 简介
- jionlp LLM 评测数据集主要用于评测通用 LLM 的效果评价。
- 着眼点：考察 LLM 模型对人类用户的帮助效果、辅助能力，可否达到一个【智能助手】的水平。
- 题型介绍：选择题来源于中国大陆国内各种专业性考试，重点在于考察模型对客观知识的覆盖面，占比 32%；主观题来源于日常总结，主要考察用户对 LLM 常用功能的效果。

| 题型  | 分值 | 形式 | 内容 | 来源 |
|-------|-----|------|------|-----|
|知识问答|32  |选择题 |覆盖各领域知识题，考察模型预训练语料的丰富性、准确性 |国内专业性考试 |
|生活常识 |10  |选择题 |覆盖衣食住行的生活常识，考察模型是否经常犯低级错误 | 日常生活总结 |
|语言表达|5   |选择题 |考察模型的语言理解能力 | 国内通用考试 |
|逻辑推理 |5   |选择题 |考察模型的逻辑推理、分析能力    |国内通用考试 |
|文本问答 |40  |简单题 |考察模型完成各种用户指令的能力 | 常用若干能力 |
|机器翻译 |8   |翻译题 |考察模型的语言能力，翻译能力   |论文和新闻  |

#### 评分规则：
- 客观选择题每题一分
- 主观题每道5分，
    - 5分满分要求模型反馈答案正确，可使用，不需要或极少需要用户做人工调整和修改。
    - 4分，要求模型反馈答案基本正确，经过一些人工修改和挑战，结果可用。
    - 3分，模型表达内容大致方向正确，需要经过较多人工修复。
    - 2分，模型反馈答案一般，语言表达通顺，符合语言模型标准，逻辑有少量问题。
    - 1分，答非所问，语言表达大致通顺，逻辑有问题。
    - 0分，答非所问，语言不通。
- 翻译题每道4分，
    - 4分，要求翻译精准，特定词汇准确。
    - 3分，有个别字、词汇错误；
    - 2分，有一些句子不正确；
    - 1分，大面积错误；
    - 0分，无法阅读。

### 说明
#### 客观题
```
用户：请回答问题：xxxxxxxx，A，xxx；B，xxx；C，xxx；D，xxx
模型：答案选A，原因是xxxxxx。
```
- 覆盖数学、物理、化学、生物、计算机、通信、机械、电力、医学、法律、新闻、地理、历史、文学、经济、编程等方面常识性问题；难易程度不一，存在少量多选题；
- 若模型给出答案字母（A\B\C\D），但分析结果错误，仍然判定正确；
- 若模型未给出答案字母，但以文字形式给出正确结果，仍然判定正确；
- 个别选择题没有正确答案，或题干信息给的不完全，无从给出答案；此时要求模型能够正确辨别题目中的问题，不能给出任何选项答案。此做法考察模型的信息辨别能力，避免幻觉妄语 Hallucination 的能力。
- 客观题由于模型的输出以概率形式进行采样，具有不确定性。评测过程中，全程都仅做一次输出，不会反复测试以期模型输出正确结果为止。

#### 主观题
- 主要覆盖写文章、写代码、写脚本、讲故事、完成用户知识咨询、特定主观问题咨询、考察模型输出陷入死循环，传统 NLP 任务等能力。

### 加载数据集
```
>>> import jionlp as jio
>>> llm_test = jio.llm_test_dataset_loader(version=1.0)
>>> print(llm_test[15])
```

### 测试结果

- 以下测试模型结果均有 pdf 版本截图供验证参考，可关注 【JioNLP】 公众号下载查阅。
- 有一些模型需要提供邀请码才可测试，欢迎大家提供邀请码，或直接使用本测试题进行测试。

| 模型 | 公司/机构 | 评分 | 日期 | 渠道  |
|-----|--------|------|-------|-------|
| GPT4      | OpenAI | **86**  |2023-05-22 | 官网 |
|ChatGPT3.5 | OpenAI | **82**  |2023-04-30 | 官网 |
|文心一言 |百度    |**59**   |2023-04-30 |官网  |
|星火大模型 |讯飞  |**55**   |2023-05-01 |官网  |
|ChatGLM-6B|清华  |**45**   |2023-05-15 | 开源Git本地部署 |
|通义千问 |阿里巴巴|
|360     |智脑    |**68**   |2023-05-22 | 官网 |
|Anthropic | Claude-Instant | **66** |2023-05-31 | Poe网站 |
|昆仑万维 | 天工   |








